
/******************************************************
 *                                                    *
 * FPAC project.            FPAC PAD                  *
 *                                                    *
 * Parts of code from different sources of ax25-utils *
 *                                                    *
 * F6FBB 05-1997                                      *
 *                                                    *
 ******************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <syslog.h>
#include <ctype.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <arpa/inet.h>

/* Variables are not extern in main */
#define extern

#include "node.h"
#include "wp.h"
#include "io.h"
#include "axutils.h"
#include "axconfig.h"
#include "nrconfig.h"

int LogLevel = LOGLVL_ERROR;
long IdleTimeout = 900L;
char *NodeId = NULL;
cfg_t cfg;

static void alarm_handler(int sig)
{
	set_eolmode(User.fd, EOLMODE_TEXT);
	tputs("\n");
	node_msg("Timeout! Disconnecting...");
	logout("Timeout");
}

static void term_handler(int sig)
{
	set_eolmode(User.fd, EOLMODE_TEXT);
	tputs("\n");
	node_msg("System going down! Disconnecting...");
	logout("SIGTERM");
}

static void prompt(void)
{
	tprintf("%s (Commands = ?) : ", cfg.alt_callsign);
}

int main(int argc, char **argv)
{
	int yes;
	char NodeName[80];
	cmd_t *c;
	union {
		struct full_sockaddr_ax25 sax;
		struct full_sockaddr_rose      srose;
		struct sockaddr_in        sin;
	} saddr;
	int slen = sizeof(saddr);
	char *p;
	char *ptr;
	int paclen;
	int invalid_cmds = 0;
	FILE *fp;
	char line[256];

	signal(SIGALRM, alarm_handler);
	signal(SIGTERM, term_handler);

	signal(SIGPIPE, SIG_IGN);

	NodeId = NodeName;

	if (cfg_open(&cfg) != 0)
	{
		return(1);
	}

	if (ax25_config_load_ports() == 0) 
	{
		log(LOGLVL_ERROR, "No AX.25 port data configured");
		return 1;
	}

	fpac_nr_config_load_ports();
	
	/*
	rs_config_load_ports();
	*/

	/* Add commands and sysop commands */
	for (c = cfg.cmd ; c ; c = c->next)
		add_alias_cmd(&Nodecmds, c->name, c->cmd);

	for (c = cfg.syscmd ; c ; c = c->next)
		add_alias_cmd(&Syscmds, c->name, c->cmd);


	if (getpeername(STDOUT_FILENO, (struct sockaddr *)&saddr, &slen) == -1)
	{
		if (errno != ENOTSOCK)
		{
			log(LOGLVL_ERROR, "getpeername: %s", strerror(errno));
			return 1;
		}
		User.ul_type = AF_UNSPEC;
	} 
	else
		User.ul_type = saddr.sax.fsa_ax25.sax25_family;

	switch (User.ul_type) 
	{
	case AF_AX25:
		strcpy(User.call, ax2asc(&saddr.sax.fsa_ax25.sax25_call));
		if (getsockname(STDOUT_FILENO, (struct sockaddr *)&saddr.sax, &slen) == -1) {
			log(LOGLVL_ERROR, "getsockname: %s", strerror(errno));
			return 1;
		}
		strcpy(User.ul_name, ax25_config_get_port(&saddr.sax.fsa_digipeater[0]));
		paclen = ax25_config_get_paclen(User.ul_name);
		p = AX25_EOL;
		break;
	case AF_NETROM:
		strcpy(User.call, ax2asc(&saddr.sax.fsa_ax25.sax25_call));
		strcpy(User.ul_name, ax2asc(&saddr.sax.fsa_digipeater[0]));
		if (getsockname(STDOUT_FILENO, (struct sockaddr *)&saddr.sax, &slen) == -1) {
			log(LOGLVL_ERROR, "getsockname: %s", strerror(errno));
			return 1;
		}
		strcpy(User.ul_port, nr_config_get_port(&saddr.sax.fsa_ax25.sax25_call));
		paclen = nr_config_get_paclen(User.ul_port);
		p = NETROM_EOL;
		break;
	case AF_ROSE:
		/* Accept the connection */
		yes = 1;
		ioctl(STDOUT_FILENO, SIOCRSACCEPT, &yes);
		strcpy(User.call, ax2asc(&saddr.srose.srose_call));
		strcpy(User.ul_name, fpac2asc(&saddr.srose.srose_addr));
		/* paclen = rs_config_get_paclen(NULL); */
		paclen = 250;
		p = ROSE_EOL;
		break;
	case AF_INET:
		ptr = getenv("CALL_TCP");
		if (ptr)
		{
			strcpy(User.call, ptr);
			paclen = 250;
			p = AX25_EOL;
		}
		else
		{
			paclen = 1024;
			p = INET_EOL;
		}
		strcpy(User.ul_name, inet_ntoa(saddr.sin.sin_addr));
		break;
	case AF_UNSPEC:
		paclen = 1024;
		p = INET_EOL;
		break;
	default:
		log(LOGLVL_ERROR, "Unsupported address family %d", User.ul_type);
		return 1;
	}

	if (init_io(User.fd, paclen, p) == -1) 
	{
		write(User.fd, "Error initializing I/O.\r\n", 25);
		log(LOGLVL_ERROR, "Error initializing I/O");
		return 1;
	}
	if ((User.ul_type == AF_INET) && (p == INET_EOL))
	{
		set_telnetmode(User.fd, 1);
		tn_do_linemode(User.fd);
	}

	init_nodecmds();

	User.state = STATE_LOGIN;
	login_user();

	gethostname(HostName, sizeof(HostName));

	if (User.call[0] == 0) 
	{
		char str[80];

		tprintf("\nFPAC-Node v %s (%s)\n\ncallsign: ", VERSION, HostName);
		usflush(User.fd);
		alarm(300L);			/* 5 min timeout */
		if ((p = readline(User.fd)) == NULL)
			logout("User disconnected");
		alarm(0L);
		strncpy(User.call, p, 9);
		User.call[9] = 0;
		strlwr(User.call);

		sprintf(str, "CALL_TCP=%s", User.call);
		putenv(str);
	}

	sprintf(NodeId,"%s", cfg.alt_callsign);

	if ((p = strstr(User.call, "-0")) != NULL)
		*p = 0;
	if (wp_check_call(User.call) == -1) 
	{
		node_msg("Invalid callsign");
		log(LOGLVL_LOGIN, "Invalid callsign %s @ %s", User.call, User.ul_name);
		logout("Invalid callsign");
	}

	if ((fp = fopen (FPAC_HELLO_FILE, "r")) != NULL) 
	{
		while (fgets (line, 256, fp) != NULL)
			tputs (line);
		tputs ("\n");
		fclose (fp);
	}

	node_msg("%s v %s (F6FBB - %s) for LINUX (help = h)\n", "FPAC-Node", VERSION, __DATE__);

	for (;;)
	{
		char *ps;

		prompt();

		usflush(User.fd);
		User.state = STATE_IDLE;
		time(&User.cmdtime);
		update_user();
		alarm(IdleTimeout);
		if ((p = readline(User.fd)) == NULL) 
		{
			if (errno == EINTR)
				continue;
			logout("User disconnected");
		}
		alarm(IdleTimeout);
		time(&User.cmdtime);
		update_user();
		ps = strdup(p);
		if ((!is_sysop()) || (cmdparse(Syscmds, ps) == -1))
		{
			if (cmdparse(Nodecmds, p) == -1) 
			{
				if (++invalid_cmds < 3) 
				{
					node_msg("Unknown command. Type ? for a list");
				} 
				else 
				{
					node_msg("Too many invalid commands. Disconnecting..."); 
					logout("Too many invalid commands");
				}
			}
			else
				invalid_cmds = 0;
		} 
		else
			invalid_cmds = 0;

		free(ps);

		tputs("\n");
	}
	return(0);
}
