
#ifndef CLUSTER_H
#define CLUSTER_H

#include "command.h"
#include "csock.h"
#include "network.h"

extern struct cmd cluster_cmds[];

extern void prompt(struct csock_t *s);

extern void user_linkadd(struct link_t *l);
extern void user_linkdel(struct link_t *l, char *reason);
extern void user_nodeadd(struct node_t *n);
extern void user_nodedel(struct node_t *n, char *reason);
extern void user_useradd(struct nuser_t *u);
extern void user_userdel(struct nuser_t *u);
extern void user_userhere(struct nuser_t *u);
extern void user_useraway(struct nuser_t *u);
extern void user_dx(struct dx_t *dx);
extern void user_announce(struct ann_t *ann);
extern void user_wwv(struct wwv_t *wwv);

#endif

