
/*
 *
 *	Clusse
 *  Copyright Heikki Hannikainen, OH7LZB 1994-1998
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 *	main.c
 *
 *	the mother of all functions
 */
 
#include "version.h"
#include "ctime.h"
#include "cstring.h"
#include "log.h"
#include "config.h"
#include "timer.h"
#include "network.h"
#include "csock.h"
#include "cfile.h"

/*
 *	Main
 */

void main(void)
{
	ctime_init();		/* Time library init */
	cstring_init();		/* Strings library init */
	open_log();		/* Open logging */
	read_config();		/* Read configuration */
	timer_init();		/* Initialize timer */
	net_init();		/* Cluster networking init */
	files_init();		/* Open data files */
	csock_init();		/* Initialize socket code, bind and listen */
	log(L_INFO, "%s - ready to serve.", SOFT_STRING);
	select_loop();		/* Loop ad infinitum */
}

