
/*
 *	log.c
 *
 *	logging facility with configurable log levels and
 *	logging destinations
 */

#include <stdio.h>
#include <stdarg.h>
#include <syslog.h>
#include "log.h"

int log_level = L_DEFLEVEL;	/* Logging level */
int log_dest = L_DEFDEST;	/* Logging destination */

int open_log(void)
{
	openlog("clussed", LOG_NDELAY|LOG_PID, LOG_LOCAL6);
	return 0;
}

int log(int level, const char *fmt, ...)
{
	va_list args;
	char s[LOG_LEN];
	
	va_start(args, fmt);
	vsnprintf(s, LOG_LEN, fmt, args);
	va_end(args);
	
	if ((log_level & level)) {
		if ((log_dest & L_STDERR))
			fprintf(stderr, "%s\n", s);
		if ((log_dest & L_SYSLOG))
			syslog(LOG_ERR, "%s", s);
	}
	
	return 0;
}

