
#include "version.h"
#include "ctime.h"
#include "cstring.h"
#include "log.h"
#include "config.h"
#include "timer.h"
#include "network.h"
#include "csock.h"

/*
 *	Main
 */

void main(void)
{
	ctime_init();		/* Time library init */
	cstring_init();		/* Strings library init */
	open_log();		/* Open logging */
	read_config();		/* Read configuration */
	timer_init();		/* Initialize timer */
	net_init();		/* Cluster networking init */
	csock_init();		/* Initialize socket code, bind and listen */
	log(L_INFO, "%s - ready to serve.", SOFT_STRING);
	select_loop();		/* Loop ad infinitum */
}

