
#include <stdlib.h>

#include "config.h"
#include "csock.h"
#include "luser.h"
#include "cluster.h"
#include "command.h"
#include "log.h"
#include "hmalloc.h"
#include "net_user.h"

struct luser_t *lusers = NULL;

int luser_count;
int luser_max;

/*
 *	Allocate and initialize a local user structure
 */

struct luser_t *luser_alloc(struct csock_t *s)
{
	struct luser_t *lu = lusers, **plu = &lusers;
	
	while (lu) {
		plu = &lu->next;
		lu = lu->next;
	}
	
	lu = hmalloc(sizeof(struct luser_t));
	*plu = lu;
	
	lu->prevp = plu;
	lu->next = NULL;
	
	lu->sock = s;
	lu->f = NULL;
	lu->nu = NULL;
	lu->fl = NULL;
	
	lu->egid = 10;
	
	lu->m2 = M2_NONE;
	lu->m3 = M3_NONE;
	
	lu->str = NULL;
	lu->path[0] = '\0';
	lu->last_talk_from[0] = '\0';
	
	lu->illegal_cmds = 0;
	lu->su_tries = 0;
	lu->locked = 0;
	
	s->lu = lu;
	s->in_handler = luser_handler;
	s->disc_handler = luser_logout;
	
	luser_count++;
	if (luser_count > luser_max)
		luser_max = luser_count;
		
	return lu;
}

/*
 *	Free a local user structure
 */

void luser_free(struct luser_t *lu)
{
	*lu->prevp = lu->next;
	if (lu->next)
		lu->next->prevp = lu->prevp;
	
//	nuser_free(u->nu);
	hfree(lu->f);
	hfree(lu->fl);
	hfree(lu->str);
	lu->sock->lu = NULL;
	hfree(lu);
	luser_count--;
}

/*
 *	Find a local user
 */

struct luser_t *get_luser(call_t *call)
{
	struct luser_t *p = lusers;

	while ((p) && (strcmp(p->nu->call, (char *)call) != 0))
		p = p->next;
	return p;
}

/*
 *	Send a message to lusers who are interested in it
 */

int send_us(int mtype, int mflag, char *s)
{
	struct luser_t *p;
	int i = 0;
	
	for (p = lusers; (p); p = p->next) {
		if (((p->f->messages & mtype) == mtype)
		  && ((p->f->flags & F_TIMESTAMP) == mflag)) {
		  	i++;
			csputs(p->sock, s);
			if (((p->f->flags & F_BEEPS) == F_BEEPS) /* Licence */
			  && ((p->f->beeps & mtype) == mtype)) /* to kill? */
			  	csputc(p->sock, '\007');
			csputc(p->sock, '\n');
		}
	}
	
	return i;
}

/*
 *	Accept a user connection (or not)
 */

void luser_login(struct csock_t *s)
{
	struct luser_t *lu;
	
	lu = luser_alloc(s);
	
	log(L_LUSER, "%s@%s/%s logged in", s->call, s->node, s->port);
	
/*	OH7LZB Clusse v0.31 - DX Cluster node OH7RBA-1 - 54/6 users, 16/2 nodes */
	csprintf(s, "%s - DX Cluster node %s\n", SOFT_STRING, clucall);
	csprintf(s, "\nHeavily under construction. Don't touch anything. Warranty void.\n");
	
	lu->nu = nuser_login(NULL, (call_t *)s->call, localnode, 1);
	
	prompt(s);
}

/*
 *	A local user has disconnected
 */

void luser_logout(struct csock_t *s)
{
	log(L_LUSER, "%s@%s/%s logged out", s->call, s->node, s->port);
	net_deluser(NULL, s->lu->nu);
	luser_free(s->lu);
}

/*
 *	Handle input from a local user - this is where the commands come in
 */
 
int luser_handler(struct csock_t *s, void *data, int len)
{
	char *p = (char *)data;
	
	if (command(s, cluster_cmds, p) == -2)
		return -2;
		
	prompt(s);
	
	return 0;
}
