
/*
 *	Replacements for malloc, realloc and free, which never fail,
 *	and might keep statistics on memory allocation...
 */

#include <unistd.h>
#include <string.h>

#include "hmalloc.h"
#include "log.h"

int mem_panic = 0;

long int hmallocs;
long int hmallocs_b;
long int hfrees;
long int hfree_nulls;
long int hreallocs;
long int hstrdups;

void *hmalloc(size_t size)
{
	void *p;
	
	if (!(p = malloc(size))) {
		if (mem_panic)
			exit(1);	/* To prevent a deadlock */
		mem_panic = 1;
		log(L_CRIT, "hmalloc: Out of memory! Could not allocate %d bytes.", size);
		exit(1);
	}
	
	hmallocs++;
	hmallocs_b += size;
	return p;
}

void *hrealloc(void *ptr, size_t size)
{
	void *p;
	
	if (!(p = realloc(ptr, size))) {
		if (mem_panic)
			exit(1);
		mem_panic = 1;
		log(L_CRIT, "hrealloc: Out of memory! Could not reallocate %d bytes.", size);
		exit(1);
	}
	
	hreallocs++;
	return p;
}

void hfree(void *ptr)
{
	if (ptr)
		free(ptr);
	else
		hfree_nulls++;
	hfrees++;
}

char *hstrdup(const char *s)
{
	char *p;
	
	p = hmalloc(strlen(s)+1);
	strcpy(p, s);
	
	hstrdups++;
	return p;
}

