
#include "hmalloc.h"
#include "network.h"
#include "cfg_links.h"
#include "log.h"

struct link_t *thislink = NULL;

/*
 *	Verify that a Link keyword has been set before
 */

int require_link(struct link_t *link)
{
	if (!link) {
		log(L_CRIT, "You must specify a Link before setting any parameters for one.");
		return 1;
	}
	
	return 0;
}

/*
 *	Link
 */

int do_link(struct link_t **dest, int argc, char **argv)
{
	struct link_t *link;
	struct link_t *foo = *dest;
	
	if (argc < 2)
		return -1;
	
	link = hmalloc(sizeof(struct link_t));
	
	if (foo) {
		foo->next = link;
		link->prevp = &foo->next;
	} else {
		links = link;
		link->prevp = &links;
	}
	
	link->next = NULL;
	thislink = link;
	
	strcpy(link->name, hstrupr(argv[1]));
	strcpy(link->call, argv[1]);
	
	return 0;
}

/*
 *	DestCall
 */

int do_destcall(struct link_t **dest, int argc, char **argv)
{
	return 0;
}

/*
 *	MyCall
 */

int do_mycall(struct link_t **dest, int argc, char **argv)
{
	return 0;
}

/*
 *	Protocol
 */

int do_protocol(struct link_t **dest, int argc, char **argv)
{
	return 0;
}

/*
 *	Script
 */

int do_script(struct link_t **dest, int argc, char **argv)
{
	struct link_t *this = *dest;

	if (require_link(this) || (argc < 2))
		return -1;
	
	this->scripts = add_string(this->scripts, hstrdup(argv[1]));
	
	return 0;
}

