
Uses Dos, Crt, ConfFile;
Type
  CallRec    = String[10];
  LocStr     = String[6];
  CoordRec   = Record
               lat, long : Real;
               End;

Const
  Cr     = #$0D;
  Lf     = #$0A;
  CrLf   = Cr+Lf;
  Copyright               = 'Copyright 1994, 1995, 1996 Heikki Hannikainen';
  Author_Address          = 'hessu@pspt.fi - oh7lzb@gw.oh7rba.ampr.org - OH7LZB@OH7RBA.#KUO.FIN.EU';

Type

  OLUserFRec = Record { users.clu }
               Call,                    { Callsign }
               Reserved  : CallRec;     { Name }
               Locator   : String[6];   { WW locator }
               Personal  : String[40];  { Some personal description }
               Logins,                  { How many connects }
               Time,                    { Last logged in/out (packed datetime) }
               NewsTime  : LongInt;     { Unused. }
               Messages,                { Messages flags }
               Beeps,                   { Beeps flags }
               Flags,                   { General flags }
               Rights    : Word;        { Permission flags }
               CharSet,                 { Character conversion table }
               Prompt    : Byte;        { Prompt type }
               End;

  LUserFRec  = Record { users.clu }
               Call      : CallRec;     { Callsign }
               Personal  : String[40];  { Some personal description }

               Locator   : LocStr;      { Mainhead locator }
               Loc       : CoordRec;    { Coordinates }

               Group     : Byte;        { Privilege group }
               Messages,                { Messages flags }
               Beeps     : TMessages;   { Beeps flags }
               Flags     : TFlags;      { General flags }
               LoginAct  : TLoginItems; { What to do on login }

               CharSet,                 { Character conversion table }
               Prompt    : Byte;        { Prompt type }
               Pagelen   : Byte;        { Page length }
               Language  : Byte;        { Which language }

               Logins,                  { How many connects }
               Time      : LongInt;     { Last logged in/out (packed datetime) }
               End;

  ODxInfoRec = Record { dx.clu }
              Num      : LongInt;      { Index number }
              Time     : LongInt;      { Packed datetime }
              Call     : String[15];   { DX callsign }
              Freq     : Real;         { Frequency }
              FromCall,                { Who submitted the spot }
              FromPC   : CallRec;      { and on what node }
              FromRoute: Byte;         { What link port did it come from }
              Info     : String[80];   { Misc text }
              End;

  DxCallStr = String[15];

  DxInfoRec = Record { dx.clu }
              Num      : LongInt;      { Index number }
              Time     : LongInt;      { Packed datetime }
              Call     : DxCallStr;    { DX callsign }
              Freq     : LongInt;      { Frequency, 1 desimaali }
              Reserved : Word;
              FromCall,                { Who submitted the spot }
              FromPC   : CallRec;      { and on what node }
              FromRoute: Pointer;      { What link port did it come from }
              Info     : String[80];   { Misc text }
              End;

  OAnnRec   = Record { announce.clu }
              Num      : LongInt;      { Index number }
              Time     : LongInt;      { Packed datetime }
              FromCall,                { From callsign }
              FromPc,                  { From node }
              ToPC     : CallRec;      { Distributed to node (* = full) }
              FromRoute: Byte;         { What link port did it come from }
              Sysop,                   { Only to sysops }
              Wx       : Boolean;      { Is it a WX spot }
              Msg      : String;       { The message itself }
              End;

  AnnRec   = Record { announce.clu }
              Num      : LongInt;      { Index number }
              Time     : LongInt;      { Packed datetime }
              FromCall,                { From callsign }
              FromPc,                  { From node }
              ToPC     : CallRec;      { Distributed to node (* = full) }
              FromLink : Pointer;      { What link port did it come from }
              Sysop,                   { Only to sysops }
              Wx       : Boolean;      { Is it a WX spot }
              Msg      : String;       { The message itself }
              End;

  OWWVRec   = Record { wwv.clu }
              Num      : LongInt;      { Index number }
              Time     : LongInt;      { When we got it in }
              Hour     : Byte;         { Hour of the WWV message }
              SFI, A   : Word;
              K        : Byte;
              Forecast : String[80];
              FromCall,                { Who submitted this one }
              FromPc   : CallRec;      { ...on what node... }
              FromRoute: Byte;         { What link port did it come from }
              End;

  WWVRec    = Record { wwv.clu }
              Num       : LongInt;      { Index number }
              Time      : LongInt;      { When we got it in }
              Hour      : Byte;         { Hour of the WWV message }
              SFI, A    : Word;
              K         : Byte;
              Forecast  : String[80];
              FromCall,                 { Who submitted this one }
              FromPc    : CallRec;      { ...on what node... }
              FromLink  : Pointer;      { What link port did it come from }
              End;

Var

 UserF     : File of OLUserFRec;
 nUserF    : File of LUserFRec;
 u         : OLUserFRec;
 nu        : LUserFRec;

 DxF       : File of ODxInfoRec;
 nDxF      : File of DxInfoRec;
 dx        : ODxInfoRec;
 ndx       : DxInfoRec;

 annF      : File of OAnnRec;
 nannF     : File of AnnRec;
 ann       : OAnnRec;
 nann      : AnnRec;

 wwvF      : File of OWWVRec;
 nwwvF     : File of WWVRec;
 wwv       : OWWVRec;
 nwwv      : WWVRec;


 Ch        : Char;
 w         : Word;
 Pos       : LongInt;
 Len       : LongInt;

 { ***************************************************************** }

Function Int2Str(int:LongInt):string;
var s: string[11];
begin
  str(int,s);
  int2str := s;
end;

 { ***************************************************************** }

Function Spaces(Len:Byte):String;
Var
  s : String;
  l : Byte;
Begin
 s := '';
 For l := 0 to Len do s := s + ' ';
 Spaces := s;
End;

 { ********************************************************************** }

Function PadLeft(Len:Byte;Str:String):String;
Var L:Byte;
Begin
 If Length(Str) >= Len
   then PadLeft := Copy(Str,1,Len)
   else PadLeft := Str + Spaces(Len-Length(Str)-1);
End;

 { ********************************************************************** }

Function PadRight(Len:Byte;Str:String):String;
Var L:Byte;
Begin
 If Length(Str) >= Len
   then PadRight := Copy(Str,1,Len)
   else PadRight := Spaces(Len-Length(Str)-1) + Str;
End;

 { ***************************************************************** }

Function BackSpaces(Len:Byte):String;
Var
  b : Byte;
  s : String;
Begin

 s := '';
 For b := 1 to Len
  do s := s + Chr(8);
 BackSpaces := s;

End;

 { ***************************************************************** }

Procedure cMessages(uMessages: Word; var nMessages: TMessages);
Begin

       nMessages := Conf^.UDefaults.DMessages;

       If uMessages and 1 = 1
         then Include(nMessages, M_Dx)
         else Exclude(nMessages, M_Dx);

       If uMessages and 2 = 2
         then Include(nMessages, M_Ann)
         else Exclude(nMessages, M_Ann);

       If uMessages and 4 = 4
         then Include(nMessages, M_Wwv)
         else Exclude(nMessages, M_Wwv);

       If uMessages and 8 = 8
         then Include(nMessages, M_User)
         else Exclude(nMessages, M_User);

       If uMessages and 16 = 16
         then Include(nMessages, M_Node)
         else Exclude(nMessages, M_Node);

       If uMessages and 32 = 32
         then Include(nMessages, M_Wx)
         else Exclude(nMessages, M_Wx);

       If uMessages and 64 = 64
         then Include(nMessages, M_Talk)
         else Exclude(nMessages, M_Talk);

       If uMessages and 128 = 128
         then Include(nMessages, M_LocalUser)
         else Exclude(nMessages, M_LocalUser);

       If uMessages and 256 = 256
         then Include(nMessages, M_Link)
         else Exclude(nMessages, M_Link);

End;

 { ***************************************************************** }

Procedure ConvertUsers;
Begin

 Assign(UserF,'data\users.clu');
 Reset(UserF);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot find users.clu. Make sure you''re in the Clusse ROOT directory.');
       Halt(1);
       End;
 Assign(nUserF,'data\users.new');
 Rewrite(nUserF);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot create users.new.');
       Halt(1);
       End;

 Pos := 0;
 Write(' Converting users.clu => users.new:     0');

 While not eof(UserF)
  do Begin

     Read(UserF,u);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cannot read users.clu!');
            Halt(1);
            End;

     With nu do With conf^.udefaults do
       Begin
       Call := u.Call;
       Time := u.Time;

       Locator := '';
       Loc.Lat := 0;
       Loc.Long := 0;

       Personal := '';
       Logins := u.Logins;

       Group := DGroup;

       { Login actions }
       LoginAct := DLogin;

       If u.Flags and 4 = 4
         then Include(LoginAct, LO_LUser)
         else Exclude(LoginAct, LO_LUser);

       If u.Flags and 8 = 8
         then Include(LoginAct, LO_LDx)
         else Exclude(LoginAct, LO_LDx);

       If u.Flags and 16 = 16
         then Include(LoginAct, LO_LAnn)
         else Exclude(LoginAct, LO_LAnn);

       If u.Flags and 32 = 32
         then Include(LoginAct, LO_Fortune)
         else Exclude(LoginAct, LO_Fortune);

       If u.Flags and 64 = 64
         then Include(LoginAct, LO_LWWV)
         else Exclude(LoginAct, LO_LWWV);

       { Messages }
       cMessages(u.Messages, Messages);
       cMessages(u.Beeps, Beeps);

       { Flags }
       Flags := DFlags;

       If u.Flags and 2 = 2
         then Include(Flags, f_Beeps)
         else Exclude(Flags, f_Beeps);

       If u.Flags and 128 = 128
         then Include(Flags, f_Timestamp)
         else Exclude(Flags, f_Timestamp);

       CharSet := u.CharSet;
       Prompt := u.Prompt;

       Language := 0;
       Pagelen := 24;

       End;

     Write(nUserF,nu);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cannot write users.new!');
            Halt(1);
            End;

     Inc(Pos);
     Write(BackSpaces(4) + PadRight(4,Int2Str(Pos)));
     End;

 Close(UserF);
 Close(nUserF);
 WriteLn(', Done.');

 Write('Renaming users.clu => users.old... ');
 Rename(UserF,'data\users.old');
 If IOResult = 0
   then WriteLn('okay.')
   else Begin
        WriteLn('Argh, failed.');
        Halt(1);
        End;

 Write('Renaming users.new => users.clu... ');
 Rename(nUserF,'data\users.clu');
 If IOResult = 0
   then WriteLn('okay.')
   else Begin
        WriteLn('Argh, failed.');
        Halt(1);
        End;

End;

 { ***************************************************************** }

Procedure ConvertDx;
Begin

 Assign(DxF,'data\dx.clu');
 Reset(DxF);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot open dx.clu.');
       Halt(1);
       End;

 Assign(nDxF,'data\dx.new');
 Rewrite(nDxF);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot create dx.new.');
       Halt(1);
       End;

 Pos := 0;
 Write(' Converting dx.clu => dx.new:     0');

 While not eof(DxF)
  do Begin

     Read(DxF,dx);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cannot read dx.clu!');
            Halt(1);
            End;

     With ndx
      do Begin
         Num := dx.Num;
         Time := dx.Time;
         Call := dx.Call;
         Freq := Round(dx.Freq * 10);
         Reserved := 0;
         FromCall := dx.FromCall;
         FromPc := dx.FromCall;
         FromRoute := nil;
         Info := dx.Info;
         End;

     Write(nDxF,ndx);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cannot write dx.new!');
            Halt(1);
            End;

     Inc(Pos);
     Write(BackSpaces(4) + PadRight(4,Int2Str(Pos)));
     End;

 Close(DxF);
 Close(nDxF);
 WriteLn(', Done.');

 Write('Renaming dx.clu => dx.old... ');
 Rename(DxF,'data\dx.old');
 If IOResult = 0
   then WriteLn('okay.')
   else Begin
        WriteLn('Argh, failed.');
        Halt(1);
        End;

 Write('Renaming dx.new => dx.clu... ');
 Rename(nDxF,'data\dx.clu');
 If IOResult = 0
   then WriteLn('okay.')
   else Begin
        WriteLn('Argh, failed.');
        Halt(1);
        End;

End;

 { ***************************************************************** }

Procedure ConvertAnn;
Begin

 Assign(annF,'data\announce.clu');
 Reset(annF);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot open announce.clu.');
       Halt(1);
       End;

 Assign(nannF,'data\announce.new');
 Rewrite(nannF);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot create announce.new.');
       Halt(1);
       End;

 Pos := 0;
 Write(' Converting announce.clu => announce.new:     0');

 While not eof(annF)
  do Begin

     Read(annF,ann);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cannot read announce.clu!');
            Halt(1);
            End;

     With nann
      do Begin
         Num        := ann.Num;
         Time       := ann.Time;
         FromCall   := ann.FromCall;
         FromPc     := ann.FromPc;
         ToPc       := ann.ToPc;
         FromLink   := nil;
         Sysop      := ann.Sysop;
         Wx         := ann.Wx;
         Msg        := ann.Msg;
         End;

     Write(nannF,nann);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cannot write announce.new!');
            Halt(1);
            End;

     Inc(Pos);
     Write(BackSpaces(4) + PadRight(4,Int2Str(Pos)));
     End;

 Close(annF);
 Close(nannF);
 WriteLn(', Done.');

 Write('Renaming announce.clu => announce.old... ');
 Rename(annF,'data\announce.old');
 If IOResult = 0
   then WriteLn('okay.')
   else Begin
        WriteLn('Argh, failed.');
        Halt(1);
        End;

 Write('Renaming announce.new => announce.clu... ');
 Rename(nannF,'data\announce.clu');
 If IOResult = 0
   then WriteLn('okay.')
   else Begin
        WriteLn('Argh, failed.');
        Halt(1);
        End;

End;

 { ***************************************************************** }

Procedure ConvertWWV;
Begin

 Assign(wwvf,'data\wwv.clu');
 Reset(wwvf);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot open wwv.clu.');
       Halt(1);
       End;

 Assign(nwwvf,'data\wwv.new');
 Rewrite(nwwvf);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot create wwv.new.');
       Halt(1);
       End;

 Pos := 0;
 Write(' Converting wwv.clu => wwv.new:     0');

 While not eof(wwvf)
  do Begin

     Read(wwvf,wwv);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cwwbot read wwv.clu!');
            Halt(1);
            End;

     With nwwv
      do Begin
         Num        := wwv.Num;
         Time       := wwv.Time;
         Hour       := wwv.Hour;
         SFI        := wwv.SFI;
         A          := wwv.A;
         K          := wwv.K;
         Forecast   := wwv.Forecast;
         FromCall   := wwv.FromCall;
         FromPc     := wwv.FromPc;
         FromLink   := nil;
         End;

     Write(nwwvf,nwwv);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cannot write wwv.new!');
            Halt(1);
            End;

     Inc(Pos);
     Write(BackSpaces(4) + PadRight(4,Int2Str(Pos)));
     End;

 Close(wwvf);
 Close(nwwvf);
 WriteLn(', Done.');

 Write('Renaming wwv.clu => wwv.old... ');
 Rename(wwvf,'data\wwv.old');
 If IOResult = 0
   then WriteLn('okay.')
   else Begin
        WriteLn('Argh, failed.');
        Halt(1);
        End;

 Write('Renaming wwv.new => wwv.clu... ');
 Rename(nwwvf,'data\wwv.clu');
 If IOResult = 0
   then WriteLn('okay.')
   else Begin
        WriteLn('Argh, failed.');
        Halt(1);
        End;

End;

 { ***************************************************************** }

Procedure ConvertStatus;
Var
  f : File;
Begin

 Write('Erasing status.clu... ');
 Assign(f,'data\status.clu');
 Erase(f);
 If IOResult <> 0
   then WriteLn('Ouch! Could not erase! Do it manually...')
   else WriteLn('okay.');

End;

 { ***************************************************************** }

Begin

 HighVideo;
 WriteLn(CrLf + '   Clusse 0.30a-g to 0.31 update' + CrLf + CrLf + '  ' + Copyright + CrLf + '  ' + Author_Address + CrLf);
 NormVideo;
 WriteLn('   Execute this program ONLY ONCE and delete it afterwards to prevent yourself' + CrLf
       + ' from running it again by accident!' + CrLf);

 WriteLn('   This program must be run Clusse root directory. If you are not' + CrLf
       + ' updating from Clusse version 0.30a or older, there is no need to run this' + CrLf
       + ' program.' + CrLf);

 Write(' Are you sure you want to run this program now (Yes/NO)? ');
 Ch := ReadKey;
 WriteLn;

 If not (UpCase(Ch) = 'Y')
  then Begin
       WriteLn(' I thought so.');
       Halt(0);
       End;

 If (ReadConfig <> 0)
   then Begin
        WriteLn(CrLf + 'Could not read Clusse configuration. Run setup.exe first!' + CrLf
                     + 'Check especially the default settings for new users, since they will' + CrLf
                     + 'be applied for all your users (except for the settings which were' + CrLf
                     + 'present in the old version).');
        Halt(0);
        End;

 ConvertUsers;
 ConvertDx;
 ConvertAnn;
 ConvertWWV;
 ConvertStatus;


End.
