
Unit s_User;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile, SetForm;

Type

  { User parameters }

  PMessageEntry = ^TMessageEntry;
  TMessageEntry = object(TCheckBoxes)
    MsgMask      : PMessages;
    constructor Init(var Bounds: TRect; Mask: PMessages; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PFlagEntry = ^TFlagEntry;
  TFlagEntry = object(TCheckBoxes)
    FlagMask     : PFlags;
    constructor Init(var Bounds: TRect; Mask: PFlags; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PLoginEntry = ^TLoginEntry;
  TLoginEntry = object(TCheckBoxes)
    LoginMask    : PLoginItems;
    constructor Init(var Bounds: TRect; Mask: PLoginItems; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PUserSets = ^TUserSets;
  TUserSets = object(TDialog)
    Backup       : PConfig;
    Abandon      : Boolean;

    DGroup       : PByteEntry;
    DPrompt      : PByteEntry;

    DMessages,
    DBeeps       : PMessageEntry;

    DFlags       : PFlagEntry;
    DLogin       : PLoginEntry;

    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

Const
  RUserSets: TStreamRec = (
     ObjType: 10044;
     VmtLink: Ofs(TypeOf(TUserSets)^);
     Load:    @TUserSets.Load;
     Store:   @TUserSets.Store
  );

Procedure RegisterUserSetForm;

Implementation { ********************************************************* }

Uses
  MsgBox;

 { *** TMessageEntry *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TMessageEntry.Init(var Bounds: TRect; Mask : PMessages; AStrings: PSItem);
Var
 i : ^Word;
Begin

 inherited Init(Bounds, AStrings);

 MsgMask := Mask;
 i := @MsgMask^;

 SetData(i^);

End;

Destructor TMessageEntry.Done;
Var
 i : Word;
 m : PMessages;
Begin

 GetData(i);
 m := @i;
 MsgMask^ := m^;

 inherited Done;

End;

 { *** TFlagEntry *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TFlagEntry.Init(var Bounds: TRect; Mask : PFlags; AStrings: PSItem);
Var
 i : ^Byte;
Begin

 inherited Init(Bounds, AStrings);

 FlagMask := Mask;
 i := @FlagMask^;

 SetData(i^);

End;

Destructor TFlagEntry.Done;
Var
 i : Word;
 m : PFlags;
Begin

 GetData(i);
 m := @i;
 FlagMask^ := m^;

 inherited Done;

End;

 { *** TLoginEntry *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TLoginEntry.Init(var Bounds: TRect; Mask : PLoginItems;
                             AStrings: PSItem);
Var
 i : ^Word;
Begin

 inherited Init(Bounds, AStrings);

 LoginMask := Mask;
 i := @LoginMask^;

 SetData(i^);

End;

Destructor TLoginEntry.Done;
Var
 i : Word;
 m : PLoginItems;
Begin

 GetData(i);
 m := @i;
 LoginMask^ := m^;

 inherited Done;

End;

 { *** TUserSets *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TUserSets.Init;
Var
  R : TRect;
Const
  InfoXEnd   = 19;
  EntryXPos  = 21;
Begin

  R.Assign(0, 0, 66, 20);
  inherited Init(R,'Default settings for a new user');

  R.Assign(EntryXPos,2,EntryXPos + 4, 3);
  DGroup := New(PByteEntry, Init(R,@Conf^.UDefaults.DGroup,2,1,GroupsAvail));
  Insert(DGroup);

  R.Assign(2, 2, InfoXEnd, 3);
  Insert(New(PLabel, Init(R, 'Privilege ~g~roup:', DGroup)));

  R.Assign(EntryXPos,3,EntryXPos + 4,4);
  DPrompt := New(PByteEntry, Init(R,@Conf^.UDefaults.DPrompt,2,1,PromptsAvail));
  Insert(DPrompt);

  R.Assign(2, 3, InfoXEnd, 4);
  Insert(New(PLabel, Init(R, '~P~rompt:', DPrompt)));

  R.Assign(3, 6, 19, 15);
  DMessages := New(PMessageEntry, Init(R, @Conf^.UDefaults.DMessages,
    NewSItem('Dx', NewSItem('Announce', NewSItem('WWV', NewSItem('Weather',
    NewSItem('Talk', NewSItem('User', NewSItem('Local user', NewSItem('Node',
    NewSItem('Link', nil )))))))))));
  Insert(DMessages);

  R.Assign(2, 5, 13, 6);
  Insert(New(PLabel, Init(R, '~M~essages:', DMessages)));

  R.Assign(19, 6, 24, 15);
  DBeeps := New(PMessageEntry, Init(R, @Conf^.UDefaults.DBeeps,
    NewSItem('', NewSItem('', NewSItem('', NewSItem('',
    NewSItem('', NewSItem('', NewSItem('', NewSItem('',
    NewSItem('', nil )))))))))));
  Insert(DBeeps);

  R.Assign(15, 5, 22, 6);
  Insert(New(PLabel, Init(R, '~B~eeps:', DBeeps)));

  R.Assign(26, 6, 46, 11);
  DFlags := New(PFlagEntry, Init(R, @Conf^.UDefaults.DFlags,
    NewSItem('Beeps', NewSItem('Timestamps', NewSItem('Timer reset',
      NewSItem('PC compat.', NewSItem('Filter enabled', nil)))))));
  Insert(DFlags);

  R.Assign(25, 5, 35, 6);
  Insert(New(PLabel, Init(R, '~F~eatures:', DFlags)));

  R.Assign(48, 6, 62, 13);
  DLogin := New(PLoginEntry, Init(R, @Conf^.UDefaults.DLogin,
    NewSItem('Dx', NewSItem('Announce', NewSItem('WWV', NewSItem('Users',
    NewSItem('Nodes', NewSItem('Links', NewSItem('Fortune', nil )))))))));
  Insert(DLogin);

  R.Assign(47, 5, 63, 6);
  Insert(New(PLabel, Init(R, '~L~ists at login:', DLogin)));

  R.Assign(9, 17, 19, 19);
  Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

  SelectNext(False);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

End;

Destructor TUserSets.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

End;

Constructor TUserSets.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TUserSets.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TUserSets.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;


Procedure RegisterUserSetForm;
Begin
  RegisterType(RUserSets);
End;

End.
