{$F-} {$R+} {$Q+} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Filters;

  { Implements the DX spot filtering system. Not very clean, but i
    am proud of the implementation of this feature, and it's
    versatility. }

Interface
Uses Dos, ConfFile, Protocol;
Type
  sType   = Byte;

  ModeRec    = (MO_any, MO_cw, MO_ssb, MO_digital, MO_satellite);

  FlRecP  = ^FlRec;
  FlRec   = Record
            Pass         : Boolean;    { Pass or drop this one }
            Beeps        : Byte;       { Extra beeps, if passes }

            DxCall       : DxCallStr;  { Dx callsign }
            _DxCall      : Boolean;
            FromCall     : CallRec;    { From callsign }
            _FromCall    : Boolean;
            FromPc       : CallRec;    { From PC callsign }
            _FromPc      : Boolean;
            Band         : Byte;       { Band }
            _Band        : Boolean;
            Mode         : ModeRec;    { Mode }
            _Mode        : Boolean;
            InfoStr      : String[20]; { Info }
            _InfoStr     : Boolean;

            Next         : FlRecP;     { Pointer to the next record }
            End;

Var
  uDataPath     : PathStr;
  FiltersM      : Word;

Function OnBand(freq:LongInt):Boolean;        { Is the freq on a legal band }
Function OnABand(freq:LongInt;id:Byte):Boolean;
Function GetBand(Const str:String):Byte;

Procedure LoadFilters(p:sType);            { Load the dx filters for the user }
Procedure ClearFilters(p:sType);           { Dispose the dx filters }

Procedure Filter_Cmd(p:sType);             { View/modify dx filters }

Function Filter(p:sType;dx:DxInfoP):ShortInt; { Filter this one }

Procedure Bands_Cmd(p:sType);              { Show band table }

Procedure Init;                            { Initialize (load band table etc) }

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Implementation
Uses BPQ, Screen, cStrings, AutoBin, Files, Config;

Type
  BandRecP = ^BandRec;
  BandRec  = Record
             Legal : Boolean;
             Wname : String[5];
             Mname : String[5];
             lo,
             hi    : LongInt;
             Next  : BandRecP;
             End;

Const
  DefFl : FlRec = (Pass:True; Beeps:0; DxCall:'*'; _DxCall:True; FromCall:'*'; _FromCall:True;
                  FromPc:'*'; _FromPc:True;
                  Band:0; _Band:True; Mode:MO_Any; _Mode:True; InfoStr:'';
                  _InfoStr:True);

  Modes : Array[MO_Any..MO_satellite] of String[4]
        = ('Any ', 'CW  ', 'SSB ', 'Digi', 'Sat ');
  FlHeadStr : String = '     Type E Call           Band   Mode  From    Node       Info string' + Cr;

Var
  BandList : BandRecP;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function OnBand(freq:LongInt):Boolean;
Var
  bp : BandRecP;
  fr : Real;
Begin

  OnBand := True;
  fr := freq / 10;
  bp := BandList;
  While assigned(bp)
   do Begin
      If (fr >= bp^.lo) and (fr <= bp^.hi) and bp^.Legal
        then Exit;
      bp := bp^.Next;
      End;

  OnBand := False;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function OnABand(freq:LongInt;id:Byte):Boolean;
Var
 bp : BandRecP;
 b  : Byte;
 fr : Real;
Begin

  OnABand := True;
  If id = 0 then Exit;
  fr := freq / 10;

  b := 1;
  bp := BandList;
  While assigned(bp) and not (b = id)
   do Begin
      bp := bp^.Next;
      Inc(b);
      End;

  If (not assigned(bp)) or (fr < bp^.lo) or  (fr > bp^.hi)
    then OnABand := False;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function BandName(id:Byte):String;
Var
 bp : BandRecP;
 b  : Byte;
Begin

  If id = 0
    then Begin
         BandName := 'Any';
         Exit;
         End;

  b := 1;
  bp := BandList;
  While assigned(bp) and not (b = id)
   do Begin
      bp := bp^.Next;
      Inc(b);
      End;

  If assigned(bp)
    then BandName := bp^.Wname
    else BandName := 'None';

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function GetBand(Const str:String):Byte;
Var
  bp : BandRecP;
  b  : Byte;
Begin

  b := 1;
  bp := BandList;
  While assigned(bp) and not ((bp^.Wname = str) or (bp^.Mname = str))
    do Begin
       Inc(b);
       bp := bp^.Next;
       End;

  If assigned(bp)
    then GetBand := b
    else GetBand := 0;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure LoadFilters(p:sType);
Var
  fi : File;
  fp : FlRecP;
  lp : ^FlRecP;
Begin

 With LUser[p]^ do
  Begin
  Assign(fi,uDataPath + StripSSID(f^.Call) + '.fl');
  Reset(fi,1);
  lp := @fl;

  If IOResult = 0
    then Begin
         While not eof(fi)
          do Begin
             New(fp);
             Inc(FiltersM);
             lp^ := fp;
             BlockRead(fi, fp^, SizeOf(FlRec));
             lp := @fp^.Next;
             End;
         Close(fi);
         End;

  lp^ := nil;
  End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure WriteFilters(p:sType);
Var
  fi : File;
  i  : Integer;
  fp : FlRecP;
  d  : Boolean;
Begin

 With LUser[p]^ do
  Begin
  Assign(fi,uDataPath + StripSSID(f^.Call) + '.fl');
  If Assigned(fl)
    then Begin
         fp := fl;
         Rewrite(fi,1);
         While assigned(fp)
          do Begin
             BlockWrite(fi, fp^, SizeOf(FlRec));
             fp := fp^.Next;
             End;
         Close(fi);
         d := u_IOCheck(p,'Could not save your filter file');
         End
    else Begin
         Erase(fi);
         i := IOResult;
         End;
  End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure ClearFilters(p:sType);
Var
 fp, fn : FlRecP;
Begin

 With LUser[p]^
  do Begin
     fp := fl;
     While assigned(fp)
      do Begin
         fn := fp^.Next;
         Dispose(fp);
         Dec(FiltersM);
         fp := fn;
         End;
     fl := nil;
     End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure FlStr(p:sType; b:Byte; fp:FlRecP);
Var
 s : String[80];

 Function b2c(bo:Boolean):String;
 Begin
   If bo then b2c := ''
         else b2c := '!';
 End;

Begin

 With fp^
  do Begin
     s := PadRight(3,Int2Str(b)) + ': ';
     If Pass
       then s := s + 'Pass '
       else s := s + 'Drop ';
     s := s + PadLeft(2,Int2Str(Beeps))
            + PadLeft(15,b2c(_DxCall) + DxCall)
            + PadLeft(7,b2c(_Band)+ BandName(Band))
            + PadLeft(5,b2c(_mode) + Modes[mode])
            + ' ' + PadLeft(8,b2c(_FromCall) + FromCall)
            + PadLeft(11,b2c(_FromPc) + FromPc) +
            + b2c(_InfoStr) + InfoStr + Cr;
     Send(p,s);
     End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function AddFl(p:sType; var ind:Byte):FlRecP;
Var
 b  : Byte;
 fl : FlRecP;
 lp : ^FlRecP;
Begin

 fl := LUser[p]^.fl;
 lp := @LUser[p]^.fl;
 b := 1;
 While assigned(fl) and (b < ind)
  do Begin
     lp := @fl^.Next;
     fl := fl^.Next;
     Inc(b);
     End;

 ind := b;

 New(fl);
 Inc(FiltersM);
 fl^ := DefFl;
 fl^.Next := lp^;
 lp^ := fl;
 AddFl := fl;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure DelFl(p:sType; ind:Byte);
Var
 b  : Byte;
 fl : FlRecP;
 lp : ^FlRecP;
Begin

 fl := LUser[p]^.fl;
 lp := @LUser[p]^.fl;
 b := 1;
 While assigned(fl) and (b < ind)
  do Begin
     lp := @fl^.Next;
     fl := fl^.Next;
     Inc(b);
     End;

 If assigned(fl)
   then Begin
        lp^ := fl^.Next;
        Dispose(fl);
        Dec(FiltersM);
        Send(p,'Filter ' + Int2Str(b) + ' removed.' + Cr);
        End
   else Send(p,'Filter ' + Int2Str(ind) + ' doesn''t exist.' + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function GetFl(p:sType; ind:Byte):FlRecP;
Var
 b  : Byte;
 fl : FlRecP;
Begin

 fl := LUser[p]^.fl;
 b := 1;
 While assigned(fl) and (b < ind)
  do Begin
     fl := fl^.Next;
     Inc(b);
     End;

 GetFl := fl;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure EditFl(p:sType; fl:FlRecP; start:Byte);
Var
  pos    : Byte;
  s, par : String[20];
  b      : Byte;
  t      : Boolean;
Begin

 pos := Start;

 Repeat

   t   := True;
   s   := UpCaseStr(Parse(pos));
   par := UpCaseStr(Parse(pos + 1));

   If par = ''
     then par := '*';

   If par[1] = '!'
     then Begin
          Delete(par,1,1);
          t := False;
          End;

   If par = ''
     then par := '*';
   If par = 'ANY'
     then par := '*';

   If not (s = '') then
   Case s[1] of

    'B' : Begin
          fl^._Band := t;
          par := LowCaseStr(par);
          If par = '*'
            then fl^.Band := 0
            else Begin
                 b := GetBand(par);
                 If b = 0
                   then Send(p,'Band ' + par + ' not found.' + Cr)
                   else fl^.Band := b;
                 End;
          Inc(pos);
          End;

    'C' : Begin
          fl^._DxCall := t;
          fl^.DxCall := par;
          Inc(pos);
          End;

    'E' : Begin
          fl^.Pass := True;
          fl^.Beeps := Str2Byte(par);
          If fl^.Beeps > 9
            then fl^.Beeps := 9;
          Inc(pos);
          End;

    'F' : Begin
          fl^._FromCall := t;
          fl^.FromCall := par;
          Inc(pos);
          End;

    'I' : Begin
          fl^._InfoStr := t;
          If (par = '*')
            then fl^.InfoStr := ''
            else fl^.InfoStr := LowCaseStr(par);
          Inc(pos);
          End;

    'N' : Begin
          fl^._FromPc := t;
          fl^.FromPc := par;
          Inc(pos);
          End;

    'P' : fl^.Pass := True;
    'D' : fl^.Pass := False;
    '+' : fl^.Pass := True;
    '-' : fl^.Pass := False;
    '1' : fl^.Pass := True;
    '0' : fl^.Pass := False;

   else Send(p,'Unknown parameter ' + s + '.' + Cr);
   End;

   Inc(pos);

 until s = '';

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Filter_Cmd(p:sType);
Var
  s  : String;
  fp : FlRecP;
  b  : Byte;
Begin

 With LUser[p]^ do
  Begin
  s := LowCaseStr(Parse(2));
  If s = ''
    then Begin
         Send(p,'Your filters:' + Cr);
         fp := fl;
         If Assigned(fp)
           then Begin
                Send(p,FlHeadStr);
                b := 1;
                While assigned(fp)
                 do Begin
                    FlStr(p,b,fp);
                    fp := fp^.Next;
                    Inc(b);
                    End;
                End
           else Send(p,' No filters set.' + Cr);
         End
    else Begin
         b := Str2Byte(Parse(1));
         Case s[1] of

          'a'      : Begin
                     fp := AddFl(p,b);
                     EditFl(p,fp,3);
                     Send(p,'Filter added:' + Cr + FlHeadStr);
                     FlStr(p,b,fp);
                     End;

{
          'r'      : Begin
                     ClearFilters(p);
                     Send(p,'Filters reset.' + Cr);
                     End;
}
          'r'      : DelFl(p,b);

         else        Begin
                     fp := GetFl(p,b);
                     If assigned(fp)
                      then Begin
                           EditFl(p,fp,2);
                           Send(p,FlHeadStr);
                           FlStr(p,b,fp);
                           End
                      else Send(p,'Filter ' + Int2Str(b) + ' doesn''t exist. Use the Add command to create it first.' + Cr);
                     End;

         End;
         WriteFilters(p);
         End;
  End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function Filter(p:sType;dx:DxInfoP):ShortInt; { Filter this one }
Var
 fp : FlRecP;
Begin

 With LUser[p]^
   do Begin
      Filter := 0;
      If assigned(fl)
        then Begin
             fp := fl;
             While assigned(fp)
              do Begin
                 With fp^ do
                 If (OnABand(dx^.Freq,Band) = _Band)
                   and (WMatch(DxCall,dx^.Call) = _DxCall)
                   and (WMatch(FromCall,dx^.FromCall) = _FromCall)
                   and (WMatch(FromPc,dx^.FromPc) = _FromPc)
                   and ((Length(InfoStr) = 0) or ((Pos(InfoStr,LowCaseStr(dx^.Info)) <> 0) = _InfoStr))
                     then Begin
                          If fp^.Pass
                            then Filter := fp^.Beeps
                            else Filter := -1;
                          Exit;
                          End;
                 fp := fp^.Next;
                 End;
             End;
      End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Bands_Cmd(p:sType);              { Show band table }
Const
  BStr : Array [0..1] of String[3] = ('No', 'Yes');
Var
  bp : BandRecP;

  Function Bool2Str(boo:Boolean):String;
  Begin
  If boo
    then Bool2Str := 'Yes'
    else Bool2Str := 'No';
  End;

Begin

 Action(p,'Band list');
 bp := BandList;
 Send(p,'Band list:           Names' + Cr
      + '  Low end  High end  MHz Metric Legal' + Cr);

 While assigned(bp)
  do With bp^ do
     Begin
     Send(p, PadRight(9,Int2Str(lo)) + PadRight(10,Int2Str(Hi)) +
           + PadRight(5,UpCaseStr(Mname)) + PadRight(6,Wname) + '  ' + Bool2Str(Legal) + Cr);
     bp := bp^.Next;
     End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Init;
Var
  b  : Byte;
  bp : BandRecP;
  bl : ^BandRecP;
Begin

  Write(' o Reading bands.ini... ');
  b := 0;
  bl := @BandList;
  AssignConf(CluPath + 'bands.ini');
  ReadConfLine;
  While not (Length(ibuffer) = 0)
   do Begin
      IBuffer := IBuffer + Cr;
      Inc(b);
      New(bp);
      bl^ := bp;
      With bp^
       do Begin
          bl := @Next;
          Legal := (IBuffer[1] = '+');
          Wname := LowCaseStr(Parse(1));
          Mname := LowCaseStr(Parse(2));
          lo := Str2LInt(Parse(3));
          hi := Str2LInt(Parse(4));
          End;
      ReadConfLine;
      End;
  CloseConf;
  bl^ := nil;
  CWriteLn(Int2Str(b) + ' bands.');
  Inc(OtherStaticMem, b * SizeOf(BandRec));

  FiltersM := 0;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

End.
