{$I-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit AutoBIN;

  { Implements the "DOS" file manipulation commands and file transfer
    protocols like AUTOBIN and ASCII, as well as the DOS, RUN and
    PG commands (requiring a dos shell) }

Interface

Function u_IOCheck(p:Byte; Const s:String):Boolean;

Procedure Dir_Cmd(p:Byte);

Procedure Cd_Cmd(p:Byte);
Procedure MD_Cmd(p:Byte);
Procedure RD_Cmd(p:Byte);

Procedure Del_Cmd(p:Byte);
Procedure Copy_Cmd(p:Byte);
Procedure Move_Cmd(p:Byte);

Procedure BinPut_Cmd(p:Byte);
Procedure BinPut_Response(p:Byte);

Procedure BinGet_Cmd(p:Byte);
Procedure BinGet_Response(p:Byte);
Procedure BinGet_Timer(p:Byte);

Procedure Put_Cmd(p:Byte);
Procedure Put_Response(p:Byte);

Procedure Get_Cmd(p:Byte);
Procedure Get_Response(p:Byte);
Procedure Get_Timer(p:Byte);

Procedure Run_Cmd(p:Byte);
Procedure DOS_Cmd(p:Byte);

Procedure PG_Cmd(p:Byte);
Procedure PG_Response(Const p:Byte);

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Implementation
Uses Dos, CRC, Files, cStrings, BPQ, ConfFile, Cluster, Screen, Config,
     MultiTsk, Environ;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { The amount of free space on disk. In bytes. -1 if no disk found.        }

Function df(Const ch:Char):LongInt;
Begin

 df := DiskFree(Ord(LowCaseCh[ch])-96);
 If IOResult <> 0
   then df := -1;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { True if IOResult = 0, False if not. In case of an error, sends the user }
 { an error message.                                                       }

Function u_IOCheck(p:Byte; Const s:String):Boolean;
Var i : Integer;
Begin

 i := IOResult;
 If i = 0
   then u_IOCheck := True
   else Begin
        Send(p,s + ':' + Cr
             + '  ' + Errorname(i) + '.' + Cr);
        u_IOCheck := False;
        End;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Does the user have write permissions in path pa                         }

Function WritePerm(p:Byte; Const pa:PathStr):Boolean;
Begin

 If  ((Copy(pa,1,Length(UserPath)) = UserPath) and fPermissionQ(p,R_UserWrite)
      and not (UserPath[0] = pa[0]))
  or ((Copy(pa,1,Length(IncomingPath)) = IncomingPath) and fPermissionQ(p,R_InWrite)
      and not (IncomingPath[0] = pa[0]))
  or fPermissionQ(p,R_AllWrite)
    then WritePerm := True
    else WritePerm := False;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Cleans up ..\ (also removes the previous directory), .\ (by just        }
 { cutting it out) and trailing .'s                                        }

Procedure CleanPath(var d:PathStr);
Var b, w : Byte;
Begin
   While Pos('..\',d) <> 0
     do Begin
        b := Pos('..\',d);
        Delete(d,b,3);
        w := b-1;
        Repeat dec(w) until (d[w] = '\') or (w = 0);
        If w > 0
          then Delete(d,w+1,b-w-1);
        End;
   While Pos('.\',d) <> 0
     do Begin
        b := Pos('.\',d);
        Delete(d,b,2);
        End;
   While d[Length(d)] = '.'
     do Dec(d[0]);
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Exctracts the path to a fully-qualified one, if required. Then calls    }
 { CleanPath.                                                              }

Procedure ExplodePath(p:Byte; var pa:PathStr);
Begin

 If (Length(pa) > 1) and (pa[2] = ':')
   then Begin { Ok, a full path - do nothing}
        End
   else If (pa[1] = '\')
          then { Relational to the current drive, add drive }
               pa := LUser[p]^.Path[1] + ':' + pa
          else { Relational to the current directory }
               pa := LUser[p]^.Path + pa;

 CleanPath(pa);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Checks if this is a device                                              }

Function DeviceFile(Const s:PathStr):Boolean;
Const
  MaxDev  = 12;
  Devices : Array[1..MaxDev] of String[4]
          = ('nul', 'con', 'aux', 'prn', 'com1', 'com2', 'com3', 'com4',
             'lpt1', 'lpt2', 'lpt3', 'lpt4');
Var b : Byte;
Begin

  DeviceFile := False;
  For b := 1 to MaxDev
    do If s = Devices[b]
         then DeviceFile := True;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Check for wildcards                                                     }

Function CheckWC(Const s:PathStr):Boolean;
Begin

  If (Pos('?', s) > 0) or (Pos('*', s) > 0)
    then CheckWC := True
    else CheckWC := False;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { A line in a directory listing                                           }

Function DirStr(f:SearchRec):String;
Var s : String;
Begin

 If f.Attr and Directory = 0
   then s := PadLeft(12,LowCaseStr(f.Name)) + PadRight(9,Int2Str(f.Size))
   else s := PadLeft(12,f.Name) + '   <DIR> ';

 DirStr := s + '  ' + DateStr(f.Time) + '  ' + TimeStrP(f.Time) + Cr;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { DOS-like file commands                                                  }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Dir_Cmd(p:Byte);
Var
 DirInfo  : SearchRec;
 s        : PathStr;
 i, n     : LongInt;
Const
 FileMask = AnyFile xor Hidden xor Sysfile xor VolumeID;
Begin

 s := LowCaseStr(Parse(1));
 ExplodePath(p,s);
 If DirExists(s) and (s[Length(s)] <> '\')
   then s := s + '\';
 If s[Length(s)] = '\'
   then s := s + '*.*';
 If (Copy(s,1,Length(UserPath)) = UserPath)
   or fPermission(p,R_AllFiles)
     then Begin
          Action(p,'DIR ' + s);
          Send(p,'  Directory of ' + s + '  (');
          FindFirst(s[1] + ':\*.*', VolumeID, DirInfo); { get volume id }
          If DosError = 0
            then Send(p,DirInfo.Name + ')' + Cr)
            else Send(p,'no label)' + Cr);

          FindFirst(s, FileMask, DirInfo);

          i := 0;
          n := 0;
          While DosError = 0
            do Begin
               Send(p,DirStr(DirInfo));
               Inc(n);
               Inc(i, DirInfo.Size);
               FindNext(DirInfo);
               End;

          Send(p,'  ' + Bytes2StrL(i) + ' bytes in ' + Int2Str(n) + ' files. ' + Bytes2StrL(df(s[1])) + ' bytes free.' + Cr);
          End;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Cd_Cmd(p:Byte);
Var
 s    : String;
Begin

 s := LowCaseStr(Parse(1));
 If s <> ''
  then Begin
       If (s[2] = ':')
         then Begin { Ok, full path, don't touch it }
              End
         else If (s[1] = '\')
                then { Relational to the current drive, add drive }
                     s := LUser[p]^.Path[1] + ':' + s
                else { Relational to the current directory }
                     s := LUser[p]^.Path + s;
       If DirExists(s)
         then Begin
              If s[Length(s)] <> '\'
                then s := s + '\';
              CleanPath(s);
              If (Copy(s,1,Length(UserPath)) = UserPath)
                or fPermission(p,R_AllFiles)
                  then LUser[p]^.Path := s;
              End
         else Send(p,'No such directory.' + Cr);
       End;
 Send(p,LUser[p]^.Path + Cr);
 Action(p,'CD ' + LUser[p]^.Path);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure MD_Cmd(p:Byte);
Begin

 With LUser[p]^ do Begin
 Str := Path + LowCaseStr(Parse(1));
 CleanPath(Str);

 If WritePerm(p,Str)
   then Begin
        Action(p,'MD ' + Str);
        MkDir(Str);
        If u_IOCheck(p,'Cannot create directory')
          then Send(p,'Directory ' + Str + ' created.' + Cr);
        End
   else Send(p,'Permission denied.' + Cr);

 End; { With }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure RD_Cmd(p:Byte);
Begin

 With LUser[p]^ do Begin
 Str := Path + LowCaseStr(Parse(1));
 CleanPath(Str);

 If WritePerm(p,Str)
   then If Str = Path
          then Send(p,'Cannot remove current directory.' + Cr)
          else Begin
               Action(p,'RD ' + Str);
               RmDir(Str);
               If u_IOCheck(p,'Cannot remove directory')
                 then Send(p,'Directory ' + Str + ' removed.' + Cr);
               End
   else Send(p,'Permission denied.' + Cr);

 End; { With }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function Delf(p:Byte; Const fs : PathStr):Boolean;
Var
 fil : File;
Begin

 Delf := False;
 If WritePerm(p,fs)
   then Begin
        Assign(fil,fs);
        Erase(fil);
        If u_IOCheck(p,'Cannot delete')
          then Delf := True;
        End
   else Send(p,'Permission denied.' + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Del_Cmd(p:Byte);
Var
 i  : LongInt;
Begin

 With LUser[p]^ do Begin
 Str := LowCaseStr(Parse(1));
 ExplodePath(p,Str);
 i := df(Str[1]);
 If Delf(p,Str)
   then Begin
        Action(p,'DEL ' + Str);
        i := df(Str[1]) - i;
        Send(p,Str + ' deleted. ' + Bytes2StrL(i) + ' bytes freed.' + Cr);
        End;
 End; { With }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function PlainName(Const s:PathStr):PathStr;
Var
  n     : NameStr;
  e     : ExtStr;
  d     : PathStr;
Begin

  fSplit(s,d,n,e);
  PlainName := n + e;

End;

Function Copyf(p:Byte; Const src:PathStr; var dest : PathStr):Boolean;
Var
 DestF  : File;
 fName  : PathStr;
 b      : Byte;
 ok     : Boolean;
 i      : LongInt;
Begin

  If CheckWC(src)
    then Begin
         Send(p,'Sorry, wildcards aren''t handled yet.' + Cr);
         Copyf := False;
         Exit;
         End;

  ok := False;

  If (Copy(Src,1,Length(UserPath)) = UserPath)
    or fPermission(p,R_AllFiles)
      then Begin
           fName := PlainName(Src);

           ExplodePath(p,Dest);

           If not FileExists(Src)
             then Send(p,'Source file does not exist.' + Cr)
             else
           If DeviceFile(fName) or DeviceFile(PlainName(dest))
             then Send(p,'Devices as file names not allowed.' + Cr)
             else
           Begin

           If DirExists(Dest)
             then Begin
                  If Dest[Length(Dest)] <> '\'
                    then Dest := Dest + '\';
                  Dest := Dest + fName;
                  End;

           If (Src = Dest)
             then Send(p,'Cannot copy or move a file to itself.' + Cr)
             else

           If WritePerm(p,Dest)
             then Begin
                  Send(p,'Copying ' + Src + ' to ' + Dest + ':' + Cr);
                  Assign(BufFile,Src);
                  FBufInit(1);

                  If u_IOCheck(p,'Cannot open source')
                    then Begin
                         Assign(DestF,Dest);
                         Rewrite(DestF,1);
                         If u_IOCheck(p,'Cannot open destination')
                           then Begin
                                i := 0;
                                Repeat
                                  BlockRead(BufFile, FileBuf^, FBufSize, BufEnd);
                                  If u_IOCheck(p,'Cannot read')
                                    then Begin
                                         BlockWrite(DestF, FileBuf^, BufEnd, BufPos);
                                         Inc(i,BufEnd);
                                         if not u_IOCheck(p,'Cannot write')
                                           then BufEnd := 0;
                                         End;
                                until (BufEnd = 0) or (BufEnd <> BufPos);
                                Close(DestF);
                                FBufClose;
                                Send(p,Bytes2StrL(i) + ' bytes copied.' + Cr);
                                ok := True;
                                End;
                         End;
                  End
             else Begin
                  Send(p,'Permission denied.' + Cr);
                  ok := False;
                  End;
             End;
           End;

 CopyF := ok;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Copy_Cmd(p:Byte);
Var
 Src,
 Dest : PathStr;
 ok   : Boolean;
Begin

 Src := LowCaseStr(Parse(1));
 Dest := LowCaseStr(Parse(2));

 If (Src = '') or (Dest = '')
  then Send(p,'Two parameters required.' + Cr)
  else Begin
       ExplodePath(p,Src);
       ok := Copyf(p,Src,Dest);
       End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Move_Cmd(p:Byte);
Var
 Src,
 Dest  : PathStr;
Begin

 Src := LowCaseStr(Parse(1));
 Dest := LowCaseStr(Parse(2));

 If (Src = '') or (Dest = '')
  then Send(p,'Two parameters required.' + Cr)
  else Begin
       ExplodePath(p,Src);
       If Copyf(p,Src,Dest)
         then If Delf(p,Src)
                then Send(p,Src + ' deleted.' + Cr);
       End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { AUTOBIN                                                                 }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure BinPut_Cmd(p:Byte);
Var
 fil : File;
Begin

 With LUser[p]^ do Begin
 Str := LowCaseStr(Parse(1));
 ExplodePath(p,Str);
 Action(p,'BPUT ' + Str);

 If WritePerm(p,Str) then
 If FileExists(Str)
  then Send(p,'File exists, cannot overwrite.' + Cr)
  else Begin
       Assign(fil,Str);
       Rewrite(fil,1);
       Close(fil);
       If u_IOCheck(p,'Cannot open file')
        then Begin
             Send(p,'Ready to receive binary file ' + Str + '...' + Cr);
             M2 := 6;
             M3 := 0;
             M4 := 0;
             Sock[p]^.SockMode := raw;
             Prompted := False;
             Locked := True;

             Seed := CRC16Seed;

             End;
       End
   else Send(p,'You''re not allowed to write this file.' + Cr);
 End; { With }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

  Procedure B_Abort(p:Byte;Const errs:String);
  Begin
    Send(p,'#ABORT#' + Cr + errs + Cr);
    Sock[p]^.SockMode := ascii;
    Prompted := True;
    With LUser[p]^
     do Begin
        M2 := 0;
        Locked := False;
        Action(p,'File transfer aborted (' + Bytes2StrL(M4) + ' b transferred)');
        End;
  End;

  Procedure B_CheckCRC(p:Byte);
  Var s : String[6];
  Begin

  With LUser[p]^
   do Begin

      If (Copy(IBuffer,1,4) = 'BIN-') and (Copy(IBuffer,6,4) = 'X OK')
        then Begin
             s := Parse(2);
             Delete(s,1,1);
             If Str2Word(s) = Seed
               then Begin
                    Send(p,'File transferred succesfully.' + Cr);
                    Action(p,'File transferred, ' + Bytes2StrL(M4) + ' b');
                    End
               else Begin
                    Send(p,'CRC checksums do not match, transferred file is probably corrupted!' + Cr);
                    Action(p,'File transferred corrupted, ' + Bytes2StrL(M4) + ' b');
                    End;
             End
        else Begin
             Send(p,'File transferred, but the integrity of the file cannot be checked.' + Cr);
             Action(p,'File transferred, no CRC, ' + Bytes2StrL(M4) + ' b');
             End;

      M2 := 0;
      Locked := False;
      End;

  End;

Procedure BinPut_Response(p:Byte);
Type
  DataType = Array[1..255] of Byte;
Var
  fil           : File;
  Start,Stop    : Byte;
  Data          : ^DataType;
  err           : Integer;
  i             : LongInt;
  Finito        : Boolean;

Begin

 With LUser[p]^ do
 Case M3 of

  1 : Begin
      Prompted := False;
      Assign(fil,Str);
      Reset(fil,1);
      GetFTime(fil,i);
      Seek(fil,FileSize(fil));
      Data := @IBuffer[1];

      If (M4 + Length(IBuffer) >= MTimer)
        then Begin
             Stop := MTimer - M4;
             Sock[p]^.InBuf := Copy(IBuffer,Stop+1,255); { Keep the rest }
             Finito := True;
             End
        else Begin
             Stop := Length(IBuffer);
             Finito := False;
             End;

      BlockWrite(fil,Data^,Stop);
      SetFTime(fil,i);
      Close(fil);

      err := IOResult;
      Crc16l(@Data^, Stop, Seed);
      Inc(M4, Stop);

      If err <> 0
       then B_Abort(p,'Cannot write to file:' + Cr
                  + '  ' + ErrorName(err) + Cr)
       else If Finito
              then Begin
                   M3 := 2; { Odotetaan BIN-TX: }
                   Sock[p]^.SockMode := ascii;
                   Send(p,'BIN-RX OK #' + Int2Str(Seed) + Cr);
                   End
              else Prompted := False;
      End;

  0 : Begin { Siirron aloituskysely }
      { #BIN#size#date#filename }
      If Copy(IBuffer,1,5) = '#BIN#'
       then Begin
            Delete(IBuffer,1,1);
            Start := 0;
            While Start < Length(IBuffer)
             do Begin
                Inc(Start);
                If IBuffer[Start] = '#'
                  then iBuffer[Start] := ' ';
                End;

            MTimer := Str2LInt(Parse(1));
            If MTimer > 0
              then If (MTimer >= df(Str[1]))
                     then B_Abort(p,'Not enough free space on disk.')
                     else Begin
                          Action(p,'Starting binary upload, ' + Bytes2StrL(MTimer) + ' b');
                          Send(p,'#OK#' + Cr);
                          Inc(M3);
                          Prompted := False;
                          i := Str2LInt(Parse(2));
                          If i > 0 { Set date }
                            then Begin
                                 Assign(fil,Str);
                                 Reset(fil,1);
                                 SetFTime(fil,i);
                                 Close(fil);
                                 err := IOResult;
                                 End;
                          End
              else B_Abort(p,'Invalid header.');
            End
       else B_Abort(p,'Handshaking failed.');
      End;

  2 : B_CheckCRC(p);

 End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure BinGet_Cmd(p:sType);
Var
 fil : File;
 i   : LongInt;
Begin

 With LUser[p]^ do Begin
 Str := LowCaseStr(Parse(1));
 ExplodePath(p,Str);
 Action(p,'BGET ' + Str);

 If (Copy(Str,1,Length(UserPath)) = UserPath)
   or fPermission(p,R_AllFiles)
    then If FileExists(Str)
           then Begin
                Assign(fil,Str);
                Reset(fil,1);
                If u_IOCheck(p,'Cannot open file')
                  then Begin
                       GetFTime(fil,i);
                       Send(p,'Sending binary file ' + Str + '...' + Cr
                            + '#BIN#' + Int2Str(FileSize(fil)) + '#$' + HexL2Str(i)
                              + '#' + UpCaseStr(PlainName(Str)) + Cr);
                       Close(fil);
                       M2 := 10;
                       M3 := 0;
                       M4 := 0;
                       Sock[p]^.SockMode := raw;
                       Prompted := False;
                       Locked := True;

                       Seed := CRC16Seed;
                       End;
                End
           else Send(p,'File not found.' + Cr)
   else Send(p,'You''re not allowed to read this file.' + Cr);
 End; { With }

End;

Procedure BinGet_Response(p:sType);
Begin

 With LUser[p]^
  do Begin

     Case M3 of

       0 : Begin
           If Copy(IBuffer,1,4) = '#OK#'
             then Begin
                  M3 := 1;
                  Seed := crc16seed;
                  Prompted := False;
                  BinGet_Timer(p);
                  End
             else B_Abort(p,'Handshaking failed.');
           End;

       1 : { Siirto meneilln }
           B_Abort(p,'Aborted by user.');

       2 : B_CheckCRC(p); { BIN-RX: odotellessa }

     End;

     End;

End;

Procedure BinGet_Timer(p:sType);
Type
  DataType = Array[1..255] of Byte;
Var
  fil  : File;
  data : ^DataType;
  i    : Word;
  s    : String;
Begin

 With LUser[p]^ do Begin

 While (m3 = 1) and (User_Frames(p) < 3)
   do   Begin
        Assign(fil,Str);
        Reset(fil,1);
        Seek(fil,m4);
        data := @s[1];
        BlockRead(fil,Data^,Sock[p]^.Paclen,i);
        If i > 0
          then Begin
               If m4 = 0
                 then Begin
                      MTimer := FileSize(fil);
                      Action(p,'Starting binary download, ' + Bytes2StrL(MTimer) + ' b');
                      End;
               s[0] := Chr(i);
               Send(p,s);
               Inc(m4,i);
               Crc16l(@Data^, i, Seed);
               End
          else Begin { EOF! }
               Send(p,'BIN-TX OK #' + Int2Str(Seed) + Cr);
               M3 := 2;
               Sock[p]^.SockMode := ascii;
               End;
        Close(fil);
        End;
 End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { ASCII Put/Get                                                           }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Put_Cmd(p:Byte);
Var
 fil : File;
Begin

 With LUser[p]^ do Begin
 Str := LowCaseStr(Parse(1));
 ExplodePath(p,Str);
 Action(p,'PUT ' + Str);

 If WritePerm(p,Str) then
 If FileExists(Str)
  then Send(p,'File exists, cannot overwrite.' + Cr)
  else Begin
       Assign(fil,Str);
       Rewrite(fil,1);
       Close(fil);
       If u_IOCheck(p,'Cannot open file')
        then Begin
             Send(p,'Ready to receive ASCII file ' + Str + '.' + Cr
                 + 'Type /ex or <CTRL-Z> in the beginning of a line to exit.' + Cr);
             M2 := 11;
             M4 := 0;
             Prompted := False;
             Locked := True;
             End;
       End
   else Send(p,'You''re not allowed to write this file.' + Cr);
 End; { With }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Put_Response(p:Byte);
Var
  fil           : Text;
  Start,Stop    : Byte;
  err           : Integer;
  Finito        : Boolean;

Begin

 With LUser[p]^
   do Begin
      Prompted := False;

      If AbortStr
       then Begin
            Send(p,'File transfer finished. ' + Bytes2StrL(M4) + ' bytes transferred.' + Cr);
            Action(p,'File transfer finished (' + Bytes2StrL(M4) + ' b transferred)');
            Prompted := True;
            Locked := False;
            M2 := 0;
            Exit;
            End;

      If (pos(Cr, IBuffer) > 0)
       then Insert(Lf, IBuffer, Pos(Cr, IBuffer)+1);

      Assign(fil,Str);
      Append(fil);
      Write(fil,IBuffer);
      Close(fil);
      err := IOResult;

      If err <> 0
       then Begin
            Send(p,'File transfer aborted! Cannot write to file:' + Cr
                  + '  ' + ErrorName(err) + Cr);
            Action(p,'File transfer aborted (' + Bytes2StrL(M4) + ' b transferred)');
            Prompted := True;
            Locked := False;
            M2 := 0;
            Exit;
            End;

      Inc(M4, Length(IBuffer));
      End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Get_Cmd(p:sType);
Var
 fil : File;
Begin

 With LUser[p]^ do Begin
 Str := LowCaseStr(Parse(1));
 ExplodePath(p,Str);
 Action(p,'GET ' + Str);

 If (Copy(Str,1,Length(UserPath)) = UserPath)
   or fPermission(p,R_AllFiles)
    then If FileExists(Str)
           then Begin
                Assign(fil,Str);
                Reset(fil,1);
                If u_IOCheck(p,'Cannot open file')
                  then Begin
                       Close(fil);
                       M2 := 12;
                       M4 := 0;
                       Prompted := False;
                       Locked := True;
                       End
                End
           else Send(p,'File not found.' + Cr)
   else Send(p,'You''re not allowed to read this file.' + Cr);
 End; { With }

End;

Procedure Get_Response(p:sType);
Begin

 With LUser[p]^
  do Begin
     Prompted := False;
     M2 := 0;
     Locked := False;
     Send(p, 'Transfer aborted.' + Cr + Prompt(p));
     End;

End;

Procedure Get_Timer(p:sType);
Type
  DataType = Array[1..255] of Byte;
Var
  fil  : File;
  data : ^DataType;
  i    : Word;
  s    : String;
Begin

 With LUser[p]^ do Begin

 While (M2 = 12) and (User_Frames(p) < 3)
   do   Begin
        Data := @s[1];
        Assign(fil,Str);
        Reset(fil,1);
        Seek(fil,m4);
        BlockRead(fil,Data^,Sock[p]^.Paclen,i);
        Inc(m4, i);
        Close(fil);
        s[0] := Chr(i);
        While (pos(Lf, s) > 0)
          do Delete(s, Pos(Lf, s), 1);
        Send(p,s);
        Prompted := False;

        If i < Sock[p]^.PacLen
          then Begin
               Action(p,'File transfer finished (' + Bytes2StrL(M4) + ' b transferred)');
               M2 := 0;
               Locked := False;
               Prompted := True;
               Send(p, Prompt(p));
               End;
        End;
 End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Executing DOS applications                                              }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

 { Support procedures for ExecWithRedir                                    }

Function ExtractFileName(Var Line : String;Index : Integer) : String;
Var
  Temp : String;
Begin
  Delete(Line,Index,1);
  While (Index <= Length(Line)) AND (Line[Index] = ' ')
    Do Delete(Line,Index,1);
  Temp := '';
  While (Index <= Length(Line)) AND (Line[Index] <> ' ') Do
  Begin
    Temp := Temp + Line[Index];
    Delete(Line,Index,1);
  End;
  ExtractFileName := Temp;
End;

Procedure CloseHandle(Handle : Word);
Var
  Regs : Registers;
Begin
  With Regs Do
  Begin
    AH := $3E;
    BX := Handle;
    MsDos(Regs);
  End;
End;

Procedure Duplicate(SourceHandle : Word;Var TargetHandle : Word);
Var
  Regs : Registers;
Begin
  With Regs Do
  Begin
    AH := $45;
    BX := SourceHandle;
    MsDos(Regs);
    TargetHandle := AX;
  End;
End;

Procedure ForceDuplicate(SourceHandle : Word;Var TargetHandle : Word);
Var
  Regs : Registers;
Begin
  With Regs Do
  Begin
    AH := $46;
    BX := SourceHandle;
    CX := TargetHandle;
    MsDos(Regs);
    TargetHandle := AX;
  End;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Swaps screen, Swaps Clusse, runs the executable in Path with command    }
 { line CmdLine. If CmdLine includes redirection using > and <, they are   }
 { parsed, removed and acted upon.                                         }

Function ExecWithRedir(Const Path:String; CmdLine : String):Byte;
Var
  Index   : Integer;
  FName   : String[80];
  InFile  : Text;
  OutFile : Text;

  StdIn     : Word;
  Stdout    : Word;

  InHandle  : Word;
  OutHandle : Word;

  Inp, outp : Boolean;

Begin

  StdIn := 0;
  StdOut := 1;                    { change to 2 for StdErr       }

  Index := Pos('>',CmdLine);
  If Index > 0                    { check for output redirection }
    then Begin
         Duplicate(StdOut,OutHandle);              { duplicate standard output    }
         FName := ExtractFileName(CmdLine,Index);  { get output file name }
         Assign(OutFile,FName);                    { open a text file      }
         Rewrite(OutFile);                         { .. for output         }
         ForceDuplicate(TextRec(OutFile).Handle,StdOut);{ make output same }
         outp := True;
         End
    else outp := False;

  Index := Pos('<',CmdLine);      { check for input redirection }
  If Index > 0
    then Begin
         Duplicate(StdIn,InHandle);                { duplicate standard input     }
         FName := ExtractFileName(CmdLine,Index);  { get input file name }
         Assign(InFile,FName);                     { open a text file    }
         Reset(InFile);                            { for input           }
         ForceDuplicate(TextRec(InFile).Handle,StdIn);  { make input same }
         inp := True;
         End
    else inp := False;

  ExecWithRedir := ExecSwapped(Path, CmdLine);

  If inp
    then Begin
         ForceDuplicate(InHandle,StdIn);   { put standard input back to keyboard }
         CloseHandle(InHandle);            { close the redirected input file     }
         Close(InFile);
         End;

  If outp
    then Begin
         ForceDuplicate(OutHandle,StdOut); { put standard output back to screen  }
         CloseHandle(OutHandle);           { close the redirected output file    }
         Close(OutFile);
         End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function ExecFound(Const p:sType; Var s:String):Boolean;
Var
  dir    : PathStr;
  name   : NameStr;
  ext    : ExtStr;
Begin

  ExecFound := True;

  If FileExists(s)
    then Begin
         fSplit(s,dir,name,ext);
         If not ((ext = '.com') or (ext = '.exe'))
           then Begin
                If (ext = '.bat')
                  then Send(p,'Cannot run batch files.' + Cr)
                  else Send(p,s + ' is not an executable file.' + Cr);
                ExecFound := False;
                End;
         End
    else If FileExists(s + '.com')
           then s := s + '.com'
           else If FileExists(s + '.exe')
                 then s := s + '.exe'
                 else Begin
                      Send(p,'File not found.' + Cr);
                      ExecFound := False;
                      End;


End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function UserExec(Const p:Byte; Const prog, par:String):Boolean;
Var
  s : String;
  b : Byte;
  t : String;
Begin

  t := TempPath + 'exec.tmp';
  If FileExists(t)
    then DelFile(t);
  b := ExecWithRedir(prog,par + ' > ' + t);

  Case b of
    1 : s := 'Could not swap.' + Cr;
    2 : s := 'File not found.' + Cr;
    3 : s := 'Path not found.' + Cr;
    8 : s := 'Insufficient memory.' + Cr;
    9 : s := 'Swapping failed.' + Cr;
  else Begin
       If SendFile(p,t)
         then s := ''
         else s := 'Redirected command output not found.' + Cr;
       End;
  End;

  If b = 0
    then UserExec := True
    else UserExec := False;

  Send(p,s);

  If FileExists(t)
    then DelFile(t);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { The RUN command: runs *executable* files, if the user has the required  }
 { privileges in the directory.                                            }

Procedure Run_Cmd(p:Byte);
Var
  s, par : String;
  b, w   : Byte;
  dir    : PathStr;
Begin

 s := LowCaseStr(Parse(1));
 ExplodePath(p, s);
 Dec(IBuffer[0]);

 If  ((Copy(s,1,Length(UserPath)) = UserPath) and fPermissionQ(p,R_UserExec)
      and not (Copy(s,1,Length(IncomingPath)) = IncomingPath) or (UserPath[0] = s[0]))
    or fPermission(p,R_AllExec)
  then Begin

       If ExecFound(p,s) then
       Begin
       GetDir(0,dir);
       Dec(LUser[p]^.Path[0]); { Strip "\" from the end for DOS }
       ChDir(LUser[p]^.Path);
       Inc(LUser[p]^.Path[0]);
       b := FindParamStart(2);
       If b <> 0
         then par := Copy(IBuffer, b, Length(IBuffer) - b  + 1)
         else par := '';
       Action(p,'RUN ' + s + ' ' + par);
       UserExec(p,s,par);
       ChDir(dir);
       End;
       End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { The DOS command: runs the DOS command interpreter (found from the       }
 { environment variable COMSPEC) with the specified command.               }

Procedure DOS_Cmd(p:Byte);
Var
  s, par : String;
  b, w   : Byte;
  dir    : PathStr;
Begin

 Dec(IBuffer[0]);

 If fPermission(p,R_DosExec)
  then Begin
       If not FileExists(Comspec)
         then Begin
              Send(p,'Command interpreter not found. Set COMSPEC.' + Cr);
              Exit;
              End;

       GetDir(0,dir);
       Dec(LUser[p]^.Path[0]); { Strip "\" from the end for DOS }
       ChDir(LUser[p]^.Path);
       Inc(LUser[p]^.Path[0]);
       b := FindParamStart(1);
       If b = 0
         then Send(p,'No command specified.' + Cr)
         else Begin
              par := Copy(IBuffer, b, Length(IBuffer) - b  + 1);
              Action(p,'DOS ' + par);
              UserExec(p,Comspec,'/c ' + par);
              End;
       ChDir(dir);
       End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure PG_Response(Const p:sType);
Var
  b    : Byte;
  par  : String;
  fin  : Boolean;
  fil  : String;
Begin

 With LUser[p]^
  do Begin
     If ExecFound(p,Str)
       then Begin
            fil := UpCaseStr(TempPath) + 'PG' + Int2Str(p) + '.TMP';
            SetEnvStr('PGTEMP', fil); { Temporary file }

            If M3 > 0
              then Begin
                   par := ibuffer;
                   Dec(par[0]);
                   End
              else Begin
                   par := '';
                   If FileExists(fil)
                     then DelFile(fil);
                   End;

            Action(p,'PG ' + str + ' ' + par);

            b := 2; { Permissions }
            If PermissionQ(p,R_SUcmd)
              then Inc(b,8);

            fin := False;

            par := f^.Call + ' ' + Int2Str(m3) + ' ' + Int2Str(b) + ' 0 ' + par;
            If not UserExec(p,str,par)
              then fin := True;

            Inc(m3);
            Prompted := False;

            Case lo(DosExitCode) of

             1 : Begin { Continue }
                 End;

             2 : Begin { Disconnect }
                 ThrowOut(p);
                 fin := True;
                 End;

             3, 4
               : Begin { Handle as BBS command }
                 If lo(DosExitCode) = 3
                   then Begin { Return to BBS }
                        Prompted := True;
                        fin := True;
                        End;
                 CluCommand(p);
                 End;

             5 : Dec(m3);

            else Begin
                 Prompted := True;
                 fin := True;
                 End;

            If fin
              then Begin
                   m2 := 0;
                   If FileExists(fil)
                     then DelFile(fil);
                   End;
            End;

            End
       else m2 := 0;

     End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure PG_Cmd(p:sType);
Begin

 With LUser[p]^
  do Begin
     Str := LowCaseStr(Parse(1));
     Action(p,'PG ' + Str);
     If Length(Str) = 0
       then Begin
            If not SendFile(p,PgPath + 'pg.txt')
              then Send(p,'No PG program description file (pg.txt) found.' + Cr);
            End
       else Begin
            Str := PGPath + Str;

            m2 := 9;
            m3 := 0;

            PG_Response(p);
            End;
     End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

End.
