
/*
 * MBUSER.H - 4/10/92 -  Definitions for user file.
 */

#define us_version 8

extern char  *usfile, *usbfile;
extern int    ufl;
extern char tcall[ln_call];  /* Used all over as temp */
extern char syscall[ln_call];  /* Used as sysop call */

#define num_um 9
extern char *um[num_um];

/*
 *  User file header record.
 */

#define ufhsunu 234

typedef struct user_hdr_s
{
  char version;       /* File version                    */
  word count;         /* Number of users in file         */
  word lmnr;          /* Last message # at last compress */
  char dirty;         /* True if anything changed        */
  char date[ln_date]; /* Date of last compress           */
  char time[ln_time]; /* Time of last compress           */
  char wpdate[ln_date];/* Date last WP Update generated  */
  char unu[ufhsunu];   /* Ain't used at all, yet          */
} USER_HDR;

/*
 *  User file user record.
 */

/*
 *  User record options.
 */

#define u_local    0x01
#define u_bbs      0x02
#define u_expert   0x04
#define u_delete   0x08
#define u_sysop    0x10
#define u_exclude  0x20
#define u_hold     0x40

/*
 *  User record state.
 */

#define u_sent     0x01
#define u_name     0x02
#define u_home     0x04
#define u_zip      0x08
#define u_qth      0x10
#define u_pause    0x20

#define pathl 81
#define userunu 105

typedef struct user_s
{
  char call[ln_call];     /* Users call                          */
  char home_bbs[ln_call]; /* Users home bbs                      */
  char date[ln_date];     /* Date of last logout                 */
  char time[ln_time];     /* Time of last logout                 */
  char handle[ln_handle]; /* Users name                          */
  char port;              /* Port user last connected, L if link */
  char path[pathl];       /* NULL terminated string              */
  byte ssid;              /* ssid, binary                        */
  byte state;             /* Got name? Got home? Sent to WP?     */
  word msg_number;        /* Last message # at last login        */
  byte options;           /* Permissions and stuff like that     */
  word log_count;         /* Number of times user has connected  */
  word rn;                /* Record number, zero if not valid    */
  char zip[ln_zip];       /* User zip code                       */
  char qth[ln_qth];       /* User Qth                            */
  char unu[userunu];
} USER;

extern USER_HDR *ufhs;
extern USER     *tuser;

