
/*
 *  MBTERM.C - 10/19/87 - Terminal emulators and things.
 */

#include "mb.h"

char *talkm1, *talkm2, *talkm3, *talkm4;

/*
 *  User wants to talk to the console.
 */

utalk()
{
  register PORTS *p;
  register short i;

  p = port;
  prtx(talkm2);

  ioport(cport);
  prtx(talkm4);

  for (i = 0; i < 10; i++)
  {
    wait(2);
    if (s_param & s_page) outchar(ctl_g);
    wait(1);
    if (s_param & s_page) outchar(ctl_g);

    if (instat())
    {
      cport->fl = NULL;
      if (p->tmode)
      {
        ioport(p);
        cmdtnc(); convtnc();
      }
      term(p);
      ioport(p);
      if (p->tmode)
      {
        cmdtnc();
        trantnc();
      }
      return;
    }

    ioport(p);
    if (instat()) return;
    ioport(cport);
  }
  ioport(p); port->msg = talkm3;
}

/*
 *  Console used as terminal to tnc.
 */

lterm()
{
  register PORTS *m, *s;

  m = cport;

  if (m->flds is 2)
  if ((m->fl = fopen(m->fld[1], "r")) isnt NULL)
  { fclose(m->fl); m->msg = mexst; return; }

  if ((s = findport(m->opt2)) is NULL) { m->msg = mnport; return; }
  if (s is m)                          { m->msg = mcant;  return; }

  if (!(s->flags & p_term))
  {
    if (!(s->mode & idle)) { m->msg = minuse; return; }
    ioport(s);

    switch(s->dev)
    {
      case p_serial:
        prtx("*** CONNECTED to $O\n");
        break;

      default: ;
    }

    s->flags setbit p_term;
  }

  m->fl = NULL;
  if (m->flds is 2) m->fl = fopen(m->fld[1], "w");
  term(s);
  ioport(m);
  if (m->fl isnt NULL) fclose(m->fl);
}

/*
 *  General "do terminal" things.
 */

term(s)
PORTS *s;
{
  register char ch;
  register PORTS *m;
  byte ec;

  m = cport;
  m->flags clrbit p_give;
  ec = s->ec;
  s->ec = true;

  while(true)
  {
    ioport(m);
    if (instat())
    {
      if ((ch = inchar()) is '\r') ch = '\n';
      if (ch is rchar)
      {
        m->flags setbit p_give;
        s->ec = ec;
        return;
      }
      ioport(s); outchar(ch);
      if (m->fl isnt NULL) if (ch isnt cpmeof) putc(ch, m->fl);
    }

    ioport(s);
    if (instat())
    {
      if ((ch = inchar()) is '\r') ch = '\n';
      if (m->fl isnt NULL) if (ch isnt cpmeof) putc(ch, m->fl);
    }
  }
}
