/*
 *  MBMODE.C - 12/28/86 - Mode command to setup the ports.
 */

/*
 *  Copyright (C) 1986
 *  H. N. Oredson
 *  134 Ponderosa Drive
 *  Santa Cruz, ca 95060
 *
 *  This code was created and distributed
 *  to the packet radio community by W0RLI and VE3GYQ.
 *  It may be freely copied for non-commercial use,
 *  as long is this notice is retained.
 *
 *  This notice and Copyright apply to all modules
 *  referenced by this module.
 */

#include <dos.h>
#include <ctype.h>

#define is   ==
#define isnt !=
#define false 0
#define true  1
#define and  &&
#define or   ||

static char b1[8] = { '1', '1', '3', '6', '1', '2', '4', '9' };
static char b2[8] = { '1', '5', '0', '0', '2', '4', '8', '6' };
static char pars[4] = { 'N', 'O', 'N', 'E' };
static char stops[2] = { '1', '2' };
static char wlens[4] = { '?', '?', '7', '8' };

main(argc, argv)
int argc;
char *argv[];
{
  char *p;
  int  port, baud, par, stop, wlen;
  short ok;
  union REGS inreg, outreg;

  if (argc < 1) oopsy("Wrong number of arguments");

/*
 *  Command line to upper case.
 */

  for (p = argv[1]; *p; p++) if (islower(*p)) *p = toupper(*p);

/*
 *  Find port number.
 */

  for (p = argv[1]; *p and (*p isnt ':'); p++);
  if (*p isnt ':') oopsy("No colon after COMn");

  port = (int) (*(p - 1) - '0');
  if (isdigit(*(p - 2))) port += 10 * (int) (*(p - 2) - '0');
  port--;

  if ((port < 0) or (port > 15)) oopsy("Port number out of range");

  p++;

  if (!*p) oopsy("Parameters missing");

/*
 *  Find baud rate.
 */

  ok = false;
  for (baud = 0; !ok and (baud < 8); baud++)
  {
    ok = (*p is b1[baud]) and (*(p + 1) is b2[baud]);
  }

  baud--;

  if (!ok) oopsy("Baud rate not correct");

  for (; *p and (*p isnt ','); p++);
  if (!*p++) oopsy("Missing parameter");
  if (!*p)   oopsy("Missing parameter");

/*
 *  Find parity.
 */

  ok = false;
  for (par = 0; !ok and (par < 4); par++)
  {
    ok = (pars[par] is *p);
  }
  par--;
  if (!ok) oopsy("Parity not N, E, or O");
  for (; *p and (*p isnt ','); p++);
  if (!*p++) oopsy("Missing parameter");
  if (!*p) oopsy("Missing parameter");

/*
 *  Find word length.
 */

  ok = false;
  for (wlen = 0; !ok and (wlen < 4); wlen++)
  {
    ok = (wlens[wlen] is *p);
  }
  wlen--;
  if (!ok) oopsy("Word length is not 7 or 8");
  for (; *p and (*p isnt ','); p++);
  if (!*p++) oopsy("MIssing parameter");
  if (!*p)   oopsy("Missing parameter");

/*
 *  Find number of stop bits.
 */

  ok = false;
  for (stop = 0; !ok and (stop < 2); stop++)
  {
    ok = (stops[stop] is *p);
  }
  stop--;
  if (!ok) oopsy("Number of stop bits not 1 or 2");

  inreg.h.al = 32 * baud + 8 * par + 4 * stop + wlen;

  printf("     COM%d:%c%c,%c,%c,%c = %x\n", port + 1,
    b1[baud], b2[baud], pars[par], wlens[wlen], stops[stop], inreg.h.al);

  inreg.x.dx = port;
  inreg.h.ah = 0;
  int86 (0x14, &inreg, &outreg);
}

oopsy(p)
char *p;
{
  printf("%s\n",p); exit(1);
}
