/*
 *  MBCONVM - 10/31/88
 *
 *  Copyright (C) 1988
 *  By the CBBS Group.
 *
 *  This program converts the mail textfiles from a version 8
 *  mail system to version 9 format.
 *  Version 9 format requires that the file header information
 *  be included in the first record of the textfile.
 *  Normal textfile data starts at offset 256 in the file.
 *
 *  It is expexted that CONVERTM.EXE be placed in the directory
 *  containing the textfiles and be executed from there.
 *  It is also expected that the file MAIL.DAT will be located in the
 *  directory \MB\BBS but if this is not the case, the user will be
 *  given the option of entering the actual directory path information.
 *  Optionally the program can be invoked with the path to the mail.dat
 *  as a command line parameter such as CONVERTM \HF\BBS  .
 *  The converted textfiles will retain the original names and location.
 *
 */

#include "mb.h"

/*  Old message header record. */


typedef struct omsg_hdr_s
{
  word next;          /* Next message header record                      */
  word prev;          /* Previous message header record                  */
  word ext;           /* Header extension record, or zero                */
  word rn;            /* Record number of this record                    */
  word read;          /* # times the message has been read               */
  word number;        /* Message number                                  */
  word size;          /* Size in bytes                                   */
  char type;          /* Message type                                    */
  byte stat;          /* Message status, see bit definitions above       */
  char to  [ln_call]; /* Destination call                                */
  char from[ln_call]; /* Originator call                                 */
  char bbs [ln_call]; /* Destination BBS, or distribution list           */
  char date[ln_date]; /* Entry date                                      */
  char time[ln_time]; /* Entry time                                      */
  char bid[ln_bid];   /* Bulletin ID, if this is a bulletin              */
  char title[80];
  char unu[120];
} OMSG_HDR;

/*  Message header extension item. */

#define o_mmesn 35           /* Maxcalls i distribution list     */

typedef struct omsg_ext_s
{
  word next;                 /* Next extension item, or free item   */
  char call[o_mmesn][ln_call]; /* Calls to send it to                 */
  byte flag[o_mmesn];          /* TRUE if need to send, FALSE if sent */
  byte count;                /* Number of calls in list            */
  char unu[8];
} OMSG_EXT;


OMSG_HDR  *o_tmmhs;
OMSG_EXT  *o_mmes;

/*
 *  Old mail file header record.
 */


typedef struct omail_hdr_s
{
  word next;          /* Next record to allocate         */
  word first;         /* First message header record     */
  word last;          /* Last message header record      */
  word ffree;         /* First record in free chain      */
  word lfree;         /* Last record in free chain       */
  word next_msg;      /* Next message number             */
  word unt_msg;       /* next_msg at last untangle       */
  byte version;       /* File format version number      */
  word free;          /* Number of records in free chain */
  word count;         /* Number of messages              */
  char date[ln_date]; /* Date of last untangle           */
  char time[ln_time]; /* Time of last untangle           */
  char unu[227];
} OMAIL_HDR;

OMAIL_HDR *o_mfhs;



main(argc, argv)
int argc;
char *argv[];
{

#define chunk 4096
register word h, rec;
register char st, c;
char *buf, *buf1, *mpath;
char msgfile[10], tmpfile[10], mbfile[80], mbnfile[80];
char flags[mmesn];
int mfl, msgfl, msfl, mfln, n, first, do_it;
MAIL_HDR  *mfhs;
MSG_HDR   *tmmhs;


/*
 *  Allocate space for the mail file records.
 */

  mfhs    =  (MAIL_HDR *) malloc(sizeof(MAIL_HDR));
  tmmhs   =  (MSG_HDR *)  malloc(sizeof(MSG_HDR));
  o_tmmhs =  (OMSG_HDR *) malloc(sizeof(OMSG_HDR));
  o_mmes  =  (OMSG_EXT *) malloc(sizeof(OMSG_EXT));
  o_mfhs  =  (OMAIL_HDR *)malloc(sizeof(OMAIL_HDR));

  buf     =  (char *) malloc(chunk);
  buf1    =  (char *) malloc(RECSIZE);

  if(argc > 1) mpath = argv[1]; else mpath = "\\mb\\bbs";
  sprintf(mbfile, "%s\\MAIL.DAT", mpath);

/*
 *  Open the mail file.
 */

  if ((mfl = open(mbfile, O_RDONLY | O_BINARY)) < 0)
     { puts("MAIL.DAT is not in this directory.\nInput directory");
       gets(mpath);
       sprintf(mbfile, "%s\\MAIL.DAT", mpath);
       if ((mfl = open(mbfile, O_RDONLY | O_BINARY)) < 0)
         { puts("MAIL.DAT is not in that directory either. Aborting\n");
           exit(1);
         }
     }

/*
 *  Read the mail file header.
 */

  read_rec(mfl, 0, (char *)mfhs);
  if (mfhs->version is 9)
   { puts("Mailfile has been converted previously. Aborting\n"); exit(1);}
  read_rec(mfl, 0, (char *)o_mfhs);   
  if (o_mfhs->version < 8 )
   { puts("Mailfile is wrong version. Aborting\n"); exit(1);}

/*
 *  Creat the NEW mail file
 */

  sprintf(mbnfile, "%s\\MAIL.NEW", mpath);
  if((mfln = open(mbnfile, O_CREAT | O_RDWR | O_BINARY, pmode)) < 0)
   { puts("MAIL.NEW cannot be opened");
     exit (1);
   }
  rec = 0;
/*
 *  Read the mail file records in sequence and
 *  process each corresponding text file.
 */

  for (h = o_mfhs->first; h; h = o_tmmhs->next)
  {
    read_rec(mfl, h, (char *)o_tmmhs);

    fill(tmmhs, '\0', 256);
    fill(flags, ' ', mmesn);

    tmmhs->read     = o_tmmhs->read;
    tmmhs->number   = o_tmmhs->number;
    tmmhs->size     = o_tmmhs->size;
    tmmhs->type     = o_tmmhs->type;
    tmmhs->stat     = o_tmmhs->stat;
    strncpy(tmmhs->to, o_tmmhs->to, ln_call);
    strncpy(tmmhs->from, o_tmmhs->from, ln_call);
    strncpy(tmmhs->bbs, o_tmmhs->bbs, ln_call);
    strncpy(tmmhs->date, o_tmmhs->date, ln_date);
    strncpy(tmmhs->time, o_tmmhs->time, ln_time);
    strncpy(tmmhs->bid, o_tmmhs->bid, ln_bid);
    strcpy(tmmhs->title, o_tmmhs->title);
    tmmhs->ext = false;

    if (o_mmes->count > mmesn) o_mmes->count = mmesn;
    if(o_tmmhs->ext)
    {
      tmmhs->ext = 0x01;
      read_rec(mfl, o_tmmhs->ext, (char *)o_mmes);
      for (c = 0; c < o_mmes->count; c++)
      {
          strncpy(tmmhs->call[c], o_mmes->call[c], ln_call);
          tmmhs->flag[c] = o_mmes->flag[c];
          flags[c] = tmmhs->flag[c] + '0';
      }
      tmmhs->count = o_mmes->count;
    }

    sprintf(msgfile,"%u",o_tmmhs->number);
    if ((msgfl = open(msgfile, O_RDONLY | O_BINARY)) < 0)
        { printf("%5.5u textfile for this message not found\n", o_tmmhs->number);
          continue;
        }
    
    first = true;
    do_it = true;
    while ((n = read(msgfl, buf, chunk)) >0)
    {
      if(first)
      {
        if (n >= RECSIZE)
        if ((buf[253] is '\0') and (buf[254] is '\r') and (buf[255] is '\n'))
        {
          printf("%5.5u was previously converted\n",
             tmmhs->number);
          do_it = false;
          break;
        }
        printf("%5.5u %s\n", o_tmmhs->number, o_tmmhs->title);

    /*  Prepare and write the internal header to the temporary file */

        fill (buf1, '\0', 256);
        buf1[254] = '\r'; buf1[255] = '\n';
        st = 'N';
        if (o_tmmhs->stat & m_stale) st = 'O';
        if (o_tmmhs->stat & m_fwd)   st = 'F';
        if (o_tmmhs->stat & m_hold)  st = 'H';
        if (o_tmmhs->stat & m_read)  st = 'Y';
        if (o_tmmhs->stat & m_kill)  st = 'K';
      sprintf(buf1,
"%5u %c%c %5u %6.6s %6.6s %6.6s %6.6s %4.4s %-12.12s %5u\r\n%c %16.16s\r\n%s\r\n",
          o_tmmhs->number, o_tmmhs->type, st, o_tmmhs->size,
          o_tmmhs->to, o_tmmhs->from, o_tmmhs->bbs,
          o_tmmhs->date, o_tmmhs->time, o_tmmhs->bid, o_tmmhs->read,
          tmmhs->ext + '0', flags, o_tmmhs->title);
        sprintf(tmpfile,"%u.tmp",o_tmmhs->number);
        msfl = open(tmpfile, O_CREAT | O_WRONLY | O_BINARY, pmode);
        write_rec(msfl, 0, (char *)buf1);

        first = false;
      }
      write (msfl, buf, n);
    }
    close(msgfl);
    if (do_it)
    {
      close(msfl);
      unlink(msgfile);
      rename(tmpfile, msgfile);
      ++rec;
      tmmhs->rn = rec;
      write_rec(mfln, rec, (char *)tmmhs);
    }

  }

/*
 *  Write new version number to mailfile and close the file.
 */

  printf("MAIL.DAT had %u messages, MAIL.NEW has %u messages.\n",
     o_mfhs->count, rec);
  mfhs->version = mb_version;
  mfhs->count = mfhs->last = rec;
  mfhs->first = 1;
  mfhs->next = rec + 1;
  mfhs->free = 0;
  mfhs->next_msg = o_mfhs->next_msg;
  mfhs->unt_msg = o_mfhs->unt_msg;
  strncpy(mfhs->date, o_mfhs->date, ln_date);
  strncpy(mfhs->time, o_mfhs->time, ln_time);
  fill(mfhs->unu, '\0', mfhsunu);

  write_rec(mfln, 0, (char *)mfhs);
  close(mfl);
  unlink(mbfile);
  printf("Deleting %s\n", mbfile);
  close(mfln);
  printf("Renameing %s to %s\n", mbnfile, mbfile);
  rename(mbnfile, mbfile);

}

/*
 *  Write random record.
 */

write_rec(fid, rec, buffer)
int fid;
int rec;
char buffer[];
{
  long lseek();
  long offs;

  offs = (long)rec * (long)RECSIZE;
  lseek(fid, offs, 0);
  return (write(fid, buffer, RECSIZE) is RECSIZE);
}

/*
 *  Read random record.
 */

read_rec(fid, rec, buffer)
int fid;
int rec;
char buffer[];
{
  long lseek();
  long offs;

  offs = (long)rec * (long)RECSIZE;
  lseek(fid, offs, 0);
  return (read(fid, buffer, RECSIZE) is RECSIZE);
}

/*
 *  Fill some memory with a character.
 */

fill(adr, ch, len)
char *adr;
char ch;
int len;
{
  while (len--) *adr++ = ch;
}
