; This file contains most of the system's messages.  The header of a message
; is
;                : number class
;
;   number -- The number of the error message.
;   class  -- The class of user to get this message
;                   N = New
;                   U = Unregistered user
;                   O = Registered user
;                   E = Expert user
;                   B = BBS
;                   R = Remote SYSOP
;                   L = Local SYSOP
;
; The message then follows.  Blank lines are ignored.  If you want a blank
; in a message, use % in the first column.  If you want to sent a file
; instead of a message use an "@".  Example  "@INFO.BB"
;
; The following tokens are substituted:
;
;     $A - @ BBS of the current message.
;     $a - Call of the originating bbs.
;     $B - Type of current message.
;     $b - BID of current message.
;     $C - The message type (by name)
;     $c - The size of the message
;     $D - The current date.
;     $E - Title of current message.
;     $F - Name of the users port.
;     $f - Name of the "other" gateway port.
;     $G - TO of the current message.
;     $g - TO "H" address of current message
;     $h - Home BBS of the connected user
;     $I - Sysops name.
;     $J - Date from current msg header
;     $j - Date from orig msg header
;     $K - Time from current msg header.
;     $k - Time from orig msg header.
;     $L - Number of the last message in the MailBox
;     $l - Date/time of user's last "L" command.
;     $M - Message number from current msg header.
;     $m - Message number from orig msg header.
;     $N - Number of active messages.
;     $n - Number of killed messages.
;     $O - Sysops callsign.
;     $o - Hierarchical address of this BBS
;     $P - FROM from current msg header.
;     $p - FROM "H" address
;     $Q - Sysops QTH
;     $q - Language setting for this user.
;     $R - Number of messages awaiting to be read by this user  (LM)
;     $r - Number of messages awaiting to be listed by this user (L)
;     $S - Status of current message.
;     $s - Screen length of user.
;     $T - The current time.
;     $t - Task ID.
;     $U - User callsign.
;     $V - Software version.
;     $u - User authentication requirements
;     $W - Users name.
;     $w - Screen width of user.
;     $X - Date user last logged in.
;     $y - Port/channel letter combo (eg A3)
;     $Y - Time user last logged in.
;     $Z - User's MAX PAC
;     $z - User's format
;     $1 - Parameter
;     $7 - Sound 440 Hz tone
;     $8 - Sound 880 Hz tone
;     $9 - Sound 1320 Hz tone
;     $: - $:
;
;
; A substitution token my be optionally followed by a format descriptor.
; This is designated by the character "#".  The number following indicates
; the size of the filed.  If negative, the information is LEFT justified.
;
; Examples:
;
;    If message number = 85 then
;
;       'x $c y'    produces 'x 85 y'
;       'x $c#8 y'  produces 'x       85 y'
;       'x $c#-8 y' produces 'x 85       y'
;
;
; When it comes time to send a message to a user, the program searches
; starts at the user's class and searches towards "NEW USER" to find the
; first message.  Example:  Message 2 has three versions but none for
; EXPERT.  If an expert user connects, it will take the OLD USER version
; since this is the next level down.  A remote sysop, however, gets a real
; short one since it has its own message for that level.
;
;---------------------------------------------------------------------------

: 1 N
I don't understand that. Please try again.
%

: 2 N
Hello and welcome to the $O mailbox!
%
I see that you are a new user.  If you want to find out about the
system, then enter INFO followed by a carriage return.  If you would
like to register as a user, please type REGISTER.  Help is also
available by typing HELP (thats pretty obvious).  If you are an
experienced user of any of the standard mailbox programs, this one is
compatible.
%

: 2 U
Hello and welcome to the $O mailbox!
%
I see that you have logged on before but not registered as a user.
Please do so soon.
%
If you want to find out about the system, then enter INFO followed by a
carriage return.  If you would like to register as a user, please type
REGISTER.  Help is also available by typing HELP (thats pretty obvious).
If you are an experienced user of any of the standard mailbox programs,
this one is compatible.
%

: 2 O
Hello $W and welcome to the $O mailbox!
%

: 2 B
Hello!

: 3 N
Action complete

: 4 N
@INFO.BB

: 4 R
  Last message    : $L
  Active messages : $N
  Killed messages : $n
%
  Messages awaiting to be read by you : $R
  Messages to be listed by you        : $r
%
  Memory available: $1

: 5 N
Type H if you need Help>

: 5 E
BBS ==>

: 5 B
=>

: 6 N
Please enter a subject for your message.

: 6 E
Subject?

: 7 N
Please enter your message now.  When you are finished, type a Control-Z
followed by a carriage return.

: 7 E
Msg?

: 8 N
To who should this message go?

: 8 E
Addressee?

: 9 N
Invalid message number specified!

: 10 N
What message number did you want to read?

: 11 N
There were too many words in your response!

: 12 N
The qualifier (2nd letter) of the command is invalid!

: 13 N
 Msg# TR  Size   To                 From           Date/Time Subj

: 14 N
You specified an invalid LIST criteria

: 15 N
No message matches your search criteria

: 16 N
The message you want cannot be found or you are not allowed to look at it.

: 17 N
There are no unread messages for you!

: 18 N
Message #$1 to be killed cannot be found or you are not allowed to kill it.

: 19 N
The address portion of the command is incorrectly formatted.

: 20 N
Message $d has been killed!

: 21 N
What message number did you want to kill?

: 22 N
No data supplied so command cancelled!

: 23 N
Message $d has been stored!

; This is the header used for relaying messages.  Make sure it is not
; more than 80 characters when expanded.
: 24 N
R:$J/$Kz @:$O$o #:$M

: 25 N
The userid you specified could not be found!

: 26 N
You have mail waiting for you.
To list this mail, type LU
To read this mail, type RM
When you are done, erase the mail by typing KM

: 26 E
You have mail waiting for you.

: 27 N
MaxPac(M): $Z  Format(F): $z Modem Password(W): $1
Screen (SxY): $sx$w Language(Q): $q Access Control(U): $u
Advanced BBS, BBS, PBBS, Delete, Home, Name, Remote SYSOP, eXclude, Zip,
Local, Class, Trans, Emergency?

: 28 N
To Adr(H): $g   From Adr (X) $p   Bid(I): $b
T (To), B(@To), F(From), A(@From), J(Title), D(Type), S(Status)?

: 29 N
Call   SS Last On     Cnt PC TBRXDLE Home       Zip        Name

: 30 N
Mailbox has not received any data from you in a while.  Connection severed.

: 30 B
Time out!

: 31 N
Invalid taskid or portid specified!

: 32 N
Task not found

: 33 N
Enter your first name

: 34 N
Enter your home zip code

: 35 N
Enter the callsign of the bulletin board station where you check in
regularly to get your mail.  Please don't enter your own call even if
you run a personal mailbox.

: 36 N
The data you entered is too long for the field.

: 37 N
%
Thanks for registering, $W.  You are now an official user of this mailbox.
%
The prompts are in "LONG" mode.  If you know your way around most
mailboxes, you can shift to the "EXPERT" mode with short prompts and
messages by entering NE.  Typing NE again will convert you back to the
LONG mode.

: 37 E
%
Thanks for re-registering, $W.

: 38 N
Invalid file name

: 39 N
The second operand is invalid

: 40 N
The date is in bad format.  Should be YYMMDDHHMM

: 41 N
Not enough operands

: 42 N
You cannot kill message #$1

: 43 N
Help for the command you wanted could not be found.

: 44 N
You are now in new user mode.

: 44 U
You are now in unregistered user mode.

: 44 O
You are now in user mode.

: 44 E
You are now in expert mode.

: 44 B
You are now in BBS mode.

: 44 R
You are now in remote SYSOP mode.

: 44 L
You are now in local SYSOP mode.

: 45 N
This is $O Mailbox in $Q.
%

: 46 N
The BID on this message is a duplicate.  It will be held for the
SYSOP's review

: 47 N
You are not permitted to use this port.

: 48 N
Files are available on the following topics:

: 49 N
Also known as:

: 50 N
No files are available to you

: 51 N
No files under that name are available to you

: 52 N
A backslash "\" is not permitted in this directory

: 53 N
File saved.

: 54 N
File already exists.

: 55 N
No files match the search criteria

: 56 N
Message #$1 has already been killed

: 57 N
JL - Past Connects
JN - Current users of mailbox

: 58 N
The SYSOP wishes to chat with you.
----------------------------------

: 59 N
You are back in normal mailbox mode

: 60 N
Wait while $O is paged.  Enter anything to cancel wait.

: 61 N
Wait is cancelled.

: 62 N
$O did not answer the page.  If you wish, leave a message
via the command:
      SP $O
%

: 63 N
$O is not available now.  If you wish, leave a message
via the command:
      SP $O
%

: 64 N
 Msg# TR  Size   To           From   Date/Time Subj

: 65 N
Enter the number of the desired message list format.
     0 = short
     1 = long
     2 = super short (no @ fields)

: 66 N
You must supply a valid number

: 67 N
From    :
: 68 N
To      :
: 69 N
Date    :
: 70 N
Msgid   :
: 71 N
Subject :
: 72 N
Path    :

: 73 N
Wildcards are not permitted on this command

: 74 N
Please enter the file now.  When you are finished, type a Control-Z
followed by a carriage return.

: 75 N
Bye

: 76 N
Operation complete

: 77 N
Enter a message type (one character)
  B = Broadcast
  P = Personal to someone
  T = NTS

: 78 N
The message type you entered was not an allowed type
%

: 79 N
The mailbox is unable to process your request because some resource
is temporarily unavailable.  Please try again later.

: 80 N
This command cannot be executed because other users are connected

: 81 N
Invalid message number or range specified -- $1

: 82 N
Message $1 cannot be found or you are not allowed to look at it.

: 83 N
Operation halted

: 84 N
Mail for:

: 85 N
Start your $1 data transfer

: 86 N
$1 data transfer started

: 87 N
$1 data transfer complete

: 88 N
$1 abort sent

: 89 N
$1 abort received

: 90 N
$1 timeout occurred

: 91 N
$1 protocol error

: 92 N
Originator's $1 file info is:

: 93 N
Binary file transfer not permitted for either this topic area or this port

: 94 N
This command cannot be executed without a "connected" task

: 95 N
Enter your call sign

: 96 N
Enter your password

: 97 N
Password Invalid

: 98 N
 -- Outbound forward

: 99 N
 (connect in progress)

: 100 N
 -- Special task

: 101 N
 -- Inbound forward

: 102 N
 (reversed)

: 103 N
 (talking to sysop)

: 104 N
No users on system
: 105 N
Personal message
: 106 N
Bulletin
: 107 N
Traffic
: 108 N
Service message
: 109 N
Message
: 110 N
What message number did you want to reply to?

: 111 N
Hello and welcome to the $O mailbox.  You are on the telephone modem
port.  You can change your password with the NP command.
%
Please register using the REGISTER command.
%
If you want to find out about the system, then enter INFO followed by a
carriage return.  If you would like to register as a user, please type
REGISTER.  Help is also available by typing HELP (thats pretty obvious).
If you are an experienced user of any of the standard mailbox programs,
this one is compatible.

: 111 O
Hello and welcome to the $O mailbox.  You are on the telephone modem
port.  You can change your password with the NP command.

: 111 B
Hello!

: 112 N
Binary download type is invalid.

: 113 N
Bad block number during $1 transfer

: 114 N
Bad block during $1 transfer

: 115 N
Re:

: 116 N
----- End of message $M from $P @ $a.$p -----

; Best leave message 116 blank for BBS
: 116 B

: 116 R
----- End of message $M from $P @ $a.$p -----

; Make this message null if you don't want to respond at end of reverse forward
: 117 N
*** DONE

: 118 N
Please confirm operation.  Yes (1) or No (0)

: 119 N
The switch is now on

: 120 N
The switch is now off

: 121 N
The type of file whose name you want to change is invalid

: 122 O
Its been a while since you registered at this mailbox.  Would you please
reconfirm your data by reentering it?  You can do this by entering
REGISTER at the next prompt.

: 123 N
Held for review -- Bulletin is old

: 124 N
Held for review -- Duplicate BID

: 125 N
Held for review -- Possible looping

: 126 N
Held for review -- Put in hold by operator

: 127 N
Held for review -- Distant system rejected message

; This is the header used for originating messages.  Make sure it is not
; more than 80 characters when expanded.
: 128 N
R:$J/$Kz @:$O$o $Q #:$M $$:$b

: 129 N
Enter the number of lines to send before pausing.  If you don't want a
pause, use 0.  Your current setting is $s.

: 130 N
Please enter your tactical call sign

: 131 N
Please enter a blank line to continue, anything else to halt output

: 132 N
Enter the number of characters wide that your screen is.  Specify 0 if you
don't want the BBS to worry about width.  Your current setting is $w

: 133 N

%
Your current screen height setting is $s.
Your current screen width setting is $w.
%

: 134 N

This BBS is not accepting NTS messages right now

: 135 N

Enter a message type (one character)
  Z = Life or death
  Y = Network control (SYSOPs only please)
  X = Emergency
  W = Priority
  V = Routine
  T = NTS to out of area

: 136 N
Space for files selected/Disk space free/Total disk space

: 137 N
The edit command is invalid

: 138 N
Bad operand on a search -- $1

: 139 N
Held for review -- Operator requested

;----------------------------------------------------------
; Deny/Reject messages start here at 140 and go to 149.  Only message
; 140 is used with a BBS.  The message that will be sent
; when a deny action is taken is set by the parameters in the
; ACTION.BB file.  The text shown below are tied to the samples
; that are in my ACTION.BB
;----------------------------------------------------------

: 140 N
Messages with this type and address are not allowed

; **** NOTE ****
; The first word of the next message must be REJECT -- don't change it
; It can only be one line long!
: 140 B
REJECT -- Excluded by SYSOP
;

: 140 R
Messages with this type and address are not allowed

: 141 N

You have attempted to send a personal message to the world.  I think you
really wanted a bulletin.  Try again with the SB command.

: 142 N
You tried to send a message to "ALL"

For bulletins, please use the TO address as a quick topic selection.
Examples: SALE, INFO, WANT, AMSAT

:  143 N

For sale message must be sent to this state only.  Use ALLCA or ALLCAN
instead of USA or ALLUS.

:  144 N

You must be registered to send bulletins.  Issue the REGISTER command.

: 150 N
Held for review -- On REJECT list

: 151 N

Enter language to be used
   A = English

: 152 N

Invalid selection

; This is the "MORE" continuing message.  It can be used to output
; a screen clear to an ANSI user.  I leave it null

: 153 N


: 154 N

You must enter a subject for this type of message.  NTS message should
show the city and phone number (only area code and prefix needed).

: 155 N

Status changed to $S for message $M

: 156 N

Message held for review by SYSOP

: 157 N

The BBS is in emergency mode.  Please try your access later

: 158 N

You cannot issue a send command until the system is sure of your identity.
Authentication will begin now.

: 159 N

You are not permitted access

: 160 N

Action for msg #$M: (K)ill, (L)eave, (Q)uit, r(E)ply?

: 160 R

Action for #$M: (K)ill, (R)elease, (H)old, (L)eave, (Q)uit, r(E)ply (C)hange?

: 161 N

No change for message $M

: 162 N

Authentication is complete

: 163 N

Authentication is not complete

: 164 N

The file to be executed cannot be found

: 165 N

Invalid action code.

: 166 N

Message held during a REVIEW

: 167 N

BBS is busy right now.  Please try again later

: 168 N

 Msg#  Size   To    From   Date/Time Subj

: 169 N

$G has registered as a user of the $A bbs.  This message will be sent there.

: 170 N

You were unable to properly authenicate your callsign.  You cannot
send any messages until you do.

: 171 N

Your user class is not permitted to use that command.

: 172 N

The call sign you gave is either invalid format or not authorized.

: 173 N

That command is either not authorized for your user class or for this port.

: 174 N

You must register as a user of this BBS to continue.
%

: 175 N

This database is not enabled or and internal error has occurred

: 176 N

%
The record for $1 cannot be found

: 177 N

Message for:    $G at $A.$g
Message from:   $P at $a.$p
Date sent:      $j
Time sent:      $k
Subject:        $E
Message number: $M

: 178 N

TR Size To From Date/Time Subj

: 179 N

Here are the messages:

: 180 N

You have mail that you have read but not deleted.  LY will show you
these messages.  KY will kill them.

: 181 N

Messages routed to $1

: 182 N

This command would list $1 messages.  Enter the number of lines to send
before pausing.  If you don't want a pause, use 0. Your current setting
is $s.
%
In the future, you can bypass this message by using the command "L0"

: 183 N

Please send the attached file.

: 184 N

Select a protocol or an existing file on this BBS for your attached file
Enter a blank line to terminate sending the message.

: 184 L

Enter the file area and file name for the attached file or ASCII for
ASCII upload.  Enter a blank line to terminate sending the message.

: 185 N

Your response was not recognizable.

: 186 N

Select a download protocol or an file area on this BBS for the attached
file.  Enter a blank line to terminate receiving the message.

: 186 L

Enter the area and file name for the attached file or ASCII for a
display of the file.  Enter a blank line to terminate sending the
message.

: 187 N

Message $M has an attached file with $1 bytes.

: 188 N

----- End of attached file to msg $M from $P @ $a.$p -----

: 189 N

Message $M marked old after $1 days

;----------------------------------------------------------
; Tell user messages start here at 190 and go to 199.  The
; message that is sent with the TELL_USER action in ACTION.BB
; The actual number useed is determined by the paramter in the
; ACTION.BB file.  The text shown below are tied to the samples
; that are in my ACTION.BB.  *** NOTE *** To ensure proper
; forwarding, these messages are empty for BBS
;----------------------------------------------------------

: 190 N

Many HF networks will not carry messages in excess of 3000 characters.
This may delay your message.

: 190 B

: 191 N

The message will be held for sysop review since you are not
authenticated.

: 200 N

Held for sysop -- Other end reported duplicate during forwarding

: 201 N

Mail for you has just arrived.

: 202 N

Wrong type of port for this operation

: 203 N

Invalid hex number -- $1

: 204 N

No authenication challenge was issued

: 205 N

Forward group number is in error

: 206 N

Suspicious or missing BID/MID on send command


