/* I got fed up with evey compiler system using a different name for the
random number generator(s). I've use two random number generators in 
th main code:

1) randreal() Expects a double in range 0 to 1.
2) randint()  Expects an integer in range 0 to 2^15-1.

DONT change the names 'randreal' and 'randint' in all the other souces
file. But DO edit the source of the two functions 'randreal' and
'randint' in this C file. Let them call whatever you like/works on your
system. 

If you use another system (eg VAX), I suggest you put this in functions
randreal and reandint:

randint()
{
#ifdef VAX
return(VAX_integer_random_number_generator());
#endif
}


*/

#ifdef i386
#ifdef UNIX
#include <time.h>
#endif
#endif
#ifdef DOS
#include <sys/time.h>
#endif
#ifdef sun
#include <sys/time.h>
#endif
#include <stdio.h>
#include <math.h>
/* #include <random.h> */
#ifndef GCC
#include <stdlib.h>
#endif
#include <values.h>
#include "yagi.h"

double drand48();
int lrand48();

double randreal(void)
{
#ifdef GCC /* GCC on PC running DOS */ 
#ifdef DOS
	return(rand()/65535.0);
#endif
#endif

#ifdef i386   /*GCC on my PC running unix */
#ifndef DOS
	return(drand48());
#endif
#endif

#ifdef sun
	return(drand48());
#endif
}
double randnorm(void)
{
	static short paired=0 ;
	static double second ;
	double x,y,rad,fac ;

	if (paired=!paired)
	{
		do {
		x=2.0*randreal()-1.0 ;
		y=2.0*randreal()-1.0 ;
		rad=x*x+y*y ;
		} while((rad>1.0)||(rad=0.0));
		fac=sqrt(2.0*log(rad)/rad) ;
		second=(x*fac) ;
		paired=!paired ;
		return (y*fac) ;
	} else return (second);
}       
		
		
int randint(void)
{
#ifdef UNIX
#ifdef i386
	return( (int) lrand48()/65535 );
#endif
#endif
#ifdef DOS
#ifdef GCC
	return( (int) rand()/2 );
#endif
#endif

#ifdef sun
	return( (int) lrand48()/65535 );
#endif
}

/* Since two random number gerators are used (a float and an int type), its
usually necessary to seed both sepparately */
void seedRNG(void)
{
	long seed_time;

	time(&seed_time); /* set seed_time to the number of seconds since Jan 1980 */
#ifdef DOS
	srand(seed_time); /* Seed the float type */
	srand(seed_time); /* Seed the int type */
#endif

#ifdef UNIX
#ifdef i386
	srand48(seed_time);  /* Seed the float type */
	lrand48(seed_time); /* Seed the int type */
#elif sun
	srand48(seed_time);  /* Seed the float type */
	lrand48(seed_time); /* Seed the int type */
#endif
#endif

}
