#include <stdio.h>
#include "yagi.h"

void usage_first(char *exefile) 
{
	fprintf(stderr,"\nYagiUda antenna analysis programs, version %.2lf\n", version());
	fprintf(stderr,"Written by David Kirkby BSc MSc G8WRB (email:davek@medphys.ucl.ac.uk)\n");
	fprintf(stderr,"Usage: %s [-hs] [-RDFLrfd] filename elements min_f f max_f step_f diameter\n",exefile);
	fprintf(stderr,"       where frequencies are in MHz and diameter is in mm\n");
	fprintf(stderr, "Where options are:\n");
	fprintf(stderr, "   -h     Print this help screen then exit.\n");
	fprintf(stderr, "   -s     Show default parameters.\n");
	fprintf(stderr,"other options [-RDFLrfd] change the default parameters - see man page\n\n");
	fprintf(stderr,"'first' is used to define an antenna quickly, if you are not interested \n");
	fprintf(stderr,"in  analysing  a  specific design (in which case use input) but need\n");
	fprintf(stderr,"to get a design that is half-way reasonable so that  it  may be  optimised.\n");
	fprintf(stderr,"It is much faster in use than 'input' as it makes a large number of assumptions\n");
	fprintf(stderr,"about the antenna. The program is not perfect and needs some work, since:\n");
	fprintf(stderr,"a) It relies on element diamter being about .0095 lambda.\n");
	fprintf(stderr,"b) Input Z is low (~25 Ohms)\n It needs some improvement.\n");
		fprintf(stderr,"Example: first 145e20 20 144 145 146 .1 6.3\n\n");
		fprintf(stderr,"will make a file '145e20' containing a rough description of a 20 element yagi, \nfor 144-146 MHz, designed at 145MHz, which 'yagi' will calculate in steps of \n0.1MHz. The antenna uses 6.3mm diameter elements.\n");

}
void usage_yagi(char *exefile)
{
	
		fprintf(stderr,"\nYagiUda antenna analysis programs, version %.2lf\n", version());
		fprintf(stderr,"Written by David Kirkby BSc MSc G8WRB (email:davek@medphys.ucl.ac.uk)\n");
		fprintf(stderr, "\nUSAGE: %s  [-hs] filename \n\n", exefile);
		fprintf(stderr, "Where options are:\n");
		fprintf(stderr, "   -h     Print this help screen\n");
		fprintf(stderr, "   -s     Suppress diagnostic output\n");
		fprintf(stderr, "'yagi' computes the currents at the centre of of each element of an antenna \ndescribed in 'filename', where 'filename' was created by 'input' or 'first'.\n");
		fprintf(stderr, "After running 'yagi filename' type 'output filename'\n");
}

void usage_output(char *exefile)
{
		double Zo=Z0;        
		fprintf(stderr,"\nYagiUda antenna analysis programs, version %.2lf\n", version());
		fprintf(stderr,"Written by David Kirkby BSc MSc G8WRB (email:davek@medphys.ucl.ac.uk)\n");
		fprintf(stderr, "\nUSAGE: %s  [-hs] [-Z Zo] filename \n\n", exefile);
		fprintf(stderr, "Where options are:\n");
		fprintf(stderr, "   -h     Print this help screen\n");
		fprintf(stderr, "   -s     Suppress diagnostic output\n");
		fprintf(stderr, "   -Z     Set characteristic impedance (default = %.3lf)\n", Zo);
}

void usage_input(char *exefile)
{

	fprintf(stderr,"\nYagiUda antenna analysis programs, version %.2lf\n", version());
	fprintf(stderr,"Written by David Kirkby BSc MSc G8WRB (email:davek@medphys.ucl.ac.uk)\n");
	fprintf(stderr, "\nUSAGE: %s  [-h] \n\n", exefile);

	fprintf(stderr, "Where the only option is:\n");
	fprintf(stderr, "   -h     Print this help screen\n\n\n");

	fprintf(stderr,"'input' is an interactive program, that asks the user for formation  about  \n");
	fprintf(stderr,"a  Yagi  design,  such as position of elements, spacing between elements,\n");
	fprintf(stderr,"frequency span of interest and a  filename to  save the data to. It then \n");
	fprintf(stderr,"writes this information into an ASCII file, which can be read by 'yagi' or \n");
	fprintf(stderr,"'optimise'. The file is  ASCII  and  it's format  is  easily  understood\n");
	fprintf(stderr,"by inspection (there are comments printed in it), so it can if necessary\n");
	fprintf(stderr,"be edited manually. After running 'input' and specifying a filename \n");
	fprintf(stderr,"(for example 144e10) you should then type 'yagi 144e10' then 'output 144e10'\n");
	fprintf(stderr,"and then and optionally 'optimise 144e10'.\n");
}

