#include <stdio.h>
#include <string.h>
#include "yagi.h"

extern double percent, acceptable_resistance_error, acceptable_reactance;
extern double acceptable_fb_ratio, acceptable_vswr, Zo;

void usage_optimise(char *str)
	{

		fprintf(stderr,"\nYagiUda antenna analysis programs, version %.2lf\n", version());
		fprintf(stderr,"Written by David Kirkby BSc MSc G8WRB (email:davek@medphys.ucl.ac.uk)\n");
		fprintf(stderr, "\nUSAGE: %s  [options] filename iterations.\n\n", str);
		fprintf(stderr,"The default behaviour of 'optimise' is to optimise the Yagi description \ncontained in the file 'filename', adjusting the lengths and positions of just \nthe parasitic elements upto %.2lf%% each time, to achieve a better gain, vswr and F/B ratio, but not bothering to go beyond reasonable limits currently set at:\n",percent);
		fprintf(stderr,"  F/B ratio > %.1lf dB\n", acceptable_fb_ratio);
		fprintf(stderr,"  %lf < Rin < %lf \n", Zo-acceptable_resistance_error, Zo+acceptable_resistance_error);
		fprintf(stderr,"  | Xin | < %.2lf Ohms\n", acceptable_reactance);
		fprintf(stderr,"  VSWR < %.2lf:1\n", acceptable_vswr);
		fprintf(stderr,"This will continue for the number of iterations specified in 'iterations' or \nuntil a file called 'stop' is created in the current directory.\n");
		fprintf(stderr,"These are a number of options for 'optimise' which can adjust such things as:\n");
		fprintf(stderr,"   -w Use a weighted combination of performance.\n");
		fprintf(stderr,"   -f, -r, -s, -x These set the reasonable values of F/B, R, SWR and X\n");
		fprintf(stderr,"   -F, -G, -S These set weights of F/B, gain and SWR (all need -W falg)\n");
		fprintf(stderr,"   -l Sets the max percentage change of positions and lengths at each iteration.\n"); 
		fprintf(stderr,"There are many many more options. See man page, or optimise.doc. Sensible use \nof these options will give you a decent Yagi.\n"); 
		exit(1);
	}

