#include <stdio.h>
#ifndef i386
#include <stdlib.h> 
#endif
#include <math.h>
#include <errno.h>
#include "yagi.h"
extern int errno;

#define EULER 0.57721566
void self_impedance(int i, double frequency, int driven, int parasitic, double **data, double **impedance)
{
	int j, row, column_real, column_imag, max_data, ii;
	double lamda, k, x , length, beta, eta, diameter,bl;
	double mu, epsilon, r, real, Rr, Xm;
	double temp, current_scale_factor;
	double ci_bl, si_bl, ci_2bl, si_2bl, sin_bl, cos_bl;

	ii=i;
	/* Put the complex value of impedance for each element into
	the array. This is a complex, as the array sizes for
	driven and parasitic elements are different */

	/* first compute the wavelength */
	lamda=3e8/frequency;

	row=i; 				   /* write data to row, column_real_or_imag */
	column_real=2*i-1;
	column_imag=2*i;
	if(i <= driven)
	{
		max_data=MAX_DRIVEN;
	}
	else if (i > driven)    			 /* parasitic element */
	{
		max_data=MAX_PARASITIC;
		i-=driven;							/* read from i-driven */
	}

	/* Now compute the factor k, defined as the ratio of
	wavelength to element radius */
	diameter=data[i][DIAMETER];

	k=2*lamda/data[i][DIAMETER];
	length=data[i][LENGTH];
	/* Use method in 'Antenna Theory' Baluns ' */
	beta=2*M_PI/lamda;
	mu=4*M_PI*1e-7;
	epsilon=8.854187818e-12;
	eta=sqrt(mu/epsilon);
	bl=beta*length;
	r=diameter/2.0;   /* radius */
	/* We often need si(bl) , si(2*bl), ci(bl), ci(2*bl). These are
	time consuming to calculate, so I calculate just once. The Numerical
	recipes routine cisi, calculates both si and ci at the same time,
	so I wont use my routines ci and si, which both simply call cisi,
	but was one of the results */
	cisi(bl, &ci_bl, &si_bl);
	cisi(2*bl, &ci_2bl, &si_2bl);
	sin_bl=sin(bl);
	cos_bl=cos(bl);
	/* imaginary part of zin given by Balans, pp 294 */
	Xm=(eta/(4*M_PI)) * 
	(2*si_bl+ cos_bl*( 2*si_bl - si_2bl ) 
	-sin_bl*( 2*ci_bl-ci_2bl-ci(2*beta*r*r/length)) ); 
	temp=sin(bl/2);
	current_scale_factor=temp*temp;
	x=Xm/current_scale_factor; /* x=Xm/(sin(bl/2)*sin(bl/2)); */
	impedance[row][column_imag]= x; /* write imaginary data to array */
	/* The radiation resistance, as described by Balans C. A. Antenna theory,
	pp124, Published by Harper and Row, (1982)  */

	j=2*ii-1;			  /* Only write to Z11_real, Z22_real etc */
	Rr=(eta/(M_PI*2))*(EULER+log(bl)-ci_bl+0.5*sin_bl*
	(si_2bl-2*si_bl)+0.5*cos_bl
	*(EULER+log(bl/2)+ci_2bl-2*ci_bl));
	real=Rr/current_scale_factor;
	impedance[ii][j]= real;  

#ifdef DEBUG
	if(errno)
	{
	fprintf(stderr,"Errno =%d in self.c\n", errno);
	exit(1);
	}
#endif
}
#undef EULER
