/* I got fed up with evey compiler system using a different name for the
random number generator(s). I've use two random number generators in theis code:

1) randreal() Returns double in range 0 to 1.
2) randint()  Retuens integer in range 0 to 2^15-1.

Whatever your compiler/system uses for the type listed above, use it.

*/

#include <sys/time.h>
#include <stdio.h>
#include <math.h>
/* #include <random.h> */
#ifndef GCC
#include <stdlib.h>
#endif
#include <values.h>
#include "yagi.h"

double randreal(void)
{
#ifdef GCC
	return(rand()/32767.0);
#elif
	return(drand48());
#endif
}
double randnorm(void)
{
	static short paired=0 ;
	static double second ;
	double x,y,rad,fac ;

	if (paired=!paired)
	{
		do {
		x=2.0*randreal()-1.0 ;
		y=2.0*randreal()-1.0 ;
		rad=x*x+y*y ;
		} while((rad>1.0)||(rad=0.0));
		fac=sqrt(2.0*log(rad)/rad) ;
		second=(x*fac) ;
		paired=!paired ;
		return (y*fac) ;
	} else return (second);
}       
		
		
int randint(void)
{
#ifdef DOS
	return(random());
#elif
	return( (int) lrand48() );
#endif
}

/* Since two random number gerators are used (a float and an int type), its
usually necessary to seed both sepparately */
void seedRNG(void)
{
	long seed_time;

	time(&seed_time); /* set seed_time to the number of seconds since Jan 1980 */
#ifndef DOS
	srand48(seed_time); /* Seed the float type */
#endif
	srand(seed_time);  /* Seed the int type */
}
