#include <stdio.h>
#include <math.h>
#include <string.h>
#include "yagi.h"

extern int optind, opterr;
extern char *optarg;

double Driven_length=.4810;
double First_element_length=0.4536,Last_element_length=0.3758,Reflector_length=0.4896;
double first_driven=.06048, director_director=0.316, reflector_driven=0.1498;

int main(int argc, char **argv)
{
	double min_f, f, max_f, step_f, angular_step=180, diameter, lambda;
	double scale_factor=1, **d, **p,  extra_length;
	double K, X_point_5, delta_X, X_l, fiddle_factor=1.0,l;
	double k ;   /* log(K) */
	int elements, driven, parasitic, i; 
	int sflg=0, hflg=0, errflg=0, aflg=0, mflg=0,c;
	FILE *fp;
	char *output_filename, *notes="Automatically produced by first";

	opterr=0;

   while ((c =  getoptions(argc,argv,"mshD:F:L:R:d:f:r:k:")) != -1)
   switch       (c) 
   {
			/* first two parameters that dont require arguments */
			 case 's':  /* show parameters*/
					sflg=1;
			      break;
			 case 'h':   /* help_screen */
					hflg=1;
			      break;
			case 'm':         /* manual ish */
					mflg=1;
					break;
			/* Now the lengths of the elements (upper case)*/
			 case 'D':  
					Driven_length=atof(optarg); /* get driven length */
					break;
			 case 'F':  
					First_element_length=atof(optarg); /*first director length */
					break;
			 case 'L':  
					Last_element_length=atof(optarg); /* Last director */
					break;
			 case 'R':  
					Reflector_length=atof(optarg); /* Reflector length */
					break;
			/* Now the spacings between elements (lower case) */
			 case 'r':  
					reflector_driven=atof(optarg);
					break;
			 case 'f':  
					first_driven=atof(optarg); /* first director and driven */
					break;
			 case 'd':  
					director_director=atof(optarg); /* directors */
					break;
        /* fiddle all lengths be fiddle_factor. Good is desin too
		  low/high in frequency*/
			 case 'k':  
					fiddle_factor=atof(optarg); /* directors */
					break;
			 case '?':  
					errflg++;
					break;
	}
		
	
	if(hflg || errflg || (argc-optind!=7))
	{
		usage_first(argv[0]);
		exit(1);
	}
		
	elements=atoi(argv[optind+1]);
	min_f=atof(argv[optind+2]);
	f=atof(argv[optind+3]);
	max_f=atof(argv[optind+4]);
	step_f=atof(argv[optind+5]);
	diameter=1e-3*atof(argv[optind+6]);
	if(!mflg)
	{
		/* Using the automatic default,the program adjusts the length of the
		driven element so that the reactance is j12.296 Ohms, the same as in the
		original design in the ARRL manual. All other lengths are then changed
		by the same factor, which I've called fiddle_factor 

		Reactance of dipole taken from Lawson, using his power series,
		since its easier and makes little difference since it will later be
		optimised */

	 	K=600/(f*diameter);  /* new antenna */
		k=log10(K);
		X_point_5=24.1591+(14.5151*k)-(5.3677*k*k)+(0.9352*k*k*k)-(0.06184*k*k*k*k );
		delta_X= -43.1*k + 33.9;	
		X_l=12.396;
		l=0.5+(X_point_5-X_l) / (20 * delta_X); /* in lambda for 15.35 Ohms */
		X_l=X_point_5 + 20*delta_X*(0.5-l);
		fiddle_factor*=l/Driven_length;
		printf("fiddle_factor=%lf\n", fiddle_factor);
	}

	Reflector_length*=fiddle_factor;
	Driven_length*=fiddle_factor;
	First_element_length*=fiddle_factor;
	Last_element_length*=fiddle_factor;
	if(sflg)
	{
		show_all_first_parameters(argv[0]);
	}
	driven=1;
	parasitic=elements-1;
	output_filename=string(0L,100L);
	d=dmatrix(1L,(long) driven,1L, 6L);
	p=dmatrix(1L,(long) parasitic,1L, 4L);
	lambda=300/f;
	fp=fopen(argv[optind],"wt");

	/* first the driven element */
	d[1][X]=reflector_driven*lambda;
	d[1][Y]=0.0;
	d[1][LENGTH]=Driven_length*lambda;
	d[1][DIAMETER]=diameter;
	d[1][VOLTAGE]=1;
	d[1][PHASE]=0.0;
	/* Usually elements get shorter towards the front element. 
	Here we work out a taper (in wavelengths - not m ) */
	extra_length=(First_element_length-Last_element_length)/(parasitic-2);
	/* now all the directors */
	for(i=1;i<=parasitic;++i)
	{
		if(i==1)
			p[1][X]=0.0; /* position of reflector */
		else if ( i==2)
			p[2][X]=d[1][X]+ first_driven*lambda; /* position of first director */
		else if(i > 2)
			p[i][X]=p[2][X]+(i-2)*director_director*lambda;
		p[i][Y]=0.0;
		if(i==1) 
			p[i][LENGTH]=Reflector_length*lambda; /*  reflector length */
		else
			p[i][LENGTH]=lambda*(First_element_length-(i-2)*extra_length); /* taper */
		p[i][DIAMETER]=diameter;
	}
	write_input_data_to_disk(fp, notes, f, min_f, max_f, step_f, elements   , driven, parasitic, angular_step, d, p, scale_factor); 
	fclose(fp);
	free_string(output_filename,0L,100L); 
}
