#include <stdio.h>
#include "yagi.h"

void write_input_data_to_disk(FILE *fp, char *notes, double frequency, double min_f,double max_f, double step_f, int elements,int driven,int parasitic, double angular_step, double **d, double **p, double scale_factor) 
{
	int i; 
	fprintf(fp, "NOTES %s\n", notes);
	fprintf(fp, "FREQUENCY %lf\n", frequency);
	fprintf(fp, "MIN_FREQUENCY %lf\n", min_f);
	fprintf(fp, "MAX_FREQUENCY %lf\n", max_f);
	fprintf(fp, "STEP_FREQUENCY %lf\n", step_f);
	fprintf(fp, "ELEMENTS %d\n", elements);
	fprintf(fp, "DRIVEN %d\n", driven);
	fprintf(fp, "PARASITIC %d\n", elements-driven);
	fprintf(fp, "ANGULAR_STEP   %lf\n", angular_step);
	fprintf(fp, "#DATA_DRIVEN        x         y       length     diameter voltage(r) voltage(i)\n");
	fprintf(fp, "DATA_DRIVEN ");
	for(i=1; i<=driven; ++i)
		fprintf(fp," %10.5lf %10.5lf %10.5lf %10.5lf %10.5lf %10.5lf", d[i][1]/scale_factor, d[i][2]/scale_factor, d[i][3]/scale_factor, d[i][4]/scale_factor, d[i][5], d[i][6]);
	fprintf(fp, "\n#DATA_PARASITIC     x         y       length     diameter\n");
	fprintf(fp, "DATA_PARASITIC\n");
	for(i=1; i<=elements-driven; ++i)
		fprintf(fp,"             %10.5lf %10.5lf %10.5lf %10.5lf\n", p[i][X]/scale_factor, p[i][Y]/scale_factor, p[i][LENGTH]/scale_factor, p[i][4]/scale_factor);
}
