#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <memory.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#ifdef sun         
#include <stdlib.h> /* Need on sun for random ... */
#endif
#include "nrutil.h"
#include "yagi.h"


extern char     *optarg;
extern int optind, opterr;
extern int errno;

double acceptable_vswr=1.1, acceptable_fb_ratio=30.0, acceptable_reactance=3;
double acceptable_resistance_error=5.0;
double percent=0.01; /* Automatic changing: 10, to 1, then 0.1 then 0.01% */
double magnitude, phase;
double Zo=Z0; /* Z0 is defined in yagi.h, Zo can be set in optimise */
double weight_gain=33.333333, weight_fb=33.333333, weight_tau=33.333333, weight_combined=66.666666;
double max_gain=0, boom_factor=1000, diameter, best_perf;
int type_of_elements_moved=3, choice=51, popsize=0;
int iterations, fitness_method=0;
double vswr=1.0;

int errno;

int main(int argc, char **argv)
{

	FILE *fp, *update_fp, *fp_out;
	char *input_filename, notes[1000];
	char *output_filename, *update_filename, *line, *ofile;
	int elements, driven, parasitic;
	int  c, ii;
	int  *indx, i, better=FALSE;
	double lowest_gain=1000, lowest_fb=1000, highest_vswr=1.0;
	double **A, *x,*v,*b,**z,pin,old_perf=-10000.0, new_perf=-1000.0;
	double **driven_data, **parasitic_data, angular_step, scale_factor=1.0;
	double **driven_data_tmp, **parasitic_data_tmp;
	double design_frequency, min_frequency, max_frequency, step_frequency;
	double E_fwd, E_back, H_fwd, H_back, frequency;
	double boom_sd, length_sd;
	struct FCOMPLEX *voltage, *current, input_impedance, z_centre;
	struct element_data *coordinates;
	struct flags flag;
	struct performance_data mean_performance, best_performance;     

	/* Zero all the flags in the structure flag. Some compilers allow
	 me to zero them when I define it in the header file, but not all.
	 Hope this method is less compiler specific. */

	memset(  (char *) &flag , 0, sizeof(flag));
	best_performance.swr=99.0;
	best_performance.gain=-1000;
	best_performance.fb=-1000;
	best_performance.r=1000;
	best_performance.x=1e19;

	opterr=0;
	ofile=string(0L,100L);
	/* Since not all complilers come with the 'getopts' functions, I've
	get a source of it and put it in the distribution of YagiUda. 
	To avoid conflics on unix systems, I've rename it to getoptions */
   while((c=getoptions(argc,argv,"wWchvdgr:C:b:x:f:s:S:G:R:X:F:l:o:e:Z:p:t:T:")) != -1)
   switch       (c) 
   {
			 case 'W':  /* weighted inprovement */
					flag.Wflg=1;
			      break;
			 case 'w':  /* wide band ant wanted - avg at low, design and upper f */
					flag.wflg=2; /* do at three frequencies,  2 extra ones */
			      break;
			 case 'c':  /* Combined SWR/gain and FB sepparately */
					flag.cflg=1;
					break;
			 case 'r':   /* acceptable_resistance_error option */
					flag.rflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -r which requires numeric data.\n");
						exit(1);
					}
					acceptable_resistance_error=atof(optarg);
					if(acceptable_resistance_error < 0.0)
					{
						error_message("The '-r' option setting an acceptable vswr must >=0.0\n");
						exit(1);
					}
			      break;
			 case 'x':   /* acceptable_reactance option */
					flag.xflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -x which requires numeric data.\n");
						exit(1);
					}
					acceptable_reactance=atof(optarg);
					if(acceptable_reactance < 0.0)
					{
						error_message("The '-x' option setting an acceptable reactance must >=0.0\n");
						exit(1);
					}
			      break;
			 case 's':   /* acceptable_vswr option */
					flag.sflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -s which requires numeric data.\n");
						exit(1);
					}
					acceptable_vswr=atof(optarg);
					if(acceptable_vswr < 1.0)
					{
						error_message("The '-s' option setting an acceptable vswr must >= 1.\n");
						exit(1);
					}
			      break;
			 case 'f':   /* acceptable_fb_ratio option */
					flag.fflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -f which requires numeric data.\n");
						exit(1);
					}
					acceptable_fb_ratio=atof(optarg);
					if(acceptable_fb_ratio < 0.0)
					{
						error_message("The '-f' option setting an acceptable FB ratio must >=0.0\n");
						exit(1);
					}
			      break;
			 case 'F':   /* fb_ratio weight */
					flag.Fflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -F which requires numeric data.\n");
						exit(1);
					}
					weight_fb=atof(optarg);
					if(weight_fb < 0.0)
					{
						error_message("The '-F' option setting the weight for FB ratio must >=0.0\n");
						exit(1);
					}
			      break;
			 case 'G':   /* fb_ratio weight */
					flag.Gflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -G which requires numeric data.\n");
						exit(1);
					}
					weight_gain=atof(optarg);
					if(weight_gain < 0.0)
					{
						error_message("The '-G' option setting the weight for gain must >=0.0\n");
						exit(1);
					}
			      break;
			 case 'C':   /* combined gain/swr  weight */
					flag.Cflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -C which requires numeric data.\n");
						exit(1);
					}
					weight_combined=atof(optarg);
					if(weight_combined < 0.0)
					{
						error_message("The '-C' option setting the weight for gain/swr  combined must >=0.0\n");
						exit(1);
					}
			      break;
			 case 'S':   /* weight of tau (related to vswr)*/
					flag.Sflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -S which requires numeric data.\n");
						exit(1);
					}
					weight_tau=atof(optarg);
					if(weight_tau < 0.0)
					{
						error_message("The '-S' option setting the weight for swr must >=0.0\n");
						exit(1);
					}
			      break;
			 case 'l':   /* percentage change in ele positions */
					flag.lflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -l which requires numeric data.\n");
						exit(1);
					}
					percent=atof(optarg);
					if(percent < 0.0)
					{
						error_message("The '-l' option setting the maximum permissable change in the lengths and positions of elements at each iteration (in %%) must be >=0.0\n");
						exit(1);
					}
			      break;
			 case 'o':   /* optimise for gain, fb etc etc */
					flag.oflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -o which requires numeric data.\n");
						exit(1);
					}
					choice=atoi(optarg);
					if(choice < 1 || choice > 63)
					{
						error_message("The '-o' option setting the parameter(s) to optimise for must be in the range 1 to 63.\n");
						exit(1);
					}
			      break;
			 case 'b':   /* how long can boom be extended */
					flag.bflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -b which requires numeric data.\n");
						exit(1);
					}
					boom_factor=atof(optarg);
					if(boom_factor < 0.0)
					{
						error_message("The '-b' option setting the maximum permissable change in the boom length (in %%) must be >=0.0\n");
						exit(1);
					}
			      break;
			 case 'Z':   /* Characteristic impedance */
					flag.Zoflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -Z which requires numeric data.\n");
						exit(1);
					}
					Zo=atof(optarg);
					if(Zo <= 0.0)
					{
						error_message("The '-Z' option setting Zo must be > 0.0\n");
						exit(1);
					}
			      break;
			 case 'e':   /* type of element moved (driven, parasitic or both) */
					flag.eflg=1;
					if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -e which requires numeric data.\n");
						exit(1);
					}
					type_of_elements_moved=atoi(optarg);
					if(type_of_elements_moved < 1 || type_of_elements_moved > 3)
					{
						error_message("The '-Z' option setting Zo must be > 0.0\n");
						exit(1);
					}
			      break;
			 case 'h':
			      flag.hflg=1;
					break;
			 case 'v':
					printf("version = %lf\n", version());
					break;
			 case 'd':
					flag.dflg=1;
					break;
			case 'g':
				flag.gflg=1;
				break;
			case 'p':
				flag.pflg=1;
				if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -p which requires numeric data.\n");
						exit(1);
					}
				popsize=atoi(optarg);
				if(popsize < 2 || popsize > 10000000)
				{
						error_message("The '-p' option setting the population size of the genetric algorithm, mush be between 2 amd 1000000\n");
						exit(1);
				}
				break;
			case 't':
				flag.tflg=1;
				if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -t which requires numeric data.\n");
						exit(1);
					}
				length_sd=atof(optarg); /* SD on lengths, in mm */
				if(length_sd < 0 )
				{
						error_message("The '-t' option setting the standard deviation of the element lengths must be > 0\n");
						exit(1);
				}
				break;
			case 'T':
				flag.Tflg=1;
				if(!isdigit(*optarg) && *optarg !='.')
					{
						error_message("Non numeric data entered for option -T which requires numeric data.\n");
						exit(1);
					}
				boom_sd=atof(optarg); /* SD on lengths, in mm */
				if(boom_sd < 0 )
				{
						error_message("The '-T' option setting the standard deviation of the boom postions must be > 0\n");
						exit(1);
				}
				break;
			 case '?':
			   flag.errflg++;
				break;
	 }
	if( fopen("stop","rt") != NULL) 
	{
		error_message("Remove the file 'stop' first\n");
		exit(1);
	}
	else
			errno=0;
	/* a function check_flags() does all the checking to make sure flags 
	set (by user adding options) are reasonable. It also acts on many of them. */
	check_flags(flag, argc, optind, argv[0]);
	iterations=atoi(argv[optind+1]);

	/* allocate memory for strings */
	input_filename=string(0L,100L);
	line=string(0L,MAX_LINE);
	output_filename=string(0L,100L);
	update_filename=string(0L,100L);
	seedRNG(); 
	/* Create a file showing best gain, fb-ratio etc achieved to date */
	/* This might typically have the name 'antenna.up' */ 
	strcpy(update_filename,argv[optind]); 
	strcat(update_filename,".up");
	update_fp=fopen(update_filename,"wt"); /* Remove filname.up */
	fclose(update_fp);
	strcpy(input_filename,argv[optind]);
	fp=fopen(input_filename,"rt");
	if(fp == NULL)
	{
		fprintf(stderr,"Cant open %s\n", input_filename);
		exit(10);
	}
	else
		fclose(fp);
	strcpy(output_filename,input_filename);
	strcat(output_filename,".bes");
	fp_out=fopen(output_filename,"wb");  /* Remove filname.bes */
	fclose(fp_out);
	/* since the size of all the arrays depends on the number of elements,
	lets first find out how many elements we have, including driven and 
	parasitic sepparately.  Then try to allocate all the memory we need. If we 
	fail, then not much time is wasted. */
	elements=get_number_of_elements(input_filename, &driven, &parasitic);
	/* allocate all memory */
	driven_data=dmatrix(1L,(long)(driven),1L,6L); 
	parasitic_data=dmatrix(1L,(long) (parasitic),1L,4L); 

	driven_data_tmp=dmatrix(1L,(long)(driven),1L,6L); 
	parasitic_data_tmp=dmatrix(1L,(long) (parasitic),1L,4L); 
	z=dmatrix(1L,(long) elements, 1L, elements*2L);
	A=dmatrix(1L, 2L*elements, 1L, 2L*elements);   /* A.x=b for large matrices */
	x=dvector(1L, 2L*elements);
	b=dvector(1L, 2L*elements);

	current=FCOMPLEXvector(1L,(long) elements); 
	voltage=FCOMPLEXvector(1L,(long) elements);

	coordinates=element_data_vector(1,elements); /* x,y &l of centre of ele's */
	v=dvector(1L,2L*elements); 
	indx=ivector(1,2L*elements);

	read_yagi_data(line, input_filename, &design_frequency, &min_frequency,                &max_frequency, &step_frequency, driven, driven_data, parasitic,                parasitic_data,&angular_step);

	/* make a copy of the element data, as we will randomise it */
	errno=0;
	copy_matrix(driven,6,driven_data_tmp,      driven_data);
	copy_matrix(parasitic,4,parasitic_data_tmp,parasitic_data);
	/* Find the maximum likely gain, given the boom length */
	max_gain=determine_maximum_gain2(elements);
	/* If a genetic algorithm is used, call the genetic algorithm
	and exit */
#ifdef DEBUG
	if(errno)
	{
		fprintf(stderr, "errno=%d in optimise.c\n", errno);
		exit(1);
	}
#endif
	if(flag.gflg)
	{
		genetic_algorithm(output_filename, update_filename, flag, design_frequency, min_frequency, max_frequency, step_frequency, angular_step, driven, parasitic, driven_data, parasitic_data, v, z, &pin, voltage, current, &input_impedance, coordinates, A, b, indx); 
		printf("The best design is in a file \"%s\". You should check it thoroughly\n",output_filename);
		printf("and if its better than %s, copy %s to %s\n",input_filename,output_filename, input_filename);
		exit (0);
	}
	if(flag.wflg)
	{
		sprintf(notes,"This has been run through optimise and optimised for wide-band use over the frequency range %.3lf MHz to %.3lfMHz. \n", min_frequency/1e6, max_frequency/1e6);
	}
	for(i=1; i<=iterations; ++i)
	{
		if(!flag.lflg)
		{
			if(i<iterations/4)
				percent=10;
			else if(i>iterations/4 && i < iterations/2)
				percent=1.0;
			else if (i > iterations/2 && i < 3*iterations/4)
				percent=0.1;
			else if(i > 3*iterations/4)
				percent=0.01;
		}
		/* By default falg.wflg is set to zero, hence the following loop
		will be exectude only once. If the flag was set to +2, the loop
		is executed 3 times and we get the average performance */
		for(ii=-1; ii<flag.wflg;++ii)
		{
			if(ii==-1)
			{
				frequency=design_frequency;
				/* Zero mean_performance structure */
				memset((char *) &mean_performance,0,sizeof(mean_performance));
			}
			if(ii==0)
				frequency=min_frequency;
			if(ii==1)
				frequency=max_frequency;
			solve_equations(frequency, driven, parasitic, driven_data, parasitic_data, v, z, &pin, voltage, current, &input_impedance, coordinates, A, b, indx);
			if(ii==-1)
				z_centre=input_impedance;
		   /* compute gain at theta=90, phi=0 (forward direction) */
			gain(90,0,pin,frequency/design_frequency,coordinates,current,elements,&E_fwd,&H_fwd,frequency,design_frequency);
		/* now compute gain in the reverse direction */
			gain(270,0,pin,frequency/design_frequency,coordinates,current,elements,&E_back,&H_back,frequency,design_frequency);
			reflection_coefficient(input_impedance,&magnitude,&phase);
			vswr=calculate_vswr(magnitude);

			mean_performance.tau_sq+=(1-(magnitude*magnitude));
			mean_performance.gain+=E_fwd;
			mean_performance.fb+=(E_fwd-E_back);
			mean_performance.swr+=vswr;
			mean_performance.r=input_impedance.r;   /* in Ohms */
			mean_performance.x=input_impedance.i;   /* in Ohms */
		}
		if(flag.wflg)
		{
			mean_performance.gain/=3.0; 
			mean_performance.fb/=3.0; 
			mean_performance.tau_sq/=3.0;
			mean_performance.swr/=3.0;
		}
		if(flag.Wflg || flag.gflg)
		{
			old_perf=performance(flag, best_performance, max_gain, acceptable_fb_ratio, weight_gain,weight_fb,weight_tau, weight_combined);
			new_perf=performance(flag, mean_performance, max_gain, acceptable_fb_ratio,weight_gain,weight_fb,weight_tau, weight_combined);
			if(new_perf > old_perf)
				better=TRUE;
			else
				better=FALSE;
		}
		else
			better=is_it_better(choice,mean_performance,best_performance);
		if(better==TRUE && !flag.Tflg)
		{
			/* The function do_since_better() does most things that need to
			be done if we have a better design. These include writing the 
			new antenna description to disk, print the new performance to disk 
			and to stdout, etc */  

			/* We write the input impedance at the centre of the band - not
			averaging, but the svwr is averaged */

			do_since_better(i,output_filename, update_filename, z_centre, mean_performance, flag, notes, design_frequency, min_frequency,max_frequency, step_frequency, elements, driven, parasitic,angular_step,driven_data,parasitic_data,scale_factor, new_perf); 
			/* now set the best performance to the performance of this iteration*/

			best_performance=mean_performance;
			copy_matrix(driven,6,driven_data_tmp,driven_data);
			copy_matrix(parasitic,4,parasitic_data_tmp,parasitic_data);
		}
		else if (better == FALSE || flag.Tflg) /* no improvement */
		{
			copy_matrix(driven,6,driven_data, driven_data_tmp);
			copy_matrix(parasitic,4,parasitic_data,parasitic_data_tmp);
			if(flag.Tflg) /* Want to find the sensitivity to constuction errors */
			{
				if(mean_performance.gain<lowest_gain)
					lowest_gain=mean_performance.gain;
				if(mean_performance.fb<lowest_fb)
					lowest_fb=mean_performance.fb;
				if(mean_performance.swr > highest_vswr)
					highest_vswr=mean_performance.swr;
			}
		}
      /* The following line looks for a file 'stop' in the current directory
		and stops next time if it finds it. For  DOS use, calling the function
		kbhit() - keyboard hit, might be better, so the user kits the keyboard
		to stop the program. We pause after 100 iterations. With a much faster/
		slower machine, you might want to change this */
		if(i%100==0)
		{
			if(fopen("stop","rt") != NULL)
				i=iterations;  /* force it to exit very soon */
			errno=0; /* Will be set to non zero if file dont exist */
			printf("%d\r", i);
		} 
		if(!flag.Tflg) /* user does want to test sensitivity */      
			randomise(type_of_elements_moved, design_frequency/1e6, percent, driven_data, parasitic_data, driven, parasitic); 
		else if(flag.Tflg)
			sensitivity(boom_sd, length_sd, driven_data, parasitic_data, driven, parasitic); 

	} /* End of main loop, now finished trying to better the design */
	if(!flag.Tflg)
	{
		printf("The best design is in a file \"%s\". You should check it thoroughly\n",output_filename);
		printf("and if its better than %s, copy %s to %s\n",input_filename,output_filename, input_filename);
	}
	else if (flag.Tflg) /* find worst design */
	{
		printf("Worst ever parameters using your constructional errors are:\n");
		printf("gain = %.3lfdBi, FB = %.3lf dB, vswr = %.3lf:1\n", lowest_gain, lowest_fb, highest_vswr);
	} 

	/* free strings */
	free_string(input_filename, 0L,100L);
	free_string(line, 0L, MAX_LINE);
	free_string(update_filename, 0L, 100L);
	free_string(output_filename,0L, 100L);
	free_string(ofile,0L,100L);
	/* free vectors */
	free_dvector(x,1L, 2L*elements);
	free_dvector(b,1L, 2L*elements);
	free_dvector(v,1L,2L*elements); 
	free_ivector(indx, 1L, 2L*elements);
	/* free matrices */
	free_dmatrix(z,1L,(long) elements, 1L, elements*2L);
	free_dmatrix(A,1L, 2L*elements, 1L, 2L*elements);
	free_dmatrix(driven_data,1L,(long)(driven),1L,6L); 
	free_dmatrix(parasitic_data,1L,(long) (parasitic),1L,4L); 
	free_dmatrix(driven_data_tmp,1L,(long)(driven),1L,6L); 
	free_dmatrix(parasitic_data_tmp,1L,(long) (parasitic),1L,4L); 
	/* free FCOMPLEX vectors */
	free_FCOMPLEXvector(current, 1L,(long) elements); 
	free_FCOMPLEXvector(voltage, 1L,(long) elements);
	free_element_data_vector(coordinates,1,elements);
}
