'       nv.bas: viewer for NEC-2 input files

'             9 Nov 95: quick change to add origin movement

'       Written by David de Schweinitz <dave.des@metronet.com>
'       Distribute freely.
'
'       I wrote this to get a quick look at simple geometry files.  I tried
'       to clean it up some before I sent it out, but not much.  Please let
'       me know if it's any use.  Suggestions, enhancements, or pointers
'       to other (preferably free) related programs would be appreciated.
'
'       This program will run with under QBasic with one minor change
'       (noted below), but it is much faster in QuickBasic.  If it's
'       too slow on a machine that does not a math co-processor, try
'       compiling it with QuickBasic 3.0.  It should run much faster.
'       Be careful running any QuickBasic 3.0 executable with graphics
'       calls while running MS Windows, however.  I've had problems with
'       major system crashes running similar programs at full-screen DOS
'       prompt under Windows.  I've had no problems with QuickBasic 4.5
'       executables (like the one distributed with this listing).  They
'       usually will not run in a window, but do fine full -screen.
'
'       This program only reads GW cards.  It doesn't handle groundplanes or
'       arcs or anything else.  It wouldn't take much to add these functions,
'       in anyone's interested.  If I do any more enhancement to the program,
'       It'll probably be to add some editing capability.
'
'       If you see a bunch of % signs in the number displays, that indicates
'       that the wire parameters are too big or too small for the fixed
'       decimal format I used.  You may need to edit these lines if you want
'       to read the numbers.
'
'       Two example files are included with this program.  CAR_C.NEC and
'       CAR_S.NEC are comma- and space-delimited files generated using
'       the Univ. of Stellenbosch WIREGRID program.
'
'       Good luck and have fun!
'                                       Dave

DECLARE FUNCTION XP! (X!, Y!, Z!, PHI!, THETA!)

DECLARE FUNCTION YP! (X!, Y!, Z!, PHI!, THETA!)

     COMMON SHARED deg2rad
     deg2rad = 4 * ATN(1) / 180
     NUUM% = 10000   '   Maximum number of wires
     DIM NSEG%(NUUM%), x1(NUUM%), y1(NUUM%), z1(NUUM%), x2(NUUM%), y2(NUUM%), z2(NUUM%), rad(NUUM%)
     DIM NTAG%(NUUM%)
     CONST ESC = 27, DOWN = 80, UP = 72, LEFT = 75, RIGHT = 77
     CONST HOME = 71, ENDKEY = 79, PGDN = 81, PGUP = 73
   
     CLS
     WIDTH 80, 43
     SCREEN 9
     LINECOL% = 14: SLINECOL% = 12   '  Line colors (changable)
     XAXISCOL% = 5: YAXISCOL% = 2: ZAXISCOL% = 7: SHEETCOL% = 8:

'    If running from an interpeter insert file name here or use INPUT command.
    
     NECFILE$ = COMMAND$      'reads NEC input file name from command line.
     IF NECFILE$ = "" THEN
       PRINT "Usage: nv FILE, where FILE is NEC input file"
     END IF

'    This program first tries to read the file as space-delimited.  If it
'    is comma-delimited, the file is closed, re-opened and then re-read.
'    I'm sure that there must be a more elegant way to do this, but this
'    seems to work OK.
'    If you use one type exclusively you may want to edit the following
'    lines accordingly.
      
     DISTSQD = 0      ' Initialize value used to scale screen.
     OPEN NECFILE$ FOR INPUT AS #1
     delimtype$ = ""
     n% = 1
'    Skip through the comment cards:
     DO
       LINE INPUT #1, j$
       IF LEFT$(j$, 2) = "CE" THEN EXIT DO
     LOOP
     DO
       LINE INPUT #1, j$
       IF LEFT$(j$, 2) = "GS" OR LEFT$(j$, 2) = "GE" THEN EXIT DO
       IF LEFT$(j$, 2) = "GW" THEN   ' Skip any non-GW cards
         IF n% = 1 THEN   'Check first GW card for commas:
           FOR m% = 1 TO LEN(j$) - 1
             IF MID$(j$, m%, 1) = "," OR MID$(j$, m%, 1) = ";" THEN
               delimtype$ = "comma"
               EXIT FOR
             END IF
           NEXT m%
           IF delimtype$ = "comma" THEN EXIT DO
         END IF
         NTAG%(n%) = VAL(MID$(j$, 3, 3))
         NSEG%(n%) = VAL(MID$(j$, 6, 5))
         x1(n%) = VAL(MID$(j$, 11, 10)): y1(n%) = VAL(MID$(j$, 21, 10)): z1(n%) = VAL(MID$(j$, 31, 10))
         x2(n%) = VAL(MID$(j$, 41, 10)): y2(n%) = VAL(MID$(j$, 51, 10)): z2(n%) = VAL(MID$(j$, 61, 10))
         rad(n%) = VAL(MID$(j$, 71, 10))
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
         IF DISTSQD > height THEN height = DISTSQD
         n% = n% + 1
       END IF
     LOOP
     CLOSE #1
     IF delimtype$ = "comma" THEN GOSUB commadelim
     height = 1.1 * SQR(height)  'Scale display to fit input file
     XPMIN = -height / 2: YPMIN = -height / 2
     GOSUB newwindow
     nmax% = n% - 1
    
     PHI = 320: THETA = 60

     LOCATE 2, 68: PRINT "AXIS LENGTH:"
     LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
     LOCATE 6, 68: PRINT " PGUP/PGDN "
     LOCATE 7, 68: PRINT "    KEYS"
     LOCATE 8, 68: PRINT "CHANGE SCALE"
     LOCATE 12, 68: PRINT " PHI THETA"
     LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
     LOCATE 16, 68: PRINT " ARROW KEYS"
     LOCATE 17, 68: PRINT "  TO ROTATE"
     LOCATE 20, 68: PRINT "2-4-6-8-0:"
     LOCATE 21, 68: PRINT " SHIFT AXES"
    
     LOCATE 24, 68: PRINT "  +/-,n"
     LOCATE 25, 68: PRINT "TO HIGHLIGHT"
     LOCATE 26, 68: PRINT "   A WIRE:"
     LOCATE 27, 68: PRINT " DATA BELOW"
     LOCATE 31, 68: PRINT "L,S,X,Y,Z"
     LOCATE 32, 68: PRINT "CHANGE COLORS"
     LOCATE 34, 68: PRINT "  <ESC>"
     LOCATE 35, 68: PRINT "   TO"
     LOCATE 36, 68: PRINT "  QUIT"
     LOCATE 40, 1: PRINT "CARD TAG SEGS    X1       Y1       Z1       X2       Y2       Z2      RAD   "
   
     hn% = 1
     LOCATE 41, 1: PRINT USING "####"; hn%;
     PRINT USING " ###"; NTAG%(hn%);
     PRINT USING " ###"; NSEG%(hn%);
     PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
    
DRAWIT:
     VIEW (10, 10)-(530, 290), SHEETCOL%   ' re-draws the background
'    The XP and YP functions do the coordinate rotation
     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(height / 4, 0, 0, PHI, THETA): YP2 = YP(height / 4, 0, 0, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), XAXISCOL%
     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(0, height / 4, 0, PHI, THETA): YP2 = YP(0, height / 4, 0, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), YAXISCOL%
     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(0, 0, height / 4, PHI, THETA): YP2 = YP(0, 0, height / 4, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), ZAXISCOL%
     FOR n% = 1 TO nmax%
       XP1 = XP(x1(n%), y1(n%), z1(n%), PHI, THETA): YP1 = YP(x1(n%), y1(n%), z1(n%), PHI, THETA)
       XP2 = XP(x2(n%), y2(n%), z2(n%), PHI, THETA): YP2 = YP(x2(n%), y2(n%), z2(n%), PHI, THETA)
       LINE (XP1, YP1)-(XP2, YP2), LINECOL%
     NEXT n%
     XP1 = XP(x1(hn%), y1(hn%), z1(hn%), PHI, THETA): YP1 = YP(x1(hn%), y1(hn%), z1(hn%), PHI, THETA)
     XP2 = XP(x2(hn%), y2(hn%), z2(hn%), PHI, THETA): YP2 = YP(x2(hn%), y2(hn%), z2(hn%), PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), SLINECOL%

     DO
       test$ = INKEY$
     LOOP WHILE test$ = ""
     ' Convert 2-byte extended code to 1-byte ASCII code and handle
     test$ = RIGHT$(test$, 1)
     SELECT CASE test$
       CASE CHR$(PGUP) 'REDUCE SCALE
         VIEW (10, 10)-(530, 290), SHEETCOL%
         height = 2 ^ .25 * height
         LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
         XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
       CASE CHR$(PGDN) 'EXPAND SCALE
         height = 1 / 2 ^ .25 * height
         LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
         XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
       CASE "6" 'move to right
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "4" 'move to left
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "8" 'move up
         yoffset = yoffset - height / 10
         GOSUB newwindow
       CASE "2" 'move down
         yoffset = yoffset + height / 10
         GOSUB newwindow
       CASE "9" 'move up and right
         yoffset = yoffset - height / 10
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "7" 'move up and left
         yoffset = yoffset - height / 10
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "3" 'move down and right
         yoffset = yoffset + height / 10
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "1" 'move down and left
         yoffset = yoffset + height / 10
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "0" 'back to origin
         xoffset = 0: yoffset = 0
         GOSUB newwindow
       CASE CHR$(RIGHT)
         PHI = PHI + 10
         IF PHI >= 360 THEN PHI = PHI - 360
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(LEFT)
         PHI = PHI - 10
         IF PHI < 0 THEN PHI = PHI + 360
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(UP)
         THETA = THETA + 10
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(DOWN)
         THETA = THETA - 10
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE "-"
         hn% = hn% - 1: IF hn% < 1 THEN hn% = nmax%
         LOCATE 41, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###"; NSEG%(hn%);
         PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
       CASE "+"
         hn% = hn% + 1: IF hn% > nmax% THEN hn% = 1
         LOCATE 41, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###"; NSEG%(hn%);
         PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
       CASE "n", "N"
         LOCATE 20, 10: INPUT "Enter segment number"; hn%
         IF hn% < 1 THEN hn% = 1
         IF hn% > nmax% THEN hn% = nmax%
         LOCATE 41, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###"; NSEG%(hn%);
         PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
       CASE "l", "L"
         LINECOL% = LINECOL% + 1
         IF LINECOL% > 15 THEN LINECOL% = 0
       CASE "s", "S"
         SLINECOL% = SLINECOL% + 1
         IF SLINECOL% > 15 THEN SLINECOL% = 0
       CASE "x", "X"
         XAXISCOL% = XAXISCOL% + 1
         IF XAXISCOL% > 15 THEN XAXISCOL% = 0
       CASE "y", "Y"
         YAXISCOL% = YAXISCOL% + 1
         IF YAXISCOL% > 15 THEN YAXISCOL% = 0
       CASE "z", "Z"
         ZAXISCOL% = ZAXISCOL% + 1
         IF ZAXISCOL% > 15 THEN ZAXISCOL% = 0
       CASE "b", "B"
         SHEETCOL% = SHEETCOL% + 1
         IF SHEETCOL% > 15 THEN SHEETCOL% = 0
       CASE CHR$(ESC)
         GOTO DONE
     END SELECT
     GOTO DRAWIT

DONE:
     STOP
     END

commadelim:         'read comma-delimited NEC-2 input file
     OPEN NECFILE$ FOR INPUT AS #1
     n% = 1
'    Skip through the comment cards:
     DO
       LINE INPUT #1, j$
       IF LEFT$(j$, 2) = "CE" THEN EXIT DO
     LOOP
'    Read geometry cards. Quit at GS or GE
     DO
       INPUT #1, j$
       IF j$ = "GS" OR j$ = "GE" THEN EXIT DO
       IF j$ = "GW" THEN    'Skip any non-GW cards
         INPUT #1, NTAG%(n%), NSEG%(n%), x1(n%), y1(n%), z1(n%), x2(n%), y2(n%), z2(n%), rad(n%)
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
         IF DISTSQD > height THEN height = DISTSQD
         n% = n% + 1
       END IF
     LOOP
     CLOSE #1
     RETURN

newwindow:
     WINDOW (XPMIN + xoffset, YPMIN + yoffset)-(1.4 * height + XPMIN + xoffset, height + YPMIN + yoffset)
     RETURN
    
     END

     FUNCTION XP (X, Y, Z, PHI, THETA)
'       deg2rad = ATN(1!) / 45
       XP = -X * SIN(PHI * deg2rad) + Y * COS(PHI * deg2rad)
     END FUNCTION

     FUNCTION YP (X, Y, Z, PHI, THETA)
'      deg2rad = ATN(1!) / 45
      YP = Z * SIN(THETA * deg2rad) - X * COS(THETA * deg2rad) * COS(PHI * deg2rad) - Y * COS(THETA * deg2rad) * SIN(PHI * deg2rad)
     END FUNCTION

