#ifndef FILE_H
#define FILE_H

//------------------------------------------------------------------------------
// Copyright (c), 1997 Ralph Holland
// History:
// 000: 26 Apr 97, RBH - Initial Writing
// Description:
// Contains File function definitions
//------------------------------------------------------------------------------

#include <dir.h>   	// mkdir, opendir
#include <io.h>     	// access
#include "stand.h"   // standard types

	// Implement missing 32 bit functions
#ifndef __WIN32__
	void CopyFile(const char *fromPath,const char *toPath,bool doNotOverwrite=false);
   void DeleteFile(const char *path);
#else
	#include <windows.h>
#endif

//---------------------------
// Utility functions
//---------------------------
inline bool Exists(const char *pathName) {
	return access(pathName,0x00)==0; // exist access
}


#endif