
'===============================================
' Plots patterns   output files
'                        By Agostino Rolando
'                        Last rev.  Jan. 28 1998
'===============================================

DECLARE SUB draw3d (scale.f, sc.f, graph.type$, what$, cut$, ang.offset)
DECLARE SUB dsplay3d (d, scale.f, sc.f, graph.type$, what$, cut$, ang.offset)
DECLARE SUB dsplay (d, scale.f, sc.f, graph.type$, what$, cut$, ang.offset)
DECLARE SUB drawsit (graph.type$, what$, cut$, path$, extn$)
DECLARE SUB plotter (f$, path$, sc.f, scale.f, ang.offset, what$)
DECLARE SUB freader.bas (graph.type$, what$, cut$, path$, extn$, necfile$)
DECLARE SUB sort (lne$, graph.type$, what$, cut$)
DECLARE SUB config (option$, graph.type$, what$, cuts$, path$, extn$)
DECLARE SUB fmax (scale.f, graph.type$, what$, cut$, path$, extn$)
DECLARE SUB printer ()

'
DECLARE FUNCTION XP! (x!, y!, z!, PHI!, THETA!)
DECLARE FUNCTION YP! (x!, y!, z!, PHI!, THETA!)

'===========================================
'array for pattern data

DIM SHARED necfile$, pointer, ang.step, ang.start, ang.offset
COMMON SHARED deg2rad   ' conversion 60-rad

DIM SHARED MAXVAL
DIM SHARED d
MAXVAL = 3000
'array for pattern data
DIM SHARED values(4, MAXVAL)
DIM SHARED maxgain, zreal$, zimag$, freq$, wave$
'===========================================
' MAIN LOOP
'

'CLS
'    If running from an interpeter insert file name here or use INPUT command.
    
necfile$ = COMMAND$      'reads NEC input file name from command line.
IF necfile$ = "" THEN
  PRINT "Usage: postproc FILE, where FILE is NEC output file"
END IF

IF necfile$ = "" THEN
  INPUT "Enter filename"; necfile$
  PRINT necfile$
END IF

'PRINT "LOADING DATA..."

f$ = necfile$
filename$ = f$

config "", graph.type$, what$, cut$, path$, extn$
'go and get data from file

PRINT "loading data ..."

freader.bas graph.type$, what$, cut$, path$, extn$, necfile$


conf$ = "config.dat"
menu$ = ""
graph.type = polar
what = both
cut = VRP

fmax scale.f, graph.type$, what$, cut$, path$, extn$

sc.f = 1
ang.offset = 0
olx = 0
oly = 0

'========================================================


WHILE option$ <> "Q"

SCREEN 0
VIEW PRINT
COLOR 14, 1
CLS
option$ = ""
PRINT
PRINT
PRINT
PRINT
PRINT "                      N E C    P O S T   P R O C E S S O R"
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT , "           '2'  2D Display pattern"
PRINT , "           '3'  3D Display pattern"
PRINT , "           'C'  Change program defaults"
PRINT , "           'Q'  Quit"
PRINT
PRINT

PRINT

PRINT
PRINT
PRINT
PRINT
PRINT
PRINT "      Rev 2.1                                              By  A. Rolando"


WHILE option$ = ""
 option$ = UCASE$(INKEY$)
WEND
'VIEW PRINT
'=========================================================
SELECT CASE option$ <> ""

       CASE option$ = "2"
 '
           drawsit graph.type$, what$, cut$, path$, extn$

       CASE option$ = "3"
           draw3d scale.f, sc.f, graph.type$, what$, cut$, ang.offset

       CASE option$ = "C"
           config option$, graph.type$, what$, cut$, path$, extn$

       CASE option$ = "Q"
END SELECT

WEND

SCREEN 0
COLOR 7, 0
CLS
END


'============================================================
'end of main
'============================================================

'============================================================
' ROUTINES
'
SUB config (option$, graph.type$, what$, cut$, path$, extn$)

' FIle that holds configuration
conf$ = "config.dat"
menu$ = ""

CLS
'some options
'graph.type :- polar-lin lin-lin
'what :- vp hp both
'cut :- HRP VRP



'this bit gets existing config
OPEN conf$ FOR INPUT AS #8
INPUT #8, graph.type$
INPUT #8, what$
INPUT #8, cut$
INPUT #8, path$
INPUT #8, extn$
CLOSE #8

'options menu
IF option$ <> "C" THEN GOTO fin
CLS
PRINT
PRINT
PRINT
PRINT
PRINT , "          The existing configuation is...."
PRINT
PRINT , "        'T'race to be plotted is "; what$
'PRINT , "'C'ut is "; cut$
'PRINT , "'P'ath for files "; path$
'PRINT , "'F'ile extension "; extn$
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT , "          Hit key for option"

WHILE menu$ = ""
   menu$ = UCASE$(INKEY$)
WEND
option$ = ""

IF menu$ = "F" THEN
   option$ = "@"
   menu$ = ""
   INPUT "Enter new default file extension"; extn$
END IF

IF menu$ = "P" THEN
   option$ = "@"
   menu$ = ""
   INPUT "Enter new default path"; path$
END IF

CLS
PRINT
SELECT CASE menu$ <> ""
       CASE menu$ = "T"
           PRINT , , "'H'orizontal"
           PRINT , , "'V'ertical"
           PRINT , , "'B'oth"
           PRINT
           PRINT , , "Hit key for option "

       CASE menu$ = "C"
           PRINT , , "H'o'rizontal radiation pattern"
           PRINT , , "Ver't'ical radiation pattern"
           PRINT
           PRINT , , "Hit key for option "
END SELECT


WHILE option$ = ""
  option$ = UCASE$(INKEY$)
WEND


SELECT CASE option$ <> ""

      CASE option$ = "P"
          graph.type$ = "polar"
      CASE option$ = "a"
          graph.type$ = "lpolar"
      CASE option$ = "L"
          graph.type$ = "linear"
      CASE option$ = "H"
          what$ = "hp"
      CASE option$ = "V"
          what$ = "vp"
      CASE option$ = "B"
          what$ = "both"
      CASE option$ = "O"
          cut$ = "HRP"
      CASE option$ = "T"
          cut$ = "VRP"

END SELECT

'This saves new config
OPEN conf$ FOR OUTPUT AS #8
PRINT #8, graph.type$
PRINT #8, what$
PRINT #8, cut$
PRINT #8, path$
PRINT #8, extn$
CLOSE #8

fin:
END SUB

'====================================================================
' DRAW 3D
'====================================================================
SUB draw3d (scale.f, sc.f, graph.type$, what$, cut$, ang.offset)
 
SHARED f$
SHARED deg2rad
SHARED max, sumh, sumv
SHARED values()
SHARED ang.end, ang.step, ang.start, pointer
     
'=======================
'Now to plot patterns

'IF what$ = "vp" THEN d = 2 ELSE d = 0
'IF what$ = "hp" THEN d = 3
'IF what$ = "both" THEN

d = 2

' FOR d = 2 TO 3
      dsplay3d d, scale.f, sc.f, graph.type$, what$, cut$, ang.offset
' NEXT d

'ELSE
'       dsplay3d d, scale.f, sc.f, graph.type$, what$, cut$, ang.offset
'END IF


END SUB

'========================================================================
' ROUTINE DRAW 2D
'========================================================================
SUB drawsit (graph.type$, what$, cut$, path$, extn$)
SHARED max, sumh, sumv
'max used for auto scaling sumh and sumv used for mean gain calculation

config "", graph.type$, what$, cut$, path$, extn$
'=======================
'routine to draw pattern on screen
'=======================
'go and get data from file
'freader.bas graph.type$, what$, cut$, path$, extn$, f$
sc.f = 1
ang.offset = 0
' adjust offset

'FOR qq = 1 TO 7
'  ang.offset = (ang.offset - .08727)
'NEXT

olx = 0
oly = 0
fmax scale.f, graph.type$, what$, cut$, path$, extn$

here:
'graphics screen mode
SCREEN 12

WHILE k$ <> " "
'=======================
'This bit does graticule
xcenter = 320
ycenter = 240
radi = 200

FOR g = 1 TO 10
  CIRCLE (xcenter, ycenter), radi * g / 10, 5
NEXT g

FOR ang = 0 TO 350 STEP 10
  a = ang * .01745
  LINE (xcenter - SIN(a) * 20, ycenter - COS(a) * 20)-(xcenter - SIN(a) * radi, ycenter - COS(a) * radi), 5
NEXT ang

' Indica gli assi X e Y della struttura
'
LINE (2 * xcenter - 100, ycenter + 4)-(2 * xcenter - 100 + 4, ycenter - 4), 7
LINE (2 * xcenter - 100, ycenter + 4)-(2 * xcenter - 100 + 4, ycenter - 4), 7
LINE (2 * xcenter - 100, ycenter - 4)-(2 * xcenter - 100 + 4, ycenter + 4), 7
LINE (2 * xcenter - 100, ycenter - 4)-(2 * xcenter - 100 + 4, ycenter + 4), 7

LINE (xcenter, 2 * ycenter - 20 + 5)-(xcenter + 5, 2 * ycenter - 20 - 5), 7
LINE (xcenter, 2 * ycenter - 20 + 5)-(xcenter + 5, 2 * ycenter - 20 - 5), 7
LINE (xcenter, 2 * ycenter - 20 - 5)-(xcenter + 5 - 2, 2 * ycenter - 20 - 2), 7
LINE (xcenter, 2 * ycenter - 20 - 5)-(xcenter + 5 - 2, 2 * ycenter - 20 - 2), 7

 

'=======================
'Now to plot patterns
d = 0
IF what$ = "vp" THEN d = 2
IF what$ = "hp" THEN d = 3
IF what$ = "both" THEN

   FOR d = 2 TO 3
      dsplay d, scale.f, sc.f, graph.type$, what$, cut$, ang.offset
   NEXT d

ELSE
   dsplay d, scale.f, sc.f, graph.type$, what$, cut$, ang.offset
END IF


'=====================================
' "Hit Any key"
VIEW PRINT 30 TO 30
'PRINT "Use < > keys to rotate trace. Space when done. Offset=";
'PRINT USING "###.#"; (ang.offset / .0174533);
'PRINT " degrees";
PRINT "                                                     P to print , <ESC> to exit";

ripeti:
k$ = ""
WHILE k$ = ""
  k$ = INKEY$
WEND

IF (k$ = "P") OR (k$ = "p") THEN
printer
GOTO ripeti:
END IF


GOTO escidiqui:

'.08727 is 10 degrees could be made smaller

IF k$ = "." OR k$ = ">" THEN ang.offset = (ang.offset + .08727)
IF k$ = "<" OR k$ = "," THEN ang.offset = (ang.offset - .08727)
IF k$ <> " " AND k$ <> "." AND k$ <> "," AND k$ <> "<" AND k$ <> ">" THEN k$ = " "
IF k$ <> " " THEN CLS
WEND

PRINT "Press S to scale trace or space for next option"
k$ = ""
WHILE k$ = ""
  k$ = UCASE$(INKEY$)
WEND
mgv = (sumv * sc.f * sc.f / (max * max * 3.14159))
mgh = (sumh * sc.f * sc.f / (max * max * 3.14159))

IF k$ = "M" THEN PRINT "vp "; mgv, "hp "; mgh

IF k$ = "M" THEN k$ = ""
WHILE k$ = ""
  k$ = UCASE$(INKEY$)
WEND


IF k$ = "S" THEN
  S$ = "0"
  DO UNTIL VAL(S$) > 0
   INPUT "Enter new scale factor of trace"; S$
  LOOP
  sc.f = sc.f * VAL(S$)
  PRINT sc.f
  CLS
  GOTO here
END IF

PRINT "Press P for HPGL plot or space to end"
k$ = ""
WHILE k$ = ""
  k$ = UCASE$(INKEY$)
WEND
IF k$ = "P" THEN plotter f$, path$, sc.f, scale.f, ang.offset, what$


escidiqui:
SCREEN 0
END SUB

'=====================================================================
' 2D display pattern on screen
'1111
'
SUB dsplay (d, scale.f, sc.f, graph.type$, what$, cut$, ang.offset)
SHARED ang.end, ang.step, ang.start, pointer
SHARED deg2rad, zreal$, zimag$, freq$, wave$, maxgain
SHARED max, sumh, sumv
SHARED values()

' this doesn't work when you rotate trace. Must be corrected.
VIEW PRINT
LOCATE 2, 1
'VIEW PRINT 2 TO 5
PRINT "IMPEDANCE= "; zreal$; " +j "; zimag$
PRINT wave$
PRINT freq$
PRINT "NORM. GAIN= "; maxgain; " dBi"
VIEW PRINT 28 TO 29
'PRINT "                                                                  ";
COLOR 14
PRINT "Vertical"
'PRINT "                                                                  ";
COLOR 15
PRINT "Horizontal";
delta = ang.end - ang.start     ' 360
 
 
'========================================
'
'  values(1) = theta
'  values(2) = theta-magnitude
'  values(3) = phi-magnitude
'  values(4) = phi
'
'========================================

' find the range in which the VERTICAL patt. is max
IF d = 2 THEN

'd = 2
maxyy = values(2, 1) 'theta-magnitude
startyy = 0
totvalori = 0        ' 360 * ??
conta = 1
massimi = 0
range = 0
'PRINT "values read = "; pointer - delta / ang.step
'- delta / ang.step
maxtheta = 0
FOR a = 2 TO pointer - delta / ang.step
' pointer=n.o of elements ,da 0 a 360 * ??

    valu = values(2, a)

    conta = conta + 1
    IF conta = delta / ang.step THEN
          conta = 0
          totvalori = totvalori + delta / ang.step
    END IF

    IF valu > maxyy THEN
                 maxyy = valu
                 maxtheta = values(1, a)
                 massimi = massimi + 1
                 range = totvalori
    END IF
   
NEXT a

' Qui maxyy = max di theta-magnitude,cioe' il max valore del
' pattern verticale
' e maxtheta = angolo a cui si ha tale max.
'PRINT "maxtheta = ", maxtheta
'INPUT ; qq

' delta / ang.step = valori da visualizzare in 1 range
startyy = range

'startyy = totvalori + massimi  '420 --> 427
 
'startyy = starting value for maximum y values range
' Now I can trace points

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

olx = values(1, 1 + startyy) * .017453 + ang.offset
valu = values(2, 1 + startyy)
oly = valu

'PRINT "theta = ", ang.start, ang.end
'PRINT "delta.phi   = ", (startyy / (delta / ang.step)) * ang.step


FOR a = 2 TO delta / ang.step + 2    'last "a" value = 62
   x = values(1, startyy + a) * .017453 + ang.offset
   valu = values(2, a + startyy)
   y = valu
  
   LINE (320 + (SIN(olx) * oly * scale.f * sc.f), 240 - (COS(olx) * oly * scale.f * sc.f))-(320 + (SIN(x) * y * scale.f * sc.f), 240 - (COS(x) * y * scale.f * sc.f)), d + 12
   olx = x
   oly = y
NEXT a


'===== NOW I REPEAT THE SAME ROUTINE, BUT FOR HOR. PATT. ======


' cerco il max dei phi-values entro ciascun "pacchetto" ampio delta
 ELSE     'd = 3

'===========
' mi calcolo COMUNQUE il maxtheta
'
'come se fosse d = 2
maxyy = values(2, 1) 'theta-magnitude
startyy = 0
totvalori = 0        ' 360 * ??
conta = 1
massimi = 0
range = 0
'PRINT "values read = "; pointer - delta / ang.step
'- delta / ang.step
maxtheta = 0
FOR a = 2 TO pointer - delta / ang.step
' pointer=n.o of elements ,da 0 a 360 * ??

    valu = values(2, a)

    conta = conta + 1
    IF conta = delta / ang.step THEN
          conta = 0
          totvalori = totvalori + delta / ang.step
    END IF

    IF valu > maxyy THEN
                 maxyy = valu
                 maxtheta = values(1, a)
                 massimi = massimi + 1
                 range = totvalori
    END IF
  
NEXT a

' Qui maxyy = max di theta-magnitude,cioe' il max valore del
' pattern verticale
' e maxtheta = angolo a cui si ha tale max.

' Devo applicare un angolo di offset per il disegno del
' pattern orizz. poiche' devono coincidere i versi dei massimi
' dei due pattern.

OFFANG = maxtheta - 360
'PRINT "offang=", OFFANG
'INPUT ; qqq



maxphi = -999.999
FOR a = 1 TO delta / ang.step
    valuphi = values(2, a)   'phi-magnitude
    IF valuphi > maxphi THEN
      maxphi = valuphi
      olxx = values(1, a)
      olxxx = values(4, a)
      olx = (OFFANG - values(4, a)) * .017453 + ang.offset
      oly = values(2, a)
      olyy = values(2, a)
    END IF
NEXT a
 

aa = delta / ang.step + 1
DO
maxphi = -999.999
FOR a = aa TO aa + delta / ang.step
    IF values(1, a) = olxx THEN
    valuphi = values(2, a)   'phi-magnitude
    
      maxphi = valuphi
      xx = values(4, a)
      x = (OFFANG - values(4, a)) * .017453 + ang.offset
      y = values(2, a)
    END IF
NEXT a
 

   LINE (320 + (SIN(olx) * oly * scale.f * sc.f), 240 - (COS(olx) * oly * scale.f * sc.f))-(320 + (SIN(x) * y * scale.f * sc.f), 240 - (COS(x) * y * scale.f * sc.f)), d + 12
   olx = x
   oly = y

aa = aa + delta / ang.step
LOOP WHILE aa < (pointer - (delta / ang.step))
     
      x = (OFFANG - olxxx) * .017453 + ang.offset
      y = olyy
  
   LINE (320 + (SIN(olx) * oly * scale.f * sc.f), 240 - (COS(olx) * oly * scale.f * sc.f))-(320 + (SIN(x) * y * scale.f * sc.f), 240 - (COS(x) * y * scale.f * sc.f)), d + 12


END IF

'===================================================
END SUB

SUB dsplay3d (d, scale.f, sc.f, graph.type$, what$, cut$, ang.offset)
SHARED ang.end, ang.step, ang.start, pointer, values
SHARED deg2rad
SHARED max, sumh, sumv
SHARED values(), maxgain, zreal$, zimag$, freq$, wave$
'SHARED ang.end, ang.step, ang.start, pointer


'max used for auto scaling sumh and sumv used for mean gain calculation

     deg2rad = 4 * ATN(1) / 180
     nuum% = 1000   '   Maximum number of wires
     DIM x1(nuum%), y1(nuum%), z1(nuum%), x2(nuum%), y2(nuum%), z2(nuum%), rad(nuum%)
     DIM Nseg(nuum%), XC(nuum%), YC(nuum%), ZC(nuum%)
     DIM NTAG%(nuum%)
     DIM curmag(nuum%), curph(nuum%)
     DIM ampshade%(15)
     CONST ESC = 27, DOWN = 80, UP = 72, LEFT = 75, RIGHT = 77
     CONST HOME = 71, ENDKEY = 79, PGDN = 81, PGUP = 73
   
     CLS
     WIDTH 80, 43
     SCREEN 9

'===================== COLORS =================================

     NERO = 0: VIOLASCU = 5: VIOLETTOSCU = 1: VIOLETTOCHI = 9
     VERDESCU = 2: VERDECHI = 10: AZZURROSCU = 3: AZZURROCHI = 11
     ROSSOSCU = 4: ROSSOCHI = 12: BIANCO = 15: GIALLO = 14
     MARRONESCU = 6: GRIGIO = 7: MARRONECHI = 8: VIOLACHI = 13


     linecol% = 14: SLINECOL% = 15   ' 12  Line colors (changable)
     XAXISCOL% = 5: YAXISCOL% = 2: ZAXISCOL% = 7: SHEETCOL% = 8:
    
'============ CURRENT INTENSITY COLOR MAP TABLE ==================

     ampshade%(10) = ROSSOCHI
     ampshade%(9) = VIOLACHI
     ampshade%(8) = VIOLASCU
     ampshade%(7) = MARRONESCU
     ampshade%(6) = MARRONECHI
     ampshade%(5) = GRIGIO
     ampshade%(4) = VIOLETTOSCU
     ampshade%(3) = VIOLETTOCHI
     ampshade%(2) = AZZURROSCU
     ampshade%(1) = AZZURROCHI

     

'     necfile$ = f$      'acquire  NEC input file name

'    This program first tries to read the file as space-delimited.  If it
'    is comma-delimited, the file is closed, re-opened and then re-read.
'    I'm sure that there must be a more elegant way to do this, but this
'    seems to work OK.
'    If you use one type exclusively you may want to edit the following
'    lines accordingly.
      
     DISTSQD = 0      ' Initialize value used to scale screen.

     OPEN necfile$ FOR INPUT AS #1
     N% = 0
'    Skip through:


'========== Search for segmentation data section ============
'
'                                 - - - - SEGMENTATION DATA - - - -
'
'                                        COORDINATES IN METERS
'
'                         I+ AND I- INDICATE THE SEGMENTS BEFORE AND AFTER I
'
'
'  SEG.   COORDINATES OF SEG. CENTER     SEG.     ORIENTATION ANGLES    WIRE    CONNECTION DATA   TAG
'  NO.       X         Y         Z       LENGTH     ALPHA     BETA      RADIUS    I-   I    I+    NO.
'     1   0.00000  -0.42900   0.00000   0.08580    0.00000  90.00000   0.00250     0    1    2      2
'     2   0.00000  -0.34320   0.00000   0.08580    0.00000  90.00000   0.00250     1    2    3      2
'     3   0.00000  -0.25740   0.00000   0.08580    0.00000  90.00000   0.00250     2    3    4      2
'
     DO
       LINE INPUT #1, j$
     LOOP UNTIL MID$(j$, 34, 34) = "- - - - SEGMENTATION DATA - - - -"
     FOR N% = 1 TO 8: LINE INPUT #1, j$: NEXT
     N% = 0
     DO
       LINE INPUT #1, j$
       IF j$ = "" THEN EXIT DO
       N% = N% + 1
       NTAG%(N%) = VAL(MID$(j$, 95, 6))

       Nseg = VAL(MID$(j$, 5, 4))

       XC = VAL(MID$(j$, 8, 9))
       YC = VAL(MID$(j$, 18, 9))
       ZC = VAL(MID$(j$, 28, 9))
       seglength = VAL(MID$(j$, 38, 9))

       alpha = VAL(MID$(j$, 48, 10))
       beta = VAL(MID$(j$, 58, 10))

' axis projection of segment lengths
       dx = seglength / 2! * COS(deg2rad * alpha) * COS(deg2rad * beta)
       dy = seglength / 2! * COS(deg2rad * alpha) * SIN(deg2rad * beta)
       dz = seglength / 2! * SIN(deg2rad * alpha)

       Nseg(N%) = Nseg  ' segment number ID

' segment extreme coordinates
       XC(N%) = XC: YC(N%) = YC: ZC(N%) = ZC
       x1(N%) = XC - dx: y1(N%) = YC - dy: z1(N%) = ZC - dz
       x2(N%) = XC + dx: y2(N%) = YC + dy: z2(N%) = ZC + dz

'wire radius
       rad(N%) = VAL(MID$(j$, 69, 9))

' sum of square distances
       DISTSQD = x1(N%) * x1(N%) + y1(N%) * y1(N%) + z1(N%) * z1(N%)
       IF DISTSQD > height THEN height = DISTSQD
     LOOP
     nmax% = N%  ' Total segments of the structure


'==================modifica============
' Look for EXcitation point

     DO
       LINE INPUT #1, j$
     LOOP UNTIL MID$(j$, 27, 2) = "EX"
     

' ***** DATA CARD NO.  3   EX   0     0     5     0  1.00000E+00  0.00000E+00  0.00000E+00  0.00000E+00  0.00000E+00  0.00000E+00
'                                    WIRE  SEGM

       Exwire = VAL(MID$(j$, 38, 5))
       Exsegm = VAL(MID$(j$, 44, 5))
    
 
     DO
       LINE INPUT #1, j$
     LOOP UNTIL MID$(j$, 30, 33) = "- - - CURRENTS AND LOCATION - - -"
     FOR N% = 1 TO 6: LINE INPUT #1, j$: NEXT
     FOR N% = 1 TO nmax%
       LINE INPUT #1, j$
       curmag(N%) = VAL(MID$(j$, 74, 11))
       curph(N%) = VAL(MID$(j$, 86, 8))
     NEXT

     CLOSE #1
     height = 1.1 * SQR(height)  'Scale display to fit input file
     XPMIN = -height / 2: YPMIN = -height / 2
'%%%%    50 ok
     PHI = 70: THETA = 30
     ampref = 1!   'amplitude reference for color-keyed current map
     hn% = 1         'number of highlighted element
    
' change scale
         FOR i = 1 TO 4
         height = 2 ^ .25 * height

 XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
 
         NEXT


     LOCATE 2, 68: PRINT "AXIS LENGTH:"
     LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
     LOCATE 6, 68: PRINT " PGUP/PGDN "
     LOCATE 7, 68: PRINT "    KEYS"
     LOCATE 8, 68: PRINT "CHANGE SCALE"
     LOCATE 12, 68: PRINT " PHI THETA"
     LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
     LOCATE 16, 68: PRINT " ARROW KEYS"
     LOCATE 17, 68: PRINT "  TO ROTATE"
     LOCATE 20, 68: PRINT "2-4-6-8-0:"
     LOCATE 21, 68: PRINT " SHIFT AXES"
    
     LOCATE 24, 68: PRINT "  +/- KEY"
     LOCATE 25, 68: PRINT "TO HIGHLIGHT"
     LOCATE 26, 68: PRINT "   A WIRE:"
     LOCATE 27, 68: PRINT " DATA BELOW"
     LOCATE 31, 68: PRINT "L,S,X,Y,Z"
     LOCATE 32, 68: PRINT "CHANGE COLORS"
     LOCATE 34, 68: PRINT "  <ESC>"
     LOCATE 35, 68: PRINT "   TO"
     LOCATE 36, 68: PRINT "  QUIT"
     LOCATE 39, 1: PRINT "SEG#  TAG    X1       Y1       Z1       X2       Y2       Z2      RAD   "
   
     LOCATE 40, 1: PRINT USING "####"; hn%;
     PRINT USING " ###"; NTAG%(hn%);
     PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
     LOCATE 41, 10: PRINT "current: "; : PRINT USING "#.######"; 1000 * curmag(hn%);
     PRINT " mA "; : PRINT USING "####.#"; curph(hn%); : PRINT " deg."
    
     FOR N% = 1 TO 10
       COLOR ampshade%(N%)
       LOCATE 20 - N%, 58: PRINT USING "###.###"; N% / 10 * ampref
     NEXT
     COLOR 15
   
     GOSUB newwindow

DRAWIT:
     VIEW (10, 10)-(450, 290), SHEETCOL%   ' re-draws the background

'==========================================================================
'    DRAW the X,Y,Z axis
'    The XP and YP functions do the coordinate rotation
'==========================================================================

     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(height / 4, 0, 0, PHI, THETA): YP2 = YP(height / 4, 0, 0, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), XAXISCOL%

     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(0, height / 4, 0, PHI, THETA): YP2 = YP(0, height / 4, 0, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), YAXISCOL%

     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(0, 0, height / 4, PHI, THETA): YP2 = YP(0, 0, height / 4, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), ZAXISCOL%

'==========================================================================
'    DRAW the segmentation structure points
'    The XP and YP functions do the coordinate rotation
'==========================================================================
     FOR N% = 1 TO nmax%
       XP1 = XP(x1(N%), y1(N%), z1(N%), PHI, THETA): YP1 = YP(x1(N%), y1(N%), z1(N%), PHI, THETA)
       XP2 = XP(x2(N%), y2(N%), z2(N%), PHI, THETA): YP2 = YP(x2(N%), y2(N%), z2(N%), PHI, THETA)

       shade% = INT(10! * 1000! * curmag(N%) / ampref): IF shade% > 10 THEN shade% = 10
       linecol% = ampshade%(shade%)
       LINE (XP1, YP1)-(XP2, YP2), linecol%
     NEXT N%
     XP1 = XP(x1(hn%), y1(hn%), z1(hn%), PHI, THETA): YP1 = YP(x1(hn%), y1(hn%), z1(hn%), PHI, THETA)
     XP2 = XP(x2(hn%), y2(hn%), z2(hn%), PHI, THETA): YP2 = YP(x2(hn%), y2(hn%), z2(hn%), PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), SLINECOL%

'==========================================================================
'    DRAW the RADIATION PATTERN
'    The XP and YP functions do the coordinate rotation
'==========================================================================
' Suppose to have polar coordinates values(1) = theta
' values(2) = phi
' values(3) = magnitude
' so we convert it into x,y,z coordinate by means of the formulas
'
'  x = R sin(theta) cos(phi)
'  y = R sin(theta)sin(phi)
'  z = R cos(theta)
'
'2222
'd = 2/3 ' vert./horiz. patt.
'
'===============================================

pointer2 = pointer
ang.end2 = ang.end
ang.start2 = ang.start
ang.step2 = ang.step

LOCATE 2, 1
PRINT "IMPEDANCE= "; zreal$; " +j "; zimag$
PRINT wave$
PRINT freq$
PRINT "NORM. GAIN= "; maxgain; " dBi"
 
fax = 150
fay = 150
faz = 150
fa2 = 40

delta2 = ang.end - ang.start     ' 360
startyy2 = 1
conta2 = 1

DO
 RR = values(d, startyy2)
 sintheta = SIN(values(1, startyy2) * deg2rad)
 costheta = COS(values(1, startyy2) * deg2rad)
 sinphi = SIN((values(4, startyy2) * deg2rad))
 cosphi = COS((values(4, startyy2) * deg2rad))

 olx = fax * RR * sintheta * cosphi
 oly = fay * RR * sintheta * sinphi
 olz = faz * RR * costheta

'here, ang.step is referred to theta (which varies more rapidly than phi)

 FOR a = startyy2 + 1 TO (startyy2 + 2) + delta2 / ang.step + 1

    RR = values(d, a)
    sintheta = SIN(values(1, a) * deg2rad)
    costheta = COS(values(1, a) * deg2rad)
    sinphi = SIN((values(4, a) * deg2rad))
    cosphi = COS((values(4, a) * deg2rad))

    x = fax * RR * sintheta * cosphi
    y = fay * RR * sintheta * sinphi
    z = faz * RR * costheta

    XP1 = fa2 * XP(olx, oly, olz, PHI, THETA)
    YP1 = fa2 * YP(olx, oly, olz, PHI, THETA)
    XP2 = fa2 * XP(x, y, z, PHI, THETA)
    YP2 = fa2 * YP(x, y, z, PHI, THETA)

    LINE (XP1, YP1)-(XP2, YP2), d + 12

    olx = x
    oly = y
    olz = z
 NEXT a

 startyy2 = startyy2 + delta2 / ang.step

LOOP UNTIL (startyy2 > pointer2 - delta2)



 

'==========================================================================
'    LOOK FOR KEYBOARD COMMAND
'==========================================================================

     DO
       test$ = INKEY$
     LOOP WHILE test$ = ""
     ' Convert 2-byte extended code to 1-byte ASCII code and handle
     test$ = RIGHT$(test$, 1)
     SELECT CASE test$
       CASE CHR$(PGUP) 'REDUCE SCALE
         height = 2 ^ .25 * height
         LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
         XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
       CASE CHR$(PGDN) 'EXPAND SCALE
         height = 1 / 2 ^ .25 * height
         LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
         XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
       CASE "6" 'move to right
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "4" 'move to left
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "8" 'move up
         yoffset = yoffset - height / 10
         GOSUB newwindow
       CASE "2" 'move down
         yoffset = yoffset + height / 10
         GOSUB newwindow
       CASE "9" 'move up and right
         yoffset = yoffset - height / 10
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "7" 'move up and left
         yoffset = yoffset - height / 10
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "3" 'move down and right
         yoffset = yoffset + height / 10
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "1" 'move down and left
         yoffset = yoffset + height / 10
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "0" 'back to origin
         xoffset = 0: yoffset = 0
         GOSUB newwindow
     
'============== LOOK FOR DIRECTION KEYS ================
      
       CASE CHR$(LEFT)
         PHI = PHI + 10
         IF PHI >= 360 THEN PHI = PHI - 360
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
     
       CASE CHR$(RIGHT)
         PHI = PHI - 10
         IF PHI < 0 THEN PHI = PHI + 360
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(UP)
         THETA = THETA + 10
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(DOWN)
         THETA = THETA - 10
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE "-"
         hn% = hn% - 1: IF hn% < 1 THEN hn% = nmax%
         LOCATE 40, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
         LOCATE 41, 10: PRINT "current: "; : PRINT USING "#.######"; 1000 * curmag(hn%);
         PRINT " milliamps at "; : PRINT USING "####.#"; curph(hn%); : PRINT " deg."
       CASE "+"
         hn% = hn% + 1: IF hn% > nmax% THEN hn% = 1
         LOCATE 40, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
         LOCATE 41, 10: PRINT "current: ";
         PRINT USING "#.######"; 1000 * curmag(hn%);
         PRINT " milliamps at "; : PRINT USING "####.#"; curph(hn%); : PRINT " deg."
       CASE "n", "N"
         LOCATE 20, 10: INPUT "Enter segment number"; hn%
         IF hn% < 1 THEN hn% = 1
         IF hn% > nmax% THEN hn% = nmax%
         LOCATE 40, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
         LOCATE 41, 10: PRINT "current: "; : PRINT USING "#.######"; 1000 * curmag(hn%);
         PRINT " milliamps at "; : PRINT USING "####.#"; curph(hn%); : PRINT " deg."
       CASE "/"
         ampref = ampref / 1.1
         FOR N% = 1 TO 10
           COLOR ampshade%(N%)
           LOCATE 20 - N%, 58: PRINT USING "###.###"; N% / 10 * ampref
         NEXT
         COLOR 15
       CASE "*"
         ampref = ampref * 1.1
         FOR N% = 1 TO 10
           COLOR ampshade%(N%)
           LOCATE 20 - N%, 58: PRINT USING "###.###"; N% / 10 * ampref
         NEXT
         COLOR 15
       CASE "l", "L"
         linecol% = linecol% + 1
         IF linecol% > 15 THEN linecol% = 0
       CASE "s", "S"
         SLINECOL% = SLINECOL% + 1
         IF SLINECOL% > 15 THEN SLINECOL% = 0
       CASE "x", "X"
         XAXISCOL% = XAXISCOL% + 1
         IF XAXISCOL% > 15 THEN XAXISCOL% = 0
       CASE "y", "Y"
         YAXISCOL% = YAXISCOL% + 1
         IF YAXISCOL% > 15 THEN YAXISCOL% = 0
       CASE "z", "Z"
         ZAXISCOL% = ZAXISCOL% + 1
         IF ZAXISCOL% > 15 THEN ZAXISCOL% = 0
       CASE "b", "B"
         SHEETCOL% = SHEETCOL% + 1
         IF SHEETCOL% > 15 THEN SHEETCOL% = 0
       CASE CHR$(ESC)
         GOTO DONE
     END SELECT
    
     GOTO DRAWIT

'ONE:
'     STOP
'     END
 



newwindow:
     WINDOW (XPMIN + xoffset, YPMIN + yoffset)-(1.4 * height + XPMIN + xoffset, height + YPMIN + yoffset)
     RETURN
DONE:
    SCREEN 0
    CLS

     END SUB

'''''
''''
'========
SUB fmax (scale.f, graph.type$, what$, cut$, path$, extn$)
SHARED max, sumh, sumv, ang.step, ang.end

PI = ATN(1) * 4

max = 0
sumh = 0
sumv = 0
ang.end = 0
ang.step = values(1, 2) - values(1, 1)
'PRINT , "ANG.STEP =  "; ang.step

FOR a = 1 TO 360
'sum areas
 sumv = sumv + (values(2, a) * values(2, a) * PI * ang.step / 360)
 sumh = sumh + (values(3, a) * values(3, a) * PI * ang.step / 360)

' look for max of either pattern
' to determine scale factor
 IF ang.end < values(1, a) THEN ang.end = values(1, a)
 IF max < values(2, a) THEN max = values(2, a)
 IF max < values(3, a) THEN max = values(3, a)
NEXT a

scale.f = 200 / max

END SUB

'=============================================================
' read data from input file
'
SUB freader.bas (graph.type$, what$, cut$, path$, extn$, necfile$)
SHARED pointer, maxgain

'read nec output file
flnum = 1
pointer = 1

OPEN necfile$ FOR INPUT AS #flnum

'========== Search for antenna characteristics
'
'                                 - - - - - - FREQUENCY - - - - - -
'
'                                    FREQUENCY= 1.4000E+02 MHZ
'                                    WAVELENGTH= 2.1414E+00 METERS
'
'                                  - - - ANTENNA ENVIRONMENT - - -
'
'                                            FREE SPACE
'
'                                          - - - ANTENNA INPUT PARAMETERS - - -
'
'   TAG   SEG.    VOLTAGE (VOLTS)         CURRENT (AMPS)         IMPEDANCE (OHMS)        ADMITTANCE (MHOS)      POWER
'   NO.   NO.    REAL        IMAG.       REAL        IMAG.       REAL        IMAG.       REAL        IMAG.     (WATTS)
'     9     5 1.00000E+00 0.00000E+00 1.16504E-03 1.22151E-02 7.73777E+00-8.11281E+01 1.16504E-03 1.22151E-02 5.82520E-04
'


     DO
       LINE INPUT #1, j$
     LOOP UNTIL MID$(j$, 37, 9) = "FREQUENCY"
     freq$ = MID$(j$, 37, 28)
     LINE INPUT #1, j$
     wave$ = MID$(j$, 37, 32)
    
     DO
       LINE INPUT #1, j$
     LOOP UNTIL MID$(j$, 49, 20) = "ANTENNA INPUT PARAME"

      LINE INPUT #1, j$
      LINE INPUT #1, j$
      LINE INPUT #1, j$
      LINE INPUT #1, j$
      zreal$ = MID$(j$, 62, 11)
      zimag$ = MID$(j$, 73, 12)
'      LOCATE 4, 4
'      PRINT "IMPEDANCE = "; zreal$; " +j "; zimag$
  
'==================fine modifica============



'look for start of pattern data
DO WHILE INSTR(LEFT$(line$, 9), "DEGREES") = 0
   LINE INPUT #flnum, line$
LOOP
maxgain = -999.999

'get pattern data and put in array
WHILE NOT EOF(flnum)
   LINE INPUT #flnum, line$
   CALL sort(line$, graph.type$, what$, cut$)
   pointer = pointer + 1
'   PRINT line$
WEND

CLOSE #flnum

'PRINT "elements = ", pointer
'INPUT "any key"; a
END SUB

'===========================================================
' plot data
'
SUB plotter (f$, path$, sc.f, scale.f, ang.offset, what$)
SHARED ang.start, ang.step, ang.end
'routine to plot pattern to plotter or file

SCREEN 0
INPUT "Enter plot filename or Enter to plot"; ff$
filename$ = path$ + "\" + ff$
a = 1
CONST PI = 3.141592654#
CONST dtor = PI / 180
CONST NINETY = 90 * dtor
CONST xx = 5300
CONST yy = 3800
CONST radius = 3198

'This bit plots to the file
IF ff$ = "" THEN OPEN "COM1:9600, S, 7, 1, RS, CS65535, DS, CD" FOR RANDOM AS #2
IF ff$ <> "" THEN OPEN filename$ FOR OUTPUT AS #2

PRINT "Graticule y/n?"
WHILE g$ = ""
 g$ = UCASE$(INKEY$)
WEND

'Plotter initialisation"
PRINT #2, "IN;SP1;PU"; xx; ","; yy; ";"
PRINT "Plotting to "; filename$


'This does graticule
IF g$ = "Y" THEN

 FOR g = 10 TO 1 STEP -1
   PRINT #2, "CI"; INT(radius * g / 10); ";"
 NEXT g

 FOR ang = 10 TO 350 STEP 20
   a = ang * dtor
   PRINT #2, "PU;PA"; xx - (SIN(a) * radius / 10); ","; yy - (COS(a) * radius / 10); ";"
   PRINT #2, "PD;PA"; xx - (SIN(a) * radius); ","; yy - (COS(a) * radius); ";"
   a = a + 10 * dtor
   PRINT #2, "PU;PA"; xx - (SIN(a) * radius); ","; yy - (COS(a) * radius); ";"
   PRINT #2, "PD;PA"; xx - (SIN(a) * radius / 10); ","; yy - (COS(a) * radius / 10); ";"
 NEXT ang

END IF

'===============================
'
'plot actual radiation pattern
'
IF what$ = "vp" THEN u = 2 ELSE u = 3
IF what$ = "hp" THEN t = 3 ELSE t = 2
FOR d = t TO u
olx = values(1, 1) * dtor + ang.offset + NINETY
oly = values(d, 1)
IF d = 3 THEN PRINT #2, "LT5;"
PRINT #2, "SP2;PU"; xx + (SIN(olx) * oly * scale.f * sc.f * radius / 200); ","; yy + (COS(olx) * oly * scale.f * sc.f * radius / 200); ";"
PRINT #2, "PD"
FOR a = 2 TO ((ang.end - ang.start) / ang.step) + 1
 x = values(1, a) * dtor + ang.offset + NINETY
 y = values(d, a)
 PRINT #2, xx + (SIN(x) * y * scale.f * sc.f * radius / 200); ","; yy + (COS(x) * y * scale.f * sc.f * radius / 200); ","
 olx = x
 oly = y
NEXT a

IF (360 - (ang.end - ang.start)) MOD 360 <= 10 THEN
  x = values(1, 1) * dtor + ang.offset + NINETY
  y = values(d, 1)
  PRINT #2, xx + (SIN(x) * oly * scale.f * sc.f * radius / 200); ","; yy + (COS(x) * oly * scale.f * sc.f * radius / 200); ","
END IF

PRINT #2, ";PU;"
NEXT d
CLOSE #2

PRINT "Any key."
WHILE a$ = ""
 a$ = INKEY$
WEND

'FOR j = 1 TO 40
' PRINT values(1, j), values(2, j), values(3, j)
' INPUT y$
'NEXT j

END SUB

'================================================
' print data screen on printer
'
SUB printer
' prova di stampa per panasonic kx-p1091
' epson compatibile
'punti orizzontali della matrice striscia grafica

Npunti = 460
Npunti2 = 460

aghi = 3
DIM figura(aghi, Npunti)
colo = 5
colo2 = 14
colo3 = 15

'k = 220      'per 2 dot
'k = 42      'per 8 dot
'k = 68    'per 4 dot
k = 150   'per 3 dot
contk:
' Memorizza il disegno nella matrice figura
FOR i = 1 TO Npunti
  FOR j = 1 TO aghi
    figura(j, i) = 0
  NEXT j
NEXT i

offp = 20

FOR i = 1 TO Npunti
  FOR j = 1 TO aghi
    figura(j, i) = POINT(320 - Npunti / 2 + j - 1 + aghi * k, 240 - Npunti / 2 + i - 1)
   
  NEXT j
NEXT i

 
'INPUT "punti per riga ? "; Npunti

N2 = INT(Npunti2 / 256)
N1 = Npunti2 - (256 * N2)

'spaziatura per 8 dot = 12
'per 4 dot = 7  per 3 dot = 5,meglio 6    per 2 dot = 3,meglio 4
'per 1 dot = 2
'
LPRINT CHR$(27) + "3" + CHR$(6)
LPRINT CHR$(27) + "K" + CHR$(N1) + CHR$(N2)
 
FOR i = 1 TO Npunti

  valore = 0
  j = aghi
contj:

IF (figura(j, i) = colo) OR (figura(j, i) = colo2) OR (figura(j, i) = colo3) THEN
valore = valore + 2 ^ (j - 1)
END IF

j = j - 1
IF j > 0 THEN
GOTO contj:
END IF
LPRINT CHR$(valore);
 
NEXT i
 LPRINT

k = k - 1

IF k > -40 THEN
GOTO contk:
END IF

END SUB

'================================================
' sort data from file
'
SUB sort (lne$, graph.type$, what$, cut$)
SHARED pointer, ang.start, maxgain
IF lne$ = "" THEN GOTO bye

IF what$ <> "log" THEN
  mag$ = MID$(lne$, 75, 15)
  mag2$ = MID$(lne$, 100, 14)
END IF

'  318.00   360.00      -2.33 -999.99   -2.33    0.00000     0.00  LINEAR    4.50353E-05  -135.29    0.00000E+00   -72.84
  mag2$ = MID$(lne$, 100, 14)

'SELECT CASE cut$ <> ""
'     CASE cut$ = "HRP"
'          ang$ = MID$(lne$, 10, 8)
'
'     CASE cut$ = "VRP"
'          ang$ = MID$(lne$, 1, 9)
'END SELECT
  dbi$ = MID$(lne$, 18, 11)
 
  gain = VAL(dbi$)
   IF gain > maxgain THEN maxgain = gain
   

'store values in array
   
ang$ = MID$(lne$, 1, 9)      ' theta
ang2$ = MID$(lne$, 10, 8)    ' phi

values(1, pointer) = VAL(ang$)
values(2, pointer) = VAL(mag$)  ' theta-magnitude
values(3, pointer) = VAL(mag2$) ' phi-magnitude
values(4, pointer) = VAL(ang2$)

'PRINT ang$, mag$, mag2$
'INPUT f$
ang.start = values(1, 1)
bye:
END SUB

     FUNCTION XP (x, y, z, PHI, THETA)
'       deg2rad = ATN(1!) / 45
       XP = -x * SIN(PHI * deg2rad) + y * COS(PHI * deg2rad)
     END FUNCTION

     FUNCTION YP (x, y, z, PHI, THETA)
'      deg2rad = ATN(1!) / 45


      YP = z * SIN(THETA * deg2rad) - x * COS(THETA * deg2rad) * COS(PHI * deg2rad) - y * COS(THETA * deg2rad) * SIN(PHI * deg2rad)
     END FUNCTION

