     ' GAMTOZ.BAS

     ' Reads MicroSmith .GAM file, converts gamma values to impedances, and
     ' writes results into another file in comma-delimited format. Run with
     ' Microsoft QBasic or QuickBasic.

     ' This program, in both source and executable forms, can be freely 
     ' copied and distributed. No warrantee of any kind is given, and no 
     ' support is available.

     ' By Roy Lewallen, W7EL
     '   1995-07-18


     ' Degree-radian conversion

     CONST DegRad = .0174533
     


     ' Move down a couple of lines

     PRINT
     PRINT

     ' Get the input file name

GetInfileName:

     INPUT "Input file (.GAM assumed) or <Enter> only to end program"; infile$
     IF infile$ = "" THEN
       GOTO done
     END IF
     
     ' Convert name to upper case and trim leading and trailing spaces

     infile$ = LTRIM$(RTRIM$(UCASE$(infile$)))

     ' Add .GAM to name if it's not already there. Note: Any extension except
     ' .GAM will cause an error.

     IF RIGHT$(infile$, 4) <> ".GAM" THEN
       infile$ = infile$ + ".GAM"
     END IF

     ' Open the input file

     ON ERROR GOTO infileErr
     OPEN infile$ FOR INPUT AS #1
     ON ERROR GOTO 0

     ' Get the output file name

GetOutfileName:

     INPUT "Output file or <Enter> only to end program"; outfile$
     IF outfile$ = "" THEN
       GOTO done
     END IF

     ' Convert name to upper case and trim leading and trailing spaces

     outfile$ = LTRIM$(RTRIM$(UCASE$(outfile$)))

     ' Open the output file

     ON ERROR GOTO outfileErr
     OPEN outfile$ FOR OUTPUT AS #2
     ON ERROR GOTO 0

     ' Print column headings to the output file. Note that WRITE #2 makes
     ' comma-delimited format. For other formats, use PRINT #2.

     WRITE #2, "Freq MHz", "R ohms", "X ohms"
     WRITE #2,

     ' Read Z0

     INPUT #1, Z0

     ' Begin read/convert/write loop

     DO UNTIL EOF(1)

       ' Read the frequency

       INPUT #1, FMHz

       ' Read the magnitude of gamma

       INPUT #1, GammaMag

       ' Read the phase of gamma

       INPUT #1, GammaPha

       ' Convert phase to radians

       GammaPha = GammaPha * DegRad

       ' Convert gamma to rectangular form

       GammaRe = GammaMag * COS(GammaPha)
       GammaIm = GammaMag * SIN(GammaPha)

       ' Calculate Z = Z0 * (1 + gamma)/(1 - gamma)

         ' Numerator, denominator of (Z0 * (1 + gamma))/(1 - gamma)

       NumRe = Z0 * (1 + GammaRe)
       NumIm = Z0 * GammaIm
       DenRe = 1 - GammaRe
       DenIm = -GammaIm

         ' Divide

       DenMag = DenRe * DenRe + DenIm * DenIm
       ZRe = (NumRe * DenRe + NumIm * DenIm) / DenMag
       ZIm = (NumIm * DenRe - NumRe * DenIm) / DenMag
     
       ' Write results in outfile$. Note: WRITE #2 makes a comma-delimited
       ' format. Use PRINT #2 for other formats.

       WRITE #2, FMHz, ZRe, ZIm

       ' Get the next set of values

     LOOP

     ' Done.

     GOTO done

infileErr:

     ' Error-trapping routine for opening input file

     PRINT
     PRINT "Unable to open the input file "; infile$
     PRINT
     GOTO GetInfileName

outfileErr:

     ' Error-trapping routine for opening output file

     PRINT
     PRINT "Unable to open the output file "; outfile$
     PRINT
     GOTO GetOutfileName

done:
     PRINT
     PRINT
     CLOSE

END

