echo off
rem	Batch file for handling Nec-2 in/output files.
rem	Remove/add one of the below 'rem' characters to select the 
rem	appropriate nec-2 executable to run (See also ReadMeFirst.txt)
rem	
rem		    Name of      		Max number   Approximate
rem     	    executable   		of segm.     memory use (Mb)
rem     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
rem	set nec2d=NEC2D.EXE     		'  256         1.5 (*)
rem	set nec2d=NEC2D512.EXE  		'  512         5
rem	set nec2d=NEC2D960.EXE  		'  960        16
rem	set nec2d=NEC2D1K4.EXE  		' 1392        32
rem	set nec2d=NEC2D1K9.EXE  		' 1950        60
rem	set nec2d=NEC2D2K8.EXE  		' 2800       122	
rem	set nec2d=NEC2D4K.EXE   		' 4000       247	
rem	set nec2d=NEC2D5K7.EXE  		' 5700       500
rem	set nec2d=NEC2D8K1.EXE  		' 8100      1006
rem	set nec2d=NEC2D11K.EXE  		' 11000      1852
rem
	set nec2d=%3.exe			' Executable is set by 4nec2 program
rem
rem ************************** Don't change the lines below ********************
rem
        if "%1" == "cop" goto cop
        if "%1" == "som" goto som
        if "%1" == "ren" goto ren
        goto gen
:som
rem	Call SOMNEC engine and generate 'arg2' ground-parameter file.
rem
	echo.
	echo Generating new %2 ground file 
	echo .
	cd exe
	somnec2d < som2d.tmp
	type som2d.tmp
	cd ..
	echo.   
	copy exe\som2d.nec %2
	goto gen
:cop
rem	Copy 'arg2' SOMNEC ground-parameter file to som2d.nec to be used.
rem
	echo.
	echo Using existing %2 ground file
	echo.
	copy %2 exe\som2d.nec         
	goto gen
:gen
rem	Call NEC2 engine with nec2d.tmp input file and optional som2d.nec ground file
rem
	echo.
	echo Generating new NEC output file 
	echo.   
	cd exe
	type nec2d.tmp
	%nec2d% < nec2d.tmp
	cd ..
	echo.
	echo Ready...
	echo.
	if "%4" == "pause" pause
	exit
:ren
rem	Delete *.npl and Rename *.nou to *.out
rem
	cd out
	if exist %2.npl del %2.npl
	if exist %3 del %3
	rename %2.nou %3
	cd ..
	exit
