// Persistence Of Vision raytracer version default scene file.
// By Arie
// This image contains the default scena in which the nec2 structure or far-field pattern is placed.

global_settings { assumed_gamma 2.2 }
                
#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "skies.inc"


// Select one of the below camera points by removing and addeng comment indicators: //

//#declare cdist = 200;          // Short distance camera
//#declare cang = 70;
#declare cdist = 400;        // Medium distance camera
#declare cang = 36;
//#declare cdist = 800;        // Long distance camera
//#declare cang = 19;
                        
#declare height = 50;          // Camera height to look at in case of groundplane.

#declare ldist = cdist+100;   // Distance for light_source
#declare lcolor = White;      // Color for light source

#declare dPHI = radians (5);  // Degrees right from camera to light source.
#declare dTHE = radians (10); // Degrees upwards from camera to light source

#declare Pattern  = texture { pigment { Red } finish { ambient .1 diffuse .8 }} // Pattern texture
#declare Geometry = texture { T_Copper_4A }                                      // Geometry texture

#declare PerfGnd = texture { T_Silver_5D }                                       // Perfect Ground(plane)
#declare FiniGnd = texture { pigment { Green } finish { ambient .4 diffuse .6 }} // Finite Ground(plane)

#declare MyClouds = sky_sphere { S_Cloud1 }                                     // Sky filled with clouds 
                                                                                
sky_sphere { MyClouds }
plane { y, 0 texture { FiniGnd } }
 
camera { location < 0.0+cdist*sin(1.4)*cos(4.89),0.0+cdist*cos(1.4),0.0+cdist*sin(1.4)*sin(4.89) > look_at < 0.0,0.0+height,0.0 > angle cang }
 
light_source { < 0.0+ldist*sin(1.4-dTHE)*cos(4.89-dPHI),0.0+ldist*cos(1.4-dTHE),0.0+ldist*sin(1.4-dTHE)*sin(4.89-dPHI) > color lcolor }
 
union {    // mult-fact= 2
cylinder { <   -19.27,    26.5,     0.0 > <     -0.1,    40.0,     0.0 >      0.5 }   //  1
sphere { <     -0.1,    40.0,     0.0 >      0.5 }   //  1
cylinder { <     -0.1,    40.0,     0.0 > <      0.1,    40.0,     0.0 >      0.5 }   //  2
sphere { <      0.1,    40.0,     0.0 >      0.5 }   //  2
cylinder { <      0.1,    40.0,     0.0 > <    19.27,    26.5,     0.0 >      0.5 }   //  3
cylinder { <      0.1,    40.0,     0.0 > <    19.27,    26.5,     0.0 >      0.5 }   //  3
texture { Geometry } }
