/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import jakarta.inject.Inject;
import java.util.ResourceBundle;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.e4.core.services.translation.ResourceBundleProvider;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

public class BundleTranslationProvider
extends TranslationService {
    @Inject
    @Optional
    ResourceBundleProvider provider;
    Logger logger;

    @Override
    public String translate(String key, String contributorURI) {
        ResourceBundleProvider prov = this.provider;
        if (prov == null) {
            return key;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundleHelper.getResourceBundleForUri(contributorURI, this.locale, prov);
            return this.getResourceString(key, resourceBundle);
        }
        catch (Exception e) {
            Logger log = this.logger;
            if (log != null) {
                log.error("Error retrieving the translation for key={} and contributorURI={}", new Object[]{key, contributorURI, e});
            }
            return key;
        }
    }

    @Inject
    @Optional
    void setLoggerFactory(LoggerFactory factory) {
        this.logger = factory != null ? factory.getLogger(this.getClass()) : null;
    }
}

