#line 2 "pgc.c"
/*-------------------------------------------------------------------------
 *
 * pgc.l
 *	  lexical scanner for ecpg
 *
 * This is a modified version of src/backend/parser/scan.l
 *
 *
 * Portions Copyright (c) 1996-2015, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *	  src/interfaces/ecpg/preproc/pgc.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include <ctype.h>
#include <sys/types.h>
#include <limits.h>

#include "extern.h"
#include "preproc.h"

#line 29 "pgc.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer base_yy_create_buffer
#define yy_delete_buffer base_yy_delete_buffer
#define yy_flex_debug base_yy_flex_debug
#define yy_init_buffer base_yy_init_buffer
#define yy_flush_buffer base_yy_flush_buffer
#define yy_load_buffer_state base_yy_load_buffer_state
#define yy_switch_to_buffer base_yy_switch_to_buffer
#define yyin base_yyin
#define yyleng base_yyleng
#define yylex base_yylex
#define yylineno base_yylineno
#define yyout base_yyout
#define yyrestart base_yyrestart
#define yytext base_yytext
#define yywrap base_yywrap
#define yyalloc base_yyalloc
#define yyrealloc base_yyrealloc
#define yyfree base_yyfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 1
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE base_yyrestart(base_yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int base_yyleng;

extern FILE *base_yyin, *base_yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE base_yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-base_yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < base_yyleng; ++yyl )\
                    if ( base_yytext[yyl] == '\n' )\
                        --base_yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --base_yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up base_yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up base_yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via base_yyrestart()), so that the user can continue scanning by
	 * just pointing base_yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when base_yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int base_yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow base_yywrap()'s to do buffer switches
 * instead of setting up a fresh base_yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void base_yyrestart (FILE *input_file  );
void base_yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE base_yy_create_buffer (FILE *file,int size  );
void base_yy_delete_buffer (YY_BUFFER_STATE b  );
void base_yy_flush_buffer (YY_BUFFER_STATE b  );
void base_yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void base_yypop_buffer_state (void );

static void base_yyensure_buffer_stack (void );
static void base_yy_load_buffer_state (void );
static void base_yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER base_yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE base_yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE base_yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE base_yy_scan_bytes (yyconst char *bytes,int len  );

void *base_yyalloc (yy_size_t  );
void *base_yyrealloc (void *,yy_size_t  );
void base_yyfree (void *  );

#define yy_new_buffer base_yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        base_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            base_yy_create_buffer(base_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        base_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            base_yy_create_buffer(base_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define base_yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *base_yyin = NULL, *base_yyout = NULL;

typedef int yy_state_type;

extern int base_yylineno;

int base_yylineno = 1;

extern char *base_yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr base_yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yynoreturn yy_fatal_error (yyconst char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up base_yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	base_yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 151
#define YY_END_OF_BUFFER 152
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[813] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   15,   15,    0,    0,    0,    0,
        0,    0,    0,    0,   14,   14,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  152,  150,  120,   98,   98,  120,
       56,  120,   80,   92,  120,   22,   96,   97,   91,   94,
       90,   95,  120,   93,   70,   70,   88,   89,  120,  103,
      120,   86,   86,  101,  102,   99,  120,  100,   78,    1,
        1,   68,   49,   68,   66,   67,   68,   23,   67,   67,
       67,   67,   70,   67,   67,   67,   67,   77,   77,   77,

       77,   77,   77,  149,  149,  149,  149,  145,  145,  144,
      143,  142,  126,  126,   15,   12,    8,    8,    9,    9,
        9,    9,   55,   51,   57,   52,   57,   14,   19,   36,
       36,   28,   42,   35,   30,   26,   26,   35,   46,   46,
       48,  141,  141,  139,   98,   98,  139,  139,   53,   32,
        0,    0,  112,    0,    0,    0,    0,    0,    0,    0,
      117,  108,    0,   87,  115,  109,  113,  110,  114,  104,
      119,   72,    2,    0,  116,   72,   70,    0,   82,  106,
      111,  105,   86,   86,  107,    1,    0,   68,   65,   68,
        0,    0,   44,   69,   43,    1,   59,   72,    3,   72,

       70,   74,   58,   60,   76,   62,   64,   61,   63,   77,
       11,   24,   21,    0,   18,    0,  148,    0,    0,    0,
      144,  142,    0,    0,  125,   15,   12,   12,   13,    8,
       10,    7,    4,   10,    6,    5,   55,   54,   57,   14,
       19,   19,   20,   36,   28,   28,   33,   29,   38,   39,
       38,   38,   38,   35,   30,   30,   31,   26,   26,   27,
       34,   46,   45,   47,    0,    0,  140,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   85,   85,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  118,    2,    0,   81,   72,    0,   73,

       82,   86,   68,   43,    1,    1,    3,   72,   70,   75,
       76,    0,    0,    0,   50,   25,  147,  146,   12,   17,
       13,   12,    4,    5,   19,   16,   20,   19,   28,   41,
       29,   28,   39,    0,    0,   40,   30,   31,   30,   26,
       27,   26,   47,    0,    0,    0,    0,    0,    0,    0,
        0,   85,   85,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   86,
        0,   72,   70,   76,    0,    0,    0,   76,  147,  147,
      146,  146,   12,   12,   12,   12,   19,   19,   19,   19,
       28,   28,   28,   28,   39,    0,    0,   40,   30,   30,

       30,   30,   26,   26,   26,   26,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  134,    0,    0,
        0,    0,    0,    0,    0,   86,    0,   72,   72,   76,
        0,    0,    0,    0,   12,   12,   12,   12,   12,   19,
       19,   16,   19,   19,   28,   28,   28,   28,   28,    0,
        0,   30,   30,   30,   30,   30,   26,   26,   26,   26,
       26,    0,    0,    0,    0,    0,    0,    0,   41,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  134,    0,  136,    0,  130,    0,    0,

      124,    0,   86,    0,    0,   72,    0,    0,    0,    0,
       76,   76,   12,   19,   28,    0,   37,   30,   26,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  122,
        0,  138,  130,  132,    0,  124,    0,   79,   71,    0,
        0,    0,    0,    0,   76,    0,    0,    0,    0,    0,
        0,    0,   83,   83,  122,  132,  128,   79,   79,   86,
       86,   86,   86,   71,   76,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   83,   83,   83,    0,   83,    0,
      128,    0,    0,    0,   86,   86,   86,   86,   86,   86,
       71,   76,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       86,   86,   86,   86,   86,   86,   86,   86,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   86,   86,   86,   86,   86,
       86,   86,   86,  133,    0,    0,    0,    0,    0,    0,
        0,    0,   53,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   32,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   86,  133,    0,  135,   86,   86,   86,   86,
       86,    0,  129,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   41,    0,

       41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   84,   84,    0,    0,  123,   86,    0,
      137,  129,   86,   86,  123,  131,    0,   53,    0,    0,
        0,    0,    0,   53,   53,    0,    0,    0,    0,    0,
        0,    0,   32,   32,    0,    0,    0,    0,    0,   32,
       32,   84,   84,   84,   84,  121,    0,  121,  131,   86,
        0,    0,    0,    0,    0,    0,    0,    0,   32,    0,
        0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  127,  127,   53,    0,    0,    0,    0,
        0,    0,    0,    0,   32,   32,    0,    0,   32,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,   28,   29,   30,   31,   32,   33,   34,
       35,   35,   36,   35,   35,   37,   38,   39,   40,   41,
       42,   43,   44,   45,   46,   35,   35,   47,   35,   35,
       48,   49,   50,   51,   52,   28,   29,   30,   31,   32,

       33,   34,   35,   35,   53,   35,   35,   37,   38,   39,
       40,   41,   42,   43,   44,   45,   54,   35,   35,   55,
       35,   35,   56,   57,   58,   28,    1,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59
    } ;

static yyconst YY_CHAR yy_meta[60] =
    {   0,
        1,    2,    3,    3,    4,    5,    4,    6,    7,    4,
        8,    9,    9,   10,    7,    1,   11,   12,   10,   13,
       13,   13,   14,   15,   16,   17,   18,    4,   19,   19,
       19,   19,   19,   19,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   12,   21,    9,
        4,   20,   20,   20,   20,    1,    4,    1,   20
    } ;

static yyconst flex_uint16_t yy_base[902] =
    {   0,
        0,    0,    0,    0,   59,    0,  113,  117,  122,  125,
      149,    0,  208,    0, 1773, 1768,  263,  316,  116,  117,
     1772, 1768,  263,  268, 1753, 1751,  273,  283, 1750, 1746,
     1740, 1739,  260,  264,  131,  140,  373,    0,  294,  303,
     1735, 1729, 1720, 1717, 1714, 4958, 4958,  297,  343, 1687,
     4958,  257,  316, 1685, 1698, 4958, 4958, 4958,  289,  106,
     4958,  302,  337,  342,  415,  420, 4958, 4958, 1682, 1678,
     1661,    0,  232, 4958, 4958, 4958, 1626, 4958, 4958,  442,
      448, 1656, 4958,  466,  439,    0,    0, 4958, 4958, 1661,
      436, 1663,  445,  269,  311, 1648, 1647,    0, 1661, 1659,

     1658, 1654, 1651, 1637,    0, 4958,    0, 4958,  484, 4958,
     4958,    0, 4958,  494,    0,  497,    0,    0,  320, 1645,
      341, 1643,    0, 1650, 4958, 4958,  275,    0,  503,    0,
        0,  522,  483,    0,  532,  542,  538, 1643,    0,    0,
     1643, 4958,  507, 4958, 4958, 4958,  436,  316,  548,  558,
      564,  459, 4958,  612,  538,  540, 1616,   83,  400, 1609,
     4958, 4958,  460, 4958, 4958, 4958, 4958, 4958, 4958, 1631,
     4958,  560,    0, 1640, 4958,  563,  568,  588,    0, 4958,
     4958, 4958,    0, 1607, 4958,  670,  477,    0,    0,  673,
      430,  494, 4958,  344, 1627,  726, 4958,  578,    0,  664,

      673,  687, 4958, 4958,  539,    0,    0,    0,    0,    0,
     4958, 4958, 4958,  471, 4958, 1606, 4958, 1614, 1592,  708,
     4958,    0,  713,  718, 4958,    0,  744,  753, 1597,    0,
      502, 4958,    0,  508, 4958,    0,    0, 4958, 4958,    0,
      756,  763, 1586,    0,  782,  785, 4958, 1581, 4958,  333,
        0,    0,    0,    0,  788,  804, 1570,  807,  814, 1565,
     4958,    0, 4958, 1563,  725,  810, 4958, 1527, 1517,  824,
     1528, 1501,  833,  836, 1507, 1487,  862, 4958,    0,    0,
      791,  531, 1477, 1486,  657, 1467, 1470, 1458,  807, 1454,
      686, 1454, 1441, 4958,    0, 1468, 4958,  824,  834,  841,

        0, 1419,  913, 1430,    0,  966,    0,  847,  853,  863,
      696, 1405,    0,  908, 4958, 4958,  931,  941,  945, 4958,
     1412,  949,    0,    0,  957, 4958, 1411,  984,  993, 4958,
     1396,  996,  527,    0,    0,    0, 1003, 1395, 1022, 1025,
     1393, 1028, 1401, 1363, 1031, 1343, 1047, 1368, 1050, 1339,
        0,    0,    0, 1347, 1342, 1333, 1326, 1327, 1327, 1316,
     1318,  726, 1319, 1319,  745, 1310, 1303, 1289, 1292,  975,
     1035, 1041, 1048,  721, 1069, 1080, 1085, 1088, 1076, 4958,
     1105, 4958, 1109, 1114, 1120, 1130, 1137, 1140, 1147, 1156,
     1159, 1163, 1175, 1179, 4958,    0,    0, 4958, 1182, 1185,

     1201, 1204, 1208, 1211, 1220, 1227, 1230, 1236, 1239, 1243,
     1246, 1288, 1255, 1266, 1300, 1304, 1311, 1287, 1277, 1277,
     1262,  680, 1265, 1265, 1248,  717, 1242, 1273, 1292, 1246,
     1244, 1240,  722, 1237, 1320, 1225, 1266, 1309, 1312,  841,
     1365, 1334, 1422, 1345, 1375, 1394, 1416, 1476, 1400, 1480,
     1492, 1496, 1508, 1512, 1519, 1524, 1529, 1540, 1535,    0,
        0, 1545, 1556, 1561, 1566, 1572, 1577, 1582, 1593, 1598,
     1588, 1404, 1223, 1604, 1609, 1235, 1614, 1625, 1630, 1635,
     1663, 1683, 1688, 1233,    0, 1227, 1210, 1222,    0, 1218,
     1206, 1204, 1202, 1337, 1620, 4958, 1691, 1397, 1193, 1188,

     1443, 1174, 1164, 1468, 1484, 1533, 1742,    0,    0, 1183,
      919, 1799, 1695, 1699, 1716,    0, 4958, 1719, 1752, 1161,
     1773, 1156, 1769, 1818, 1779, 1154, 1161,    0, 1158, 1722,
     1736, 4958, 1785, 1803, 1157, 1828, 1138, 1871, 1816, 1156,
     1155,  580, 1897,    0, 1955,    0, 1848, 1837, 1138, 1854,
     1865, 1136, 1840, 1857, 1874, 1884, 1893, 2004,    0, 1135,
      108,  642, 1117, 1892, 2058,    0, 1943,  246, 1121, 1958,
     1981, 1984, 2116, 2007, 1918, 1951, 1987, 1114, 2012, 1106,
     2017, 1095,  838, 1088, 1091,  910, 1082,  743, 1079, 1071,
     4958,    0,    0, 1173, 1067,  765, 2119, 2024,    0, 1081,

     2123, 2126, 2143,    0, 1078, 1061, 1043, 1041, 1034, 1028,
      767,  987,  978,  796,  975,  952,  935,  936,  923,  896,
      828,  893,  892, 2164,  908, 2180, 2183, 2200,  877, 2203,
      775,  866,  878,  839,  833,  813, 2029, 2147,  799,  785,
      768,  896,  766, 2040, 2219,  716,  689,  686, 2222, 2238,
     2248, 2228, 4958, 2258, 2268, 2284, 2287, 2303, 2306, 2322,
     2325, 2328, 4958, 2344, 2361, 2381, 2384,  660,  658,  640,
      936,  641,  573, 2043, 2232, 4958, 2387, 2049,  561,  541,
     2052, 2400, 2135,  481,  426, 2403, 2406, 2423, 2426, 2442,
     2459, 2462, 2480, 2483, 2499, 2504, 2515, 2520, 2525, 2536,

        0,  355, 2541, 2546, 2574, 2594, 2599, 2604, 2620, 2632,
     2652, 2657, 2662, 2186, 2309,  307,  286, 2429, 2452, 2531,
     4958, 2610, 2615,  283, 2623, 2668, 2673, 2678, 2683, 2694,
     2699, 2704, 2732, 2752,    0, 2757, 2768, 2773, 2778, 2790,
     2795, 2814, 2826, 4958, 2831, 2835, 2852, 2862, 2880, 2884,
        0, 2689, 2710, 2806, 2855, 2872,  100, 2890, 2900, 2907,
     2916, 2919, 2935, 2938, 2955, 2965, 2976, 2993, 3003, 3014,
     3024, 3041, 3052, 3063, 3073, 3090, 3101, 3111, 3121, 3131,
     3147, 3157, 3179, 2941, 3030, 3167, 3195, 3205, 3225, 3228,
     3244, 3261, 3264, 3282, 3285,    0, 3302, 3318, 3321, 3338,

     3341, 3357, 3377, 3374, 3397, 3415, 3431, 3435, 3451, 3455,
     3471, 4958, 3525, 3546, 3567, 3588, 3609, 3630, 3651, 3672,
     3693, 3714, 3735, 3756, 3777, 3793, 3810, 3823, 3830, 3845,
     3865, 3886, 3907, 3923, 3942, 3962, 3983, 4004, 4025, 4046,
     4066, 4087, 4108,  983, 4128, 4145, 4163,  471, 4179, 4199,
     4217, 4230, 4247, 4262,  545,  759,  810, 4275,  572, 4294,
     4314, 4335, 4356,  829,  996,  999, 4377, 4398, 4419, 4440,
     4456, 4476, 4497, 4518, 1003, 1024, 4539, 4560, 4581, 4602,
     1025, 1027, 4622, 1028, 1102, 1133, 4642, 4663, 4684, 4705,
     4726, 4747, 4768, 4789, 4810, 4831, 4852, 4873, 4894, 4915,

     4936
    } ;

static yyconst flex_int16_t yy_def[902] =
    {   0,
      813,  813,  812,    3,  812,    5,  814,  814,  815,  815,
      812,   11,  812,   13,  816,  816,  817,  817,   18,   18,
      818,  818,  819,  819,  820,  820,  821,  821,  822,  822,
      822,  822,  822,  822,  823,  823,  812,   37,  824,  824,
      818,  818,  822,  822,  812,  812,  812,  812,  812,  812,
      812,  825,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  826,  826,  812,  812,  812,  812,  812,  812,  812,
      812,  827,  812,  825,  828,  827,  827,  812,  812,  827,
      812,  827,  812,  829,  827,  827,  827,  830,  830,  830,

      830,  830,  830,  831,  832,  812,  833,  812,  812,  812,
      812,  834,  812,  835,  836,  812,  837,  837,  812,  812,
      812,  812,  838,  812,  812,  812,  812,  839,  812,  840,
      840,  812,  841,  842,  812,  812,  812,  842,  843,  843,
      844,  812,  845,  812,  812,  812,  812,  812,  812,  812,
      812,  825,  812,  812,  154,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  846,  847,  812,  812,  812,  812,  848,  812,
      812,  812,  826,  826,  812,  812,  825,  827,  827,  154,
      154,  812,  812,  812,  849,  850,  812,  812,  851,  812,

      812,  812,  812,  812,  852,  827,  827,  827,  827,  830,
      812,  812,  812,  812,  812,  831,  812,  832,  833,  812,
      812,  834,  812,  835,  812,  836,  812,  812,  812,  837,
      812,  812,  853,  812,  812,  854,  838,  812,  812,  839,
      812,  812,  812,  840,  812,  812,  812,  812,  812,  812,
      855,  856,  857,  842,  812,  812,  812,  812,  812,  812,
      812,  843,  812,  858,  812,  845,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  154,  812,  277,  154,
      277,  154,  154,  154,  277,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  846,  847,  812,  812,  812,  812,

      848,  826,  277,  849,  850,  850,  851,  812,  812,  812,
      852,  812,  859,  860,  812,  812,  812,  812,  812,  812,
      812,  861,  853,  854,  812,  812,  812,  862,  812,  812,
      812,  863,  812,  864,  865,  866,  812,  812,  867,  812,
      812,  868,  858,  812,  869,  812,  812,  812,  870,  812,
      277,  277,  277,  154,  154,  154,  154,  277,  277,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  826,
      812,  812,  812,  871,  860,  860,  860,  860,  812,  812,
      812,  812,  872,  861,  861,  861,  873,  862,  862,  862,
      874,  863,  863,  863,  812,  875,  876,  812,  877,  867,

      867,  867,  878,  868,  868,  868,  812,  869,  869,  869,
      869,  812,  879,  870,  870,  870,  870,  812,  154,  154,
      154,  154,  277,  277,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  826,  812,  812,  812,  871,
      880,  860,  812,  860,  872,  872,  872,  872,  861,  873,
      873,  873,  873,  862,  874,  874,  874,  874,  863,  881,
      882,  877,  877,  877,  877,  867,  878,  878,  878,  878,
      868,  812,  812,  869,  869,  812,  879,  879,  879,  879,
      879,  870,  870,  812,  154,  154,  154,  154,  277,  277,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,

      812,  812,  826,  812,  812,  812,  880,  507,  507,  507,
      507,  883,  872,  873,  874,  884,  812,  877,  878,  812,
      869,  812,  879,  879,  870,  812,  154,  277,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  826,  812,  812,
      507,  507,  507,  507,  883,  885,  812,  869,  812,  879,
      870,  812,  154,  812,  812,  812,  812,  812,  558,  826,
      826,  826,  826,  812,  812,  886,  812,  812,  812,  869,
      812,  879,  870,  812,  277,  812,  277,  277,  812,  812,
      812,  812,  812,  812,  826,  826,  826,  826,  826,  826,
      812,  565,  882,  812,  812,  812,  869,  812,  887,  812,

      879,  870,  812,  888,  812,  277,  812,  812,  812,  812,
      826,  826,  826,  826,  826,  826,  826,  826,  812,  812,
      812,  812,  812,  869,  812,  889,  879,  870,  812,  890,
      277,  812,  812,  812,  812,  826,  826,  826,  826,  826,
      826,  826,  826,  812,  812,  812,  812,  812,  869,  812,
      891,  869,  812,  889,  889,  892,  889,  879,  870,  812,
      893,  870,  812,  890,  890,  894,  890,  277,  812,  812,
      812,  812,  826,  812,  812,  812,  826,  826,  826,  826,
      826,  812,  812,  812,  812,  869,  869,  812,  869,  869,
      895,  889,  889,  812,  889,  889,  879,  812,  896,  879,

      888,  812,  870,  870,  812,  870,  870,  897,  890,  890,
      812,  890,  890,  277,  812,  812,  812,  812,  826,  812,
      812,  812,  826,  826,  812,  812,  895,  869,  895,  895,
      898,  895,  895,  892,  887,  879,  879,  812,  879,  879,
      899,  899,  870,  812,  897,  897,  900,  897,  897,  894,
      888,  277,  812,  277,  812,  812,  812,  812,  812,  826,
      895,  895,  895,  812,  895,  895,  895,  895,  879,  899,
      899,  901,  899,  899,  899,  897,  897,  897,  812,  897,
      897,  897,  897,  812,  812,  898,  895,  899,  899,  812,
      899,  899,  899,  899,  900,  888,  897,  895,  901,  899,

      897,  895,  899,  897,  895,  899,  897,  895,  899,  897,
      899,    0,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,

      812
    } ;

static yyconst flex_uint16_t yy_nxt[5018] =
    {   0,
       47,   48,   49,   48,   50,   51,   52,   53,   54,   55,
       56,   57,   58,   59,   60,   61,   62,   63,   64,   65,
       66,   66,   67,   68,   69,   70,   71,   47,   72,   72,
       72,   72,   73,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   74,   47,   75,
       47,   72,   72,   72,   72,   76,   77,   78,   72,   79,
       80,   81,   80,   82,   83,   84,   85,   86,   87,   88,
       89,   89,   86,   86,   89,   90,   91,   92,   93,   93,
       93,   94,   89,   95,   96,   97,   87,   98,   99,   98,
       98,  100,   98,   98,   98,   98,   98,  101,   98,   98,

       98,   98,   98,   98,  102,  103,   89,   79,   89,   86,
       98,   98,  102,  103,   79,   87,   79,   98,  105,  289,
      166,  290,  105,  109,  109,  109,  109,  109,  109,  121,
      121,  167,  784,  140,  122,  122,  106,  107,  141,  106,
      106,  107,  140,  106,  586,  110,  587,  141,  110,  111,
      111,  111,  111,  111,  111,  111,  111,  111,  111,  111,
      111,  111,  111,  111,  111,  111,  111,  111,  111,  111,
      111,  111,  111,  111,  111,  111,  111,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  111,  111,  111,  111,

      112,  112,  112,  112,  111,  111,  111,  112,  113,  113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  113,  113,  114,  114,  114,  114,
      114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
      114,  114,  114,  114,  114,  113,  113,  113,  113,  114,
      114,  114,  114,  113,  113,  113,  114,  118,  126,  118,
      137,  118,  118,  126,  137,  131,  119,  118,  184,  118,
      239,  120,  594,  132,  595,  131,  184,  118,  118,  118,
      118,  203,  155,  132,  204,  145,  146,  145,  151,  151,

      151,  147,  163,  152,  145,  146,  145,  164,  138,  156,
      147,  127,  138,  118,  165,  760,  127,  757,  168,  118,
      118,  133,  118,  239,  118,  118,  148,  169,  170,  119,
      118,  133,  118,  231,  120,  148,  206,  207,  232,  756,
      118,  118,  118,  118,  151,  151,  151,  157,  158,  152,
      171,  159,  333,  333,  234,  173,  172,  172,  172,  235,
      174,  160,  269,  194,  194,  194,  118,  175,  159,  160,
      269,  742,  118,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,

      142,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      143,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      142,  142,  142,  142,  143,  143,  143,  143,  142,  142,
      142,  143,  176,  291,  177,  177,  177,  176,  292,  177,
      177,  177,  727,  186,  186,  186,  193,  178,  187,  186,
      186,  186,  178,  197,  187,  198,  198,  198,  194,  194,
      194,  179,  200,  282,  201,  201,  201,  283,  158,  179,
      190,  268,  190,  163,  190,  190,  315,  202,  164,  190,
      190,  316,  190,  301,  190,  220,  220,  220,  268,  301,
      190,  190,  190,  190,  155,  223,  223,  223,  227,  228,

      228,  191,  250,  250,  241,  242,  242,  221,  265,  265,
      265,  156,  191,  229,  726,  231,  190,  225,  192,  243,
      232,  234,  190,  245,  246,  246,  235,  285,  251,  192,
      267,  286,  247,  255,  256,  256,  252,  253,  248,  258,
      259,  259,  247,  258,  259,  259,  395,  395,  257,  270,
      270,  270,  247,  238,  260,  312,  313,  334,  260,  273,
      274,  274,  354,  334,  271,  151,  151,  151,  247,  355,
      152,  282,  724,  285,  275,  283,  284,  286,  287,  172,
      172,  172,  298,  298,  298,  176,  314,  177,  177,  177,
      374,  374,  178,  272,  723,  178,  510,  198,  198,  198,

      178,  272,  299,  276,  299,  719,  543,  300,  300,  300,
      202,  276,  277,  277,  278,  279,  277,  277,  277,  277,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
      280,  280,  280,  280,  280,  280,  280,  280,  280,  280,
      280,  280,  280,  280,  280,  280,  280,  280,  280,  277,
      281,  277,  277,  277,  280,  280,  280,  277,  277,  277,
      277,  186,  186,  186,  718,  588,  187,  303,  716,  303,
      589,  303,  303,  308,  308,  308,  303,  303,  358,  303,
      200,  303,  309,  309,  309,  359,  202,  303,  303,  303,

      303,  310,  715,  310,  714,  202,  300,  300,  300,  220,
      220,  220,  312,  313,  223,  223,  223,  366,  684,  223,
      223,  223,  683,  303,  367,  488,  265,  265,  265,  303,
      306,  221,  306,  488,  306,  306,  225,  312,  313,  306,
      306,  225,  306,  314,  306,  227,  228,  228,  267,  682,
      306,  306,  306,  306,  319,  319,  319,  241,  242,  242,
      229,  427,  492,  320,  325,  325,  325,  500,  314,  321,
      492,  335,  243,  326,  615,  500,  306,  335,  427,  327,
      430,  616,  306,  245,  246,  246,  329,  329,  329,  255,
      256,  256,  351,  352,  353,  330,  622,  430,  248,  681,

      679,  331,  636,  623,  257,  337,  337,  337,  258,  259,
      259,  265,  265,  265,  330,  340,  340,  340,  678,  636,
      338,  668,  336,  260,  330,  270,  270,  270,  336,  668,
      341,  639,  677,  267,  273,  274,  274,  347,  347,  347,
      271,  396,  363,  298,  298,  298,  330,  396,  639,  275,
      364,  673,  348,  300,  300,  300,  178,  312,  313,  363,
      300,  300,  300,  646,  371,  672,  372,  372,  372,  272,
      200,  596,  373,  373,  373,  671,  609,  272,  276,  202,
      646,  276,  300,  300,  300,  202,  276,  663,  314,  276,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,

      277,  277,  277,  277,  277,  277,  277,  277,  277,  375,
      375,  375,  669,  670,  277,  277,  277,  303,  653,  303,
      669,  303,  303,  648,  377,  647,  303,  303,  645,  303,
      670,  303,  379,  379,  379,  542,  543,  303,  303,  303,
      303,  680,  381,  381,  381,  612,  319,  319,  319,  680,
      385,  228,  228,  613,  380,  320,  644,  378,  325,  325,
      325,  321,  612,  303,  382,  386,  544,  326,  643,  303,
      306,  642,  306,  327,  306,  306,  435,  435,  435,  306,
      306,  717,  306,  641,  306,  389,  242,  242,  264,  717,
      306,  306,  306,  306,  329,  329,  329,  393,  246,  246,

      390,  264,  264,  330,  337,  337,  337,  640,  397,  331,
      638,  398,  394,  330,  397,  460,  306,  398,  436,  338,
      637,  460,  306,  401,  256,  256,  340,  340,  340,  405,
      259,  259,  409,  270,  270,  330,  461,  516,  402,  517,
      546,  341,  461,  516,  406,  517,  546,  410,  347,  347,
      347,  415,  274,  274,  437,  437,  437,  330,  371,  635,
      438,  438,  438,  348,  634,  439,  416,  373,  373,  373,
      375,  375,  375,  202,  633,  632,  411,  379,  379,  379,
      202,  375,  375,  375,  411,  377,  375,  375,  375,  375,
      375,  375,  276,  631,  630,  417,  377,  626,  621,  380,

      276,  441,  618,  417,  442,  443,  381,  381,  381,  617,
      446,  319,  319,  614,  566,  385,  228,  228,  378,  447,
      566,  385,  228,  228,  611,  448,  610,  608,  382,  378,
      386,  385,  228,  228,  378,  444,  386,  378,  451,  325,
      325,  389,  242,  242,  607,  593,  449,  452,  389,  242,
      242,  593,  606,  453,  596,  590,  390,  389,  242,  242,
      456,  329,  329,  390,  393,  246,  246,  585,  574,  457,
      571,  510,  454,  504,  558,  458,  393,  246,  246,  394,
      393,  246,  246,  463,  337,  337,  401,  256,  256,  557,
      554,  394,  464,  553,  552,  459,  549,  547,  465,  510,

      538,  402,  401,  256,  256,  401,  256,  256,  619,  468,
      340,  340,  405,  259,  259,  537,  620,  402,  469,  535,
      466,  405,  259,  259,  470,  619,  534,  406,  405,  259,
      259,  472,  472,  472,  530,  529,  406,  409,  270,  270,
      409,  270,  270,  471,  409,  270,  270,  409,  270,  270,
      528,  489,  410,  527,  485,  410,  478,  347,  347,  474,
      485,  526,  410,  522,  520,  479,  503,  415,  274,  274,
      501,  480,  499,  473,  494,  494,  494,  498,  475,  497,
      493,  411,  416,  504,  411,  505,  505,  505,  411,  411,
      491,  411,  411,  495,  495,  495,  411,  490,  489,  411,

      481,  415,  274,  274,  487,  415,  274,  274,  481,  486,
      485,  417,  415,  274,  274,  496,  416,  484,  476,  417,
      482,  435,  435,  435,  434,  433,  371,  416,  506,  506,
      506,  506,  506,  506,  432,  375,  375,  375,  494,  494,
      494,  202,  431,  483,  202,  417,  375,  375,  375,  417,
      441,  429,  428,  417,  426,  425,  417,  417,  424,  423,
      443,  377,  422,  502,  417,  507,  508,  375,  375,  507,
      507,  507,  421,  420,  507,  507,  446,  319,  319,  419,
      507,  510,  418,  378,  413,  447,  412,  507,  507,  507,
      507,  448,  507,  407,  378,  446,  319,  319,  533,  533,

      533,  385,  228,  228,  447,  472,  472,  472,  263,  403,
      448,  399,  391,  507,  511,  507,  449,  446,  319,  319,
      507,  507,  507,  375,  375,  375,  447,  387,  383,  376,
      376,  313,  448,  376,  376,  376,  376,  193,  377,  376,
      376,  376,  376,  376,  536,  536,  536,  473,  376,  370,
      512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
      512,  512,  512,  512,  512,  512,  512,  512,  512,  376,
      297,  378,  369,  512,  512,  512,  512,  446,  319,  319,
      512,  451,  325,  325,  368,  365,  447,  539,  539,  539,
      452,  362,  513,  451,  325,  325,  453,  451,  325,  325,

      361,  504,  452,  540,  540,  540,  452,  360,  453,  451,
      325,  325,  453,  389,  242,  242,  357,  356,  452,  350,
      456,  329,  329,  349,  514,  456,  329,  329,  454,  457,
      456,  329,  329,  346,  457,  458,  393,  246,  246,  457,
      458,  456,  329,  329,  345,  458,  463,  337,  337,  344,
      457,  459,  506,  506,  506,  464,  515,  463,  337,  337,
      291,  465,  463,  337,  337,  202,  464,  463,  337,  337,
      263,  464,  465,  401,  256,  256,  464,  465,  468,  340,
      340,  342,  518,  468,  340,  340,  339,  469,  466,  405,
      259,  259,  469,  470,  468,  340,  340,  332,  470,  468,

      340,  340,  328,  469,  471,  409,  270,  270,  469,  470,
      409,  270,  270,  322,  519,  478,  347,  347,  318,  317,
      474,  495,  495,  495,  479,  410,  478,  347,  347,  217,
      480,  478,  347,  347,  193,  479,  478,  347,  347,  302,
      479,  480,  297,  496,  294,  479,  480,  293,  288,  411,
      263,  523,  521,  261,  411,  238,  236,  411,  233,  481,
      217,  215,  411,  214,  478,  347,  347,  481,  213,  212,
      481,  211,  209,  479,  208,  481,  199,  196,  481,  480,
      481,  189,  185,  481,  415,  274,  274,  182,  481,  415,
      274,  274,  531,  531,  531,  524,  446,  319,  319,  482,

      451,  325,  325,  181,  416,  447,  180,  162,  481,  452,
      161,  513,  153,  812,  532,  514,  481,  456,  329,  329,
      463,  337,  337,  555,  555,  555,  457,  150,  417,  464,
      150,  525,  515,  417,  149,  518,  417,  531,  531,  531,
      149,  417,  507,  508,  375,  375,  507,  507,  507,  136,
      136,  507,  507,  468,  340,  340,  135,  507,  541,  532,
      135,  129,  469,  129,  507,  507,  507,  507,  519,  507,
      478,  347,  347,  124,  409,  270,  270,  124,  116,  479,
      415,  274,  274,  116,  812,  523,  533,  533,  533,  410,
      507,  511,  507,  812,  812,  416,  812,  507,  507,  507,

      375,  375,  375,  548,  556,  556,  556,  376,  812,  551,
      376,  376,  376,  376,  481,  442,  443,  376,  411,  478,
      347,  347,  481,  812,  417,  376,  411,  812,  479,  536,
      536,  536,  417,  812,  480,  564,  564,  564,  409,  270,
      270,  575,  576,  577,  812,  812,  444,  812,  378,  567,
      567,  567,  812,  410,  812,  478,  347,  347,  579,  579,
      579,  550,  812,  481,  479,  570,  415,  274,  274,  812,
      480,  481,  559,  559,  559,  555,  555,  555,  812,  812,
      568,  416,  411,  569,  572,  556,  556,  556,  812,  812,
      411,  578,  812,  573,  581,  581,  581,  812,  812,  481,

      569,  812,  560,  561,  812,  812,  562,  481,  580,  812,
      417,  591,  591,  591,  812,  812,  563,  812,  417,  575,
      576,  577,  812,  562,  563,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  567,  567,  567,  812,  565,  565,
      565,  565,  579,  579,  579,  565,  375,  375,  375,  409,
      270,  270,  812,  376,  812,  812,  376,  376,  376,  376,
      812,  442,  443,  376,  410,  568,  812,  812,  569,  812,
      812,  376,  598,  598,  598,  478,  347,  347,  575,  576,
      577,  599,  812,  812,  479,  569,  812,  600,  597,  812,

      480,  812,  444,  411,  378,  559,  559,  559,  603,  603,
      603,  411,  601,  579,  579,  579,  812,  604,  581,  581,
      581,  812,  812,  605,  812,  598,  598,  598,  812,  481,
      674,  674,  674,  812,  599,  582,  568,  481,  812,  583,
      600,  674,  674,  674,  674,  674,  674,  812,  812,  584,
      722,  722,  722,  725,  725,  725,  583,  584,  507,  508,
      375,  375,  507,  507,  507,  592,  509,  507,  507,  509,
      509,  509,  509,  507,  542,  543,  509,  592,  592,  592,
      507,  507,  507,  507,  509,  507,  592,  592,  592,  592,
      592,  592,  592,  592,  592,  592,  592,  592,  592,  592,

      592,  592,  592,  592,  592,  544,  507,  511,  507,  592,
      592,  592,  592,  507,  507,  507,  592,  415,  274,  274,
      409,  270,  270,  812,  478,  347,  347,  415,  274,  274,
      812,  812,  416,  479,  812,  410,  722,  722,  722,  480,
      812,  812,  416,  812,  603,  603,  603,  812,  675,  675,
      675,  624,  812,  604,  812,  812,  602,  812,  628,  605,
      812,  417,  812,  627,  411,  649,  650,  650,  481,  417,
      676,  417,  411,  812,  651,  812,  481,  812,  812,  417,
      652,  655,  598,  598,  478,  347,  347,  752,  753,  754,
      656,  812,  812,  479,  812,  812,  657,  812,  812,  480,

      812,  659,  660,  660,  665,  603,  603,  812,  812,  411,
      661,  812,  812,  666,  812,  658,  662,  411,  812,  667,
      675,  675,  675,  649,  650,  650,  812,  812,  481,  409,
      270,  270,  651,  675,  675,  675,  481,  812,  652,  650,
      650,  650,  676,  812,  691,  417,  812,  812,  599,  687,
      688,  688,  812,  417,  685,  676,  812,  812,  408,  655,
      598,  598,  812,  812,  689,  812,  812,  411,  656,  655,
      598,  598,  812,  411,  657,  411,  812,  812,  656,  812,
      812,  411,  812,  272,  657,  693,  694,  694,  655,  598,
      598,  272,  812,  690,  656,  812,  812,  656,  812,  812,

      695,  690,  812,  696,  697,  698,  698,  659,  660,  660,
      755,  755,  755,  699,  812,  812,  661,  812,  812,  700,
      812,  812,  662,  698,  698,  698,  704,  705,  705,  415,
      274,  274,  701,  812,  812,  414,  812,  812,  702,  812,
      812,  706,  812,  812,  708,  665,  603,  603,  481,  812,
      812,  417,  812,  812,  666,  812,  481,  812,  812,  417,
      667,  812,  665,  603,  603,  812,  812,  276,  812,  812,
      707,  666,  812,  417,  812,  276,  812,  667,  707,  812,
      812,  417,  710,  711,  711,  665,  603,  603,  720,  720,
      720,  666,  812,  812,  666,  812,  812,  712,  812,  812,

      713,  720,  720,  720,  409,  270,  270,  409,  270,  270,
      721,  812,  812,  728,  812,  812,  728,  812,  812,  410,
      812,  812,  410,  721,  270,  270,  270,  409,  270,  270,
      725,  725,  725,  653,  812,  812,  728,  812,  812,  271,
      812,  812,  474,  409,  270,  270,  812,  812,  411,  812,
      812,  411,  728,  758,  758,  758,  411,  812,  410,  411,
      730,  650,  650,  655,  598,  598,  812,  812,  272,  731,
      812,  411,  734,  812,  475,  732,  272,  812,  657,  411,
      812,  655,  598,  598,  598,  598,  598,  411,  812,  812,
      734,  812,  812,  735,  812,  411,  657,  812,  812,  600,

      655,  598,  598,  812,  733,  655,  598,  598,  812,  734,
      812,  812,  733,  812,  656,  696,  697,  698,  698,  812,
      696,  698,  698,  698,  812,  699,  737,  738,  738,  812,
      701,  700,  720,  720,  720,  479,  702,  478,  347,  347,
      812,  739,  415,  274,  274,  812,  479,  415,  274,  274,
      812,  743,  741,  812,  721,  812,  743,  416,  812,  812,
      481,  812,  416,  812,  812,  276,  812,  812,  481,  812,
      740,  812,  812,  276,  812,  347,  347,  347,  740,  812,
      812,  481,  812,  812,  744,  812,  417,  812,  812,  481,
      348,  417,  812,  812,  417,  415,  274,  274,  812,  417,

      415,  274,  274,  812,  743,  746,  660,  660,  812,  743,
      482,  722,  722,  722,  747,  416,  759,  759,  759,  276,
      748,  665,  603,  603,  725,  725,  725,  276,  812,  812,
      750,  483,  812,  665,  603,  603,  667,  812,  812,  417,
      812,  812,  750,  812,  417,  812,  812,  417,  667,  749,
      812,  812,  417,  603,  603,  603,  812,  749,  665,  603,
      603,  812,  751,  665,  603,  603,  812,  750,  605,  759,
      759,  759,  666,  713,  730,  650,  650,  812,  713,  409,
      270,  270,  812,  731,  730,  650,  650,  812,  812,  761,
      752,  753,  754,  731,  410,  730,  650,  650,  812,  761,

      763,  764,  764,  812,  731,  730,  650,  650,  812,  731,
      761,  755,  755,  755,  731,  765,  812,  812,  733,  812,
      767,  812,  812,  411,  812,  812,  733,  812,  733,  812,
      812,  411,  812,  730,  650,  650,  733,  812,  812,  733,
      812,  812,  731,  812,  766,  812,  812,  733,  761,  733,
      812,  812,  766,  693,  694,  694,  812,  733,  478,  347,
      347,  812,  656,  812,  768,  812,  812,  769,  695,  478,
      347,  347,  812,  480,  347,  347,  347,  733,  769,  478,
      347,  347,  812,  744,  480,  733,  812,  812,  769,  348,
      812,  478,  347,  347,  523,  812,  771,  698,  698,  812,

      769,  812,  481,  812,  812,  772,  480,  752,  753,  754,
      481,  773,  812,  481,  812,  771,  698,  698,  276,  812,
      812,  481,  524,  481,  772,  812,  276,  415,  274,  274,
      775,  481,  746,  660,  660,  481,  746,  660,  660,  812,
      774,  747,  416,  481,  812,  747,  812,  776,  774,  812,
      812,  776,  812,  778,  779,  779,  755,  755,  755,  774,
      812,  812,  747,  746,  660,  660,  812,  774,  780,  812,
      812,  417,  747,  758,  758,  758,  749,  812,  782,  417,
      749,  746,  660,  660,  749,  710,  711,  711,  749,  812,
      747,  758,  758,  758,  666,  812,  776,  781,  812,  812,

      712,  759,  759,  759,  812,  781,  812,  749,  785,  785,
      785,  812,  783,  812,  812,  749,  812,  730,  650,  650,
      730,  650,  650,  812,  812,  749,  731,  812,  812,  786,
      812,  812,  767,  749,  812,  761,  730,  650,  650,  650,
      650,  650,  785,  785,  785,  786,  812,  812,  735,  812,
      812,  761,  812,  812,  685,  812,  730,  650,  650,  812,
      812,  733,  812,  812,  733,  786,  730,  650,  650,  733,
      812,  767,  733,  812,  812,  786,  812,  730,  650,  650,
      733,  761,  812,  272,  812,  812,  731,  812,  733,  812,
      812,  272,  767,  812,  730,  650,  650,  768,  812,  812,

      733,  812,  812,  731,  478,  347,  347,  812,  733,  761,
      733,  812,  812,  479,  812,  771,  698,  698,  733,  480,
      812,  733,  812,  812,  772,  771,  698,  698,  812,  733,
      775,  785,  785,  785,  772,  812,  787,  812,  733,  812,
      775,  812,  789,  790,  790,  812,  733,  812,  481,  812,
      812,  772,  812,  771,  698,  698,  481,  791,  812,  774,
      812,  812,  772,  812,  771,  698,  698,  774,  793,  774,
      812,  812,  812,  772,  771,  698,  698,  774,  812,  775,
      812,  812,  812,  772,  812,  812,  792,  812,  812,  793,
      812,  746,  660,  660,  792,  794,  812,  774,  812,  812,

      747,  812,  746,  660,  660,  774,  782,  812,  774,  812,
      812,  795,  746,  660,  660,  812,  774,  776,  774,  812,
      812,  795,  698,  698,  698,  812,  774,  776,  812,  812,
      812,  796,  746,  660,  660,  749,  812,  702,  812,  812,
      812,  795,  812,  749,  812,  812,  749,  782,  746,  660,
      660,  812,  812,  812,  749,  812,  749,  795,  746,  660,
      660,  812,  812,  776,  749,  812,  276,  747,  763,  764,
      764,  812,  812,  782,  276,  812,  749,  731,  812,  783,
      746,  660,  660,  765,  749,  812,  812,  812,  812,  747,
      812,  812,  749,  812,  812,  776,  730,  650,  650,  812,

      749,  812,  749,  812,  812,  731,  771,  698,  698,  812,
      749,  761,  766,  812,  812,  799,  812,  812,  812,  812,
      766,  775,  797,  812,  749,  798,  771,  698,  698,  698,
      698,  698,  749,  812,  812,  799,  812,  812,  796,  812,
      733,  775,  812,  812,  702,  771,  698,  698,  733,  812,
      774,  812,  812,  812,  799,  812,  812,  812,  774,  812,
      793,  812,  771,  698,  698,  771,  698,  698,  812,  812,
      774,  799,  812,  276,  772,  812,  812,  775,  774,  812,
      793,  276,  812,  771,  698,  698,  778,  779,  779,  774,
      812,  812,  772,  794,  812,  747,  812,  774,  775,  812,

      812,  780,  812,  746,  660,  660,  774,  812,  812,  774,
      812,  812,  747,  812,  774,  812,  812,  774,  776,  730,
      650,  650,  789,  790,  790,  800,  812,  774,  731,  812,
      781,  772,  801,  812,  761,  774,  812,  791,  781,  771,
      698,  698,  746,  660,  660,  812,  802,  749,  772,  812,
      812,  747,  812,  812,  775,  749,  812,  776,  730,  650,
      650,  812,  812,  733,  812,  812,  792,  731,  803,  804,
      812,  733,  812,  761,  792,  746,  660,  660,  771,  698,
      698,  812,  812,  774,  747,  812,  749,  772,  812,  812,
      776,  774,  812,  775,  749,  812,  812,  805,  730,  650,

      650,  812,  733,  812,  812,  806,  812,  731,  812,  812,
      733,  812,  812,  761,  807,  812,  771,  698,  698,  749,
      812,  812,  774,  812,  812,  772,  812,  749,  812,  808,
      774,  775,  746,  660,  660,  812,  730,  650,  650,  812,
      812,  747,  733,  812,  812,  731,  812,  776,  812,  812,
      733,  761,  771,  698,  698,  809,  746,  660,  660,  812,
      774,  772,  812,  810,  812,  747,  812,  775,  774,  812,
      812,  776,  771,  698,  698,  812,  749,  812,  812,  812,
      733,  772,  812,  811,  749,  812,  812,  775,  733,  812,
      812,  812,  812,  812,  812,  812,  774,  812,  812,  812,

      749,  812,  812,  812,  774,  812,  812,  812,  749,  812,
      812,  812,  812,  812,  812,  812,  774,  812,  812,  812,
      812,  812,  812,  812,  774,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  108,  108,  108,
      108,  108,  108,  108,  108,  108,  108,  108,  108,  108,
      108,  108,  108,  108,  108,  108,  108,  108,  115,  115,
      115,  115,  115,  115,  115,  115,  115,  115,  115,  115,

      115,  115,  115,  115,  115,  115,  115,  115,  115,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
      123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
      123,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  128,  128,  128,  128,  128,  128,  128,  128,
      128,  128,  128,  128,  128,  128,  128,  128,  128,  128,
      128,  128,  128,  130,  130,  130,  130,  130,  130,  130,

      130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
      130,  130,  130,  130,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  134,  134,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  183,  812,

      812,  812,  812,  812,  812,  183,  812,  812,  812,  812,
      812,  183,  183,  188,  812,  812,  188,  812,  812,  188,
      188,  812,  812,  812,  812,  188,  188,  188,  195,  812,
      812,  812,  812,  812,  812,  195,  812,  812,  812,  812,
      812,  195,  195,  205,  812,  812,  205,  812,  205,  205,
      210,  812,  812,  812,  812,  812,  812,  210,  812,  812,
      812,  812,  812,  210,  210,  216,  216,  216,  216,  812,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      812,  216,  812,  216,  216,  216,  218,  218,  218,  218,
      812,  218,  218,  218,  218,  218,  218,  218,  218,  218,

      218,  218,  218,  218,  218,  218,  218,  219,  219,  219,
      219,  219,  219,  219,  219,  219,  219,  219,  219,  219,
      219,  219,  219,  219,  812,  219,  219,  219,  222,  812,
      812,  812,  812,  812,  812,  222,  812,  812,  812,  812,
      812,  222,  222,  224,  224,  812,  812,  224,  812,  812,
      812,  812,  812,  812,  224,  812,  224,  812,  812,  812,
      224,  224,  226,  226,  226,  226,  226,  226,  226,  812,
      226,  226,  226,  226,  226,  226,  226,  226,  226,  226,
      226,  226,  226,  230,  230,  230,  230,  230,  230,  230,
      230,  230,  812,  230,  230,  230,  230,  230,  230,  230,

      230,  230,  230,  230,  237,  237,  237,  237,  812,  237,
      237,  237,  237,  237,  237,  237,  237,  237,  237,  237,
      237,  237,  237,  237,  237,  240,  240,  240,  240,  240,
      240,  240,  812,  240,  240,  240,  240,  240,  240,  240,
      240,  240,  240,  240,  240,  240,  244,  244,  244,  244,
      244,  244,  244,  812,  244,  244,  244,  244,  244,  244,
      244,  244,  244,  244,  244,  244,  249,  249,  249,  249,
      249,  249,  249,  249,  249,  249,  249,  249,  249,  249,
      249,  249,  249,  249,  249,  249,  249,  254,  254,  254,
      254,  254,  254,  254,  812,  254,  254,  254,  254,  254,

      254,  254,  254,  254,  254,  254,  254,  254,  262,  262,
      262,  262,  262,  812,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  262,  266,
      266,  812,  812,  266,  812,  812,  812,  812,  812,  812,
      266,  812,  266,  812,  812,  812,  266,  266,  295,  812,
      812,  295,  812,  812,  295,  295,  812,  812,  812,  812,
      295,  295,  295,  296,  296,  296,  296,  296,  296,  296,
      296,  296,  296,  296,  296,  296,  296,  296,  296,  296,
      296,  296,  296,  296,  304,  812,  812,  812,  812,  812,
      812,  304,  812,  812,  812,  812,  812,  304,  304,  305,

      305,  812,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  305,
      307,  812,  812,  307,  812,  812,  307,  307,  812,  812,
      812,  812,  307,  307,  307,  311,  812,  812,  812,  812,
      311,  311,  311,  812,  812,  812,  812,  812,  311,  311,
      323,  812,  812,  323,  812,  812,  323,  323,  812,  812,
      812,  812,  323,  323,  323,  324,  812,  812,  324,  812,
      812,  324,  324,  812,  812,  812,  812,  324,  324,  324,
      343,  812,  812,  812,  812,  812,  812,  343,  812,  812,
      812,  812,  812,  343,  343,  376,  376,  812,  812,  376,

      376,  812,  376,  376,  376,  376,  376,  812,  812,  812,
      812,  376,  376,  376,  384,  384,  384,  384,  384,  384,
      384,  384,  384,  384,  384,  384,  384,  384,  384,  384,
      384,  384,  384,  384,  384,  388,  388,  388,  388,  388,
      388,  388,  388,  388,  388,  388,  388,  388,  388,  388,
      388,  388,  388,  388,  388,  388,  392,  392,  392,  392,
      392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
      392,  392,  392,  392,  392,  392,  392,  400,  400,  400,
      400,  400,  400,  400,  400,  400,  400,  400,  400,  400,
      400,  400,  400,  400,  400,  400,  400,  400,  404,  404,

      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      414,  414,  414,  414,  414,  414,  414,  414,  414,  414,
      414,  414,  414,  414,  414,  414,  414,  414,  414,  414,
      414,  440,  812,  812,  812,  812,  440,  440,  440,  812,
      812,  812,  812,  812,  440,  440,  445,  445,  445,  445,
      445,  445,  445,  445,  445,  445,  445,  445,  445,  445,
      445,  445,  445,  445,  445,  445,  445,  450,  450,  450,

      450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
      450,  450,  450,  450,  450,  450,  450,  450,  455,  455,
      455,  455,  455,  455,  455,  455,  455,  455,  455,  455,
      455,  455,  455,  455,  455,  455,  455,  455,  455,  462,
      462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
      462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  477,  477,  477,  477,  477,  477,  477,  477,  477,
      477,  477,  477,  477,  477,  477,  477,  477,  477,  477,

      477,  477,  509,  509,  509,  509,  509,  509,  509,  509,
      509,  509,  509,  509,  509,  509,  509,  509,  509,  509,
      509,  509,  509,  545,  545,  812,  812,  545,  545,  812,
      545,  545,  545,  545,  545,  812,  812,  812,  812,  545,
      545,  545,  625,  625,  625,  625,  625,  625,  625,  812,
      625,  625,  625,  625,  625,  625,  625,  625,  625,  625,
      625,  625,  625,  629,  629,  629,  629,  629,  629,  629,
      812,  629,  629,  629,  629,  629,  629,  629,  629,  629,
      629,  629,  629,  629,  654,  654,  654,  654,  654,  654,
      654,  654,  654,  654,  654,  654,  654,  654,  654,  654,

      654,  654,  654,  654,  654,  664,  664,  664,  664,  664,
      664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
      664,  664,  664,  664,  664,  664,  686,  686,  686,  686,
      686,  686,  686,  686,  686,  686,  686,  686,  686,  686,
      686,  686,  686,  686,  686,  686,  686,  692,  692,  692,
      692,  692,  692,  692,  692,  692,  692,  692,  692,  692,
      692,  692,  692,  692,  692,  692,  692,  692,  703,  703,
      703,  703,  703,  703,  703,  703,  703,  703,  703,  703,
      703,  703,  703,  703,  703,  703,  703,  703,  703,  709,
      709,  709,  709,  709,  709,  709,  709,  709,  709,  709,

      709,  709,  709,  709,  709,  709,  709,  709,  709,  709,
      729,  729,  729,  729,  729,  729,  729,  729,  729,  729,
      729,  729,  729,  729,  729,  729,  729,  729,  729,  729,
      729,  736,  736,  736,  736,  736,  736,  736,  736,  736,
      736,  736,  736,  736,  736,  736,  736,  736,  736,  736,
      736,  736,  745,  745,  745,  745,  745,  745,  745,  745,
      745,  745,  745,  745,  745,  745,  745,  745,  745,  745,
      745,  745,  745,  762,  762,  762,  762,  762,  762,  762,
      762,  762,  762,  762,  762,  762,  762,  762,  762,  762,
      762,  762,  762,  762,  770,  770,  770,  770,  770,  770,

      770,  770,  770,  770,  770,  770,  770,  770,  770,  770,
      770,  770,  770,  770,  770,  777,  777,  777,  777,  777,
      777,  777,  777,  777,  777,  777,  777,  777,  777,  777,
      777,  777,  777,  777,  777,  777,  788,  788,  788,  788,
      788,  788,  788,  788,  788,  788,  788,  788,  788,  788,
      788,  788,  788,  788,  788,  788,  788,   45,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,

      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812
    } ;

static yyconst flex_int16_t yy_chk[5018] =
    {   0,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,

        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    7,  158,
       60,  158,    8,    9,    9,    9,   10,   10,   10,   19,
       20,   60,  757,   35,   19,   20,    7,    7,   35,    7,
        8,    8,   36,    8,  561,    9,  561,   36,   10,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,

       11,   11,   11,   11,   11,   11,   11,   11,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   17,   23,   17,
       33,   17,   17,   24,   34,   27,   17,   17,   73,   17,
      127,   17,  568,   27,  568,   28,   73,   17,   17,   17,
       17,   94,   52,   28,   94,   39,   39,   39,   48,   48,

       48,   39,   59,   48,   40,   40,   40,   59,   33,   52,
       40,   23,   34,   17,   59,  724,   24,  717,   62,   17,
       18,   27,   18,  127,   18,   18,   39,   62,   62,   18,
       18,   28,   18,  119,   18,   40,   95,   95,  119,  716,
       18,   18,   18,   18,   49,   49,   49,   53,   53,   49,
       63,   53,  250,  250,  121,   64,   63,   63,   63,  121,
       64,   53,  148,  194,  194,  194,   18,   64,   53,   53,
      148,  702,   18,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,

       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   65,  159,   65,   65,   65,   66,  159,   66,
       66,   66,  685,   80,   80,   80,   85,   65,   80,   81,
       81,   81,   66,   91,   81,   91,   91,   91,   85,   85,
       85,   65,   93,  191,   93,   93,   93,  191,  147,   65,
       84,  147,   84,  163,   84,   84,  214,   93,  163,   84,
       84,  214,   84,  848,   84,  109,  109,  109,  147,  848,
       84,   84,   84,   84,  152,  114,  114,  114,  116,  116,

      116,   84,  133,  133,  129,  129,  129,  109,  143,  143,
      143,  152,  187,  116,  684,  231,   84,  114,   84,  129,
      231,  234,   84,  132,  132,  132,  234,  192,  133,  187,
      143,  192,  132,  135,  135,  135,  133,  133,  132,  137,
      137,  137,  135,  136,  136,  136,  333,  333,  135,  149,
      149,  149,  136,  149,  137,  205,  205,  855,  136,  150,
      150,  150,  282,  855,  149,  151,  151,  151,  150,  282,
      151,  155,  680,  156,  150,  155,  155,  156,  156,  172,
      172,  172,  176,  176,  176,  177,  205,  177,  177,  177,
      859,  859,  172,  149,  679,  176,  542,  198,  198,  198,

      177,  149,  178,  150,  178,  673,  542,  178,  178,  178,
      198,  150,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  186,  186,  186,  672,  562,  186,  190,  670,  190,
      562,  190,  190,  200,  200,  200,  190,  190,  285,  190,
      201,  190,  201,  201,  201,  285,  200,  190,  190,  190,

      190,  202,  669,  202,  668,  201,  202,  202,  202,  220,
      220,  220,  311,  311,  223,  223,  223,  291,  648,  224,
      224,  224,  647,  190,  291,  422,  265,  265,  265,  190,
      196,  220,  196,  422,  196,  196,  223,  374,  374,  196,
      196,  224,  196,  311,  196,  227,  227,  227,  265,  646,
      196,  196,  196,  196,  228,  228,  228,  241,  241,  241,
      227,  362,  426,  228,  242,  242,  242,  433,  374,  228,
      426,  856,  241,  242,  588,  433,  196,  856,  362,  242,
      365,  588,  196,  245,  245,  245,  246,  246,  246,  255,
      255,  255,  281,  281,  281,  246,  596,  365,  245,  643,

      641,  246,  611,  596,  255,  256,  256,  256,  258,  258,
      258,  266,  266,  266,  256,  259,  259,  259,  640,  611,
      256,  631,  857,  258,  259,  270,  270,  270,  857,  631,
      259,  614,  639,  266,  273,  273,  273,  274,  274,  274,
      270,  864,  289,  298,  298,  298,  274,  864,  614,  273,
      289,  636,  274,  299,  299,  299,  298,  440,  440,  289,
      300,  300,  300,  621,  308,  635,  308,  308,  308,  270,
      309,  583,  309,  309,  309,  634,  583,  270,  273,  308,
      621,  274,  310,  310,  310,  309,  273,  629,  440,  274,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,

      277,  277,  277,  277,  277,  277,  277,  277,  277,  314,
      314,  314,  632,  633,  277,  277,  277,  303,  625,  303,
      632,  303,  303,  623,  314,  622,  303,  303,  620,  303,
      633,  303,  317,  317,  317,  511,  511,  303,  303,  303,
      303,  642,  318,  318,  318,  586,  319,  319,  319,  642,
      322,  322,  322,  586,  317,  319,  619,  314,  325,  325,
      325,  319,  586,  303,  318,  322,  511,  325,  618,  303,
      306,  617,  306,  325,  306,  306,  370,  370,  370,  306,
      306,  671,  306,  616,  306,  328,  328,  328,  844,  671,
      306,  306,  306,  306,  329,  329,  329,  332,  332,  332,

      328,  844,  844,  329,  337,  337,  337,  615,  865,  329,
      613,  866,  332,  337,  865,  875,  306,  866,  370,  337,
      612,  875,  306,  339,  339,  339,  340,  340,  340,  342,
      342,  342,  345,  345,  345,  340,  876,  881,  339,  882,
      884,  340,  876,  881,  342,  882,  884,  345,  347,  347,
      347,  349,  349,  349,  371,  371,  371,  347,  372,  610,
      372,  372,  372,  347,  609,  373,  349,  373,  373,  373,
      375,  375,  375,  372,  608,  607,  345,  379,  379,  379,
      373,  376,  376,  376,  345,  375,  377,  377,  377,  378,
      378,  378,  347,  606,  605,  349,  376,  600,  595,  379,

      347,  377,  590,  349,  378,  378,  381,  381,  381,  589,
      383,  383,  383,  587,  885,  384,  384,  384,  375,  383,
      885,  385,  385,  385,  585,  383,  584,  582,  381,  376,
      384,  386,  386,  386,  377,  378,  385,  378,  387,  387,
      387,  388,  388,  388,  580,  886,  386,  387,  389,  389,
      389,  886,  578,  387,  569,  563,  388,  390,  390,  390,
      391,  391,  391,  389,  392,  392,  392,  560,  552,  391,
      549,  541,  390,  540,  537,  391,  393,  393,  393,  392,
      394,  394,  394,  399,  399,  399,  400,  400,  400,  535,
      529,  393,  399,  527,  526,  394,  522,  520,  399,  510,

      503,  400,  401,  401,  401,  402,  402,  402,  594,  403,
      403,  403,  404,  404,  404,  502,  594,  401,  403,  500,
      402,  405,  405,  405,  403,  594,  499,  404,  406,  406,
      406,  407,  407,  407,  493,  492,  405,  408,  408,  408,
      409,  409,  409,  406,  410,  410,  410,  411,  411,  411,
      491,  490,  408,  488,  487,  409,  413,  413,  413,  410,
      486,  484,  411,  476,  473,  413,  436,  414,  414,  414,
      434,  413,  432,  407,  428,  428,  428,  431,  411,  430,
      427,  408,  414,  437,  409,  437,  437,  437,  410,  408,
      425,  411,  409,  429,  429,  429,  410,  424,  423,  411,

      413,  415,  415,  415,  421,  416,  416,  416,  413,  420,
      419,  414,  417,  417,  417,  429,  415,  418,  412,  414,
      416,  435,  435,  435,  369,  368,  438,  417,  438,  438,
      438,  439,  439,  439,  367,  442,  442,  442,  494,  494,
      494,  438,  366,  417,  439,  415,  444,  444,  444,  416,
      442,  364,  363,  415,  361,  360,  417,  416,  359,  358,
      442,  444,  357,  435,  417,  441,  441,  441,  441,  441,
      441,  441,  356,  355,  441,  441,  445,  445,  445,  354,
      441,  441,  350,  442,  348,  445,  346,  441,  441,  441,
      441,  445,  441,  344,  444,  446,  446,  446,  498,  498,

      498,  449,  449,  449,  446,  472,  472,  472,  343,  341,
      446,  338,  331,  441,  441,  441,  449,  447,  447,  447,
      441,  441,  441,  443,  443,  443,  447,  327,  321,  443,
      443,  312,  447,  443,  443,  443,  443,  304,  443,  443,
      443,  443,  443,  443,  501,  501,  501,  472,  443,  302,
      443,  443,  443,  443,  443,  443,  443,  443,  443,  443,
      443,  443,  443,  443,  443,  443,  443,  443,  443,  443,
      296,  443,  293,  443,  443,  443,  443,  448,  448,  448,
      443,  450,  450,  450,  292,  290,  448,  504,  504,  504,
      450,  288,  448,  451,  451,  451,  450,  452,  452,  452,

      287,  505,  451,  505,  505,  505,  452,  286,  451,  453,
      453,  453,  452,  454,  454,  454,  284,  283,  453,  276,
      455,  455,  455,  275,  453,  456,  456,  456,  454,  455,
      457,  457,  457,  272,  456,  455,  459,  459,  459,  457,
      456,  458,  458,  458,  271,  457,  462,  462,  462,  269,
      458,  459,  506,  506,  506,  462,  458,  463,  463,  463,
      268,  462,  464,  464,  464,  506,  463,  465,  465,  465,
      264,  464,  463,  466,  466,  466,  465,  464,  467,  467,
      467,  260,  465,  468,  468,  468,  257,  467,  466,  471,
      471,  471,  468,  467,  469,  469,  469,  248,  468,  470,

      470,  470,  243,  469,  471,  474,  474,  474,  470,  469,
      475,  475,  475,  229,  470,  477,  477,  477,  219,  218,
      474,  495,  495,  495,  477,  475,  478,  478,  478,  216,
      477,  479,  479,  479,  195,  478,  480,  480,  480,  184,
      479,  478,  174,  495,  170,  480,  479,  160,  157,  474,
      141,  480,  475,  138,  475,  124,  122,  474,  120,  477,
      104,  103,  475,  102,  481,  481,  481,  477,  101,  100,
      478,   99,   97,  481,   96,  479,   92,   90,  478,  481,
      480,   82,   77,  479,  482,  482,  482,   71,  480,  483,
      483,  483,  497,  497,  497,  481,  513,  513,  513,  482,

      514,  514,  514,   70,  483,  513,   69,   55,  481,  514,
       54,  513,   50,   45,  497,  514,  481,  515,  515,  515,
      518,  518,  518,  530,  530,  530,  515,   44,  482,  518,
       43,  483,  515,  483,   42,  518,  482,  531,  531,  531,
       41,  483,  507,  507,  507,  507,  507,  507,  507,   32,
       31,  507,  507,  519,  519,  519,   30,  507,  507,  531,
       29,   26,  519,   25,  507,  507,  507,  507,  519,  507,
      523,  523,  523,   22,  521,  521,  521,   21,   16,  523,
      525,  525,  525,   15,    0,  523,  533,  533,  533,  521,
      507,  507,  507,    0,    0,  525,    0,  507,  507,  507,

      512,  512,  512,  521,  534,  534,  534,  512,    0,  525,
      512,  512,  512,  512,  523,  512,  512,  512,  521,  524,
      524,  524,  523,    0,  525,  512,  521,    0,  524,  536,
      536,  536,  525,    0,  524,  539,  539,  539,  548,  548,
      548,  553,  553,  553,    0,    0,  512,    0,  512,  547,
      547,  547,    0,  548,    0,  550,  550,  550,  554,  554,
      554,  524,    0,  524,  550,  548,  551,  551,  551,    0,
      550,  524,  538,  538,  538,  555,  555,  555,    0,    0,
      547,  551,  548,  547,  550,  556,  556,  556,    0,    0,
      548,  553,    0,  551,  557,  557,  557,    0,    0,  550,

      547,    0,  538,  538,    0,    0,  538,  550,  554,    0,
      551,  564,  564,  564,    0,    0,  538,    0,  551,  575,
      575,  575,    0,  538,  538,  543,  543,  543,  543,  543,
      543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
      543,  543,  543,  543,  567,  567,  567,    0,  543,  543,
      543,  543,  576,  576,  576,  543,  545,  545,  545,  570,
      570,  570,    0,  545,    0,    0,  545,  545,  545,  545,
        0,  545,  545,  545,  570,  567,    0,    0,  567,    0,
        0,  545,  571,  571,  571,  572,  572,  572,  577,  577,
      577,  571,    0,    0,  572,  567,    0,  571,  570,    0,

      572,    0,  545,  570,  545,  558,  558,  558,  574,  574,
      574,  570,  572,  579,  579,  579,    0,  574,  581,  581,
      581,    0,    0,  574,    0,  598,  598,  598,    0,  572,
      637,  637,  637,    0,  598,  558,  558,  572,    0,  558,
      598,  644,  644,  644,  674,  674,  674,    0,    0,  558,
      678,  678,  678,  681,  681,  681,  558,  558,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,

      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  573,  573,  573,
      597,  597,  597,    0,  601,  601,  601,  602,  602,  602,
        0,    0,  573,  601,    0,  597,  683,  683,  683,  601,
        0,    0,  602,    0,  603,  603,  603,    0,  638,  638,
      638,  597,    0,  603,    0,    0,  573,    0,  602,  603,
        0,  573,    0,  601,  597,  624,  624,  624,  601,  573,
      638,  602,  597,    0,  624,    0,  601,    0,    0,  602,
      624,  626,  626,  626,  627,  627,  627,  714,  714,  714,
      626,    0,    0,  627,    0,    0,  626,    0,    0,  627,

        0,  628,  628,  628,  630,  630,  630,    0,    0,  624,
      628,    0,    0,  630,    0,  627,  628,  624,    0,  630,
      645,  645,  645,  649,  649,  649,    0,    0,  627,  652,
      652,  652,  649,  675,  675,  675,  627,    0,  649,  650,
      650,  650,  645,    0,  652,  628,    0,    0,  650,  651,
      651,  651,    0,  628,  650,  675,    0,    0,  651,  654,
      654,  654,    0,    0,  651,    0,    0,  649,  654,  655,
      655,  655,    0,  652,  654,  649,    0,    0,  655,    0,
        0,  652,    0,  650,  655,  656,  656,  656,  657,  657,
      657,  650,    0,  651,  656,    0,    0,  657,    0,    0,

      656,  651,    0,  657,  658,  658,  658,  659,  659,  659,
      715,  715,  715,  658,    0,    0,  659,    0,    0,  658,
        0,    0,  659,  660,  660,  660,  661,  661,  661,  662,
      662,  662,  660,    0,    0,  661,    0,    0,  660,    0,
        0,  661,    0,    0,  662,  664,  664,  664,  658,    0,
        0,  659,    0,    0,  664,    0,  658,    0,    0,  659,
      664,    0,  665,  665,  665,    0,    0,  660,    0,    0,
      661,  665,    0,  662,    0,  660,    0,  665,  661,    0,
        0,  662,  666,  666,  666,  667,  667,  667,  677,  677,
      677,  666,    0,    0,  667,    0,    0,  666,    0,    0,

      667,  682,  682,  682,  686,  686,  686,  687,  687,  687,
      677,    0,    0,  686,    0,    0,  687,    0,    0,  686,
        0,    0,  687,  682,  688,  688,  688,  689,  689,  689,
      718,  718,  718,  688,    0,    0,  689,    0,    0,  688,
        0,    0,  689,  690,  690,  690,    0,    0,  686,    0,
        0,  687,  690,  719,  719,  719,  686,    0,  690,  687,
      691,  691,  691,  692,  692,  692,    0,    0,  688,  691,
        0,  689,  692,    0,  690,  691,  688,    0,  692,  689,
        0,  693,  693,  693,  694,  694,  694,  690,    0,    0,
      693,    0,    0,  694,    0,  690,  693,    0,    0,  694,

      695,  695,  695,    0,  691,  696,  696,  696,    0,  695,
        0,    0,  691,    0,  696,  695,  697,  697,  697,    0,
      696,  698,  698,  698,    0,  697,  699,  699,  699,    0,
      698,  697,  720,  720,  720,  699,  698,  700,  700,  700,
        0,  699,  703,  703,  703,    0,  700,  704,  704,  704,
        0,  703,  700,    0,  720,    0,  704,  703,    0,    0,
      697,    0,  704,    0,    0,  698,    0,    0,  697,    0,
      699,    0,    0,  698,    0,  705,  705,  705,  699,    0,
        0,  700,    0,    0,  705,    0,  703,    0,    0,  700,
      705,  704,    0,    0,  703,  706,  706,  706,    0,  704,

      707,  707,  707,    0,  706,  708,  708,  708,    0,  707,
      706,  722,  722,  722,  708,  707,  723,  723,  723,  705,
      708,  709,  709,  709,  725,  725,  725,  705,    0,    0,
      709,  707,    0,  710,  710,  710,  709,    0,    0,  706,
        0,    0,  710,    0,  707,    0,    0,  706,  710,  708,
        0,    0,  707,  711,  711,  711,    0,  708,  712,  712,
      712,    0,  711,  713,  713,  713,    0,  712,  711,  726,
      726,  726,  713,  712,  727,  727,  727,    0,  713,  728,
      728,  728,    0,  727,  729,  729,  729,    0,    0,  727,
      752,  752,  752,  729,  728,  730,  730,  730,    0,  729,

      731,  731,  731,    0,  730,  732,  732,  732,    0,  731,
      730,  753,  753,  753,  732,  731,    0,    0,  727,    0,
      732,    0,    0,  728,    0,    0,  727,    0,  729,    0,
        0,  728,    0,  733,  733,  733,  729,    0,    0,  730,
        0,    0,  733,    0,  731,    0,    0,  730,  733,  732,
        0,    0,  731,  734,  734,  734,    0,  732,  736,  736,
      736,    0,  734,    0,  733,    0,    0,  736,  734,  737,
      737,  737,    0,  736,  738,  738,  738,  733,  737,  739,
      739,  739,    0,  738,  737,  733,    0,    0,  739,  738,
        0,  740,  740,  740,  739,    0,  741,  741,  741,    0,

      740,    0,  736,    0,    0,  741,  740,  754,  754,  754,
      736,  741,    0,  737,    0,  742,  742,  742,  738,    0,
        0,  737,  740,  739,  742,    0,  738,  743,  743,  743,
      742,  739,  745,  745,  745,  740,  746,  746,  746,    0,
      741,  745,  743,  740,    0,  746,    0,  745,  741,    0,
        0,  746,    0,  747,  747,  747,  755,  755,  755,  742,
        0,    0,  747,  748,  748,  748,    0,  742,  747,    0,
        0,  743,  748,  756,  756,  756,  745,    0,  748,  743,
      746,  749,  749,  749,  745,  750,  750,  750,  746,    0,
      749,  758,  758,  758,  750,    0,  749,  747,    0,    0,

      750,  759,  759,  759,    0,  747,    0,  748,  760,  760,
      760,    0,  749,    0,    0,  748,    0,  761,  761,  761,
      762,  762,  762,    0,    0,  749,  761,    0,    0,  762,
        0,    0,  761,  749,    0,  762,  763,  763,  763,  764,
      764,  764,  784,  784,  784,  763,    0,    0,  764,    0,
        0,  763,    0,    0,  764,    0,  765,  765,  765,    0,
        0,  761,    0,    0,  762,  765,  766,  766,  766,  761,
        0,  765,  762,    0,    0,  766,    0,  767,  767,  767,
      763,  766,    0,  764,    0,    0,  767,    0,  763,    0,
        0,  764,  767,    0,  768,  768,  768,  766,    0,    0,

      765,    0,    0,  768,  769,  769,  769,    0,  765,  768,
      766,    0,    0,  769,    0,  770,  770,  770,  766,  769,
        0,  767,    0,    0,  770,  771,  771,  771,    0,  767,
      770,  785,  785,  785,  771,    0,  768,    0,  768,    0,
      771,    0,  772,  772,  772,    0,  768,    0,  769,    0,
        0,  772,    0,  773,  773,  773,  769,  772,    0,  770,
        0,    0,  773,    0,  774,  774,  774,  770,  773,  771,
        0,    0,    0,  774,  775,  775,  775,  771,    0,  774,
        0,    0,    0,  775,    0,    0,  772,    0,    0,  775,
        0,  776,  776,  776,  772,  774,    0,  773,    0,    0,

      776,    0,  777,  777,  777,  773,  776,    0,  774,    0,
        0,  777,  778,  778,  778,    0,  774,  777,  775,    0,
        0,  778,  779,  779,  779,    0,  775,  778,    0,    0,
        0,  779,  780,  780,  780,  776,    0,  779,    0,    0,
        0,  780,    0,  776,    0,    0,  777,  780,  781,  781,
      781,    0,    0,    0,  777,    0,  778,  781,  782,  782,
      782,    0,    0,  781,  778,    0,  779,  782,  786,  786,
      786,    0,    0,  782,  779,    0,  780,  786,    0,  781,
      783,  783,  783,  786,  780,    0,    0,    0,    0,  783,
        0,    0,  781,    0,    0,  783,  787,  787,  787,    0,

      781,    0,  782,    0,    0,  787,  788,  788,  788,    0,
      782,  787,  786,    0,    0,  788,    0,    0,    0,    0,
      786,  788,  783,    0,  783,  787,  789,  789,  789,  790,
      790,  790,  783,    0,    0,  789,    0,    0,  790,    0,
      787,  789,    0,    0,  790,  791,  791,  791,  787,    0,
      788,    0,    0,    0,  791,    0,    0,    0,  788,    0,
      791,    0,  792,  792,  792,  793,  793,  793,    0,    0,
      789,  792,    0,  790,  793,    0,    0,  792,  789,    0,
      793,  790,    0,  794,  794,  794,  795,  795,  795,  791,
        0,    0,  794,  792,    0,  795,    0,  791,  794,    0,

        0,  795,    0,  797,  797,  797,  792,    0,    0,  793,
        0,    0,  797,    0,  792,    0,    0,  793,  797,  798,
      798,  798,  799,  799,  799,  794,    0,  794,  798,    0,
      795,  799,  797,    0,  798,  794,    0,  799,  795,  800,
      800,  800,  801,  801,  801,    0,  798,  797,  800,    0,
        0,  801,    0,    0,  800,  797,    0,  801,  802,  802,
      802,    0,    0,  798,    0,    0,  799,  802,  800,  801,
        0,  798,    0,  802,  799,  804,  804,  804,  803,  803,
      803,    0,    0,  800,  804,    0,  801,  803,    0,    0,
      804,  800,    0,  803,  801,    0,    0,  802,  805,  805,

      805,    0,  802,    0,    0,  803,    0,  805,    0,    0,
      802,    0,    0,  805,  804,    0,  806,  806,  806,  804,
        0,    0,  803,    0,    0,  806,    0,  804,    0,  805,
      803,  806,  807,  807,  807,    0,  808,  808,  808,    0,
        0,  807,  805,    0,    0,  808,    0,  807,    0,    0,
      805,  808,  809,  809,  809,  806,  810,  810,  810,    0,
      806,  809,    0,  807,    0,  810,    0,  809,  806,    0,
        0,  810,  811,  811,  811,    0,  807,    0,    0,    0,
      808,  811,    0,  809,  807,    0,    0,  811,  808,    0,
        0,    0,    0,    0,    0,    0,  809,    0,    0,    0,

      810,    0,    0,    0,  809,    0,    0,    0,  810,    0,
        0,    0,    0,    0,    0,    0,  811,    0,    0,    0,
        0,    0,    0,    0,  811,  813,  813,  813,  813,  813,
      813,  813,  813,  813,  813,  813,  813,  813,  813,  813,
      813,  813,  813,  813,  813,  813,  814,  814,  814,  814,
      814,  814,  814,  814,  814,  814,  814,  814,  814,  814,
      814,  814,  814,  814,  814,  814,  814,  815,  815,  815,
      815,  815,  815,  815,  815,  815,  815,  815,  815,  815,
      815,  815,  815,  815,  815,  815,  815,  815,  816,  816,
      816,  816,  816,  816,  816,  816,  816,  816,  816,  816,

      816,  816,  816,  816,  816,  816,  816,  816,  816,  817,
      817,  817,  817,  817,  817,  817,  817,  817,  817,  817,
      817,  817,  817,  817,  817,  817,  817,  817,  817,  817,
      818,  818,  818,  818,  818,  818,  818,  818,  818,  818,
      818,  818,  818,  818,  818,  818,  818,  818,  818,  818,
      818,  819,  819,  819,  819,  819,  819,  819,  819,  819,
      819,  819,  819,  819,  819,  819,  819,  819,  819,  819,
      819,  819,  820,  820,  820,  820,  820,  820,  820,  820,
      820,  820,  820,  820,  820,  820,  820,  820,  820,  820,
      820,  820,  820,  821,  821,  821,  821,  821,  821,  821,

      821,  821,  821,  821,  821,  821,  821,  821,  821,  821,
      821,  821,  821,  821,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  823,  823,  823,  823,  823,
      823,  823,  823,  823,  823,  823,  823,  823,  823,  823,
      823,  823,  823,  823,  823,  823,  824,  824,  824,  824,
      824,  824,  824,  824,  824,  824,  824,  824,  824,  824,
      824,  824,  824,  824,  824,  824,  824,  825,  825,  825,
      825,  825,  825,  825,  825,  825,  825,  825,  825,  825,
      825,  825,  825,  825,  825,  825,  825,  825,  826,    0,

        0,    0,    0,    0,    0,  826,    0,    0,    0,    0,
        0,  826,  826,  827,    0,    0,  827,    0,    0,  827,
      827,    0,    0,    0,    0,  827,  827,  827,  828,    0,
        0,    0,    0,    0,    0,  828,    0,    0,    0,    0,
        0,  828,  828,  829,    0,    0,  829,    0,  829,  829,
      830,    0,    0,    0,    0,    0,    0,  830,    0,    0,
        0,    0,    0,  830,  830,  831,  831,  831,  831,    0,
      831,  831,  831,  831,  831,  831,  831,  831,  831,  831,
        0,  831,    0,  831,  831,  831,  832,  832,  832,  832,
        0,  832,  832,  832,  832,  832,  832,  832,  832,  832,

      832,  832,  832,  832,  832,  832,  832,  833,  833,  833,
      833,  833,  833,  833,  833,  833,  833,  833,  833,  833,
      833,  833,  833,  833,    0,  833,  833,  833,  834,    0,
        0,    0,    0,    0,    0,  834,    0,    0,    0,    0,
        0,  834,  834,  835,  835,    0,    0,  835,    0,    0,
        0,    0,    0,    0,  835,    0,  835,    0,    0,    0,
      835,  835,  836,  836,  836,  836,  836,  836,  836,    0,
      836,  836,  836,  836,  836,  836,  836,  836,  836,  836,
      836,  836,  836,  837,  837,  837,  837,  837,  837,  837,
      837,  837,    0,  837,  837,  837,  837,  837,  837,  837,

      837,  837,  837,  837,  838,  838,  838,  838,    0,  838,
      838,  838,  838,  838,  838,  838,  838,  838,  838,  838,
      838,  838,  838,  838,  838,  839,  839,  839,  839,  839,
      839,  839,    0,  839,  839,  839,  839,  839,  839,  839,
      839,  839,  839,  839,  839,  839,  840,  840,  840,  840,
      840,  840,  840,    0,  840,  840,  840,  840,  840,  840,
      840,  840,  840,  840,  840,  840,  841,  841,  841,  841,
      841,  841,  841,  841,  841,  841,  841,  841,  841,  841,
      841,  841,  841,  841,  841,  841,  841,  842,  842,  842,
      842,  842,  842,  842,    0,  842,  842,  842,  842,  842,

      842,  842,  842,  842,  842,  842,  842,  842,  843,  843,
      843,  843,  843,    0,  843,  843,  843,  843,  843,  843,
      843,  843,  843,  843,  843,  843,  843,  843,  843,  845,
      845,    0,    0,  845,    0,    0,    0,    0,    0,    0,
      845,    0,  845,    0,    0,    0,  845,  845,  846,    0,
        0,  846,    0,    0,  846,  846,    0,    0,    0,    0,
      846,  846,  846,  847,  847,  847,  847,  847,  847,  847,
      847,  847,  847,  847,  847,  847,  847,  847,  847,  847,
      847,  847,  847,  847,  849,    0,    0,    0,    0,    0,
        0,  849,    0,    0,    0,    0,    0,  849,  849,  850,

      850,    0,  850,  850,  850,  850,  850,  850,  850,  850,
      850,  850,  850,  850,  850,  850,  850,  850,  850,  850,
      851,    0,    0,  851,    0,    0,  851,  851,    0,    0,
        0,    0,  851,  851,  851,  852,    0,    0,    0,    0,
      852,  852,  852,    0,    0,    0,    0,    0,  852,  852,
      853,    0,    0,  853,    0,    0,  853,  853,    0,    0,
        0,    0,  853,  853,  853,  854,    0,    0,  854,    0,
        0,  854,  854,    0,    0,    0,    0,  854,  854,  854,
      858,    0,    0,    0,    0,    0,    0,  858,    0,    0,
        0,    0,    0,  858,  858,  860,  860,    0,    0,  860,

      860,    0,  860,  860,  860,  860,  860,    0,    0,    0,
        0,  860,  860,  860,  861,  861,  861,  861,  861,  861,
      861,  861,  861,  861,  861,  861,  861,  861,  861,  861,
      861,  861,  861,  861,  861,  862,  862,  862,  862,  862,
      862,  862,  862,  862,  862,  862,  862,  862,  862,  862,
      862,  862,  862,  862,  862,  862,  863,  863,  863,  863,
      863,  863,  863,  863,  863,  863,  863,  863,  863,  863,
      863,  863,  863,  863,  863,  863,  863,  867,  867,  867,
      867,  867,  867,  867,  867,  867,  867,  867,  867,  867,
      867,  867,  867,  867,  867,  867,  867,  867,  868,  868,

      868,  868,  868,  868,  868,  868,  868,  868,  868,  868,
      868,  868,  868,  868,  868,  868,  868,  868,  868,  869,
      869,  869,  869,  869,  869,  869,  869,  869,  869,  869,
      869,  869,  869,  869,  869,  869,  869,  869,  869,  869,
      870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
      870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
      870,  871,    0,    0,    0,    0,  871,  871,  871,    0,
        0,    0,    0,    0,  871,  871,  872,  872,  872,  872,
      872,  872,  872,  872,  872,  872,  872,  872,  872,  872,
      872,  872,  872,  872,  872,  872,  872,  873,  873,  873,

      873,  873,  873,  873,  873,  873,  873,  873,  873,  873,
      873,  873,  873,  873,  873,  873,  873,  873,  874,  874,
      874,  874,  874,  874,  874,  874,  874,  874,  874,  874,
      874,  874,  874,  874,  874,  874,  874,  874,  874,  877,
      877,  877,  877,  877,  877,  877,  877,  877,  877,  877,
      877,  877,  877,  877,  877,  877,  877,  877,  877,  877,
      878,  878,  878,  878,  878,  878,  878,  878,  878,  878,
      878,  878,  878,  878,  878,  878,  878,  878,  878,  878,
      878,  879,  879,  879,  879,  879,  879,  879,  879,  879,
      879,  879,  879,  879,  879,  879,  879,  879,  879,  879,

      879,  879,  880,  880,  880,  880,  880,  880,  880,  880,
      880,  880,  880,  880,  880,  880,  880,  880,  880,  880,
      880,  880,  880,  883,  883,    0,    0,  883,  883,    0,
      883,  883,  883,  883,  883,    0,    0,    0,    0,  883,
      883,  883,  887,  887,  887,  887,  887,  887,  887,    0,
      887,  887,  887,  887,  887,  887,  887,  887,  887,  887,
      887,  887,  887,  888,  888,  888,  888,  888,  888,  888,
        0,  888,  888,  888,  888,  888,  888,  888,  888,  888,
      888,  888,  888,  888,  889,  889,  889,  889,  889,  889,
      889,  889,  889,  889,  889,  889,  889,  889,  889,  889,

      889,  889,  889,  889,  889,  890,  890,  890,  890,  890,
      890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
      890,  890,  890,  890,  890,  890,  891,  891,  891,  891,
      891,  891,  891,  891,  891,  891,  891,  891,  891,  891,
      891,  891,  891,  891,  891,  891,  891,  892,  892,  892,
      892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
      892,  892,  892,  892,  892,  892,  892,  892,  893,  893,
      893,  893,  893,  893,  893,  893,  893,  893,  893,  893,
      893,  893,  893,  893,  893,  893,  893,  893,  893,  894,
      894,  894,  894,  894,  894,  894,  894,  894,  894,  894,

      894,  894,  894,  894,  894,  894,  894,  894,  894,  894,
      895,  895,  895,  895,  895,  895,  895,  895,  895,  895,
      895,  895,  895,  895,  895,  895,  895,  895,  895,  895,
      895,  896,  896,  896,  896,  896,  896,  896,  896,  896,
      896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
      896,  896,  897,  897,  897,  897,  897,  897,  897,  897,
      897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
      897,  897,  897,  898,  898,  898,  898,  898,  898,  898,
      898,  898,  898,  898,  898,  898,  898,  898,  898,  898,
      898,  898,  898,  898,  899,  899,  899,  899,  899,  899,

      899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
      899,  899,  899,  899,  899,  900,  900,  900,  900,  900,
      900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
      900,  900,  900,  900,  900,  900,  901,  901,  901,  901,
      901,  901,  901,  901,  901,  901,  901,  901,  901,  901,
      901,  901,  901,  901,  901,  901,  901,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,

      812,  812,  812,  812,  812,  812,  812,  812,  812,  812,
      812,  812,  812,  812,  812,  812,  812
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[152] =
    {   0,
1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 
    1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 
    0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 
    0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
    1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int base_yy_flex_debug;
int base_yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *base_yytext;
#line 1 "pgc.l"

#line 30 "pgc.l"
extern YYSTYPE base_yylval;

static int		xcdepth = 0;	/* depth of nesting in slash-star comments */
static char	   *dolqstart = NULL;	/* current $foo$ quote start string */
static YY_BUFFER_STATE scanbufhandle;
static char *scanbuf;

/*
 * literalbuf is used to accumulate literal values when multiple rules
 * are needed to parse a single literal.  Call startlit to reset buffer
 * to empty, addlit to add text.  Note that the buffer is permanently
 * malloc'd to the largest size needed so far in the current run.
 */
static char	   *literalbuf = NULL;		/* expandable buffer */
static int		literallen;				/* actual current length */
static int		literalalloc;			/* current allocated buffer size */

/* Used for detecting global state together with braces_open */
static int		parenths_open;

/* Used to tell parse_include() whether the command was #include or #include_next */
static bool		include_next;

#define startlit()	(literalbuf[0] = '\0', literallen = 0)
static void addlit(char *ytext, int yleng);
static void addlitchar (unsigned char);
static void parse_include (void);
static bool ecpg_isspace(char ch);
static bool isdefine(void);
static bool isinformixdefine(void);

char *token_start;
static int state_before;

struct _yy_buffer
{
	YY_BUFFER_STATE		buffer;
	long				lineno;
	char			   *filename;
	struct _yy_buffer  *next;
} *yy_buffer = NULL;

static char *old;

#define MAX_NESTED_IF 128
static short preproc_tos;
static short ifcond;
static struct _if_value
{
	short condition;
	short else_branch;
} stacked_if_value[MAX_NESTED_IF];

#define YY_NO_INPUT 1

/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *	<xb> bit string literal
 *	<xcc> extended C-style comments in C
 *	<xcsql> extended C-style comments in SQL
 *	<xd> delimited identifiers (double-quoted identifiers) - thomas 1997-10-27
 *	<xh> hexadecimal numeric string - thomas 1997-11-16
 *	<xq> standard quoted strings - thomas 1997-07-30
 *	<xqc> standard quoted strings in C - michael
 *	<xe> extended quoted strings (support backslash escape sequences)
 *	<xn> national character quoted strings
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 */















/* Bit string
 */
/* Hexadecimal number */
/* National character */
/* Quoted string that allows backslash escapes */
/* C version of hex number */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Unicode escapes */
/* (The ecpg scanner is not backup-free, so the fail rules in scan.l are not needed here, but could be added if desired.) */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* special stuff for C strings */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!	Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *	  {operator} would. Then the tie-breaker (first matching rule of same
 *	  length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *	  in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *	  if found throw it back with yyless().  This handles the plus-slash-star
 *	  problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.	"op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/* we no longer allow unary minus in numbers.
 * instead we pass it separately to parser. there it gets
 * coerced via doNegate() -- Leon aug 20 1999
 *
 * {realfail1} and {realfail2} are added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  SQL-style comments, which start with -- and extend to the
 * next newline, are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix ecpg_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* special characters for other dbms */
/* we have to react differently in compat mode */
/* some stuff needed for ecpg */
/* we might want to parse all cpp include files */
/* take care of cpp lines, they may also be continuated */
/* first a general line for all commands not starting with "i" */
/* and then the other commands starting with "i", we have to add these
 * separately because the cppline production would match on "include" too */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *	and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *	style of two adjacent single quotes "''" and in the Postgres/Java style
 *	of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *	backslash is dropped from the string. - thomas 1997-09-24
 * Note that xcstart must appear before operator, as explained above!
 *	Also whitespace (comment) must appear before operator.
 */
#line 2124 "pgc.c"

#define INITIAL 0
#define C 1
#define SQL 2
#define incl 3
#define def 4
#define def_ident 5
#define undef 6
#define xb 7
#define xcc 8
#define xcsql 9
#define xd 10
#define xdc 11
#define xh 12
#define xe 13
#define xn 14
#define xq 15
#define xqc 16
#define xdolq 17
#define xcond 18
#define xskip 19
#define xui 20
#define xus 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int base_yylex_destroy (void );

int base_yyget_debug (void );

void base_yyset_debug (int debug_flag  );

YY_EXTRA_TYPE base_yyget_extra (void );

void base_yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *base_yyget_in (void );

void base_yyset_in  (FILE * _in_str  );

FILE *base_yyget_out (void );

void base_yyset_out  (FILE * _out_str  );

			int base_yyget_leng (void );

char *base_yyget_text (void );

int base_yyget_lineno (void );

void base_yyset_lineno (int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int base_yywrap (void );
#else
extern int base_yywrap (void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput (int c,char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( base_yytext, (size_t) base_yyleng, 1, base_yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( base_yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( base_yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, max_size, base_yyin))==0 && ferror(base_yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(base_yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int base_yylex (void);

#define YY_DECL int base_yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after base_yytext and base_yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! base_yyin )
			base_yyin = stdin;

		if ( ! base_yyout )
			base_yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			base_yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				base_yy_create_buffer(base_yyin,YY_BUF_SIZE );
		}

		base_yy_load_buffer_state( );
		}

	{
#line 376 "pgc.l"



		/* code to execute during start of each call of base_yylex() */
		token_start = NULL;


#line 2371 "pgc.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of base_yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 813 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 812 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < base_yyleng; ++yyl )
				if ( base_yytext[yyl] == '\n' )
					
    base_yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 383 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 385 "pgc.l"
{
					token_start = base_yytext;
					state_before = YYSTATE;
					xcdepth = 0;
					BEGIN(xcc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", base_yyout);
				}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 394 "pgc.l"
{
					token_start = base_yytext;
					state_before = YYSTATE;
					xcdepth = 0;
					BEGIN(xcsql);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", base_yyout);
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 403 "pgc.l"
{ ECHO; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 404 "pgc.l"
{
					xcdepth++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/_*", base_yyout);
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 410 "pgc.l"
{
					if (xcdepth <= 0)
					{
						ECHO;
						BEGIN(state_before);
						token_start = NULL;
					}
					else
					{
						xcdepth--;
						fputs("*_/", base_yyout);
					}
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 423 "pgc.l"
{
					ECHO;
					BEGIN(state_before);
					token_start = NULL;
				}
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 428 "pgc.l"
{ ECHO; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 429 "pgc.l"
{ ECHO; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 430 "pgc.l"
{ ECHO; }
	YY_BREAK
case YY_STATE_EOF(xcc):
case YY_STATE_EOF(xcsql):
#line 432 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated /* comment"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 434 "pgc.l"
{
					token_start = base_yytext;
					BEGIN(xb);
					startlit();
					addlitchar('b');
				}
	YY_BREAK
case 12:
/* rule 12 can match eol */
#line 441 "pgc.l"
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 441 "pgc.l"
{
					yyless(1);
					BEGIN(SQL);
					if (literalbuf[strspn(literalbuf, "01") + 1] != '\0')
						mmerror(PARSE_ERROR, ET_ERROR, "invalid bit string literal");
					base_yylval.str = mm_strdup(literalbuf);
					return BCONST;
				}
	YY_BREAK
case 14:
/* rule 14 can match eol */
#line 451 "pgc.l"
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 451 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 16:
/* rule 16 can match eol */
#line 453 "pgc.l"
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 453 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case YY_STATE_EOF(xb):
#line 454 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated bit string literal"); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 456 "pgc.l"
{
					token_start = base_yytext;
					BEGIN(xh);
					startlit();
					addlitchar('x');
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 463 "pgc.l"
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 463 "pgc.l"
{
				yyless(1);
				BEGIN(SQL);
				base_yylval.str = mm_strdup(literalbuf);
				return XCONST;
			}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 470 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated hexadecimal string literal"); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 471 "pgc.l"
{
				/* National character.
				 * Transfer it as-is to the backend.
				 */
				token_start = base_yytext;
				state_before = YYSTATE;
				BEGIN(xn);
				startlit();
			}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 480 "pgc.l"
{
				token_start = base_yytext;
				state_before = YYSTATE;
				BEGIN(xqc);
				startlit();
			}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 486 "pgc.l"
{
				token_start = base_yytext;
				state_before = YYSTATE;
				BEGIN(xq);
				startlit();
			}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 492 "pgc.l"
{
				token_start = base_yytext;
				state_before = YYSTATE;
				BEGIN(xe);
				startlit();
			}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 498 "pgc.l"
{
				token_start = base_yytext;
				state_before = YYSTATE;
				BEGIN(xus);
				startlit();
				addlit(base_yytext, base_yyleng);
			}
	YY_BREAK
case 26:
/* rule 26 can match eol */
#line 506 "pgc.l"
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 506 "pgc.l"
{
				yyless(1);
				BEGIN(state_before);
				base_yylval.str = mm_strdup(literalbuf);
				return SCONST;
			}
	YY_BREAK
case 28:
/* rule 28 can match eol */
#line 513 "pgc.l"
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 513 "pgc.l"
{
				yyless(1);
				BEGIN(state_before);
				base_yylval.str = mm_strdup(literalbuf);
				return ECONST;
			}
	YY_BREAK
case 30:
/* rule 30 can match eol */
#line 520 "pgc.l"
case 31:
/* rule 31 can match eol */
YY_RULE_SETUP
#line 520 "pgc.l"
{
				yyless(1);
				BEGIN(state_before);
				base_yylval.str = mm_strdup(literalbuf);
				return NCONST;
			}
	YY_BREAK
case 32:
/* rule 32 can match eol */
YY_RULE_SETUP
#line 526 "pgc.l"
{
				addlit(base_yytext, base_yyleng);
				BEGIN(state_before);
				base_yylval.str = mm_strdup(literalbuf);
				return UCONST;
			}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 532 "pgc.l"
{ addlitchar('\''); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 533 "pgc.l"
{
				addlitchar('\\');
				addlitchar('\'');
			}
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 537 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 538 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 539 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 38:
/* rule 38 can match eol */
YY_RULE_SETUP
#line 540 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 541 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 542 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 41:
/* rule 41 can match eol */
YY_RULE_SETUP
#line 543 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 544 "pgc.l"
{
			   /* This is only needed for \ just before EOF */
			   addlitchar(base_yytext[0]);
			}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xqc):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xn):
case YY_STATE_EOF(xus):
#line 548 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 549 "pgc.l"
{
				/* throw back all but the initial "$" */
				yyless(1);
				/* and treat it as {other} */
				return base_yytext[0];
			}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 555 "pgc.l"
{
				token_start = base_yytext;
				if (dolqstart)
					free(dolqstart);
				dolqstart = mm_strdup(base_yytext);
				BEGIN(xdolq);
				startlit();
				addlit(base_yytext, base_yyleng);
			}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 564 "pgc.l"
{
				if (strcmp(base_yytext, dolqstart) == 0)
				{
					addlit(base_yytext, base_yyleng);
					free(dolqstart);
					dolqstart = NULL;
					BEGIN(SQL);
					base_yylval.str = mm_strdup(literalbuf);
					return DOLCONST;
				}
				else
				{
					/*
					 * When we fail to match $...$ to dolqstart, transfer
					 * the $... part to the output, but put back the final
					 * $ for rescanning.  Consider $delim$...$junk$delim$
					 */
					addlit(base_yytext, base_yyleng-1);
					yyless(base_yyleng-1);
				}
			}
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
#line 585 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 586 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 587 "pgc.l"
{
				/* single quote or dollar sign */
				addlitchar(base_yytext[0]);
			}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 591 "pgc.l"
{ base_yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 592 "pgc.l"
{
						state_before = YYSTATE;
						BEGIN(xd);
						startlit();
					}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 597 "pgc.l"
{
						state_before = YYSTATE;
						BEGIN(xui);
						startlit();
						addlit(base_yytext, base_yyleng);
					}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 603 "pgc.l"
{
						BEGIN(state_before);
						if (literallen == 0)
							mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
						/* The backend will truncate the identifier here. We do not as it does not change the result. */
						base_yylval.str = mm_strdup(literalbuf);
						return CSTRING;
					}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 611 "pgc.l"
{
						BEGIN(state_before);
						base_yylval.str = mm_strdup(literalbuf);
						return CSTRING;
					}
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 616 "pgc.l"
{
						BEGIN(state_before);
						if (literallen == 2) /* "U&" */
							mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
						/* The backend will truncate the identifier here. We do not as it does not change the result. */
						addlit(base_yytext, base_yyleng);
						base_yylval.str = mm_strdup(literalbuf);
						return UIDENT;
					}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 625 "pgc.l"
{ addlitchar('"'); }
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 626 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xdc):
case YY_STATE_EOF(xui):
#line 627 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted identifier"); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 628 "pgc.l"
{
						state_before = YYSTATE;
						BEGIN(xdc);
						startlit();
					}
	YY_BREAK
case 57:
/* rule 57 can match eol */
YY_RULE_SETUP
#line 633 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 634 "pgc.l"
{ return TYPECAST; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 635 "pgc.l"
{ return DOT_DOT; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 636 "pgc.l"
{ return COLON_EQUALS; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 637 "pgc.l"
{ return EQUALS_GREATER; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 638 "pgc.l"
{ return LESS_EQUALS; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 639 "pgc.l"
{ return GREATER_EQUALS; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 640 "pgc.l"
{ return NOT_EQUALS; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 641 "pgc.l"
{ return NOT_EQUALS; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 642 "pgc.l"
{
			  /* are we simulating Informix? */
				if (INFORMIX_MODE)
				{
					unput(':');
				}
				else
					return base_yytext[0];
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 651 "pgc.l"
{ /*
					   * We may find a ';' inside a structure
					   * definition in a TYPE or VAR statement.
					   * This is not an EOL marker.
					   */
					  if (base_yytext[0] == ';' && struct_level == 0)
						 BEGIN(C);
					  return base_yytext[0];
					}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 660 "pgc.l"
{
						/*
						 * Check for embedded slash-star or dash-dash; those
						 * are comment starts, so operator must stop there.
						 * Note that slash-star or dash-dash at the first
						 * character will match a prior rule, not this one.
						 */
						int		nchars = base_yyleng;
						char   *slashstar = strstr(base_yytext, "/*");
						char   *dashdash = strstr(base_yytext, "--");

						if (slashstar && dashdash)
						{
							/* if both appear, take the first one */
							if (slashstar > dashdash)
								slashstar = dashdash;
						}
						else if (!slashstar)
							slashstar = dashdash;
						if (slashstar)
							nchars = slashstar - base_yytext;

						/*
						 * For SQL compatibility, '+' and '-' cannot be the
						 * last char of a multi-char operator unless the operator
						 * contains chars that are not in SQL operators.
						 * The idea is to lex '=-' as two operators, but not
						 * to forbid operator names like '?-' that could not be
						 * sequences of SQL operators.
						 */
						while (nchars > 1 &&
							   (base_yytext[nchars-1] == '+' ||
								base_yytext[nchars-1] == '-'))
						{
							int		ic;

							for (ic = nchars-2; ic >= 0; ic--)
							{
								if (strchr("~!@#^&|`?%", base_yytext[ic]))
									break;
							}
							if (ic >= 0)
								break; /* found a char that makes it OK */
							nchars--; /* else remove the +/-, and check again */
						}

						if (nchars < base_yyleng)
						{
							/* Strip the unwanted chars from the token */
							yyless(nchars);
							/*
							 * If what we have left is only one char, and it's
							 * one of the characters matching "self", then
							 * return it as a character token the same way
							 * that the "self" rule would have.
							 */
							if (nchars == 1 &&
								strchr(",()[].;:+-*/%^<>=", base_yytext[0]))
								return base_yytext[0];
						}

						base_yylval.str = mm_strdup(base_yytext);
						return Op;
					}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 724 "pgc.l"
{
						base_yylval.ival = atol(base_yytext+1);
						return PARAM;
					}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 728 "pgc.l"
{
						long val;
						char* endptr;

						errno = 0;
						val = strtol((char *)base_yytext, &endptr,10);
						if (*endptr != '\0' || errno == ERANGE
#ifdef HAVE_LONG_INT_64
							/* if long > 32 bits, check for overflow of int4 */
							|| val != (long) ((int32) val)
#endif
							)
						{
							errno = 0;
							base_yylval.str = mm_strdup(base_yytext);
							return FCONST;
						}
						base_yylval.ival = val;
						return ICONST;
					}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 748 "pgc.l"
{
						base_yylval.str = mm_strdup(base_yytext);
						return IP;
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 752 "pgc.l"
{
						base_yylval.str = mm_strdup(base_yytext);
						return FCONST;
			}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 756 "pgc.l"
{
						base_yylval.str = mm_strdup(base_yytext);
						return FCONST;
			}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 760 "pgc.l"
{
						yyless(base_yyleng-1);
						base_yylval.str = mm_strdup(base_yytext);
						return FCONST;
					}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 765 "pgc.l"
{
						yyless(base_yyleng-2);
						base_yylval.str = mm_strdup(base_yytext);
						return FCONST;
					}
	YY_BREAK
case 76:
/* rule 76 can match eol */
YY_RULE_SETUP
#line 770 "pgc.l"
{
						base_yylval.str = mm_strdup(base_yytext+1);
						return(CVARIABLE);
					}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 774 "pgc.l"
{
						const ScanKeyword  *keyword;

						if (!isdefine())
						{
							/* Is it an SQL/ECPG keyword? */
							keyword = ScanECPGKeywordLookup(base_yytext);
							if (keyword != NULL)
								return keyword->value;

							/* Is it a C keyword? */
							keyword = ScanCKeywordLookup(base_yytext);
							if (keyword != NULL)
								return keyword->value;

							/*
							 * None of the above.  Return it as an identifier.
							 *
							 * The backend will attempt to truncate and case-fold
							 * the identifier, but I see no good reason for ecpg
							 * to do so; that's just another way that ecpg could get
							 * out of step with the backend.
							 */
							base_yylval.str = mm_strdup(base_yytext);
							return IDENT;
						}
					}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 801 "pgc.l"
{ return base_yytext[0]; }
	YY_BREAK
case 79:
/* rule 79 can match eol */
YY_RULE_SETUP
#line 802 "pgc.l"
{ BEGIN(SQL); return SQL_START; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 803 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(SQL);
							return SQL_START;
						}
						else
							return S_ANYTHING;
					 }
	YY_BREAK
case 81:
/* rule 81 can match eol */
YY_RULE_SETUP
#line 813 "pgc.l"
{ ECHO; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 814 "pgc.l"
{
						char* endptr;

						errno = 0;
						base_yylval.ival = strtoul((char *)base_yytext,&endptr,16);
						if (*endptr != '\0' || errno == ERANGE)
						{
							errno = 0;
							base_yylval.str = mm_strdup(base_yytext);
							return SCONST;
						}
						return ICONST;
					}
	YY_BREAK
case 83:
/* rule 83 can match eol */
YY_RULE_SETUP
#line 827 "pgc.l"
{
						if (system_includes)
						{
							include_next = false;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(base_yytext);
							return(CPP_LINE);
						}
					}
	YY_BREAK
case 84:
/* rule 84 can match eol */
YY_RULE_SETUP
#line 839 "pgc.l"
{
						if (system_includes)
						{
							include_next = true;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(base_yytext);
							return(CPP_LINE);
						}
					}
	YY_BREAK
case 85:
/* rule 85 can match eol */
YY_RULE_SETUP
#line 851 "pgc.l"
{
						base_yylval.str = mm_strdup(base_yytext);
						return(CPP_LINE);
					}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 855 "pgc.l"
{
						const ScanKeyword		*keyword;

						/*
						 * Try to detect a function name:
						 * look for identifiers at the global scope
						 * keep the last identifier before the first '(' and '{' */
						if (braces_open == 0 && parenths_open == 0)
						{
							if (current_function)
								free(current_function);
							current_function = mm_strdup(base_yytext);
						}
						/* Informix uses SQL defines only in SQL space */
						/* however, some defines have to be taken care of for compatibility */
						if ((!INFORMIX_MODE || !isinformixdefine()) && !isdefine())
						{
							keyword = ScanCKeywordLookup(base_yytext);
							if (keyword != NULL)
								return keyword->value;
							else
							{
								base_yylval.str = mm_strdup(base_yytext);
								return IDENT;
							}
						}
					}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 882 "pgc.l"
{ mmerror(PARSE_ERROR, ET_ERROR, "nested /* ... */ comments"); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 883 "pgc.l"
{ return(':'); }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 884 "pgc.l"
{ return(';'); }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 885 "pgc.l"
{ return(','); }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 886 "pgc.l"
{ return('*'); }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 887 "pgc.l"
{ return('%'); }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 888 "pgc.l"
{ return('/'); }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 889 "pgc.l"
{ return('+'); }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 890 "pgc.l"
{ return('-'); }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 891 "pgc.l"
{ parenths_open++; return('('); }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 892 "pgc.l"
{ parenths_open--; return(')'); }
	YY_BREAK
case 98:
/* rule 98 can match eol */
YY_RULE_SETUP
#line 893 "pgc.l"
{ ECHO; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 894 "pgc.l"
{ return('{'); }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 895 "pgc.l"
{ return('}'); }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 896 "pgc.l"
{ return('['); }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 897 "pgc.l"
{ return(']'); }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 898 "pgc.l"
{ return('='); }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 899 "pgc.l"
{ return(S_MEMBER); }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 900 "pgc.l"
{ return(S_RSHIFT); }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 901 "pgc.l"
{ return(S_LSHIFT); }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 902 "pgc.l"
{ return(S_OR); }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 903 "pgc.l"
{ return(S_AND); }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 904 "pgc.l"
{ return(S_INC); }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 905 "pgc.l"
{ return(S_DEC); }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 906 "pgc.l"
{ return(S_EQUAL); }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 907 "pgc.l"
{ return(S_NEQUAL); }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 908 "pgc.l"
{ return(S_ADD); }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 909 "pgc.l"
{ return(S_SUB); }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 910 "pgc.l"
{ return(S_MUL); }
	YY_BREAK
case 116:
YY_RULE_SETUP
#line 911 "pgc.l"
{ return(S_DIV); }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 912 "pgc.l"
{ return(S_MOD); }
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 913 "pgc.l"
{ return(S_MEMPOINT); }
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 914 "pgc.l"
{ return(S_DOTPOINT); }
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 915 "pgc.l"
{ return S_ANYTHING; }
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 916 "pgc.l"
{ BEGIN(def_ident); }
	YY_BREAK
case 122:
/* rule 122 can match eol */
YY_RULE_SETUP
#line 917 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(def_ident);
						}
						else
						{
							yyless(1);
							return (S_ANYTHING);
						}
					}
	YY_BREAK
case 123:
/* rule 123 can match eol */
YY_RULE_SETUP
#line 929 "pgc.l"
{ BEGIN(undef); }
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 930 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(undef);
						}
						else
						{
							yyless(1);
							return (S_ANYTHING);
						}
					}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 942 "pgc.l"
{
					struct _defines *ptr, *ptr2 = NULL;
					int i;

					/*
					 *	Skip the ";" and trailing whitespace. Note that base_yytext
					 *	contains at least one non-space character plus the ";"
					 */
					for (i = strlen(base_yytext)-2;
						 i > 0 && ecpg_isspace(base_yytext[i]);
						 i-- )
						;
					base_yytext[i+1] = '\0';


					for (ptr = defines; ptr != NULL; ptr2 = ptr, ptr = ptr->next)
					{
						if (strcmp(base_yytext, ptr->old) == 0)
						{
							if (ptr2 == NULL)
								defines = ptr->next;
							else
								ptr2->next = ptr->next;
							free(ptr->new);
							free(ptr->old);
							free(ptr);
							break;
						}
					}

					BEGIN(C);
				}
	YY_BREAK
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 974 "pgc.l"
{
						mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL UNDEF command");
						yyterminate();
				}
	YY_BREAK
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 978 "pgc.l"
{ BEGIN(incl); }
	YY_BREAK
case 128:
/* rule 128 can match eol */
YY_RULE_SETUP
#line 979 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  BEGIN(incl);
					  }
					  else
					  {
						  yyless(1);
						  return (S_ANYTHING);
					  }
					}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 991 "pgc.l"
{ ifcond = TRUE; BEGIN(xcond); }
	YY_BREAK
case 130:
/* rule 130 can match eol */
YY_RULE_SETUP
#line 992 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  ifcond = TRUE;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return (S_ANYTHING);
					  }
					}
	YY_BREAK
case 131:
/* rule 131 can match eol */
YY_RULE_SETUP
#line 1005 "pgc.l"
{ ifcond = FALSE; BEGIN(xcond); }
	YY_BREAK
case 132:
/* rule 132 can match eol */
YY_RULE_SETUP
#line 1006 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  ifcond = FALSE;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return (S_ANYTHING);
					  }
					}
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 1019 "pgc.l"
{	/* pop stack */
						if ( preproc_tos == 0 ) {
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						}
						else if ( stacked_if_value[preproc_tos].else_branch )
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						else
							preproc_tos--;

						ifcond = TRUE; BEGIN(xcond);
					}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1030 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						else if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						else
							preproc_tos--;

						ifcond = TRUE;
						BEGIN(xcond);
					}
					else
					{
						yyless(1);
						return (S_ANYTHING);
					}
				}
	YY_BREAK
case 135:
/* rule 135 can match eol */
YY_RULE_SETUP
#line 1051 "pgc.l"
{	/* only exec sql endif pops the stack, so take care of duplicated 'else' */
					if (stacked_if_value[preproc_tos].else_branch)
						mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
					else
					{
						stacked_if_value[preproc_tos].else_branch = TRUE;
						stacked_if_value[preproc_tos].condition =
							(stacked_if_value[preproc_tos-1].condition &&
							 !stacked_if_value[preproc_tos].condition);

						if (stacked_if_value[preproc_tos].condition)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
				}
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 1067 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
						else
						{
							stacked_if_value[preproc_tos].else_branch = TRUE;
							stacked_if_value[preproc_tos].condition =
							(stacked_if_value[preproc_tos-1].condition &&
							 !stacked_if_value[preproc_tos].condition);

							if (stacked_if_value[preproc_tos].condition)
								BEGIN(C);
							else
								BEGIN(xskip);
						}
					}
					else
					{
						yyless(1);
						return (S_ANYTHING);
					}
				}
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 1092 "pgc.l"
{
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
					else
						preproc_tos--;

					if (stacked_if_value[preproc_tos].condition)
					   BEGIN(C);
					else
					   BEGIN(xskip);
				}
	YY_BREAK
case 138:
/* rule 138 can match eol */
YY_RULE_SETUP
#line 1103 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
						else
							preproc_tos--;

						if (stacked_if_value[preproc_tos].condition)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
					else
					{
						yyless(1);
						return (S_ANYTHING);
					}
				}
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 1124 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 140:
/* rule 140 can match eol */
YY_RULE_SETUP
#line 1126 "pgc.l"
{
					if (preproc_tos >= MAX_NESTED_IF-1)
						mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					else
					{
						struct _defines *defptr;
						unsigned int i;

						/*
						 *	Skip the ";" and trailing whitespace. Note that base_yytext
						 *	contains at least one non-space character plus the ";"
						 */
						for (i = strlen(base_yytext)-2;
							 i > 0 && ecpg_isspace(base_yytext[i]);
							 i-- )
							;
						base_yytext[i+1] = '\0';

						for (defptr = defines;
							 defptr != NULL && strcmp(base_yytext, defptr->old) != 0;
							 defptr = defptr->next);

						preproc_tos++;
						stacked_if_value[preproc_tos].else_branch = FALSE;
						stacked_if_value[preproc_tos].condition =
						(defptr ? ifcond : !ifcond) && stacked_if_value[preproc_tos-1].condition;
					}

					if (stacked_if_value[preproc_tos].condition)
						BEGIN(C);
					else
						BEGIN(xskip);
				}
	YY_BREAK
case 141:
/* rule 141 can match eol */
YY_RULE_SETUP
#line 1160 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL IFDEF command");
				yyterminate();
			}
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 1164 "pgc.l"
{
				old = mm_strdup(base_yytext);
				BEGIN(def);
				startlit();
			}
	YY_BREAK
case 143:
/* rule 143 can match eol */
YY_RULE_SETUP
#line 1169 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL DEFINE command");
				yyterminate();
			}
	YY_BREAK
case 144:
/* rule 144 can match eol */
YY_RULE_SETUP
#line 1173 "pgc.l"
{
						struct _defines *ptr, *this;

						for (ptr = defines; ptr != NULL; ptr = ptr->next)
						{
							 if (strcmp(old, ptr->old) == 0)
							 {
								free(ptr->new);
								ptr->new = mm_strdup(literalbuf);
							 }
						}
						if (ptr == NULL)
						{
							this = (struct _defines *) mm_alloc(sizeof(struct _defines));

							/* initial definition */
							this->old = old;
							this->new = mm_strdup(literalbuf);
							this->next = defines;
							this->used = NULL;
							defines = this;
						}

						BEGIN(C);
					}
	YY_BREAK
case 145:
/* rule 145 can match eol */
YY_RULE_SETUP
#line 1198 "pgc.l"
{ addlit(base_yytext, base_yyleng); }
	YY_BREAK
case 146:
/* rule 146 can match eol */
YY_RULE_SETUP
#line 1199 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 147:
/* rule 147 can match eol */
YY_RULE_SETUP
#line 1200 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 148:
/* rule 148 can match eol */
YY_RULE_SETUP
#line 1201 "pgc.l"
{ parse_include(); }
	YY_BREAK
case 149:
/* rule 149 can match eol */
YY_RULE_SETUP
#line 1202 "pgc.l"
{
					mmfatal(PARSE_ERROR, "syntax error in EXEC SQL INCLUDE command");
					yyterminate();
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(C):
case YY_STATE_EOF(SQL):
case YY_STATE_EOF(incl):
case YY_STATE_EOF(def):
case YY_STATE_EOF(def_ident):
case YY_STATE_EOF(undef):
case YY_STATE_EOF(xcond):
case YY_STATE_EOF(xskip):
#line 1207 "pgc.l"
{
					if (yy_buffer == NULL)
					{
						if ( preproc_tos > 0 )
						{
							preproc_tos = 0;
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						}
						yyterminate();
					}
					else
					{
						struct _yy_buffer *yb = yy_buffer;
						int i;
						struct _defines *ptr;

						for (ptr = defines; ptr; ptr = ptr->next)
							if (ptr->used == yy_buffer)
							{
								ptr->used = NULL;
								break;
							}

						if (base_yyin != NULL)
							fclose(base_yyin);

						base_yy_delete_buffer(YY_CURRENT_BUFFER );
						base_yy_switch_to_buffer(yy_buffer->buffer);

						base_yylineno = yy_buffer->lineno;

						/* We have to output the filename only if we change files here */
						i = strcmp(input_filename, yy_buffer->filename);

						free(input_filename);
						input_filename = yy_buffer->filename;

						yy_buffer = yy_buffer->next;
						free(yb);

						if (i != 0)
							output_line_number();

					}
				}
	YY_BREAK
case 150:
/* rule 150 can match eol */
YY_RULE_SETUP
#line 1252 "pgc.l"
{ mmfatal(PARSE_ERROR, "internal error: unreachable state; please report this to <pgsql-bugs@postgresql.org>"); }
	YY_BREAK
case 151:
YY_RULE_SETUP
#line 1253 "pgc.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 3973 "pgc.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed base_yyin at a new source and called
			 * base_yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = base_yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( base_yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * base_yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of base_yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					base_yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			base_yyrestart(base_yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) base_yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 813 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 813 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
	yy_is_jam = (yy_current_state == 812);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up base_yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --base_yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					base_yyrestart(base_yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( base_yywrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve base_yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    base_yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void base_yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        base_yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            base_yy_create_buffer(base_yyin,YY_BUF_SIZE );
	}

	base_yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	base_yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void base_yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		base_yypop_buffer_state();
	 *		base_yypush_buffer_state(new_buffer);
     */
	base_yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	base_yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (base_yywrap()) processing, but the only time this flag
	 * is looked at is after base_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void base_yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	base_yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE base_yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) base_yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in base_yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) base_yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in base_yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	base_yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with base_yy_create_buffer()
 * 
 */
    void base_yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		base_yyfree((void *) b->yy_ch_buf  );

	base_yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a base_yyrestart() or at EOF.
 */
    static void base_yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	base_yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then base_yy_init_buffer was _probably_
     * called from base_yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void base_yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		base_yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void base_yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	base_yyensure_buffer_stack();

	/* This block is copied from base_yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from base_yy_switch_to_buffer. */
	base_yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void base_yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	base_yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		base_yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void base_yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)base_yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in base_yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)base_yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in base_yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE base_yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) base_yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in base_yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	base_yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to base_yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       base_yy_scan_bytes() instead.
 */
YY_BUFFER_STATE base_yy_scan_string (yyconst char * yystr )
{
    
	return base_yy_scan_bytes(yystr,(int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to base_yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE base_yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) base_yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in base_yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = base_yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in base_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up base_yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		base_yytext[base_yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = base_yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		base_yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int base_yyget_lineno  (void)
{
    
    return base_yylineno;
}

/** Get the input stream.
 * 
 */
FILE *base_yyget_in  (void)
{
        return base_yyin;
}

/** Get the output stream.
 * 
 */
FILE *base_yyget_out  (void)
{
        return base_yyout;
}

/** Get the length of the current token.
 * 
 */
int base_yyget_leng  (void)
{
        return base_yyleng;
}

/** Get the current token.
 * 
 */

char *base_yyget_text  (void)
{
        return base_yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void base_yyset_lineno (int  _line_number )
{
    
    base_yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see base_yy_switch_to_buffer
 */
void base_yyset_in (FILE *  _in_str )
{
        base_yyin = _in_str ;
}

void base_yyset_out (FILE *  _out_str )
{
        base_yyout = _out_str ;
}

int base_yyget_debug  (void)
{
        return base_yy_flex_debug;
}

void base_yyset_debug (int  _bdebug )
{
        base_yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from base_yylex_destroy(), so don't allocate here.
     */

    /* We do not touch base_yylineno unless the option is enabled. */
    base_yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    base_yyin = stdin;
    base_yyout = stdout;
#else
    base_yyin = NULL;
    base_yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * base_yylex_init()
     */
    return 0;
}

/* base_yylex_destroy is for both reentrant and non-reentrant scanners. */
int base_yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		base_yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		base_yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	base_yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * base_yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *base_yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *base_yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void base_yyfree (void * ptr )
{
			free( (char *) ptr );	/* see base_yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1253 "pgc.l"


void
lex_init(void)
{
	braces_open = 0;
	parenths_open = 0;
	current_function = NULL;

	preproc_tos = 0;
	base_yylineno = 1;
	ifcond = TRUE;
	stacked_if_value[preproc_tos].condition = ifcond;
	stacked_if_value[preproc_tos].else_branch = FALSE;

	/* initialize literal buffer to a reasonable but expansible size */
	if (literalbuf == NULL)
	{
		literalalloc = 1024;
		literalbuf = (char *) malloc(literalalloc);
	}
	startlit();

	BEGIN(C);
}

static void
addlit(char *ytext, int yleng)
{
	/* enlarge buffer if needed */
	if ((literallen+yleng) >= literalalloc)
	{
		do
			literalalloc *= 2;
		while ((literallen+yleng) >= literalalloc);
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	memcpy(literalbuf+literallen, ytext, yleng);
	literallen += yleng;
	literalbuf[literallen] = '\0';
}

static void
addlitchar(unsigned char ychar)
{
	/* enlarge buffer if needed */
	if ((literallen+1) >= literalalloc)
	{
		literalalloc *= 2;
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	literalbuf[literallen] = ychar;
	literallen += 1;
	literalbuf[literallen] = '\0';
}

static void
parse_include(void)
{
	/* got the include file name */
	struct _yy_buffer *yb;
	struct _include_path *ip;
	char inc_file[MAXPGPATH];
	unsigned int i;

	yb = mm_alloc(sizeof(struct _yy_buffer));

	yb->buffer =	YY_CURRENT_BUFFER;
	yb->lineno = base_yylineno;
	yb->filename = input_filename;
	yb->next = yy_buffer;

	yy_buffer = yb;

	/*
	 * skip the ";" if there is one and trailing whitespace. Note that
	 * base_yytext contains at least one non-space character plus the ";"
	 */
	for (i = strlen(base_yytext)-2;
		 i > 0 && ecpg_isspace(base_yytext[i]);
		 i--)
		;

	if (base_yytext[i] == ';')
		i--;

	base_yytext[i+1] = '\0';

	base_yyin = NULL;

	/* If file name is enclosed in '"' remove these and look only in '.' */
	/* Informix does look into all include paths though, except filename starts with '/' */
	if (base_yytext[0] == '"' && base_yytext[i] == '"' &&
		((compat != ECPG_COMPAT_INFORMIX && compat != ECPG_COMPAT_INFORMIX_SE) || base_yytext[1] == '/'))
	{
		base_yytext[i] = '\0';
		memmove(base_yytext, base_yytext+1, strlen(base_yytext));

		strlcpy(inc_file, base_yytext, sizeof(inc_file));
		base_yyin = fopen(inc_file, "r");
		if (!base_yyin)
		{
			if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
			{
				strcat(inc_file, ".h");
				base_yyin = fopen(inc_file, "r");
			}
		}

	}
	else
	{
		if ((base_yytext[0] == '"' && base_yytext[i] == '"') || (base_yytext[0] == '<' && base_yytext[i] == '>'))
		{
			base_yytext[i] = '\0';
			memmove(base_yytext, base_yytext+1, strlen(base_yytext));
		}

		for (ip = include_paths; base_yyin == NULL && ip != NULL; ip = ip->next)
		{
			if (strlen(ip->path) + strlen(base_yytext) + 3 > MAXPGPATH)
			{
				fprintf(stderr, _("Error: include path \"%s/%s\" is too long on line %d, skipping\n"), ip->path, base_yytext, base_yylineno);
				continue;
			}
			snprintf (inc_file, sizeof(inc_file), "%s/%s", ip->path, base_yytext);
			base_yyin = fopen(inc_file, "r");
			if (!base_yyin)
			{
				if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
				{
					strcat(inc_file, ".h");
					base_yyin = fopen( inc_file, "r" );
				}
			}
			/* if the command was "include_next" we have to disregard the first hit */
			if (base_yyin && include_next)
			{
				fclose (base_yyin);
				base_yyin = NULL;
				include_next = false;
			}
		}
	}
	if (!base_yyin)
		mmfatal(NO_INCLUDE_FILE, "could not open include file \"%s\" on line %d", base_yytext, base_yylineno);

	input_filename = mm_strdup(inc_file);
	base_yy_switch_to_buffer(base_yy_create_buffer(base_yyin,YY_BUF_SIZE ));
	base_yylineno = 1;
	output_line_number();

	BEGIN(C);
}

/*
 * ecpg_isspace() --- return TRUE if flex scanner considers char whitespace
 */
static bool
ecpg_isspace(char ch)
{
	if (ch == ' ' ||
		ch == '\t' ||
		ch == '\n' ||
		ch == '\r' ||
		ch == '\f')
		return true;
	return false;
}

static bool isdefine(void)
{
	struct _defines *ptr;

	/* is it a define? */
	for (ptr = defines; ptr; ptr = ptr->next)
	{
		if (strcmp(base_yytext, ptr->old) == 0 && ptr->used == NULL)
		{
			struct _yy_buffer *yb;

			yb = mm_alloc(sizeof(struct _yy_buffer));

			yb->buffer =  YY_CURRENT_BUFFER;
			yb->lineno = base_yylineno;
			yb->filename = mm_strdup(input_filename);
			yb->next = yy_buffer;

			ptr->used = yy_buffer = yb;

			base_yy_scan_string(ptr->new);
			return true;
		}
	}

	return false;
}

static bool isinformixdefine(void)
{
	const char *new = NULL;

	if (strcmp(base_yytext, "dec_t") == 0)
		new = "decimal";
	else if (strcmp(base_yytext, "intrvl_t") == 0)
		new = "interval";
	else if (strcmp(base_yytext, "dtime_t") == 0)
		new = "timestamp";

	if (new)
	{
		struct _yy_buffer *yb;

		yb = mm_alloc(sizeof(struct _yy_buffer));

		yb->buffer =  YY_CURRENT_BUFFER;
		yb->lineno = base_yylineno;
		yb->filename = mm_strdup(input_filename);
		yb->next = yy_buffer;
		yy_buffer = yb;

		base_yy_scan_string(new);
		return true;
	}

	return false;
}

/*
 * Called before any actual parsing is done
 */
void
scanner_init(const char *str)
{
	Size	slen = strlen(str);

	/*
	 * Might be left over after ereport()
	 */
	if (YY_CURRENT_BUFFER)
		base_yy_delete_buffer(YY_CURRENT_BUFFER);

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	scanbuf = mm_alloc(slen + 2);
	memcpy(scanbuf, str, slen);
	scanbuf[slen] = scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	scanbufhandle = base_yy_scan_buffer(scanbuf,slen + 2);

	/* initialize literal buffer to a reasonable but expansible size */
	literalalloc = 128;
	literalbuf = (char *) mm_alloc(literalalloc);
	startlit();

	BEGIN(INITIAL);
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(void)
{
	base_yy_delete_buffer(scanbufhandle);
	free(scanbuf);
}

