/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs

#define yylval          base_yylval
#define yychar          base_yychar
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */
#line 5 "preproc.y" /* yacc.c:339  */

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
static void __attribute__((format(PG_PRINTF_ATTRIBUTE, 3, 0)))
vmmerror(int error_code, enum errortype type, const char *error, va_list ap)
{
	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, base_yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	vfprintf(stderr, error, ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
	}
}

void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list		ap;

	va_start(ap, error);
	vmmerror(error_code, type, error, ap);
	va_end(ap);
}

void
mmfatal(int error_code, const char *error, ...)
{
	va_list		ap;

	va_start(ap, error);
	vmmerror(error_code, ET_ERROR, error, ap);
	va_end(ap);

	if (base_yyin)
		fclose(base_yyin);
	if (base_yyout)
		fclose(base_yyout);

	if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
		fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
	exit(error_code);
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(base_yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essentially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}

#line 645 "preproc.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "preproc.h".  */
#ifndef YY_BASE_YY_PREPROC_H_INCLUDED
# define YY_BASE_YY_PREPROC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int base_yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    SQL_ALLOCATE = 258,
    SQL_AUTOCOMMIT = 259,
    SQL_BOOL = 260,
    SQL_BREAK = 261,
    SQL_CALL = 262,
    SQL_CARDINALITY = 263,
    SQL_CONNECT = 264,
    SQL_COUNT = 265,
    SQL_DATETIME_INTERVAL_CODE = 266,
    SQL_DATETIME_INTERVAL_PRECISION = 267,
    SQL_DESCRIBE = 268,
    SQL_DESCRIPTOR = 269,
    SQL_DISCONNECT = 270,
    SQL_FOUND = 271,
    SQL_FREE = 272,
    SQL_GET = 273,
    SQL_GO = 274,
    SQL_GOTO = 275,
    SQL_IDENTIFIED = 276,
    SQL_INDICATOR = 277,
    SQL_KEY_MEMBER = 278,
    SQL_LENGTH = 279,
    SQL_LONG = 280,
    SQL_NULLABLE = 281,
    SQL_OCTET_LENGTH = 282,
    SQL_OPEN = 283,
    SQL_OUTPUT = 284,
    SQL_REFERENCE = 285,
    SQL_RETURNED_LENGTH = 286,
    SQL_RETURNED_OCTET_LENGTH = 287,
    SQL_SCALE = 288,
    SQL_SECTION = 289,
    SQL_SHORT = 290,
    SQL_SIGNED = 291,
    SQL_SQL = 292,
    SQL_SQLERROR = 293,
    SQL_SQLPRINT = 294,
    SQL_SQLWARNING = 295,
    SQL_START = 296,
    SQL_STOP = 297,
    SQL_STRUCT = 298,
    SQL_UNSIGNED = 299,
    SQL_VAR = 300,
    SQL_WHENEVER = 301,
    S_ADD = 302,
    S_AND = 303,
    S_ANYTHING = 304,
    S_AUTO = 305,
    S_CONST = 306,
    S_DEC = 307,
    S_DIV = 308,
    S_DOTPOINT = 309,
    S_EQUAL = 310,
    S_EXTERN = 311,
    S_INC = 312,
    S_LSHIFT = 313,
    S_MEMPOINT = 314,
    S_MEMBER = 315,
    S_MOD = 316,
    S_MUL = 317,
    S_NEQUAL = 318,
    S_OR = 319,
    S_REGISTER = 320,
    S_RSHIFT = 321,
    S_STATIC = 322,
    S_SUB = 323,
    S_VOLATILE = 324,
    S_TYPEDEF = 325,
    CSTRING = 326,
    CVARIABLE = 327,
    CPP_LINE = 328,
    IP = 329,
    DOLCONST = 330,
    ECONST = 331,
    NCONST = 332,
    UCONST = 333,
    UIDENT = 334,
    IDENT = 335,
    FCONST = 336,
    SCONST = 337,
    BCONST = 338,
    XCONST = 339,
    Op = 340,
    ICONST = 341,
    PARAM = 342,
    TYPECAST = 343,
    DOT_DOT = 344,
    COLON_EQUALS = 345,
    ABORT_P = 346,
    ABSOLUTE_P = 347,
    ACCESS = 348,
    ACTION = 349,
    ADD_P = 350,
    ADMIN = 351,
    AFTER = 352,
    AGGREGATE = 353,
    ALL = 354,
    ALSO = 355,
    ALTER = 356,
    ALWAYS = 357,
    ANALYSE = 358,
    ANALYZE = 359,
    AND = 360,
    ANY = 361,
    ARRAY = 362,
    AS = 363,
    ASC = 364,
    ASSERTION = 365,
    ASSIGNMENT = 366,
    ASYMMETRIC = 367,
    AT = 368,
    ATTRIBUTE = 369,
    AUTHORIZATION = 370,
    BACKWARD = 371,
    BEFORE = 372,
    BEGIN_P = 373,
    BETWEEN = 374,
    BIGINT = 375,
    BINARY = 376,
    BIT = 377,
    BOOLEAN_P = 378,
    BOTH = 379,
    BY = 380,
    CACHE = 381,
    CALLED = 382,
    CASCADE = 383,
    CASCADED = 384,
    CASE = 385,
    CAST = 386,
    CATALOG_P = 387,
    CHAIN = 388,
    CHAR_P = 389,
    CHARACTER = 390,
    CHARACTERISTICS = 391,
    CHECK = 392,
    CHECKPOINT = 393,
    CLASS = 394,
    CLOSE = 395,
    CLUSTER = 396,
    COALESCE = 397,
    COLLATE = 398,
    COLLATION = 399,
    COLUMN = 400,
    COMMENT = 401,
    COMMENTS = 402,
    COMMIT = 403,
    COMMITTED = 404,
    CONCURRENTLY = 405,
    CONFIGURATION = 406,
    CONNECTION = 407,
    CONSTRAINT = 408,
    CONSTRAINTS = 409,
    CONTENT_P = 410,
    CONTINUE_P = 411,
    CONVERSION_P = 412,
    COPY = 413,
    COST = 414,
    CREATE = 415,
    CROSS = 416,
    CSV = 417,
    CURRENT_P = 418,
    CURRENT_CATALOG = 419,
    CURRENT_DATE = 420,
    CURRENT_ROLE = 421,
    CURRENT_SCHEMA = 422,
    CURRENT_TIME = 423,
    CURRENT_TIMESTAMP = 424,
    CURRENT_USER = 425,
    CURSOR = 426,
    CYCLE = 427,
    DATA_P = 428,
    DATABASE = 429,
    DAY_P = 430,
    DEALLOCATE = 431,
    DEC = 432,
    DECIMAL_P = 433,
    DECLARE = 434,
    DEFAULT = 435,
    DEFAULTS = 436,
    DEFERRABLE = 437,
    DEFERRED = 438,
    DEFINER = 439,
    DELETE_P = 440,
    DELIMITER = 441,
    DELIMITERS = 442,
    DESC = 443,
    DICTIONARY = 444,
    DISABLE_P = 445,
    DISCARD = 446,
    DISTINCT = 447,
    DO = 448,
    DOCUMENT_P = 449,
    DOMAIN_P = 450,
    DOUBLE_P = 451,
    DROP = 452,
    EACH = 453,
    ELSE = 454,
    ENABLE_P = 455,
    ENCODING = 456,
    ENCRYPTED = 457,
    END_P = 458,
    ENUM_P = 459,
    ESCAPE = 460,
    EVENT = 461,
    EXCEPT = 462,
    EXCLUDE = 463,
    EXCLUDING = 464,
    EXCLUSIVE = 465,
    EXECUTE = 466,
    EXISTS = 467,
    EXPLAIN = 468,
    EXTENSION = 469,
    EXTERNAL = 470,
    EXTRACT = 471,
    FALSE_P = 472,
    FAMILY = 473,
    FETCH = 474,
    FILTER = 475,
    FIRST_P = 476,
    FLOAT_P = 477,
    FOLLOWING = 478,
    FOR = 479,
    FORCE = 480,
    FOREIGN = 481,
    FORWARD = 482,
    FREEZE = 483,
    FROM = 484,
    FULL = 485,
    FUNCTION = 486,
    FUNCTIONS = 487,
    GLOBAL = 488,
    GRANT = 489,
    GRANTED = 490,
    GREATEST = 491,
    GROUP_P = 492,
    HANDLER = 493,
    HAVING = 494,
    HEADER_P = 495,
    HOLD = 496,
    HOUR_P = 497,
    IDENTITY_P = 498,
    IF_P = 499,
    ILIKE = 500,
    IMMEDIATE = 501,
    IMMUTABLE = 502,
    IMPLICIT_P = 503,
    IN_P = 504,
    INCLUDING = 505,
    INCREMENT = 506,
    INDEX = 507,
    INDEXES = 508,
    INHERIT = 509,
    INHERITS = 510,
    INITIALLY = 511,
    INLINE_P = 512,
    INNER_P = 513,
    INOUT = 514,
    INPUT_P = 515,
    INSENSITIVE = 516,
    INSERT = 517,
    INSTEAD = 518,
    INT_P = 519,
    INTEGER = 520,
    INTERSECT = 521,
    INTERVAL = 522,
    INTO = 523,
    INVOKER = 524,
    IS = 525,
    ISNULL = 526,
    ISOLATION = 527,
    JOIN = 528,
    KEY = 529,
    LABEL = 530,
    LANGUAGE = 531,
    LARGE_P = 532,
    LAST_P = 533,
    LATERAL_P = 534,
    LC_COLLATE_P = 535,
    LC_CTYPE_P = 536,
    LEADING = 537,
    LEAKPROOF = 538,
    LEAST = 539,
    LEFT = 540,
    LEVEL = 541,
    LIKE = 542,
    LIMIT = 543,
    LISTEN = 544,
    LOAD = 545,
    LOCAL = 546,
    LOCALTIME = 547,
    LOCALTIMESTAMP = 548,
    LOCATION = 549,
    LOCK_P = 550,
    MAPPING = 551,
    MATCH = 552,
    MATERIALIZED = 553,
    MAXVALUE = 554,
    MINUTE_P = 555,
    MINVALUE = 556,
    MODE = 557,
    MONTH_P = 558,
    MOVE = 559,
    NAME_P = 560,
    NAMES = 561,
    NATIONAL = 562,
    NATURAL = 563,
    NCHAR = 564,
    NEXT = 565,
    NO = 566,
    NONE = 567,
    NOT = 568,
    NOTHING = 569,
    NOTIFY = 570,
    NOTNULL = 571,
    NOWAIT = 572,
    NULL_P = 573,
    NULLIF = 574,
    NULLS_P = 575,
    NUMERIC = 576,
    OBJECT_P = 577,
    OF = 578,
    OFF = 579,
    OFFSET = 580,
    OIDS = 581,
    ON = 582,
    ONLY = 583,
    OPERATOR = 584,
    OPTION = 585,
    OPTIONS = 586,
    OR = 587,
    ORDER = 588,
    ORDINALITY = 589,
    OUT_P = 590,
    OUTER_P = 591,
    OVER = 592,
    OVERLAPS = 593,
    OVERLAY = 594,
    OWNED = 595,
    OWNER = 596,
    PARSER = 597,
    PARTIAL = 598,
    PARTITION = 599,
    PASSING = 600,
    PASSWORD = 601,
    PLACING = 602,
    PLANS = 603,
    POSITION = 604,
    PRECEDING = 605,
    PRECISION = 606,
    PRESERVE = 607,
    PREPARE = 608,
    PREPARED = 609,
    PRIMARY = 610,
    PRIOR = 611,
    PRIVILEGES = 612,
    PROCEDURAL = 613,
    PROCEDURE = 614,
    PROGRAM = 615,
    QUOTE = 616,
    RANGE = 617,
    READ = 618,
    REAL = 619,
    REASSIGN = 620,
    RECHECK = 621,
    RECURSIVE = 622,
    REF = 623,
    REFERENCES = 624,
    REFRESH = 625,
    REINDEX = 626,
    RELATIVE_P = 627,
    RELEASE = 628,
    RENAME = 629,
    REPEATABLE = 630,
    REPLACE = 631,
    REPLICA = 632,
    RESET = 633,
    RESTART = 634,
    RESTRICT = 635,
    RETURNING = 636,
    RETURNS = 637,
    REVOKE = 638,
    RIGHT = 639,
    ROLE = 640,
    ROLLBACK = 641,
    ROW = 642,
    ROWS = 643,
    RULE = 644,
    SAVEPOINT = 645,
    SCHEMA = 646,
    SCROLL = 647,
    SEARCH = 648,
    SECOND_P = 649,
    SECURITY = 650,
    SELECT = 651,
    SEQUENCE = 652,
    SEQUENCES = 653,
    SERIALIZABLE = 654,
    SERVER = 655,
    SESSION = 656,
    SESSION_USER = 657,
    SET = 658,
    SETOF = 659,
    SHARE = 660,
    SHOW = 661,
    SIMILAR = 662,
    SIMPLE = 663,
    SMALLINT = 664,
    SNAPSHOT = 665,
    SOME = 666,
    STABLE = 667,
    STANDALONE_P = 668,
    START = 669,
    STATEMENT = 670,
    STATISTICS = 671,
    STDIN = 672,
    STDOUT = 673,
    STORAGE = 674,
    STRICT_P = 675,
    STRIP_P = 676,
    SUBSTRING = 677,
    SYMMETRIC = 678,
    SYSID = 679,
    SYSTEM_P = 680,
    TABLE = 681,
    TABLES = 682,
    TABLESPACE = 683,
    TEMP = 684,
    TEMPLATE = 685,
    TEMPORARY = 686,
    TEXT_P = 687,
    THEN = 688,
    TIME = 689,
    TIMESTAMP = 690,
    TO = 691,
    TRAILING = 692,
    TRANSACTION = 693,
    TREAT = 694,
    TRIGGER = 695,
    TRIM = 696,
    TRUE_P = 697,
    TRUNCATE = 698,
    TRUSTED = 699,
    TYPE_P = 700,
    TYPES_P = 701,
    UNBOUNDED = 702,
    UNCOMMITTED = 703,
    UNENCRYPTED = 704,
    UNION = 705,
    UNIQUE = 706,
    UNKNOWN = 707,
    UNLISTEN = 708,
    UNLOGGED = 709,
    UNTIL = 710,
    UPDATE = 711,
    USER = 712,
    USING = 713,
    VACUUM = 714,
    VALID = 715,
    VALIDATE = 716,
    VALIDATOR = 717,
    VALUE_P = 718,
    VALUES = 719,
    VARCHAR = 720,
    VARIADIC = 721,
    VARYING = 722,
    VERBOSE = 723,
    VERSION_P = 724,
    VIEW = 725,
    VIEWS = 726,
    VOLATILE = 727,
    WHEN = 728,
    WHERE = 729,
    WHITESPACE_P = 730,
    WINDOW = 731,
    WITH = 732,
    WITHIN = 733,
    WITHOUT = 734,
    WORK = 735,
    WRAPPER = 736,
    WRITE = 737,
    XML_P = 738,
    XMLATTRIBUTES = 739,
    XMLCONCAT = 740,
    XMLELEMENT = 741,
    XMLEXISTS = 742,
    XMLFOREST = 743,
    XMLPARSE = 744,
    XMLPI = 745,
    XMLROOT = 746,
    XMLSERIALIZE = 747,
    YEAR_P = 748,
    YES_P = 749,
    ZONE = 750,
    NULLS_FIRST = 751,
    NULLS_LAST = 752,
    WITH_ORDINALITY = 753,
    WITH_TIME = 754,
    POSTFIXOP = 755,
    UMINUS = 756
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 579 "preproc.y" /* yacc.c:355  */

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;

#line 1202 "preproc.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE base_yylval;
extern YYLTYPE base_yylloc;
int base_yyparse (void);

#endif /* !YY_BASE_YY_PREPROC_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1231 "preproc.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   111957

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  521
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  718
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2843
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  5236

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   756

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   508,     2,     2,
     513,   514,   506,   504,   516,   505,   515,   507,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   518,   517,
     501,   500,   502,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   511,     2,   512,   509,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   519,     2,   520,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   503,   510
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1511,  1511,  1514,  1516,  1518,  1520,  1522,  1524,  1526,
    1528,  1530,  1532,  1534,  1536,  1538,  1540,  1542,  1544,  1546,
    1548,  1550,  1552,  1554,  1556,  1558,  1560,  1562,  1564,  1566,
    1568,  1570,  1572,  1590,  1592,  1594,  1596,  1598,  1600,  1602,
    1604,  1606,  1608,  1610,  1612,  1614,  1616,  1618,  1620,  1622,
    1624,  1626,  1628,  1630,  1632,  1634,  1636,  1638,  1640,  1642,
    1644,  1646,  1648,  1650,  1654,  1656,  1658,  1660,  1662,  1664,
    1666,  1668,  1670,  1672,  1674,  1676,  1678,  1680,  1682,  1684,
    1686,  1688,  1690,  1692,  1694,  1696,  1698,  1700,  1702,  1704,
    1706,  1708,  1710,  1712,  1714,  1716,  1718,  1720,  1722,  1729,
    1731,  1733,  1735,  1737,  1739,  1741,  1743,  1745,  1747,  1749,
    1751,  1757,  1759,  1761,  1763,  1765,  1767,  1769,  1771,  1773,
    1779,  1789,  1793,  1799,  1803,  1813,  1823,  1824,  1838,  1845,
    1851,  1862,  1868,  1877,  1884,  1890,  1899,  1906,  1914,  1919,
    1927,  1932,  1938,  1943,  1949,  1954,  1960,  1964,  1968,  1972,
    1976,  1980,  1984,  1988,  1992,  2000,  2004,  2008,  2012,  2016,
    2020,  2028,  2036,  2045,  2047,  2055,  2059,  2067,  2075,  2079,
    2087,  2091,  2099,  2103,  2111,  2119,  2127,  2131,  2139,  2143,
    2151,  2155,  2159,  2164,  2173,  2178,  2184,  2189,  2195,  2199,
    2203,  2207,  2211,  2215,  2223,  2227,  2231,  2239,  2243,  2247,
    2255,  2259,  2263,  2267,  2268,  2272,  2276,  2280,  2285,  2289,
    2293,  2297,  2301,  2305,  2309,  2317,  2321,  2329,  2333,  2341,
    2345,  2359,  2363,  2367,  2371,  2379,  2383,  2387,  2391,  2399,
    2403,  2407,  2411,  2415,  2419,  2423,  2431,  2435,  2440,  2446,
    2450,  2458,  2466,  2470,  2474,  2478,  2486,  2490,  2498,  2502,
    2510,  2514,  2522,  2526,  2530,  2534,  2538,  2547,  2555,  2559,
    2567,  2571,  2579,  2587,  2591,  2595,  2599,  2603,  2611,  2615,
    2619,  2623,  2627,  2631,  2635,  2639,  2643,  2647,  2651,  2655,
    2659,  2663,  2667,  2671,  2679,  2683,  2691,  2695,  2699,  2703,
    2707,  2711,  2715,  2719,  2723,  2727,  2731,  2735,  2739,  2743,
    2747,  2751,  2755,  2759,  2763,  2767,  2771,  2775,  2779,  2783,
    2787,  2791,  2795,  2799,  2803,  2807,  2811,  2815,  2819,  2823,
    2827,  2831,  2835,  2839,  2843,  2847,  2851,  2855,  2859,  2863,
    2871,  2875,  2883,  2887,  2892,  2898,  2903,  2909,  2914,  2920,
    2924,  2928,  2932,  2940,  2948,  2953,  2959,  2963,  2971,  2975,
    2979,  2983,  2991,  2999,  3003,  3011,  3015,  3019,  3023,  3031,
    3036,  3044,  3052,  3060,  3064,  3072,  3077,  3083,  3087,  3091,
    3099,  3103,  3111,  3116,  3122,  3126,  3130,  3134,  3138,  3142,
    3146,  3150,  3154,  3158,  3162,  3166,  3170,  3174,  3182,  3187,
    3193,  3198,  3204,  3209,  3215,  3220,  3226,  3230,  3238,  3246,
    3250,  3254,  3258,  3263,  3269,  3273,  3281,  3289,  3293,  3297,
    3301,  3309,  3313,  3317,  3321,  3325,  3329,  3333,  3338,  3344,
    3349,  3355,  3360,  3366,  3370,  3378,  3382,  3390,  3394,  3398,
    3406,  3410,  3418,  3426,  3434,  3439,  3445,  3449,  3453,  3457,
    3465,  3469,  3473,  3477,  3481,  3485,  3489,  3497,  3501,  3505,
    3509,  3517,  3525,  3529,  3534,  3540,  3544,  3548,  3552,  3556,
    3560,  3568,  3572,  3580,  3584,  3588,  3592,  3596,  3600,  3604,
    3612,  3617,  3623,  3628,  3634,  3638,  3646,  3654,  3658,  3663,
    3668,  3674,  3678,  3686,  3690,  3698,  3703,  3709,  3713,  3717,
    3721,  3726,  3732,  3740,  3748,  3752,  3756,  3760,  3764,  3772,
    3777,  3783,  3787,  3791,  3796,  3802,  3806,  3810,  3815,  3821,
    3826,  3832,  3837,  3843,  3851,  3859,  3863,  3868,  3874,  3882,
    3890,  3895,  3901,  3909,  3917,  3921,  3929,  3934,  3940,  3944,
    3952,  3956,  3960,  3964,  3968,  3972,  3976,  3980,  3984,  3988,
    3992,  3996,  4004,  4009,  4015,  4019,  4023,  4027,  4035,  4039,
    4047,  4051,  4059,  4064,  4070,  4074,  4082,  4087,  4093,  4097,
    4105,  4110,  4116,  4120,  4128,  4133,  4139,  4147,  4152,  4158,
    4162,  4170,  4174,  4182,  4187,  4193,  4197,  4201,  4209,  4217,
    4222,  4228,  4236,  4240,  4244,  4248,  4252,  4256,  4260,  4264,
    4268,  4272,  4276,  4280,  4284,  4288,  4292,  4296,  4300,  4304,
    4308,  4312,  4316,  4320,  4324,  4328,  4336,  4344,  4348,  4352,
    4356,  4364,  4368,  4376,  4381,  4387,  4391,  4399,  4403,  4411,
    4416,  4422,  4426,  4434,  4442,  4446,  4454,  4458,  4462,  4466,
    4474,  4482,  4490,  4498,  4506,  4511,  4517,  4521,  4529,  4534,
    4540,  4544,  4552,  4556,  4560,  4568,  4572,  4580,  4584,  4592,
    4600,  4604,  4608,  4616,  4620,  4628,  4636,  4640,  4648,  4652,
    4656,  4664,  4668,  4676,  4680,  4684,  4688,  4692,  4700,  4705,
    4711,  4716,  4722,  4726,  4734,  4739,  4745,  4749,  4754,  4760,
    4764,  4768,  4772,  4780,  4785,  4792,  4794,  4802,  4806,  4810,
    4814,  4818,  4822,  4830,  4834,  4842,  4846,  4854,  4858,  4866,
    4874,  4878,  4886,  4894,  4898,  4902,  4906,  4914,  4923,  4932,
    4936,  4940,  4944,  4948,  4952,  4956,  4960,  4964,  4968,  4972,
    4976,  4980,  4984,  4992,  5000,  5004,  5012,  5016,  5024,  5028,
    5032,  5036,  5040,  5048,  5056,  5060,  5068,  5076,  5081,  5087,
    5091,  5099,  5103,  5107,  5115,  5120,  5126,  5134,  5138,  5146,
    5150,  5154,  5158,  5162,  5170,  5175,  5181,  5186,  5192,  5196,
    5201,  5207,  5213,  5219,  5227,  5231,  5239,  5243,  5251,  5255,
    5263,  5267,  5275,  5279,  5287,  5295,  5303,  5307,  5311,  5315,
    5323,  5327,  5331,  5335,  5339,  5343,  5347,  5351,  5355,  5359,
    5363,  5367,  5371,  5375,  5379,  5383,  5387,  5395,  5399,  5407,
    5411,  5419,  5423,  5431,  5439,  5443,  5448,  5454,  5458,  5462,
    5466,  5470,  5474,  5478,  5482,  5486,  5490,  5494,  5498,  5502,
    5510,  5514,  5518,  5522,  5526,  5530,  5534,  5538,  5542,  5546,
    5550,  5554,  5558,  5562,  5566,  5570,  5574,  5578,  5582,  5586,
    5590,  5594,  5598,  5606,  5610,  5618,  5622,  5626,  5630,  5634,
    5642,  5647,  5653,  5657,  5661,  5665,  5669,  5673,  5677,  5681,
    5685,  5689,  5693,  5697,  5701,  5709,  5713,  5721,  5725,  5729,
    5733,  5739,  5745,  5751,  5757,  5763,  5769,  5775,  5785,  5796,
    5807,  5818,  5829,  5840,  5851,  5867,  5883,  5899,  5910,  5926,
    5937,  5953,  5968,  5972,  5980,  5985,  5991,  5999,  6003,  6011,
    6015,  6019,  6023,  6027,  6035,  6039,  6047,  6051,  6055,  6059,
    6067,  6071,  6075,  6079,  6083,  6087,  6091,  6095,  6099,  6103,
    6107,  6111,  6115,  6119,  6123,  6127,  6135,  6139,  6147,  6151,
    6159,  6164,  6170,  6174,  6182,  6190,  6198,  6202,  6210,  6215,
    6221,  6226,  6232,  6240,  6245,  6251,  6255,  6259,  6267,  6271,
    6275,  6283,  6287,  6291,  6295,  6303,  6311,  6316,  6322,  6327,
    6333,  6338,  6344,  6349,  6355,  6359,  6367,  6371,  6375,  6383,
    6388,  6394,  6398,  6403,  6409,  6413,  6418,  6424,  6428,  6433,
    6439,  6443,  6447,  6455,  6460,  6466,  6470,  6478,  6482,  6490,
    6494,  6502,  6506,  6514,  6518,  6522,  6526,  6530,  6538,  6542,
    6546,  6550,  6554,  6562,  6570,  6578,  6582,  6586,  6594,  6598,
    6602,  6610,  6619,  6623,  6627,  6631,  6639,  6643,  6651,  6655,
    6663,  6667,  6671,  6675,  6679,  6683,  6687,  6691,  6695,  6699,
    6703,  6707,  6711,  6715,  6719,  6727,  6731,  6735,  6739,  6747,
    6751,  6759,  6764,  6770,  6778,  6782,  6790,  6798,  6802,  6810,
    6815,  6821,  6825,  6833,  6837,  6845,  6849,  6857,  6861,  6865,
    6869,  6877,  6881,  6889,  6897,  6901,  6909,  6913,  6921,  6925,
    6929,  6937,  6941,  6946,  6952,  6960,  6965,  6971,  6975,  6979,
    6987,  6991,  6999,  7004,  7010,  7014,  7022,  7026,  7030,  7034,
    7038,  7042,  7046,  7050,  7054,  7058,  7062,  7066,  7070,  7074,
    7078,  7082,  7086,  7090,  7094,  7098,  7102,  7106,  7110,  7114,
    7118,  7122,  7126,  7130,  7134,  7138,  7142,  7146,  7150,  7154,
    7158,  7162,  7166,  7170,  7174,  7178,  7182,  7186,  7190,  7194,
    7198,  7206,  7211,  7217,  7222,  7228,  7232,  7236,  7240,  7244,
    7248,  7252,  7256,  7260,  7264,  7268,  7272,  7276,  7280,  7284,
    7288,  7292,  7296,  7300,  7304,  7308,  7312,  7316,  7320,  7328,
    7332,  7336,  7340,  7344,  7348,  7352,  7356,  7360,  7364,  7368,
    7372,  7376,  7380,  7384,  7388,  7392,  7396,  7400,  7408,  7416,
    7420,  7424,  7432,  7436,  7444,  7448,  7452,  7456,  7460,  7468,
    7473,  7479,  7483,  7487,  7491,  7499,  7503,  7508,  7514,  7518,
    7526,  7534,  7539,  7545,  7553,  7557,  7565,  7569,  7573,  7577,
    7581,  7585,  7589,  7593,  7597,  7601,  7605,  7609,  7613,  7617,
    7625,  7629,  7634,  7640,  7644,  7648,  7652,  7656,  7664,  7668,
    7672,  7680,  7685,  7691,  7695,  7699,  7704,  7713,  7717,  7721,
    7726,  7732,  7740,  7748,  7753,  7759,  7763,  7767,  7771,  7775,
    7779,  7783,  7787,  7791,  7795,  7799,  7803,  7807,  7811,  7815,
    7819,  7827,  7832,  7838,  7842,  7850,  7858,  7863,  7869,  7877,
    7881,  7889,  7893,  7901,  7909,  7913,  7917,  7921,  7925,  7929,
    7933,  7941,  7946,  7952,  7960,  7964,  7968,  7972,  7976,  7980,
    7988,  7996,  8000,  8004,  8012,  8017,  8023,  8027,  8031,  8035,
    8039,  8047,  8051,  8059,  8063,  8067,  8071,  8079,  8083,  8091,
    8095,  8103,  8108,  8114,  8119,  8125,  8130,  8136,  8141,  8147,
    8151,  8155,  8159,  8167,  8171,  8175,  8179,  8183,  8187,  8191,
    8195,  8199,  8207,  8211,  8219,  8227,  8231,  8239,  8243,  8248,
    8254,  8260,  8270,  8275,  8281,  8285,  8289,  8293,  8301,  8303,
    8311,  8316,  8322,  8330,  8334,  8338,  8346,  8350,  8358,  8366,
    8371,  8377,  8385,  8390,  8396,  8404,  8409,  8415,  8419,  8423,
    8427,  8431,  8435,  8439,  8443,  8451,  8456,  8462,  8470,  8474,
    8482,  8486,  8494,  8502,  8510,  8518,  8522,  8530,  8583,  8587,
    8600,  8602,  8606,  8610,  8614,  8623,  8629,  8633,  8641,  8645,
    8653,  8657,  8665,  8669,  8673,  8677,  8681,  8685,  8689,  8693,
    8701,  8705,  8713,  8717,  8721,  8725,  8729,  8733,  8741,  8745,
    8753,  8757,  8765,  8773,  8778,  8784,  8789,  8791,  8797,  8801,
    8805,  8809,  8813,  8817,  8821,  8825,  8829,  8837,  8842,  8848,
    8852,  8857,  8863,  8867,  8871,  8876,  8882,  8887,  8893,  8901,
    8905,  8913,  8917,  8925,  8929,  8933,  8937,  8945,  8950,  8956,
    8960,  8965,  8973,  8977,  8985,  8989,  8997,  9005,  9009,  9014,
    9020,  9028,  9032,  9040,  9044,  9052,  9057,  9063,  9068,  9074,
    9078,  9086,  9091,  9097,  9101,  9109,  9117,  9121,  9125,  9129,
    9137,  9142,  9148,  9152,  9160,  9165,  9171,  9175,  9183,  9187,
    9191,  9195,  9202,  9209,  9213,  9221,  9225,  9229,  9233,  9237,
    9241,  9249,  9253,  9257,  9261,  9269,  9274,  9280,  9284,  9288,
    9292,  9297,  9303,  9307,  9311,  9315,  9323,  9328,  9334,  9338,
    9346,  9350,  9354,  9358,  9366,  9370,  9378,  9382,  9386,  9394,
    9398,  9406,  9414,  9418,  9426,  9431,  9437,  9442,  9448,  9453,
    9459,  9463,  9469,  9475,  9480,  9486,  9490,  9498,  9506,  9508,
    9510,  9514,  9518,  9522,  9530,  9540,  9551,  9560,  9564,  9568,
    9572,  9576,  9580,  9584,  9592,  9596,  9600,  9604,  9612,  9616,
    9624,  9629,  9635,  9639,  9643,  9647,  9651,  9655,  9659,  9663,
    9667,  9671,  9675,  9683,  9688,  9694,  9698,  9706,  9710,  9718,
    9726,  9734,  9738,  9746,  9750,  9758,  9766,  9774,  9778,  9782,
    9786,  9790,  9794,  9802,  9807,  9813,  9818,  9824,  9828,  9832,
    9836,  9844,  9852,  9856,  9861,  9867,  9871,  9875,  9879,  9883,
    9887,  9891,  9895,  9899,  9903,  9907,  9911,  9915,  9920,  9926,
    9930,  9938,  9942,  9946,  9950,  9954,  9958,  9962,  9966,  9970,
    9974,  9978,  9982,  9986,  9990,  9994,  9998, 10002, 10006, 10010,
   10014, 10018, 10022, 10026, 10030, 10034, 10038, 10042, 10046, 10050,
   10054, 10058, 10062, 10066, 10070, 10074, 10078, 10082, 10086, 10090,
   10094, 10098, 10102, 10106, 10110, 10114, 10118, 10122, 10126, 10130,
   10134, 10138, 10142, 10146, 10150, 10154, 10158, 10162, 10167, 10171,
   10179, 10183, 10187, 10191, 10195, 10199, 10203, 10207, 10211, 10215,
   10219, 10223, 10227, 10231, 10235, 10239, 10243, 10247, 10251, 10255,
   10259, 10263, 10271, 10275, 10279, 10283, 10287, 10291, 10295, 10299,
   10303, 10307, 10311, 10315, 10323, 10327, 10331, 10335, 10339, 10343,
   10347, 10355, 10359, 10367, 10371, 10379, 10383, 10387, 10391, 10395,
   10399, 10403, 10407, 10411, 10415, 10419, 10423, 10427, 10431, 10435,
   10439, 10443, 10447, 10451, 10455, 10459, 10463, 10467, 10471, 10475,
   10479, 10483, 10487, 10491, 10495, 10499, 10503, 10507, 10511, 10515,
   10519, 10523, 10527, 10531, 10535, 10539, 10543, 10551, 10555, 10563,
   10567, 10571, 10576, 10582, 10590, 10594, 10602, 10606, 10614, 10618,
   10626, 10630, 10635, 10641, 10645, 10649, 10653, 10661, 10666, 10672,
   10677, 10683, 10688, 10694, 10698, 10706, 10714, 10718, 10723, 10729,
   10737, 10741, 10748, 10753, 10759, 10764, 10769, 10775, 10779, 10787,
   10791, 10795, 10799, 10803, 10811, 10815, 10819, 10827, 10831, 10835,
   10843, 10847, 10855, 10859, 10863, 10867, 10871, 10875, 10879, 10883,
   10887, 10895, 10899, 10907, 10911, 10919, 10923, 10927, 10931, 10935,
   10939, 10947, 10951, 10959, 10963, 10971, 10975, 10983, 10987, 10995,
   10999, 11003, 11011, 11015, 11023, 11028, 11034, 11038, 11042, 11046,
   11050, 11054, 11058, 11062, 11070, 11074, 11082, 11090, 11095, 11101,
   11105, 11109, 11113, 11117, 11122, 11128, 11136, 11144, 11148, 11152,
   11160, 11164, 11172, 11180, 11184, 11192, 11200, 11205, 11211, 11216,
   11222, 11226, 11234, 11238, 11242, 11246, 11254, 11258, 11267, 11269,
   11277, 11282, 11288, 11292, 11300, 11304, 11312, 11320, 11325, 11331,
   11335, 11343, 11347, 11351, 11355, 11363, 11367, 11375, 11379, 11387,
   11391, 11399, 11407, 11415, 11423, 11431, 11439, 11447, 11451, 11459,
   11463, 11467, 11471, 11475, 11479, 11483, 11487, 11491, 11495, 11499,
   11503, 11507, 11511, 11512, 11517, 11523, 11531, 11535, 11543, 11547,
   11548, 11552, 11560, 11564, 11568, 11572, 11580, 11584, 11588, 11592,
   11596, 11600, 11604, 11608, 11612, 11616, 11620, 11624, 11628, 11632,
   11636, 11640, 11644, 11648, 11652, 11656, 11660, 11664, 11668, 11672,
   11676, 11680, 11684, 11688, 11692, 11696, 11700, 11704, 11708, 11712,
   11716, 11720, 11724, 11728, 11732, 11736, 11740, 11744, 11748, 11752,
   11756, 11760, 11764, 11768, 11772, 11776, 11780, 11784, 11788, 11792,
   11796, 11800, 11804, 11808, 11812, 11816, 11820, 11824, 11828, 11832,
   11836, 11840, 11844, 11848, 11852, 11856, 11860, 11864, 11868, 11872,
   11876, 11880, 11884, 11888, 11892, 11896, 11900, 11904, 11908, 11912,
   11916, 11920, 11924, 11928, 11932, 11936, 11940, 11944, 11948, 11952,
   11956, 11960, 11964, 11968, 11972, 11976, 11980, 11984, 11988, 11992,
   11996, 12000, 12004, 12008, 12012, 12016, 12020, 12024, 12028, 12032,
   12036, 12040, 12044, 12048, 12052, 12056, 12060, 12064, 12068, 12072,
   12076, 12080, 12084, 12088, 12092, 12096, 12100, 12104, 12108, 12112,
   12116, 12120, 12124, 12128, 12132, 12136, 12140, 12144, 12148, 12152,
   12156, 12160, 12164, 12168, 12172, 12176, 12180, 12184, 12188, 12192,
   12196, 12200, 12204, 12208, 12212, 12216, 12220, 12224, 12228, 12232,
   12236, 12240, 12244, 12248, 12252, 12256, 12260, 12264, 12268, 12272,
   12276, 12280, 12284, 12288, 12292, 12296, 12300, 12304, 12308, 12312,
   12316, 12320, 12324, 12328, 12332, 12336, 12340, 12344, 12348, 12352,
   12356, 12360, 12364, 12368, 12372, 12376, 12380, 12384, 12388, 12392,
   12396, 12400, 12404, 12408, 12412, 12416, 12420, 12424, 12428, 12432,
   12436, 12440, 12444, 12448, 12452, 12456, 12460, 12464, 12468, 12472,
   12476, 12480, 12484, 12488, 12492, 12496, 12500, 12504, 12508, 12512,
   12516, 12520, 12524, 12528, 12532, 12536, 12540, 12544, 12548, 12552,
   12556, 12560, 12564, 12568, 12572, 12576, 12584, 12588, 12592, 12596,
   12600, 12604, 12608, 12612, 12616, 12620, 12624, 12628, 12632, 12636,
   12640, 12644, 12648, 12652, 12656, 12660, 12664, 12668, 12672, 12676,
   12680, 12684, 12688, 12692, 12696, 12700, 12704, 12708, 12712, 12716,
   12720, 12724, 12728, 12732, 12736, 12740, 12744, 12748, 12752, 12756,
   12764, 12768, 12772, 12776, 12780, 12784, 12788, 12792, 12796, 12800,
   12804, 12808, 12812, 12816, 12820, 12824, 12828, 12832, 12836, 12840,
   12844, 12848, 12856, 12860, 12864, 12868, 12872, 12876, 12880, 12884,
   12888, 12892, 12896, 12900, 12904, 12908, 12912, 12916, 12920, 12924,
   12928, 12932, 12936, 12940, 12944, 12948, 12952, 12956, 12960, 12964,
   12968, 12972, 12976, 12980, 12984, 12988, 12992, 12996, 13000, 13004,
   13008, 13012, 13016, 13020, 13024, 13028, 13032, 13036, 13040, 13044,
   13048, 13052, 13056, 13060, 13064, 13068, 13072, 13076, 13080, 13084,
   13088, 13092, 13096, 13100, 13104, 13108, 13112, 13116, 13120, 13124,
   13128, 13132, 13136, 13140, 13144, 13148, 13152, 13162, 13163, 13166,
   13167, 13168, 13174, 13175, 13176, 13177, 13178, 13191, 13191, 13200,
   13215, 13217, 13220, 13222, 13226, 13238, 13254, 13258, 13269, 13270,
   13273, 13285, 13294, 13295, 13298, 13299, 13300, 13303, 13304, 13307,
   13308, 13311, 13312, 13315, 13317, 13319, 13321, 13325, 13332, 13339,
   13355, 13389, 13399, 13402, 13406, 13419, 13420, 13422, 13424, 13428,
   13442, 13449, 13510, 13519, 13521, 13522, 13525, 13527, 13528, 13531,
   13532, 13533, 13534, 13535, 13542, 13541, 13551, 13553, 13555, 13556,
   13559, 13560, 13561, 13562, 13565, 13566, 13570, 13569, 13586, 13584,
   13600, 13599, 13613, 13619, 13620, 13623, 13625, 13626, 13629, 13630,
   13631, 13632, 13635, 13636, 13639, 13647, 13664, 13672, 13695, 13801,
   13835, 13837, 13839, 13843, 13847, 13846, 13897, 13899, 13898, 13913,
   13919, 13926, 13931, 13937, 13938, 13941, 13942, 13943, 13944, 13945,
   13946, 13947, 13955, 13963, 13966, 13967, 13968, 13969, 13970, 13971,
   13979, 13987, 13988, 13989, 13992, 13993, 13996, 13998, 14007, 14095,
   14096, 14103, 14104, 14105, 14111, 14120, 14123, 14124, 14125, 14126,
   14129, 14130, 14131, 14134, 14136, 14144, 14145, 14151, 14159, 14160,
   14163, 14164, 14167, 14172, 14179, 14184, 14191, 14198, 14198, 14200,
   14207, 14208, 14211, 14212, 14213, 14214, 14215, 14216, 14217, 14218,
   14219, 14225, 14232, 14244, 14250, 14257, 14265, 14266, 14278, 14289,
   14300, 14304, 14305, 14308, 14313, 14317, 14318, 14321, 14327, 14335,
   14341, 14348, 14352, 14353, 14356, 14359, 14363, 14364, 14367, 14373,
   14382, 14387, 14397, 14407, 14419, 14420, 14421, 14422, 14423, 14424,
   14425, 14426, 14427, 14428, 14429, 14430, 14431, 14432, 14433, 14440,
   14441, 14444, 14445, 14452, 14453, 14454, 14461, 14460, 14477, 14478,
   14485, 14484, 14554, 14560, 14566, 14574, 14580, 14586, 14592, 14598,
   14604, 14610, 14616, 14622, 14633, 14634, 14637, 14638, 14639, 14640,
   14641, 14642, 14643, 14644, 14645, 14646, 14647, 14648, 14649, 14650,
   14651, 14652, 14653, 14654, 14655, 14656, 14657, 14658, 14659, 14660,
   14663, 14664, 14665, 14666, 14667, 14668, 14672, 14673, 14674, 14675,
   14676, 14677, 14678, 14681, 14684, 14685, 14686, 14687, 14688, 14689,
   14690, 14691, 14704, 14705, 14706, 14707, 14708, 14709, 14710, 14715,
   14716, 14717, 14718, 14719, 14720, 14726, 14727, 14728, 14729, 14730,
   14731, 14732, 14733, 14734, 14735, 14736, 14739, 14740, 14741, 14742,
   14743, 14746, 14747, 14748, 14749, 14752, 14753, 14754, 14755, 14756,
   14757, 14758, 14775, 14776, 14777, 14780, 14781, 14782, 14783, 14784,
   14785, 14789, 14789, 14792, 14798, 14799, 14802, 14804, 14809, 14819,
   14830, 14837, 14838, 14839, 14842, 14875, 14877, 14879, 14882, 14892,
   14902, 14912, 14913, 14916, 14918, 14919, 14920, 14923, 14925, 14933,
   14934, 14935, 14939, 14940, 14944, 14945, 14948, 14949, 14952, 14953,
   14954, 14955, 14956, 14959, 14960, 14961, 14962, 14963, 14964, 14965,
   14966, 14967, 14968, 14969, 14970, 14971, 14972, 14973, 14974, 14975,
   14976, 14977, 14978, 14979, 14980, 14981, 14982, 14983, 14984, 14985,
   14986, 14987, 14988, 14989, 14990, 14991, 14992, 14993, 14994, 14995,
   14996, 14997, 14998, 14999, 15000, 15001, 15002, 15003, 15004, 15005,
   15006, 15007, 15008, 15009, 15010, 15011, 15012, 15013, 15014, 15017,
   15018, 15019, 15020, 15023, 15024, 15025, 15026, 15027, 15028, 15029,
   15030, 15031, 15032, 15039, 15040, 15041, 15042, 15043, 15046, 15047,
   15050, 15051, 15062, 15063
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EVENT", "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE",
  "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FILTER", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR",
  "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION",
  "FUNCTIONS", "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P",
  "HANDLER", "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P",
  "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING",
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY",
  "INLINE_P", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT",
  "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO",
  "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LABEL",
  "LANGUAGE", "LARGE_P", "LAST_P", "LATERAL_P", "LC_COLLATE_P",
  "LC_CTYPE_P", "LEADING", "LEAKPROOF", "LEAST", "LEFT", "LEVEL", "LIKE",
  "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP",
  "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MATERIALIZED", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES",
  "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING",
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC",
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR",
  "OPTION", "OPTIONS", "OR", "ORDER", "ORDINALITY", "OUT_P", "OUTER_P",
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL",
  "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS", "POSITION",
  "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY",
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "PROGRAM", "QUOTE",
  "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REF",
  "REFERENCES", "REFRESH", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME",
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT",
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW",
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P",
  "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER",
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR",
  "SIMPLE", "SMALLINT", "SNAPSHOT", "SOME", "STABLE", "STANDALONE_P",
  "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE",
  "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC", "SYSID", "SYSTEM_P",
  "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY",
  "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION",
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P",
  "TYPES_P", "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE",
  "UNKNOWN", "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER", "USING",
  "VACUUM", "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES",
  "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW",
  "VIEWS", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH",
  "WITHIN", "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P",
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS", "XMLFOREST",
  "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P",
  "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_ORDINALITY", "WITH_TIME",
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'",
  "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with",
  "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "generic_set", "set_rest_more", "var_name", "var_list",
  "var_value", "iso_level", "opt_boolean_or_string", "zone_value",
  "opt_encoding", "NonReservedWord_or_Sconst", "VariableResetStmt",
  "reset_rest", "generic_reset", "SetResetClause",
  "FunctionSetResetClause", "VariableShowStmt", "ConstraintsSetStmt",
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt",
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd",
  "alter_column_default", "opt_drop_behavior", "opt_collate_clause",
  "alter_using", "replica_identity", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "opt_program", "copy_file_name", "copy_options",
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids",
  "copy_delimiter", "opt_using", "copy_generic_opt_list",
  "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateMatViewStmt",
  "create_mv_target", "OptNoLog", "RefreshMatViewStmt", "CreateSeqStmt",
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by",
  "NumericOnly", "NumericOnly_list", "CreatePLangStmt", "opt_trusted",
  "handler_name", "opt_inline_handler", "validator_clause",
  "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen",
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable",
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt",
  "CreateEventTrigStmt", "event_trigger_when_list",
  "event_trigger_when_item", "event_trigger_value_list",
  "AlterEventTrigStmt", "enable_trigger", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "old_aggr_definition", "old_aggr_list", "old_aggr_elem",
  "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "opt_if_not_exists", "CreateOpClassStmt", "opclass_item_list",
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label",
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt",
  "RevokeStmt", "privileges", "privilege_list", "privilege",
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption",
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique",
  "opt_concurrently", "opt_index_name", "access_method_clause",
  "index_params", "index_elem", "opt_collate", "opt_class", "opt_asc_desc",
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args",
  "func_args_list", "func_args_with_defaults",
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name",
  "func_return", "func_type", "func_arg_with_default", "aggr_arg",
  "aggr_args", "aggr_args_list", "createfunc_opt_list",
  "common_func_opt_item", "createfunc_opt_item", "func_as",
  "opt_definition", "table_func_column", "table_func_column_list",
  "AlterFunctionStmt", "alterfunc_opt_list", "opt_restrict",
  "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes",
  "any_operator", "DoStmt", "dostmt_opt_list", "dostmt_opt_item",
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists",
  "ReindexStmt", "reindex_type", "opt_force", "AlterTblSpcStmt",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "AlterSystemStmt",
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "for_locking_strength", "locked_rels_list", "values_clause",
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause",
  "opt_alias_clause", "func_alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "rowsfrom_item",
  "rowsfrom_list", "opt_col_def_list", "opt_ordinality", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_application", "func_expr", "func_expr_windowless",
  "func_expr_common_subexpr", "xml_root_version",
  "opt_xml_root_standalone", "xml_attributes", "xml_attribute_list",
  "xml_attribute_el", "document_or_content", "xml_whitespace_option",
  "xmlexists_argument", "within_group_clause", "filter_clause",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "opt_target_list", "target_list", "target_el",
  "qualified_name_list", "qualified_name", "name_list", "name",
  "database_name", "access_method", "attr_name", "index_name", "file_name",
  "func_name", "AexprConst", "Iconst", "RoleId", "role_list",
  "SignedIconst", "NonReservedWord", "unreserved_keyword",
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword",
  "statements", "statement", "CreateAsStmt", "$@1", "at", "ECPGConnect",
  "connection_target", "opt_database_name", "db_prefix", "server",
  "opt_server", "server_name", "opt_port", "opt_connection_name",
  "opt_user", "ora_user", "user_name", "char_variable", "opt_options",
  "connect_options", "opt_opt_value", "prepared_name", "ECPGCursorStmt",
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration",
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval",
  "ECPGDeclaration", "$@2", "sql_startdeclare", "sql_enddeclare",
  "var_type_declarations", "vt_declarations", "variable_declarations",
  "type_declaration", "$@3", "var_declaration", "$@4", "$@5",
  "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
      61,    60,    62,   755,    43,    45,    42,    47,    37,    94,
     756,    91,    93,    40,    41,    46,    44,    59,    58,   123,
     125
};
# endif

#define YYPACT_NINF -4769

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4769)))

#define YYTABLE_NINF -2684

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-2684)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   -4769,   489, 18773, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, 26359, -4769,
   -4769, -4769, -4769, -4769,100610,   884, -4769, -4769, -4769,105551,
   -4769, -4769, -4769,   528, 67780, -4769, 70720,  1194, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, 74640, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, 56497,  1238, -4769,
     346, -4769, -4769, -4769, -4769, -4769, -4769, -4769,   -26,  9374,
   -4769, -4769, 71210, -4769,   123, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, 71700,   752, -4769, -4769,   928,   980, -4769,   114,
   14582, -4769, -4769, 64350, 68760, -4769, -4769, 75130,   851,  1938,
   11271,   -26, 25865, 75620, -4769,  1870, -4769, 53020, -4769, -4769,
   -4769, 68270, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, 82970,  2607,   841, 53520, -4769, -4769,
   -4769, -4769, 82970, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, 76110, -4769,   989,  1079,   798, 83460, 83950, 65820,
   -4769,  1302, -4769, 82970,  1177,   738, 55515, -4769, 84440, -4769,
   -4769,  1108, -4769, 76600, -4769, -4769, -4769, -4769,   841, -4769,
   56497, 52036,    79,  1094, -4769, -4769, 84930, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769,  1953,  1151, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769,   752, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769,   758, -4769,   782,   777,  1914,   570,  1216,
   -4769, -4769, -4769,  8117, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769,102071,  2039, -4769, -4769, -4769,  1241, -4769,  1251, -4769,
   -4769, -4769,  1422, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
    1086, -4769, -4769, -4769, -4769,  1758,101097, 74640, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, 63860, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769,   190, -4769, -4769, -4769,
   -4769, -4769, 74640, 74640, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   74640,  1372, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769,   471,  1592, -4769, -4769, 56497,  2789,  2789,  1906,
  102071, -4769, -4769, -4769, 57970, 82970, 82970, 82970,  1668, 82970,
    1686, 82970,   283, 57970,109774, 77090,  1814,  1688, 47523, -4769,
  108508, 82970, 82970, 85420, 82970,    15, 72190, 82970,  1829, 82970,
   82970,108930, 85910,  1875, -4769,  2195,  1472, -4769, -4769, -4769,
   82970,  7359,  2607, -4769, -4769, 82970,  1797, 57970, 82970,  1725,
   82970,  1819, 82970, -4769, 82970,  1823, 86400,   361,  1754,109774,
    2040, 48027,  1940,109774, 86890, 82970, 82970, -4769, -4769,  1897,
   82970, 82970, -4769,  2052,110196,  1811,  2073,  2240,  2152,   903,
   -4769, -4769,  2331,  1889, -4769, -4769,  2357, 74640, -4769, 72680,
   -4769, -4769, -4769,  2412, -4769, -4769, -4769, -4769, -4769, -4769,
  106820,  1938, -4769, -4769, 58461, 82970,  2193, -4769, -4769, 87380,
   -4769,  2010, -4769,   577, 58952,110618,  2303,  1989, 48531,  2339,
  111040, 87870, -4769, -4769, 88360, -4769, 88850,  2082, 89340, -4769,
  111462, -4769,  2219, 89830, -4769, 24482, -4769,  1979,   811,  2027,
    2428, 74640, 74640,  1581,103408, -4769, -4769,   752, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769,   218,  1497, 54020,   912,
   54520, -4769, -4769,  1047,  1406,  1459,   218,  2430,  2430,    52,
   74640, -4769, -4769,  1497, -4769,   537,     4,  2031,  2031,  2031,
    2209,   -14, -4769,  2031, -4769, -4769, -4769, -4769, 76600, 54020,
   54520, -4769,  2051,  2607,    84,  2445,  2109, 82970, -4769, 82970,
   -4769, 82970, 82970, -4769, -4769, -4769,  2467,  2091,  2325, -4769,
    2086, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
    2275,  2290,  2302,   109,  2607,  2205, -4769,  2421, -4769,  2324,
   31463,   414, 74640,  2607, 55020, 77580, 97670,   174,106820,  2607,
   90320,  2141,  1448,  2343, -4769, -4769, -4769,    54, -4769,  2540,
    2192,  2419,    35,  1472, 45039, -4769,  2190,   849, 76600,102558,
   -4769, -4769, -4769, -4769,   236,  2475, 31972, -4769, 82970,  2183,
   -4769,  2194,  2196,  2204,  1914, -4769, 82970,  1097,  1097,  2589,
    1097,  1614,  1643, -4769,  2384, -4769,  2492,  2457, 76600,  1094,
     -26,  2214, -4769, -4769, -4769,  2230, -4769,  2223,  2238, -4769,
     907,  2501, -4769, -4769, -4769, -4769,  2299,  2332,  2335,  2336,
    2263,  2345,   187, -4769, -4769, -4769, -4769,  2582, -4769, -4769,
   -4769, -4769, -4769, -4769,  2680,  2664,105976,105976,   571,   645,
     176,   194, -4769, -4769, -4769,  2530, -4769, -4769,  2527, 82970,
    2364, 82970, -4769, -4769, -4769, 90810, -4769, -4769,  2789,  2230,
    2292, -4769,   305, -4769,   849, -4769,   331,   351,   368,  1568,
    2295,  1759,  1996, -4769,   543, 82970,  2423,   205,   916,  2362,
   78070,  2392,  2320,   354,  2612,  2676,  2381,   187, 78560, -4769,
   82970, 82970, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769,  2356, -4769, -4769,  2365,  2643,   856,  2566,  1685,  2689,
    7838,  1264, 91300, 98160,  2648,  2701,  4352,  1721,   639,  2587,
     896,  2643,  2686,   943,  2706,  6601, 82970,  2410, -4769,  2623,
    2742,   876, -4769,   827, -4769,  2477,  2636,  1004, 57970,  2442,
   -4769, -4769, 82970, -4769, -4769, -4769,  2524, -4769,   638, 57970,
   -4769,  2651,  2511, 49035, -4769, 82970, -4769, -4769, -4769, -4769,
   -4769,  2597, 82970, -4769, -4769,  2727, 82970, -4769,  2031,  2652,
    2504,  2888, 61407,   149, 82970,  2556,  2934, 82970,  2730,  2556,
    2572, 91790, -4769, -4769,  2556, -4769, -4769, 82970, 82970,  2551,
    1974,  2556,  2763,  2967,  2971,  2666,  2753,   771,  1154,   139,
    2898,  2556,  2656, 82970, 92280, 82970,  2675, 82970,  2985, 57970,
   82970, -4769,  2794, 79050, -4769,  2667,  2331, -4769, -4769, -4769,
   -4769, -4769,  1383, -4769, -4769, -4769, -4769,  2958,  2292,   701,
    2962,  2673,  2984, -4769, -4769,  2731, -4769,  3001,  2320,  3010,
   -4769,  2710, 92770, -4769, 93260, 93750,  3030,  2356,109774,  3053,
    2710,  3063,  2906,  3065,   701,  3070, -4769,   867,  3071,  2959,
    3073,  1690,  2710,107242,  3075,    99, -4769, 24577, 24482, -4769,
   27410,  1061, -4769, -4769, -4769, -4769, -4769, -4769, 35535,   653,
    2863, -4769, -4769, -4769,  1918, -4769,104695, -4769,  1581,  1497,
   -4769, 74640,  1497, 74640,    52,  1497, 74640,  1497, 74640,    52,
    1497, 74640, 74640, 74640,  1497, -4769, -4769,  1702,  2026, -4769,
   -4769, -4769, -4769, -4769, 74640,  2777, 82970, 82970, -4769, -4769,
   -4769, 69250,109774, 69740, -4769, -4769,   287, 74640, -4769, 74640,
   -4769,  2607, -4769, -4769,   811, 61407,  3183,109774,  2985,  3067,
    3067,  3067, -4769, -4769, -4769,  3007, 82970,  3072,  3076, 69250,
  109774, -4769, 94240,106820,  2970,  2788, -4769, -4769, -4769, -4769,
    1977,  2924,   289,  2996, 35535,  2797,   217,   217,  2800,  3083,
   -4769, -4769, -4769,   395,  2807,  2815, -4769,   422,   422,  2972,
    2816,  2818, -4769,   444,  2819, -4769,  3021,   500,  2822,  2823,
    2824,  2165,   217, 35535, -4769,  2825,   422,  2827,  2828,  2829,
    3055,  2832, -4769,  3112,  2833,   462,   488,  2834,  2835, -4769,
    2816, -4769,   406,  2837,  2840,  2843,  2844,  2846,  2847,  2848,
    2849, 35535, 35535, -4769, 30445,   849,  2607, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769,   108, -4769,   508,  3580, -4769,  2885,
   -4769, -4769,  3026, 35535, -4769, -4769,  3054,  2850, -4769,   518,
   -4769, -4769,   849, -4769, -4769,  1802, -4769, -4769, -4769, -4769,
    1588,  1588,   214, -4769, 71210, 71210, -4769, -4769,   756,  2852,
   -4769,  1642, -4769, -4769, -4769, -4769, -4769, -4769,106398,  3257,
   -4769,  1810,  2607,   827,  1338,  3206,103833,104264,  3102,  3102,
    3085, -4769, -4769, 82970, -4769, -4769, 35535, 51052, -4769,   849,
     180,  3105, -4769, -4769, -4769,  2023, -4769, -4769, -4769,   752,
   -4769, 13900, -4769,  2059,  2183, 82970, 82970,  3268, -4769, -4769,
    2194, -4769, -4769,  1914,  1914, 35535,  1914,  1006,  1661, 32481,
   35535,  3153,  3056,  1332,  1591,  3156, -4769,  3059,  1614,  1643,
   76600, 82970, 94730,  2980, -4769, -4769,  2230,  2878,  1894, -4769,
   63370,101584,101584,  3123, -4769, -4769,  1298,    73,  2994,  3086,
    2430,  1598,   813,   813, -4769, -4769,  2874, -4769,  3216, 71210,
    2939,105976, -4769, -4769, 82970, -4769, -4769, 79540, -4769, -4769,
   -4769,  1909,  2881, -4769,  2901, 82970,  3384, -4769,   813,   813,
   -4769, -4769,  2891, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769,102071,  2896, 82970, -4769,  2897,  2899, -4769,102558, 51544,
    1948,   849,  2975,  2977,  3023, 56497,  2900,  2983,  2988,  3025,
    2989,  2991, 98650, -4769, -4769, -4769, -4769,  1602,   862,  1291,
    2992,   163,   152,  3276, -4769,  1613,  3040, -4769, -4769, -4769,
    3847, 82970,  3220,  6857,  3106,   187,  3039, -4769, -4769,  3152,
    3000,  3002,  3119,   187,   178, 99140, -4769, -4769, -4769, -4769,
   -4769, -4769,  5437, 28944, -4769,  3003,  2986,  3014, 82970, 64840,
    2133,  3120,  1221,  2168,   682, 82970,  3197,  3129, 82970,  2940,
    3028,  3029,  3223,  2954,  1362,  3316,  2960, -4769, -4769,  3133,
    3221,  3263,  7726,  3019,  3020, 60425,    -6, 49539,  3305,  1185,
    3044, -4769,  1185, 82970,  3058,  3060, 82970,   187, -4769,  3365,
     187,   187,  1871,  3367,  3064,   274,  1608,  2556,  2960,  2929,
   -4769,  3066,  3069,  1628, -4769,  3168, -4769, -4769,  1316,  3080,
   76600,   224,  1790,  2960,  3078,  3081,  2954,  2954, 82970, 82970,
   82970, 82970, 82970,   165,  3389,  3395,  3087,   144,  3135,  2995,
   -4769,  1185,107664,  3088, -4769,  1185, 82970,  3092,  1954,  2960,
    1741, -4769,  1654, -4769, -4769, -4769,  1472, -4769, 82970, -4769,
   82970,  2292, 61407,  3202, -4769,  3049, -4769,  2320,   187, -4769,
   82970, 82970,  2356,  1202,   906,  3204, 82970,  3262,  3057, -4769,
     908, 51544, -4769,  2551,  3024, -4769,  3074, -4769,  3074,  3074,
    3027,  3027,  3031, -4769, -4769,  2165,  3074,  3027, -4769, 62389,
   -4769,  1826,  1901, -4769,  3425,  3429, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769,  1476, -4769,  2100, -4769, -4769,
   -4769, 82970, 56497, -4769,  3445, -4769, -4769, 61407,  3218,  3331,
   -4769, 82970,  3234,  3035, -4769,  3369,  3094, -4769, -4769,   474,
   -4769,  3338,109774,   225,  2607,  3084, 82970,  3261, 82970, 82970,
   82970, 82970, -4769, -4769,  3233,   658,    78, -4769,107664, -4769,
   82970,  2929,  3246,  3452,   646,  2031, 82970,  3339, -4769, 82970,
    3052,  3454,  3290, -4769, -4769,  3061,  2430, -4769,  2667, -4769,
    2139, -4769,  3175, -4769, 57970,   701, -4769, -4769, -4769, -4769,
   61407, 82970, 95220, 57970,   701,109774,109774,  3356,    99,  3357,
    3113,  3361,  3116, 49539,   701,   133,109774, 82970, 82970, 82970,
   -4769, 82970, -4769, -4769, -4769, -4769, 82970, 82970,109774,107664,
    3363,  3368,   701, 82970, 82970, -4769, -4769, 27321,  1462, -4769,
   24482, -4769, 13900,  2107,  3102, -4769,  1372, 82970,  1560,  1581,
  108086, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, 74640,
   -4769, 74640,    52, -4769, -4769, 74640, -4769, 74640,    52, -4769,
   74640, -4769, -4769, -4769, 74640, 82970,  3565,  3077, -4769,  1802,
   -4769, 82970,  2110, -4769, -4769,  2111,   965, 82970, 82970,   610,
   57970, 82970,  3269, 82970, 82970, 82970, 82970, 82970,  3160,  2852,
    1420, -4769,   339, 76600,  3275, -4769, -4769, -4769, -4769, -4769,
    2126,  1953,   937, 82970, -4769, -4769, -4769, -4769, -4769, -4769,
   69740, 68270,  3370,   196, 82970, -4769, -4769,  4088, 35535, 30954,
   -4769, -4769, -4769,  3090, 13900,  3125, 35535, -4769, -4769, 35535,
    3091,  2430,  2430, 35535, -4769, -4769, -4769, -4769,  2314,  2430,
   -4769, 35535, 35535,  2430,  2430,  3074,  3074, -4769,  4289, 35535,
   -4769, 49539, 35535, 37062, 28434, 35535,  3171,  3114,  2430, -4769,
    2430, -4769, 35535, 29936, -4769, 35535,  3307, 38080, 35535,  1338,
    3309, 35535,  1338,  3528,  3528,  1094,  2791,  5411,  3101,   849,
   -4769,  3215,  2430, -4769,  2430,  1109,   257, 61407, 35535, 56497,
    3185,   150, 82970, 35535,  3107,  1994, -4769, 35535,  1500, -4769,
    3108, 35535,  3186, 35535, 35535, 35535, 35535, 35535, 35535, 35535,
   35535, 35535, -4769, 39070,   290, -4769,  3386,  3404,   -44,  3242,
   70230,  3397, -4769, 31463, 27924, -4769,   248, 74640, -4769, -4769,
     849, -4769, -4769, -4769, -4769, -4769,  1909,  3117, -4769,  3132,
   -4769, -4769, -4769, -4769, -4769, 82970,  3257, -4769, -4769,  3191,
   -4769, -4769, -4769, -4769,   814, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769,  3118, -4769, -4769, -4769, -4769,  3118, -4769,
   -4769,  3102,  3121,  4882, -4769, -4769, -4769, -4769,  3393,  3394,
     701,102071, 82970,   236, 73170, -4769, 31972, -4769,  2138, -4769,
    3131, -4769,  3380, -4769,  3134, -4769, 11469,  3380, -4769, -4769,
     160,  3244,  3373,  3324, -4769, -4769, -4769,  3137, 13900, -4769,
    2036, 13900,  2123, -4769, -4769, -4769, -4769, -4769, -4769,  1410,
   -4769, 82970,  3275,  3153,  1591,  3196,   982, 82970, -4769, 45534,
    2037, -4769,  2230, -4769, -4769, 25109, -4769, 26847, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769,  3141, -4769, -4769,
   -4769, -4769, -4769,   187,  3142,  3623, -4769,105976, -4769, -4769,
   -4769,  3565, -4769,  2357, -4769,  2357,  3651, -4769, 74640, -4769,
   -4769, -4769, -4769,   530, -4769, 24482, -4769, 24482, -4769,  3332,
   -4769,  3541, -4769, 62389, -4769,  3155, -4769, 61898, 59443, -4769,
   -4769,   675, -4769,   869,  3235,  3237,  3279,109774, 82970, 82970,
   -4769, 56497,109774, 82970, 82970,109774, 82970, 82970, -4769,  3520,
    1115, 68270,  3283, 66310, -4769, -4769,  3162, 82970,  3219,  3405,
    3406,   891, -4769, -4769, 95710, -4769,  3360,109774, 82970, 82970,
   35535,  3366, 82970, 82970, -4769,   337,  3245,  3250, -4769, 82970,
    3251, 57970,  3179, 82970, 82970, 82970,  3254,   674, 57970,  3226,
   50043, 82970, 82970, 82970, 82970,  3304, 82970, 82970,  3422,  1000,
   76600,   120,  2262,  2960,  3383, -4769,  1306, -4769,109774, 82970,
    3376, -4769, -4769, -4769, 66800,  3589,  3296, -4769, -4769, 99630,
   -4769, -4769, -4769,  2150, -4769,109774,109774, 82970,  8902, 82970,
    1084, -4769, -4769, 61407, -4769, 82970, 82970, 82970, 82970, 73660,
   96200, 96690,  1429,  1521, 82970, 74150, -4769, 82970, -4769, -4769,
   56988,109774, 82970,   665, 56497, -4769, 82970,  3381,  1026, -4769,
   82970,  7611,  3273,  3284, 82970,   122,  2407,  2960, 82970, 82970,
    3194,  2151,  3277,  3320, -4769, 82970, 97670, -4769,109774,  2200,
   -4769,  3341,109774, 82970,  8770, -4769, -4769,   187, -4769, -4769,
   -4769, -4769, -4769, 82970, 82970,   187, 82970,   187,   202, -4769,
  109774, 82970, -4769, -4769, -4769, 82970,  8946, 82970, 82970, 82970,
   82970,109774, 82970, -4769, -4769,  1200,  1664,  1114,  1361,  3342,
   82970,  3473, 82970, 97180,109774, 82970, 82970, 82970,  1360, -4769,
   -4769, -4769,  3318, -4769,109774,  2200, -4769,  9261, 82970, 82970,
    3285,  3288,   185,  3371, -4769, -4769, -4769, -4769, -4769, -4769,
    3449,  3612, 82970, -4769,  3456,  3459,  3274,  3286,  3461,  1691,
   82970, -4769, -4769, -4769, -4769, 82970,  3465,  1691,  3411,   588,
   -4769, -4769,  2556, -4769,  2197, -4769,  3241, -4769, 35535,  3636,
   61407,  3248,  3252,  3321, -4769,  3325,  2430, -4769,  2217, -4769,
   -4769,  2229, -4769,  3256,   658,  1936, -4769, 56497, 82970,   718,
    1178,  3540, 65330,  3718,  3538, 82970,  3294, 82970,  3718, 82970,
   -4769,  1715, 68270, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769,  3539, -4769,  2607,  2551,  2551,  2551,  2551, -4769,
   -4769, -4769, -4769,  3443,  1782, -4769,  3255,  2551, 82970,  3372,
    3718,  3264, -4769,  2929,  3555,  3558, 82970, 65330,  2269,  3293,
    3666,  2031,  2607,  3448, -4769, 29440,  4608,  3455,106820, 79050,
   -4769,  3272,  3535,  3542,  3557, -4769,  2292, -4769,  3677, -4769,
    3574,   701,  2320, -4769,  2710, -4769, 82970, -4769, 82970, 82970,
   82970, 82970,  2356, -4769, -4769,  2710,  3463,   701,   701, -4769,
    3464,   701,  2710,  3399,  3570,106820, -4769,    99, -4769, -4769,
   -4769, -4769, -4769, 35535, -4769, -4769,  2031,  2139, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, 74640,
    2357, -4769,  2235, -4769, 82970, -4769,  3551,  3552,  3554,  3297,
    3302,  3323, 82970,  3308, -4769,  3297,   187,  3297,  2852,  2852,
    3297,  3302,109352,  3714,  3577,   111, -4769,   119,  1394,  3518,
   -4769, -4769, -4769, -4769, 61407, -4769, -4769, -4769, -4769, -4769,
   82970,  3344,   147,  3496,  3310,109352,  3702,   701, -4769, 57970,
   -4769, -4769, -4769,  3388,  3407, 57970,  3508,  3362, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769,  3559, 82970,  2236, -4769,  1683,
   -4769,  1712, 35535, 35535,   275, -4769, 12010,  2309, 35535,  3317,
    3322,  2313, -4769, -4769, -4769, -4769, -4769, -4769,  3327,  3605,
   -4769, -4769,  3328,  2316,  2322,  3329,  3330, -4769, -4769,  3617,
    3334, 12095,  3335, 37062, 37062,  1141, -4769, -4769, 37062,  3343,
   -4769,  2330,  6702,  3336,  3346,  3374, -4769,  3347,  3349, 12301,
   32990, 35535, 32990, 32990, 12851,  3336,  3350,  2342, 56497,  3492,
   12737,  2352, -4769, 35535, 56497,  5364, 35535, -4769, 35535, 82970,
    3351,  3354, -4769, -4769,  4289, -4769,  3377, -4769, 37062, 37062,
   -4769,  2399, 30445, -4769, -4769,  3626, -4769, -4769,  1732, -4769,
    3358, -4769, -4769,  2453,   207, 35535,  3107, 35535,  3437, 49539,
    4237, 35535,  5282,  5452,  5452,   629,   629,   172,   172,   172,
    1840,  3242, -4769, -4769, -4769,  3364,  3382,  3385,  3521,  2832,
   35535, -4769,  2441,  2447, 82970,  7103, 10095, 10623, -4769, -4769,
   40583,  3401, -4769, 35535, 35535, 35535,  3387, -4769,  3786, 13900,
     480, -4769,  3788, -4769, -4769, -4769,  1512,  3651,  1909, -4769,
    1472,  2430,  1109,104695, -4769, -4769, -4769, 35535, -4769, -4769,
   -4769, -4769,  2194, -4769, -4769, -4769, -4769, -4769, 82970,  1953,
   35535, -4769, -4769,   677,  2093, 35535,  2036, -4769, -4769,  3423,
   -4769, 35535, -4769, -4769, -4769,  2852, -4769, -4769, -4769, 40583,
    3408,  3416, 44544,  3500, -4769, -4769, 82970,   186, -4769, -4769,
   -4769,  3400, -4769, -4769, -4769,   -95, -4769, -4769, -4769, -4769,
   -4769, -4769,  3390, -4769,  3378, -4769,  3402, -4769, -4769, -4769,
   -4769,   183,  3392,  3403,  3396,  1059, -4769, 59443,  2100, -4769,
   61898, -4769, 61898, -4769,  2100,  3759, -4769, 59443,  1681,109774,
   82970, 82970, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769,  3598, -4769,109774,109774,  3572, 82970,  3567,  3576,
   35535,   267, 82970,  3410,  3415,  1229,  3661, 82970, -4769,  3703,
     701, -4769, -4769,  3480, -4769, 13900, -4769, -4769, -4769, -4769,
   -4769,109774, 82970, -4769,106820, -4769,  2292, 61407, -4769, -4769,
   -4769, 82970,  3436, 82970, -4769, 82970, 82970, 82970,  2356, -4769,
   -4769, -4769, -4769,  1068, -4769, -4769, 82970, 82970,   486,  3482,
    3485, 82970, -4769,   516,  3168,  9620, 82970, 82970, 82970,  3664,
   -4769, -4769, -4769, -4769,  3613, -4769, -4769, 59443, -4769,  2710,
    1335,  3498,  2960, -4769,  3601, -4769,  1381, -4769, -4769, -4769,
   -4769, -4769,  3723,   701,  3725,   701, 82970, 82970, 82970, 82970,
   -4769, -4769, -4769, -4769, -4769, 56497, 56497, 56497,  2367, -4769,
   -4769,  2607, -4769, -4769, -4769, -4769, -4769, -4769,  3686, -4769,
    2373, -4769,  1479, -4769, -4769, -4769, -4769, -4769, -4769,109774,
   82970,  9839, 82970, 82970, 82970,  2003, -4769,  1093, 61407, -4769,
   60916,109774, 82970, -4769, -4769,  3653,  3596, -4769,  1730,  3597,
  109774,  3489, -4769, -4769,  3511, -4769, -4769,  3512,  2471,  2960,
    2929, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,  1446,
     199,  2537,  2960,  3514, -4769,  3515, -4769, -4769, -4769,  3656,
    3657,  3658,  3519,  3522,  3566,  3523,  3524,  3571, -4769,  3527,
    3579,  3529,  3582,  3532,   701, 61407,  3643,  2607,  3568,  3765,
     701, -4769,  3543, -4769, -4769,  3867, -4769, 82970, -4769,  3546,
    2552,  2960, -4769, -4769,109774, 82970, -4769, -4769, -4769,  1691,
   61407,  3713,  1691,  1691, 82970, 82970,  1691, -4769, -4769, -4769,
    3715,  3716,  1691, -4769, -4769, -4769, -4769,  2652,  3471, -4769,
    2412, 47019,  6049,  3477,  3252,  3478,  2430, 43059,  1395,  3691,
    3481, -4769, -4769, 56497, 47019,  1800,  3709,  3499,  3499,  3499,
    3499,  3499,  3499,  3499, -4769,  3345,   284,  2556,106820, 82970,
  106820, -4769,  1178,  3601, 82970, 82970,  3484,  3486, -4769, -4769,
   -4769, -4769,109774,    50,109774,  2430, -4769, -4769,  3556, -4769,
   82970,  2031,  3885,  2971,   225,  3627,  1856,  3832,  3293, -4769,
   -4769, -4769, -4769, 82970, 82970,   658,  2607, -4769,  3493,  3494,
   -4769, 82970, 82970, 82970, 82970,  1953,  3501,  3495, 61407,   542,
    3685,  3688,  2954,  3904,  1953,  3293,  3581, 82970, -4769,  2409,
     117, -4769,  2607,106820, 59934, -4769,  4063, -4769, -4769,  1058,
    3780, -4769, 82970, -4769, -4769, 44049,   701, 61407, 82970, -4769,
     701,    99,  3561,   701,  3562,   701,   701, 82970, -4769, -4769,
   82970, -4769, 82970,107664,   701, -4769, 13900,  3797, -4769, -4769,
   -4769, -4769,  3631,  3632,  3634, 82970,  3297, 57970, -4769,  3513,
  109774,  1468, -4769, -4769,  3705, -4769, -4769, -4769, -4769, -4769,
    3823,  3826, -4769, -4769, -4769,   169, -4769,109774, 69250,   153,
  109774, -4769,  2292, -4769, -4769,  2320,   187, -4769, 82970,  3767,
   -4769, -4769, -4769,  3530,  2420, 12886, 35535, -4769,  3835, 61407,
   -4769,  6361, -4769, -4769, -4769, -4769, 35535, -4769, -4769, -4769,
   -4769, -4769, 35535, -4769, 35535,  3810, -4769,  3952,  3952, 61407,
   37062,  1571,  2827, 37062, 37062, 37062, 37062, 37062, 37062, 37062,
   37062, 37062, 39579,   623, -4769, -4769, 35535, 35535,  3819,  3810,
   -4769, -4769,  1585,  1585, 61407,  3531,  3336,  3533,  3534, 35535,
   -4769, -4769,  2433, 38575,  3536, 56497, -4769, 35535, 11602,  2455,
    3575, 13407,   849,  7154, -4769,  3911,  2607, 35535,  1853,  2583,
   35535,  2458, 35535,  3822, -4769, -4769, -4769,  3545, -4769, -4769,
   61407, 35535, 37062, 37062,  5132, -4769,  5606, 35535,  3547,  5934,
   30445, -4769,  3719,  3585, 46029, -4769,   841,   841,   841,   841,
   -4769, 82970, 82970, 82970, 41078,  3825, 40088, 80030,  3549,  2247,
   -4769, 80030, 80520, -4769,  3564, -4769,  3563,   849, 35535,  3829,
     763,   763,  3719, -4769, 35535, 33499,  3560, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769,  3578, -4769,  3569, -4769, -4769,   827,  3583,
   -4769, -4769,  6388,   183, -4769, -4769,  3584, -4769,  3586, -4769,
    2093, -4769, -4769, -4769,  7275,  3739, -4769, -4769,  3549, 34008,
    3500, -4769,  2463, -4769, -4769, 31463, -4769, -4769,  2479, 45534,
    3408, 31972,   849,  2430,  3590, -4769,  2357,  1512, -4769, -4769,
   -4769, -4769, -4769,  2497,  1947, -4769, -4769, 59443, -4769,  3625,
   -4769, -4769, -4769,  3499,  2710,  2710,   847,  3297,  3844,   847,
    8284, -4769, -4769, 41573, 82970, 82970, -4769, 82970,  2510,  1837,
   82970, -4769, 82970, -4769, -4769, -4769, -4769,  3963, -4769, 82970,
   -4769, -4769,  3614,  3619, -4769, 82970, 82970, 82970, 82970, -4769,
   -4769,  2295, -4769, -4769,109774, 82970, -4769, -4769, -4769,   204,
    2616,  2960, -4769,  3655, -4769, -4769,  3836, -4769,  3967,  3667,
   82970,  3587, -4769,  1837,   179,  2954,   887, -4769, -4769,  3659,
   82970, -4769, 82970, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, 56988, -4769, -4769, 82970, -4769, 56497, 47019, 56497,
   -4769,  1537,   230,  2628,  2960, -4769,  3665, -4769,  3669,  3671,
    3711,   788,  1013,  3672,  3673,  3721,  3599,  3606,  3615, -4769,
   -4769,   218,  2607, -4769, -4769,  2607,  2710,  2607, 82970, 82970,
   82970,  3985,  3699, 82970, 82970, 82970, 82970, 82970,  3907,   595,
    1929,109774, 82970, 82970,109774, 82970, 82970, 82970, 82970, 82970,
   82970, 82970, -4769,  3991,  3916,  2158,  3964,  3693, 82970, -4769,
   82970,  3168, 82970, 82970, -4769, -4769, -4769,  3622,  1691, -4769,
   -4769,  3869,  3874, -4769,  1691,  1691, -4769,   908, 56497, -4769,
    3282, -4769,  3241,  3586,   813,   813, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769,  2430,  2465,  3635, -4769, 43554, -4769,  3633,
   -4769,  2310,  1109, -4769, -4769, 82970,  3499, -4769,  2483,  2685,
    2773,  2855, 81010, 81500, 81990,  3637, 82970, 82970, 37062, -4769,
    1716,   992, -4769,  3877, 82970,  3675, -4769, -4769, -4769,  3798,
   82970, -4769, -4769, -4769, -4769, -4769,  3648, -4769,  3756, 65330,
    2710,109774,109774,  2710, -4769, 61407,  3649,  3293,109774,   225,
    1398, 92280,  3683, -4769,  3654,  3941, -4769,  3660,  3663, -4769,
   -4769, 82970,  3601,  2516,   705,  2027,  3344, 67290,  2269,  3917,
   -4769, -4769, -4769,  4025,  3749, -4769,  1953,  3344,  3749,  2607,
    3219, -4769, 59443, 35535, 35535, -4769,  3668, -4769,  3670,  4620,
   -4769,  2551, -4769, -4769, -4769, -4769, -4769, -4769,  3745, 82970,
    4100, -4769, -4769, -4769,  3674,   701, -4769, -4769, 82970, -4769,
   82970, -4769, -4769,   701,   701, -4769,  3789, -4769,  1953, 82970,
   82970, 82970,  3297, -4769,   187, -4769,  3958,109352, -4769, -4769,
   -4769, -4769, -4769,  4020,   196,  3965, -4769, -4769,  3925,  3926,
    3927,  3928,  2216, -4769, -4769, 35535, 13900, -4769,  3687, -4769,
   13900,  8619, 13900,  3819, -4769,  2698,  3970, -4769,   641,  3689,
    2698,  2810,  2810,   418,   418,   137,   137,   137,  3952,   623,
   13900, 13900, -4769, -4769, -4769, -4769,  3690, -4769, -4769, -4769,
    3336, -4769, 36044,  3843,  4075, -4769, -4769, -4769,  3737,  3740,
    3700, -4769, 35535, 36553,  3701, 62389, -4769, -4769,  1109,  1878,
   37062, 37062,  1634, -4769,  1085, 35535, 61407,  2535,  1634,  2649,
    2659, 35535, 35535,  6334,   295, 35535,  8825,  3704, 35535,100120,
   -4769, -4769, 82970, 82970, 82970, 82970, -4769, -4769, -4769, 80030,
   80520,  3706, 42563,  2247,  3707, 82970, -4769, -4769,  3710, 40583,
    3947,  3891, -4769, 40583,  3891,  1876,  3891,  3955, -4769, 46524,
   -4769, -4769,  3717, -4769, -4769, 27924,  1873, 13900,  4104,  3992,
   35535,  3720,  3722,  3726, 13900, 35535, -4769,  2607,  1512,  1008,
    2607, -4769, -4769, -4769, 49539, -4769, -4769, -4769,  3909, 13900,
   -4769,  1953, 82970,   849,    63,  3742, 82970, -4769,  3500, -4769,
   -4769, 24482, -4769, -4769, -4769, -4769,  3792,  2538, -4769,   218,
   -4769, -4769, -4769, -4769,  3807, 68270,  4016, -4769, 35535,  2545,
   -4769,  3771,  4106,   143,  2546,  2554,  1837, -4769,  3675, -4769,
    1764,  3996,   278, -4769,   701, -4769, 61407, -4769, 82970, 82970,
   -4769, -4769, -4769, -4769,  2900, -4769, -4769, 82970, 82970, 82970,
   82970, -4769,109774, 82970, -4769, 56497,  3345,  3934, -4769, -4769,
    3939,   218, 82970, -4769, 61407,   701,   701, -4769, -4769, -4769,
   -4769,  3758,  4134,  3833, 82970, 82970, 82970, 82970,109774, 82970,
   82970,  2430,  2430, 61407,  3744, -4769,  2430,  2430,  3747, -4769,
  109774, 82970, 82970, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769,109774, 82970, -4769,  3828, -4769, -4769, -4769,
   82970, 82970, 82970, 82970,  4053, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, 82970, -4769, -4769,  2607,
    2607, 61407,   701,   701, -4769, -4769, -4769,  3997, -4769,  1691,
    1691, -4769, -4769,   130,  2588, -4769,102980, -4769, -4769,  2934,
    2607,  2934,  1841, -4769, -4769,  2934, -4769,  2934, -4769,  1837,
    3754,  1872,  4037, -4769,  2532,102071, 43554, 43554, 43554, 43554,
   43554, -4769, -4769,  4040,   218, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   35535, -4769,  1346,  2698, -4769, -4769, -4769, -4769,  3675,  2031,
    3812, 57970,   934, -4769,  4023,   718, 65330,  1012, 82970, -4769,
    2710,  2710,  3817, 82970,  4168, -4769,   723, 82970,  4079,  3808,
   -4769,  2607, -4769, -4769,  3293, 82970, 65330,  3344, -4769,  2592,
   -4769, -4769, -4769,  3803,  3688,  3769,  2269,  1196, 82970, -4769,
    3809, -4769, -4769,  4055,  3772, -4769, 13900, 13900,  2607, 62880,
    4063, -4769, 82970,  4030, 82970, -4769,   701, -4769,   701,   701,
   -4769, -4769, 82970,  3297,  3297,  3297, -4769,  3959, -4769, -4769,
     701,109352,  2216,  2216,  2216,  2216, -4769, -4769, -4769, 13900,
   -4769, -4769, -4769, 37062,  4059, -4769,  3778, 61407, -4769,  3782,
    2596,  2603, 38080,  3929, -4769, -4769, -4769,  9280,  3837, 13900,
    3883,  3784,  3785, -4769,  1078,  1078,  1085,  2620, -4769, 37062,
   37062,  1634,  1634, 35535,  1634, -4769, -4769,  9350,  3957, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, 57479, 80030,  3790, 82970,
    2247, 40583, -4769, -4769,  2389, -4769, 40583,  4031, -4769, 40583,
   82970,  3793, 82970,   480, 35535, 35535,  3831, -4769, -4769, -4769,
    3719, -4769, -4769,   813, -4769, -4769, -4769, -4769,  1109,  3791,
   74640, -4769, -4769, -4769,  1094, -4769, -4769, -4769, -4769, -4769,
   -4769,109352,  3981,109352,  1837,  9958,  3675, 41573, 50547, 82970,
   82480, 82480,  3940,  3675,  3812, -4769, -4769, -4769, -4769, -4769,
   -4769,  3799, -4769, -4769, -4769,  3875, -4769, -4769,   420,  3275,
    2624, -4769, -4769, -4769, -4769, -4769,  3991, -4769, -4769, 47019,
  109774, 82970, -4769,  3876, -4769, -4769, -4769, -4769, -4769, 42068,
   49539, -4769,   788,  3802,  3805,  1013, -4769, -4769, -4769,   769,
    3275, 82970,  1487,   910,  3846,  3297,  4096, -4769, -4769, -4769,
    3991, -4769, -4769,  1691, -4769, -4769, -4769,  2556,  4137, -4769,
   56497, -4769,105126, -4769, -4769, -4769,  2607, -4769,  2607,  4008,
   82970, 52528,  2607,  2607, -4769, 57970,  4219,  4219, -4769,  3815,
    2056,  2056, -4769, -4769, -4769, 82970, -4769, -4769, 10310,  4012,
   -4769,  3812,  4035,  4081, -4769,  3821, 82970,  3978,  3827,  3824,
     812,   812,  3601, 82970,  2630,  1953,   225, 65330,  3601, -4769,
    1748,  3830,  4133, -4769,  4239,  3501,  3834, -4769, -4769, 67290,
    4014,  3749, 82970,  3688,  3961, -4769,  3966, -4769,   216, -4769,
   82970, 41573, -4769, 61898, -4769,  2657, -4769, -4769,  3401, 82970,
     780, -4769,  3851, -4769, -4769, -4769, -4769, -4769, -4769,   153,
   -4769, -4769, -4769, -4769,   707, 37062, 61407,  2665, 35535, -4769,
   35535, -4769,  4228, -4769, -4769, -4769,   593, -4769, -4769, -4769,
    1078,  1078,  1634, -4769,  4230,  3719, -4769,  2668,  4250, -4769,
   82970,  2681, -4769, 35535,  3848, -4769, -4769, 40583,  2389,  2694,
   82970,  2695, 61407,  3845,  3336, 13900, 82970, -4769,  3849, -4769,
   -4769, -4769, -4769, -4769, -4769,  1468,   847,   153,  4106,  3812,
   -4769,  3853, -4769, -4769, 82970, -4769,  1236,  1236, 82970,  3812,
   -4769, -4769, 82970,  3932, -4769, -4769, 56497,  3906, -4769,   885,
    3275, 82970, 61407,  2320,    40, -4769, 61407, 61407, -4769,  3942,
   -4769, -4769, 82970, 82970, 82970, 82970, 82970,   701, -4769,  3471,
    2607, -4769, -4769,  2700, -4769, -4769, -4769, 82970,  3654, -4769,
    3654, -4769, -4769,  4219,  1064, -4769, -4769, -4769, -4769,  1548,
    4051, -4769,  1158,  4041,  3943,  3858, -4769, 57970,  4285,  3979,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769,  4160,
    3293,  3809, -4769, -4769, -4769, -4769, 35535,  4022,  1953,  2269,
    3917, -4769, -4769, -4769,  2703,  3749, -4769, -4769,  4245,  4057,
    4246, -4769,  2704, -4769, -4769,  4620, 62880,  4192, -4769,  3930,
   82970, -4769, -4769,  2377,  4303, -4769,   707,  2709, -4769,  2713,
    2718,  4021,  3931, -4769, 35535,    49,  3564, 57479,  3880, -4769,
    2723, -4769, 13900, 82970, -4769, -4769, -4769,  2732, -4769, -4769,
    3879, -4769,  4282, -4769, -4769,  4167, -4769, 82480,  3923, 49539,
   -4769,  2093,  2093,  2031, -4769,  1837, -4769, 82970, -4769, 35535,
   -4769,  3971, -4769, -4769,  2733, -4769,   572,  4032,  4176,  2736,
    2739, 82970,  3302,  3924,  3302, -4769,  3297, -4769, -4769, -4769,
   -4769,105126,  3654, -4769, -4769, -4769,  4206,  4151, -4769, -4769,
   -4769, -4769,   291, -4769,  4082,  4083, 82970, -4769,  3893, -4769,
    2743, 82970, 82970,  4304,  4306, -4769, 10420, 57970,  3809,  3688,
    2269,  3345, -4769, -4769,  4085, -4769,  4086,  3293, 41573,  4063,
   -4769,   251, -4769, -4769, -4769, -4769, -4769, 82970, -4769, -4769,
   -4769, -4769, -4769,  3336, 34517, 34517,  3897, -4769, -4769, 82970,
   -4769,  2744, -4769, 82970,  3905,109352,  1236,  3908, -4769,  3903,
   -4769, -4769,  4035,  1837,  3275, 13900, 82970, 57970,  4294, -4769,
   -4769, -4769,  4032, -4769, -4769,  3275, 82970, -4769,  4036, -4769,
     991,   991,  4242, -4769,  3973, -4769, -4769,  3919, -4769,  4348,
    3601, -4769,   788,  1953, -4769,  3918, -4769,  3749,  3688, -4769,
   -4769,  3749, -4769, -4769, -4769, -4769,  1606, -4769, 37571,  4047,
     889, 11809, -4769, -4769, -4769, -4769,  2747, -4769, -4769, -4769,
     153,  2093, 35535,  1837, -4769,  4041, -4769,  3275,  2320, 82970,
   -4769, -4769, -4769,  3808, -4769,  4341, -4769,   644, -4769, -4769,
   -4769, -4769, -4769,  3744,  3809, 56006, -4769,  3749,  3401, -4769,
    2016, -4769, -4769, -4769, -4769, -4769, -4769, -4769,  4331, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769, 10718, -4769, -4769,
   -4769, -4769,  4226, -4769, -4769, -4769, -4769,  2748, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769,  1806, -4769, -4769,  1816,  2204,
   35026, -4769,  1837,  4084, -4769, 56006, -4769,  2016, -4769, 57970,
   -4769, -4769,  3935, 56006,  2752, -4769
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2367,     0,     2,     1,  2797,  2801,  2805,  2806,  2723,  2807,
    2808,  2773,  2774,  2775,  2776,  2777,  2778,  2779,  2780,  2781,
    2782,  2783,  2784,  2786,  2785,  2787,  2788,  2789,  2790,  2791,
    2792,  2793,  2794,  2796,  2795,  2745,  2374,  2742,  2739,  2740,
    2741,  2746,  2744,  2737,  2738,  1964,  2810,  2798,  2811,  2799,
    2800,  2802,  2803,  2772,  2804,  2812,  2813,  2814,  2809,  2817,
    2768,  2769,  2767,  2770,  2771,  2815,  2816,  2759,  2760,  2761,
    2762,  2818,  2375,  2376,  2764,  2368,  2372,  2434,  2505,  2765,
    2766,  2763,  2373,  2758,  2505,     0,  2626,  2627,  2628,     0,
    2629,  2630,  2631,  2557,  2519,  2632,     0,     0,  2633,  2634,
    2635,  2636,  2637,  2638,  2639,  2640,     0,  2641,  2642,  2643,
    2644,  2504,  2645,  2646,  2647,  2648,  2649,  2481,  2487,  2610,
       0,  2461,  2462,  2458,  2460,  2459,  2463,  2446,  1222,   565,
    1310,  1309,     0,  2270,  1222,  2226,  2227,  2271,  2228,  2229,
    2230,   262,     0,  1312,  2231,  2272,     0,  1222,  2273,   389,
     984,  2274,  2275,  2389,     0,  2232,  2233,     0,     0,     0,
     565,  1222,     0,     0,  2234,  1424,  2235,     0,  2236,  2276,
    2277,     0,  2237,  2278,  2279,  2238,  2239,  2240,  2280,  2281,
    2282,  2241,  2283,  2284,     0,     0,  1438,     0,  2242,  2285,
    2243,  2244,     0,  2286,  2245,  2246,  2247,  2287,  2288,  2248,
    2249,  2250,     0,  2251,     0,     0,     0,     0,     0,     0,
    2289,  1222,  2252,     0,     0,  1445,     0,  2253,     0,  2290,
    2254,     0,  2255,     0,  2256,  2257,  2258,  2259,  1438,  2606,
    2482,     0,  1314,     0,  2260,  2291,     0,  2261,  2262,  2263,
    2264,  2265,  2266,  2267,  2268,  2269,     0,     0,    59,    60,
      24,    23,    29,    28,    82,    83,    47,    15,    73,    53,
     116,   115,   117,    35,    31,    67,    20,    22,    32,    36,
      55,    48,    94,    54,    18,    52,    77,    56,    80,    42,
       9,    10,    43,    71,    11,    44,    72,    12,    45,    13,
      61,    84,    27,    57,    81,    58,     3,    38,    69,    65,
       8,    49,    50,    51,    74,    75,    76,    99,    79,   111,
      34,   108,    88,    89,   105,    90,   106,     6,    91,    46,
      14,   102,   101,   103,    68,    39,    70,   100,    21,   104,
      16,    17,   107,    78,    97,    93,   112,   110,   118,    95,
      62,     4,     5,    85,    19,    41,     7,    26,    25,    40,
      33,   114,    30,  1312,    87,    98,    86,    92,    66,    96,
     113,    64,   109,  1411,  1398,  1447,  1410,  1423,     0,  1413,
    2702,  2703,    37,  1424,   120,   121,   126,  2371,  2423,  2424,
    2425,  2505,  2456,  2457,  2450,  2466,  2476,  2465,  2469,  2477,
    2464,  2483,     0,   123,   125,   127,   130,   124,   119,   122,
     129,   134,   128,   133,   131,   132,   135,   136,   137,  2704,
    1638,  2701,    63,  2441,  2440,     0,  2505,     0,  2734,  1976,
    1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,
    1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,  1996,
    1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,  2006,
    2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,  2015,  2016,
    2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,  2025,  2026,
    2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,  2035,  2036,
    2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,  2045,  2046,
    2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,  2055,  2056,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2065,  2066,
    2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,  2075,  2076,
    2077,  2078,  2079,  2080,  2081,  2082,  2083,  2084,  2085,  2086,
    2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,  2095,  2096,
    2097,  2098,  2099,  2100,  2101,  2102,  2103,  2104,  2105,  2106,
    2107,  2108,  2109,  2110,  2111,  2112,  2113,  2114,  2115,  2116,
    2117,  2118,  2119,  2120,  2121,  2122,  2123,  2124,  2125,  2126,
    2127,  2130,  2128,  2129,  2131,  2132,  2133,  2134,  2135,  2136,
    2137,  2138,  2139,  2140,  2141,  2142,  2143,  2144,  2145,  2146,
    2147,  2148,  2149,  2150,  2151,  2152,  2153,  2154,  2155,  2156,
    2157,  2158,  2159,  2160,  2161,  2162,  2163,  2164,  2165,  2166,
    2167,  2168,  2169,  2170,  2171,  2172,  2173,  2174,  2175,  2176,
    2177,  2178,  2179,  2180,  2181,  2182,  2183,  2184,  2185,  2186,
    2187,  2188,  2189,  2190,  2191,  2192,  2389,  2193,  2194,  2195,
    2196,  2197,  2198,  2199,  2200,  2201,  2202,  2203,  2204,  2205,
    2206,  2207,  2208,  2209,  2210,  2211,  2212,  2213,  2214,  2215,
    2216,  2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,  2225,
    2407,  1965,  1973,  1974,  1975,  2382,  2403,  2409,  2730,  2408,
    1972,  2556,     0,     0,  2650,  2651,  2652,  2653,  2654,  2655,
    2705,  2706,  2707,  2708,  2709,  2711,  2710,  2518,  2677,  2714,
    2517,  2715,  2521,  2716,  2717,  2718,  2719,  2678,  2720,  2520,
    2712,  2674,  2522,  2515,  2516,  2675,  2624,  2625,  1942,  2676,
    2673,  2713,  2410,  2672,  2526,  2525,  1388,  2729,  1941,  1389,
       0,  2528,  2656,  2657,  2658,  2659,  2661,  2660,  2662,  2292,
    2293,  2294,  2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,
    2303,  2687,  2304,  2305,  2306,  2700,  2307,  2308,  2688,  2309,
    2310,  2311,  2312,  2313,  2314,  2315,  2316,  2317,  2318,  2319,
    2320,  2321,  2322,  2323,  2324,  2325,  2326,  2327,  2328,  2329,
    2330,  2331,  2332,  2689,  2690,  2333,  2334,  2335,  2336,  2337,
    2338,  2339,  2340,  2341,  2342,  2343,  2344,  2345,  2346,  2347,
    2348,  2349,  2350,  2351,  2352,  2353,  2354,  2355,  2356,  2691,
    2357,  2358,  2692,  2359,  2360,  2361,  2693,  2362,  2363,  2364,
    2365,  2366,  2697,  2698,  2699,  2686,  2479,  2663,  2685,  2696,
    2694,  2695,  2489,  2485,  2493,  2488,     0,     0,     0,     0,
    2505,  1221,  1220,  1206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   564,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2379,     0,  1232,   360,   359,  1311,
    1292,   565,     0,  1209,   388,     0,     0,     0,     0,     0,
       0,     0,     0,   754,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   185,     0,     0,   412,   411,     0,
       0,     0,   956,   417,     0,     0,     0,     0,     0,   553,
    2388,  2383,  2393,     0,  2386,  2387,  2672,     0,  2821,  2128,
    2419,  2420,  2819,  2178,  1390,   263,   266,   267,   264,   265,
       0,  1063,  1064,  1066,     0,     0,  1076,   789,   790,     0,
     788,     0,   792,     0,     0,     0,   784,     0,     0,     0,
       0,     0,   791,   781,     0,   780,     0,     0,     0,   787,
       0,   782,     0,     0,  1210,     0,  2471,  2472,  2066,  1351,
     418,     0,     0,  1424,     0,  1329,  1330,  1312,  1319,  1331,
    1324,  1326,  1325,  1327,  1323,  1328,  1977,   895,  1991,   895,
    2056,   892,   893,   895,   895,   895,  2145,     0,     0,   867,
       0,   878,  1968,   895,  1969,  2730,   900,   473,   473,   473,
       0,   899,   904,   473,  1203,  1241,  1946,  1437,     0,  1991,
    2056,   868,  1202,  2193,  1343,     0,     0,     0,  1080,     0,
    1081,     0,  2160,  1214,   247,  2670,  2169,  2256,  2193,  2671,
     246,   241,   242,  2665,  2666,  2668,   215,  2669,  2667,  2664,
    1981,     0,     0,   899,     0,  1211,  1212,   851,  1444,  1442,
    1928,     0,     0,  1999,     0,  2011,  2092,   238,  2156,  2161,
    2169,  2256,  2193,  2223,   194,   204,   199,     0,   256,  2169,
    2256,  2193,     0,  1232,     0,  1414,  1530,  1937,     0,     0,
    2480,  1205,  1204,  1313,     0,  1316,     0,  1492,  2141,  1418,
    1420,  1318,  1411,     0,     0,  2370,  1307,  1441,  1441,     0,
    1441,     0,  1403,  1411,  1406,  1410,     0,     0,     0,     0,
    1222,     0,  2448,  2476,  2455,  2511,  2452,     0,     0,  2501,
    2497,  2494,  2502,  2503,  2496,  2484,  1627,  1628,  1629,  1626,
    1639,  1625,     0,  2429,  1630,  2468,  2435,     0,  2443,  2442,
    2747,  2748,  2558,  2381,  2400,     0,     0,     0,     0,     0,
       0,     0,  2527,  2529,  2531,  2491,  2490,  2486,     0,     0,
       0,     0,  2616,  2617,  2615,     0,  2612,  2614,     0,  2511,
       0,  2681,  2675,  2684,     0,  1947,  2676,  2673,  2672,     0,
     799,     0,   141,   944,     0,     0,     0,     0,  1941,     0,
       0,     0,     0,     0,     0,  2065,     0,     0,     0,  1840,
    2003,  2051,  1850,  1848,  1849,  1842,  1843,  1844,  1845,  1846,
    1847,     0,  1061,  1841,     0,   163,   141,     0,     0,  2065,
       0,     0,     0,     0,     0,  2065,     0,     0,     0,     0,
       0,   163,  2095,   141,  2065,     0,     0,     0,  1226,     0,
       0,     0,  1228,  1231,  1207,  1295,     0,  1937,     0,     0,
     830,   820,     0,   831,   821,   826,     0,   833,     0,     0,
     823,     0,     0,     0,   834,     0,   822,   824,   836,   825,
     832,     0,     0,   827,   828,     0,     0,  1218,   473,   366,
       0,     0,     0,     0,     0,   141,  1282,     0,  2065,   141,
       0,     0,   416,   415,   141,   414,   413,  2003,  2051,     0,
     983,   141,  2065,     0,   187,   635,   568,     0,     0,   713,
    2095,   141,     0,     0,     0,     0,     0,     0,   959,     0,
       0,   552,   565,     0,  2392,  2398,     0,  2390,  2559,  2822,
    2820,  2514,     0,  1067,   239,   240,  1065,  2065,     0,   334,
       0,     0,  2065,  1269,   786,     0,   785,  2065,     0,  2065,
    1966,   178,     0,   783,  2003,  2051,  2065,     0,     0,  2065,
     170,  2065,     0,  2065,   334,  2065,   569,     0,  2065,     0,
    2065,  2095,   172,     0,  2065,   334,   797,     0,     0,  2752,
    2756,     0,  2754,  2749,  2470,  2524,  2523,  2422,     0,  2833,
       0,  1390,  1321,  1336,     0,  1332,  1339,  1335,  1424,   895,
     894,     0,   895,     0,  2842,   895,     0,   895,     0,  2842,
     895,     0,     0,     0,   895,  1970,  1971,     0,     0,  2841,
    2839,  2840,   869,   879,     0,   901,     0,     0,   908,   907,
     906,     0,     0,     0,   909,  1534,  1366,     0,   876,     0,
     874,     0,  1200,  1217,     0,     0,     0,     0,   959,  1083,
    1083,  1083,  1213,   245,   243,     0,     0,     0,     0,     0,
       0,  1219,     0,     0,     0,     0,  2736,  1953,  1851,  2735,
       0,  2227,  2228,  2229,  1909,     0,  2677,  2230,  2231,  2272,
    1759,  1746,  1755,  1760,  1747,  1749,  1756,  2232,  2233,  2035,
    2234,  2235,  1960,  2236,  2237,  1582,  2239,  2240,  2241,  1751,
    1753,  2242,  2243,     0,  1961,  2245,  2246,  2114,  2248,  2249,
    2251,  2252,  1757,  2254,  2255,  2256,  2257,  2258,  2259,  1959,
       0,  1758,  2260,  2262,  2263,  2264,  2265,  2266,  2267,  2268,
    2269,     0,     0,  1934,     0,  1728,     0,  1574,  1575,  1597,
    1598,  1576,  1603,  1604,  1616,  1577,     0,  1933,  1641,  1808,
    1727,  1742,  1733,     0,  1726,  1722,  1427,  1927,  1929,     0,
    1723,  1949,  1910,  1963,  1962,  2730,  1918,  1952,  1950,  1951,
       0,     0,     0,   207,     0,     0,  2605,   258,     0,   259,
    1935,  2169,   195,   237,   209,   236,   210,   208,     0,  2001,
     196,     0,     0,   197,     0,     0,     0,     0,     0,     0,
       0,   252,  1208,     0,  1532,  1531,     0,     0,  1916,  1938,
     806,     0,  1305,  1306,  1304,     0,  1301,  1303,  1315,  1312,
    1923,  1922,  1924,     0,  1419,     0,     0,     0,  1401,  1400,
    1318,  1439,  1440,     0,     0,     0,     0,     0,     0,     0,
       0,  1482,  1455,  1456,  1458,  1479,  1483,  1491,     0,  1407,
       0,     0,  1536,     0,  1493,  2369,  2511,  2512,     0,  2506,
       0,  2505,  2505,  2499,  2498,  2495,     0,     0,     0,     0,
       0,     0,     0,     0,  2426,   547,  2428,   544,     0,     0,
    2402,     0,  2406,  2404,     0,  2551,  2554,     0,  2552,  2553,
    2555,     0,  2560,  2561,     0,     0,     0,  2743,     0,     0,
    2542,  2530,  2537,  2539,  2541,  2540,  2549,  2545,  2548,  2550,
    2492,  2505,  2623,     0,  2618,  2621,     0,  2613,     0,     0,
       0,  1948,     0,     0,     0,     0,   800,     0,     0,     0,
       0,     0,     0,   140,  1267,   249,  1265,     0,     0,     0,
       0,     0,     0,     0,  1274,     0,     0,   176,   177,   580,
     565,     0,  2065,     0,     0,     0,     0,  1023,  1030,     0,
       0,     0,     0,     0,     0,     0,  1024,  1022,  1025,   251,
    1034,  1047,  1050,     0,   934,     0,     0,     0,     0,     0,
    1132,     0,     0,  1132,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   272,   284,   329,     0,
       0,  2065,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   145,     0,     0,     0,     0,     0,     0,   531,   543,
       0,     0,     0,     0,     0,   540,     0,   141,   276,   524,
     528,     0,     0,     0,   644,   643,  1272,  1271,     0,     0,
       0,  1132,     0,   268,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   352,
     353,     0,     0,     0,   145,     0,     0,     0,     0,   278,
       0,  2436,     0,  1227,  1224,  1225,     0,  1230,     0,  1291,
       0,     0,     0,     0,   838,     0,   835,     0,     0,   829,
    2003,  2051,     0,     0,     0,     0,     0,     0,   391,   365,
       0,     0,   710,     0,     0,  1585,  1614,  1592,  1614,  1614,
    1581,  1581,  1594,  1583,  1621,     0,  1614,  1581,  1586,     0,
    1584,  1624,  1624,  1609,     0,  1566,  1567,  1568,  1569,  1595,
    1596,  1570,  1601,  1602,  1571,  1638,  2682,  1581,  2683,  2680,
    2679,     0,     0,   721,     0,  1244,  1281,     0,     0,     0,
     574,     0,  2065,     0,   143,   755,     0,   711,   417,     0,
     143,     0,     0,   181,     0,   639,     0,     0,     0,     0,
       0,     0,   659,   658,     0,     0,     0,   712,     0,   143,
       0,   527,  2065,     0,   473,   473,     0,     0,   958,   961,
       0,     0,     0,  2396,  2391,  2394,     0,  2384,  2398,  1393,
    1395,  1394,     0,  1392,     0,   334,   332,   333,   708,  1075,
       0,     0,     0,     0,   334,     0,     0,  2065,   334,  2065,
       0,  2065,     0,     0,   334,   334,     0,     0,     0,     0,
     640,     0,   796,   794,   793,   795,     0,     0,     0,     0,
       0,  2065,   334,     0,     0,   777,  2750,     0,     0,  2753,
       0,  2473,  1861,     0,  2836,  1348,  2837,     0,     0,  1424,
       0,   226,   227,   225,  1337,   228,  1338,  1334,  1320,     0,
     887,     0,  2842,  2843,   872,     0,   882,     0,  2842,   870,
       0,   883,   880,   881,     0,     0,     0,  2838,  2721,  2727,
     886,     0,     0,   474,   476,     0,     0,  2021,  2034,     0,
    2057,  2083,  2084,  2161,  2165,     0,  2188,  2197,     0,   910,
     939,   905,     0,     0,  1376,   877,   875,  1201,  1341,  1867,
       0,  1424,     0,     0,  1082,  1079,  1078,  1077,   244,   216,
       0,     0,     0,   941,  2160,  1216,   850,   565,     0,     0,
    1731,  1732,  1613,  1600,  1908,     0,     0,  1608,  1607,     0,
       0,     0,     0,     0,  1590,  1589,  1588,  1730,  1875,     0,
    1587,     0,     0,     0,     0,  1614,  1614,  1612,  1661,     0,
    1591,     0,     0,  1888,     0,  1894,     0,     0,     0,  1620,
       0,  1618,     0,     0,  1697,     0,     0,     0,     0,     0,
       0,     0,     0,  1645,  1646,  2678,  1728,  1861,     0,  1729,
    1956,     0,     0,  1606,     0,  1638,  1851,     0,     0,     0,
       0,  1921,     0,  1859,     0,     0,  1675,  1857,     0,  1677,
       0,     0,     0,  1850,  1848,  1849,  1842,  1843,  1844,  1845,
    1846,  1847,  1855,  1658,     0,  1932,     0,  1810,     0,  1657,
       0,  1495,  1426,     0,     0,  1954,  1911,     0,  2728,  2731,
    1724,  2602,  2601,  2600,  2599,  2570,     0,  2564,  2565,     0,
    2603,  2604,   260,   261,   257,     0,     0,   212,   211,     0,
     234,   235,   206,   233,     0,   229,   230,   214,  1799,  1798,
     213,   205,   202,   200,   217,   219,   220,   203,   201,   255,
     253,     0,     0,     0,  1913,  1912,  1944,  1917,     0,     0,
     334,  2505,  1299,     0,  1296,  1926,     0,  1421,     0,  1939,
       0,  1308,  1417,  1416,  1448,  1449,   976,  1415,  1473,  1474,
    1469,     0,     0,     0,  1488,  1486,  1465,  1459,  1464,  1462,
       0,  1466,  1641,  1481,  1405,  1453,  1454,  1457,  1404,     0,
    1484,     0,  1376,  1482,  1458,  1363,     0,     0,  1537,     0,
       0,  2513,  2511,  2451,  1566,  2505,  2444,  2505,  2500,  2432,
    1632,  1633,  1634,  1635,  1636,  1637,  2433,     0,  2430,  1631,
    2431,   545,   546,     0,     0,     0,  2399,     0,  2380,  2405,
    2536,  2645,  2568,     0,  2569,     0,     0,  2533,     0,  2543,
    2546,  2544,  2547,     0,  1566,  2724,  2619,  2724,  1566,   998,
    1000,     0,   999,     0,  1002,     0,  1011,     0,     0,   997,
    1016,     0,  1005,  1003,     0,     0,     0,     0,     0,     0,
     801,     0,     0,     0,     0,     0,     0,  2188,   248,  1263,
       0,     0,     0,     0,   943,   942,     0,     0,   963,     0,
       0,     0,  1277,   462,     0,   331,     0,     0,     0,     0,
       0,     0,     0,     0,   706,   703,     0,     0,   702,     0,
     578,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   614,
       0,  1132,     0,   647,     0,  1032,     0,  1031,     0,     0,
       0,  1033,  1028,  1029,  2161,  2169,  2193,   250,  1049,     0,
    1048,  1046,   986,     0,   987,     0,     0,     0,     0,     0,
    2044,   286,   299,     0,  1131,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   320,     0,   323,   322,
       0,     0,     0,     0,     0,   327,     0,     0,     0,   326,
       0,     0,     0,     0,     0,  1132,     0,   280,     0,     0,
       0,     0,     0,     0,  1062,     0,     0,   166,     0,   162,
     165,     0,     0,     0,     0,   530,   542,     0,   534,   535,
     532,   536,   537,     0,     0,     0,     0,     0,     0,   529,
       0,     0,   637,   636,   642,     0,     0,     0,     0,     0,
       0,     0,     0,  1085,  1084,     0,     0,     0,     0,     0,
       0,   745,     0,     0,     0,     0,     0,     0,     0,   169,
     650,   651,     0,   652,     0,   167,   168,     0,     0,     0,
       0,     0,     0,     0,   224,  1223,  1229,  1294,  1945,  1293,
       0,     0,     0,   837,     0,     0,     0,     0,     0,     0,
       0,   839,   840,   841,   842,     0,     0,     0,     0,     0,
     368,   369,   141,   367,     0,   734,  2679,   709,     0,  1566,
       0,  1562,  1558,  1627,  1626,  1625,     0,  1572,  1581,  1578,
     722,     0,   724,   727,     0,  1242,   435,     0,     0,   571,
     614,     0,   420,   174,     0,     0,     0,     0,   139,   185,
     187,   418,     0,   186,   188,   190,   191,   192,   189,   193,
     634,   638,     0,   567,     0,     0,     0,     0,     0,   660,
     664,   663,   667,   665,     0,   661,     0,     0,  1554,     0,
     161,     0,   523,   526,     0,  2377,     0,   420,   504,   345,
       0,   473,     0,     0,   960,     0,     0,     0,     0,     0,
    2397,     0,     0,     0,     0,  1391,     0,  1053,     0,  1270,
    2065,   334,     0,  1051,   179,  1967,     0,   778,     0,     0,
       0,     0,     0,  1055,   774,   171,     0,   334,   334,   570,
       0,   334,   173,     0,     0,     0,   562,   334,   798,  2751,
    2757,  2755,  1350,     0,  2834,  2835,   473,  1395,  1322,  1333,
     884,   891,   873,   890,   889,   871,   888,   885,  2535,     0,
       0,  2726,     0,   902,     0,   472,     0,     0,     0,   916,
     917,     0,     0,   915,   932,   918,     0,   920,   912,   911,
     921,   922,     0,     0,   941,     0,  1373,     0,  1371,     0,
    1535,  1375,  1364,  1342,     0,  1340,  1345,  1347,  1346,  1344,
       0,   517,     0,     0,   899,     0,     0,   334,  1215,     0,
     852,   853,   859,     0,     0,     0,     0,     0,   860,   856,
     857,   858,   861,   862,   863,     0,     0,     0,  1871,     0,
    1872,     0,     0,     0,  1907,  1903,     0,     0,     0,     0,
       0,     0,  1879,  1880,  1881,  1878,  1882,  1877,     0,     0,
    1883,  1876,     0,     0,     0,     0,     0,  1611,  1610,     0,
       0,     0,     0,     0,     0,     0,  1700,  1733,     0,     0,
    1835,     0,  1861,  1893,     0,     0,  1622,     0,     0,     0,
       0,     0,     0,     0,  1861,  1899,     0,     0,     0,     0,
    1797,     0,  1794,     0,     0,     0,     0,  1918,     0,     0,
       0,     0,  1957,  1642,  1659,  1931,     0,  1920,     0,     0,
    1643,  1666,     0,  1900,  1693,     0,  1698,  1681,     0,  1674,
       0,  1679,  1683,  1662,  1921,  1860,     0,  1858,     0,     0,
    1660,     0,  1655,  1653,  1654,  1647,  1648,  1649,  1650,  1651,
    1652,  1656,  1839,  1837,  1838,     0,     0,     0,  1818,     0,
       0,  1678,  2059,  2092,     0,  1438,  1438,  1438,  1425,  1436,
       0,  1549,  1930,     0,     0,     0,     0,  1734,     0,  1865,
    1447,  1863,  1947,  2733,  2732,  1919,     0,     0,     0,  1936,
       0,     0,  1638,     0,   254,  1533,  1914,     0,   804,   805,
     803,  1566,  1318,  1302,  1298,  1297,  1925,  1317,     0,  1424,
       0,   974,   975,     0,   979,     0,     0,  1467,  1489,     0,
    1480,     0,  1471,  1472,  1463,  1490,  1485,  1409,  1408,     0,
    1552,     0,     0,  1360,  1353,  1538,     0,  1495,  1378,  1380,
    1381,     0,  1918,  2449,  2507,  2454,  2475,  2445,  2478,  1640,
    2427,  2467,     0,  2401,  2571,  2572,     0,  2562,  2563,  2532,
    2538,  2609,     0,  2725,     0,     0,  1001,     0,  1581,  1012,
       0,   996,     0,   995,  1581,     0,  1013,     0,  1581,     0,
       0,     0,  1160,  1087,  1136,   802,  1161,  1088,  1137,  1162,
    1089,  1264,     0,  1266,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   685,  2065,
     334,  1275,  1163,     0,  1090,   330,  1276,  1138,  1280,   705,
     704,     0,     0,  1139,     0,   579,     0,     0,   584,   585,
     586,     0,     0,     0,   587,     0,  2003,  2051,     0,   592,
     599,   604,   594,     0,   605,   600,     0,     0,     0,     0,
       0,     0,   611,   613,     0,     0,     0,     0,     0,     0,
    1026,  1027,  1164,  1093,     0,  1140,   985,     0,  1094,   175,
       0,     0,   273,   287,   620,   685,  1134,   306,   319,   314,
     315,   313,  2065,   334,  2065,   334,     0,     0,     0,     0,
     316,   311,   312,   308,   321,  1980,  2036,  2170,     0,   624,
     626,     0,   631,   324,  1108,   341,   340,   339,     0,   328,
       0,   346,   349,   325,   304,   307,   305,   301,   285,     0,
       0,     0,     0,     0,     0,     0,  1943,     0,     0,  1057,
       0,     0,     0,   164,  1122,     0,     0,   150,     0,     0,
       0,     0,   144,   154,     0,  1170,  1098,     0,     0,   277,
     525,   533,   538,  1102,   541,  1150,   539,  1176,  1099,     0,
    1132,     0,   269,     0,  1100,     0,  1144,  1172,  1124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1283,     0,
       0,     0,     0,     0,   334,     0,     0,     0,  1134,  2065,
     334,  1171,     0,  1129,  1158,     0,   354,     0,  1123,     0,
       0,   279,  1104,  1152,     0,     0,   222,   221,   223,     0,
       0,     0,     0,     0,     0,     0,     0,   844,   813,   843,
       0,     0,     0,   807,   390,   363,   364,   366,   373,   733,
       0,     0,     0,  1563,  1559,     0,     0,     0,     0,     0,
       0,  1579,   723,     0,     0,     0,     0,  1262,  1262,  1262,
    1262,  1262,  1262,  1262,  1243,  1273,     0,   141,     0,     0,
       0,   573,   613,   620,     0,     0,     0,   419,   423,   427,
     428,   429,     0,     0,     0,     0,   155,   142,     0,   763,
       0,   473,     0,   187,   180,     0,     0,     0,   345,   720,
     718,   717,   719,     0,     0,     0,   738,   716,     0,  1553,
    1555,     0,     0,     0,     0,     0,   422,     0,   476,     0,
       0,   508,     0,     0,     0,   345,     0,     0,   990,     0,
    1008,   991,     0,     0,     0,  1037,  1042,  1038,  1018,     0,
     550,  2395,  2389,  1396,  1397,     0,   334,     0,     0,   615,
     334,   334,     0,   334,     0,   334,   334,     0,  1198,   641,
       0,   693,     0,     0,   334,   776,  1862,     0,  2534,  2722,
     903,   475,     0,     0,     0,     0,   914,     0,   548,   919,
       0,   931,   926,   928,     0,   935,  1374,  1367,  1369,  1368,
       0,     0,  1365,  1868,   775,     0,   522,     0,     0,   334,
       0,   936,     0,   854,   855,     0,     0,   864,     0,     0,
    1443,  1869,  1870,     0,     0,     0,     0,  1904,     0,     0,
    1772,     0,  1748,  1750,  1580,  1762,     0,  1593,  1773,  1774,
    1752,  1754,     0,  1852,     0,     0,  1763,  1702,  1703,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1715,  1714,  1764,  1834,     0,     0,  1891,  1892,
    1765,  1623,  1624,  1624,     0,     0,  1898,     0,     0,     0,
    1770,  1775,     0,     0,     0,     0,  1781,     0,  1802,     0,
       0,     0,  1725,  1862,  1615,  1616,     0,     0,     0,     0,
       0,     0,     0,     0,  1699,  1682,  1676,     0,  1680,  1684,
       0,     0,     0,     0,  1668,  1694,  1664,     0,     0,  1670,
       0,  1695,     0,     0,     0,  1741,  1438,  1438,  1438,  1438,
    1435,     0,     0,     0,     0,  2158,     0,  1516,  1494,  1496,
    1503,  1516,  1521,  1743,  1547,  1744,     0,  1937,     0,  1476,
    1447,  1447,  1447,  1740,     0,     0,     0,  1446,  2584,  2586,
    2587,  2588,  2589,  2590,  2592,  2593,  2595,  2596,  2597,  2585,
    2591,  2594,  2598,  2575,  2576,     0,  2566,  2567,   198,     0,
     231,   218,     0,  2609,  1300,  1940,     0,  1450,     0,  1853,
     979,   977,   978,  1452,     0,     0,  1487,  1460,  1362,     0,
    1360,  1355,     0,  1356,  1918,     0,  1352,  1385,     0,     0,
    1552,     0,  1384,     0,  2509,  2437,     0,     0,  2608,  2611,
    2622,  2620,  2447,     0,  1581,   993,   994,     0,  1017,     0,
    1159,  1086,  1135,  1262,   946,   947,     0,   945,     0,     0,
       0,   461,   962,     0,     0,     0,   685,     0,     0,   465,
       0,  1278,     0,  1177,  1121,   581,   582,     0,   593,     0,
     602,   601,     0,     0,   589,     0,     0,     0,     0,   588,
     607,   554,   608,   610,     0,     0,   609,   612,   617,  1132,
       0,   648,  1110,     0,  1156,  1020,     0,   988,     0,     0,
       0,     0,   435,   300,     0,     0,     0,   288,   298,     0,
       0,   303,     0,   296,   317,   309,   318,   310,   628,   629,
     627,   623,     0,   630,   632,     0,   343,     0,     0,     0,
    1166,     0,  1132,     0,   281,  1106,     0,  1154,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1167,
    1141,     0,     0,   147,   146,     0,   153,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   355,   336,     0,   741,     0,     0,     0,   357,
       0,     0,     0,     0,  1165,  1095,   808,     0,     0,   809,
     817,     0,     0,   810,     0,     0,   819,     0,     0,   362,
     370,   735,     0,  2114,  1842,  1843,   731,   736,   728,   730,
     729,   732,   685,     0,     0,     0,  1564,     0,  2823,  2831,
    2830,     0,  1638,   725,   726,     0,  1262,  1261,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   447,
       0,     0,   441,     0,     0,  1042,   434,   437,   438,     0,
       0,   574,   577,   575,   576,   606,     0,   454,     0,     0,
     157,     0,     0,   158,   156,     0,     0,   345,     0,   183,
     418,     0,     0,   566,   666,   669,   662,     0,   737,   739,
     714,     0,   620,     0,     0,  1351,   517,     0,   504,   500,
     502,   501,   503,     0,   510,   344,     0,   517,   510,     0,
     963,   989,     0,     0,     0,  1035,  1039,  1036,     0,     0,
    1004,     0,  1019,   982,  1193,  1194,  1191,  1192,     0,     0,
    2412,  1387,  2421,  1054,     0,   334,  1052,   779,     0,   770,
       0,   772,  1056,   334,   334,   653,     0,   563,     0,     0,
       0,     0,   913,   933,     0,   929,     0,     0,   896,   938,
    1372,  1370,   515,     0,   941,     0,   897,   940,     0,     0,
       0,     0,     0,  1873,  1599,     0,  1906,  1902,     0,  1745,
    1874,     0,  1886,  1885,  1701,  1887,     0,  1720,     0,     0,
    1712,  1710,  1711,  1704,  1705,  1706,  1707,  1708,  1709,  1713,
    1896,  1895,  1889,  1890,  1619,  1617,     0,  1767,  1768,  1769,
    1897,  1776,     0,  1994,  1803,  1780,  1796,  1795,     0,     0,
       0,  1783,     0,     0,  1792,     0,  1836,  1605,  1638,  1644,
       0,     0,  1667,  1901,  1685,     0,     0,     0,  1663,     0,
       0,     0,     0,  1672,  1852,     0,     0,     0,     0,  1821,
    1816,  1817,     0,     0,     0,     0,  1429,  1428,  1434,  1516,
    1521,     0,  1411,     0,  1503,     0,  1515,  1501,  1514,     0,
       0,  1527,  1525,     0,  1527,     0,  1527,     0,  1498,     0,
    1517,  1499,  1514,  1546,  1539,     0,  1938,  1548,     0,  1478,
       0,     0,     0,     0,  1866,     0,  1864,  1735,     0,     0,
       0,  1915,  2607,  1422,     0,  1451,  1468,  1461,     0,  1550,
    1361,     0,     0,  1358,     0,     0,     0,  1379,  1360,  1382,
    2453,     0,  2508,  2573,  2574,  1014,     0,     0,  1006,     0,
     952,   953,   951,   954,     0,     0,     0,   685,     0,     0,
     481,     0,   970,   970,     0,     0,   467,   513,  1042,   688,
       0,     0,     0,   686,   334,  1091,     0,   603,     0,     0,
     598,   596,   595,   597,   555,  1175,  1092,     0,     0,     0,
       0,  1021,     0,     0,  1109,     0,   432,     0,   293,  1133,
       0,     0,     0,   292,     0,   334,   334,   625,   342,   347,
     348,   351,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   764,   747,     0,     0,   765,   766,
       0,     0,     0,  1059,  1060,  1058,   151,   148,   149,   152,
    1119,  1103,  1151,     0,     0,  1101,     0,  1145,  1116,  1112,
       0,     0,     0,     0,     0,  1174,  1128,  1149,  1173,  1126,
    1147,  1125,  1146,  1127,  1148,  1120,     0,  1557,   744,     0,
       0,     0,   334,   334,   655,  1105,  1153,     0,   811,     0,
       0,   812,   814,   393,     0,   396,   403,   374,   379,  1282,
       0,  1282,     0,   376,   380,  1282,   375,  1282,   372,   707,
       0,     0,     0,  1560,     0,  2505,     0,     0,     0,     0,
       0,  1565,  1573,   684,     0,  1253,  1252,  1251,  1255,  1254,
    1257,  1256,  1248,  1247,  1260,  1259,  1246,  1245,  1250,  1249,
       0,   439,     0,   445,   449,   450,   448,   440,  1042,   473,
     512,     0,     0,   697,     0,   572,   420,   451,     0,   424,
     160,   159,     0,     0,     0,   187,     0,     0,   671,   675,
     715,     0,  1556,   649,   345,     0,   420,   517,  2378,     0,
     425,   430,   431,     0,   508,     0,   504,     0,     0,   514,
    1240,   518,   519,     0,     0,   992,  1009,  1010,     0,     0,
    1042,  1041,     0,   557,     0,  2385,   334,   616,   334,   334,
    1199,   694,     0,   925,   924,   923,   549,     0,   927,   516,
     334,     0,     0,     0,     0,     0,   866,   845,   865,  1905,
    1761,  1771,  1884,     0,     0,  1721,     0,     0,  1766,  2261,
       0,     0,     0,     0,  1800,  1801,  1782,     0,  2105,  1787,
       0,     0,     0,  1958,  1691,  1689,  1686,     0,  1687,     0,
       0,  1669,  1665,     0,  1671,  1696,  1807,     0,  1823,  1820,
    1433,  1432,  1431,  1430,  1502,  1500,     0,  1505,  1512,     0,
    1497,     0,  1526,  1522,     0,  1523,     0,     0,  1524,     0,
       0,  1512,     0,  1447,     0,     0,  1812,  1738,  1739,  1736,
    1447,  1955,  2577,     0,  2580,  2578,  2579,  2583,  1638,     0,
       0,  1354,  1357,  1359,     0,  1386,  1377,  2510,  1007,  1015,
    1268,     0,     0,     0,   463,     0,  1042,     0,     0,     0,
     973,   973,     0,  1042,   512,   690,   689,   692,   687,   691,
    1279,     0,   590,   591,  1111,     0,  1157,  1117,     0,  1376,
       0,   621,   289,   290,   291,   294,   336,   302,   295,     0,
       0,     0,  1107,     0,  1155,  1114,  1168,  1096,  1142,     0,
       0,   753,     0,     0,     0,     0,  1169,  1097,  1143,     0,
    1376,     0,     0,     0,     0,  1288,     0,   335,   743,   742,
     336,   356,  1130,     0,   815,   816,   394,   141,     0,   371,
       0,   401,     0,   399,   398,   400,     0,   387,     0,     0,
       0,     0,     0,     0,  1561,     0,  1073,  1073,  2824,     0,
    2825,  2826,  2827,  2828,  2829,     0,   685,  1258,     0,     0,
     436,   512,   480,     0,   442,     0,     0,     0,     0,     0,
       0,     0,   620,     0,     0,     0,   182,   420,   620,   670,
       0,     0,     0,   740,     0,   422,     0,  1349,   421,     0,
       0,   510,     0,   508,     0,   505,     0,   509,     0,  1233,
       0,     0,  1040,     0,  1044,     0,  1003,   980,  1549,     0,
     561,  2411,  2415,  1074,   771,   773,   654,   930,   937,   334,
     846,   847,   848,   849,  1716,     0,     0,     0,     0,  1777,
       0,  1778,  1805,  1804,  1784,  1788,     0,  1785,  1786,  1688,
    1692,  1690,  1673,  1809,     0,  1447,  1542,     0,  1545,  1504,
       0,     0,  1506,     0,     0,  1508,  1510,     0,     0,     0,
       0,     0,  1941,     0,  1475,  1477,     0,  1412,     0,  2582,
    2581,   232,  1854,  1551,  1383,   931,     0,   334,   970,   512,
     482,  2114,   483,   969,     0,   971,   976,   976,     0,   512,
     685,   583,     0,     0,   274,   619,     0,   338,   350,     0,
    1376,     0,     0,     0,   760,   748,     0,     0,   767,     0,
     270,  1113,     0,     0,     0,     0,     0,   334,   818,   373,
       0,   397,   406,     0,   404,   377,   382,     0,   386,   384,
     383,   378,   381,  1073,     0,  1070,  1069,  2832,   683,     0,
     471,   443,     0,   491,     0,     0,   698,     0,     0,     0,
     460,   459,   456,   455,   457,   458,   453,   452,   645,   757,
     345,  1240,   633,   672,   673,   668,     0,     0,     0,   504,
     500,   426,   435,   409,     0,   510,   506,   507,     0,     0,
       0,  1290,     0,   964,  1043,     0,     0,     0,   556,     0,
       0,   560,   551,     0,  2413,   898,  1717,     0,  1718,     0,
       0,     0,  1790,  1789,     0,  1826,  1547,     0,     0,  1541,
       0,  1513,  1529,     0,  1509,  1507,  1518,     0,  1520,  1735,
    1811,  1813,     0,  1737,   948,     0,   949,   973,   486,     0,
     972,   979,   979,   473,   685,   464,  1118,     0,   622,     0,
     297,     0,   282,  1115,     0,   751,     0,   762,   760,     0,
       0,     0,  1284,     0,  1285,  1286,  1289,   358,   361,   392,
     402,     0,   385,  1068,  1072,  1071,     0,     0,   444,   477,
     478,   479,     0,   446,   487,   488,     0,   695,     0,   700,
       0,     0,     0,     0,     0,  1234,     0,     0,  1240,   508,
     504,   433,   499,   407,     0,  1237,     0,   345,     0,  1042,
    1045,  1197,   559,   558,  2416,  2418,  2417,     0,  1719,  1793,
    1779,  1806,  1791,  1822,     0,     0,     0,  1540,  1543,     0,
    1511,     0,  1519,     0,     0,     0,   976,     0,   685,     0,
     967,   966,   480,   466,  1376,   337,     0,     0,     0,   758,
     761,   749,   762,   769,   768,  1376,     0,   405,     0,   470,
       0,     0,     0,   489,     0,   490,   511,     0,   699,     0,
     620,   756,     0,     0,   674,     0,  1235,   510,   508,  1238,
    1239,   510,   965,   981,  1196,  1195,  1424,  2414,  2226,     0,
    2199,     0,  1824,  1827,  1825,  1819,     0,  1528,  1814,  1815,
     334,   979,     0,   468,   484,   491,   275,  1376,     0,     0,
     750,   271,  1287,   675,   496,     0,   495,     0,   493,   492,
     696,   701,   646,   746,  1240,   678,   410,   510,  1549,  1179,
    1424,  1178,  1180,  1188,  1185,  1187,  1186,  1184,     0,  1831,
    1830,  1829,  1833,  1832,  1544,   950,   968,     0,   685,   283,
     752,   759,     0,   494,   498,   497,  1236,     0,   676,   679,
     682,   680,   681,   408,   955,     0,  1189,  1183,  1411,  1398,
       0,   485,   469,     0,   656,     0,  1181,  1424,  1828,     0,
     677,  1182,     0,   678,     0,   657
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4769, -4769,  4065, -4769, -1203,    72,  2558, -1082, -4769, -4769,
   -4769,  1034, -4769, -4769, -4769, -4769, -4769, -4769, -4769,  3227,
   -4769, -4769,  1735, -2618, -4769, -4769,   -38,  3207, -1613,   -49,
    2838,  1411, -4769, -1411, -4769, -4769,  -863,    44, -4769,  3217,
     383, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -1037,
    1888,  1231,  3236, -2645, -4769, -4769, -1734, -3340, -4769,   613,
   -4769, -4769,  1833, -4769, -4769, -4769,  1087,   535,  -416, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769,  -225, -4769, -4769,  -553,
     263,  -124, -2612,  -276, -4769, -4769,   481,  -278, -1619, -4769,
   -3674, -4769,    42, -4769, -4769, -4769,  -259, -1729,  1325, -4769,
    -980, -1406,  1653,  -614, -4769,  -137, -4769,  -671,  -554,  -546,
    -622,  -440, -3847, -4248, -3863, -3391,  1336, -4769, -3782,   294,
   -4769, -4769,   313,   327, -4769, -4769, -1809, -1745, -4769, -1088,
   -4769, -4769, -4769, -3106, -4769, -4769, -4769, -4769,   -77, -4769,
   -4769, -4769, -4769,   511, -4769, -4769, -4769, -4769, -4769, -4769,
   -2412,  1794,  1795, -4769, -4769, -3319, -4769, -1218, -4769,   654,
   -3100,  1252, -4769, -4769, -4769,  2515, -4769, -4769, -4769, -4769,
   -4769, -4769, -1907, -4769, -4769,   347, -4769,  1809,  1065, -4769,
   -4769, -4769,  -659,  -727,  -714, -4769, -3088, -4769, -4769, -4769,
   -4769,  -214, -4769, -4769, -4769, -4769, -4769, -4769, -1251, -4769,
    1120, -3274, -4769, -4769,  1135, -4769, -4769, -4769, -4769, -4769,
    -605,  -144,  2544, -4769,  -486,  -579, -4769, -4769, -4769,  -139,
   -4769, -4769, -4769, -4769, -4769, -4769, -1353, 11341, -1871, -4769,
   -4769, -4769, -4769, -2586, -4769, -4769, -4769, -1987, -4769,  4342,
      14,   103,   352, -4769,  -195,   -99,  3079, -1408, -2811,   454,
    -299, -4769, -2068, -4769, -4769, -4769, -2705, -4769, -4769, -4769,
   -4769, -3611,   356, -4769,  3089, -4769,   507, -4769, -4477, -4068,
   -4364, -3918, -3624, -4769, -4769, -1347, -4769, -4769, -4769, -1735,
    2113, -2217, -4769, -2354,   512,  1416, -1258, -2927, -3872, -1023,
   -3392, -4769, -3807,  -401, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -1360,  -873, -4769, -4769,  3620, -4769, -3861, -4769, -4769,
   -4769, -4769,  1209, -4769, -4769, -1687,  1208, -4769, -4769, -4769,
   -4769, -4769,  -582,  -672, -4769, -4769, -4769,   358, -4769, -4769,
   -4769, -4769,  2291, -1214, -1022,  3470,   360, -4099, -4769, -4769,
   -4769, -4769, -3162, -4769, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -1882, -4769, -4769, -4769, -4769, -4769, -4769, -4769,  2233,
    2241,  -110,  -198, -4769, -4769, -1541, -4769,  -829, -4769,  2487,
   -4769, -4769, -4769, -4769,  1509,   364,   555,   -72, -4769, -4769,
     340, -3525,   -67, -4769, -4769, -4769, -4769, -2303,   -65, -4769,
     834, -4769, -4769, -2929, -4769,   370,     7,  3164,  1771,   -62,
     142,  -245,  -211,  -169,   -68,  3472,  2941, -4769, -4769, -4769,
    -196,  2153, -4769, -1097,  -343, -4769,  1519,  -936,  2221,  2925,
    2931, -4769,  1516, -4769, -4769,  1525, -4769, -4769, -4769,  -927,
    2231, -4769,  2930, -4769, -4769, -4769,  1510,  1520, -3513,   935,
   -3490, -3464,   424,   405, -1073,  -210,  -158,  3525,  2942,   946,
    -354, -4769, -4769,  -350, -4546,   877, -4769, -4363, -2501,   576,
   -2185, -1888, -4769, -4769, -1419, 10754, -4769, -4769, -4769, 13908,
   15768, -4769, -4769, 18215, 19946, -4769, -1310,   994, 20680,  7315,
   -1474, -1898, -1545, 19281, -2437,  2396, -2906, -4769, -3643, -2757,
   -4769, -4769, -4769,  -166,  1007,   134, -4769, -4769, -4769, -4769,
   -4769, -4769,  -458, -4769,  -457, -4769, -4769, -4769,  -449, -4768,
    2697, -4769,  -735, -4769, 20754,  1565, -4769, -1333, -2861, -2875,
   -3505, -2047, -4769, -4769, -4769, -4769, -4769, -4769, -4769, -3175,
   -3396,  -439,  1644, -4769, -4769,  1738, -4769, -4769, -4769, -1595,
   -1163, -2778,  1645, -2225, -4769, -1109, -4769,   899,  2372, -1063,
   12724, -1476, 17472,  -128, -2431, -1568, -1818, -4769,  4631, -4769,
    2809,  3553,  -925,  -143,  -938,  6479,  4730,  5419, -3250, -4769,
   -4769,   373, -4769, -4769, -4769,  4001,  1156, -4769,  3295, -4769,
    1880,  2622, -4769, -4769,  2245,  -967,   -27, -4769,  -424, -4769,
    -136, -4769, -4769, -4769,   171, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769, -4769, -4769,  2963, -4769, -4769, -1498, -4769, -4769,
   -4769, -4769, -4769,  4269,  -378, -4769,  3676,  -377, -4769, -4769,
   -4769, -4769, -4769, -4769, -4769, -4769, -4769,  2976,  2283, -4769,
    3467, -4769, -4769, -4769,   -33,  3195, -4769, -4769, -4769, -1216,
    -597,  3491,  3497,  2248, -4769, -4769, -4769, -4769, -4769, -4769,
   -4769, -4769,  2253, -4769, -4769,  1625, -2207,  2258, -4769, -4769,
     922, -4769, -4769,   451, -4769,   923, -4769,  3093, -4769, -4769,
   -4769,   959, -4769, -4769, -4769,  -584, 14899,   -69,   -54,   127,
    1048, -4769,  9281,  6417,  -109,  2997,   -48, 12424, 19077,    80,
   -4769,  4259,  2259,  1858, -1054, -4769,  2274,  2570,  6911, -4769,
   -1047,     5,  1838, -4769,    -2,  -674, -1196,  3289,  -745, -2009,
   -4769,  4678, -4769, -3610, -4769, -1051,  3680, -1233
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1754,  2703,  2579,  3426,  3427,   249,
     250,  1829,   251,   252,   253,   254,   255,   256,   257,  1770,
     258,   259,  1323,  1983,  2713,   260,  2448,  1085,  1086,  1087,
    2303,  2304,  2645,  2305,  2292,  1604,  2085,  1789,  1051,  1052,
    1756,  1790,   262,   263,  1598,  2284,   264,   265,   266,  1816,
    1817,  1764,  2028,  4367,  5000,  3259,  2559,  3463,  3260,  3261,
     267,  1879,  1880,   268,   269,  3377,  1920,  2672,  3929,  3930,
    4398,   885,  2669,  4687,  4688,  4384,  4385,  4694,  4883,  4884,
    2714,  1979,  3457,  4018,  3417,  4469,  3418,  4470,  3419,  4471,
    3405,  3976,  3977,  3978,  3420,  4447,  4916,  3421,  2463,  5028,
    2748,  2115,  2113,  4903,  4259,  4260,  5088,  5033,  5034,  5035,
    5168,  4476,  3461,  4024,  4479,  4724,  3158,  2003,  3536,   985,
    2750,   916,   986,  2715,   274,  2742,  1849,  1850,  2587,  3936,
    3519,   275,  1342,  3800,  4770,  4951,  4952,   276,   873,   277,
    1987,   278,   279,  2699,  3411,   280,  2480,  3175,   281,   282,
    3202,  3203,  3204,   283,   284,  3822,  4640,  1818,  3248,  3249,
    3250,  3251,  3843,   285,  1985,  1855,  2722,   286,   287,   288,
     289,   290,  2632,   291,   292,  2716,  1995,  2734,  2735,  4459,
    4740,  4925,  4742,  5207,  5208,  4716,  3779,  4273,   294,   295,
    4442,  4443,  5040,   296,  2478,   297,   298,   299,  1963,  2691,
    2692,  3937,  1922,  2674,  2675,  4007,  4008,   300,  3337,   301,
    4324,  4325,   917,  5043,  5007,  5101,   302,   303,  4328,  4329,
     304,   305,   306,   307,   308,   973,  1395,  1396,  1746,   309,
    2320,   310,  1296,  3368,   311,  1484,  2886,  4517,   312,  1009,
    1420,  1421,  2717,   314,  1020,  2864,  1022,  2128,  3521,  3522,
    4078,  2833,  1211,   315,   316,  2844,  2867,   317,  1757,  2454,
    2455,  4254,  2718,   918,  2009,  2753,  3153,  4942,  4261,  4620,
    4846,  3064,  3723,   319,   919,  1794,  2523,  2756,  3469,  2426,
    2427,  2428,  4039,  2429,  3471,  2430,  1740,  2431,  3476,  3477,
    3478,  4035,  4043,  4764,  4765,   320,  1792,  2521,   321,   322,
     323,  1826,  1231,   324,   941,   942,   325,  4895,   326,  1361,
     327,  1041,  2145,   328,   329,  2536,  3829,   330,   331,   332,
    5181,  5215,  5216,  5217,  4048,  5136,   333,  5183,  1462,   335,
     336,   337,   876,  1262,  1263,  1264,  2719,  4759,   339,   340,
    2695,  3404,  3958,   341,   342,  2449,  3143,   343,   344,   345,
     346,  1967,   347,   348,   349,   350,  1899,   351,  1635,  1636,
     352,   353,   880,  1105,  1639,  1647,   354,   988,  1414,  1415,
    1416,  2087,   355,  1466,  2855,   989,  1409,   990,  3083,  3732,
    3733,  3736,   991,  3080,   359,  2134,  2849,  2852,   992,  3087,
    3088,  3089,  3090,  3091,  3738,   993,  1011,  1352,  2764,   994,
    1555,   364,   365,   366,  1114,  1109,  1110,   368,  2261,  3018,
    1028,  1653,  1070,  1121,  3687,  2334,  2335,  2357,  2358,  1662,
    1663,  2347,  2349,  3066,  2350,  3074,  2340,  4209,  4586,  2353,
    2354,  1665,  1666,  1667,  2362,   369,  3021,  3668,  3669,  3670,
    4186,  4187,  4201,  4197,  4573,  4815,  3671,  1456,  1673,  3672,
    4806,  4807,  4969,  4204,  3679,  3730,  3448,  3449,  3450,  2432,
    2682,  1945,  1556,  1946,  2689,  1557,  2180,  1948,  1558,  1559,
    1560,  1951,  1561,  1562,  1563,  1564,  2163,  2223,  1565,  1566,
    2199,  1153,  1154,  2072,  2925,  1568,  1569,  1570,  3674,  1571,
    4144,  4541,  4530,  2951,  2952,  2300,  4140,  3614,  2257,  3008,
    4827,  4980,  4981,  3655,  4170,  4558,  4805,  5076,  5142,  5143,
    1572,  3005,  2252,  1233,  1573,  3939,  2254,  2945,  3030,  3031,
    2140,  2161,  2891,  2908,  2909,  2922,  3575,  2929,  2934,  3598,
    3599,  2946,  2974,  1574,  2894,  2895,  3558,  2165,  1575,  1628,
    1629,  2270,  2969,  1642,  1643,  1107,  1576,  1577,  1578,  2129,
    1096,  4811,   726,   709,  3275,  2315,  1266,  1025,  1579,  1580,
    1581,  1370,  1371,  1695,   671,   710,   711,  1191,   823,     2,
      75,   995,  3455,   373,   374,   921,   922,   923,  1344,  1345,
    2014,  2017,  1700,  2398,   675,   676,   727,  4495,  4771,  4954,
     979,   375,   376,   377,   378,  1696,  2394,  1155,    76,    84,
      77,  1156,   415,   416,  2375,   379,   840,   380,  1676,  1135,
    3744,   381,   382,   383,   384,   385,   976,   386,  1137,   387,
    1138,   388,   389,   390,   391,  1145,   392,  1678,  1679,  4242,
    1680,   393,   394,   713,   714,  1407,   395,   396,  1172,  1173,
    1439,  1440,  1706,  1721,  1722,  1723,   397,   683,   398,   399,
     400,  1712,  1713,   401,  2277,  2278,  2403,  2279,   402,  3104,
    3105,   403,  3703,  3704,  4595,  3705,   404,  2273,   405,   406,
    1099,  3749,   407,   836,   408,  1186,   715,   716,   717,  1193,
     826,  1056,   728,  1195,  3252,   828,   829,   719,   720,   721,
    2107,    78,  3112,  2108,  1583,   729,  1584,  2268,  1585,  1586,
    1587,  1588,  1589,  1729,   723,  1162,  1399,  1400,  3113,  1402,
      82,  1403,   412,  3951,  2075,  1441,  2093,  2094
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,  1113,  1354,  1132,  1133,  2084,   357,    79,   827,   409,
     367,   358,  1599,   360,  1062,   409,   362,  2044,   932,  2038,
    1674,  2034,  1122,  1854,  1013,   920,   915,  1668,  1319,  2462,
     410,  1741,  1098,  1831,  2317,  1380,   410,  1448,  1449,  1450,
    2112,  1621,  1923,  1454,  1013,  1392,  1417,  3028,   409,  1897,
    1884,  2679,  2834,   827,  3539,   987,  1170,  2687,  2524,  3076,
    1613,  2801,  2201,   824,  1694,  1095,  1034,   712,  1977,  3036,
    2532,  2152,  1021,  3121,  3123,  2073,   411,  1353,  1997,  2555,
    2647,  3373,   411,   972,  4042,  1377,  2688,   680,  2174,  2175,
    3416,  2739,  3434,   409,  3985,  3806,  4225,   367,  4003,   874,
    2025,  3056,  1965,   725,  2599,   712,  1970,  2190,   824,  2331,
    1063,  1974,  2890,   731,  3673,   411,  2541,  1724,  1980,  3334,
    3954,   827,   261,  1232,  1726,  4028,   924,   931,  1999,  1819,
    4262,  3940,  2613,  2614,  1174,  4157,   931,  3823,  3277,  3525,
    1354,  2382,  2384,  2385,  3940,  3838,  2317,  3840,  4296,   878,
    3682,   926,  2793,  4183,  1412,  1116,  1124,  3737,  4256,  1050,
     411,   409,  3680,  3681,   934,  4482,  1232,  4490,  4440,  1092,
    2328,  4474,  2517,  3673,  2609,   931,   824,  2440,  1084,  3622,
    2531,  1010,  4200,  2376,  2376,  1661,  2167,  2168,  1791,  3095,
    3753,  2754,  2743,  2074,  1664,  4621,  2099,   831,  1125,  1702,
    1703,  1010,  4122,  1848,  2069,  4230,  1059,  4198,  1715,  1863,
    3120,  1165,  2187,  3748,  1059,  1606,  1059,  4819,  1889,  4821,
     363,  2218,  4947,  1232,  2275,  3579,  4751,  2026,   411,  3111,
    1401,  1716,   418,  3115,  4468,   884,  3959,  3960,  3961,  3962,
    3963,  3964,   831,  2221,   825,  4481,    45,  1996,   418,    37,
      38,    39,    40,  1348,  1187,   414,    44,  4847,  2625,   418,
    2227,  2026,  2967,  3675,  5006,  2534,   418,  2534,    43,    37,
      38,    39,    40,    45,  3429,    43,    44,  1486,  1717,  2620,
      45,  2026,  2736,  1615,  4943,  2230,  4619,  3991,  1058,   825,
     418,   886, -1614, -1614, -1614, -1614,  1058,  4033,  1058, -1614,
    1767,   357,   875,  1437,    45,   367,   358,   363,   360,  1103,
     831,   362,   409,  1464,  3742,  2232,  2468,  -395,  1918,  2967,
    1437,  3526,  3675, -1948, -1948, -1948, -1948,  2962,  2086,  3528,
   -1948,  1437,  2470,   410,  3356,  2572,  2318,  4404,  1480,   130,
     131,   270,  4082,  3009,  2534,  4938,  -141,   409,  3493,  2534,
    3495,  5134, -1614,  4939,  1603,  -141, -1840,   825,  2076,  2465,
    -141,  1445,  2512, -1840, -1614, -1614, -1614, -1614,   410,  2534,
    5188, -1614,   271,  2383,  2590,  2534,  3537,  2607,  1961,   411,
   -2682, -2682, -2682, -2682,   837,  2711,   838, -2682,  1112,  3002,
    1161,   272,  2219,  1242, -1856, -2682,  3003,  2573,  1592,  1897,
    4103, -1856,  1768, -2103,  2456,   273, -2683, -2683, -2683, -2683,
    1912,  5074,   841, -2683,   411,  3020,  3387,   261,  1243,  2266,
    3184, -2683,  1452,  3743,  4123,   293, -2680, -2680, -2680, -2680,
     313,  2866,  2845, -2680,   318,  3992,   334,  5075,   338,  3169,
    2737, -2680,   356, -2679, -2679, -2679, -2679,  2513,   361,  1767,
   -2679,   372,  5228,  2045,   842,  1354,  1209,  4977, -2679,  2712,
    4628,  4624,  1189,  1133,  1632,  2471,  1633,  1150,  2201,  3010,
   -2275, -2275, -2275, -2275,  3556,  2458,  5110, -2275,  1354,  2027,
    4083, -1609, -1609, -1609, -1609, -2275,  3577,  3578, -1609,     3,
    1616,  3593,  4297,  2459,  3384,  3979,  1175, -1581, -1581, -1581,
   -1581,  2591,  1453,  2592, -1581,  4935,  3579,  4940,   920,  1123,
    1438,  2174,  2175,  2027,  5135,   363,  3527,  1446,  2190, -1594,
   -1594, -1594, -1594,  2293,  3529,  2262, -1594,  2130,  2306,  2306,
    2062,  3628,  3629,  2027,  1310,  2679,  2132, -1624, -1624, -1624,
   -1624, -1609,  2142,  2472, -1624,  1354,  1168,  1169,  1232,  2846,
    1476,  1768,  2658,  1825,  1617,  2153,  3206,   681,  3272,  2319,
    2654,   841,  3128, -1624, -1624, -1624, -1624,  2309,  2310,  1476,
   -1624,  1705,  1708,  2968,  4310, -1621, -1621, -1621, -1621,  2263,
    2626,  5132, -1621,    37,    38,    39,    40,  1159,  4686,  2088,
      44,  2738,  1104,    37,    38,    39,    40,  1465,  3940,  2469,
      44,  4249,   418,   842,  1737,    37,    38,    39,    40,   924,
   -2103,    43,    44,  1486,  1717,  2064,    45,  4034,  2167,  2168,
    2156,  2222,  2460,  5086,  2317,  1453,  2187,   246,  2621,  4753,
    3642,  4721,  5214,  3357,   926,  3883,   270,  2604,  1758,  1711,
    4287,  2829,  2595,  2650,  2597,  2835,  3591,  2837,  1166,  2036,
    2840,  4547,  1962,  2068,  1626,   931,   931,  4454,  1627,   839,
    2608,  1769,  1962,  1453,  1007,  1008,  4314,   271, -1840,  4077,
    1354,  2317,  2677,  3065, -2103,  3035,  4570,  2276,  1354,  1354,
    4574,  2251,  2646,  4767,  2162,  4747,   272,  2505,  4266, -2103,
    4200,  1692,  1693,  4463,  3387,  2511,  2133,  1167,  1718,  1719,
     273,  3004,  3739,  1161,  1634,  2822, -1856,  4522,  1246,  1210,
    2797,  3579,  2036,  4606,  3170,  4564,  5146,  2227,  2461,  1202,
     293,  3772,  1007,  1008,  3802,   313,  2847,  1178,  1795,   318,
   -1614,   334,  2363,   338,  2399,  1176,  2503,   356,  4629,  1113,
    1759,  2364,  2230,   361,  2848,  2288,   372,  5111,  2893,  2585,
    1365,  1753,  2588,  2589,  3197,  1126,  2162,  3980,  3673,  1626,
    3673, -1948,  1219,  1627,  1305,  2830,  3755,   409,  3756,  2520,
    4987,   409,  2232,  3916,  2841,  3300,  3919,  3920,  -141,  -141,
    3923,  1669,   824,  2831,  2542,  2567,  3926,  1311,   682,  1418,
    1868,  3807,   410,  1350,  4414,  3579,  4710,  4711,  4712,  4713,
    4714,  5127, -1614,  2133,  1295, -2410,  3028,  3028,  3028,  4839,
    4216,  1905,  1174,  1119,  3207,  3999,  4849,  3375, -2682,  4351,
    2655,  1363,  5045,  4853,  5204,  2887,  2889,  3198,  1869,  2026,
    4247,  3707,  1127,  4524,   411,  4525,  2897,  1068,   411,  1704,
    2901,  2706,  1198,  2730, -2683,  3255,  4896,  3182,  2913,  2914,
    1590,  1198,   680,  1419,  4399,  1425,  1410,  1430,   680,  2812,
    2805,  2931,  2933,  1434, -2680,  2815,  3713,  3673,  4020,   680,
    1455,  2069,  2947,  3135,  1413,  2917,  2918,  3097,  3273,  3097,
    5177, -2679,  1405,   418,  1760,  1198,  1425,  1430,  4933,    37,
      38,    39,    40,  3581,    43,  3256,    44,   680,   417,    45,
    1161,   680,   931,  1124,  4962,  5098,  2517,  3675, -2275,  3675,
    3223,  4910,   680,  1707,  1591,   367,   831,  1761, -1399, -1609,
    2731,  1437,  1988,  4808,  3588,  3589,  3590,  3591,  4991,  4992,
    1069,  1351,  1683,  3921,  3922,  2173,  2036, -1402,   680,  2282,
    1455,  2196,  1198,  4493,  2707,  1125,  1762,  3408,  3803,  5126,
     935,  1406,  1198,   680,  2574,   931,  4233,  2179,   680,  4911,
    1989,  2197,  5205,   825,  4526,  5099,  4912,  2196,   680,  2746,
    1672,  4352,  1037,    81,  4262,  2198, -1581, -2684,  3201,  3257,
      79,  1870,   680,    37,    38,    39,    40,  2197,  1411,  1117,
      44,  1873, -1399,  4913,  1637, -2410,  3685,  1874,  2599,  2456,
    3807,  2200,  2283,  1366,  1763,  1424,  3718,  1429,  3125,  1258,
    2832, -1402,  1423, -1621,  1428,  2457,  3675,  1443,  2052,  4321,
    3470,  2224,  4787,  2804,  3376,  2749,  1128,  3938,  4465,  1438,
     409,  2264,  5023,  -618,  1718,  1719,  1458,  1460,  1602,  4726,
    3938,  1596,  1610,  1457,  1459,  1161,  2746,   712,  1118, -1581,
    1038,  1631,  1773,  2219, -2410,  2554,  2053,  2661,  4812,  2543,
    4299,  2838,  2839,  4816,  1906,  4914,  4818,  2470,  1198,  1871,
    2458,  2544,  5053,  5059,  1059,  5206,   680,  4809,  1059,  4250,
     418,  2027,  5049,    37,    38,    39,    40,  4963,  2459,    43,
      44,  4949,  1232,  1875,    45,  2662,  1119,   411,  4042,  1259,
    3183,  2732,  1426,  1438,  1198,  1828,  1431,  1432,  1433,  3409,
    2774,  1171,  5190,  1990,  2733,  1119,  1444,  4322,  4262,  5164,
    4040,  2785,  2545,  3258,  4744,   363,  1112,  3586,  3587,  3588,
    3589,  3590,  3591,  2792,  1339,  2248,  2249,  2250,  2251, -1399,
    1260,  1001,  1417,  4105,  3710,  4727,  4110,  4111,  4112,  4113,
    4114,  4115,  4116,  4117,  4118,  4119,  1058,  1697, -1402,  2747,
    1058,  1002,  3081,  1488,   680,   680,  3579,  3265,  5151,  4614,
    2782,  1684,  4869,  2227,  4436,  5024,  1727,  1222,  1223,  1224,
   -2053,  1225,  1226,  1227,  1228,  1229,  1230,  3410,  3861,  3126,
    1261,  3127,  1828,  1050,  1858,  4641,  1651,  2826,  2230,   936,
    4300,  1991, -1581,  5128,  1894,  4159,  4160,  4323,   730,  2054,
     977,  3586,  3587,  3588,  3589,  3590,  3591,  2460,  4466,  3795,
     879,  4730,  1697,  1039,  1040,  4985,  1488,  2338,  2232,  3579,
    1830,  4915,  1120,  4850,  -163, -1399,  4737,  1876,  3197,  5191,
    1059,  1059,  4950,  4044,  4326,  4251,  1755,  3754,  2663,   937,
    2808,  1992,  5133,  3128, -1402,   881,  1123,  3796,  5051,  -163,
    3044,  1146,  4731,   832,  5176,  2012,  1198,  1027,  5178,  3391,
    1877,  1993, -1399,   833,  4252, -1399,  1001,  1198,  1100,  4210,
     938,  4957,   939,  3673,  2683,  2036,  4873,  3673,  5001,  1652,
    3862, -1402,  1340,  4253, -1402,  3319,  1002,  2055,  3075,  1878,
    1960,  3320,  5165,  4301,  4974,  3100,  4302,  4605,  1232,  1113,
    4437,  3198,  5025,  2461,  5213, -2085,  2339,  1883,  2920,  -799,
    4045,  -163,  1058,  1058,  4808,  2670,  2671,  3041,  1147,  1035,
    4901, -1945,  4378,  1753,   882,  4216,  2664,  1198,  4381,  4382,
    4590,  3199,  4327,  1896,  4583,  3061,  -163,  1341,  3581,  3156,
     367,  1147,  3266,  2414,  1133, -2684,  3516,  5004,  1895,  1724,
    1626,  5009,  5010,  2827,  1627,  3328,  1726,  5090,  5091, -1581,
   -2053,  5166,   834,  2860,  3200,  4858,   680,  1036,   215,  4510,
   -1581,  4754,  2173, -1581,  1745, -1581,  1148,  4874,  5029,  1149,
    3580,   680,  2828,  4755,  5167,    81,    81,  3321,    81,  3940,
    2554,  2036,    79,    79,  3157,    79,  1198,  3582,   223,  1148,
    3797,  3581,  2684,  4918,   680,  4262,  3197,  1994,   841,  4922,
    1753,  1697,  3496,  3491,  3062,  3490,  3058,  1139,  2090, -2053,
    2092,  1745,  3675,  2096,  3863,  2098,  3675,  1406,  2101,  2102,
    2103,  2324,  2332,  2333,  2464,  2337,   233,  1140,  4988,  4073,
     680,  2110,  1067,  2036,  4046,  3345,  1232,  1141,  4994,   236,
     842,  1874,  3201,  1960,  2135,   680,  2136,  3864,  3028,  3378,
    3582,  2465,  2659,  2379,  3439,  3440,  3441,  3442,   680,  1174,
    1150,   680,  3817,  3965,  1125,  1125,  3447,  1125,  3329,  3198,
    3210,  3222,  1198,  2298,  3938,  3082,  3865,  3292,  3798,  3301,
    3144,  5030,   835,  1150,  2019, -2085,  4093,  3304,  3486,  3306,
    4462,  3714,  1672,  4593,  4047,  1626,  4239,  3330,  2316,  1627,
    3688,  1198,  2089,  3689,  3690,  2091,  3968,  5196,  2095,  2660,
    2097,  4433,  2299,  2100,  3691,  3692,  3693,  2104,  3694,  3695,
    2380,  3322,  3152,  3696,  3697,  3698,  1093,  3299,  4756,  1198,
    1198,  1657,  1198,  3292,  2020,  2599,  1142,  1875,   409,  3554,
     363,  2280,  2281,   208, -2085,  2255,  5031,   712,   712,  3312,
    3387,  1198,  3145,   824,  3323,  3211,  3752,  2070,  3824,  1151,
    5044,  2071,  3586,  3587,  3588,  3589,  3590,  3591,  2576,  2246,
    2247,  2248,  2249,  2250,  2251,  1809,  4066,  -963,  2381,  1152,
    3351,  3219,  2685,  3324,  2466,  1851,   680,  1106,  3606,  2296,
    2538,   409,   409,   409,   680,   680,  1697,  3188,  1143,  2984,
    1659,  1697,  1697,  3884,  1198,   411,   824,  4498,  4899,  4499,
    1258,   898,  2160,   410,   410,  1001,  2316,  2380,  1852,  3631,
    3201,  3583,  3584,  3585,  2021,  3586,  3587,  3588,  3589,  3590,
    3591,  2683,  2177,  1198,  1258,  1002,  1064,  1198,  1198,  4719,
    3673,  2539,   409,  4948,  3972,  3673,  2396,  4042,  1115,   409,
    3673,  3767,   712,  3673, -2104,  3818,   409,  2218,   411,   411,
     411,  2019,  2204,   410,  2341,  3699,  1144,  3156,  1001,   900,
    2418,   824,  1150,  2498,  2022,  2381,  2216,  2391,  2392,   680,
    4779,  3973,  2606,    37,    38,    39,    40,   831,  1002,  3391,
      44,  3673,  1809,  4544,  4545,  3974,  2105,  5131,  1147,  2226,
    1259,  2342,  2227,  2410,  2412,  4021,  1001, -2131,  4025,   411,
    4269,  2807,  1129,  1853,  3109,  3331,   411,  1960,  3819,  2106,
     841,   980,  3775,   411,  1259,  2985,  1002,  2230,  3518,  2986,
    1059,  3778,  1616,  2231,   825,  1232,  4998,  1608,  1136,  3825,
     981,  1260,  4995,  4106,  3332,  4107,    37,    38,    39,    40,
   -2474,  3465,  5026,    44,   418,  2023,  1148,  2232,  2286,  2684,
    1697,  3530,   842,  1059,  3826,  1260,  3881,  2987,  1697,  1150,
    2556,  1960,   982,  4684,  4685,  1123,  1123,  3975,  1123,     8,
    4835,  5172,  4837,  2474,  4270,    37,    38,    39,    40,  3675,
    1657,  1261,    44,  2475,  3675,  2344,  1617,  3700,  3236,  3675,
    1354,  2021,  3675,  1960,  2267,   831,  2450,   907,  3794,   908,
    1171,  1476,  1058,  1657,  4729,  1261,  2451,  4736,  1658,  2557,
      80,  2558,  1697,  2382,  5063,  1697,  1697,  4632,  4633,  3882,
    3531,  2452,  1978,  2693,  4746,  3673,  1177,  1354,  1612,  4271,
    3675,  4272, -1446,  3701, -2104,  1058,  2345, -1446,   891,  3237,
    1150,  2022,   825,  1755,   418,  2554,  1755,  4312,  1944,  1659,
     680,    35,   418,  2234,  4108,    37,    38,    39,    40,    41,
      42,    43,    44,   409,  4109,  3480,    45,  2843,  2388,  4434,
    1960,  2389,  1659,  2769,  2235,  2236,  5093,  2988,   824,  1742,
    3238,  3673,  2271,  1697,  2059,  2272,  1660, -2131,  3786,  2676,
    5179,   192,  1188, -2104,  3633,  1755,  3634,   679,  2227,  1755,
    4284, -1446,  3504,  3686,  2060,  2341,  2036,  1960,  1488,  1660,
    4313,  3579,  1743,  3051,  1133,  4076,  2602,  4625,   898,  3635,
    2239,   205,  2023,  2230,  2476,  2306,  2863,  3702,  4150,  4267,
     411,  3239,  4435,  2240,  4872,  1960,  2227,  -957, -1446,  2685,
    1413,  1744,  2342,   130,   131,  2850, -2131,   215,  2070,  3848,
     680,   418,  2800,  2232,  4077,  2453,  3808,  2477,  3028,  2686,
    2290,   925,  2390,  3028,  3849,    45,   680,   943,  3028,  2596,
    5153,  4857,   215,  3058,  3675,  3325,   900,   223,  3828,  3367,
    4626,   367,  4594,    37,    38,    39,    40,  2642,  3708,  4269,
      44,  2232,  1198,  1026,  2343,  1203,  1834,  3035,  1960,  2643,
     980,  1198,   223,   680,   680,  4877,  2556,  4004,  3326,  4072,
    1715,  2139,   831,  2590,   680,   233,  4013,  3435,  3873,   981,
    3636,  2862,  2708,  2644,  4412,  3637,   680,   680,   236,  1835,
    3675,  3673,  1864,  1716,  2196,    81,  2344,  3327,    81,  2856,
     233,  2740,    79,   367,  2857,    79,  2858,  1934,   680,  2859,
    2885,   982,  2640,   236,  2197,  2557,  4784,  2558,  3396,   825,
     122,  4298,  4303,  4270,   246,  1865,  2810,  4878,  2811,  1866,
    1747,  2291,  2813,  4705,  2814,  1354,  4191,  2816,   126,  3444,
    5222,  2817,  4800,  4801,  3445,  2641,  3648,  2345,  1198,  5180,
    2965,  2554,  4288,  3581,  1867,  2547,  1205,  3955,  4124,  4125,
    4085,  4706,  3445,  1748,  4192,  4923,  1217,  3397,  2246,  2247,
    2248,  2249,  2250,  2251,   907,  3508,   908,  3035,  4271,  4576,
    4272,  1256,  3673,  4353,  4699,   910,  1198,  1198,  1218,  4700,
     409,  4194,  1749,  4924,  1198,  4315,   912,  1198,  3811,  1978,
    2591,  1198,  2592,  4354,  3638,   824,  2911,  1962,  1332,  1198,
    1198,  2610,  3582,  1312,  3639,  1313,  2975,  1198,  2976,  3759,
    1198,  1198,  1198,  1198,  2173,  3551,  2441,  3067,  4089,  2803,
    1198,  1198,  4701,  1198,  3981,  1198,  1198,   898,  1333,  1198,
    3675,  2977,  2577,  1637,   940,  2580,  3398,  3399,  2556,  3764,
    3765,   363,  1248,  1332,  3552,  1960,  1198,   411,  3553,  1257,
    3400,  1198,  4607,  1299,  3854,  1198,  1354,  1334,  1302,  1198,
     205,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,
    4543,  1198,   409,  1333,  1232,  4369,  3146,  4542,  3149,  1304,
    4196,  1198,  1198,  1307,  2629,   900,   215,  2557,  2636,  2558,
    1832,    35,  4763,   410,  5150,  4370,  4130,  3401,  2534,    41,
      42,  1335,  4001,   363,  4088,  1881,  2535,  1885,  4472,  2434,
    1327,    37,    38,    39,    40,  3938,   223,  3470,    44,  2185,
    2186,  3675,  4919,  2554,  3084,  2196,   409,  2978,   409,   831,
     215,  3785,  2979,  2534,  1692,  1693,  1320,  2980,  3140,   411,
    5226,  2540,  2435,  5227,  1198,  2197,  1335,   410,  3719,   410,
    1648,   192,  2316, -1399,   233,  3391,  4854,  1750,   983,  2198,
     223,  -418,  3205,  2953,  3858,  2639,  2956,   236,  4956,   215,
    -520,  2436,  3285,  3583,  3584,  3585,   825,  3586,  3587,  3588,
    3589,  3590,  3591,   677,  3402,  3876,  3403,  4870,  4264,  4265,
    1751,  1336,   409,   411,   208,   411,  2973,  3859,   233,   223,
    2196,  1161,  2556,   984,  1626,    35, -1948,   824,  1627,    37,
      38,    39,    40,    41,    42,   680,    44,  1337,  1697,  1752,
    2197,  2571,  3286,   907,  1338,   908,  3860,  1346,  4190,  4944,
    2372,  2373,   215,    81,  2200,    81,  1343,   233,  1727,   843,
      79,  1960,    79,  3072,  3073,  1960,  1960,   246,  1978,   418,
     236,  2557,  2079,  2558,  2080,   680,  2981,  1360,   883,   411,
     680,  1014,   223,   680,  -418,  3262,  2982,  3283,    35,   418,
    1364,  3997,   974,  1372,  3287,  4246,    41,    42,  4090,  1373,
    2173,  1014,  2441,    45,  1378,   680,   246,  2554,  1198,  1315,
    1354,  1316,  1354,  1753,   925,  1387,  1799,  4191,  2651,  1198,
     233,   409,  1800,    35,  2226,   409,  1198,  2227,  2159,  2902,
     246,    41,    42,   236,  1897,  1393,   824,  3990,   975,  3993,
     824,  3605,  1065,  3607,  3608,  4192,   680,  4696,   363,  4698,
   -1470, -1470,  2230,  4702,  4206,  4703,    45,  1059,  2231,  1774,
    4193,   831,  1801,   680,   680,  4780,  4781,  4782,  4783,   246,
   -1190,  1960,  4194, -1190,  4516,  1354,  1451,  2322,  2226,  2323,
    1408,  2227,  2232,  2696,  1447,  3982,  3288,  3984,   411,   680,
    4190,  1775,   411,  2372,  3093,  4195,  2903,  5002,    37,    38,
      39,    40,  4408,  4409,  4410,    44,  2230,  1461,   825,    45,
    1467,  1802,  2231,  2325,  1059,  2326,   680,  3293,  1803,  1468,
     680,  1804,  1473,  4211,  4212,  4213,  1474,  3436,  3406,  3721,
    3722,  1117,  1697,  4503,  4504,  4505,  2232,  1475,   680,  1058,
    1697,  1476,  1697, -1447,  3630,  1477,  2768,  1776, -1447,   680,
    4037,  2317,  4084,  2173,  2904,  1745,  2762,  2905,  2763,  4191,
    1478,  2802,   680,  2803,  2823,  2825,  2824,  2824,   409,  1479,
     831,  4196,   680,  3293,   831,  1805,  1611,  4893,  3035,  1777,
    2853,  1482,  2854,   824, -2684,  1483,  3719,  4192,  2234,  3289,
    1118,  1485,  3057,  3208,  3058,  1618,  1058,  3290,  3641,  3719,
    3291,   898,  4193,  4415,  3216,  3279,  3217,  3280,  1488,  2235,
    2236,  3579, -1447,  1614,  4194,  1778,  1198,   825,  1960,  2146,
    2147,   825,    37,    38,    39,    40, -2684,  1619,  4151,    44,
    2556,  1620,  1806,  4374,  1807,   411,  1625,  4195, -2684,  1645,
    4831,  3293,  2234,  1638,  1808,  1779,  3293,  1646,  2906, -1447,
    1648,  3379,  1809,  3380,  1655,  2239,  4813,  1119,  1649,   900,
    1297,  1670,  1810,  2235,  2236,  1671,  -521,  1113,  2240,  4763,
    2173,  1675,  2441,  1780,  1488,  1686,  1677,  3579,  3293,  2557,
   -2684,  2558,  1681,  3392,  1488,  3393,  3459,  3579,  3460,  3510,
    3550,  2824,  2803,  1960,  4549,  1811,   680,  1682,  1812,  1813,
      37,    38,    39,    40,  4550,  1685,  1781,    44,  1687,  2239,
     208,  1688,  1689,  4196,  1782,  2554,  1690,   831,  1355,   943,
    1783,  1691,  2240,  1488,  1814,  1698,  3579,  1784,  1699,  1701,
    4491,  5156,  1161,   680,  1730,  1785,  1179,  1731,  3274,  4531,
    1733,  1198,  5161,  2963,  1786,  1739, -2684,  2907,  1180,  1181,
    1745,    74,  1787,    80,  4406,  4407,  4408,  4409,  4410,  3661,
    3662,  3663,  4411,  3560,   825,  2803,  1766,  3564,  1182,  2803,
    3568,  1183,  2803,  1793,  1120,  2556,  3569,  1113,  2803,  3612,
     680,  1697,  1815,  1771,  3595,  3619,  2803,  4814,    37,    38,
      39,    40,  1960,  3581,  5199,    44,  3611,   907,  2803,   908,
   -2684,  1797,  3880,   680,  1788,  4418,  3616,  1198,  3617,  1825,
    3656,  1463,  3657,  1198,  4672,  4673,  3658,  4675,  3659,   409,
    1827,  3841,   913,  3842,  2557,   409,  2558,  3846,  1798,  3847,
    1198,  1198,  1828,  1833,   824,  1488,  1198,  1859,  3579,  2556,
     824,  1836,  1481,  2246,  2247,  2248,  2249,  2250,  2251,  1892,
    1882,  1593,  3582,  1860,  1872,  1605,  1355,  1607,  1886,  3581,
    2554,  1198,  1198,  4031,  1893,  4032,  1198,  1891,  3885,  3581,
      37,    38,    39,    40,  4094,  1898,  2803,    44,  1198,  1198,
    1198,  1198,  4401,  3913,  4402,  1184,   411,  4131,  2557,  4132,
    2558,  1198,   411,  4420,  1198,  1902,  1198,  2246,  2247,  2248,
    2249,  2250,  2251,  1900,  1904,  2556,  1198,  1198,  3581,  4141,
    1198,  4142,  4153,  1908,  2803,  4693,  1012,  4231,  3582,  4232,
    2556,  1909,  1185,  1198,  2554,  1198,  4506,  2856,  3582,  1198,
    1914,   367,  2857,  4235,  2858,  4236,  1012,  2859, -1411, -1585,
   -1585, -1585, -1585,  1916,   679,   679, -1585,  4289,  1198,  1728,
   -1411,  4245,  1919,  3127,  2557, -1411,  2558,  1921,  1198,  4316,
    4472,  1198,  1198,  1198,  4268,  1924,  2824,  3582,   831,  2557,
    4464,  2558,  2824,  1753,   831,  4422,  4406,  4407,  4408,  4409,
    4410,   680,  1966,  1969,  2556,  1198,  4708,  4734,  1697,  4548,
    2554,  2854,  4609,  1971,  3127,  1837,  2556, -1411,  1198,  4616,
    4622,  4617,  2824,  1198,  1962,  2554,  4450,  4451,  4623,  1198,
    2824, -1592, -1592, -1592, -1592,   825,  1981,  1198, -1592, -1411,
    3581,   825,  1982,  3583,  3584,  3585,  -184,  3586,  3587,  3588,
    3589,  3590,  3591,  2557,  1986,  2558, -1583, -1583, -1583, -1583,
    1741,  1838,  4689, -1583,  4690,  2557,  4748,  2558,  4749,  3224,
    4789,  1984,  4790,  3719,  2216,  1960, -1411,  4791,  1960,  2803,
    1960,  4575,  1998,  4578, -1411,  1960,  2000,   680,  2973,  2554,
   -1586, -1586, -1586, -1586,  4799,  2008,  2854, -1586,  4855,  3582,
    4856,  2554,   680,   680,  4920,  2006,  2824,  3651,  1198,  3583,
    3584,  3585,   859,  3586,  3587,  3588,  3589,  3590,  3591,  3583,
    3584,  3585,  3667,  3586,  3587,  3588,  3589,  3590,  3591,   680,
    2024,  4945,   680,  4946,  2029,  1960,   409,   409,   409,  4958,
    1839,  2854,  4966,  4603,  4967,  2016,  2030, -1584, -1584, -1584,
   -1584,   824,   824,   824, -1584,  4971,  2031,  3058,  3583,  3584,
    3585,   363,  3586,  3587,  3588,  3589,  3590,  3591,  4976,  4978,
    4011,  4011,  2032,  2033,  5020,  1960,  5021,  5052,  5057,  2285,
    5058,  3667,  2035,  5068,  1112,  2854,  2036,  5069,  1840,  3617,
    1841,  1355,  5070,  2048,  2803,    80,    80,  5080,    80,  3058,
    2598, -1411,  2043,   411,   411,   411,  5082,  5097,  4011,  2854,
    5103,  4824,  2854,  5104,  1355,  2854,  3385,  5118,  5147,  5119,
    3058,  5194,  5224,  4011,  5225,  2046,  5235,   680,  5225,  1843,
    1014,  1654,  1014,  1656,  1014,  2047,  1960,  2049,  1960,   680,
    1014,  4882,  2051,  2056,  2693,  2058,  2057,  2063,   680,  2077,
    2111,  2141,  2144,  2148,  4888,  4890,  2150,  2157,  4695,  2137,
    2151,  2158,  1626,  1014,  1014,  1648,  1627,  2170,  1845,  4167,
    2166, -2684, -2684,  2169,  3586,  3587,  3588,  3589,  3590,  3591,
    2171,  1355,  2260,  2176,   409,   831,   831,   831,  2172,   246,
    2227,  2178,  2181,  1960,  4970,  2182,  2183,  2184,  2189,   824,
    2191,  2192,  2193,  1847,  4970,  2194,  2195,  2202,  2203,  4052,
    2205,  4599,   680,  2206,   920,  2230,  2207,  2208,  1960,  2209,
    2210,  2211,  2212,  2256,  2258,  2289,  2263,  4638,  2285,  2301,
    1437,  2311,   825,   825,   825,  2321,  2330,  1658,  3932,  1960,
    2359,  1660,  2361,  2369,  2371,  2232,  1697,  2378,  1150,  2386,
    2393,   411,  1960,  4016,  2220,  2395,  2397,  2405,  2408,  1697,
    5016,  2406,  4027,  4387,  2225,  1113,   680,  2413,   680,  2415,
   -2626,  2437,  2417,  2438,  2439,  2441,  2444,  2265,  4669,  2442,
     680,  1113,   680,  4051,  2443,  2445,  1014,  2446,  2467,  2473,
    3533,  2479,  2500,  2504,  2506,  2507,  2508,  2510,  2509,  2525,
     677,   677,  2527,  2526,  4388,  1725,  1355,  2537,  1354,  2295,
    2297,  2547,  2548,  2550,  1355,  1355,  1960,  4960,   931,  4722,
    4172,  4173,  4174,  4175,  2551,  2552,  2553,  2554,  4389,  2560,
    2563,   680,  1960,   831,  2562,  2564,  2561,  2568,  2569,  2575,
    2578,  5022,  3965,  4390,  4879,  1960,  4823,  4391,  3966,  1232,
    2586,  1014,  2593,  4828,  2582,  4834,  2583,  5081,  3967,  1809,
    2594,   680,  2600,  2622,  5008,  2601,  4136,  4392,  2605,  2623,
    4393,  2628,  2235,  2236,  2611,  1198,  5005,  2612,   680,  5012,
     825,  5014,  4394,  2624,  2634,  3968,  2627,  3969,  2638,  2652,
    2653,  2665,  2667,  2680,  2668,   680,  2681,  2678,   680,   679,
    2173,  2162,  2694,  2698,  2179,  2697,   409,  2701,  2702,   893,
    2709,  1697,  2705,  1853,  1198,  2724,  2729,  1960,  2239,  2744,
    2745,   824,  2757,  2752,  1198,  2755,  2758,  2765,  2776,  2778,
    1198,  2779,  1198,  2780,  2781,  2794,  2759,  1960,  1198,  2819,
    2795,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,
    1198,  2836,  2851,  2820,  1198,  1198,  2842,   363,  2893,  2865,
    4395,  3970,  1960,  2892,  2898,  2935,   363,  1198,  4396,  2936,
    4882,  1198,  2948,   411,  2954,  1198,  2227,  2958,  2959,  2966,
    2972,  2989,  2991,  3006,  3007,  1198,  3020,   363,  1198,  3040,
    1198,  5073,  3038,  3037,  3043,  3045,  3048,  3049,  1960,  1198,
    1198,  1198,   670,  4397,  3059,  1198,  1118,  3069,  1198,  3068,
    3060,    35,  3070,  3071,  3079,  3099,  3101,  3102,  3971,    41,
      42,  2275,  1198,  3972,  1198,  2226,  3117,  3116,  2227,  3119,
    3131,  3129,  3142,  3130,  3147,  3150,  1198,  3152,  3161,  3154,
    3155,  3171,  1198,  1198,  3166,  2228,  3172,  3174,  2229,  4934,
    1014,  2603,  3177,  2230,  3181,   831,  3185,  3193,  3196,  2231,
    3973,  3209,  2226,  3214,  1608,  2227,  1612,  3264,  4965,  3269,
    3278,  3282,  3270,  3281,  3974,  3294,  3333,  3336,  3347,  3359,
    3360,  3354,  2228,  2232,  3355,  4859,  3362,  1198,  4336,  3363,
    2230,  3366,  3364,  1198,  3358,  3372,  2231,  3374,  3262,  1198,
    4311,  3381,   825,  3383,  3365,  4842,  2246,  2247,  2248,  2249,
    2250,  2251,  3414,  3787,  1354,  1960,  3394,  3388,  2673,  3386,
    2232,  3389,  3428,  3387,  3430,  3437,  3443,  3453,  3446,  3454,
    3462,  1198,  3451,   409,  3464,  3467,  3483,  3452,   409,  3482,
     409,  3485,  3479,  3484,    74,  3487,  3488,  4864,   824,    35,
    3497,  3500,  2216,   824,  3503,   824,  3975,    41,    42,  3502,
    3512,  3513,   680,  3514,  3515,  1012,  4179,  1012,  4182,  1012,
    3524,  5200,  2866,  3058,  3422,  1012,  1435,  1436,  2064,  4386,
    3532,  3535,  2720,  3538,  3517,  2233,  1453,  3540,  3543,  2234,
    3546,  3562,  3547,  3544,  3566,  3548,  3563,  3613,  1012,  1012,
     411,  3565,  3567,  3570,  3571,   411,  1960,   411,  3573,  3576,
    2235,  2236,  2803,  1697,  3866,  3632,  3868,  3594,  3654,   409,
    3600,  3602,  2233,  3603,  3610,  3625,  2234,  2237,  3626,  3601,
    3285,  3640,  3627,  3647,   824,  3678,  3684,  3650, -1003,  3726,
    3731,  3735,  3729,  1232,  3757,  1014,  3763,  2235,  2236,   680,
    1014,  1014,   680,  2238,  3746,  3652,  2239,  3768,  3653,  3766,
    3741,  3683,  3747,  3769,  2237,    80,  3750,  3745,    80,  2240,
    3751,  3903,  2241,  3777,  3719,  3780,  3782,  3789,  3804,  2070,
    3286,  3805,   831,  3773,  3815,  1232,   411,   831,  3774,   831,
    2238,  3816,  3821,  2239,  3820,  3830,  3917,  3832,  3845,  2391,
    2392,  3871,  3872,  3875,  3877,  2481,  2240,  3878,  3879,  2241,
    3886,  3887,  3888,  3889,  3890,  3891,  3904,  3893,  3892,  3894,
    3895,  1012,  3896,  3897,  4480,  3899,  1198,  3423,  3901,   825,
    3898,  3906,  3287,  3900,   825,   677,   825,  3908,  2482,  3910,
    1720,  2620,  3912,  3918,  3928,  3924,  3925,  2242,  3943,   680,
     680,  2483,  3944,  1960,  2389,  3952,   680,  3956,  3988,  3957,
    3998,  3995,  3989,  4000,  2484,  4002,  4051,  4010,   831,  4019,
    4011,  4022,  4026,  5092,  4017,  4023,  2910,  4029,  4049,  4058,
    4060,  4068,  4069,  4070,  2242,  4071,  1012,  4709,  1133,  4074,
    1960,  1198,  1198,  4080,  3224,  4079,  4081,  4092,  4097,  3597,
    3579,  2159,  2485,  3596,  4143,  4127,  2221,  4128,  4129,  1014,
    4135,  4155,  1119,  2486,  4181,   825,  2352,  1014,  4156,  4168,
    4612,  4164,  4203,  4054,  3288,  4189,  4208,  4227,  4255,  4219,
    4248,  4276,  4278,  2487,  4217,   680,  4205,  4279,  2488,  1697,
    2243,  2244,  2245,  1354,  2246,  2247,  2248,  2249,  2250,  2251,
    4241,  4290,  4292,  1198,  4218,  4293,  4291,  4220,  4223,  4224,
    4295,  4317,  4320,  3424,  4304,  4318,  4610,  4319,  4330,  4331,
    4343,  1014,  4332,  4333,  1014,  1014,  5089,  2243,  2244,  2245,
    4334,  2246,  2247,  2248,  2249,  2250,  2251,  4344,  4368,  4335,
    1198,  4350,  3042,  3572,  4366,  4098,  4377,  4299,  4371,  4379,
    1198,  1198,  3425,  1960,  4380,  2489,  4405,  4403,  1198,  1198,
    4430,  4438,  4041,  1198,  1960,  4104,  4448,  4441,  4644,  1198,
    1198,  4446,  4453,  1198,  4457,  4458,  1198,  3289,   363,  4601,
    2824,  3472,  4475,  4477,  4460,  3290,  2490,  4478,  3291,  4461,
    4126,  4492,  1014,  4489,  4488,  4494,  2869,  1198,  4496,  4502,
    1774,  1198,  4507,  4509,  4511,  4512,  4513,  4514,  4515,  4523,
    4533,  4520,  4527,  1198,  4528,   859,    74,    74,  1198,    74,
     363,  4532,  4534,  1198,  4536,  4535,  2139,  4540,  4556,  4566,
    4571,  4567,  1775,  4569,  4596,  1012,   409,  4572,  4579,  4584,
    4582,  4585,  4600,  2870,  4587,   679,  4588,  4608,  2491,    81,
    4589,   824,  4604,  4611,  2492,  4613,    79,  2493,  4618,  4619,
    4627,  1728,  4642,    80,  1232,    80,  1198,  4643,  4649,  4650,
    4662,  4651,  2871,  4665,  4671,  4676,  4704,  4683,  4707,  4715,
    4723,  4717,  4728,  2494,  1960,  4733,  4735,  4739,  1776,  2495,
    4750,  4741,  4752,  2872,  4760,  4761,  4758,  4769,  4785,  4777,
     680,  4786,  2496,   411,  2873,  4788,  4796,  4793,  4797,  4798,
    4795,  4804,  1960,  4810,  4817,  4832,  4820,  4826,  4836,  4848,
    1777,  4852,  4861,  4851,  2874,  4866,   680,  2497,  4867,  2875,
    4876,  1960,  2226,  4875,  4880,  2227,  4887,  4894,   680,  4897,
    4437,  3667,  4902,  4904,  4905,  3667,   409,  4907,  4909,  3473,
    4908,   680,  2228,  4926,  4927,  4932,  1778,  4928,  4930,  4936,
    2230,  4953,  1607,  4961,  4937,  4964,  2231,   410,  4968,  4979,
    4997,  4973,  5027,  4983,  4999,  2876,  4989,  5039,  5032,  1960,
    5011,  5036,  5037,   363,  2226,   831,  1779,  2227,  5042,  5041,
    2232,  5047,  5054,  5056,   680,  5061,  2877,  5055,  5067,  5071,
    5084,  1697,  5062,  5079,  5072,  5083,  5085,  5087,  5100,  5096,
    5006,  5106,  2230,   411,  5108,  5109,  5117,  1213,  2231,  5112,
    5114,  5145,  5122,  1236,  5123,  5129,  5130,  5154,  4169,  5159,
    1012,  5152,   825,  5163,  1253,  1012,  1012,  5110,  1198,  5111,
    5171,  5175,  2232,  5170,  5189,  5203,  5220,  5223,  1131,  1198,
    1796,   208,  2635,  5229,  3432,  1782,   859,  1799,  5233,  3268,
    1857,  1783,  1314,  1800,  3711,  2308,  1321,  3827,  1784,  1856,
    4309,  3346,  4383,  5018,  3927,  4881,  2519,  1331,  5107,  4929,
    4449,  4931,  4917,  2878,  4720,  1786,  3771,  3511,  5155,  2879,
    4840,  5115,  2233,  1787,  5198,  2880,  2234,  1960,  5113,  5169,
    5050,  3776,  4445,  1801,  3412,  3413,  4307,  3369,  3839,  2387,
    2721,  1435,  1436,  3395,  5202,  3369,  5234,  2235,  2236,   680,
    4006,  5230,  4906,  3953,  2881,  3931,  2882,  5173,  4865,  2704,
    2402,  1198,  5102,  5160,  2237,  1960,  4868,  2409,  2411,  1031,
    1198,  4508,  2131,  2883,  2233,  1788,  4984,  4484,  2234,  3475,
    4041,  3122,  1802,  3758,  4485,  5060,  3907,  1198,  1198,  1803,
    2238,  1198,  1804,  2239,  5182,  5231,  3053,  2143,  2884,  2235,
    2236,  1356,  3438,  1622,  1198,  3054,  2240,  2809,  3716,  1198,
    4467,  4452,  4602,  4237,  1198,  2078,  2237,  1198,  3507,  3717,
    1644,  4386,  1198,  1198,  1012,  3078,  2327,  3727,  2356,  2926,
    3466,  3725,  1012,  2355,  3077,  2360,  1355,  3740,  4830,  3728,
    4577,  4184,  2238,  2949,  4565,  2239,  1805,  4833,  4975,   680,
    4180,   680,  2365,  5078,  1014,  1198,  5077,  4238,  2240,  4147,
    2050,   409,  4959,  1630,  4137,  5148,  5144,  5149,  3720,  3643,
    3645,  2065,  3557,  1355,  4234,  3022,   824,  1164,  4050,  3481,
    2761,  2018,  3103,  5137,  2242,  2377,  1012,  1960,   680,  1012,
    1012,  1134,  2370,  1404,  1697,  3094,  1738,  1198,  3107,  2138,
    1709,  3110,  3706,  1806,  3108,  1807,  1710,  1014,  4243,  4592,
    4244,   677,  4222,  4921,  1157,  1808,  3114,  2374,  3509,  2821,
      83,     0,     0,  1809,  2274,     0,  2067,  1725,   411,  1442,
     680,     0,     0,  1810,     0,     0,  2242,     0,     0,     0,
       0,     0,     0,  1198,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3667,     0,     0,  3472,  1012,  3667,   670,
     670,  3667,     0,     0,     0,     0,  1861,     0,  3472,  1812,
    1813,     0,  2139,     0,     0,  1774,     0,  2243,  2244,  2245,
       0,  2246,  2247,  2248,  2249,  2250,  2251,  1774,     0,     0,
       0,     0,     0,     0,     0,  1862,     0,     0,     0,  1198,
       0,  1960,     0,     0,     0,     0,     0,  1775,     0,     0,
     831,     0,     0,     0,     0,     0,     0,     0,     0,  1775,
       0,     0,     0,  1198,  1960,     0,  1198,   409,  1198,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,     0,   824,     0,     0,     0,     0,     0,   370,     0,
       0,  1198,     0,  1815,   370,  1198,     0,   825,     0,   673,
    1960,     0,     0,  1776,     0,  2760,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1776,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   370,     0,     0,
       0,     0,  4631,     0,   411,  1777,     0,     0,     0,     0,
    1960,  1014,     0,     0,  1960,  1960,  5048,  1777,     0,  1014,
       0,  1014,     0,     0,     0,     0,    74,   363,     0,    74,
    4646,  1355,     0,     0,  3473,     0,     0,     0,     0,     0,
    2927,  1778,   370,     0,     0,     0,  3473,     0,     0,  4661,
       0,     0,     0,  1778,  2927,  1198,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1779,     0,     0,  1198,     0,     0,     0,     0,     0,
       0,     0,     0,  1779,     0,  5219,   831,     0,  1054,     0,
       0,     0,     0,     0,  1960,     0,  1054,  4680,  1054,     0,
       0,  5066,     0,     0,     0,  3011,     0,     0,     0,  3667,
     370,     0,  1198,     0,     0,  1198,     0,  2226,     0,     0,
    2227,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2899,  2900,     0,   825,     0,     0,   208,  2228,  2912,     0,
    3474,     0,  2915,  2916,     0,  2230,  1783,  1198,   208,     0,
       0,  2231,  1782,  1784,     0,     0,     0,  2937,  1783,  2938,
       0,  2519,  1355,     0,     0,  1784,     0,     0,     0,   680,
    1786,     0,     0,  2519,     0,  2232,     0,     0,  1787,     0,
       0,  2960,  1786,  2961,     0,     0,     0,     0,     0,     0,
    1787,     0,     0,     0,     0,  1198,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1198,     0,     0,     0,
       0,  5174,     0,     0,  5184,     0,  5210,     0,   367,  5185,
     363,  5186,  1198,  1198,  5187,     0,     0,     0,     0,     0,
    1788,     0,     0,   680,  3475,  2402,     0,     0,     0,  3844,
       0,     0,  1788,     0,     0,  1198,  3475,     0,     0,     0,
       0,     0,     0,  2139,     0,     0,   409,     0,  5184,     0,
    1014,   370,   367,  5185,     0,  5186,  5210,     0,  5187,     0,
       0,   824,     0,     0,  5210,     0,  3874,  2233,     0,     0,
       0,  2234,     0,     0,     0,     0,  1198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   370,     0,     0,  1012,
    1198,     0,  2235,  2236,     0,  5184,   409,     0,     0,   367,
    5185,     0,  5186,     0,   409,  5187,     0,     0,     0,  2237,
       0,   824,     0,   411,     0,  3905,     0,     0,     0,   824,
    5211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2238,     0,  3369,  2239,     0,
    3369,  3369,  1012,     0,  3369,     0,     0,     0,     0,     0,
    3369,  2240,     0,     0,  2241,     0,     0,  2226,  1198,  3941,
    2227,     0,  1720,   411,    74,  3950,    74,  1198,     0,     0,
    5211,   411,  3941,     0,     0,     0,     0,     0,  5211,     0,
       0,     0,     0,     0,     0,  2230,  1355,     0,  1355,     0,
       0,  2231,     0,     0,   670,   831,     0,     0,     0,     0,
       0,  2767,     0,     0,     0,   363,     0,     0,     0,     0,
    2773,     0,     0,     0,  2777,  2232,     0,     0,   363,     0,
    2783,  2784,     0,     0,  4009,     0,     0,     0,     0,  2242,
       0,     0,     0,     0,     0,     0,     0,     0,  2796,     0,
       0,     0,   825,     0,     0,   831,     0,     0,     0,     0,
    4036,  1355,     0,   831,     0,     0,     0,  1014,     0,  2926,
    2926,     0,  5218,     0,  2926,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   825,     0,     0,     0,     0,     0,     0,     0,
     825,     0,  2139,     0,  2926,  2926,     0,  2226,     0,   363,
    2227,     0,     0,     0,     0,     0,     0, -2684,     0,     0,
       0,  2234,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,  3046,  2230,  1012,     0,  3903,     0,
    3047,  2231,  2235,  2236,  1012,     0,  1012,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2684,
       0,     0,     0,     0,     0,  2232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2633,     0,     0,  2139,     0,
       0,     0,  2139,  2139,     0,     0,     0,     0,  2239,  2226,
       0,     0,  2227,     0,     0,     0,     0,     0,     0,     0,
       0,  2240,     0,     0,  4148,     0,     0,     0,     0,  2228,
       0,     0,     0,     0,     0,  1190,     0,  2230,     0,     0,
       0,     0,     0,  2231,  1212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3390,  2226,   371,     0,  2227,
       0,     0,     0,   371,     0,     0,     0,  2232,   674,     0,
       0,     0,     0,     0,     0,     0,  2228,     0,  1300,     0,
       0,     0,     0,     0,  2230,     0,     0,  2233,     0,     0,
    2231,  2234,     0,     0,     0,  2710,   371,  2226,     0, -2684,
    2227,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2633,  2235,  2236,  2232,     0,  3050,     0,     0,     0,
       0,     0,     0,     0,  1774,  2230,   370,     0,     0,  2237,
     370,  2231,     0,     0,     0,  1358,     0,     0,     0,     0,
       0,   371,     0,     0,   673,  1368,     0,     0,     0,  2775,
     673,     0,     0,     0,     0,  2232,  1775,     0,  2239,     0,
       0,   673,     0,     0,     0,     0,     0,     0,     0,  2233,
       0,  2240,  2633,  2234,     0,     0,     0,     0,     0,     0,
    2927,  2927,     0,     0,     0,  2927,     0,     0,     0,   673,
       0,     0,     0,   673,  2235,  2236,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,   673,  1012,     0,     0,     0,   371,
       0,  2237,  1776,     0,     0,  1014,  2233,     0,     0,     0,
    2234,     0,     0,     0,     0,  2927,  2927,     0,  1014,     0,
     673,     0,     0,     0,     0,     0,     0,  2238,     0,     0,
    2239,  2235,  2236,     0,  1777,   673,  3941,     0,     0,  2242,
     673,  2226,     0,  2240,  2227,     0,  2241,  2233,  2237,     0,
     673,  2234,     0,     0,     0,     0,     0,     0,     0,     0,
    4337,     0,     0,  4338,   673,  4339,     0,     0,     0,  2230,
    1778,     0,  2235,  2236,  2238,  2231,     0,  2239,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2237,
    2240,     0,     0,  2241,     0,     0,     0,     0,     0,  2232,
    1779,     0,     0,     0,     0,     0,  3369,     0,     0,     0,
       0,     0,  3369,  3369,     0,  2673,     0,     0,  2239,     0,
       0,  2242,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2240,  2243,  2244,  2245,  3950,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,     0,     0,  4417,  4419,  4421,  4423,
     371,     0,     0,     0,     0,     0,  1054,     0,   673,     0,
    1054,  4162,     0,     0,     0,   208,     0,  2518,  2242,  1782,
    1014,     0,     0,     0,     0,  1783,     0,     0,     0,   370,
       0,     0,  1784,     0,     0,   371,     0,     0,     0,     0,
    2519,     0,     0,     0,     0,     0,     0,  2402,     0,  1786,
    3709, -2684,  1012,     0,     0,  2234,     0,  1787,     0,  2242,
       0,     0,     0,     0,  2243,  2244,  2245,  4483,  2246,  2247,
    2248,  2249,  2250,  2251,     0,     0,  2235,  2236,     0,     0,
    3620,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2684,     0,     0,   673,   673,     0,  1901,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1788,
    1907,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,
    2251,     0,  2239,     0,     0,  2957,     0,     0,     0,     0,
    4518,     0,     0,     0,     0,  2240,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     670,     0,     0, -2684, -2684,     0,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,     0,     0,     0,     0,     0,     0,
    2010,     0,  1054,  1054,     0,     0,  2926,     0,     0,  2926,
    2926,  2926,  2926,  2926,  2926,  2926,  2926,  2926,  2926,     0,
    3132,     0,     0,     0,     0,  3136,     0,     0,  3139,     0,
       0,     0,     0,     0,     0,     0,     0,  3489,     0,  4134,
       0,     0,     0, -2684,     0,     0,     0,     0,     0,  2226,
    3162,     0,  2227,  3498,  3499,     0,     0,  3501,     0,     0,
       0,     0,     0,  3505,     0,     0,     0,     0,  2926,  2926,
       0,     0,     0,     0,     0,     0,     0,  2230,     0,     0,
       0,     0,     0,  2231,     0,  4591,     0,  4597,  4598,     0,
       0,  3212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2232,  3218,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3541,  3253,     0,     0,     0,   673,     0,
    2246,  2247,  2248,  2249,  2250,  2251,     0,     0,     0,     0,
       0,     0,  1014,   673,     0,     0,     0,     0,     0,     0,
       0,  3284,     0,     0,  2226,  3295,     0,  2227,     0,  4165,
       0,     0,     0,     0,     0,  1014,   673,     0,     0,     0,
       0,     0,     0,  3307,  2228,     0,     0,     0,     0,     0,
       0,     0,  2230,     0,  3317,     0,     0,     0,  2231,     0,
       0,     0,     0,     0,     0,     0,     0,  3341,     0, -2684,
       0,     0,   673,  2234,     0,     0,     0,  3348,     0,     0,
    1012,     0,  2232,     0,     0,  3945,  3948,   673,     0,     0,
       0,     0,     0,  1012,  2235,  2236,     0,  4678,  4679,     0,
     673,     0,     0,   673,     0,     0,     0,  3369,  3369,     0,
       0, -2684,     0,     0,  1355,     0,     0,     0,  4697,     0,
       0,     0,     0,     0,  3994,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3950,  3950,  3950,  3950,  3950,     0,
    2239,     0,     0,     0,     0,   371,     0,     0,     0,   371,
       0,     0,     0,  2240,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   674,     0,     0,     0,  2927,     0,   674,
    2927,  2927,  2927,  2927,  2927,  2927,  2927,  2927,  2927,  2927,
     674,     0,     0,     0,  2233,     0,     0,     0,  2234,  4743,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2927,     0,     0,     0,     0,     0,     0,     0,   674,  2235,
    2236,     0,   674,     0,     0,     0,  4762,     0,     0,     0,
       0,     0,     0,   674,     0,     0,  2237,     0,   673,  2927,
    2927, -2684,     0,     0,     0,     0,   673,   673,  1014,     0,
    4518,  4518,  4518,  4518,     0,  1012,     0,   370,     0,   674,
       0,     0,  2238,     0,  2926,  2239,     0,     0,     0,     0,
       0,     0,     0,     0,   674,     0,     0,     0,  2240,   674,
       0,  2241,     0,     0,     0,     0,     0,     0,     0,   674,
       0,     0,     0,     0,     0,  3523,  3781,     0,     0,     0,
       0,     0,     0,   674,     0,     0,     0,     0,     0,     0,
     370,   370,   370,     0,     0,     0,     0,     0,  3523,  2226,
       0,     0,  2227,     0,     0,     0,     0,     0,     0,     0,
       0,   673,     0,     0,     0,     0,     0,     0,  2246,  2247,
    2248,  2249,  2250,  2251,     0,     0,  2226,  2230,     0,  2227,
       0,     0,     0,  2231,     0,     0,  2242,     0,     0,     0,
       0,   370,     0,     0,     0,     0,  2228,     0,   370,  3831,
       0,  3833,     0,  2226,  2230,   370,  2227,  2232,     0,     0,
    2231,     0,  1054,     0,     0,     0,     0,  3941,     0,     0,
       0,     0,     0,  2228,     0,     0,     0,   674,     0,     0,
       0,  2230,     0,     0,  2232,     0,     0,  2231,     0,     0,
       0,     0,     0,     0,     0,  1054,     0,     0,   371,     0,
       0,  3369,     0,  1014,     0,     0,     0,     0,     0,     0,
    1355,  2232,     0,     0,  4885,     0,  4886,     0,     0,  4553,
    4891,  4892,     0,     0,     0,     0,  2926,  2926,     0,  2243,
    2244,  2245,  4240,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,     0,     0,  3942,     0,     0,     0,     0,   672,     0,
    3902,     0,     0,     0,     0,  1014,  3909,     0,     0, -2684,
       0,     0,     0,  2234,     0,   674,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   822,     0,     0,     0,
       0,     0,     0,     0,  2235,  2236,  2233,     0,     0,     0,
    2234,     0,   673,     0,     0,     0,     0,     0,     0,     0,
       0, -2684,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2235,  2236,  2233,     0,     0,     0,  2234,     0,     0,
       0,   822,     0,     0,     0,     0,     0,     0,  2237,     0,
    2239,     0,     0,     0,     0,  2766,     0,  1012,  2235,  2236,
    1014,     0,     0,  2240,  2772,  2927,     0,     0,     0,     0,
       0,     0,     0,     0,  2238,  2237,     0,  2239,     0,     0,
    1012,     0,  3760,     0,     0,     0,     0,  1053,  1014,     0,
    2240,     0,   370,  2241,     0,  1053,  1799,  1053,     0,     0,
       0,  2238,  1800,     0,  2239,     0,     0,     0,     0,   822,
       0,     0,   673,     0,     0,     0,     0,  2240,  5019,     0,
    2241,     0,  4053,     0,  3783,     0,  4056,  4057,   673,  4059,
       0,  4061,  4062,     0,     0,     0,     0,     0,     0,     0,
    4067, -2684,  1801,  1435,  1436,     0,     0,     0,     0,     0,
       0,  1212,  4400,     0,     0,     0,  3948,     0,     0,     0,
       0,     0,     0,     0,     0,   673,   673,  4416,  2242,     0,
       0,     0,     0,     0,     0,  4086,   673,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2226,   673,   673,
    2227,  1802,     0,     0,     0,  2242,     0,   674,  1803,     0,
       0,  1804,     0,     0,     0,     0,     0,  2228,     0,     0,
     673,     0,   674,     0,     0,  2230,     0,     0,     0,     0,
       0,  2231,  3850,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3869,   674,     0,     0,  2246,  2247,
    2248,  2249,  2250,  2251,     0,  2232,     0,  2927,  2927,     0,
       0,     0,     0,     0,     0,  1805,     0,     0,     0,  1355,
       0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,
    2251,   674,     0,     0,     0,  4099,     0,     0,     0,     0,
       0,     0,     0,  1012,     0,     0,   674,     0,  2243,  2244,
    2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,   674,
    4221,     0,   674,     0,     0,     0,     0,  3914,     0,     0,
       0,     0,  1806,     0,  1807,     0,     0,     0,     0,  2926,
       0,     0,     0,  1014,  1808,     0,  3596,     0,  4792,     0,
       0,  3597,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1810,     0,     0,  2926,  2926,  2233,     0,     0,
       0,  2234,  1799,     0,     0,     0,     0,     0,  1800,   370,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2235,  2236,     0,  1887,     0,     0,  1812,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2237,
       0,     0,     0,     0,     0,     0,     0,     0,  1801,     0,
     678,     0,     0,     0,  1888,   722,     0,   722,     0,     0,
       0,     0,     0,  5212,     0,  2238,     0,   722,  2239,     0,
       0,     0,     0,     0,     0,     0,     0,   674,  2402,     0,
       0,  2240,     0,     0,  2241,   674,   674,     0,     0,     0,
       0,     0,     0,   722,     0,     0,   371,  1802,     0,     0,
      74,   370,     0,   722,  1803,     0,  2633,  1804,  1012,     0,
       0,     0,  1815,  5212,   722,   722,     0,     0,   722,     0,
       0,  5212,     0,  4075,   722,     0,     0,     0,  1015,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4087,     0,     0,     0,     0,  1015,   371,
     371,   371,     0,     0,     0,   370,     0,   370,     0,  2242,
    1012,  1805,  3176,   722,     0,     0,     0,     0,     0,  1212,
     674,     0,     0,     0,     0,     0,     0,   673,     0,     0,
    4659,  4660,     0,     0,     0,  4663,  4664,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     371,     0,     0,     0,     0,     0,     0,   371,     0,     0,
       0,     0,     0,     0,   371,     0,     0,   673,  1806,     0,
    1807,   370,   673,     0,     0,   673,     0,     0,     0,     0,
    1808,  2926,     0,     0,     0,     0,     0,     0,  1809,     0,
       0,     0,     0,     0,     0,  1012,     0,   673,  1810,     0,
       0,     0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,     0,  3948,  3948,  3948,  3948,  3948,
    2927,     0,     0,  1012,     0,     0,     0,  5065,     0,  2927,
       0,  2501,     0,     0,  1812,  1813,     0,     0,   673,  2226,
       0,     0,  2227,     0,     0,     0,  2927,  2927,     0,  1054,
       0,     0,     0,     0,     0,   673,   673,     0,     0,  2228,
    2502,     0,     0, -2189,     0,     0,     0,  2230,     0,     0,
       0,     0,     0,  2231,     0,     0,     0,     0,     0,     0,
     370,   673,     0,     0,   370,     0,     0,     0,     0,     0,
       0,  4497,     0,     0,     0,     0,     0,  2232,     0,  4500,
    4501,   674,     0,     0,     0,     0,  1054,     0,   673,     0,
   -2189,     0,   673,     0,     0,   822,     0,     0,  1815,     0,
       0,     0, -2189,     0,     0,     0,     0, -2189,   722,     0,
     673,     0, -2189,   672,     0,     0,     0, -2189,     0,   672,
   -2189,   673, -2189,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,   673,     0,     0,  4285,     0,     0,
    2226,     0,     0,  2227,   673,     0,     0,     0,     0, -2189,
       0,     0,     0,     0,     0,     0,     0,     0,   672,     0,
    2228,   371,   672,     0,     0,     0,     0,     0,  2230,     0,
       0, -2189,     0,   672,  2231,     0,     0,     0,     0,  2233,
       0,   674,  4829,  2234,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   674,  2232,   672,
       0,     0,     0,     0,  2235,  2236,     0,   370, -2189,     0,
       0,     0,     0,     0,   672,     0, -2189,     0,     0,   672,
       0,  2237,     0,     0,  4355,     0,     0,  4358,     0,   672,
       0,     0,     0,     0,   674,   674,     0,  1268,  1012,     0,
       0,     0,     0,   672,     0,   674,     0,  2238,     0,     0,
    2239,     0,     0,     0,     0,     0,     0,   674,   674,     0,
       0,     0,  2927,  2240, -2189,     0,  2241,     0,   673,     0,
    1269,     0,     0,     0,     0,     0,     0,     0,     0,   674,
    3542,     0,     0,  1270,  1271,     0,  3545,     0,     0,     0,
    4630,     0,  1272,     0,     0,     0,  1273,     0,     0,     0,
    2233,     0,     0,     0,  2234,   673,     0,     0,     0,  1027,
       0,     0,     0,  1274,     0,     0,     0,     0,     0,     0,
       0,  4647,  4648,     0,     0,  2235,  2236,   722,     0,     0,
       0,  4455,     0, -2189,  1275,  1053,     0,   672,     0,  1053,
       0,  2242,  2237,     0,     0,  1276,     0,     0,     0,     0,
       0,     0,   673,  1277,     0,     0,     0, -2189,     0, -2189,
   -2189,     0,     0,     0,     0,  1278,     0,     0,  2238,     0,
    1279,  2239,     0,   722,   722,   673,     0,     0,     0,     0,
       0,     0,     0,     0,  2240,     0,     0,  2241,  4681,  4682,
       0,  1280,     0,     0, -2189,     0,     0, -2189, -2189,     0,
   -2189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3523,     0,     0,     0,     0,     0,  1281,     0,     0,     0,
       0,   722,     0,     0,     0,   672,   672,     0,   371,     0,
       0,  3676,     0,     0,  2243,  2244,  2245,  1282,  2246,  2247,
    2248,  2249,  2250,  2251,     0,     0,     0,     0,  4146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   370,     0,
       0,     0,  2242,     0,   370,     0,     0,     0,  1283,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1799,     0,     0,     0,
    3676,     0,  1800,     0,     0,     0,     0,   859,     0,  1957,
       0,  1053,  1053,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4773,     0,  4774,  4775,     0,     0,     0,     0,
     371,     0,     0,     0,  1284,     0,  4778,     0,  1285,     0,
    1286,     0,  1801,     0,     0,     0,  1287,     0,     0,  1288,
       0,     0,  5064,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   673,     0,  2243,  2244,  2245,     0,  2246,
    2247,  2248,  2249,  2250,  2251,  1289,     0,  1290,     0,  4226,
       0,  1291,     0,     0,   371,     0,   371,     0,     0,  1292,
       0,  1802,     0,     0,  1293,     0,     0,     0,  1803,     0,
       0,  1804,     0,     0,     0,     0,   674,     0,     0,     0,
       0,  1799,     0,     0,     0,     0,     0,  1800,     0,  1294,
       0,     0,     0,     0,     0,     0,     0,  1347,   722,     0,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   674,   672,     0,   673,
     371,   674,     0,     0,   674,  1805,     0,  1801,     0,     0,
       0,  4656,   672,     0,   673,   673,     0,     0,     0,     0,
       0,     0,  1957,  4666,     0,     0,   674,     0,     0,   722,
       0,     0,   722,   722,     0,   672,     0,     0,     0,     0,
       0,   673,     0,     0,   673,     0,     0,   678,     0,  1015,
       0,  1015,     0,     0,     0,     0,  1802,   678,     0,     0,
       0,   722,  1806,  1803,  1807,     0,  1804,   674,     0,     0,
       0,   672,     0,  1799,  1808,     0,     0,     0,     0,  1800,
    1015,  1015,  1809,     0,   674,   674,   672,     0,     0,     0,
       0,     0,  1810,     0,     0,     0,     0,     0,     0,   672,
       0,     0,   672,     0,  1837,     0,     0,     0,     0,   371,
     674,     0,     0,   371,     0,   370,   370,   370,     0,  1801,
    1805,     0,     0,   722,  5209,   722,     0,     0,  1812,  1813,
       0,     0,     0,     0,     0,     0,     0,   674,     0,   673,
       0,   674,     0,     0,     0,     0,     0,     0,     0,     0,
    1838,   673,     0,     0,  1814,  4955,     0,     0,     0,   674,
     673,     0,     0,     0,     0,     0,     0,     0,  1802,     0,
     674,     0,     0,     0,  5209,  1803,     0,  1806,  1804,  1807,
       0,     0,  5209,   674,     0,     0,     0,     0,     0,  1808,
       0,     0,     0,   674,     0,     0,     0,  1809,     0,     0,
       0,     0,     0,   678,  3523,     0,     0,  1810,     0,     0,
       0,     0,  1815,  4986,     0,     0,     0,   678,   678,     0,
       0,  1714,     0,     0,   673,     0,     0,   672,     0,  1839,
       0,     0,  1805,     0,     0,   672,   672,     0,     0,     0,
    2565,     0,     0,  1812,  1813,     0,   822,     0,     0,     0,
       0,     0,     0,  5017,     0,     0,   371,     0,     0,     0,
      85,     0,     0,   370,     0,     0,    89,     0,   678,  2566,
      93,     0,    94,     0,    96,    97,     0,  1840,   673,  1841,
     673,     0,     0,     0,     0,   106,     0,     0,  1212,  1842,
       0,  1807,   673,     0,   673,     0,  2433,     0,     0,   822,
       0,  1808,   119,   120,  3523,     0,  3523,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,   674,  1843,  1810,
     672,     0,     0,     0,     0,     0,     0,  1815,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   673,     0,     0,     0,     0,   128,     0,
    2433,     0,  1844,     0,   674,  1812,  1813,  1845,   129,     0,
     130,   131,     0,     0,   822,     0,     0,     0,     0,     0,
       0,  1053,     0,   673,     0,  1130,     0,     0,     0,     0,
       0,  1846,  1957,     0,     0,     0,     0,     0,     0,     0,
     673,     0,  1847,     0,     0,   141,     0,   142,   143,     0,
       0,   674,     0,   146,  1053,   147,     0,   673,     0,     0,
     673,     0,     0,     0,     0,   149,     0,   150,     0,     0,
       0,     0,     0,     0,   674,     0,     0,     0,     0,     0,
       0,   153,     0,   154,     0,  3676,   157,  3676,     0,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,   158,     0,
     159,     0,     0,     0,   160,     0,     0,     0,     0,  1957,
     161,     0,     0,     0,     0,     0,     0,   678,   163,     0,
     165,     0,   722,     0,   722,     0,   167,   722,  2433,   722,
       0,     0,   722,   722,   722,   370,     0,     0,  2109,     0,
       0,   171,     0,     0,     0,   722,  1957,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,   371,   722,  2226,
     722,     0,  2227,   371,     0,   722,     0,     0,     0,     0,
       0,     0,     0,     0,  1957,     0,  5195,     0,     0,  2228,
       0,     0,     0,     0,     0,     0,     0,  2230,     0,     0,
       0,     0,     0,  2231,  3676,     0,   184,   185,     0,     0,
       0,     0,   186,     0,     0,     0,     0,     0,     0,     0,
       0,   187,     0,     0,     0,     0,     0,  2232,     0,     0,
       0,     0,   192,     0,     0,     0,     0,     0,     0,     0,
       0,   822,     0,     0,     0,     0,     0,  1957,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,   674,     0,     0,     0,     0,     0,     0,     0,
     202,     0,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,   204,     0,     0,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,   208,  2269,     0,     0,     0,
     209,     0,     0,   211,     0,   722,   722,   213,     0,     0,
       0,     0,   214,   215,   672,   672,     0,     0,     0,     0,
     216,     0,   678,   218,     0,   672,     0,   678,   678,  2233,
       0,   221,     0,  2234,   673,     0,     0,   672,   672,     0,
       0,     0,     0,   223,     0,     0,     0,     0,   674,     0,
       0,     0,     0,     0,  2235,  2236,     0,     0,     0,   672,
     228,     0,   229,   674,   674,     0,     0,     0,     0,     0,
     231,  2237,   370,     0,     0,     0,   232,   370,     0,   370,
       0,   233,     0,     0,     0,     0,     0,     0,     0,     0,
     674,     0,     0,   674,   236,     0,     0,  2238,     0,     0,
    2239,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     722,     0,   678,  2240,     0,     0,  2241,  1955,     0,     0,
       0,   673,  2404,     0,   673,     0,     0,     0,     0,     0,
     246,     0,     0,     0,  -138,     0,     0,     0,  3523,     0,
       0,     0,     0,     0,  1957,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   370,     0,
       0,     0,     0,     0,   371,   371,   371,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3032,     0,     0,     0,     0,   678,     0,   674,     0,
       0,  2242,     0,     0,   678,     0,     0,     0,     0,     0,
     674,     0,     0,     0,  2226,     0,     0,  2227,   822,   674,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   673,   673,     0,  2228,     0,     0,     0,   673,     0,
       0,     0,  2230,     0,     0,     0,     0,     0,  2231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
       0,   678,   678,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   674,     0,     0,     0,     0,     0,     0,
    1955,     0,     0,     0,  2243,  2244,  2245,     0,  2246,  2247,
    2248,  2249,  2250,  2251,     0,     0,     0,     0,  4257,     0,
       0,     0,     0,     0,     0,     0,     0,   673,     0,     0,
       0,     0,   371,     0,     0,     0,     0,     0,     0,   678,
    3676,     0,     0,     0,  3676,     0,     0,   674,     0,   674,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3118,   674,     0,   674,  2433,  3124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2233,  1799,     0,     0,  2234,     0,
       0,  1800,     0,     0,     0,     0,   672,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2235,
    2236,     0,   674,     0,     0,     0,  1837,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2237,     0,     0,     0,
    2226,  1801,     0,  2227,     0,     0,   672,     0,     0,     0,
     822,   672,   674,     0,   672,     0,  2294,     0,     0,     0,
    2228,     0,  2238,     0,     0,  2239,     0,     0,  2230,   674,
       0,     0,  1838,     0,  2231,     0,   672,     0,  2240,     0,
    1957,  2241,     0,     0,     0,     0,   674,     0,     0,   674,
    1802,     0,     0,     0,     0,     0,     0,  1803,  2232,     0,
    1804,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1799,  1053,     0,
     722,     0,   722,  1800,   672,   672,   722,     0,   722,     0,
       0,   722,     0,     0,     0,   722,     0,     0,     0,     0,
    2269,  1839,   673,     0,  1805,   370,  2242,     0,     0,   822,
     672,     0,     0,   822,   371,     0,     0,     0,     0,     0,
       0,  1799,     0,  1801,     0,     0,     0,  1800,   673,     0,
       0,     0,     0,     0,  1955,  1053,     0,   672,     0,     0,
     673,   672,     0,     0,     0,     0,     0,     0,     0,  1840,
    2233,  1841,  4725,   673,  2234,     0,     0,     0,     0,   672,
       0,  1842,     0,  1807,     0,     0,     0,  1801,     0,     0,
     672,     0,  1802,  1808,     0,  2235,  2236,  1957,     0,  1803,
       0,  1809,  1804,   672,     0,     0,     0,     0,  1955,     0,
    1843,  1810,  2237,   672,     0,     0,   673,     0,     0,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,     0,     0,  4521,     0,   370,  1802,     0,  2238,     0,
    1955,  2239,     0,  1803,  3297,     0,  1804,  1812,  1813,  1845,
       0,     0,     0,     0,  2240,     0,  1805,  2241,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2109,  2433,  3298,     0,     0,   822,     0,  3034,     0,
       0,     0,     0,     0,  1847,     0,     0,  2404,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3676,     0,     0,
    1805,     0,  3676,     0,     0,     0,     0,  3676,     0,     0,
    3676,     0,     0,  1806,     0,  1807,     0,  1955,     0,     0,
       0,     0,     0,   674,     0,  1808,     0,     0,     0,     0,
       0,  1815,  2242,  1809,     0,     0,  1955,   672,     0,     0,
       0,   673,     0,  1810,     0,     0,     0,     0,  3676,     0,
       0,   678,     0,     0,  1955,     0,     0,  1806,     0,  1807,
       0,   371,     0,     0,     0,     0,   371,     0,   371,  1808,
       0,  1957,     0,     0,   672,     0,  3221,  1809,     0,  1812,
    1813,     0,  1955,     0,     0,     0,     0,  1810,     0,     0,
    4863,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   678,  1814,     0,     0,   678,     0,
     674,     0,     0,   674,  3106,     0,  1714,     0,     0,   722,
    3310,   672,     0,  1812,  1813,  2243,  2244,  2245,     0,  2246,
    2247,  2248,  2249,  2250,  2251,     0,  1212,     0,     0,  4555,
       0,   673,     0,   673,   672,  1955,     0,   371,     0,  3311,
       0,     0,     0,     0,     0,     0,  1799,     0,     0,     0,
       0,     0,  1800,  1815,     0,  2226,     0,     0,  2227,     0,
       0,     0,     0,     0,     0,   718,     0,     0,     0,     0,
     673,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,     0,  3676,  2230,     0,     0,     0,     0,     0,  2231,
       0,     0,  1801,     0,     0,     0,     0,  1815,     0,     0,
     674,   674,     0,   718,     0,     0,     0,   674,     0,     0,
     370,     0,   673,  2232,     0,     0,     0,   822,     0,     0,
       0,     0,     0,   822,   718,  2226,     0,     0,  2227,     0,
    3032,  3032,  3032,     0,     0,     0,     0,     0,  3676,     0,
       0,  1802,  1023,     0,     0,  2228,     0,     0,  1803,     0,
       0,  1804,     0,  2230,     0,  1024,     0,     0,     0,  2231,
       0,     0,   844,  1032,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1043,     0,
    1023,     0,     0,  2232,  1066,     0,   674,     0,   678,     0,
       0,     0,     0,     0,  1097,     0,   678,     0,   678,     0,
       0,     0,  1102,     0,     0,  1805,     0,     0,   845,     0,
       0,     0,   672,     0,     0,  2233,     0,     0,     0,  2234,
       0,   846,     0,     0,  2433,     0,     0,  3124,  5038,  3124,
       0,     0,  1955,     0,  2433,     0,     0,     0,   847,     0,
    2235,  2236,     0,     0,   848,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2237,     0,   849,
       0,     0,  1806,     0,  1807,     0,     0,     0,     0,     0,
     850,     0,     0,     0,  1808,     0,   370,     0,   851,     0,
       0,     0,  1809,  2238,  1957,  2233,  2239,     0,  3676,  2234,
     852,     0,  1810,     0,     0,   853,     0,     0,   672,  2240,
       0,   854,  2241,     0,     0,     0,     0,     0,     0,     0,
    2235,  2236,     0,   672,   672,     0,   855,     0,     0,     0,
       0,     0,     0,     0,  2433,  3349,     0,  2237,  1812,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     672,   856,     0,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2238,  3350,     0,  2239,     0,     0,     0,
       0,     0,   857,     0,     0,     0,     0,     0,  5125,  2240,
       0,     0,  2241,     0,     0,     0,     0,  2242,     0,  3676,
       0,     0,     0,     0,     0,  1957,     0,  1957,     0,     0,
       0,     0,     0,   858,     0,     0,     0,     0,     0,     0,
       0,   674,     0,     0,   371,  1799,     0,     0,     0,     0,
       0,  1800,  1815,     0,   822,   822,   822,     0,  5158,     0,
     722,  2109,   859,     0,     0,     0,     0,   674,  1955,     0,
       0,     0,  1955,  1955,     0,     0,     0,   678,   672,   674,
       0,   673,  1957,     0,     0,     0,     0,  2242,     0,   860,
     672,  1801,   674,   861,     0,   862,     0,     0,     0,   672,
       0,   863,     0,     0,   864,     0,     0,  1957,     0,     0,
    2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,
       0,     0,     0,     0,  4794,     0,     0,     0,  3124,   865,
     866,     0,   867,     0,     0,   674,   868,     0,     0,     0,
    1802,  3124,     0,     0,   869,   673,     0,  1803,     0,   870,
    1804,     0,     0,     0,   371,     0,     0,     0,     0,     0,
       0,   871,     0,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   872,     0,     0,     0,  1955,     0,
    2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,
    5232,     0,     0,     0,  4803,     0,     0,     0,     0,     0,
       0,     0,   822,     0,  1805,  1957,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,     0,   672,
       0,  3124,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,     0,   672,  1957,   370,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   718,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     674,  1806,     0,  1807,  1799,     0,     0,     0,     0,     0,
    1800,     0,     0,  1808,     0,     0,     0,     0,     0,  2404,
       0,  1809,   672,     0,   678,   370,     0,     0,     0,     0,
       0,  1810,     0,   370,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1957,     0,     0,     0,
    1801,     0,   672,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3809,  1955,  1957,  1812,  1813,   672,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   672,     0,     0,   672,
       0,  1957,     0,  3810,     0,     0,     0,     0,     0,  1802,
     674,     0,   674,     0,     0,     0,  1803,     0,     0,  1804,
       0,     0,     0,  2226,     0,     0,  2227,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1957,     0,     0,
       0,     0,     0,  2228,     0,     0,     0,     0,     0,   674,
    1955,  2230,     0,     0,     0,     0,     0,  2231,     0,     0,
       0,  1815,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1805,   822,     0,     0,     0,     0,     0,
       0,  2232,  3032,     0,     0,     0,     0,     0,     0,   371,
       0,   674,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,  1200,  1200,   718,     0,
    1200,     0,  1208,     0,  1194,     0,  1097,     0,     0,  1234,
       0,     0,     0,     0,  1097,     0,     0,  1097,     0,     0,
    1806,  1200,  1807,  1097,     0,     0,     0,     0,     0,     0,
       0,  1267,  1808,     0,     0,     0,  1097,     0,  1194,  1955,
    1809,  1200,     0,   718,  2433,  1200,     0,     0,     0,     0,
    1810,     0,  1234,     0,     0,  1324,     0,     0,     0,     0,
       0,     0,  1200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2233,     0,     0,     0,  2234,     0,     0,
       0,     0,     0,  3852,     0,     0,  1812,  1813,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,  2235,  2236,
     718,     0,     0,     0,     0,  1194,     0,     0,     0,  1234,
       0,     0,  3853,     0,     0,  2237,     0,     0,     0,     0,
       0,     0,     0,     0,  1200, -2191,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3124,     0,     0,     0,     0,
       0,  2238,     0,     0,  2239,   371,     0,     0,     0,     0,
       0,     0,     0,   672,     0,     0,     0,  2240,     0,     0,
    2241,     0,   678,     0,     0,     0,     0,     0,     0,     0,
    1815,     0, -2191,     0,     0,   678,     0,     0,     0,  1097,
       0,     0,     0,     0, -2191,     0,     0,     0,     0, -2191,
       0,   822,  1097,  1472, -2191,     0,   822,     0,   822, -2191,
       0,     0, -2191,     0, -2191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,     0,   718,  1097,     0,     0,     0,
       0, -2191,     0,     0,     0,  2242,     0,     0,     0,     0,
     672,     0,     0,   672,     0,  1097,     0,     0,     0,  1097,
       0,     0,     0, -2191,     0,     0,     0,  1582,     0,     0,
       0,     0,     0,     0,     0,  2226,   722,  1097,  2227,     0,
       0,     0,     0,     0,     0,     0,     0,   822,     0,  1097,
       0,     0,  1957,     0,     0,  2228,     0,     0,     0,     0,
   -2191,     0,     0,  2230,     0,     0,     0,     0, -2191,  2231,
       0,     0,  1955,     0,     0,  1955,     0,  1955,     0,     0,
     674,     0,  1955,     0,     0,     0,     0,     0,     0,  2433,
       0,     0,     0,  2232,     0,     0,     0,   678,  2243,  2244,
    2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,
     672,   672,  4838,     0,     0,     0, -2191,   672,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1097,  1955,     0,     0,     0,     0,     0,     0,  1097,
       0,  1200,  1200,     0,   674,  2226,     0,     0,  2227,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1027,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,     0,  1955,  2230,     0,     0,     0,     0,     0,  2231,
       0,     0,     0,     0,     0, -2191,     0,     0,     0,  1194,
       0,     0,     0,     0,     0,  2233,   672,     0,     0,  2234,
    1194,     0,  1957,  2232,  1234,     0,     0,     0,     0, -2191,
       0, -2191, -2191,  1957,     0,     0,     0,  1200,     0,     0,
    2235,  2236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1097,  1955,   371,  1955,     0,  2237,  1200,  1200,
       0,     0,     0,     0,     0,     0, -2191,     0,     0, -2191,
   -2191,     0, -2191,     0,  1097,  1097,  1097,     0,  1200,     0,
    1194,     0,  3032,  2238,  2015,     0,  2239,  3032,     0,     0,
       0,     0,  3032,     0,     0,     0,     0,     0,     0,  2240,
       0,     0,  2241,     0,   371,     0,     0,     0,     0,     0,
    1955,     0,   371,  1200,     0,  1200,  1200,  3106,     0,     0,
       0,     0,     0,     0,     0,  2233,     0,     0,     0,  2234,
       0,     0,     0,     0,     0,  1955,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1582,
    2235,  2236,     0,  1957,     0,     0,  1955,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2237,     0,  1955,
       0,     0,     0,     0,     0,     0,     0,  2242,     0,     0,
       0,  1957,     0,     0,     0,     0,     0,  2114,  2114,     0,
       0,     0,  1097,  2238,  1023,     0,  2239,     0,     0,     0,
    1957,     0,     0,     0,     0,     0,     0,     0,     0,  2240,
       0,     0,  2241,     0,     0,     0,     0,  2149,     0,   678,
    1097,     0,     0,  2155,     0,     0,     0,     0,     0,     0,
       0,   672,     0,  1955,   822,  1582,     0,     0,     0,     0,
       0,     0,   678, -2204,     0,     0,     0,     0,  1957,  1955,
       0,     0,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,  1955,  2226,  1582,     0,  2227,     0,     0,   672,
    2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,
       0,     0,   672,  2228,  4900,     0,     0,  2242,     0,     0,
   -2204,  2230,  1582,  1582,     0,  1582,     0,  2231,     0,     0,
       0,     0, -2204,     0,     0,     0,     0, -2204,     0,     0,
       0,     0, -2204,     0,  1582,     0,     0, -2204,     0,     0,
   -2204,  2232, -2204,     0,     0,   672,     0,     0,     0,     0,
       0,     0,     0,     0,  1955,   718,   718,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2204,
       0,     0,     0,     0,  1955,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1097,     0,  4766,  1582,     0,     0,
       0, -2204,     0,     0,     0,     0,     0,     0,     0,  1955,
    2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,
       0,     0,     0,     0,  5124,     0,  1582,     0,     0,     0,
    1582,  1582,     0,     0,  1957,     0,     0,     0, -2204,     0,
       0,  1097,  1097,  2368,     0,  1955, -2204,     0,     0,     0,
       0,     0,     0,  2233,     0,     0,     0,  2234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     718,     0,     0,     0,     0,   678,     0,     0,  2235,  2236,
     672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2204,  2237,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2238,     0,     0,  2239,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2240,     0,  1027,
    2241,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3124,     0,     0,     0,
       0,     0,  1955, -2204,     0,     0,     0,     0,     0,  1097,
    2533,     0,     0,     0,     0,     0,  1097,     0,     0,  1200,
     672,     0,   672,     0,     0,     0,     0, -2204,     0, -2204,
   -2204,     0,     0,     0,     0,     0,     0,     0,  1234,     0,
       0,     0,     0,     0,  1097,     0,     0,  1097,     0,     0,
       0,     0,     0,     0,     0,  2242,     0,     0,     0,   672,
    2404,     0,     0,     0, -2204,     0,     0, -2204, -2204,     0,
   -2204,  1097,     0,     0,     0,     0,     0,     0,     0,  1200,
    1200,  1200,  1200,  1097,     0,     0,     0,     0,     0,     0,
     678,     0,     0,  1955,     0,     0,     0,  1097,     0,   822,
       0,   672,     0,     0,     0,     0,     0,     0,     0,  2648,
    3124,  1097,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1200,  1200,     0,     0,     0,     0,  1200,     0,     0,
       0,     0,     0,  1957,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,     0,     0,     0,     0,  2243,  2244,
    2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,
       0,     0,  5221,     0,     0,     0,     0,     0,     0,  1957,
       0,     0,  1200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1200,
    1200,  1200,  1200,     0,     0,     0,     0,     0,     0,  1957,
       0,  1097,     0,  1957,  1957,     0,     0,  1097,     0,     0,
    2648,     0,     0,     0,     0,     0,     0,   678,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,     0,     0,
    1955,     0,   718,     0,  1194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1234,   678,     0,     0,     0,  1200,
       0,     0,     0,     0,     0,   822,     0,     0,  1200,     0,
       0,     0,     0,     0,  1200,  1200,     0,  1955,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1097,     0,
       0,     0,     0,  4766,     0,     0,     0,     0,     0,   944,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   945,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2114,     0,     0,     0,     0,     0,     0,  1200,
       0,  1194,   946,     0,     0,  1097,  1097,     0,  1200,     0,
       0,     0,     0,     0,  1097,   947,     0,     0,     0,     0,
       0,     0,     0,     0,  1097,     0,     0,     0,   948,     0,
       0,  1023,  1023,     0,     0,  2868,     0,     0,     0,  1582,
    1582,     0,     0,     0,     0,   949,     0,  1582,     0,     0,
    1582,     0,     0,     0,  1582,     0,     0,     0,     0,     0,
    1955,     0,  1582,  1582,     0,     0,   950,     0,     0,     0,
    1582,  1955,  1234,  1582,  1582,  1582,  1582,   951,     0,     0,
       0,     0,     0,  1582,  1582,   952,  1582,     0,  1582,  1582,
       0,     0,  1582,     0,     0,     0,     0,   953,     0,     0,
     672,     0,   954,     0,     0,     0,     0,     0,   955,  1582,
       0,   722,     0,  1200,  1582,     0,     0,     0,  1582,     0,
       0,     0,  1582,   956,  1582,  1582,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,     0,  1582,     0,     0,     0,     0,     0,
       0,  1097,     0,     0,  1582,  1582,     0,     0,     0,     0,
       0,     0,     0,     0,  2226,     0,     0,  2227,     0,     0,
     678,     0,     0,     0,   672,     0,  1097,     0,     0,   957,
       0,     0,     0,     0,  2228,     0,     0,     0,  3061,     0,
       0,     0,  2230,     0,     0,     0,     0,     0,  2231,     0,
       0,  1955,     0,     0,     0,     0,     0,     0,     0,     0,
     958,     0,     0,  1097,     0,  1097,     0,  1582,     0,     0,
       0,   959,  2232,     0,     0,     0,     0,     0,     0,  1955,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   859,
       0,     0,     0,     0,     0,     0,     0,     0,  1955,     0,
       0,     0,  1097,     0,     0,     0,     0,     0,  3085,     0,
    3092,     0,     0,     0,   822,     0,   960,  3062,     0,     0,
     961,     0,   962,     0,     0,     0,     0,     0,   963,     0,
       0,   964,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1955,  2226,     0,     0,
    2227,     0,     0,     0,     0,     0,     0,   965,     0,   966,
       0,     0,     0,   967,   822,     0,     0,  2228,     0,     0,
       0,   968,   822,     0,  2233,  2230,   969,     0,  2234,     0,
       0,  2231,     0,     0,     0,     0,     0,   718,   970,     0,
       0,     0,  1023,     0,  1023,     0,     0,     0,     0,  2235,
    2236,   971,     0,     0,     0,  2232,     0,     0,     0,     0,
       0,  1582,     0,     0,     0,     0,  2237,     0,     0,     0,
       0,     0,  1194,     0,  1200,  1200,  1200,     0,     0,  1194,
       0,  1234,     0,  1200,     0,  1200,     0,  1200,  1200,     0,
       0,  1097,  2238,     0,     0,  2239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2240,     0,
       0,  2241,     0,     0,     0,     0,     0,     0,     0,     0,
    2533,     0,     0,     0,     0,     0,     0,  3226,     0,     0,
       0,     0,  3235,     0,     0,     0,     0,     0,  1097,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1955,     0,     0,  1097,     0,  2233,     0,  3276,
    3276,  2234,     0,     0,     0,     0,   718,     0,     0,     0,
       0,     0,     0,     0,   678,     0,     0,     0,     0,     0,
       0,     0,  2235,  2236,  1200,     0,  2242,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2237,
       0,     0,     0,     0,  2226,     0,     0,  2227,     0,     0,
       0,  3335,     0,  3338,  3340,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2228,  2238,     0,     0,  2239,     0,
       0,     0,  2230,     0,     0,     0,     0,  3063,  2231,     0,
       0,  2240,     0,  1200,  2241,     0,     0,     0,     0,     0,
       0,  1200,     0,     0,     0,     0,  1200,     0,     0,     0,
       0,     0,  2232,     0,  4138,     0,     0,     0,     0,  1582,
       0,     0,     0,     0,  1955,     0,     0,     0,     0,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,     0,     0,  2533,     0,     0,  3276,     0,  1097,     0,
    3433,     0,     0,  1023,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2242,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3335,
       0,     0,     0,  4139,     0,     0,     0,  1200,  3458,     0,
       0,     0,  5192,     0,     0,     0,     0,     0,     0,     0,
    2015,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2233,     0,  1947,  1200,  2234,  1200,
    3276,  1200,  3276,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1955,  2235,
    2236,     0,     0,     0,  1582,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2226,  2237,     0,  2227,     0,
       0,  1955,  2243,  2244,  2245,  2114,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,     0,  2228,     0,     0,  3559,     0,
       0,     0,  2238,  2230,     0,  2239,     0,     0,     0,  2231,
       0,     0,     0,     0,     0,     0,     0,  1955,  2240,     0,
       0,  2241,     0,     0,     0,     0,     0,     0,     0,     0,
    1194,     0,     0,  2232,     0,     0,  1194,     0,     0,  5193,
       0,     0,     0,     0,     0,     0,     0,  1200,     0,     0,
       0,     0,     0,  1582,  1582,     0,     0,  1955,     0,  1582,
    2226,  1955,  1955,  2227,     0,     0,  1199,  1201,     0,     0,
    1204,     0,  1206,     0,     0,     0,     0,     0,     0,     0,
    2228,     0,     0,     0,  1582,  1582,     0,     0,  2230,  1582,
       0,  1250,     0,     0,  2231,     0,  2242,     0,     0,  1947,
       0,  1582,  1582,  1582,  1582,     0,     0,     0,     0,     0,
       0,  1303,     0,     0,  1582,  1306,     0,  1582,  2232,  1582,
    3624,     0,     0,     0,     0,     0,     0,     0,     0,  1582,
    1582,     0,  1329,  1582,     0,  2233,     0,     0,     0,  2234,
       0,     0,     0,     0,     0,     0,  1582,     0,  1582,     0,
    1234,     0,  1582,     0,     0,     0,     0,     0,     0,     0,
    2235,  2236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,     0,  1097,     0,  2237,     0,     0,
       0,  3677,     0,     0,  1582,  1582,  1582,     0,     0,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,     0,     0,  2238,     0,     0,  2239,     0,  1582,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2240,
    2233,  1582,  2241,     0,  2234,     0,  1582,     0,     0,     0,
       0,     0,  1582,     0,     0,     0,     0,     0,     0,     0,
    3677,     0,     0,  3734,     0,  2235,  2236,  3092,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2237,     0,     0,     0,  2226,     0,     0,  2227,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2228,     0,  2238,  3604,
       0,  2239,     0,     0,  2230,     0,     0,  2242,     0,     0,
    2231,     0,     0,     0,  2240,     0,     0,  2241,     0,     0,
       0,  1582,     0,  3276,     0,     0,     0,     0,  2114,     0,
       0,     0,  3574,     0,  2232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1200,     0,  1200,  1200,  1200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1947,     0,     0,     0,     0,     0,     0,
       0,     0,  2242,     0,     0,     0,     0,     0,     0,     0,
    2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   830,     0,     0,     0,     0,  2233,  1947,     0,     0,
    2234,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1823,  1824,     0,     0,     0,     0,     0,     0,     0,
       0,  2235,  2236,     0,     0,     0,     0,     0,     0,  1947,
       0,     0,     0,     0,     0,     0,   830,     0,  2237,     0,
       0,     0,     0,     0,     0,  2243,  2244,  2245,     0,  2246,
    2247,  2248,  2249,  2250,  2251,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2238,     0,     0,  2239,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2240,     0,  1057,  2241,     0,     0,     0,  1917,     0,     0,
    1057,     0,  1057,     0,     0,  3276,  3276,     0,     0,     0,
       0,     0,     0,     0,   830,     0,  1947,     0,  1975,  1976,
       0,     0,     0,     0,     0,     0,     0,     0,  3949,     0,
       0,     0,     0,     0,     0,  1947,     0,     0,  2007,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1947,     0,  1097,  1097,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2242,     0,
       0,  1097,     0,     0,     0,  2040,  2042,     0,     0,     0,
       0,  1947,     0,     0,  2114,  1097,     0,     0,     0,     0,
       0,     0,     0,  2114,  1097,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1097,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   718,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1200,     0,
       0,  1200,     0,     0,  1947,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1194,     0,
       0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,
    2251,     0,     0,     0,     0,     0,     0,     0,     0,  1097,
       0,     0,  2226,     0,     0,  2227,     0,     0,     0,  1200,
       0,     0,     0,     0,     0,     0,     0,  1582,     0,     0,
       0,     0,  2228,     0,     0,  3615,     0,  1582,     0,     0,
    2230,     0,     0,  1582,     0,  1582,  2231,     0,     0,     0,
       0,  1582,     0,     0,  1582,  1582,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,     0,     0,     0,  1582,  1582,     0,
    2232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1582,     0,     0,     0,  1582,     0,     0,     0,  1582,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1582,     0,
       0,  1582,     0,  1582,     0,     0,     0,     0,     0,     0,
       0,     0,  1582,  1582,  1582,     0,     0,     0,  1582,     0,
       0,  1582,     0,     0,     0,  4171,  2226,     0,     0,  2227,
       0,     0,  1097,  1097,  1097,  1194,     0,  3677,  4188,     0,
       0,     0,  4188,  4202,     0,     0,  2228,     0,     0,  1582,
       0,     0,     0,     0,  2230,  1582,  1582,     0,     0,     0,
    2231,  2226,     0,     0,  2227,     0,     0,     0,     0,     0,
       0,  1947,  2233,     0,     0,     0,  2234,     0,     0,     0,
       0,  2228,     0,     0,  2232,     0,     0,     0,     0,  2230,
       0,     0,     0,     0,     0,  2231,     0,  2235,  2236,     0,
    1582,     0,     0,     0,     0,     0,  1582,     0,     0,     0,
    3092,     0,  1582,     0,  2237,     0,     0,     0,     0,  2232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2238,     0,     0,  2239,  4263,  2114,  2114,     0,  2648,     0,
       0,     0,     0,     0,     0,     0,  2240,     0,     0,  2241,
       0,     0,     0,     0,     0,     0,  1200,  1200,  1200,  1200,
    3609,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2233,     0,     0,     0,
    2234,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4306,     0,     0,     0,     0,     0,     0,
       0,  2235,  2236,     0,     0,     0,     0,     0,     0,     0,
       0,  2233,     0,     0,     0,  2234,     0,     0,  2237,     0,
       0,     0,     0,     0,  2242,     0,     0,     0,     0,  2549,
       0,     0,     0,     0,     0,     0,  2235,  2236,     0,     0,
       0,     0,     0,     0,  2238,     0,     0,  2239,     0,     0,
       0,     0,     0,  2237,     0,     0,     0,  1947,     0,     0,
    2240,  1947,  1947,  2241,     0,     0,     0,     0,     0,  4372,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2238,
       0,     0,  2239,     0,     0,     0,     0,     0,     0,  2615,
    2616,  2617,  2618,     0,     0,  2240,     0,     0,  2241,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3949,     0,
       0,     0,     0,     0,     0,     0,  1097,  2243,  2244,  2245,
       0,  2246,  2247,  2248,  2249,  2250,  2251,  1200,     0,  1582,
       0,  2656,  2657,     0,     0,  1097,     0,  2666,  2242,     0,
     830,  4444,     0,     0,     0,     0,     0,     0,  1196,     0,
    2533,     0,     0,     0,     0,     0,     0,  1196,     0,     0,
       0,     0,  1097,     0,     0,     0,     0,  1947,     0,     0,
       0,     0,  3335,  2242,     0,     0,     0,     0,  4473,     0,
       0,     0,  2690,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,  1582,  1582,     0,     0,     0,  4095,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2725,
    2726,  2727,  2728,     0,     0,     0,     0,     0,     0,  3276,
       0,  3276,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,
    2251,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,  1582,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,  2243,  2244,  2245,  2787,
    2246,  2247,  2248,  2249,  2250,  2251,     0,     0,  2791,     0,
       0,     0,     0,     0,     0,  2798,     0,     0,     0,     0,
       0,     0,     0,  1582,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1582,  1582,     0,     0,     0,     0,     0,
       0,  1582,  1582,     0,  1947,     0,  1582,     0,     0,     0,
       0,     0,  1582,  1582,     0,     0,  1582,     0,     0,  1582,
    4559,     0,     0,  1097,  1097,  1097,  1097,     0,     0,     0,
    4188,  4202,     0,  4188,     0,     0,  4568,     0,     0,     0,
    3677,     0,     0,     0,  3677,     0,     0,     0,     0,     0,
    4581,     0,     0,     0,     0,     0,  1582,     0,     0,     0,
       0,  1582,  2226,     0,  1196,  2227,  1582,     0,     0,     0,
    1057,     0,     0,     0,  1057,  1234,     0,     0,     0,  1947,
       0,     0,  2228,  3734,     0,  4145,     0,  3092,     0,     0,
    2230,     0,     0,     0,     0,     0,  2231,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,  1023,     0,     0,  1582,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2232,     0,     0,     0,     0,     0,     0,     0,     0,  3276,
    3276,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2970,     0,     0,     0,     0,     0,  1216,
       0,     0,     0,  4645,     0,     0,     0,  1240,     0,     0,
       0,     0,     0,     0,     0,     0,  1255,     0,     0,     0,
       0,     0,     0,     0,  1265,     0,     0,     0,  1947,  1298,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1200,     0,     0,
       0,     0,  2233,     0,     0,     0,  2234,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1057,  1057,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2235,  2236,     0,
       0,     0,     0,     0,     0,     0,     0,  3949,  3949,  3949,
    3949,  3949,  1196,     0,  2237,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,     0,     0,     0,     0,     0,     0,
    2238,     0,  1194,  2239,     0,     0,  1958,  2533,     0,     0,
       0,     0,     0,     0,  2114,     0,  2240,     0,     0,  2241,
       0,     0,     0,     0,     0,     0,  1200,  2533,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,  1471,     0,     0,     0,     0,
       0,     0,     0,  1097,     0,  4772,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1600,
       0,     0,     0,     0,  1582,     0,     0,     0,     0,     0,
       0,     0,     0,  1582,  2242,     0,     0,     0,  1624,     0,
       0,     0,     0,     0,  3178,  3179,  3180,     0,     0,     0,
    1582,  1582,  1196,  3190,  1582,  3192,     0,  3194,  3195,     0,
    1650,     0,     0,     0,     0,     0,     0,  1194,  4188,     0,
       0,     0,  3677,     0,     0,     0,     0,  3677,     0,     0,
    3677,  3335,     0,  4822,     0,  1582,  1582,     0,     0,     0,
       0,  1947,     0,     0,  1947,     0,  1947,     0,     0,     0,
       0,  1947,     0,     0,     0,     0,     0,     0,     0,  1958,
       0,     0,     0,     0,     0,     0,     0,     0,  4263,  1234,
    1200,  1200,  1200,     0,     0,     0,     0,  2243,  2244,  2245,
       0,  2246,  2247,  2248,  2249,  2250,  2251,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1947,     0,     0,  3302,     0,     0,     0,     0,     0,
    1194,  1234,  1822,     0,     0,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1947,     0,     0,     0,  1196,  1196,     0,  1196,     0,
       0,  2114,  2114,     0,     0,  2226,  1194,     0,  2227,     0,
       0,     0,     0,  3361,     0,     0,  1097,  1196,     0,     0,
       0,  3370,     0,     0,     0,  2228,  3371,  4444,     0,     0,
       0,     0,     0,  2230,  3276,     0,     0,     0,  2533,  2231,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4473,     0,  1947,  1097,  1947,  1973,     0,     0,     0,     0,
       0,  1200,  4263,  2232,     0,     0,     0,     0,     0,     0,
    1196,   830,     0,     0,     0,     0,     0,  2001,  2004,  2005,
       0,     0,     0,     0,     0,     0,  1582,     0,     0,  1582,
       0,  1582,     0,     0,     0,     0,     0,     0,     0,  1196,
       0,     0,     0,  1196,  1196,     0,     0,  3456,     0,  1947,
       0,     0,     0,     0,  1582,     0,     0,     0,  3677,     0,
       0,  4822,     0,     0,     0,     0,     0,  4982,     0,     0,
       0,     0,     0,     0,  1947,     0,     0,     0,     0,  3492,
       0,  3494,     0,     0,     0,  1200,     0,     0,     0,  1097,
       0,     0,     0,     0,     0,  1947,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2233,     0,     0,  1947,  2234,
       0,     0,     0,  1200,  1200,  1200,  1200,     0,     0,     0,
       0,     0,     0,  1958,     0,     0,     0,     0,  2114,   830,
    2235,  2236,     0,     0,     0,  1600,  1057,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2237,  1194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1600,     0,     0,     0,  1582,     0,  1057,
       0,     0,  1947,  2238,     0,     0,  2239,  1958,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3549,  1947,  2240,
       0,     0,  2241,     0,     0,     0,     0,     0,     0,     0,
       0,  1947,     0,     0,     0,  1582,     0,     0,  1194,  1958,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1200,     0,
    1234,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1582,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2242,     0,     0,
       0,     0,     0,  1947,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1200,     0,     0,  1958,     0,  1194,     0,
       0,     0,     0,  1947,     0,     0,     0,     0,     0,  4263,
       0,     0,     0,     0,     0,  1958,     0,  2312,  4772,     0,
       0,     0,     0,     0,     0,  1582,  1582,     0,  1947,     0,
    3335,     0,     0,  1958,  4982,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1194,     0,
       0,     0,     0,     0,     0,     0,   830,  1200,     0,     0,
       0,  1958,     0,     0,  1947,  2366,     0,     0,     0,     0,
    2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1582,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1582,     0,     0,     0,     0,     0,     0,
    1200,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,  1958,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,     0,     0,     0,     0,     0,     0,
    1194,  1947,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2528,     0,  3790,     0,  3791,  3792,  3793,  2546,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2581,     0,     0,
    2584,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,  1196,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,  1196,     0,     0,  2619,  1196,     0,     0,
       0,     0,  1947,     0,     0,  1196,  1196,     0,     0,     0,
    2637,     0,     0,  1196,     0,     0,  1196,  1196,  1196,  1196,
       0,     0,     0,     0,  2649,     0,  1196,  1196,     0,  1196,
       0,  1196,  1196,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1958,  1196,   830,     0,     0,     0,  1196,     0,     0,
       0,  1196,     0,     0,     0,  1196,     0,  1196,  1196,  1196,
    1196,  1196,  1196,  1196,  1196,  1196,     0,  1196,     0,     0,
     887,     0,     0,     0,     0,     0,     0,  1196,  1196,     0,
       0,     0,   888,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   889,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2741,     0,   890,     0,     0,     0,
    2751,     0,     0,     0,     0,   891,     0,     0,     0,  -755,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1947,
    1196,     0,     0,     0,     0,     0,   892,     0,     0,     0,
       0,     0,   893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   894,     0,     0,
       0,     0,     0,     0,     0,     0,  1947,     0,   895,     0,
       0,     0,     0,     0,     0,     0,   896,     0,     0,     0,
       0,  2806,     0,     0,     0,     0,     0,     0,   897,     0,
       0,     0,     0,     0,     0,   898,     0,     0,     0,   899,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -957,     0,     0,     0,  4063,     0,
       0,  4064,     0,     0,     0,     0,     0,  1958,  1600,  1600,
       0,  1958,  1958,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   830,     0,  2861,     0,     0,
       0,     0,     0,   900,     0,     0,     0,     0,     0,     0,
    -521,     0,     0,     0,     0,     0,     0,     0,     0,  4091,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,  1947,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
    1947,   901,  1196,     0,   902,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1057,     0,     0,     0,     0,     0,  -418,
       0,     0,     0,     0,     0,     0,     0,  1958,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   903,     0,     0,
       0,     0,     0,   904,   830,     0,     0,     0,   830,  -418,
       0,     0,   905,     0,  3019,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1057,     0,     0,     0,     0,     0,     0,     0,  -418,  3039,
     906,   907,     0,   908,   909,     0,     0,     0,     0,     0,
       0,     0,   910,     0,     0,     0,     0,   911,     0,     0,
    1947,     0,     0,   912,     0,     0,   913,     0,     0,   914,
       0,     0,     0,     0,     0,     0,  3052,     0,  3055,     0,
       0,     0,  -418,     0,     0,     0,     0,     0,  1947,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1947,     0,     0,
       0,     0,     0,     0,     0,  1600,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,     0,  1958,     0,     0,  1055,     0,     0,
       0,     0,     0,     0,     0,  1055,     0,  1055,     0,     0,
       0,   830,     0,     0,     0,  1947,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4280,  4281,  4282,  4283,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1958,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1949,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3244,     0,     0,     0,     0,     0,     0,  1958,     0,
       0,  1947,     0,     0,     0,     0,     0,     0,  3271,     0,
       0,     0,     0,  1196,     0,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,     0,     0,     0,  4431,     0,     0,
       0,     0,     0,     0,     0,     0,  1196,  1196,     0,     0,
       0,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,  1196,     0,
       0,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,  1196,  1196,  1196,     0,     0,
       0,     0,   830,  1949,     0,     0,     0,  1196,   830,     0,
    1196,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,  1196,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,  1947,     0,     0,     0,     0,     0,  1196,
       0,  1196,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3431,     0,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,  1196,  1196,  1196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1947,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1947,  1958,     0,     0,  1958,     0,  1958,     0,     0,     0,
       0,  1958,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,  1947,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1958,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1947,     0,     0,     0,
    1947,  1947,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1958,     0,     0,     0,     0,     0,  1949,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   830,
     830,   830,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4674,     0,     0,     0,     0,     0,     0,
       0,  1949,  1958,     0,  1958,     0,     0,  4677,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1949,     0,     0,     0,     0,  3660,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,  1958,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1958,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1958,  4745,     0,     0,     0,
    1949,     0,     0,     0,     0,     0,     0,   830,  1958,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1949,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,  1949,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1949,     0,     0,     0,     0,
       0,     0,  1958,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1958,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1958,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1949,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4843,  4845,  4845,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,  1055,     0,     0,     0,  1055,
    1196,     0,     0,  1958,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,  1196,     0,  1196,     0,
       0,     0,     0,  1958,  1196,  1192,     0,  1196,  1196,  1196,
    1196,  1196,  1196,  1196,  1196,  1196,  1196,     0,     0,     0,
    1196,  1196,     0,     0,     0,     0,     0,     0,  1958,     0,
       0,     0,     0,  1196,     0,     0,     0,  1196,     0,   830,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,  1196,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,  1958,  1196,  1196,  1196,     0,     0,
       0,  1196,     0,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4941,  1196,     0,     0,     0,     0,     0,  1196,  1196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1949,     0,     0,  3986,  3987,
       0,  1055,  1055,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,  3996,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,     0,  1196,     0,  1192,  4005,     0,
       0,     0,     0,     0,     0,     0,     0,  4014,  1192,     0,
       0,  1958,     0,     0,     0,  4990,     0,     0,     0,     0,
       0,  4030,     0,     0,     0,     0,     0,  1196,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5013,     0,  5015,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1600,     0,     0,     0,   830,     0,     0,     0,
       0,   830,  1958,   830,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4845,     0,
       0,  1949,     0,     0,     0,  1949,  1949,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   830,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1956,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  5121,     0,  4176,  4177,  4178,     0,     0,
       0,     0,  1196,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1958,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,     0,     0,     0,     0,     0,  5162,     0,     0,
    1192,  1192,     0,  1192,     0,     0,  1958,  1196,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    5201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,  1196,     0,  1192,  1192,
       0,     0,     0,     0,     0,     0,  1196,  1196,     0,  1958,
       0,     0,     0,     0,  1196,  1196,     0,     0,     0,  1196,
    1958,     0,     0,     0,     0,  1196,  1196,     0,  1949,  1196,
       0,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,  1196,     0,     0,     0,  1956,  1196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1055,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4413,
       0,     0,  1196,     0,  1055,     0,     0,     0,     0,     0,
       0,     0,  1956,     0,     0,     0,     0,     0,  4439,     0,
    1958,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   830,
       0,     0,     0,     0,  1956,  4456,     0,     0,  1958,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1958,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1949,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1958,     0,     0,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1956,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1956,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4560,  4561,  4562,  4563,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1958,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,  1956,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,     0,     0,
       0,  1958,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,  1196,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
    1196,     0,     0,  1196,     0,     0,     0,     0,  1196,  1196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,  1949,     0,     0,  1949,     0,
    1949,     0,     0,     0,     0,  1949,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,  1192,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,  1192,     0,
    1950,     0,  1192,  1958,     0,     0,     0,     0,     0,     0,
    1192,  1192,     0,  1196,     0,  1949,     0,     0,  1192,     0,
       0,  1192,  1192,  1192,  1192,     0,     0,     0,     0,     0,
       0,  1192,  1192,     0,  1192,     0,  1192,  1192,     0,     0,
    1192,     0,     0,     0,   830,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1949,  1956,  1192,     0,  1196,
       0,     0,  1192,     0,     0,     0,  1192,     0,     0,     0,
    1192,     0,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,
    1192,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,  1949,  1958,  1949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1196,
    1958,     0,  1196,     0,  1196,     0,  4768,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,  1950,     0,     0,     0,  1196,     0,     0,
       0,  1196,     0,  1949,     0,     0,  1958,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     830,     0,     0,     0,     0,     0,  1958,     0,     0,  1949,
    1958,  1958,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1949,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1956,     0,     0,     0,  1956,  1956,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1949,     0,     0,  1192,
    1958,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1192,     0,  1949,     0,     0,     0,     0,  1192,  1196,     0,
       0,  1196,     0,     0,     0,  1949,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1055,     0,
       0,     0,     0,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,  1956,     0,     0,     0,     0,     0,     0,  4898,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1949,     0,     0,
       0,  1196,     0,     0,     0,  1055,  1600,     0,     0,     0,
       0,     0,  1196,     0,     0,     0,     0,  1949,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1196,  1196,
       0,     0,     0,     0,     0,     0,     0,  1950,     0,     0,
       0,     0,  1949,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1950,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4993,     0,     0,     0,  1196,  1192,     0,  1956,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1950,     0,     0,     0,     0,     0,   830,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   930,     0,     0,     0,
       0,     0,     0,     0,     0,   930,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,   830,
       0,     0,     0,  1196,  1956,     0,     0,   830,     0,     0,
       0,     0,     0,     0,     0,  1949,     0,     0,     0,     0,
    1950,     0,     0,     0,   930,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,  1950,  1111,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1956,     0,     0,  1949,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,  1192,     0,     0,     0,     0,  1192,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,  1192,     0,     0,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
    1192,  1192,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,  1192,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,  1192,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,  1192,     0,     0,  1160,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1949,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,  1192,  1192,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1949,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1956,     0,     0,  1956,
       0,  1956,     0,     0,     0,     0,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,  1949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1949,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   930,   930,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1956,     0,  1956,
       0,     0,     0,     0,  1949,     0,     0,     0,     0,     0,
       0,  1950,     0,     0,     0,  1950,  1950,     0,     0,     0,
       0,     0,  1160,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1949,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,     0,     0,  1956,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1956,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1949,
    1956,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1956,     0,     0,     0,     0,     0,     0,
       0,  1950,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1237,  1238,     0,  1241,     0,     0,  1247,
       0,  1249,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1956,     0,     0,
    1301,     0,     0,     0,     0,     0,     0,     0,  1309,     0,
       0,     0,     0,  1956,     0,     0,     0,  1325,  1326,     0,
       0,     0,  1328,     0,     0,     0,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1160,
       0,   930,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,  1359,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1382,     0,  1949,  1384,     0,  1386,     0,
    1389,     0,     0,     0,     0,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,   930,  1192,     0,     0,  1956,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,  1192,     0,  1192,     0,     0,     0,     0,  1956,  1192,
       0,     0,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,
    1192,  1192,     0,     0,     0,  1192,  1192,     0,     0,     0,
       0,     0,     0,  1956,     0,     0,     0,     0,  1192,  1469,
       0,  1470,  1192,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,  1950,     0,     0,  1192,     0,     0,  1192,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,  1956,
    1192,  1192,  1192,     0,  1160,     0,  1192,     0,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,  1949,     0,     0,
       0,     0,     0,  1192,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
    1111,     0,     0,  1192,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1950,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1732,     0,  1734,     0,     0,  1956,  1736,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,  1192,     0,     0,     0,     0,  1765,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1949,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
    1949,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1903,     0,     0,  1956,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1913,     0,     0,
       0,     0,     0,     0,  1915,     0,     0,     0,     0,     0,
    1949,     0,     0,     0,  1949,  1949,  1964,     0,     4,  1968,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,  2011,     0,     8,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,    36,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1950,     0,     0,  1950,     0,
    1950,     0,     0,     0,  1956,  1950,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1956,  1192,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,     0,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,    50,     0,     0,
       0,  1192,  1192,     0,  1956,     0,  1950,     0,  1950,  1192,
    1192,     0,     0,     0,  1192,  1956,     0,     0,     0,     0,
    1192,  1192,     0,     0,  1192,     0,     0,  1192,     0,     0,
       0,     0,     0,    51,     0,     0,    52,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,    53,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1950,  1192,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,  1192,     0,     0,  1111,  2329,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,     0,  1950,     0,     0,     0,     0,    54,     0,     0,
       0,     0,     0,     0,     0,  1956,  2400,     0,     0,  2400,
       0,     0,     0,     0,     0,     0,     0,  2407,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1956,     0,  2416,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1956,    56,     0,     0,  1950,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    57,     0,
       0,     0,  1950,  2499,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
    1956,     0,     0,    59,     0,     0,     0,    60,    61,    62,
      63,    64,     0,     0,    65,    66,    67,    68,     0,    69,
      70,    71,    72,    73,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1950,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,     0,     0,  1950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1950,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1956,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,  1956,     0,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2700,     0,     0,     0,     0,  1192,  1192,
       0,     0,  1192,     0,     0,     0,     0,     0,  2723,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,  1192,     0,     0,  1192,     0,
       0,     0,     0,  1192,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2771,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,  1952,     0,  2786,
       0,  2788,     0,  2789,     0,  1950,     0,     0,  2790,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1956,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2329,
       0,     0,     0,  2329,     0,  2329,     0,     0,  2329,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1192,     0,  1956,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1952,     0,     0,     0,  1192,  1956,     0,  1192,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,  1192,     0,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3033,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1956,     0,  1950,     0,  1956,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1950,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1956,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1160,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3133,  3134,     0,  1950,     0,  3137,  3138,     0,     0,  3141,
       0,  1197,     0,     0,  1950,     0,     0,     0,     0,  3151,
    1197,     0,     0,     0,     0,     0,  3160,     0,     0,     0,
    3163,  3164,     0,     0,  3167,  3168,  1192,     0,     0,     0,
       0,  3173,     0,     0,  1952,     0,     0,  1192,     0,     0,
       0,     0,     0,  3189,  1197,  3191,     0,     0,     0,     0,
       0,     0,     0,  1192,  1192,     0,     0,     0,     0,     0,
       0,  3213,     0,     0,     0,     0,  3215,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,  3220,
       0,     0,     0,     0,     0,     0,     0,  3225,  1952,  3227,
    3228,  3231,  3233,     0,     0,     0,  3240,  3243,     0,     0,
       0,  1197,     0,     0,  3254,     0,     0,     0,  3263,     0,
       0,  1197,  3267,     0,     0,     0,     0,  1192,     0,     0,
    1952,     0,     0,     0,  1950,     0,     0,     0,     0,     0,
       0,  1192,     0,     0,     0,  3296,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3303,     0,  3305,     0,
       0,     0,  1950,  3308,     0,     0,     0,  3309,     0,  3313,
    3314,  3315,  3316,     0,  3318,     0,     0,     0,     0,     0,
       0,  1950,     0,     0,     0,     0,     0,  3342,  3343,  3344,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3352,  3353,     0,     0,     0,     0,     0,  1952,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,  1952,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,  1952,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3407,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1952,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1160,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,     0,  2329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3534,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,  1567,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1959,
       0,     0,     0,     0,     0,     0,     0,  1641,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,  1950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1952,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3715,  1950,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1959,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1950,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1950,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,  3761,  3762,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2329,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,  1197,
    1950,  1197,     0,     0,  1950,  1950,     0,     0,  1952,     0,
       0,     0,  1952,  1952,  3784,     0,     0,     0,     0,     0,
    1197,     0,     0,  3788,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3799,  3801,
       0,     0,     0,  3801,     0,     0,     0,     0,  3812,  3813,
    3814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,  3834,  3835,
    3836,  3837,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,     0,     0,     0,  1197,  1197,     0,     0,
       0,     0,  3851,     0,  3855,  3856,  3857,     0,  1952,     0,
       0,     0,     0,     0,  3870,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2164,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2188,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1959,     0,     0,  3911,
       0,     0,     0,     0,     0,     0,     0,  3915,     0,     0,
       0,     0,  2213,  2214,     0,  2217,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2259,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1959,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3983,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,  1959,     0,     0,     0,     0,  2313,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4012,     0,     0,  4015,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2336,     0,     0,     0,
    2348,  2351,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   930,     0,     0,
    4055,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1952,     0,     0,     0,  4065,     0,     0,     0,     0,  1959,
       0,     0,     0,     0,     0,     0,     0,  2329,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1959,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1959,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1197,     0,     0,     0,     0,     0,  1959,     0,     0,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,  1197,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,  1197,     0,  1953,     0,
    1197,     0,  4274,     0,  4275,     0,     0,     0,  1197,  1197,
       0,  4277,     0,     0,     0,     0,  1197,     0,     0,  1197,
    1197,  1197,  1197,     0,     0,     0,     0,  4286,     0,  1197,
    1197,     0,  1197,     0,  1197,  1197,     0,     0,  1197,     0,
       0,     0,  4294,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4305,     0,  1959,  1197,     0,     0,     0,     0,
    1197,     0,     0,     0,  1197,     0,     0,  4308,  1197,     0,
    1197,  1197,  1197,  1197,  1197,  1197,  1197,  1197,  1197,     0,
    1197,     0,  1952,     0,     0,  1952,     0,  1952,     0,     0,
    1197,  1197,  1952,     0,     0,     0,     0,     0,     0,     0,
    4340,  4341,  4342,     0,     0,  4345,  4346,  4347,  4348,  4349,
       0,     0,     0,     0,  4356,  4357,     0,  4359,  4360,  4361,
    4362,  4363,  4364,  4365,     0,     0,     0,     0,     0,     0,
       0,     0,  4373,     0,  4375,  4376,     0,     0,     0,     0,
       0,     0,  1952,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,  1953,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1952,     0,  4425,  4427,  4429,     0,     0,  4432,
       0,     0,     0,     0,     0,     0,     0,  2896,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2919,     0,     0,  2921,     0,     0,  2932,     0,     0,     0,
       0,     0,     0,  2939,  2944,     0,     0,     0,     0,  2950,
       0,     0,  2955,  1952,     0,  1952,     0,     0,     0,     0,
    1959,     0,     0,     0,  1959,  1959,     0,     0,     0,  2964,
       0,     0,     0,     0,  2971,     0,     0,     0,  2983,     0,
       0,  3801,  2990,     0,  2992,  2993,  2994,  2995,  2996,  2997,
    2998,  2999,  3000,     0,  3001,     0,     0,     0,     0,     0,
       0,  2329,  2329,  2329,  1567,  3029,     0,  1197,     0,     0,
    1952,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1952,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1641,     0,  1952,
    1959,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1952,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1953,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1952,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3165,     0,     0,     0,  1197,     0,  1959,     0,  4634,
    4635,  4636,  4637,     0,     0,  4639,     0,     0,     0,     0,
       0,  1953,     0,     0,  1952,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4652,  4653,  4654,  4655,
       0,  4657,  4658,     0,  1952,     0,     0,     0,     0,     0,
       0,     0,     0,  4667,  4668,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4670,     0,     0,  1952,
       0,     0,  2329,  2329,     0,  2329,     0,     0,     0,     0,
       0,     0,  1959,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1953,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1953,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,     0,     0,     0,  1953,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1953,     0,     0,     0,     0,     0,     0,
    4732,     0,     0,     0,     0,     0,     0,     0,     0,  4738,
       0,  1959,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
    4757,     0,  1197,     0,     0,     0,     0,     0,     0,  3382,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
    1197,     0,  1952,     0,  4776,  1197,  1953,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,  1197,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,  1197,  1197,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,     0,  1197,     0,  1197,     0,     0,     0,     0,
       0,  2329,     0,     0,     0,  1197,  1197,     0,     0,  1197,
       0,     0,     0,     0,  2329,     0,     0,     0,     0,     0,
       0,     0,  1197,  1952,  1197,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3506,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
    1197,  1197,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4860,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,  1197,  4871,     0,  1954,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1953,  3555,     0,     0,     0,     0,  3561,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,  1959,     0,  1959,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,     0,
    1952,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2944,     0,  2944,  2944,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,  3618,     0,     0,  3621,     0,  3623,
       0,  3801,     0,     0,     0,     0,     0,  1952,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3644,     0,  3646,     0,
       0,     0,  3649,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2329,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2329,     0,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3029,  3029,  3029,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2253,     0,     0,  4996,     0,     0,     0,  3712,     0,
       0,     0,     0,  5003,     0,     0,     0,     0,     0,     0,
       0,  2336,     0,     0,     0,     0,  3724,     0,  2329,     0,
       0,     0,  2351,     0,     0,  1959,     0,  1959,     0,     0,
    1952,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,  1952,     0,  1953,  1953,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2253,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1959,     0,     0,     0,     0,     0,     0,  1954,
       0,     0,  3801,     0,     0,     0,     0,     0,     0,     0,
       0,  3770,     0,     0,     0,     0,     0,  1959,     0,     0,
       0,     0,     0,     0,     0,  2329,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1959,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  5094,
       0,  1959,     0,  1954,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,  5105,     0,     0,     0,     0,     0,     0,
       0,  1952,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1954,     0,     0,  5116,     0,
       0,     0,     0,  5120,     0,     0,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1959,     0,     0,  1952,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1959,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,     0,  5157,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,  1952,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,  1954,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1954,
       0,     0,     0,     0,     0,     0,  1953,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,  1959,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,  1954,     0,  1197,
       0,  1197,     0,     0,     0,     0,  1959,  1197,     0,     0,
    1197,  1197,  1197,  1197,  1197,  1197,  1197,  1197,  1197,  1197,
       0,     0,     0,  1197,  1197,     0,     0,     0,     0,     0,
       0,  1959,     0,     0,     0,     0,  1197,     0,     0,     0,
    1197,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,  1953,     0,     0,  1197,     0,     0,  1197,     0,  1197,
    1954,     0,     0,     0,     0,     0,     0,  1959,  1197,  1197,
    1197,     0,     0,     0,  1197,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1197,  1952,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,  1197,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,  2253,     0,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,  4096,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4100,     0,     0,
    1197,     0,     0,  4101,     0,  4102,     0,     0,     0,     0,
       0,     0,     0,     0,  1952,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4120,  4121,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2950,     0,
       0,     0,     0,     0,     0,     0,     0,  1954,  4149,     0,
       0,  4152,     0,  4154,     0,     0,     0,     0,  2253,     0,
       0,     0,  4158,     0,     0,  1959,     0,     0,  4163,     0,
       0,  4166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2253,     0,     0,     0,     0,  2928,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4207,
       0,     0,     0,     0,     0,  4214,  3029,  2253,  2253,     0,
       0,  2253,     0,     0,     0,     0,     0,     0,  1952,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1952,     0,     0,     0,     0,     0,     0,     0,     0,
    4229,     0,     0,  2253,     0,     0,  1567,     0,     0,     0,
       0,     0,  1641,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1952,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1953,     0,     0,  1953,  2253,  1953,     0,
       0,     0,  1959,  1953,     0,     0,     0,  1952,     0,     0,
       0,  1952,  1952,     0,     0,     0,     0,     0,     0,     0,
    2253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2253,  1954,     0,  2253,     0,  1954,  1954,  1959,
    1197,  1197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1953,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1953,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,  1954,     0,     0,     0,     0,     0,  1197,
    1197,     0,  1959,     0,  1953,     0,  1953,  1197,  1197,     0,
       0,     0,  1197,  1959,     0,     0,     0,     0,  1197,  1197,
       0,     0,  1197,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1953,  1197,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1953,     0,     0,     0,
       0,     0,     0,     0,  4486,  4487,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1953,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
    1953,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1959,     0,     0,     0,     0,     0,     0,
    1954,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4519,     0,     0,     0,
       0,  1959,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1959,     0,     0,     0,  1953,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,  4537,  4539,     0,     0,     0,     0,     0,
       0,     0,     0,  1953,     0,  1954,  4546,     0,     0,     0,
       0,     0,  4551,  4552,     0,     0,  4554,     0,  1959,  4557,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3029,     0,     0,     0,
       0,  3029,     0,     0,     0,     0,  3029,     0,     0,     0,
       0,     0,     0,     0,     0,  1953,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,  1953,     0,     0,     0,     0,
       0,     0,     0,     0,  1954,     0,     0,     0,     0,  4615,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1959,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1953,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,     0,     0,  1959,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,  1197,     0,     0,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,  1197,     0,
    2253,     0,     0,  1197,     0,     0,  1197,     0,     0,     0,
       0,  1197,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2253,     0,  2253,     0,  2928,  2928,  3592,
       0,     0,  2928,     0,     0,     0,  2253,     0,     0,     0,
       0,     0,     0,  2253,  1197,     0,     0,     0,  2253,     0,
       0,     0,     0,  1953,  2253,     0,     0,     0,     0,  2253,
       0,  4718,     0,     0,     0,     0,     0,     0,  2253,     0,
       0,     0,  2928,  2928,     0,  2253,  1959,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,  2253,     0,     0,
       0,     0,     0,     0,  2253,     0,  2253,  2253,  2253,  2253,
    2253,  2253,  2253,  2253,  2253,  2253,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,  2253,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1953,     0,     0,  1954,     0,     0,
    1954,     0,  1954,     0,     0,     0,     0,  1954,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4802,     0,     0,     0,  1197,     0,
    1959,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1954,     0,     0,
       0,     0,  1197,  1959,     0,  1197,  4825,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,     0,     0,  1197,     0,     0,  1954,     0,  1959,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2253,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1959,
       0,  1953,     0,  1959,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1954,     0,
    1954,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1953,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1954,     0,     0,     0,     0,
       0,     0,     0,  1959,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1954,  1197,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1954,     0,     0,     0,     0,     0,     0,     0,  2950,
       0,     0,     0,     0,  1954,     0,  1197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1953,     0,     0,  4972,     0,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,  2253,     0,  1954,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1197,  1197,     0,  1954,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1954,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  5046,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1954,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,     0,     0,     0,     0,     0,     0,  1954,
    2253,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    5095,     0,     0,     0,  1954,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,  2253,
       0,     0,     0,     0,     0,  2253,     0,  1953,     0,     0,
    1954,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3592,  3592,     0,  2928,     0,     0,  2928,  2928,  2928,
    2928,  2928,  2928,  2928,  2928,  2928,  2928,  3592,     0,     0,
       0,     0,     0,     0,     0,  5141,  5141,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2253,     0,     0,  2253,     0,  2253,     0,     0,
       0,     0,  3592,  3592,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2928,  2928,  2253,     0,
    2253,     0,     0,  2253,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  5141,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  5197,     0,     0,     0,  1954,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2253,     0,     0,     0,
       0,     0,     0,  1953,     0,     0,     0,     0,  2253,     0,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  5141,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,  2253,     9,    10,     0,  1954,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1953,     0,     0,     0,     0,
       0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     0,     0,    46,     0,     0,     0,
       9,    10,     0,     0,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1954,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,     0,     0,     0,     0,  1953,
       0,    46,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2928,     0,    49,     0,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1953,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,    51,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      53,     0,     0,     0,     0,     0,     0,     0,  1953,     0,
       0,     0,  1953,  1953,     0,     0,     0,     0,     0,    49,
       0,     0,     0,     0,     0,  1954,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1954,     0,     0,     0,
       0,    50,     0,     0,     0,     0,     0,     0,     0,     0,
    2253,     0,     0,     0,  2253,  2253,  2253,     0,     0,  3592,
       0,     0,     0,     0,  3592,  3592,  3592,  3592,  3592,  3592,
    3592,  3592,  3592,  3592,  2253,  2253,    54,    51,     0,     0,
      52,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    53,     0,     0,     0,     0,
       0,     0,     0,  2253,  2928,  2928,  2253,     0,  2253,     0,
       0,     0,  2253,  3592,  3592,     0,     0,  2253,    55,     0,
    2253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    56,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    57,     0,     0,
       0,     0,     0,     0,     0,     0,  1954,     0,     0,     0,
       0,  2253,     0,     0,     0,     0,     0,     0,  2253,     0,
       0,    54,     0,     0,     0,    58,     0,     0,     0,     0,
       0,     0,    59,  2253,  1954,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1397,     0,     0,     0,     0,
      71,  1398,     0,  1954,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    57,     0,     0,     0,     0,     0,     0,     0,
       0,  1954,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1397,  2066,     0,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,     0,
      35,     0,     0,     0,     0,     0,     0,  3592,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1954,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
    2253,  2253,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,   145,     0,     0,     0,     0,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     151,     0,     0,  2253,     0,     0,   152,  2928,     0,     0,
       0,     0,     0,     0,     0,     0,   155,   156,     0,     0,
       0,  2253,     0,  2253,     0,     0,     0,     0,  3592,  3592,
    2253,     0,     0,  2928,  2928,  2253,  2253,     0,  2253,     0,
       0,  2253,     0,   162,     0,     0,     0,     0,     0,     0,
       0,   164,     0,     0,     0,   166,     0,     0,     0,  1954,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,  2253,
       0,     0,     0,     0,   176,     0,   177,     0,     0,   178,
     179,     0,   180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   193,     0,     0,   194,     0,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1954,   196,   197,     0,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,     0,     0,     0,     0,  1954,     0,     0,     0,
       0,     0,  2253,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   210,     0,     0,   212,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,     0,     0,  3592,  2928,
       0,     0,  1954,   224,   225,     0,  1954,  1954,   226,     0,
     227,     0,     0,     0,  3592,  3592,  2253,     0,     0,   230,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   234,     0,     0,   235,     0,  2253,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   237,   238,   239,   240,   241,   242,   243,
     244,   245,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3096,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3592,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2253,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2253,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,  2253,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,  2253,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,   739,   427,   428,   429,   740,   741,
     742,   743,   744,   745,   746,   430,   431,   747,   432,   433,
     133,   434,   435,   436,   135,   136,   137,   138,   139,   748,
     437,   438,   439,   440,   441,   749,   750,   442,   443,   751,
     140,   444,   752,   445,   446,   447,   448,   144,   753,   145,
     754,   449,   450,   451,   452,   148,   453,   755,   756,   454,
     455,   456,   457,   458,   459,   757,   151,   460,   758,   759,
     760,   761,   152,   762,   763,   764,   461,   462,   463,   464,
     701,   465,   155,   156,   466,   765,   467,   766,   468,   469,
     470,   471,   472,   767,   473,   474,   475,   768,   769,   476,
     477,   478,   479,   480,   770,   481,   482,   483,   771,   484,
     485,   486,   772,   487,   488,   489,   490,   164,   491,   492,
     493,   166,   773,   494,   774,   495,   496,   168,   497,   775,
     498,   776,   499,   169,   777,   170,   500,   501,   502,   778,
     503,   172,   779,   504,   780,   505,   506,   703,   507,   508,
     173,   509,   510,   511,   781,   512,   513,   514,   515,   516,
     517,   782,   518,   174,   175,   783,   519,   520,   521,   784,
     176,   785,   177,   786,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,   787,   529,   530,   788,   531,   181,
     182,   532,   183,   789,   533,   534,   535,   790,   791,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,   189,   190,   547,   548,   191,   792,   549,
     550,   193,   551,   793,   194,   552,   195,   553,   554,   555,
     794,   556,   795,   796,   557,   558,   559,   797,   798,   560,
     196,   197,   561,   198,   199,   562,   563,   564,   565,   566,
     567,   568,   799,   569,   200,   570,   201,   571,   572,   573,
     800,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,   801,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   802,   597,   598,   210,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,   803,   608,   609,   610,   611,   612,   804,   613,   217,
     614,   615,   219,   616,   220,   617,   805,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   806,   628,
     629,   807,   630,   631,   632,   633,   634,   635,   808,   224,
     225,   809,   810,   637,   226,   638,   227,   811,   639,   640,
     641,   642,   643,   644,   645,   812,   813,   646,   647,   648,
     649,   650,   814,   815,   651,   652,   653,   654,   655,   816,
     234,   817,   656,   235,   657,   658,   659,   660,   818,   819,
     661,   820,   821,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,    85,     0,     0,    86,    87,    88,    89,    90,
      91,    92,    93,     0,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   975,   104,   105,   106,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,   119,   120,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,   127,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     129,     0,   130,   131,     0,     0,     0,     0,     0,     0,
       0,     0,   132,     0,   133,     0,     0,   134,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,   141,     0,   142,
     143,   144,     0,   145,     0,   146,     0,   147,     0,   148,
       0,     0,     0,     0,     0,     0,     0,   149,     0,   150,
     151,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,     0,     0,   153,     0,   154,   155,   156,   157,     0,
       0,     0,     0,     0, -1424,     0,     0,     0,     0,     0,
     158,     0,   159,     0,     0,     0,   160,     0,     0,     0,
       0,     0,   161,   162,     0,     0,     0,     0,     0,     0,
     163,   164,   165,     0,     0,   166,     0,     0,   167,     0,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,   171,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0, -1424,     0,     0,   176,     0,   177,     0,     0,   178,
     179,     0,   180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,   184,   185,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,   187,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,   192,   193,     0,     0,   194,     0,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,   197,     0,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,   208,     0,     0,
       0,     0,   209,   210,     0,   211,   212,     0,     0,   213,
       0,     0,     0,     0,   214,   215,     0,     0,     0,     0,
       0,     0,   216,   217,     0,   218,   219,     0,   220,     0,
       0,     0,     0,   221,     0,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,   223,     0,     0,     0,     0,
       0,     0,     0,   224,   225,     0,     0,     0,   226,     0,
     227,     0,   228,     0,   229,     0,     0,     0,     0,   230,
       0,     0,   231,     0,     0, -1424,     0,     0,   232,     0,
       0,     0,     0,   233,   234,     0,     0,   235,     0,     0,
       0,     0,     0,     0,     0,     0,   236,     0,     0,     0,
       0,     0,     0,   237,   238,   239,   240,   241,   242,   243,
     244,   245,     0,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   246,   104,   105,     0,  -138,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,   145,     0,     0,     0,     0,     0,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,   166,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   181,   182,     0,   183,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,     0,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
       0,     0,     0,     0,     0,     0,     0,   230,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   234,     0,     0,   235,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,   237,   238,   239,   240,   241,   242,   243,   244,   245,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     0,     0,     9,    10,     0,  3098,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,    46,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,     0,     0,
       0,    51,     0,     0,    52,     0,     0,     0,     0,     0,
       0,     0,    48,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    58,     0,     0,     0,     0,     0,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1397,  2799,     0,     0,     0,    71,
       0,     0,     0,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      56,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    57,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    58,     0,     0,     0,     0,     0,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1397,     0,     0,     0,     0,    71,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1486,  1487,  1488,
      45,  1489,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  3023,   427,   428,   429,     0,     0,     0,
       0,  1490,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1491,   137,  1492,  1493,     0,   437,
     438,   439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,
     444,     0,   445,   446,   447,   448,  1498,     0,  1499,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1500,  1501,
    1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,
     465,  1507,  1508,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,  3024,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1510,   491,   492,   493,
    1511,  1512,   494,     0,   495,   496,  1513,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1514,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1515,  1516,
       0,  1517,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1518,   182,
     532,   183,     0,   533,   534,   535,  1519,  1520,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1521,   189,  1522,   547,   548,   191,  1523,   549,   550,
     193,   551,  1524,  1525,   552,  1526,   553,   554,   555,     0,
     556,     0,     0,  1527,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1528,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1529,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1530,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1531,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1532,   613,   217,   614,
     615,   219,   616,  1533,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1534,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1535,  1536,
       0,     0,   637,  1537,   638,  1538,  1539,   639,   640,   641,
     642,   643,   644,   645,     0,  1540,   646,   647,   648,   649,
     650,  1541,     0,   651,   652,   653,   654,   655,   707,  1542,
    3025,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,  1552,
    3026,     0,     0,     0,     0,     0,     0,  1554,  3027,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1486,  1487,  1488,
      45,  1489,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1490,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1491,   137,  1492,  1493,     0,   437,
     438,   439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,
     444,     0,   445,   446,   447,   448,  1498,     0,  1499,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1500,  1501,
    1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,
     465,  1507,  1508,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1510,   491,   492,   493,
    1511,  1512,   494,     0,   495,   496,  1513,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1514,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1515,  1516,
       0,  1517,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1518,   182,
     532,   183,     0,   533,   534,   535,  1519,  1520,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1521,   189,  1522,   547,   548,   191,  1523,   549,   550,
     193,   551,  1524,  1525,   552,  1526,   553,   554,   555,     0,
     556,     0,     0,  1527,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1528,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1529,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1530,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1531,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1532,   613,   217,   614,
     615,   219,   616,  1533,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1534,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1535,  1536,
       0,     0,   637,  1537,   638,  1538,  1539,   639,   640,   641,
     642,   643,   644,   645,     0,  1540,   646,   647,   648,   649,
     650,  1541,     0,   651,   652,   653,   654,   655,   707,  1542,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,  1552,
       0,     0,     0,     0,     0,     0,     0,  1554,  2930,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1925,   137,  1926,  1927,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1928,  1929,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,  1930,  1931,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,  1932,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,  2419,   512,   513,   514,   515,   516,   517,
       0,   518,   174,  2420,     0,   519,   520,   521,  1515,  1933,
       0,  1934,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1935,   189,  1936,   547,   548,     0,     0,   549,   550,
     193,   551,     0,     0,   552,  1937,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,  2422,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1938,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,  2423,   614,
     615,   219,   616,  1940,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1941,  1942,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,  1943,
    2424,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
       0,     0,     0,     0,     0,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,  2522,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
    1925,   137,  1926,  1927,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1928,  1929,   444,     0,   445,   446,
     447,   448,     0,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,  1930,  1931,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1509,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,     0,   491,   492,   493,     0,     0,   494,     0,
     495,   496,  1932,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,  2419,
     512,   513,   514,   515,   516,   517,     0,   518,   174,  2420,
       0,   519,   520,   521,  1515,  1933,     0,  1934,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,     0,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1935,   189,  1936,
     547,   548,     0,     0,   549,   550,   193,   551,     0,     0,
     552,  1937,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,  2422,   197,   561,   198,     0,
     562,   563,   564,   565,   566,   567,   568,     0,   569,     0,
     570,     0,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1938,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,  2423,   614,   615,   219,   616,  1940,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1941,  1942,     0,     0,   637,     0,
     638,     0,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,  1943,  2424,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,   668,   669,     0,     0,     0,     0,
       0,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,  3468,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1486,
    1487,  1488,    45,  1489,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1490,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,  1491,   137,  1492,  1493,
    2940,   437,   438,   439,   440,   441,  1494,  1495,   442,   443,
    1496,  1497,   444,     0,   445,   446,   447,   448,  1498,     0,
    1499,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
    1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,
     464,   701,   465,  1507,  1508,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1509,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,  1510,   491,
     492,   493,  1511,  1512,   494,     0,   495,   496,  1513,   497,
       0,   498,     0,   499,   169,  2941,   170,   500,   501,   502,
       0,   503,  1514,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1515,  1516,     0,  1517,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,  2942,   531,
    1518,   182,   532,   183,     0,   533,   534,   535,  1519,  1520,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1521,   189,  1522,   547,   548,   191,  1523,
     549,   550,   193,   551,  1524,  1525,   552,  1526,   553,   554,
     555,     0,   556,     0,     0,  1527,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1528,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1529,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1530,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1531,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1532,   613,
     217,   614,   615,   219,   616,  1533,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1534,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1535,  1536,     0,  2943,   637,  1537,   638,  1538,  1539,   639,
     640,   641,   642,   643,   644,   645,     0,  1540,   646,   647,
     648,   649,   650,  1541,     0,   651,   652,   653,   654,   655,
     707,  1542,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1551,  1552,     0,     0,     0,     0,     0,     0,     0,  1554,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1486,  1487,
    1488,    45,  1489,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1490,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,  1491,   137,  1492,  1493,     0,
     437,   438,   439,   440,   441,  1494,  1495,   442,   443,  1496,
    1497,   444,     0,   445,   446,   447,   448,  1498,     0,  1499,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1500,
    1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,
     701,   465,  1507,  1508,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1509,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1510,   491,   492,
     493,  1511,  1512,   494,     0,   495,   496,  1513,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1514,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1515,
    1516,     0,  1517,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1518,
     182,   532,   183,     0,   533,   534,   535,  1519,  1520,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1521,   189,  1522,   547,   548,   191,  1523,   549,
     550,   193,   551,  1524,  1525,   552,  1526,   553,   554,   555,
       0,   556,     0,     0,  1527,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1528,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1529,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1530,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1531,   601,   602,   603,   604,   605,   606,   706,
     607,   215,   608,   609,   610,   611,   612,  1532,   613,   217,
     614,   615,   219,   616,  1533,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1534,     0,   628,
     629,   223,   630,   631,   632,   633,   634,   635,     0,  1535,
    1536,     0,     0,   637,  1537,   638,  1538,  1539,   639,   640,
     641,   642,   643,   644,   645,     0,  1540,   646,   647,   648,
     649,   650,  1541,     0,   651,   652,   653,   654,   655,  2215,
    1542,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,   236,   662,   663,   664,   665,   666,   667,   237,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,
     669,     0,     0,     0,     0,     0,     0,     0,     0,  1551,
    1552,     0,     0,     0,     0,     0,     0,     0,  1554,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1486,  1487,  1488,
      45,  1489,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1490,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1491,   137,  1492,  1493,     0,   437,
     438,   439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,
     444,     0,   445,   446,   447,   448,  1498,     0,  1499,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1500,  1501,
    1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,
     465,  1507,  1508,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1510,   491,   492,   493,
    1511,  1512,   494,     0,   495,   496,  1513,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1514,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1515,  1516,
       0,  1517,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1518,   182,
     532,   183,     0,   533,   534,   535,  1519,  1520,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1521,   189,  1522,   547,   548,   191,  1523,   549,   550,
     193,   551,  1524,  1525,   552,  1526,   553,   554,   555,     0,
     556,     0,     0,  1527,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1528,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1529,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1530,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1531,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1532,   613,   217,   614,
     615,   219,   616,  1533,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1534,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1535,  1536,
       0,     0,   637,  1537,   638,  1538,  1539,   639,   640,   641,
     642,   643,   644,   645,     0,  1540,   646,   647,   648,   649,
     650,  1541,     0,   651,   652,   653,   654,   655,   707,  1542,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,  1552,
       0,     0,     0,     0,     0,  2159,  2888,  1554,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1486,  1487,  1488,    45,
    1489,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
    1490,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,  1491,   137,  1492,  1493,     0,   437,   438,
     439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,   444,
       0,   445,   446,   447,   448,  1498,     0,  1499,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1500,  1501,  1502,
    1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,   465,
    1507,  1508,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1509,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,  1510,   491,   492,   493,  1511,
    1512,   494,     0,   495,   496,  1513,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1514,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,  1515,  1516,     0,
    1517,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1518,   182,   532,
     183,     0,   533,   534,   535,  1519,  1520,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1521,   189,  1522,   547,   548,   191,  1523,   549,   550,   193,
     551,  1524,  1525,   552,  1526,   553,   554,   555,     0,   556,
       0,     0,  1527,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1528,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1529,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1530,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
    1531,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1532,   613,   217,   614,   615,
     219,   616,  1533,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1534,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1535,  1536,     0,
       0,   637,  1537,   638,  1538,  1539,   639,   640,   641,   642,
     643,   644,   645,     0,  1540,   646,   647,   648,   649,   650,
    1541,     0,   651,   652,   653,   654,   655,   707,  1542,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,
       0,     0,     0,     0,     0,     0,     0,  1551,  1552,  1553,
       0,     0,     0,     0,     0,     0,  1554,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,   418,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1486,  1487,  1488,    45,  1489,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,  1490,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,  1491,   137,  1492,  1493,     0,   437,   438,   439,
     440,   441,  1494,  1495,   442,   443,  1496,  1497,   444,     0,
     445,   446,   447,   448,  1498,     0,  1499,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,  1500,  1501,  1502,  1503,
    1504,  1505,  1506,   461,   462,   463,   464,   701,   465,  1507,
    1508,   466,  1640,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1509,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,  1510,   491,   492,   493,  1511,  1512,
     494,     0,   495,   496,  1513,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1514,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,  1515,  1516,     0,  1517,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,  1518,   182,   532,   183,
       0,   533,   534,   535,  1519,  1520,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1521,
     189,  1522,   547,   548,   191,  1523,   549,   550,   193,   551,
    1524,  1525,   552,  1526,   553,   554,   555,     0,   556,     0,
       0,  1527,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1528,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1529,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1530,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,  1531,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,  1532,   613,   217,   614,   615,   219,
     616,  1533,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1534,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1535,  1536,     0,     0,
     637,  1537,   638,  1538,  1539,   639,   640,   641,   642,   643,
     644,   645,     0,  1540,   646,   647,   648,   649,   650,  1541,
       0,   651,   652,   653,   654,   655,   707,  1542,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,  1543,  1544,  1545,
    1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,     0,
       0,     0,     0,     0,     0,     0,  1551,  1552,     0,     0,
       0,     0,     0,     0,     0,  1554,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1486,  1487,  1488,    45,  1489,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
    2346,   427,   428,   429,     0,     0,     0,     0,  1490,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,  1491,   137,  1492,  1493,     0,   437,   438,   439,   440,
     441,  1494,  1495,   442,   443,  1496,  1497,   444,     0,   445,
     446,   447,   448,  1498,     0,  1499,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,  1500,  1501,  1502,  1503,  1504,
    1505,  1506,   461,   462,   463,   464,   701,   465,  1507,  1508,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1509,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,  1510,   491,   492,   493,  1511,  1512,   494,
       0,   495,   496,  1513,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1514,     0,   504,
       0,   505,   506,   703,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,  1515,  1516,     0,  1517,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,  1518,   182,   532,   183,     0,
     533,   534,   535,  1519,  1520,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1521,   189,
    1522,   547,   548,   191,  1523,   549,   550,   193,   551,  1524,
    1525,   552,  1526,   553,   554,   555,     0,   556,     0,     0,
    1527,   558,   559,     0,     0,   560,   196,   197,   561,   198,
    1528,   562,   563,   564,   565,   566,   567,   568,     0,   569,
    1529,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1530,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,  1531,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,  1532,   613,   217,   614,   615,   219,   616,
    1533,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1534,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1535,  1536,     0,     0,   637,
    1537,   638,  1538,  1539,   639,   640,   641,   642,   643,   644,
     645,     0,  1540,   646,   647,   648,   649,   650,  1541,     0,
     651,   652,   653,   654,   655,   707,  1542,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,  1543,  1544,  1545,  1546,
    1547,  1548,  1549,  1550,   708,   668,   669,     0,     0,     0,
       0,     0,     0,     0,     0,  1551,  1552,     0,     0,     0,
       0,     0,     0,     0,  1554,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1486,  1487,  1488,    45,  1489,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1490,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1491,   137,  1492,  1493,     0,   437,   438,   439,   440,   441,
    1494,  1495,   442,   443,  1496,  1497,   444,     0,   445,   446,
     447,   448,  1498,     0,  1499,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,
    1506,   461,   462,   463,   464,   701,   465,  1507,  1508,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1509,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1510,   491,   492,   493,  1511,  1512,   494,     0,
     495,   496,  1513,   497,     0,   498,     0,   499,   169,  2941,
     170,   500,   501,   502,     0,   503,  1514,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1515,  1516,     0,  1517,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1518,   182,   532,   183,     0,   533,
     534,   535,  1519,  1520,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1521,   189,  1522,
     547,   548,   191,  1523,   549,   550,   193,   551,  1524,  1525,
     552,  1526,   553,   554,   555,     0,   556,     0,     0,  1527,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1528,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1529,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1530,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1531,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1532,   613,   217,   614,   615,   219,   616,  1533,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1534,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1535,  1536,     0,     0,   637,  1537,
     638,  1538,  1539,   639,   640,   641,   642,   643,   644,   645,
       0,  1540,   646,   647,   648,   649,   650,  1541,     0,   651,
     652,   653,   654,   655,   707,  1542,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,  1550,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1551,  1552,     0,     0,     0,     0,
       0,     0,     0,  1554,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1490,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,  1491,
     137,  1492,  1493,     0,   437,   438,   439,   440,   441,  1494,
    1495,   442,   443,  1496,  1497,   444,     0,   445,   446,   447,
     448,  1498,     0,  1499,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,
     461,   462,   463,   464,   701,   465,  1507,  1508,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1509,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,  1510,   491,   492,   493,  1511,  1512,   494,     0,   495,
     496,  1513,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1514,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1515,  1516,     0,  1517,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1518,   182,   532,   183,     0,   533,   534,
     535,  1519,  1520,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1521,   189,  1522,   547,
     548,   191,  1523,   549,   550,   193,   551,  1524,  1525,   552,
    1526,   553,   554,   555,     0,   556,     0,     0,  1527,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1528,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1529,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1530,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1531,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1532,   613,   217,   614,   615,   219,   616,  1533,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1534,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1535,  1536,     0,     0,   637,  1537,   638,
    1538,  1539,   639,   640,   641,   642,   643,   644,   645,     0,
    1540,   646,   647,   648,   649,   650,  1541,     0,   651,   652,
     653,   654,   655,   707,  1542,  4215,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,
    1549,  1550,   708,   668,   669,     0,     0,     0,     0,     0,
       0,     0,     0,  1551,  1552,     0,     0,     0,     0,     0,
       0,     0,  1554,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
     418,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,  1490,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,  1491,   137,
    1492,  1493,     0,   437,   438,   439,   440,   441,  1494,  1495,
     442,   443,  1496,  1497,   444,     0,   445,   446,   447,   448,
    1498,     0,  1499,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,  4228,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,
     462,   463,   464,   701,   465,  1507,  1508,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
    1510,   491,   492,   493,  1511,  1512,   494,     0,   495,   496,
    1513,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1514,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,  1515,  1516,     0,  1517,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1518,   182,   532,   183,     0,   533,   534,   535,
    1519,  1520,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1521,   189,  1522,   547,   548,
     191,  1523,   549,   550,   193,   551,  1524,  1525,   552,  1526,
     553,   554,   555,     0,   556,     0,     0,  1527,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1528,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1529,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1530,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,  1531,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1532,   613,   217,   614,   615,   219,   616,  1533,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1534,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1535,  1536,     0,     0,   637,  1537,   638,  1538,
    1539,   639,   640,   641,   642,   643,   644,   645,     0,  1540,
     646,   647,   648,   649,   650,  1541,     0,   651,   652,   653,
     654,   655,   707,  1542,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
    1550,   708,   668,   669,     0,     0,     0,     0,     0,     0,
       0,     0,  1551,  1552,     0,     0,     0,     0,     0,     0,
       0,  1554,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,   418,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1486,  1487,  1488,    45,  1489,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,  1490,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,  5138,  1491,   137,  1492,
    1493,     0,   437,   438,   439,   440,   441,  1494,  1495,   442,
     443,  1496,  1497,   444,     0,   445,   446,   447,   448,  1498,
       0,  1499,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
    5139,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,
     463,   464,   701,   465,  1507,  1508,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1509,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,  1510,
     491,   492,   493,  1511,  1512,   494,     0,   495,   496,  1513,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,  1514,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,  1515,  1516,     0,  1517,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,  1518,   182,   532,   183,     0,   533,   534,   535,  1519,
    1520,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1521,   189,  1522,   547,   548,   191,
    1523,   549,   550,   193,   551,  1524,  1525,   552,  1526,   553,
     554,   555,     0,   556,     0,     0,  1527,   558,   559,     0,
       0,   560,   196,   197,   561,   198,  1528,   562,   563,   564,
     565,   566,   567,   568,     0,   569,  1529,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1530,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,  1531,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,  1532,
     613,   217,   614,   615,   219,   616,  1533,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1534,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1535,  1536,     0,     0,   637,  1537,   638,  1538,  1539,
     639,   640,   641,   642,  5140,   644,   645,     0,  1540,   646,
     647,   648,   649,   650,  1541,     0,   651,   652,   653,   654,
     655,   707,  1542,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,
     708,   668,   669,     0,     0,     0,     0,     0,     0,     0,
       0,  1551,  1552,     0,     0,     0,     0,     0,     0,     0,
    1554,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1486,
    1487,  1488,    45,  1489,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1490,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,  1491,   137,  1492,  1493,
       0,   437,   438,   439,   440,   441,  1494,  1495,   442,   443,
    1496,  1497,   444,     0,   445,   446,   447,   448,  1498,     0,
    1499,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,  5139,
    1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,
     464,   701,   465,  1507,  1508,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1509,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,  1510,   491,
     492,   493,  1511,  1512,   494,     0,   495,   496,  1513,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1514,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1515,  1516,     0,  1517,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
    1518,   182,   532,   183,     0,   533,   534,   535,  1519,  1520,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1521,   189,  1522,   547,   548,   191,  1523,
     549,   550,   193,   551,  1524,  1525,   552,  1526,   553,   554,
     555,     0,   556,     0,     0,  1527,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1528,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1529,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1530,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1531,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1532,   613,
     217,   614,   615,   219,   616,  1533,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1534,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1535,  1536,     0,     0,   637,  1537,   638,  1538,  1539,   639,
     640,   641,   642,  5140,   644,   645,     0,  1540,   646,   647,
     648,   649,   650,  1541,     0,   651,   652,   653,   654,   655,
     707,  1542,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1551,  1552,     0,     0,     0,     0,     0,     0,     0,  1554,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1486,  1487,
    1488,    45,  1489,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1490,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,  1491,   137,  1492,  1493,     0,
     437,   438,   439,   440,   441,  1494,  1495,   442,   443,  1496,
    1497,   444,     0,   445,   446,   447,   448,  1498,     0,  1499,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1500,
    1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,
     701,   465,  1507,  1508,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1509,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1510,   491,   492,
     493,  1511,  1512,   494,     0,   495,   496,  1513,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1514,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1515,
    1516,     0,  1517,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1518,
     182,   532,   183,     0,   533,   534,   535,  1519,  1520,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1521,   189,  1522,   547,   548,   191,  1523,   549,
     550,   193,   551,  1524,  1525,   552,  1526,   553,   554,   555,
       0,   556,     0,     0,  1527,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1528,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1529,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1530,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1531,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1532,   613,   217,
     614,   615,   219,   616,  1533,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1534,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1535,
    1536,     0,     0,   637,  1537,   638,  1538,  1539,   639,   640,
     641,   642,   643,   644,   645,     0,  1540,   646,   647,   648,
     649,   650,  1541,     0,   651,   652,   653,   654,   655,   707,
    1542,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,
     669,     0,     0,     0,     0,     0,     0,     0,     0,  1551,
    1552,     0,     0,     0,     0,     0,     0,     0,  1554,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1486,  1487,  1488,
      45,  1489,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1490,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1491,   137,  1492,  1493,     0,   437,
     438,   439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,
     444,     0,   445,   446,   447,   448,  1498,     0,  1499,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1500,  1501,
    1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,
     465,  1507,  1508,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1510,   491,   492,   493,
    1511,  1512,   494,     0,   495,   496,  1513,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1514,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1515,  1516,
       0,  1517,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1518,   182,
     532,   183,     0,   533,   534,   535,  1519,  1520,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1521,   189,  1522,   547,   548,   191,  1523,   549,   550,
     193,   551,  1524,  1525,   552,  1526,   553,   554,   555,     0,
     556,     0,     0,  1527,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1528,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1529,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1530,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1531,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1532,   613,   217,   614,
     615,   219,   616,  1533,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1534,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1535,  1536,
       0,     0,   637,  1537,   638,  1538,  1539,   639,   640,   641,
     642,   643,   644,   645,     0,  1540,   646,   647,   648,   649,
     650,  1541,     0,   651,   652,   653,   654,   655,   707,  1542,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,  4529,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,  1552,
       0,     0,     0,     0,     0,     0,     0,  1554,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1486,  1487,  1488,    45,
    1489,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
    1490,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,  1491,   137,  1492,  1493,     0,   437,   438,
     439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,   444,
       0,   445,   446,   447,   448,  1498,     0,  1499,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1500,  1501,  1502,
    1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,   465,
    1507,  1508,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1509,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,  1510,   491,   492,   493,  1511,
    1512,   494,     0,   495,   496,  1513,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1514,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,  1515,  1516,     0,
    1517,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1518,   182,   532,
     183,     0,   533,   534,   535,  1519,  1520,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1521,   189,  1522,   547,  4538,   191,  1523,   549,   550,   193,
     551,  1524,  1525,   552,  1526,   553,   554,   555,     0,   556,
       0,     0,  1527,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1528,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1529,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1530,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
    1531,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1532,   613,   217,   614,   615,
     219,   616,  1533,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1534,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1535,  1536,     0,
       0,   637,  1537,   638,  1538,  1539,   639,   640,   641,   642,
     643,   644,   645,     0,  1540,   646,   647,   648,   649,   650,
    1541,     0,   651,   652,   653,   654,   655,   707,  1542,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,
       0,     0,     0,     0,     0,     0,     0,  1551,  1552,     0,
       0,     0,     0,     0,     0,     0,  1554,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,   418,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1486,  1487,  1488,    45,  1489,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,  1490,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,  1491,   137,  1492,  1493,     0,   437,   438,   439,
     440,   441,  1494,  1495,   442,   443,  1496,  1497,   444,     0,
     445,   446,   447,   448,  1498,     0,  1499,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,  1500,  1501,  1502,  1503,
    1504,  1505,  1506,   461,   462,   463,   464,   701,   465,  1507,
    1508,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1509,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,  1510,   491,   492,   493,  1511,  1512,
     494,     0,   495,   496,  1513,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1514,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,  1515,  1516,     0,  1517,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,  1518,   182,   532,   183,
       0,   533,   534,   535,  1519,  1520,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1521,
     189,  1522,   547,   548,   191,     0,   549,   550,   193,   551,
    1524,  1525,   552,  1526,   553,   554,   555,     0,   556,     0,
       0,  1527,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1528,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1529,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1530,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,  1531,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,  1532,   613,   217,   614,   615,   219,
     616,  1533,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1534,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1535,  1536,     0,     0,
     637,  1537,   638,  1538,  1539,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,  1541,
       0,   651,   652,   653,   654,   655,   707,  1542,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,  1543,  1544,  1545,
    1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,     0,
       0,     0,     0,     0,     0,     0,  2923,  2924,     0,     0,
       0,     0,     0,     0,     0,  1554,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1486,  1487,  1488,    45,  1489,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,  1490,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
   -2684,  1491,   137,  1492,  1493,     0,   437,   438,   439,   440,
     441,  1494,  1495,   442,   443,  1496,  1497,   444,     0,   445,
     446,   447,   448,  1498,     0,  1499,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,  5139,  1500,  1501,  1502,  1503,  1504,
    1505,  1506,   461,   462,   463,   464,   701,   465,  1507,  1508,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1509,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,  1510,   491,   492,   493,  1511,  1512,   494,
       0,   495,   496,  1513,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1514,     0,   504,
       0,   505,   506,   703,   507,   508,     0,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,  1515,  1516,     0,  1517,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,  1518,   182,   532,     0,     0,
     533,   534,   535,  1519,  1520,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1521,   189,
    1522,   547,   548,   191,     0,   549,   550,   193,   551,  1524,
    1525,   552,  1526,   553,   554,   555,     0,   556,     0,     0,
    1527,   558,   559,     0,     0,   560,   196,   197,   561,   198,
    1528,   562,   563,   564,   565,   566,   567,   568,     0,   569,
    1529,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1530,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,  1531,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,  1532,   613,   217,   614,   615,     0,   616,
    1533,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1534,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1535,  1536,     0,     0,   637,
    1537,   638,  1538,  1539,   639,   640,   641,   642,  5140,   644,
     645,     0,  1540,   646,   647,   648,   649,   650,  1541,     0,
     651,   652,   653,   654,   655,   707,  1542,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,  1543,  1544,  1545,  1546,
    1547,  1548,  1549,  1550,   708,   668,   669,     0,     0,     0,
       0,     0,     0,     0,     0,  1551,  1552,     0,     0,     0,
       0,     0,     0,     0,  1554,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1486,  1487,     0,    45,  1489,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1490,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1491,   137,  1492,  1493,     0,   437,   438,   439,   440,   441,
    1494,  1495,   442,   443,  1496,  1497,   444,     0,   445,   446,
     447,   448,  1498,     0,  1499,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,
    1506,   461,   462,   463,   464,   701,   465,  1507,  1508,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1509,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1510,   491,   492,   493,  1511,  1512,   494,     0,
     495,   496,  1513,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1514,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1515,  1516,     0,  1517,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1518,   182,   532,   183,     0,   533,
     534,   535,  1519,  1520,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1521,   189,  1522,
     547,   548,   191,     0,   549,   550,   193,   551,  1524,  1525,
     552,  1526,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1528,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1529,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1530,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1531,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1532,   613,   217,   614,   615,   219,   616,  1533,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1534,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1535,  1536,     0,     0,   637,  1537,
     638,  1538,  1539,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,  1541,     0,   651,
     652,   653,   654,   655,   707,  1542,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,  1550,   708,   668,   669,     0,     0,     0,     0,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,  1554,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1486,  1487,
       0,    45,  1489,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1490,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,  1491,   137,  1492,  1493,     0,
    4133,   438,   439,   440,   441,  1494,  1495,   442,   443,  1496,
    1497,   444,     0,   445,   446,   447,   448,  1498,     0,  1499,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1500,
    1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,
     701,   465,  1507,  1508,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1509,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1510,   491,   492,
     493,  1511,  1512,   494,     0,   495,   496,  1513,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1514,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1515,
    1516,     0,  1517,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1518,
     182,   532,   183,     0,   533,   534,   535,  1519,  1520,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1521,   189,  1522,   547,   548,   191,     0,   549,
     550,   193,   551,  1524,  1525,   552,  1526,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1528,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1529,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1530,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1531,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1532,   613,   217,
     614,   615,   219,   616,  1533,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1534,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1535,
    1536,     0,     0,   637,  1537,   638,  1538,  1539,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,  1541,     0,   651,   652,   653,   654,   655,   707,
    1542,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,
     669,     0,     0,     0,     0,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,  1554,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1486,  1487,  1488,    45,  1489,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1490,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
    1491,   137,  1492,  1493,     0,   437,   438,   439,   440,   441,
    1494,  1495,   442,   443,  1496,  1497,   444,     0,   445,   446,
     447,   448,  1498,     0,  1499,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,
    1506,   461,   462,   463,   464,   701,   465,  1507,  1508,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1509,   479,   480,     0,
     481,   482,   483,     0,   484,     0,   486,     0,   487,   488,
     489,   490,  1510,   491,   492,   493,  1511,  1512,   494,     0,
     495,   496,  1513,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1514,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1515,  1516,     0,  1517,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1518,   182,   532,     0,     0,   533,
     534,   535,  1519,  1520,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1521,   189,  1522,
     547,   548,   191,     0,   549,   550,   193,   551,  1524,  1525,
     552,  1526,   553,   554,   555,     0,   556,     0,     0,  1527,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1528,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1529,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1530,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1531,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1532,   613,   217,   614,   615,     0,   616,  1533,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1534,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1535,  1536,     0,     0,   637,  1537,
     638,  1538,  1539,   639,   640,   641,   642,   643,   644,   645,
       0,  1540,   646,   647,   648,   649,   650,  1541,     0,   651,
     652,   653,   654,   655,   707,  1542,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,  1550,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1551,  1552,     0,     0,     0,     0,
       0,     0,     0,  1554,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1490,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,     0,  1491,
     137,  1492,  1493,     0,   437,   438,   439,   440,   441,  1494,
    1495,   442,   443,  1496,  1497,   444,     0,   445,   446,   447,
     448,  1498,     0,  1499,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,
     461,   462,   463,   464,   701,   465,  1507,  1508,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1509,   479,   480,     0,   481,
     482,   483,     0,   484,     0,   486,     0,   487,   488,   489,
     490,  1510,   491,   492,   493,  1511,  1512,   494,     0,   495,
     496,  1513,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1514,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1515,  1516,     0,  1517,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1518,   182,   532,     0,     0,   533,   534,
     535,  1519,  1520,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1521,   189,  1522,   547,
     548,   191,     0,   549,   550,   193,   551,  1524,  1525,   552,
    1526,   553,   554,   555,     0,   556,     0,     0,  1527,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1528,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1529,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1530,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1531,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1532,   613,   217,   614,   615,     0,   616,  1533,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1534,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1535,  1536,     0,     0,   637,  1537,   638,
    1538,  1539,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,  1541,     0,   651,   652,
     653,   654,   655,   707,  1542,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,
    1549,  1550,   708,   668,   669,     0,     0,     0,     0,     0,
       0,     0,     0,  2923,  2924,     0,     0,     0,     0,     0,
       0,     0,  1554,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,  1495,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
    1498,     0,  1499,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,  1511,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1514,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,  3664,   529,   530,
       0,   531,  1518,   182,   532,   183,     0,   533,   534,   535,
    1519,  1520,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,  1525,   552,   195,
     553,   554,   555,     0,   556,     0,  1094,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1528,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1529,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,  3665,   602,   603,   604,
     605,   606,   706,   607,   215,   608,   609,   610,   611,   612,
    1532,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1534,     0,   628,   629,   223,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,  1537,   638,  1538,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,  1541,     0,   651,   652,   653,
     654,   655,  2215,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,   236,   662,   663,   664,   665,
     666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
    1550,   708,   668,   669,     0,     0,     0,     0,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,  3666,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,   136,   137,   138,   139,     0,   437,   438,
     439,   440,   441,     0,  1495,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,  1498,     0,  1499,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1500,  1501,  1502,
    1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,  1511,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1514,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,  3664,   529,   530,     0,   531,  1518,   182,   532,
     183,     0,   533,   534,   535,  1519,  1520,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,   189,   190,   547,   548,   191,     0,   549,   550,   193,
     551,     0,  1525,   552,   195,   553,   554,   555,     0,   556,
       0,  1094,   557,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1528,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1529,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
     212,  3665,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1532,   613,   217,   614,   615,
     219,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1534,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,  1537,   638,  1538,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
    1541,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,
       0,     0,     0,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,  3666,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,  1495,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
    1498,     0,  1499,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,  1511,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1514,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1518,   182,   532,   183,     0,   533,   534,   535,
    1519,  1520,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,  1525,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1528,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1529,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,  3665,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1532,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1534,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,  1537,   638,  1538,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,  1541,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
    1550,   708,   668,   669,     0,     0,     0,     0,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,   246,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,   136,   137,   138,   139,     0,   437,   438,
     439,   440,   441,     0,  1495,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,  1498,     0,  1499,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1500,  1501,  1502,
    1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,  1511,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1514,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1518,   182,   532,
     183,     0,   533,   534,   535,  1519,  1520,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,   189,   190,   547,   548,   191,     0,   549,   550,   193,
     551,     0,  1525,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1528,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1529,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1532,   613,   217,   614,   615,
     219,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1534,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,  1537,   638,  1538,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
    1541,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,
       0,     0,     0,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,  4258,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,     0,     0,     0,     0,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,  4862,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,  4185,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0, -1516,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0, -1516,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518, -1516,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523, -1516,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181, -1516,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188, -1516,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598, -1516,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  1648,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,  3946,  3947,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
      45,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  3947,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,   215,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,   223,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,  2215,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,   236,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,   246,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
     215,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
     223,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  2215,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,   236,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,   246,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,  1623,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  3086,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,  4169,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  4580,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,  1219,    45,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,   739,   427,
     428,   429,   740,   741,   742,   743,   744,   745,   746,   430,
     431,   747,   432,   433,   133,   434,   435,   436,     0,  1925,
     137,  1926,  1927,   748,   437,   438,   439,   440,   441,   749,
     750,   442,   443,  1928,  1929,   444,   752,   445,   446,   447,
     448,     0,   753,   145,   754,   449,   450,   451,   452,   148,
     453,   699,   756,   454,   455,   456,   457,   458,   459,   757,
     151,   460,     0,   759,   760,   761,   152,   762,   763,   764,
     461,   462,   463,   464,   701,   465,  1930,  1931,   466,   765,
     467,   766,   468,   469,   470,   471,   472,   767,   473,   474,
     475,   768,   769,   476,   477,  1509,   479,   480,   770,   481,
     482,   483,   771,   484,   485,   486,   772,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   773,   494,   774,   495,
     496,  1932,   497,   775,   498,   776,   499,   169,   777,   170,
     500,   501,   502,   778,   503,     0,   779,   504,   780,   505,
     506,   703,   507,   508,   173,   509,   510,   511,   781,   512,
     513,   514,   515,   516,   517,   782,   518,   174,     0,     0,
     519,   520,   521,  1515,  1933,   785,  1934,   786,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,   787,   529,
     530,   788,   531,     0,   182,   532,   183,   789,   533,   534,
     535,   790,   791,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1935,   189,  1936,   547,
     548,     0,   792,   549,   550,   193,   551,   793,     0,   552,
    1937,   553,   554,   555,   794,   556,   795,   796,  3933,   558,
     559,   797,   798,   560,     0,   197,   561,   198,     0,   562,
     563,   564,   565,   566,   567,   568,   799,   569,     0,   570,
       0,   571,   572,   573,   800,   574,   575,   576,   577,   578,
     579,   580,   581,  1938,   582,   583,   584,   585,   801,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     802,   597,   598,   210,   599,   600,     0,   601,   602,   603,
     604,   605,   606,   706,   607,   803,   608,   609,   610,   611,
     612,   804,   613,  2423,   614,   615,   219,   616,  1940,   617,
     805,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,   806,   628,   629,   807,   630,   631,   632,   633,
     634,   635,   808,  1941,  1942,     0,   810,   637,     0,   638,
       0,   811,   639,   640,   641,   642,   643,   644,   645,     0,
     813,   646,   647,   648,   649,   650,   814,   815,   651,   652,
     653,   654,   655,     0,  1943,   817,   656,   235,   657,   658,
     659,   660,   818,   819,   661,   820,   821,   662,   663,   664,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   708,   668,   669,     0,     0,     0,     0,  1222,
    1223,  1224,     0,  3934,  3935,  1227,  1228,  1229,  1230,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1219,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,  1220,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,  1221,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,  1222,  1223,  1224,     0,  1225,  1226,  1227,
    1228,  1229,  1230,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   687,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1219,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,     0,   434,   435,   436,   135,   136,     0,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,  1317,   447,   448,   144,
       0,     0,     0,   449,   450,   451,   452,     0,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
       0,     0,     0,     0,     0,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,  1318,     0,   495,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,   508,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,     0,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,     0,     0,   523,
       0,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,     0,   532,     0,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,     0,   190,   547,   548,   191,
       0,   549,   550,     0,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,     0,   561,     0,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,     0,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,     0,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,     0,     0,     0,     0,  1222,  1223,  1224,
       0,  1225,  1226,  1227,  1228,  1229,  1230,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   687,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1219,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,     0,   434,   435,   436,
     135,   136,     0,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   698,   140,   444,     0,   445,
    1374,   447,   448,   144,     0,     0,     0,   449,   450,   451,
     452,     0,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,     0,     0,     0,     0,     0,     0,
       0,     0,   461,   462,   463,   464,   701,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,  1375,
       0,   495,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   703,   507,  1376,     0,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,     0,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,     0,     0,   523,     0,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,     0,   532,     0,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,     0,
     190,   547,   548,   191,     0,   549,   550,     0,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,     0,   561,     0,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,     0,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,     0,     0,   637,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   707,   234,     0,   656,     0,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,     0,     0,     0,
       0,  1222,  1223,  1224,     0,  1225,  1226,  1227,  1228,  1229,
    1230,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1219,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,  1910,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,  1911,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,     0,     0,     0,  1222,  1223,  1224,     0,  1225,
    1226,  1227,  1228,  1229,  1230,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1219,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,  1222,
    1223,  1224,     0,  1225,  1226,  1227,  1228,  1229,  1230,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1219,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,  3186,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,  3187,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,  1222,  1223,  1224,     0,  1225,  1226,  1227,
    1228,  1229,  1230,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   687,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1219,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,     0,   434,   435,   436,   135,   136,     0,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,   446,   447,   448,   144,
       0,     0,     0,   449,   450,   451,   452,     0,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
       0,     0,     0,     0,     0,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,   494,     0,   495,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,   508,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,     0,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,     0,     0,   523,
       0,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,     0,   532,     0,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,     0,   190,   547,   548,   191,
       0,   549,   550,     0,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,  4841,   558,   559,     0,
       0,   560,   196,     0,   561,     0,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,     0,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,     0,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,     0,     0,     0,     0,  1222,  1223,  1224,
       0,  1225,  1226,  1227,  1228,  1229,  1230,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,   739,   427,   428,   429,   740,   741,   742,   743,   744,
     745,   746,   430,   431,   747,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,   748,   437,   438,   439,
     440,   441,   749,   750,   442,   443,   751,   140,   444,   752,
     445,   446,   447,   448,   144,   753,   145,   754,   449,   450,
     451,   452,   148,   453,   755,   756,   454,   455,   456,   457,
     458,   459,   757,   151,   460,   758,   759,   760,   761,   152,
     762,   763,   764,   461,   462,   463,   464,   701,   465,   155,
     156,   466,   765,   467,   766,   468,   469,   470,   471,   472,
     767,   473,   474,   475,   768,   769,   476,   477,   478,   479,
     480,   770,   481,   482,   483,   771,   484,   485,   486,   772,
     487,   488,   489,   490,   164,   491,   492,   493,   166,   773,
     494,   774,   495,   496,   168,   497,   775,   498,   776,   499,
     169,   777,   170,   500,   501,   502,   778,   503,   172,   779,
     504,   780,   505,   506,   703,   507,   508,   173,   509,   510,
     511,   781,   512,   513,   514,   515,   516,   517,   782,   518,
     174,   175,   783,   519,   520,   521,   784,   176,   785,   177,
     786,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,   787,   529,   530,   788,   531,   181,   182,   532,   183,
     789,   533,   534,   535,   790,   791,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,   792,   549,   550,   193,   551,
     793,   194,   552,   195,   553,   554,   555,   794,   556,   795,
     796,   557,   558,   559,   797,   798,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,   799,
     569,   200,   570,   201,   571,   572,   573,   800,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,   801,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   802,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,   803,   608,
     609,   610,   611,   612,   804,   613,   217,   614,   615,   219,
     616,   220,   617,   805,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   806,   628,   629,   807,   630,
     631,   632,   633,   634,   635,   808,   224,   225,   809,   810,
     637,   226,   638,   227,   811,   639,   640,   641,   642,   643,
     644,   645,   812,   813,   646,   647,   648,   649,   650,   814,
     815,   651,   652,   653,   654,   655,   816,   234,   817,   656,
     235,   657,   658,   659,   660,   818,   819,   661,   820,   821,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,     0,   732,
      86,    87,    88,   684,    90,    91,    92,   685,  2314,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1925,   137,  1926,  1927,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1928,  1929,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,  1930,  1931,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,  1932,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,  2419,   512,   513,   514,   515,   516,   517,
       0,   518,   174,  2420,     0,   519,   520,   521,  1515,  1933,
       0,  1934,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1935,   189,  1936,   547,   548,     0,     0,   549,   550,
     193,   551,     0,     0,   552,  1937,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,  2421,   560,  2422,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1938,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,  2423,   614,
     615,   219,   616,  1940,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1941,  1942,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,  1943,
    2424,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
       0,     0,    86,    87,    88,   684,    90,    91,    92,   685,
    2425,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,     0,    86,    87,    88,   684,    90,    91,
      92,   685,  1101,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   687,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,     0,   434,   435,   436,   135,   136,     0,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,     0,     0,   449,   450,   451,   452,     0,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,     0,     0,     0,     0,     0,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,   508,     0,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,     0,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,     0,     0,
     523,     0,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,     0,   532,     0,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,     0,   190,   547,   548,
     191,     0,   549,   550,     0,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,     0,   561,     0,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,     0,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,     0,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,     0,    86,    87,    88,   684,
      90,    91,    92,   685,  4889,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   996,   421,   422,   423,   424,   425,   426,   997,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   998,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   999,   168,   497,     0,   498,     0,  1000,     0,  1001,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,  1002,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,  1003,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
    1004,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,  1005,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,  1006,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1007,  1008,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   996,   421,   422,   423,   424,   425,   426,   997,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,  1029,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   999,   168,   497,     0,   498,     0,  1030,     0,  1001,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,  1002,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,  1003,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
    1004,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,  1005,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,  1006,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1007,  1008,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1422,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,  1001,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,  1002,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1007,  1008,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1427,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,  1001,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,  1002,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1007,  1008,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
     702,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,  1594,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,  1071,
    1595,    86,    87,    88,   684,    90,    91,    92,   685,  1072,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,  1073,   443,  1045,
     140,   444,     0,   445,   446,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,  1074,     0,  1075,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,  1076,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,  1077,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
    1078,   600,   212,   601,   602,   603,  1079,   605,   606,   706,
     607,     0,   608,   609,   610,   611,  1080,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1081,
     225,     0,     0,  1082,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,  1049,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,  1083,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   739,   427,   428,   429,   740,
     741,   742,   743,   744,   745,   746,   430,   431,   747,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
     748,   437,   438,   439,   440,   441,   749,   750,   442,   443,
     751,   140,   444,   752,   445,   446,   447,   448,   144,   753,
     145,   754,   449,   450,   451,   452,   148,   453,   755,   756,
     454,   455,   456,   457,   458,   459,   757,   151,   460,   758,
     759,   760,   761,   152,   762,   763,   764,   461,   462,   463,
     464,   701,   465,   155,   156,   466,   765,   467,   766,   468,
     469,   470,   471,   472,   767,   473,   474,   475,   768,   769,
     476,   477,   478,   479,   480,   770,   481,   482,   483,   771,
     484,   485,   486,   772,   487,   488,   489,   490,   164,   491,
     492,   493,   166,   773,   494,   774,   495,   496,   168,   497,
     775,   498,   776,   499,   169,   777,   170,   500,   501,   502,
     778,   503,   172,   779,   504,   780,   505,   506,   703,   507,
     508,   173,   509,   510,   511,   781,   512,   513,   514,   515,
     516,   517,   782,   518,   174,   175,   783,   519,   520,   521,
     784,   176,   785,   177,   786,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,   787,   529,   530,   788,   531,
     181,   182,   532,   183,   789,   533,   534,   535,   790,   791,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,   189,   190,   547,   548,   191,   792,
     549,   550,   193,   551,   793,   194,   552,   195,   553,   554,
     555,   794,   556,   795,   796,   557,   558,   559,   797,   798,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,   799,   569,   200,   570,   201,   571,   572,
     573,   800,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,   801,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   802,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,   803,   608,   609,   610,   611,   612,   804,   613,
     217,   614,   615,   219,   616,   220,   617,   805,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   806,
     628,   629,   807,   630,   631,   632,   633,   634,   635,   808,
     224,   225,   809,   810,   637,   226,   638,   227,   811,   639,
     640,   641,   642,   643,   644,   645,   812,   813,   646,   647,
     648,   649,   650,   814,   815,   651,   652,   653,   654,   655,
     816,   234,   817,   656,   235,   657,   658,   659,   660,   818,
     819,   661,   820,   821,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,   739,   427,   428,   429,
     740,   741,   742,   743,   744,   745,   746,   430,   431,   747,
     432,   433,   133,   434,   435,   436,   135,   136,   137,   138,
     139,   748,   437,   438,   439,   440,   441,   749,   750,   442,
     443,   751,   140,   444,   752,   445,   446,   447,   448,   144,
     753,   145,   754,   449,   450,   451,   452,   148,   453,   755,
     756,   454,   455,   456,   457,   458,   459,   757,   151,   460,
     758,   759,   760,   761,   152,   762,   763,   764,   461,   462,
     463,   464,   701,   465,   155,   156,   466,   765,   467,   766,
     468,   469,   470,   471,   472,   767,   473,   474,   475,   768,
     769,   476,   477,   478,   479,   480,   770,   481,   482,   483,
     771,   484,   485,   486,   772,   487,   488,   489,   490,   164,
     491,   492,   493,   166,   773,   494,   774,   495,   496,   168,
     497,   775,   498,   776,   499,   169,   777,   170,   500,   501,
     502,   778,   503,   172,   779,   504,   780,   505,   506,   703,
     507,   508,   173,   509,   510,   511,   781,   512,   513,   514,
     515,   516,   517,   782,   518,   174,   175,   783,   519,   520,
     521,   784,   176,   785,   177,   786,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,   787,   529,   530,   788,
     531,   181,   182,   532,   183,   789,   533,   534,   535,   790,
     791,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,   189,   190,   547,   548,   191,
     792,   549,   550,   193,   551,   793,   194,   552,   195,   553,
     554,   555,   794,   556,   795,   796,   557,   558,   559,   797,
     798,   560,   196,   197,   561,   198,   199,   562,   563,   564,
     565,   566,   567,   568,   799,   569,   200,   570,   201,   571,
     572,   573,   800,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,   801,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   802,   597,
     598,   210,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,   803,   608,   609,   610,   611,   612,   804,
     613,   217,   614,   615,   219,   616,   220,   617,   805,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     806,   628,   629,   807,   630,   631,   632,   633,   634,   635,
     808,   224,   225,   809,   810,   637,   226,   638,   227,   811,
     639,   640,   641,   642,   643,   644,   645,   812,   813,   646,
     647,   648,   649,   650,   814,   815,   651,   652,   653,   654,
     655,   816,   234,   817,   656,   235,   657,   658,   659,   660,
     818,   819,   661,   820,   821,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,  3245,   424,   425,   426,   739,   427,   428,
     429,   740,   741,   742,   743,   744,   745,   746,   430,   431,
     747,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,   748,   437,   438,   439,   440,   441,   749,   750,
     442,   443,   751,   140,   444,   752,   445,   446,   447,   448,
     144,   753,   145,   754,   449,   450,   451,   452,   148,   453,
     755,   756,   454,   455,   456,   457,   458,   459,   757,   151,
     460,   758,   759,   760,   761,   152,   762,   763,   764,   461,
     462,   463,   464,   701,   465,   155,   156,   466,   765,   467,
     766,   468,   469,   470,   471,   472,   767,   473,   474,   475,
     768,   769,   476,   477,   478,  3246,   480,   770,   481,   482,
     483,   771,   484,   485,   486,   772,   487,   488,   489,   490,
     164,   491,   492,   493,   166,   773,   494,   774,   495,   496,
     168,   497,   775,   498,   776,   499,   169,   777,   170,   500,
     501,   502,   778,   503,   172,   779,   504,   780,   505,   506,
     703,   507,   508,   173,   509,   510,   511,   781,   512,   513,
     514,   515,   516,   517,   782,   518,   174,   175,   783,   519,
     520,   521,   784,   176,   785,   177,   786,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,   787,   529,   530,
     788,   531,   181,   182,   532,   183,   789,   533,   534,   535,
     790,   791,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,   792,   549,   550,   193,   551,   793,   194,   552,   195,
     553,   554,   555,   794,   556,   795,   796,   557,   558,   559,
     797,   798,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,   799,   569,   200,   570,   201,
     571,   572,   573,   800,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,   801,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   802,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,   803,   608,   609,   610,   611,   612,
     804,  3247,   217,   614,   615,   219,   616,   220,   617,   805,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   806,   628,   629,   807,   630,   631,   632,   633,   634,
     635,   808,   224,   225,   809,   810,   637,   226,   638,   227,
     811,   639,   640,   641,   642,   643,   644,   645,   812,   813,
     646,   647,   648,   649,   650,   814,   815,   651,   652,   653,
     654,   655,   816,   234,   817,   656,   235,   657,   658,   659,
     660,   818,   819,   661,   820,   821,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,   136,
     137,   138,   139,     0,   437,   438,   439,   440,   441,     0,
    1495,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,  1498,     0,  1499,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,  1511,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1514,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1518,   182,   532,   183,     0,   533,   534,
     535,  1519,  1520,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,   189,   190,   547,
     548,   191,     0,   549,   550,   193,   551,     0,  1525,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1528,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1529,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1532,   613,   217,   614,   615,   219,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1534,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,  1537,   638,
    1538,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,  1541,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,
    1549,  1550,   708,   668,   669,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,   136,   137,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   698,   140,   444,     0,   445,
     446,   447,   448,   144,     0,   145,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,     0,     0,     0,   152,     0,
       0,     0,   461,   462,   463,   464,   701,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,   494,
       0,   495,   496,   168,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   703,   507,  1357,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,   182,   532,   183,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,   189,
     190,   547,   548,   191,     0,   549,   550,   193,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,   197,   561,   198,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,   219,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,     0,     0,   637,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   707,   234,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   698,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,   701,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   703,   507,  1367,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   707,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,     0,  1925,   137,  1926,  1927,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,  1928,  1929,   444,
       0,   445,   446,   447,   448,     0,     0,   145,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,     0,     0,     0,
     152,     0,     0,     0,   461,   462,   463,   464,   701,   465,
    1930,  1931,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1509,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,     0,   491,   492,   493,     0,
       0,   494,     0,   495,   496,  1932,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,  2419,   512,   513,   514,   515,   516,   517,     0,
     518,   174,  2420,     0,   519,   520,   521,  1515,  1933,     0,
    1934,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,     0,   182,   532,
     183,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1935,   189,  1936,   547,   548,     0,     0,   549,   550,   193,
     551,     0,     0,   552,  1937,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,  2422,   197,
     561,   198,     0,   562,   563,   564,   565,   566,   567,   568,
       0,   569,     0,   570,     0,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1938,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,  2423,   614,   615,
     219,   616,  1940,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,     0,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1941,  1942,     0,
       0,   637,     0,   638,     0,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,     0,  1943,  2424,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   708,   668,   669,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1925,   137,  1926,  1927,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1928,  1929,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,  1930,  1931,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,  1932,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,     0,     0,   519,   520,   521,  1515,  1933,
       0,  1934,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1935,   189,  1936,   547,   548,     0,     0,   549,   550,
     193,   551,  2510,     0,   552,  1937,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,     0,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1938,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,  2423,   614,
     615,   219,   616,  1940,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
    4038,   630,   631,   632,   633,   634,   635,     0,  1941,  1942,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,  1943,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,     0,  1925,   137,  1926,  1927,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,  1928,
    1929,   444,     0,   445,   446,   447,   448,     0,     0,   145,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,     0,
       0,     0,   152,     0,     0,     0,   461,   462,   463,   464,
     701,   465,  1930,  1931,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1509,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,     0,   491,   492,
     493,     0,     0,   494,     0,   495,   496,  1932,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,     0,     0,   519,   520,   521,  1515,
    1933,     0,  1934,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,     0,
     182,   532,   183,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1935,   189,  1936,   547,   548,  2570,     0,   549,
     550,   193,   551,     0,     0,   552,  1937,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
       0,   197,   561,   198,     0,   562,   563,   564,   565,   566,
     567,   568,     0,   569,     0,   570,     0,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1938,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,     0,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,  1939,
     614,   615,   219,   616,  1940,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1941,
    1942,     0,     0,   637,     0,   638,     0,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,     0,
    1943,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   708,   668,
     669,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,     0,  1925,   137,  1926,  1927,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
    1928,  1929,   444,     0,   445,   446,   447,   448,     0,     0,
     145,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,   701,   465,  1930,  1931,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1509,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,     0,   491,
     492,   493,     0,     0,   494,     0,   495,   496,  1932,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,     0,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,     0,     0,   519,   520,   521,
    1515,  1933,     0,  1934,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
       0,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1935,   189,  1936,   547,   548,  3867,     0,
     549,   550,   193,   551,     0,     0,   552,  1937,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,     0,   197,   561,   198,     0,   562,   563,   564,   565,
     566,   567,   568,     0,   569,     0,   570,     0,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1938,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
    1939,   614,   615,   219,   616,  1940,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,     0,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1941,  1942,     0,     0,   637,     0,   638,     0,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,  1943,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   708,
     668,   669,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,     0,  1925,   137,  1926,
    1927,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,  1928,  1929,   444,     0,   445,   446,   447,   448,     0,
       0,   145,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,     0,     0,     0,   152,     0,     0,     0,   461,   462,
     463,   464,   701,   465,  1930,  1931,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1509,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,     0,
     491,   492,   493,     0,     0,   494,     0,   495,   496,  1932,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,     0,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,     0,     0,   519,   520,
     521,  1515,  1933,     0,  1934,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,     0,   182,   532,   183,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1935,   189,  1936,   547,   548,     0,
       0,   549,   550,   193,   551,     0,     0,   552,  1937,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,     0,   197,   561,   198,     0,   562,   563,   564,
     565,   566,   567,   568,     0,   569,     0,   570,     0,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1938,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,     0,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,  1939,   614,   615,   219,   616,  1940,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,     0,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1941,  1942,     0,     0,   637,     0,   638,     0,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,     0,  1943,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     708,   668,   669,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,     0,  1925,   137,
    1926,  1927,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,  1928,  1929,   444,     0,   445,   446,   447,   448,
       0,     0,   145,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,   701,   465,  1930,  1931,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
       0,   491,   492,   493,     0,     0,   494,     0,   495,   496,
    1932,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,     0,     0,   519,
     520,   521,  1515,  1933,     0,  1934,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,     0,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1935,   189,  1936,   547,   548,
       0,     0,   549,   550,   193,   551,     0,     0,   552,  1937,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,     0,   197,   561,   198,     0,   562,   563,
     564,   565,   566,   567,   568,     0,   569,     0,   570,     0,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1938,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,     0,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,  2423,   614,   615,   219,   616,  1940,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
       0,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1941,  1942,     0,     0,   637,     0,   638,     0,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,  1943,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   708,   668,   669,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,     0,  1925,
     137,  1926,  1927,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,  1928,  1929,   444,     0,   445,   446,   447,
     448,     0,     0,   145,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,     0,     0,     0,   152,     0,     0,     0,
     461,   462,   463,   464,   701,   465,  1930,  1931,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1509,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,     0,   491,   492,   493,     0,     0,   494,     0,   495,
     496,  1932,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,     0,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,     0,     0,
     519,   520,   521,  1515,  1933,     0,  1934,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,     0,   182,   532,   183,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1935,   189,  1936,   547,
     548,     0,     0,   549,   550,   193,   551,     0,     0,   552,
    1937,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,     0,   197,   561,   198,     0,   562,
     563,   564,   565,   566,   567,   568,     0,   569,     0,   570,
       0,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1938,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,     0,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,     0,   614,   615,   219,   616,  1940,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1941,  1942,     0,     0,   637,     0,   638,
       0,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,     0,  1943,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   708,   668,   669,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
       0,   137,     0,     0,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,     0,   444,     0,   445,   446,
     447,   448,     0,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,     0,     0,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,     0,   491,   492,   493,     0,     0,   494,     0,
     495,   496,     0,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,     0,
       0,   519,   520,   521,     0,     0,     0,     0,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,     0,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,     0,   189,     0,
     547,   548,     0,     0,   549,   550,   193,   551,     0,     0,
     552,     0,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,     0,   197,   561,   198,     0,
     562,   563,   564,   565,   566,   567,   568,     0,   569,     0,
     570,     0,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,     0,   614,   615,   219,   616,     0,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,     0,     0,     0,     0,   637,     0,
     638,     0,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,     0,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   739,
     427,   428,   429,   740,   741,   742,   743,   744,   745,   746,
     430,   431,   747,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,   748,   437,   438,   439,   440,   441,
     749,   750,   442,   443,     0,   140,   444,   752,   445,   446,
     447,   448,   144,   753,   145,   754,   449,   450,   451,   452,
     148,   453,   755,   756,   454,   455,   456,   457,   458,   459,
     757,   151,   460,     0,   759,   760,   761,   152,   762,   763,
     764,   461,   462,   463,   464,     0,   465,   155,   156,   466,
     765,   467,   766,   468,   469,   470,   471,   472,   767,   473,
     474,   475,   768,   769,   476,   477,   478,   479,   480,   770,
     481,   482,   483,   771,   484,   485,   486,   772,   487,   488,
     489,   490,   164,   491,   492,   493,   166,   773,   494,   774,
     495,   496,   168,   497,   775,   498,   776,   499,   169,   777,
     170,   500,   501,   502,   778,   503,   172,   779,   504,   780,
     505,   506,     0,   507,   508,   173,   509,   510,   511,   781,
     512,   513,   514,   515,   516,   517,   782,   518,   174,   175,
       0,   519,   520,   521,     0,   176,   785,   177,   786,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,   787,
     529,   530,   788,   531,   181,   182,   532,   183,   789,   533,
     534,   535,   790,   791,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,   792,   549,   550,   193,   551,   793,   194,
     552,   195,   553,   554,   555,   794,   556,   795,   796,   557,
     558,   559,   797,   798,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,   799,   569,   200,
     570,   201,   571,   572,   573,   800,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,   801,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   802,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,   803,   608,   609,   610,
     611,   612,   804,   613,   217,   614,   615,   219,   616,   220,
     617,   805,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,   806,   628,   629,   807,   630,   631,   632,
     633,   634,   635,   808,   224,   225,     0,   810,   637,   226,
     638,   227,   811,   639,   640,   641,   642,   643,   644,   645,
       0,   813,   646,   647,   648,   649,   650,   814,   815,   651,
     652,   653,   654,   655,     0,   234,   817,   656,   235,   657,
     658,   659,   660,   818,   819,   661,   820,   821,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
    1163,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,  2456,   445,   446,
     447,   448,   144,     0,     0,  2529,   449,   450,   451,   452,
       0,   453,   699,  2457,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,  2530,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,  2459,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,  2460,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,  2461,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,  2456,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,  2457,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,  2530,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,  2459,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,  3415,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,  2460,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,  2461,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,  1060,   425,   426,  1016,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
    1017,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,  1061,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,  1018,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,  1019,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1016,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
    1017,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,  3148,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,  1018,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,  1019,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,  2456,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,  2457,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,  2530,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,  2459,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,  2460,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,  2461,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   697,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,   700,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
     702,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1016,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
    1017,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,  1018,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,  1019,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,   927,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   928,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   929,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  2116,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,  2117,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,  2118,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,  2119,   499,     0,     0,
       0,  2120,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,  2121,  2122,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,  2123,   605,   606,   706,   607,     0,  2124,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,  2125,   630,  2126,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,  2127,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
    1017,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,  1018,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,  1019,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,  2105,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,  2401,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,  3012,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,  3013,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,  3014,   630,   631,  3015,
     633,  3016,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,  3017,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   724,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
     702,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   877,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1244,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1245,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,  1094,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1349,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,   130,   131,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  3229,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,  3230,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  3241,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,  3242,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   933,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   978,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,  1033,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,  1094,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1214,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1215,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1597,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1772,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,  1094,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1820,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1821,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,  2013,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,  2105,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,  2401,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,  4185,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,  4199,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
    4424,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
    4426,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
    4428,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,  4844,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
    1042,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1044,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  1046,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1047,   225,     0,     0,  1048,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1088,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  1089,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1090,   225,     0,     0,  1091,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,  1108,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1239,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1254,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1308,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1322,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1362,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1381,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1383,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1385,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1388,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1394,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,  1608,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,  1073,   443,  1045,   140,  1609,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,  1077,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,  1078,   600,   212,   601,   602,
     603,  1079,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  1601,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1081,   225,     0,     0,  1082,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,  1083,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,  1735,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1044,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1972,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  2002,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  2037,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  2039,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  2041,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
    2154,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,  2367,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,     0,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  2770,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  3159,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  3232,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  3234,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  3339,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,  1073,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,  1077,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,  1078,   600,   212,   601,   602,
     603,  1079,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  1601,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1081,   225,     0,     0,  1082,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,  1083,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,  1073,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,  1077,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,  1078,   600,   212,   601,   602,
     603,  1079,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  1601,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,  2447,   632,
     633,   634,   635,     0,  1081,   225,     0,     0,  1082,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,  1083,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,  1073,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,  1077,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,  1078,   600,   212,   601,   602,
     603,  2514,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  2515,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1081,   225,     0,     0,  2516,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,  1083,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,  1073,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,  1077,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,  1078,   600,   212,   601,   602,
     603,  1079,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  2515,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1081,   225,     0,     0,  2516,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,  1083,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,     0,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,     0,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,     0,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115, -2438,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,    35,     0,   413,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,   145,     0,     0,     0,     0,     0,
     148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,   156,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,   166,     0,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   181,   182,     0,   183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,   193,     0,     0,   194,
       0,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,   197,     0,   198,   199,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   200,
       0,   201,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,   212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,     0,     0,     0,     0,     0,     0,     0,
     230,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   234,     0,     0,   235,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115, -2439,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,    35,     0,
    1158,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,   145,     0,     0,     0,     0,     0,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,   166,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   181,   182,     0,   183,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,     0,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
       0,     0,     0,     0,     0,     0,     0,   230,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   234,     0,     0,   235,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   237,   238,   239,   240,   241,   242,   243,   244,   245,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,   145,     0,
       0,     0,     0,     0,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,   156,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     166,     0,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   176,
       0,   177,     0,     0,   178,   179,     0,   180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     193,     0,     0,   194,     0,   195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,     0,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,   225,
       0,     0,     0,   226,     0,   227,     0,     0,     0,     0,
       0,     0,     0,     0,   230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   234,
       0,     0,   235,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,   145,     0,     0,     0,     0,
       0,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,   152,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,   156,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,   166,     0,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   176,     0,   177,     0,
       0,   178,   179,     0,   180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,     0,   183,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
     190,     0,     0,   191,     0,     0,     0,   193,     0,     0,
     194,     0,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,   197,     0,   198,
     199,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   210,     0,     0,   212,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   217,     0,     0,   219,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   224,   225,     0,     0,     0,
     226,     0,   227,     0,     0,     0,     0,     0,     0,     0,
       0,   230,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   234,     0,     0,   235,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   237,   238,   239,   240,   241,
     242,   243,   244,   245,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,     0,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,   156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   176,     0,   177,     0,     0,   178,   179,
       0,   180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,     0,   198,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   200,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   234,     0,     0,   235,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,  2081,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,  2082,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,  2083,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   668,   669,     0,     0,     0,    35,
       0,     0,     0,     0,  1692,  1693,  4691,    41,    42,     0,
       0,     0,     0,  4692,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,   130,   131,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,   215,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,   223,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   233,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,   236,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,   668,   669,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,     0,    45,
       0,   246,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,   136,   137,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,     0,   140,   444,
       0,   445,   446,   447,   448,   144,     0,   145,     0,   449,
     450,   451,   452,   148,   453,     0,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,     0,     0,     0,
     152,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     155,   156,   466,  2302,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
    2081,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,     0,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,   182,   532,
     183,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   543,     0,   544,   545,   546,
     188,   189,   190,   547,   548,   191,     0,   549,   550,   193,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
    2082,     0,   557,   558,   559,     0,     0,   560,   196,   197,
     561,   198,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
     212,   601,   602,   603,   604,   605,   606,     0,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
     219,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,  2083,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,     0,   234,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,   668,   669,     0,
       0,     0,     0,     0,     0,    35,   418,  1692,  1693,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,     0,
      45,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,  2307,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,  2081,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,  2082,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,  2083,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,     0,   668,   669,
       0,     0,     0,     0,     0,     0,    35,   418,  1692,  1693,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,   136,   137,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,     0,
     140,   444,     0,   445,   446,   447,   448,   144,     0,   145,
       0,   449,   450,   451,   452,   148,   453,     0,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,     0,
       0,     0,   152,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,  2081,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,     0,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
     182,   532,   183,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   543,     0,   544,
     545,   546,   188,   189,   190,   547,   548,   191,     0,   549,
     550,   193,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,  2082,     0,   557,   558,   559,     0,     0,   560,
     196,   197,   561,   198,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,   212,   601,   602,   603,   604,   605,   606,     0,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,   219,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,  2083,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,     0,
     234,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,     0,   668,
     669,     0,     0,     0,     0,     0,     0,    35,     0,  1692,
    1693,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,  2081,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,  2082,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,  2083,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,     0,
     668,   669,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,   136,   137,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,     0,   140,   444,     0,   445,
     446,   447,   448,   144,     0,   145,     0,   449,   450,   451,
     452,   148,   453,     0,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,     0,     0,     0,   152,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,   494,
       0,   495,   496,   168,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,     0,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,   182,   532,   183,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   543,     0,   544,   545,   546,   188,   189,
     190,   547,   548,   191,     0,   549,   550,   193,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,   197,   561,   198,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,   212,   601,
     602,   603,   604,   605,   606,     0,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,   219,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,   636,     0,   637,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,     0,   234,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,     0,   668,   669,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     668,   669,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,  2287,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   668,   669,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   668,   669,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,  2061,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   668,   669,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,  2630,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,  2631,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   668,   669,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,   130,
     131,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     668,   669,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,  1235,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   668,   669,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1251,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,  1252,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   668,   669,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,  3520,
     504,     0,   505,   506,     0,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   668,   669,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   668,   669,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,  1330,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     668,   669,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,  1369,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   668,   669,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,  1379,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   668,   669,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,  1390,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,  1391,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,     0,   668,   669
};

static const yytype_int16 yycheck[] =
{
       2,   246,   940,   381,   381,  1416,    78,     2,   117,    78,
      78,    78,  1075,    78,   209,    84,    78,  1377,   154,  1372,
    1129,  1368,   365,  1241,   167,   153,   150,  1124,   901,  1758,
      78,  1194,   228,  1236,  1629,   960,    84,  1017,  1018,  1019,
    1446,  1092,  1300,  1023,   187,   970,   984,  2264,   117,  1263,
    1253,  1939,  2120,   162,  2865,   165,   730,  1955,  1793,  2362,
    1082,  2070,  1536,   117,  1152,   223,   202,    94,  1319,  2276,
    1799,  1479,   171,  2427,  2428,  1408,    78,   940,  1329,  1813,
    1898,  2667,    84,   160,  3476,   958,  1957,    89,  1507,  1508,
    2702,  1998,  2710,   162,  3413,  3201,  3720,   165,  3438,   132,
    1358,  2326,  1305,    96,  1849,   132,  1309,  1526,   162,  1650,
     209,  1314,  2159,   106,  3020,   117,  1803,  1171,  1321,  2620,
    3394,   230,    78,   858,  1171,  3465,   153,   154,  1331,  1217,
    3773,  3381,  1866,  1867,   731,  3640,   163,  3225,  2569,  2844,
    1078,  1686,  1687,  1688,  3394,  3245,  1741,  3247,  3822,   142,
    3025,   153,  2059,  3666,   983,   353,   367,  3086,  3769,   208,
     162,   230,  3023,  3024,   157,  4028,   901,  4039,  3975,   218,
    1646,  4018,  1785,  3079,  1861,   202,   230,  1745,   216,  2957,
    1799,   167,  3672,  1681,  1682,  1121,  1496,  1497,  1211,  2374,
    3117,  2009,  2001,  1409,  1121,  4263,  1429,   117,   367,  1166,
    1167,   187,  3598,  1240,  1400,  3730,   208,  3671,    14,  1246,
    2427,    21,  1522,    30,   216,  1078,   218,  4580,  1255,  4582,
      78,  1554,  4768,   958,    10,    88,  4474,   128,   230,  2414,
     975,    37,    72,  2418,  4016,   121,  3398,  3399,  3400,  3401,
    3402,  3403,   162,   135,   117,  4027,    86,   108,    72,    75,
      76,    77,    78,   927,   838,    84,    82,  4621,   114,    72,
      88,   128,   112,  3020,   224,   145,    72,   145,    81,    75,
      76,    77,    78,    86,  2705,    81,    82,    83,    84,   114,
      86,   128,   204,   229,  4761,   113,   143,   237,   208,   162,
      72,   149,    75,    76,    77,    78,   216,   180,   218,    82,
      95,   373,   179,   268,    86,   373,   373,   165,   373,   230,
     230,   373,   381,   229,  3092,   143,   153,   187,  1298,   112,
     268,   210,  3079,    75,    76,    77,    78,  2225,  1416,   210,
      82,   268,   180,   381,   149,   341,   156,  3947,   229,   103,
     104,    78,   173,   387,   145,   129,    72,   416,  2779,   145,
    2781,   100,   135,   137,   180,    81,    99,   230,  1409,   180,
      86,   357,   184,   106,    75,    76,    77,    78,   416,   145,
    5138,    82,    78,   300,   172,   145,   229,   153,   229,   381,
      75,    76,    77,    78,    38,   160,    40,    82,   246,    99,
     417,    78,  1555,   378,    99,    90,   106,   403,  1072,  1613,
    3575,   106,   197,   229,   137,    78,    75,    76,    77,    78,
    1283,   362,   438,    82,   416,   229,   511,   373,   403,  1582,
    2488,    90,   436,   518,  3599,    78,    75,    76,    77,    78,
      78,   235,    93,    82,    78,   385,    78,   388,    78,   102,
     362,    90,    78,    75,    76,    77,    78,   269,    78,    95,
      82,    78,  5220,  1378,   480,  1393,   173,  4820,    90,   234,
     182,  4268,   840,   840,   228,   313,   230,   394,  1942,   513,
      75,    76,    77,    78,   199,   208,   185,    82,  1416,   380,
     311,    75,    76,    77,    78,    90,  2923,  2924,    82,     0,
     436,  2928,   313,   226,  2679,   211,    25,    75,    76,    77,
      78,   299,   516,   301,    82,  4753,    88,   291,   636,   367,
     458,  1930,  1931,   380,   263,   373,   405,   513,  1937,    75,
      76,    77,    78,  1611,   405,  1576,    82,  1452,  1616,  1617,
    1393,  2968,  2969,   380,   173,  2423,   249,    75,    76,    77,
      78,   135,  1467,   391,    82,  1483,   682,   683,  1283,   210,
     515,   197,  1912,   513,   500,  1480,   436,    29,   436,   379,
    1907,   438,  2433,    75,    76,    77,    78,  1618,  1619,   515,
      82,  1168,  1169,   423,  3848,    75,    76,    77,    78,   516,
     436,  5058,    82,    75,    76,    77,    78,   416,   458,  1418,
      82,   513,   513,    75,    76,    77,    78,   513,  3848,   436,
      82,  3763,    72,   480,  1188,    75,    76,    77,    78,   636,
     436,    81,    82,    83,    84,   516,    86,   500,  1928,  1929,
    1483,   513,   355,  4987,  2219,   516,  1936,   513,   463,  4476,
     423,  4438,  5178,   448,   636,   436,   373,  1855,    95,   463,
     436,  2117,  1845,  1901,  1847,  2121,   509,  2123,   458,   516,
    2126,  4156,   513,  1398,   511,   682,   683,  3997,   515,   313,
     436,   456,   513,   516,   504,   505,   436,   373,   411,   516,
    1608,  2266,  1923,   513,   500,  2270,  4189,   463,  1616,  1617,
    4193,   509,  1896,  4490,   467,  4467,   373,  1775,  3776,   515,
    4180,   504,   505,  4012,   511,  1783,   516,   507,   504,   505,
     373,   411,   516,   730,   468,  2111,   411,  4103,   866,   426,
    2063,    88,   516,  4238,   377,  4179,  5079,    88,   451,   847,
     373,  3152,   504,   50