/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_CURRENT = 267,
     SQL_DATA = 268,
     SQL_DATETIME_INTERVAL_CODE = 269,
     SQL_DATETIME_INTERVAL_PRECISION = 270,
     SQL_DESCRIBE = 271,
     SQL_DESCRIPTOR = 272,
     SQL_DISCONNECT = 273,
     SQL_ENUM = 274,
     SQL_FOUND = 275,
     SQL_FREE = 276,
     SQL_GO = 277,
     SQL_GOTO = 278,
     SQL_IDENTIFIED = 279,
     SQL_INDICATOR = 280,
     SQL_KEY_MEMBER = 281,
     SQL_LENGTH = 282,
     SQL_LONG = 283,
     SQL_NAME = 284,
     SQL_NULLABLE = 285,
     SQL_OCTET_LENGTH = 286,
     SQL_OPEN = 287,
     SQL_OUTPUT = 288,
     SQL_REFERENCE = 289,
     SQL_RETURNED_LENGTH = 290,
     SQL_RETURNED_OCTET_LENGTH = 291,
     SQL_SCALE = 292,
     SQL_SECTION = 293,
     SQL_SHORT = 294,
     SQL_SIGNED = 295,
     SQL_SQL = 296,
     SQL_SQLERROR = 297,
     SQL_SQLPRINT = 298,
     SQL_SQLWARNING = 299,
     SQL_START = 300,
     SQL_STOP = 301,
     SQL_STRUCT = 302,
     SQL_UNSIGNED = 303,
     SQL_VALUE = 304,
     SQL_VAR = 305,
     SQL_WHENEVER = 306,
     S_ADD = 307,
     S_AND = 308,
     S_ANYTHING = 309,
     S_AUTO = 310,
     S_CONST = 311,
     S_DEC = 312,
     S_DIV = 313,
     S_DOTPOINT = 314,
     S_EQUAL = 315,
     S_EXTERN = 316,
     S_INC = 317,
     S_LSHIFT = 318,
     S_MEMPOINT = 319,
     S_MEMBER = 320,
     S_MOD = 321,
     S_MUL = 322,
     S_NEQUAL = 323,
     S_OR = 324,
     S_REGISTER = 325,
     S_RSHIFT = 326,
     S_STATIC = 327,
     S_SUB = 328,
     S_VOLATILE = 329,
     S_TYPEDEF = 330,
     TYPECAST = 331,
     ABORT_P = 332,
     ABSOLUTE_P = 333,
     ACCESS = 334,
     ACTION = 335,
     ADD_P = 336,
     ADMIN = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     ASYMMETRIC = 352,
     AT = 353,
     AUTHORIZATION = 354,
     BACKWARD = 355,
     BEFORE = 356,
     BEGIN_P = 357,
     BETWEEN = 358,
     BIGINT = 359,
     BINARY = 360,
     BIT = 361,
     BOOLEAN_P = 362,
     BOTH = 363,
     BY = 364,
     CACHE = 365,
     CALLED = 366,
     CASCADE = 367,
     CASCADED = 368,
     CASE = 369,
     CAST = 370,
     CHAIN = 371,
     CHAR_P = 372,
     CHARACTER = 373,
     CHARACTERISTICS = 374,
     CHECK = 375,
     CHECKPOINT = 376,
     CLASS = 377,
     CLOSE = 378,
     CLUSTER = 379,
     COALESCE = 380,
     COLLATE = 381,
     COLUMN = 382,
     COMMENT = 383,
     COMMIT = 384,
     COMMITTED = 385,
     CONCURRENTLY = 386,
     CONNECTION = 387,
     CONSTRAINT = 388,
     CONSTRAINTS = 389,
     CONVERSION_P = 390,
     CONVERT = 391,
     COPY = 392,
     CREATE = 393,
     CREATEDB = 394,
     CREATEROLE = 395,
     CREATEUSER = 396,
     CROSS = 397,
     CSV = 398,
     CURRENT_DATE = 399,
     CURRENT_ROLE = 400,
     CURRENT_TIME = 401,
     CURRENT_TIMESTAMP = 402,
     CURRENT_USER = 403,
     CURSOR = 404,
     CYCLE = 405,
     DATABASE = 406,
     DAY_P = 407,
     DEALLOCATE = 408,
     DEC = 409,
     DECIMAL_P = 410,
     DECLARE = 411,
     DEFAULT = 412,
     DEFAULTS = 413,
     DEFERRABLE = 414,
     DEFERRED = 415,
     DEFINER = 416,
     DELETE_P = 417,
     DELIMITER = 418,
     DELIMITERS = 419,
     DESC = 420,
     DISABLE_P = 421,
     DISTINCT = 422,
     DO = 423,
     DOMAIN_P = 424,
     DOUBLE_P = 425,
     DROP = 426,
     EACH = 427,
     ELSE = 428,
     ENABLE_P = 429,
     ENCODING = 430,
     ENCRYPTED = 431,
     END_P = 432,
     ESCAPE = 433,
     EXCEPT = 434,
     EXCLUSIVE = 435,
     EXCLUDING = 436,
     EXECUTE = 437,
     EXISTS = 438,
     EXPLAIN = 439,
     EXTERNAL = 440,
     EXTRACT = 441,
     FALSE_P = 442,
     FETCH = 443,
     FIRST_P = 444,
     FLOAT_P = 445,
     FOR = 446,
     FORCE = 447,
     FOREIGN = 448,
     FORWARD = 449,
     FREEZE = 450,
     FROM = 451,
     FULL = 452,
     FUNCTION = 453,
     GET = 454,
     GLOBAL = 455,
     GRANT = 456,
     GRANTED = 457,
     GREATEST = 458,
     GROUP_P = 459,
     HANDLER = 460,
     HAVING = 461,
     HEADER_P = 462,
     HOLD = 463,
     HOUR_P = 464,
     IF_P = 465,
     ILIKE = 466,
     IMMEDIATE = 467,
     IMMUTABLE = 468,
     IMPLICIT_P = 469,
     IN_P = 470,
     INCLUDING = 471,
     INCREMENT = 472,
     INDEX = 473,
     INDEXES = 474,
     INHERIT = 475,
     INHERITS = 476,
     INITIALLY = 477,
     INNER_P = 478,
     INOUT = 479,
     INPUT_P = 480,
     INSENSITIVE = 481,
     INSERT = 482,
     INSTEAD = 483,
     INT_P = 484,
     INTEGER = 485,
     INTERSECT = 486,
     INTERVAL = 487,
     INTO = 488,
     INVOKER = 489,
     IS = 490,
     ISNULL = 491,
     ISOLATION = 492,
     JOIN = 493,
     KEY = 494,
     LANCOMPILER = 495,
     LANGUAGE = 496,
     LARGE_P = 497,
     LAST_P = 498,
     LEADING = 499,
     LEAST = 500,
     LEFT = 501,
     LEVEL = 502,
     LIKE = 503,
     LIMIT = 504,
     LISTEN = 505,
     LOAD = 506,
     LOCAL = 507,
     LOCALTIME = 508,
     LOCALTIMESTAMP = 509,
     LOCATION = 510,
     LOCK_P = 511,
     LOGIN_P = 512,
     MATCH = 513,
     MAXVALUE = 514,
     MINUTE_P = 515,
     MINVALUE = 516,
     MODE = 517,
     MONTH_P = 518,
     MOVE = 519,
     NAMES = 520,
     NATIONAL = 521,
     NATURAL = 522,
     NCHAR = 523,
     NEW = 524,
     NEXT = 525,
     NO = 526,
     NOCREATEDB = 527,
     NOCREATEROLE = 528,
     NOCREATEUSER = 529,
     NOINHERIT = 530,
     NOLOGIN_P = 531,
     NONE = 532,
     NOSUPERUSER = 533,
     NOT = 534,
     NOTHING = 535,
     NOTIFY = 536,
     NOTNULL = 537,
     NOWAIT = 538,
     NULL_P = 539,
     NULLIF = 540,
     NUMERIC = 541,
     OBJECT_P = 542,
     OF = 543,
     OFF = 544,
     OFFSET = 545,
     OIDS = 546,
     OLD = 547,
     ON = 548,
     ONLY = 549,
     OPERATOR = 550,
     OPTION = 551,
     OR = 552,
     ORDER = 553,
     OUT_P = 554,
     OUTER_P = 555,
     OVERLAPS = 556,
     OVERLAY = 557,
     OWNED = 558,
     OWNER = 559,
     PARTIAL = 560,
     PASSWORD = 561,
     PLACING = 562,
     POSITION = 563,
     PRECISION = 564,
     PRESERVE = 565,
     PREPARE = 566,
     PREPARED = 567,
     PRIMARY = 568,
     PRIOR = 569,
     PRIVILEGES = 570,
     PROCEDURAL = 571,
     PROCEDURE = 572,
     QUOTE = 573,
     READ = 574,
     REAL = 575,
     REASSIGN = 576,
     RECHECK = 577,
     REFERENCES = 578,
     REINDEX = 579,
     RELATIVE_P = 580,
     RELEASE = 581,
     RENAME = 582,
     REPEATABLE = 583,
     REPLACE = 584,
     RESET = 585,
     RESTART = 586,
     RESTRICT = 587,
     RETURNING = 588,
     RETURNS = 589,
     REVOKE = 590,
     RIGHT = 591,
     ROLE = 592,
     ROLLBACK = 593,
     ROW = 594,
     ROWS = 595,
     RULE = 596,
     SAVEPOINT = 597,
     SCHEMA = 598,
     SCROLL = 599,
     SECOND_P = 600,
     SECURITY = 601,
     SELECT = 602,
     SEQUENCE = 603,
     SERIALIZABLE = 604,
     SESSION = 605,
     SESSION_USER = 606,
     SET = 607,
     SETOF = 608,
     SHARE = 609,
     SHOW = 610,
     SIMILAR = 611,
     SIMPLE = 612,
     SMALLINT = 613,
     SOME = 614,
     STABLE = 615,
     START = 616,
     STATEMENT = 617,
     STATISTICS = 618,
     STDIN = 619,
     STDOUT = 620,
     STORAGE = 621,
     STRICT_P = 622,
     SUBSTRING = 623,
     SUPERUSER_P = 624,
     SYMMETRIC = 625,
     SYSID = 626,
     SYSTEM_P = 627,
     TABLE = 628,
     TABLESPACE = 629,
     TEMP = 630,
     TEMPLATE = 631,
     TEMPORARY = 632,
     THEN = 633,
     TIME = 634,
     TIMESTAMP = 635,
     TO = 636,
     TRAILING = 637,
     TRANSACTION = 638,
     TREAT = 639,
     TRIGGER = 640,
     TRIM = 641,
     TRUE_P = 642,
     TRUNCATE = 643,
     TRUSTED = 644,
     TYPE_P = 645,
     UNCOMMITTED = 646,
     UNENCRYPTED = 647,
     UNION = 648,
     UNIQUE = 649,
     UNKNOWN = 650,
     UNLISTEN = 651,
     UNTIL = 652,
     UPDATE = 653,
     USER = 654,
     USING = 655,
     VACUUM = 656,
     VALID = 657,
     VALIDATOR = 658,
     VALUES = 659,
     VARCHAR = 660,
     VARYING = 661,
     VERBOSE = 662,
     VIEW = 663,
     VOLATILE = 664,
     WHEN = 665,
     WHERE = 666,
     WITH = 667,
     WITHOUT = 668,
     WORK = 669,
     WRITE = 670,
     YEAR_P = 671,
     ZONE = 672,
     WITH_CASCADED = 673,
     WITH_LOCAL = 674,
     WITH_CHECK = 675,
     IDENT = 676,
     SCONST = 677,
     Op = 678,
     CSTRING = 679,
     CVARIABLE = 680,
     CPP_LINE = 681,
     IP = 682,
     BCONST = 683,
     XCONST = 684,
     DOLCONST = 685,
     ICONST = 686,
     PARAM = 687,
     FCONST = 688,
     POSTFIXOP = 689,
     UMINUS = 690
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_CURRENT 267
#define SQL_DATA 268
#define SQL_DATETIME_INTERVAL_CODE 269
#define SQL_DATETIME_INTERVAL_PRECISION 270
#define SQL_DESCRIBE 271
#define SQL_DESCRIPTOR 272
#define SQL_DISCONNECT 273
#define SQL_ENUM 274
#define SQL_FOUND 275
#define SQL_FREE 276
#define SQL_GO 277
#define SQL_GOTO 278
#define SQL_IDENTIFIED 279
#define SQL_INDICATOR 280
#define SQL_KEY_MEMBER 281
#define SQL_LENGTH 282
#define SQL_LONG 283
#define SQL_NAME 284
#define SQL_NULLABLE 285
#define SQL_OCTET_LENGTH 286
#define SQL_OPEN 287
#define SQL_OUTPUT 288
#define SQL_REFERENCE 289
#define SQL_RETURNED_LENGTH 290
#define SQL_RETURNED_OCTET_LENGTH 291
#define SQL_SCALE 292
#define SQL_SECTION 293
#define SQL_SHORT 294
#define SQL_SIGNED 295
#define SQL_SQL 296
#define SQL_SQLERROR 297
#define SQL_SQLPRINT 298
#define SQL_SQLWARNING 299
#define SQL_START 300
#define SQL_STOP 301
#define SQL_STRUCT 302
#define SQL_UNSIGNED 303
#define SQL_VALUE 304
#define SQL_VAR 305
#define SQL_WHENEVER 306
#define S_ADD 307
#define S_AND 308
#define S_ANYTHING 309
#define S_AUTO 310
#define S_CONST 311
#define S_DEC 312
#define S_DIV 313
#define S_DOTPOINT 314
#define S_EQUAL 315
#define S_EXTERN 316
#define S_INC 317
#define S_LSHIFT 318
#define S_MEMPOINT 319
#define S_MEMBER 320
#define S_MOD 321
#define S_MUL 322
#define S_NEQUAL 323
#define S_OR 324
#define S_REGISTER 325
#define S_RSHIFT 326
#define S_STATIC 327
#define S_SUB 328
#define S_VOLATILE 329
#define S_TYPEDEF 330
#define TYPECAST 331
#define ABORT_P 332
#define ABSOLUTE_P 333
#define ACCESS 334
#define ACTION 335
#define ADD_P 336
#define ADMIN 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define ASYMMETRIC 352
#define AT 353
#define AUTHORIZATION 354
#define BACKWARD 355
#define BEFORE 356
#define BEGIN_P 357
#define BETWEEN 358
#define BIGINT 359
#define BINARY 360
#define BIT 361
#define BOOLEAN_P 362
#define BOTH 363
#define BY 364
#define CACHE 365
#define CALLED 366
#define CASCADE 367
#define CASCADED 368
#define CASE 369
#define CAST 370
#define CHAIN 371
#define CHAR_P 372
#define CHARACTER 373
#define CHARACTERISTICS 374
#define CHECK 375
#define CHECKPOINT 376
#define CLASS 377
#define CLOSE 378
#define CLUSTER 379
#define COALESCE 380
#define COLLATE 381
#define COLUMN 382
#define COMMENT 383
#define COMMIT 384
#define COMMITTED 385
#define CONCURRENTLY 386
#define CONNECTION 387
#define CONSTRAINT 388
#define CONSTRAINTS 389
#define CONVERSION_P 390
#define CONVERT 391
#define COPY 392
#define CREATE 393
#define CREATEDB 394
#define CREATEROLE 395
#define CREATEUSER 396
#define CROSS 397
#define CSV 398
#define CURRENT_DATE 399
#define CURRENT_ROLE 400
#define CURRENT_TIME 401
#define CURRENT_TIMESTAMP 402
#define CURRENT_USER 403
#define CURSOR 404
#define CYCLE 405
#define DATABASE 406
#define DAY_P 407
#define DEALLOCATE 408
#define DEC 409
#define DECIMAL_P 410
#define DECLARE 411
#define DEFAULT 412
#define DEFAULTS 413
#define DEFERRABLE 414
#define DEFERRED 415
#define DEFINER 416
#define DELETE_P 417
#define DELIMITER 418
#define DELIMITERS 419
#define DESC 420
#define DISABLE_P 421
#define DISTINCT 422
#define DO 423
#define DOMAIN_P 424
#define DOUBLE_P 425
#define DROP 426
#define EACH 427
#define ELSE 428
#define ENABLE_P 429
#define ENCODING 430
#define ENCRYPTED 431
#define END_P 432
#define ESCAPE 433
#define EXCEPT 434
#define EXCLUSIVE 435
#define EXCLUDING 436
#define EXECUTE 437
#define EXISTS 438
#define EXPLAIN 439
#define EXTERNAL 440
#define EXTRACT 441
#define FALSE_P 442
#define FETCH 443
#define FIRST_P 444
#define FLOAT_P 445
#define FOR 446
#define FORCE 447
#define FOREIGN 448
#define FORWARD 449
#define FREEZE 450
#define FROM 451
#define FULL 452
#define FUNCTION 453
#define GET 454
#define GLOBAL 455
#define GRANT 456
#define GRANTED 457
#define GREATEST 458
#define GROUP_P 459
#define HANDLER 460
#define HAVING 461
#define HEADER_P 462
#define HOLD 463
#define HOUR_P 464
#define IF_P 465
#define ILIKE 466
#define IMMEDIATE 467
#define IMMUTABLE 468
#define IMPLICIT_P 469
#define IN_P 470
#define INCLUDING 471
#define INCREMENT 472
#define INDEX 473
#define INDEXES 474
#define INHERIT 475
#define INHERITS 476
#define INITIALLY 477
#define INNER_P 478
#define INOUT 479
#define INPUT_P 480
#define INSENSITIVE 481
#define INSERT 482
#define INSTEAD 483
#define INT_P 484
#define INTEGER 485
#define INTERSECT 486
#define INTERVAL 487
#define INTO 488
#define INVOKER 489
#define IS 490
#define ISNULL 491
#define ISOLATION 492
#define JOIN 493
#define KEY 494
#define LANCOMPILER 495
#define LANGUAGE 496
#define LARGE_P 497
#define LAST_P 498
#define LEADING 499
#define LEAST 500
#define LEFT 501
#define LEVEL 502
#define LIKE 503
#define LIMIT 504
#define LISTEN 505
#define LOAD 506
#define LOCAL 507
#define LOCALTIME 508
#define LOCALTIMESTAMP 509
#define LOCATION 510
#define LOCK_P 511
#define LOGIN_P 512
#define MATCH 513
#define MAXVALUE 514
#define MINUTE_P 515
#define MINVALUE 516
#define MODE 517
#define MONTH_P 518
#define MOVE 519
#define NAMES 520
#define NATIONAL 521
#define NATURAL 522
#define NCHAR 523
#define NEW 524
#define NEXT 525
#define NO 526
#define NOCREATEDB 527
#define NOCREATEROLE 528
#define NOCREATEUSER 529
#define NOINHERIT 530
#define NOLOGIN_P 531
#define NONE 532
#define NOSUPERUSER 533
#define NOT 534
#define NOTHING 535
#define NOTIFY 536
#define NOTNULL 537
#define NOWAIT 538
#define NULL_P 539
#define NULLIF 540
#define NUMERIC 541
#define OBJECT_P 542
#define OF 543
#define OFF 544
#define OFFSET 545
#define OIDS 546
#define OLD 547
#define ON 548
#define ONLY 549
#define OPERATOR 550
#define OPTION 551
#define OR 552
#define ORDER 553
#define OUT_P 554
#define OUTER_P 555
#define OVERLAPS 556
#define OVERLAY 557
#define OWNED 558
#define OWNER 559
#define PARTIAL 560
#define PASSWORD 561
#define PLACING 562
#define POSITION 563
#define PRECISION 564
#define PRESERVE 565
#define PREPARE 566
#define PREPARED 567
#define PRIMARY 568
#define PRIOR 569
#define PRIVILEGES 570
#define PROCEDURAL 571
#define PROCEDURE 572
#define QUOTE 573
#define READ 574
#define REAL 575
#define REASSIGN 576
#define RECHECK 577
#define REFERENCES 578
#define REINDEX 579
#define RELATIVE_P 580
#define RELEASE 581
#define RENAME 582
#define REPEATABLE 583
#define REPLACE 584
#define RESET 585
#define RESTART 586
#define RESTRICT 587
#define RETURNING 588
#define RETURNS 589
#define REVOKE 590
#define RIGHT 591
#define ROLE 592
#define ROLLBACK 593
#define ROW 594
#define ROWS 595
#define RULE 596
#define SAVEPOINT 597
#define SCHEMA 598
#define SCROLL 599
#define SECOND_P 600
#define SECURITY 601
#define SELECT 602
#define SEQUENCE 603
#define SERIALIZABLE 604
#define SESSION 605
#define SESSION_USER 606
#define SET 607
#define SETOF 608
#define SHARE 609
#define SHOW 610
#define SIMILAR 611
#define SIMPLE 612
#define SMALLINT 613
#define SOME 614
#define STABLE 615
#define START 616
#define STATEMENT 617
#define STATISTICS 618
#define STDIN 619
#define STDOUT 620
#define STORAGE 621
#define STRICT_P 622
#define SUBSTRING 623
#define SUPERUSER_P 624
#define SYMMETRIC 625
#define SYSID 626
#define SYSTEM_P 627
#define TABLE 628
#define TABLESPACE 629
#define TEMP 630
#define TEMPLATE 631
#define TEMPORARY 632
#define THEN 633
#define TIME 634
#define TIMESTAMP 635
#define TO 636
#define TRAILING 637
#define TRANSACTION 638
#define TREAT 639
#define TRIGGER 640
#define TRIM 641
#define TRUE_P 642
#define TRUNCATE 643
#define TRUSTED 644
#define TYPE_P 645
#define UNCOMMITTED 646
#define UNENCRYPTED 647
#define UNION 648
#define UNIQUE 649
#define UNKNOWN 650
#define UNLISTEN 651
#define UNTIL 652
#define UPDATE 653
#define USER 654
#define USING 655
#define VACUUM 656
#define VALID 657
#define VALIDATOR 658
#define VALUES 659
#define VARCHAR 660
#define VARYING 661
#define VERBOSE 662
#define VIEW 663
#define VOLATILE 664
#define WHEN 665
#define WHERE 666
#define WITH 667
#define WITHOUT 668
#define WORK 669
#define WRITE 670
#define YEAR_P 671
#define ZONE 672
#define WITH_CASCADED 673
#define WITH_LOCAL 674
#define WITH_CHECK 675
#define IDENT 676
#define SCONST 677
#define Op 678
#define CSTRING 679
#define CVARIABLE 680
#define CPP_LINE 681
#define IP 682
#define BCONST 683
#define XCONST 684
#define DOLCONST 685
#define ICONST 686
#define PARAM 687
#define FCONST 688
#define POSTFIXOP 689
#define UMINUS 690




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

/* INFORMIX workaround, no longer needed
static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;
*/

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 310 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1265 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1277 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   63078

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  456
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  545
/* YYNRULES -- Number of rules. */
#define YYNRULES  2101
/* YYNRULES -- Number of states. */
#define YYNSTATES  3539

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   691

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   442,     2,     2,
     447,   448,   440,   438,   454,   439,   449,   441,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   455,   450,
     435,   434,   436,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   445,     2,   446,   443,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   451,     2,   452,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   437,
     444,   453
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   236,   238,   244,   246,   247,
     250,   253,   257,   261,   263,   265,   267,   269,   271,   273,
     275,   277,   279,   281,   285,   289,   292,   295,   298,   301,
     305,   309,   315,   321,   327,   332,   338,   344,   349,   353,
     359,   363,   369,   375,   382,   384,   386,   390,   396,   403,
     408,   410,   411,   414,   415,   417,   419,   421,   423,   425,
     427,   430,   434,   438,   442,   446,   450,   453,   459,   462,
     465,   469,   473,   475,   479,   481,   483,   485,   489,   492,
     495,   498,   500,   502,   504,   506,   508,   510,   512,   514,
     516,   518,   522,   529,   531,   533,   535,   537,   538,   540,
     542,   546,   551,   557,   562,   565,   568,   572,   577,   581,
     584,   589,   591,   593,   595,   597,   599,   604,   609,   611,
     615,   619,   624,   631,   638,   645,   652,   657,   664,   667,
     672,   676,   680,   684,   688,   692,   696,   700,   704,   708,
     711,   715,   717,   719,   723,   727,   731,   734,   737,   741,
     744,   746,   748,   749,   752,   753,   756,   766,   773,   775,
     777,   779,   781,   783,   786,   787,   789,   791,   795,   799,
     801,   803,   807,   811,   815,   820,   822,   823,   826,   827,
     831,   832,   834,   835,   847,   860,   862,   864,   867,   870,
     873,   876,   877,   879,   880,   882,   886,   888,   890,   892,
     896,   899,   900,   904,   906,   908,   911,   913,   917,   922,
     927,   930,   936,   938,   941,   944,   947,   951,   954,   955,
     958,   961,   964,   967,   970,   973,   977,   979,   984,   991,
     999,  1011,  1015,  1016,  1020,  1022,  1024,  1027,  1030,  1031,
    1033,  1035,  1038,  1041,  1042,  1046,  1050,  1053,  1055,  1057,
    1060,  1063,  1068,  1069,  1072,  1075,  1078,  1079,  1083,  1088,
    1093,  1094,  1097,  1098,  1103,  1104,  1105,  1117,  1121,  1122,
    1126,  1128,  1130,  1136,  1141,  1144,  1145,  1148,  1150,  1153,
    1157,  1160,  1163,  1166,  1169,  1173,  1177,  1181,  1183,  1184,
    1190,  1200,  1202,  1203,  1205,  1208,  1211,  1212,  1215,  1216,
    1222,  1230,  1232,  1233,  1240,  1243,  1244,  1248,  1254,  1269,
    1289,  1291,  1293,  1295,  1299,  1305,  1307,  1309,  1311,  1315,
    1316,  1318,  1319,  1321,  1323,  1325,  1329,  1330,  1332,  1334,
    1335,  1338,  1340,  1343,  1345,  1348,  1349,  1352,  1354,  1357,
    1360,  1367,  1376,  1385,  1389,  1395,  1400,  1405,  1410,  1414,
    1422,  1426,  1428,  1432,  1436,  1438,  1440,  1442,  1444,  1446,
    1448,  1452,  1456,  1458,  1462,  1466,  1468,  1472,  1476,  1489,
    1491,  1495,  1500,  1508,  1513,  1516,  1518,  1519,  1521,  1522,
    1530,  1540,  1546,  1553,  1560,  1565,  1567,  1569,  1571,  1573,
    1575,  1577,  1579,  1581,  1583,  1587,  1589,  1592,  1595,  1599,
    1604,  1610,  1615,  1620,  1624,  1629,  1633,  1637,  1640,  1645,
    1648,  1650,  1652,  1654,  1656,  1659,  1662,  1664,  1666,  1668,
    1671,  1674,  1676,  1679,  1682,  1684,  1686,  1693,  1701,  1709,
    1719,  1728,  1737,  1744,  1754,  1762,  1773,  1781,  1783,  1785,
    1787,  1789,  1791,  1793,  1795,  1797,  1799,  1801,  1803,  1805,
    1807,  1809,  1817,  1825,  1836,  1839,  1841,  1843,  1845,  1849,
    1851,  1853,  1855,  1857,  1859,  1862,  1865,  1868,  1871,  1874,
    1877,  1880,  1882,  1886,  1888,  1891,  1895,  1896,  1898,  1902,
    1905,  1912,  1919,  1923,  1924,  1928,  1929,  1943,  1958,  1960,
    1961,  1964,  1965,  1967,  1971,  1974,  1977,  1982,  1984,  1987,
    1988,  1998,  2006,  2009,  2010,  2014,  2017,  2019,  2023,  2027,
    2031,  2034,  2037,  2039,  2041,  2043,  2045,  2048,  2050,  2054,
    2056,  2058,  2064,  2066,  2071,  2073,  2076,  2081,  2087,  2089,
    2091,  2093,  2095,  2099,  2103,  2106,  2109,  2112,  2115,  2117,
    2120,  2121,  2127,  2129,  2132,  2134,  2135,  2141,  2149,  2155,
    2163,  2171,  2181,  2183,  2187,  2191,  2195,  2197,  2201,  2213,
    2224,  2227,  2228,  2238,  2241,  2242,  2247,  2252,  2257,  2259,
    2261,  2263,  2264,  2272,  2279,  2286,  2294,  2301,  2308,  2318,
    2325,  2332,  2339,  2348,  2357,  2364,  2371,  2373,  2374,  2382,
    2389,  2397,  2404,  2411,  2418,  2426,  2433,  2440,  2447,  2455,
    2465,  2475,  2482,  2489,  2496,  2497,  2512,  2514,  2516,  2520,
    2524,  2526,  2528,  2530,  2532,  2534,  2536,  2538,  2539,  2541,
    2543,  2545,  2547,  2549,  2551,  2552,  2559,  2568,  2571,  2574,
    2577,  2580,  2583,  2587,  2591,  2594,  2597,  2600,  2603,  2607,
    2610,  2616,  2621,  2625,  2629,  2633,  2635,  2637,  2638,  2642,
    2645,  2648,  2650,  2654,  2657,  2659,  2660,  2669,  2680,  2683,
    2687,  2691,  2692,  2695,  2701,  2705,  2707,  2710,  2714,  2718,
    2722,  2726,  2730,  2734,  2738,  2742,  2747,  2751,  2755,  2757,
    2758,  2764,  2770,  2775,  2778,  2779,  2784,  2788,  2794,  2801,
    2806,  2813,  2820,  2826,  2834,  2836,  2837,  2848,  2853,  2856,
    2858,  2863,  2869,  2875,  2878,  2883,  2885,  2887,  2889,  2890,
    2892,  2893,  2895,  2896,  2900,  2901,  2906,  2908,  2910,  2912,
    2914,  2916,  2918,  2919,  2925,  2927,  2932,  2935,  2939,  2941,
    2944,  2947,  2948,  2955,  2958,  2959,  2965,  2969,  2970,  2973,
    2976,  2979,  2983,  2985,  2989,  2991,  2994,  2996,  2997,  3005,
    3007,  3011,  3013,  3015,  3019,  3025,  3028,  3030,  3034,  3042,
    3043,  3046,  3049,  3052,  3056,  3057,  3060,  3063,  3065,  3067,
    3071,  3075,  3077,  3080,  3085,  3090,  3092,  3094,  3103,  3105,
    3110,  3115,  3120,  3123,  3125,  3126,  3130,  3134,  3139,  3144,
    3149,  3154,  3157,  3159,  3161,  3162,  3164,  3165,  3167,  3173,
    3175,  3176,  3178,  3179,  3183,  3185,  3189,  3193,  3196,  3199,
    3201,  3206,  3211,  3214,  3217,  3222,  3224,  3225,  3227,  3229,
    3231,  3235,  3236,  3239,  3240,  3242,  3246,  3248,  3249,  3251,
    3254,  3259,  3264,  3267,  3268,  3271,  3275,  3278,  3279,  3283,
    3285,  3287,  3290,  3292,  3295,  3301,  3308,  3314,  3316,  3319,
    3321,  3326,  3330,  3335,  3341,  3346,  3352,  3357,  3363,  3366,
    3371,  3373,  3376,  3379,  3382,  3384,  3386,  3387,  3392,  3395,
    3397,  3400,  3403,  3408,  3410,  3413,  3417,  3419,  3422,  3423,
    3425,  3429,  3432,  3435,  3439,  3445,  3452,  3456,  3461,  3462,
    3464,  3468,  3472,  3476,  3480,  3484,  3488,  3490,  3492,  3494,
    3496,  3498,  3500,  3502,  3505,  3511,  3514,  3516,  3518,  3520,
    3522,  3524,  3526,  3528,  3530,  3532,  3534,  3536,  3539,  3542,
    3545,  3548,  3551,  3553,  3557,  3558,  3564,  3568,  3569,  3575,
    3579,  3580,  3582,  3584,  3586,  3588,  3594,  3597,  3599,  3601,
    3603,  3605,  3611,  3614,  3617,  3620,  3622,  3626,  3630,  3633,
    3635,  3636,  3640,  3641,  3647,  3650,  3656,  3659,  3661,  3665,
    3669,  3670,  3672,  3674,  3676,  3678,  3680,  3682,  3686,  3690,
    3694,  3698,  3702,  3706,  3710,  3711,  3713,  3717,  3723,  3726,
    3729,  3733,  3737,  3741,  3745,  3749,  3753,  3757,  3761,  3765,
    3769,  3772,  3775,  3779,  3783,  3786,  3790,  3796,  3801,  3808,
    3812,  3818,  3823,  3830,  3835,  3842,  3848,  3856,  3859,  3863,
    3866,  3871,  3875,  3879,  3884,  3888,  3893,  3897,  3902,  3908,
    3915,  3922,  3930,  3937,  3945,  3952,  3960,  3964,  3969,  3974,
    3981,  3984,  3986,  3990,  3993,  3997,  4001,  4005,  4009,  4013,
    4017,  4021,  4025,  4029,  4033,  4036,  4039,  4045,  4052,  4059,
    4067,  4069,  4071,  4074,  4079,  4081,  4083,  4085,  4088,  4091,
    4094,  4096,  4100,  4105,  4111,  4117,  4122,  4124,  4126,  4131,
    4133,  4138,  4140,  4145,  4147,  4152,  4154,  4156,  4158,  4160,
    4167,  4172,  4177,  4182,  4187,  4194,  4200,  4206,  4212,  4217,
    4224,  4229,  4236,  4241,  4246,  4251,  4256,  4260,  4266,  4268,
    4270,  4272,  4274,  4276,  4278,  4280,  4282,  4284,  4286,  4288,
    4290,  4292,  4294,  4296,  4301,  4303,  4308,  4310,  4315,  4317,
    4320,  4322,  4325,  4327,  4331,  4335,  4336,  4340,  4342,  4344,
    4348,  4352,  4356,  4358,  4360,  4362,  4364,  4366,  4368,  4370,
    4372,  4377,  4381,  4384,  4388,  4389,  4393,  4397,  4400,  4403,
    4405,  4406,  4409,  4412,  4416,  4419,  4421,  4423,  4427,  4433,
    4436,  4438,  4443,  4446,  4447,  4449,  4450,  4452,  4455,  4458,
    4461,  4465,  4471,  4473,  4476,  4477,  4480,  4482,  4483,  4485,
    4487,  4489,  4493,  4497,  4501,  4503,  4507,  4509,  4511,  4513,
    4515,  4517,  4521,  4523,  4526,  4528,  4532,  4534,  4536,  4538,
    4540,  4542,  4544,  4546,  4549,  4551,  4554,  4558,  4565,  4567,
    4569,  4571,  4573,  4575,  4577,  4579,  4581,  4583,  4585,  4587,
    4589,  4591,  4594,  4596,  4598,  4600,  4602,  4605,  4608,  4610,
    4612,  4614,  4616,  4618,  4620,  4622,  4624,  4627,  4630,  4632,
    4634,  4636,  4638,  4640,  4642,  4644,  4646,  4648,  4650,  4652,
    4654,  4660,  4664,  4667,  4670,  4674,  4682,  4684,  4686,  4688,
    4689,  4692,  4695,  4697,  4698,  4700,  4704,  4706,  4709,  4710,
    4713,  4714,  4717,  4718,  4720,  4724,  4729,  4733,  4735,  4737,
    4739,  4742,  4743,  4751,  4755,  4758,  4760,  4762,  4764,  4765,
    4771,  4772,  4777,  4780,  4782,  4785,  4786,  4788,  4792,  4796,
    4800,  4804,  4805,  4810,  4816,  4822,  4823,  4825,  4827,  4829,
    4831,  4834,  4837,  4840,  4842,  4845,  4846,  4854,  4855,  4861,
    4862,  4867,  4870,  4873,  4874,  4877,  4879,  4881,  4883,  4885,
    4887,  4889,  4891,  4893,  4895,  4897,  4899,  4905,  4908,  4910,
    4914,  4917,  4920,  4924,  4925,  4931,  4933,  4934,  4940,  4943,
    4946,  4948,  4950,  4952,  4955,  4958,  4962,  4964,  4967,  4970,
    4974,  4978,  4983,  4986,  4988,  4991,  4993,  4995,  4998,  5001,
    5005,  5007,  5009,  5011,  5013,  5014,  5016,  5020,  5026,  5027,
    5030,  5031,  5033,  5036,  5040,  5043,  5045,  5047,  5049,  5050,
    5052,  5054,  5056,  5060,  5061,  5066,  5069,  5072,  5074,  5076,
    5077,  5079,  5081,  5083,  5085,  5088,  5092,  5093,  5095,  5098,
    5100,  5105,  5110,  5111,  5113,  5116,  5118,  5120,  5124,  5126,
    5128,  5133,  5138,  5143,  5148,  5150,  5151,  5155,  5159,  5164,
    5166,  5170,  5174,  5179,  5181,  5185,  5189,  5191,  5198,  5200,
    5204,  5208,  5215,  5217,  5221,  5225,  5227,  5229,  5231,  5233,
    5235,  5237,  5239,  5241,  5243,  5245,  5247,  5249,  5251,  5253,
    5255,  5260,  5265,  5267,  5269,  5274,  5279,  5283,  5284,  5292,
    5294,  5295,  5296,  5304,  5308,  5313,  5317,  5319,  5321,  5323,
    5326,  5330,  5336,  5339,  5345,  5348,  5350,  5352,  5354,  5356,
    5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,  5374,  5376,
    5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,  5394,  5396,
    5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,  5414,  5416,
    5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,  5434,  5436,
    5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,  5454,  5456,
    5458,  5460,  5462,  5464,  5466,  5468,  5470,  5472,  5474,  5476,
    5478,  5480,  5482,  5484,  5486,  5488,  5490,  5492,  5494,  5496,
    5498,  5500,  5502,  5504,  5506,  5508,  5510,  5512,  5514,  5516,
    5518,  5520,  5522,  5524,  5526,  5528,  5530,  5532,  5534,  5536,
    5538,  5540,  5542,  5544,  5546,  5548,  5550,  5552,  5554,  5556,
    5558,  5560,  5562,  5564,  5566,  5568,  5570,  5572,  5574,  5576,
    5578,  5580,  5582,  5584,  5586,  5588,  5590,  5592,  5594,  5596,
    5598,  5600,  5602,  5604,  5606,  5608,  5610,  5612,  5614,  5616,
    5618,  5620,  5622,  5624,  5626,  5628,  5630,  5632,  5634,  5636,
    5638,  5640,  5642,  5644,  5646,  5648,  5650,  5652,  5654,  5656,
    5658,  5660,  5662,  5664,  5666,  5668,  5670,  5672,  5674,  5676,
    5678,  5680,  5682,  5684,  5686,  5688,  5690,  5692,  5694,  5696,
    5698,  5700,  5702,  5704,  5706,  5708,  5710,  5712,  5714,  5716,
    5718,  5720,  5722,  5724,  5726,  5728,  5730,  5732,  5734,  5736,
    5738,  5740,  5742,  5744,  5746,  5748,  5750,  5752,  5754,  5756,
    5758,  5760,  5762,  5764,  5766,  5768,  5770,  5772,  5774,  5776,
    5778,  5780,  5782,  5784,  5786,  5788,  5790,  5792,  5794,  5796,
    5798,  5800,  5802,  5804,  5806,  5808,  5810,  5812,  5814,  5816,
    5818,  5820,  5822,  5824,  5826,  5828,  5830,  5832,  5834,  5836,
    5838,  5840,  5842,  5844,  5846,  5848,  5850,  5852,  5854,  5856,
    5858,  5860,  5862,  5864,  5866,  5868,  5870,  5872,  5874,  5876,
    5878,  5880,  5882,  5884,  5886,  5888,  5890,  5892,  5894,  5896,
    5898,  5900,  5902,  5904,  5906,  5908,  5910,  5912,  5914,  5916,
    5918,  5920,  5922,  5924,  5926,  5928,  5930,  5932,  5934,  5936,
    5938,  5940,  5942,  5944,  5946,  5948,  5950,  5952,  5954,  5956,
    5958,  5960,  5962,  5964,  5966,  5968,  5970,  5972,  5974,  5976,
    5978,  5980,  5982,  5984,  5986,  5988,  5990,  5992,  5994,  5996,
    5998,  6000,  6002,  6004,  6006,  6008,  6010,  6012,  6014,  6016,
    6018,  6020,  6022,  6024,  6026,  6028,  6030,  6032,  6034,  6036,
    6038,  6040,  6042,  6044,  6046,  6048,  6050,  6052,  6054,  6056,
    6058,  6060,  6062,  6064,  6066,  6068,  6070,  6072,  6074,  6076,
    6078,  6080,  6082,  6084,  6086,  6088,  6090,  6092,  6094,  6096,
    6098,  6100,  6102,  6104,  6106,  6108,  6110,  6112,  6114,  6116,
    6118,  6120,  6122,  6124,  6126,  6128,  6130,  6132,  6134,  6136,
    6138,  6140,  6142,  6144,  6146,  6148,  6150,  6152,  6154,  6156,
    6158,  6160,  6162,  6164,  6166,  6168,  6170,  6172,  6174,  6176,
    6178,  6180,  6182,  6184,  6186,  6188,  6192,  6194,  6195,  6197,
    6200,  6202,  6205,  6207,  6209,  6212,  6215,  6217,  6219,  6221,
    6223,  6225,  6227,  6230,  6234,  6236,  6239,  6241,  6245,  6247,
    6251,  6253,  6255,  6257,  6259,  6261,  6263,  6265,  6267,  6269,
    6271,  6273,  6275,  6277,  6279,  6281,  6283,  6285,  6287,  6289,
    6291,  6293,  6295,  6297,  6299,  6301,  6303,  6305,  6307,  6309,
    6311,  6313,  6315,  6317,  6319,  6321,  6323,  6325,  6327,  6329,
    6331,  6333,  6335,  6337,  6339,  6341,  6343,  6345,  6347,  6349,
    6351,  6353,  6355,  6357,  6359,  6361,  6363,  6365,  6367,  6369,
    6371,  6373
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     457,     0,    -1,   458,    -1,    -1,   458,   459,    -1,   986,
     460,   461,   450,    -1,   986,   461,   450,    -1,   986,   876,
      -1,   884,    -1,   999,    -1,   426,    -1,   451,    -1,   452,
      -1,    98,   920,    -1,   686,    -1,   687,    -1,   692,    -1,
     643,    -1,   472,    -1,   660,    -1,   661,    -1,   548,    -1,
     496,    -1,   467,    -1,   466,    -1,   468,    -1,   697,    -1,
     495,    -1,   504,    -1,   695,    -1,   605,    -1,   492,    -1,
     505,    -1,   542,    -1,   576,    -1,   651,    -1,   694,    -1,
     691,    -1,   629,    -1,   471,    -1,   552,    -1,   588,    -1,
     462,    -1,   475,    -1,   547,    -1,   514,    -1,   559,    -1,
     562,    -1,   465,    -1,   682,    -1,   724,    -1,   578,    -1,
     711,    -1,   577,    -1,   653,    -1,   474,    -1,   593,    -1,
     594,    -1,   557,    -1,   469,    -1,   670,    -1,   596,    -1,
     561,    -1,   575,    -1,   470,    -1,   690,    -1,   703,    -1,
     602,    -1,   608,    -1,   619,    -1,   623,    -1,   706,    -1,
     672,    -1,   681,    -1,   713,    -1,   671,    -1,   595,    -1,
     655,    -1,   647,    -1,   648,    -1,   646,    -1,   658,    -1,
     609,    -1,   620,    -1,   662,    -1,   727,    -1,   674,    -1,
     601,    -1,   673,    -1,   717,    -1,   696,    -1,   479,    -1,
     490,    -1,   491,    -1,   679,    -1,   939,    -1,   860,    -1,
     874,    -1,   875,    -1,   940,    -1,   917,    -1,   937,    -1,
     918,    -1,   921,    -1,   926,    -1,   948,    -1,   941,    -1,
     927,    -1,   936,    -1,   955,    -1,   957,    -1,   951,    -1,
     944,    -1,   958,    -1,   961,    -1,   963,    -1,   138,   337,
     858,   463,   464,    -1,   412,    -1,    -1,   306,   848,    -1,
     306,   284,    -1,   176,   306,   848,    -1,   392,   306,   848,
      -1,   369,    -1,   278,    -1,   220,    -1,   275,    -1,   139,
      -1,   272,    -1,   140,    -1,   273,    -1,   257,    -1,   276,
      -1,   132,   249,   850,    -1,   402,   397,   848,    -1,   399,
     835,    -1,   371,   849,    -1,    82,   835,    -1,   337,   835,
      -1,   215,   337,   835,    -1,   215,   204,   835,    -1,   138,
     399,   858,   463,   464,    -1,    87,   337,   858,   463,   464,
      -1,    87,   337,   858,   352,   480,    -1,    87,   337,   858,
     491,    -1,    87,   399,   858,   463,   464,    -1,    87,   399,
     858,   352,   480,    -1,    87,   399,   858,   491,    -1,   171,
     337,   835,    -1,   171,   337,   210,   183,   835,    -1,   171,
     399,   835,    -1,   171,   399,   210,   183,   835,    -1,   138,
     204,   858,   463,   464,    -1,    87,   204,   858,   473,   399,
     835,    -1,    81,    -1,   171,    -1,   171,   204,   835,    -1,
     171,   204,   210,   183,   835,    -1,   138,   343,   476,    99,
     858,   477,    -1,   138,   343,   971,   477,    -1,   971,    -1,
      -1,   477,   478,    -1,    -1,   514,    -1,   623,    -1,   547,
      -1,   562,    -1,   608,    -1,   679,    -1,   352,   480,    -1,
     352,   252,   480,    -1,   352,   350,   480,    -1,   481,   381,
     482,    -1,   481,   453,   482,    -1,   379,   417,   487,    -1,
     383,   677,    -1,   350,   119,    93,   383,   677,    -1,   265,
     488,    -1,   337,   489,    -1,   350,    99,   489,    -1,   350,
      99,   157,    -1,   970,    -1,   481,   449,   971,    -1,   483,
      -1,   157,    -1,   485,    -1,   483,   454,   485,    -1,   319,
     391,    -1,   319,   130,    -1,   328,   319,    -1,   349,    -1,
     486,    -1,   856,    -1,   971,    -1,   387,    -1,   187,    -1,
     293,    -1,   289,    -1,   856,    -1,   993,    -1,   789,   853,
     791,    -1,   789,   447,   849,   448,   853,   791,    -1,   157,
      -1,   252,    -1,   853,    -1,   157,    -1,    -1,   971,    -1,
     853,    -1,   355,   481,   933,    -1,   355,   379,   417,   933,
      -1,   355,   383,   237,   247,   933,    -1,   355,   350,    99,
     933,    -1,   355,    85,    -1,   330,   481,    -1,   330,   379,
     417,    -1,   330,   383,   237,   247,    -1,   330,   350,    99,
      -1,   330,    85,    -1,   352,   134,   493,   494,    -1,    85,
      -1,   833,    -1,   160,    -1,   212,    -1,   121,    -1,    87,
     373,   761,   497,    -1,    87,   218,   761,   499,    -1,   498,
      -1,   497,   454,   498,    -1,    81,   659,   519,    -1,    87,
     659,   971,   501,    -1,    87,   659,   971,   171,   279,   284,
      -1,    87,   659,   971,   352,   279,   284,    -1,    87,   659,
     971,   352,   363,   849,    -1,    87,   659,   971,   352,   366,
     971,    -1,   171,   659,   971,   502,    -1,    87,   659,   971,
     390,   767,   503,    -1,    81,   527,    -1,   171,   133,   836,
     502,    -1,   352,   413,   291,    -1,   124,   293,   836,    -1,
     352,   413,   124,    -1,   174,   385,   836,    -1,   174,   385,
      85,    -1,   174,   385,   399,    -1,   166,   385,   836,    -1,
     166,   385,    85,    -1,   166,   385,   399,    -1,   220,   834,
      -1,   271,   220,   834,    -1,   500,    -1,   500,    -1,   499,
     454,   500,    -1,   304,   381,   858,    -1,   352,   374,   836,
      -1,   352,   579,    -1,   330,   579,    -1,   352,   157,   792,
      -1,   171,   157,    -1,   112,    -1,   332,    -1,    -1,   400,
     792,    -1,    -1,   123,   836,    -1,   137,   510,   834,   511,
     506,   507,   512,   463,   508,    -1,   137,   728,   381,   507,
     463,   508,    -1,   381,    -1,   196,    -1,   853,    -1,   364,
      -1,   365,    -1,   508,   509,    -1,    -1,   105,    -1,   291,
      -1,   163,   693,   853,    -1,   284,   693,   853,    -1,   143,
      -1,   207,    -1,   318,   693,   848,    -1,   178,   693,   848,
      -1,   192,   318,   530,    -1,   192,   279,   284,   530,    -1,
     105,    -1,    -1,   412,   291,    -1,    -1,   513,   164,   853,
      -1,    -1,   400,    -1,    -1,   138,   515,   373,   834,   447,
     516,   448,   537,   538,   539,   540,    -1,   138,   515,   373,
     834,   288,   834,   447,   516,   448,   538,   539,   540,    -1,
     377,    -1,   375,    -1,   252,   377,    -1,   252,   375,    -1,
     200,   377,    -1,   200,   375,    -1,    -1,   517,    -1,    -1,
     518,    -1,   517,   454,   518,    -1,   519,    -1,   524,    -1,
     527,    -1,   971,   767,   520,    -1,   520,   521,    -1,    -1,
     133,   836,   522,    -1,   522,    -1,   523,    -1,   279,   284,
      -1,   284,    -1,   394,   642,   541,    -1,   313,   239,   642,
     541,    -1,   120,   447,   792,   448,    -1,   157,   793,    -1,
     323,   834,   529,   532,   533,    -1,   159,    -1,   279,   159,
      -1,   222,   160,    -1,   222,   212,    -1,   248,   834,   525,
      -1,   525,   526,    -1,    -1,   216,   158,    -1,   181,   158,
      -1,   216,   134,    -1,   181,   134,    -1,   216,   219,    -1,
     181,   219,    -1,   133,   836,   528,    -1,   528,    -1,   120,
     447,   792,   448,    -1,   394,   447,   530,   448,   642,   541,
      -1,   313,   239,   447,   530,   448,   642,   541,    -1,   193,
     239,   447,   530,   448,   323,   834,   529,   532,   533,   572,
      -1,   447,   530,   448,    -1,    -1,   530,   454,   531,    -1,
     531,    -1,   971,    -1,   258,   197,    -1,   258,   305,    -1,
      -1,   534,    -1,   535,    -1,   534,   535,    -1,   535,   534,
      -1,    -1,   293,   162,   536,    -1,   293,   398,   536,    -1,
     271,    80,    -1,   332,    -1,   112,    -1,   352,   157,    -1,
     352,   284,    -1,   221,   447,   833,   448,    -1,    -1,   412,
     579,    -1,   412,   291,    -1,   413,   291,    -1,    -1,   293,
     129,   171,    -1,   293,   129,   162,   340,    -1,   293,   129,
     310,   340,    -1,    -1,   374,   836,    -1,    -1,   400,   218,
     374,   836,    -1,    -1,    -1,   138,   515,   373,   834,   544,
     538,   539,   540,    93,   543,   727,    -1,   447,   545,   448,
      -1,    -1,   545,   454,   546,    -1,   546,    -1,   971,    -1,
     138,   515,   348,   834,   549,    -1,    87,   348,   834,   549,
      -1,   549,   550,    -1,    -1,   110,   855,    -1,   150,    -1,
     271,   150,    -1,   217,   551,   855,    -1,   259,   855,    -1,
     261,   855,    -1,   271,   259,    -1,   271,   261,    -1,   303,
     109,   599,    -1,   361,   463,   855,    -1,   331,   463,   855,
      -1,   109,    -1,    -1,   138,   553,   558,   241,   489,    -1,
     138,   553,   558,   241,   489,   205,   554,   555,   556,    -1,
     389,    -1,    -1,   836,    -1,   836,   600,    -1,   403,   554,
      -1,    -1,   240,   853,    -1,    -1,   171,   558,   241,   853,
     502,    -1,   171,   558,   241,   210,   183,   853,   502,    -1,
     316,    -1,    -1,   138,   374,   836,   560,   255,   848,    -1,
     304,   836,    -1,    -1,   171,   374,   836,    -1,   171,   374,
     210,   183,   836,    -1,   138,   385,   836,   563,   564,   293,
     834,   566,   182,   317,   836,   447,   569,   448,    -1,   138,
     133,   385,   836,    83,   564,   293,   834,   571,   572,   191,
     172,   339,   182,   317,   842,   447,   569,   448,    -1,   101,
      -1,    83,    -1,   565,    -1,   565,   297,   565,    -1,   565,
     297,   565,   297,   565,    -1,   227,    -1,   162,    -1,   398,
      -1,   191,   567,   568,    -1,    -1,   172,    -1,    -1,   339,
      -1,   362,    -1,   570,    -1,   569,   454,   570,    -1,    -1,
     857,    -1,   971,    -1,    -1,   196,   834,    -1,   573,    -1,
     573,   574,    -1,   574,    -1,   574,   573,    -1,    -1,   279,
     159,    -1,   159,    -1,   222,   212,    -1,   222,   160,    -1,
     171,   385,   836,   293,   834,   502,    -1,   171,   385,   210,
     183,   836,   293,   834,   502,    -1,   138,    95,   836,   120,
     447,   792,   448,   572,    -1,   171,    95,   836,    -1,   138,
      84,   842,   583,   579,    -1,   138,    84,   842,   585,    -1,
     138,   295,   798,   579,    -1,   138,   390,   599,   579,    -1,
     138,   390,   599,    -1,   138,   390,   599,    93,   447,   765,
     448,    -1,   447,   580,   448,    -1,   581,    -1,   580,   454,
     581,    -1,   974,   434,   582,    -1,   974,    -1,   638,    -1,
     983,    -1,   984,    -1,   801,    -1,   856,    -1,   447,   584,
     448,    -1,   447,   440,   448,    -1,   767,    -1,   584,   454,
     767,    -1,   447,   586,   448,    -1,   587,    -1,   586,   454,
     587,    -1,   993,   434,   582,    -1,   138,   295,   122,   599,
     591,   191,   390,   767,   400,   838,    93,   589,    -1,   590,
      -1,   589,   454,   590,    -1,   295,   849,   650,   592,    -1,
     295,   849,   650,   447,   649,   448,   592,    -1,   198,   849,
     842,   631,    -1,   366,   767,    -1,   157,    -1,    -1,   322,
      -1,    -1,   171,   295,   122,   599,   400,   838,   502,    -1,
     171,   295,   122,   210,   183,   599,   400,   838,   502,    -1,
     171,   303,   109,   835,   502,    -1,   321,   303,   109,   835,
     381,   836,    -1,   171,   597,   210,   183,   598,   502,    -1,
     171,   597,   598,   502,    -1,   373,    -1,   348,    -1,   408,
      -1,   218,    -1,   390,    -1,   169,    -1,   135,    -1,   343,
      -1,   599,    -1,   598,   454,   599,    -1,   971,    -1,   971,
     600,    -1,   449,   839,    -1,   600,   449,   839,    -1,   388,
     734,   833,   502,    -1,   188,   603,   604,   836,   933,    -1,
     188,   603,   836,   933,    -1,   188,   604,   836,   933,    -1,
     188,   836,   933,    -1,   188,   603,   604,   836,    -1,   188,
     603,   836,    -1,   188,   604,   836,    -1,   188,   836,    -1,
     264,   603,   604,   836,    -1,   264,   836,    -1,   270,    -1,
     314,    -1,   189,    -1,   243,    -1,    78,   850,    -1,   325,
     850,    -1,   850,    -1,    85,    -1,   194,    -1,   194,   850,
      -1,   194,    85,    -1,   100,    -1,   100,   850,    -1,   100,
      85,    -1,   215,    -1,   196,    -1,   128,   293,   606,   836,
     235,   607,    -1,   128,   293,    84,   842,   583,   235,   607,
      -1,   128,   293,   198,   842,   631,   235,   607,    -1,   128,
     293,   295,   798,   447,   649,   448,   235,   607,    -1,   128,
     293,   385,   836,   293,   599,   235,   607,    -1,   128,   293,
     341,   836,   293,   599,   235,   607,    -1,   128,   293,   341,
     836,   235,   607,    -1,   128,   293,   295,   122,   599,   400,
     838,   235,   607,    -1,   128,   293,   242,   287,   855,   235,
     607,    -1,   128,   293,   115,   447,   767,    93,   767,   448,
     235,   607,    -1,   128,   293,   558,   241,   599,   235,   607,
      -1,   127,    -1,   151,    -1,   343,    -1,   218,    -1,   348,
      -1,   373,    -1,   169,    -1,   390,    -1,   408,    -1,   135,
      -1,   374,    -1,   337,    -1,   853,    -1,   284,    -1,   201,
     610,   293,   613,   381,   614,   616,    -1,   335,   610,   293,
     613,   196,   614,   502,    -1,   335,   201,   296,   191,   610,
     293,   613,   196,   614,   502,    -1,    85,   315,    -1,    85,
      -1,   611,    -1,   612,    -1,   611,   454,   612,    -1,   347,
      -1,   323,    -1,   138,    -1,   971,    -1,   833,    -1,   373,
     833,    -1,   348,   833,    -1,   198,   617,    -1,   151,   835,
      -1,   241,   835,    -1,   343,   835,    -1,   374,   835,    -1,
     615,    -1,   614,   454,   615,    -1,   858,    -1,   204,   858,
      -1,   412,   201,   296,    -1,    -1,   618,    -1,   617,   454,
     618,    -1,   842,   631,    -1,   201,   611,   381,   835,   621,
     622,    -1,   335,   611,   196,   835,   622,   502,    -1,   412,
      82,   296,    -1,    -1,   202,   109,   858,    -1,    -1,   138,
     624,   218,   840,   293,   834,   625,   447,   626,   448,   642,
     540,   764,    -1,   138,   624,   218,   131,   840,   293,   834,
     625,   447,   626,   448,   642,   540,   764,    -1,   394,    -1,
      -1,   400,   838,    -1,    -1,   627,    -1,   626,   454,   627,
      -1,   971,   628,    -1,   795,   628,    -1,   447,   792,   448,
     628,    -1,   599,    -1,   400,   599,    -1,    -1,   138,   630,
     198,   842,   631,   334,   637,   639,   642,    -1,   138,   630,
     198,   842,   631,   639,   642,    -1,   297,   329,    -1,    -1,
     447,   632,   448,    -1,   447,   448,    -1,   633,    -1,   632,
     454,   633,    -1,   634,   636,   638,    -1,   636,   634,   638,
      -1,   636,   638,    -1,   634,   638,    -1,   638,    -1,   215,
      -1,   299,    -1,   224,    -1,   215,   299,    -1,   853,    -1,
     853,   454,   853,    -1,   973,    -1,   638,    -1,   353,   972,
     600,   442,   390,    -1,   767,    -1,   972,   600,   442,   390,
      -1,   641,    -1,   639,   641,    -1,   111,   293,   284,   225,
      -1,   334,   284,   293,   284,   225,    -1,   367,    -1,   213,
      -1,   360,    -1,   409,    -1,   185,   346,   161,    -1,   185,
     346,   234,    -1,   346,   161,    -1,   346,   234,    -1,    93,
     635,    -1,   241,   489,    -1,   640,    -1,   412,   579,    -1,
      -1,    87,   198,   618,   644,   645,    -1,   640,    -1,   644,
     640,    -1,   332,    -1,    -1,   171,   198,   842,   631,   502,
      -1,   171,   198,   210,   183,   842,   631,   502,    -1,   171,
      84,   842,   583,   502,    -1,   171,    84,   210,   183,   842,
     583,   502,    -1,   171,   295,   798,   447,   649,   448,   502,
      -1,   171,   295,   210,   183,   650,   447,   649,   448,   502,
      -1,   767,    -1,   767,   454,   767,    -1,   277,   454,   767,
      -1,   767,   454,   277,    -1,   798,    -1,   971,   449,   650,
      -1,   138,   115,   447,   767,    93,   767,   448,   412,   198,
     618,   652,    -1,   138,   115,   447,   767,    93,   767,   448,
     413,   198,   652,    -1,    93,    96,    -1,    -1,   171,   115,
     654,   447,   767,    93,   767,   448,   502,    -1,   210,   183,
      -1,    -1,   324,   656,   834,   657,    -1,   324,   372,   836,
     657,    -1,   324,   151,   836,   657,    -1,   218,    -1,   373,
      -1,   192,    -1,    -1,    87,    84,   842,   583,   327,   381,
     836,    -1,    87,   135,   599,   327,   381,   836,    -1,    87,
     151,   837,   327,   381,   837,    -1,    87,   198,   842,   631,
     327,   381,   836,    -1,    87,   204,   858,   327,   381,   858,
      -1,    87,   241,   836,   327,   381,   836,    -1,    87,   295,
     122,   599,   400,   838,   327,   381,   836,    -1,    87,   343,
     836,   327,   381,   836,    -1,    87,   373,   761,   327,   381,
     836,    -1,    87,   218,   761,   327,   381,   836,    -1,    87,
     373,   761,   327,   659,   836,   381,   836,    -1,    87,   385,
     836,   293,   761,   327,   381,   836,    -1,    87,   399,   858,
     327,   381,   858,    -1,    87,   374,   836,   327,   381,   836,
      -1,   127,    -1,    -1,    87,    84,   842,   583,   352,   343,
     836,    -1,    87,   169,   599,   352,   343,   836,    -1,    87,
     198,   842,   631,   352,   343,   836,    -1,    87,   348,   761,
     352,   343,   836,    -1,    87,   373,   761,   352,   343,   836,
      -1,    87,   390,   599,   352,   343,   836,    -1,    87,    84,
     842,   583,   304,   381,   858,    -1,    87,   135,   599,   304,
     381,   858,    -1,    87,   151,   837,   304,   381,   858,    -1,
      87,   169,   837,   304,   381,   858,    -1,    87,   198,   842,
     631,   304,   381,   858,    -1,    87,   295,   650,   447,   649,
     448,   304,   381,   858,    -1,    87,   295,   122,   599,   400,
     838,   304,   381,   858,    -1,    87,   343,   836,   304,   381,
     858,    -1,    87,   390,   599,   304,   381,   858,    -1,    87,
     374,   836,   304,   381,   858,    -1,    -1,   138,   630,   341,
     836,    93,   663,   293,   668,   381,   834,   764,   168,   669,
     664,    -1,   280,    -1,   666,    -1,   447,   665,   448,    -1,
     665,   450,   667,    -1,   667,    -1,   727,    -1,   706,    -1,
     717,    -1,   711,    -1,   671,    -1,   666,    -1,    -1,   347,
      -1,   398,    -1,   162,    -1,   227,    -1,   228,    -1,    86,
      -1,    -1,   171,   341,   836,   293,   834,   502,    -1,   171,
     341,   210,   183,   836,   293,   834,   502,    -1,   281,   834,
      -1,   250,   834,    -1,   396,   834,    -1,   396,   440,    -1,
      77,   675,    -1,   102,   675,   678,    -1,   361,   383,   678,
      -1,   129,   675,    -1,   177,   675,    -1,   338,   675,    -1,
     342,   971,    -1,   326,   342,   971,    -1,   326,   971,    -1,
     338,   675,   381,   342,   971,    -1,   338,   675,   381,   971,
      -1,   311,   383,   853,    -1,   129,   312,   853,    -1,   338,
     312,   853,    -1,   414,    -1,   383,    -1,    -1,   237,   247,
     484,    -1,   319,   294,    -1,   319,   415,    -1,   676,    -1,
     677,   454,   676,    -1,   677,   676,    -1,   677,    -1,    -1,
     138,   515,   408,   834,   529,    93,   727,   680,    -1,   138,
     297,   329,   515,   408,   834,   529,    93,   727,   680,    -1,
     420,   296,    -1,   418,   120,   296,    -1,   419,   120,   296,
      -1,    -1,   251,   841,    -1,   138,   151,   837,   412,   683,
      -1,   138,   151,   837,    -1,   684,    -1,   683,   684,    -1,
     374,   685,   836,    -1,   374,   685,   157,    -1,   255,   685,
     853,    -1,   255,   685,   157,    -1,   376,   685,   836,    -1,
     376,   685,   157,    -1,   175,   685,   854,    -1,   175,   685,
     157,    -1,   132,   249,   685,   849,    -1,   304,   685,   836,
      -1,   304,   685,   157,    -1,   434,    -1,    -1,    87,   151,
     837,   463,   688,    -1,    87,   151,   837,   352,   480,    -1,
      87,   151,   837,   491,    -1,   688,   689,    -1,    -1,   132,
     249,   685,   849,    -1,   171,   151,   837,    -1,   171,   151,
     210,   183,   837,    -1,   138,   169,   599,   693,   767,   520,
      -1,    87,   169,   599,   501,    -1,    87,   169,   599,   171,
     279,   284,    -1,    87,   169,   599,   352,   279,   284,    -1,
      87,   169,   599,    81,   527,    -1,    87,   169,   599,   171,
     133,   836,   502,    -1,    93,    -1,    -1,   138,   591,   135,
     599,   191,   853,   381,   853,   196,   599,    -1,   124,   840,
     293,   834,    -1,   124,   834,    -1,   124,    -1,   401,   700,
     701,   699,    -1,   401,   700,   701,   699,   834,    -1,   401,
     700,   701,   699,   697,    -1,   698,   699,    -1,   698,   699,
     834,   702,    -1,    89,    -1,    88,    -1,   407,    -1,    -1,
     197,    -1,    -1,   195,    -1,    -1,   447,   835,   448,    -1,
      -1,   184,   705,   699,   704,    -1,   727,    -1,   706,    -1,
     717,    -1,   711,    -1,   724,    -1,   698,    -1,    -1,   227,
     233,   834,   707,   710,    -1,   727,    -1,   447,   708,   448,
     727,    -1,   157,   404,    -1,   708,   454,   709,    -1,   709,
      -1,   971,   825,    -1,   333,   830,    -1,    -1,   162,   196,
     762,   712,   764,   710,    -1,   400,   754,    -1,    -1,   256,
     734,   833,   714,   716,    -1,   215,   715,   262,    -1,    -1,
      79,   354,    -1,   339,   354,    -1,   339,   180,    -1,   354,
     398,   180,    -1,   354,    -1,   354,   339,   180,    -1,   180,
      -1,    79,   180,    -1,   283,    -1,    -1,   398,   762,   352,
     718,   753,   764,   710,    -1,   719,    -1,   718,   454,   719,
      -1,   720,    -1,   721,    -1,   722,   434,   827,    -1,   447,
     723,   448,   434,   829,    -1,   971,   825,    -1,   722,    -1,
     723,   454,   722,    -1,   156,   836,   725,   149,   726,   191,
     727,    -1,    -1,   725,   105,    -1,   725,   226,    -1,   725,
     344,    -1,   725,   271,   344,    -1,    -1,   412,   208,    -1,
     413,   208,    -1,   729,    -1,   728,    -1,   447,   729,   448,
      -1,   447,   728,   448,    -1,   731,    -1,   730,   738,    -1,
     730,   737,   747,   742,    -1,   730,   737,   741,   748,    -1,
     731,    -1,   728,    -1,   347,   736,   830,   732,   753,   764,
     745,   746,    -1,   752,    -1,   730,   393,   735,   730,    -1,
     730,   231,   735,   730,    -1,   730,   179,   735,   730,    -1,
     233,   733,    -1,   933,    -1,    -1,   377,   734,   834,    -1,
     375,   734,   834,    -1,   252,   377,   734,   834,    -1,   252,
     375,   734,   834,    -1,   200,   377,   734,   834,    -1,   200,
     375,   734,   834,    -1,   373,   834,    -1,   834,    -1,   373,
      -1,    -1,    85,    -1,    -1,   167,    -1,   167,   293,   447,
     803,   448,    -1,    85,    -1,    -1,   738,    -1,    -1,   298,
     109,   739,    -1,   740,    -1,   739,   454,   740,    -1,   792,
     400,   801,    -1,   792,    94,    -1,   792,   165,    -1,   792,
      -1,   249,   743,   290,   744,    -1,   290,   744,   249,   743,
      -1,   249,   743,    -1,   290,   744,    -1,   249,   743,   454,
     744,    -1,   741,    -1,    -1,   792,    -1,    85,    -1,   792,
      -1,   204,   109,   803,    -1,    -1,   206,   792,    -1,    -1,
     749,    -1,   191,   319,   294,    -1,   747,    -1,    -1,   750,
      -1,   749,   750,    -1,   191,   398,   751,   716,    -1,   191,
     354,   751,   716,    -1,   288,   835,    -1,    -1,   404,   829,
      -1,   752,   454,   829,    -1,   196,   754,    -1,    -1,   754,
     454,   755,    -1,   755,    -1,   761,    -1,   761,   757,    -1,
     763,    -1,   763,   757,    -1,   763,    93,   447,   765,   448,
      -1,   763,    93,   971,   447,   765,   448,    -1,   763,   971,
     447,   765,   448,    -1,   728,    -1,   728,   757,    -1,   756,
      -1,   447,   756,   448,   757,    -1,   447,   756,   448,    -1,
     755,   142,   238,   755,    -1,   755,   758,   238,   755,   760,
      -1,   755,   238,   755,   760,    -1,   755,   267,   758,   238,
     755,    -1,   755,   267,   238,   755,    -1,    93,   971,   447,
     835,   448,    -1,    93,   971,    -1,   971,   447,   835,   448,
      -1,   971,    -1,   197,   759,    -1,   246,   759,    -1,   336,
     759,    -1,   223,    -1,   300,    -1,    -1,   400,   447,   835,
     448,    -1,   293,   792,    -1,   834,    -1,   834,   440,    -1,
     294,   834,    -1,   294,   447,   834,   448,    -1,   761,    -1,
     761,   971,    -1,   761,    93,   971,    -1,   795,    -1,   411,
     792,    -1,    -1,   766,    -1,   765,   454,   766,    -1,   971,
     767,    -1,   770,   768,    -1,   353,   770,   768,    -1,   770,
      92,   445,   849,   446,    -1,   353,   770,    92,   445,   849,
     446,    -1,   445,   446,   768,    -1,   445,   769,   446,   768,
      -1,    -1,   849,    -1,   447,   769,   448,    -1,   769,   438,
     769,    -1,   769,   439,   769,    -1,   769,   440,   769,    -1,
     769,   441,   769,    -1,   769,   442,   769,    -1,   848,    -1,
     971,    -1,   772,    -1,   788,    -1,   773,    -1,   777,    -1,
     781,    -1,   789,   791,    -1,   789,   447,   849,   448,   791,
      -1,   972,   600,    -1,   772,    -1,   788,    -1,   773,    -1,
     778,    -1,   782,    -1,   972,    -1,   229,    -1,   230,    -1,
     358,    -1,   104,    -1,   320,    -1,   190,   774,    -1,   170,
     309,    -1,   155,   776,    -1,   154,   776,    -1,   286,   775,
      -1,   107,    -1,   447,   849,   448,    -1,    -1,   447,   849,
     454,   849,   448,    -1,   447,   849,   448,    -1,    -1,   447,
     849,   454,   849,   448,    -1,   447,   849,   448,    -1,    -1,
     779,    -1,   780,    -1,   779,    -1,   780,    -1,   106,   786,
     447,   849,   448,    -1,   106,   786,    -1,   783,    -1,   784,
      -1,   783,    -1,   784,    -1,   785,   447,   849,   448,   787,
      -1,   785,   787,    -1,   118,   786,    -1,   117,   786,    -1,
     405,    -1,   266,   118,   786,    -1,   266,   117,   786,    -1,
     268,   786,    -1,   406,    -1,    -1,   118,   352,   971,    -1,
      -1,   380,   447,   849,   448,   790,    -1,   380,   790,    -1,
     379,   447,   849,   448,   790,    -1,   379,   790,    -1,   232,
      -1,   412,   379,   417,    -1,   413,   379,   417,    -1,    -1,
     416,    -1,   263,    -1,   152,    -1,   209,    -1,   260,    -1,
     345,    -1,   416,   381,   263,    -1,   152,   381,   209,    -1,
     152,   381,   260,    -1,   152,   381,   345,    -1,   209,   381,
     260,    -1,   260,   381,   345,    -1,   209,   381,   345,    -1,
      -1,   794,    -1,   792,    76,   767,    -1,   792,    98,   379,
     417,   792,    -1,   438,   792,    -1,   439,   792,    -1,   792,
     438,   792,    -1,   792,   439,   792,    -1,   792,   440,   792,
      -1,   792,   441,   792,    -1,   792,   442,   792,    -1,   792,
     443,   792,    -1,   792,   435,   792,    -1,   792,   436,   792,
      -1,   792,   434,   792,    -1,   792,   800,   792,    -1,   800,
     792,    -1,   792,   800,    -1,   792,    90,   792,    -1,   792,
     297,   792,    -1,   279,   792,    -1,   792,   248,   792,    -1,
     792,   248,   792,   178,   792,    -1,   792,   279,   248,   792,
      -1,   792,   279,   248,   792,   178,   792,    -1,   792,   211,
     792,    -1,   792,   211,   792,   178,   792,    -1,   792,   279,
     211,   792,    -1,   792,   279,   211,   792,   178,   792,    -1,
     792,   356,   381,   792,    -1,   792,   356,   381,   792,   178,
     792,    -1,   792,   279,   356,   381,   792,    -1,   792,   279,
     356,   381,   792,   178,   792,    -1,   792,   236,    -1,   792,
     235,   284,    -1,   792,   282,    -1,   792,   235,   279,   284,
      -1,   796,   301,   796,    -1,   792,   235,   387,    -1,   792,
     235,   279,   387,    -1,   792,   235,   187,    -1,   792,   235,
     279,   187,    -1,   792,   235,   395,    -1,   792,   235,   279,
     395,    -1,   792,   235,   167,   196,   792,    -1,   792,   235,
     279,   167,   196,   792,    -1,   792,   235,   288,   447,   805,
     448,    -1,   792,   235,   279,   288,   447,   805,   448,    -1,
     792,   103,   826,   793,    90,   793,    -1,   792,   279,   103,
     826,   793,    90,   793,    -1,   792,   103,   370,   793,    90,
     793,    -1,   792,   279,   103,   370,   793,    90,   793,    -1,
     792,   215,   816,    -1,   792,   279,   215,   816,    -1,   792,
     802,   797,   728,    -1,   792,   802,   797,   447,   792,   448,
      -1,   394,   728,    -1,   794,    -1,   793,    76,   767,    -1,
     439,   793,    -1,   793,   438,   793,    -1,   793,   439,   793,
      -1,   793,   440,   793,    -1,   793,   441,   793,    -1,   793,
     442,   793,    -1,   793,   443,   793,    -1,   793,   435,   793,
      -1,   793,   436,   793,    -1,   793,   434,   793,    -1,   793,
     423,   793,    -1,   800,   793,    -1,   793,   800,    -1,   793,
     235,   167,   196,   793,    -1,   793,   235,   279,   167,   196,
     793,    -1,   793,   235,   288,   447,   793,   448,    -1,   793,
     235,   279,   288,   447,   793,   448,    -1,   822,    -1,   843,
      -1,   432,   825,    -1,   447,   792,   448,   825,    -1,   817,
      -1,   795,    -1,   728,    -1,   183,   728,    -1,    92,   728,
      -1,    92,   807,    -1,   796,    -1,   842,   447,   448,    -1,
     842,   447,   803,   448,    -1,   842,   447,    85,   803,   448,
      -1,   842,   447,   167,   803,   448,    -1,   842,   447,   440,
     448,    -1,   144,    -1,   146,    -1,   146,   447,   849,   448,
      -1,   147,    -1,   147,   447,   849,   448,    -1,   253,    -1,
     253,   447,   849,   448,    -1,   254,    -1,   254,   447,   849,
     448,    -1,   145,    -1,   148,    -1,   351,    -1,   399,    -1,
     115,   447,   792,    93,   767,   448,    -1,   186,   447,   804,
     448,    -1,   302,   447,   809,   448,    -1,   308,   447,   811,
     448,    -1,   368,   447,   812,   448,    -1,   384,   447,   792,
      93,   767,   448,    -1,   386,   447,   108,   815,   448,    -1,
     386,   447,   244,   815,   448,    -1,   386,   447,   382,   815,
     448,    -1,   386,   447,   815,   448,    -1,   136,   447,   792,
     400,   599,   448,    -1,   136,   447,   803,   448,    -1,   285,
     447,   792,   454,   792,   448,    -1,   125,   447,   803,   448,
      -1,   203,   447,   803,   448,    -1,   245,   447,   803,   448,
      -1,   339,   447,   803,   448,    -1,   339,   447,   448,    -1,
     447,   803,   454,   792,   448,    -1,    91,    -1,   359,    -1,
      85,    -1,   423,    -1,   799,    -1,   438,    -1,   439,    -1,
     440,    -1,   442,    -1,   443,    -1,   441,    -1,   435,    -1,
     436,    -1,   434,    -1,   423,    -1,   295,   447,   650,   448,
      -1,   798,    -1,   295,   447,   650,   448,    -1,   798,    -1,
     295,   447,   650,   448,    -1,   248,    -1,   279,   248,    -1,
     211,    -1,   279,   211,    -1,   792,    -1,   803,   454,   792,
      -1,   808,   196,   792,    -1,    -1,   805,   454,   767,    -1,
     767,    -1,   807,    -1,   806,   454,   807,    -1,   445,   803,
     446,    -1,   445,   806,   446,    -1,   993,    -1,   416,    -1,
     263,    -1,   152,    -1,   209,    -1,   260,    -1,   345,    -1,
     853,    -1,   792,   810,   813,   814,    -1,   792,   810,   813,
      -1,   307,   792,    -1,   793,   215,   793,    -1,    -1,   792,
     813,   814,    -1,   792,   814,   813,    -1,   792,   813,    -1,
     792,   814,    -1,   803,    -1,    -1,   196,   792,    -1,   191,
     792,    -1,   792,   196,   803,    -1,   196,   803,    -1,   803,
      -1,   728,    -1,   447,   803,   448,    -1,   114,   821,   818,
     820,   177,    -1,   818,   819,    -1,   819,    -1,   410,   792,
     378,   792,    -1,   173,   792,    -1,    -1,   792,    -1,    -1,
     832,    -1,   832,   824,    -1,   449,   839,    -1,   449,   440,
      -1,   445,   792,   446,    -1,   445,   792,   455,   792,   446,
      -1,   823,    -1,   824,   823,    -1,    -1,   825,   823,    -1,
      97,    -1,    -1,   792,    -1,   157,    -1,   827,    -1,   828,
     454,   827,    -1,   447,   828,   448,    -1,   830,   454,   831,
      -1,   831,    -1,   792,    93,   974,    -1,   792,    -1,   440,
      -1,   859,    -1,   971,    -1,   834,    -1,   833,   454,   834,
      -1,   832,    -1,   832,   824,    -1,   836,    -1,   835,   454,
     836,    -1,   971,    -1,   971,    -1,   971,    -1,   974,    -1,
     971,    -1,   853,    -1,   973,    -1,   832,   824,    -1,   857,
      -1,   771,   853,    -1,   789,   853,   791,    -1,   789,   447,
     849,   448,   853,   791,    -1,   387,    -1,   187,    -1,   284,
      -1,   989,    -1,   431,    -1,   433,    -1,   428,    -1,   429,
      -1,   422,    -1,   430,    -1,   844,    -1,   990,    -1,   849,
      -1,   439,   849,    -1,   844,    -1,   992,    -1,   845,    -1,
     851,    -1,   439,   845,    -1,   439,   844,    -1,   848,    -1,
     848,    -1,   990,    -1,   844,    -1,   848,    -1,   990,    -1,
     845,    -1,   844,    -1,   439,   845,    -1,   439,   844,    -1,
     990,    -1,   848,    -1,   855,    -1,   848,    -1,   845,    -1,
     844,    -1,   846,    -1,   847,    -1,   990,    -1,   971,    -1,
     292,    -1,   269,    -1,     9,   381,   861,   868,   869,    -1,
       9,   381,   157,    -1,     9,   870,    -1,   151,   861,    -1,
     862,   865,   867,    -1,   863,   455,   864,   867,   441,   862,
     873,    -1,   872,    -1,   848,    -1,   837,    -1,    -1,   993,
     992,    -1,   423,   866,    -1,   864,    -1,    -1,   971,    -1,
     971,   449,   866,    -1,   427,    -1,   455,   849,    -1,    -1,
      93,   920,    -1,    -1,   399,   870,    -1,    -1,   871,    -1,
     871,   441,   871,    -1,   871,    24,   109,   871,    -1,   871,
     400,   871,    -1,   858,    -1,   853,    -1,   992,    -1,   423,
     971,    -1,    -1,   156,   836,   725,   149,   726,   191,   925,
      -1,   153,   311,   925,    -1,   153,   925,    -1,   877,    -1,
     891,    -1,   878,    -1,    -1,   897,   900,   879,   913,   450,
      -1,    -1,   900,   880,   913,   450,    -1,   903,   450,    -1,
     855,    -1,   454,   855,    -1,    -1,   791,    -1,   416,   381,
     260,    -1,   416,   381,   345,    -1,   152,   381,   152,    -1,
     263,   381,   263,    -1,    -1,   886,   885,   888,   887,    -1,
     986,   102,   156,    38,   450,    -1,   986,   177,   156,    38,
     450,    -1,    -1,   889,    -1,   426,    -1,   893,    -1,   891,
      -1,   889,   893,    -1,   889,   891,    -1,   889,   426,    -1,
     893,    -1,   890,   893,    -1,    -1,    75,   892,   900,   916,
     975,   768,   450,    -1,    -1,   897,   900,   894,   913,   450,
      -1,    -1,   900,   895,   913,   450,    -1,   903,   450,    -1,
     455,   844,    -1,    -1,   898,   899,    -1,   898,    -1,   899,
      -1,    61,    -1,    72,    -1,    70,    -1,    55,    -1,    56,
      -1,    74,    -1,   909,    -1,   905,    -1,   901,    -1,   975,
     447,   881,   882,   448,    -1,   975,   883,    -1,   907,    -1,
      19,   969,   902,    -1,    19,   902,    -1,    19,   969,    -1,
     451,   997,   452,    -1,    -1,   907,   904,   451,   890,   452,
      -1,   903,    -1,    -1,   908,   906,   451,   890,   452,    -1,
      47,   969,    -1,   393,   969,    -1,    47,    -1,   393,    -1,
     910,    -1,   912,   911,    -1,    48,    39,    -1,    48,    39,
     229,    -1,    48,    -1,    48,   229,    -1,    48,    28,    -1,
      48,    28,   229,    -1,    48,    28,    28,    -1,    48,    28,
      28,   229,    -1,    48,   117,    -1,    39,    -1,    39,   229,
      -1,   229,    -1,    28,    -1,    28,   229,    -1,    28,    28,
      -1,    28,    28,   229,    -1,     5,    -1,   117,    -1,   170,
      -1,    40,    -1,    -1,   914,    -1,   913,   454,   914,    -1,
     916,   976,   768,   896,   915,    -1,    -1,   434,   998,    -1,
      -1,   440,    -1,   440,   440,    -1,   156,   362,   993,    -1,
      18,   919,    -1,   920,    -1,    12,    -1,    85,    -1,    -1,
     837,    -1,   157,    -1,   872,    -1,   182,   212,   924,    -1,
      -1,   182,   925,   922,   923,    -1,   929,   933,    -1,   933,
     929,    -1,   929,    -1,   933,    -1,    -1,   872,    -1,   424,
      -1,   836,    -1,   872,    -1,    21,   836,    -1,    32,   836,
     928,    -1,    -1,   929,    -1,   400,   934,    -1,   930,    -1,
     400,   932,    17,   994,    -1,   233,   932,    17,   994,    -1,
      -1,    41,    -1,   233,   985,    -1,   931,    -1,   935,    -1,
     935,   454,   934,    -1,   856,    -1,   989,    -1,   311,   925,
     196,   924,    -1,    16,   225,   836,   930,    -1,    16,   938,
     836,   930,    -1,    16,   938,   836,   931,    -1,    33,    -1,
      -1,     3,    17,   994,    -1,   153,    17,   994,    -1,   199,
      17,   994,   942,    -1,   943,    -1,   942,   454,   943,    -1,
     992,   434,   947,    -1,   352,    17,   994,   945,    -1,   946,
      -1,   945,   454,   946,    -1,   947,   434,   851,    -1,    11,
      -1,   199,    17,   994,    49,   851,   949,    -1,   950,    -1,
     949,   454,   950,    -1,   992,   434,   954,    -1,   352,    17,
     994,    49,   851,   952,    -1,   953,    -1,   952,   454,   953,
      -1,   954,   434,   852,    -1,     8,    -1,    13,    -1,    14,
      -1,    15,    -1,    25,    -1,    26,    -1,    27,    -1,    29,
      -1,    30,    -1,    31,    -1,   309,    -1,    35,    -1,    36,
      -1,    37,    -1,   390,    -1,   352,     4,   434,   956,    -1,
     352,     4,   381,   956,    -1,   293,    -1,   289,    -1,   352,
     132,   381,   920,    -1,   352,   132,   434,   920,    -1,   352,
     132,   920,    -1,    -1,   390,   959,   975,   235,   900,   768,
     960,    -1,    34,    -1,    -1,    -1,    50,   962,   974,   235,
     900,   768,   960,    -1,    51,    42,   964,    -1,    51,   279,
      20,   964,    -1,    51,    44,   964,    -1,    10,    -1,    43,
      -1,    46,    -1,    23,   836,    -1,    22,   381,   836,    -1,
     168,   836,   447,   987,   448,    -1,   168,     6,    -1,     7,
     836,   447,   987,   448,    -1,     7,   836,    -1,   966,    -1,
     967,    -1,     6,    -1,     7,    -1,     8,    -1,    10,    -1,
      11,    -1,    13,    -1,    14,    -1,    15,    -1,    20,    -1,
      22,    -1,    23,    -1,    24,    -1,    25,    -1,    26,    -1,
      27,    -1,    29,    -1,    30,    -1,    31,    -1,    35,    -1,
      36,    -1,    37,    -1,    38,    -1,    41,    -1,    42,    -1,
      43,    -1,    44,    -1,    46,    -1,    49,    -1,     9,    -1,
      16,    -1,    18,    -1,    32,    -1,    50,    -1,    51,    -1,
       5,    -1,    28,    -1,    33,    -1,    39,    -1,    47,    -1,
      40,    -1,    48,    -1,   974,    -1,   993,    -1,   979,    -1,
     981,    -1,   982,    -1,   965,    -1,   977,    -1,   117,    -1,
     404,    -1,   993,    -1,   978,    -1,   982,    -1,   965,    -1,
     977,    -1,   117,    -1,   404,    -1,   993,    -1,   978,    -1,
     965,    -1,   968,    -1,   977,    -1,   993,    -1,   978,    -1,
     983,    -1,   965,    -1,   977,    -1,   976,    -1,   968,    -1,
     117,    -1,   225,    -1,   229,    -1,   393,    -1,   381,    -1,
     977,    -1,   979,    -1,   993,    -1,   982,    -1,   983,    -1,
     966,    -1,   975,    -1,   984,    -1,   980,    -1,   967,    -1,
      55,    -1,    56,    -1,    61,    -1,    70,    -1,    72,    -1,
      75,    -1,    74,    -1,   979,    -1,   980,    -1,   152,    -1,
     209,    -1,   260,    -1,   263,    -1,   345,    -1,   416,    -1,
     981,    -1,   132,    -1,    77,    -1,    78,    -1,    79,    -1,
      80,    -1,    81,    -1,    82,    -1,    83,    -1,    84,    -1,
      86,    -1,    87,    -1,    95,    -1,    96,    -1,    98,    -1,
     100,    -1,   101,    -1,   102,    -1,   109,    -1,   110,    -1,
     112,    -1,   113,    -1,   116,    -1,   119,    -1,   121,    -1,
     122,    -1,   123,    -1,   124,    -1,   128,    -1,   129,    -1,
     130,    -1,   131,    -1,   134,    -1,   135,    -1,   137,    -1,
     139,    -1,   140,    -1,   141,    -1,   143,    -1,   149,    -1,
     150,    -1,   151,    -1,   153,    -1,   156,    -1,   158,    -1,
     160,    -1,   162,    -1,   163,    -1,   164,    -1,   166,    -1,
     169,    -1,   170,    -1,   171,    -1,   172,    -1,   174,    -1,
     175,    -1,   176,    -1,   178,    -1,   181,    -1,   180,    -1,
     182,    -1,   184,    -1,   188,    -1,   189,    -1,   192,    -1,
     194,    -1,   198,    -1,   200,    -1,   202,    -1,   205,    -1,
     207,    -1,   208,    -1,   210,    -1,   212,    -1,   213,    -1,
     214,    -1,   216,    -1,   217,    -1,   218,    -1,   219,    -1,
     220,    -1,   221,    -1,   226,    -1,   227,    -1,   228,    -1,
     237,    -1,   239,    -1,   240,    -1,   241,    -1,   242,    -1,
     243,    -1,   247,    -1,   250,    -1,   251,    -1,   252,    -1,
     255,    -1,   256,    -1,   257,    -1,   258,    -1,   259,    -1,
     261,    -1,   262,    -1,   264,    -1,   265,    -1,   270,    -1,
     271,    -1,   272,    -1,   273,    -1,   274,    -1,   275,    -1,
     276,    -1,   278,    -1,   280,    -1,   281,    -1,   283,    -1,
     287,    -1,   288,    -1,   291,    -1,   295,    -1,   296,    -1,
     303,    -1,   304,    -1,   305,    -1,   306,    -1,   311,    -1,
     312,    -1,   310,    -1,   314,    -1,   315,    -1,   316,    -1,
     317,    -1,   318,    -1,   319,    -1,   321,    -1,   322,    -1,
     324,    -1,   325,    -1,   326,    -1,   327,    -1,   328,    -1,
     329,    -1,   330,    -1,   331,    -1,   332,    -1,   334,    -1,
     335,    -1,   337,    -1,   338,    -1,   340,    -1,   341,    -1,
     342,    -1,   343,    -1,   344,    -1,   348,    -1,   349,    -1,
     350,    -1,   352,    -1,   354,    -1,   355,    -1,   357,    -1,
     360,    -1,   361,    -1,   362,    -1,   363,    -1,   364,    -1,
     365,    -1,   366,    -1,   369,    -1,   367,    -1,   372,    -1,
     371,    -1,   374,    -1,   375,    -1,   376,    -1,   377,    -1,
     383,    -1,   385,    -1,   388,    -1,   389,    -1,   390,    -1,
     391,    -1,   392,    -1,   395,    -1,   396,    -1,   397,    -1,
     398,    -1,   401,    -1,   402,    -1,   406,    -1,   408,    -1,
     412,    -1,   413,    -1,   414,    -1,   415,    -1,   417,    -1,
     104,    -1,   106,    -1,   118,    -1,   125,    -1,   136,    -1,
     154,    -1,   155,    -1,   183,    -1,   186,    -1,   190,    -1,
     203,    -1,   224,    -1,   230,    -1,   232,    -1,   245,    -1,
     266,    -1,   268,    -1,   277,    -1,   285,    -1,   286,    -1,
     299,    -1,   302,    -1,   308,    -1,   309,    -1,   320,    -1,
     339,    -1,   353,    -1,   358,    -1,   368,    -1,   379,    -1,
     380,    -1,   384,    -1,   386,    -1,   405,    -1,    99,    -1,
     103,    -1,   105,    -1,   142,    -1,   195,    -1,   197,    -1,
     211,    -1,   223,    -1,   235,    -1,   236,    -1,   238,    -1,
     246,    -1,   248,    -1,   267,    -1,   282,    -1,   300,    -1,
     301,    -1,   336,    -1,   356,    -1,   407,    -1,    85,    -1,
      88,    -1,    89,    -1,    90,    -1,    91,    -1,    92,    -1,
      93,    -1,    94,    -1,    97,    -1,   108,    -1,   114,    -1,
     115,    -1,   120,    -1,   126,    -1,   127,    -1,   133,    -1,
     138,    -1,   144,    -1,   146,    -1,   147,    -1,   145,    -1,
     148,    -1,   157,    -1,   159,    -1,   165,    -1,   167,    -1,
     168,    -1,   173,    -1,   177,    -1,   179,    -1,   187,    -1,
     191,    -1,   193,    -1,   196,    -1,   201,    -1,   204,    -1,
     206,    -1,   215,    -1,   222,    -1,   231,    -1,   233,    -1,
     244,    -1,   249,    -1,   269,    -1,   279,    -1,   284,    -1,
     289,    -1,   290,    -1,   292,    -1,   293,    -1,   294,    -1,
     297,    -1,   298,    -1,   313,    -1,   323,    -1,   333,    -1,
     347,    -1,   351,    -1,   359,    -1,   370,    -1,   373,    -1,
     378,    -1,   382,    -1,   387,    -1,   394,    -1,   399,    -1,
     400,    -1,   410,    -1,   411,    -1,   988,    -1,   985,   454,
     988,    -1,    45,    -1,    -1,   997,    -1,   992,   991,    -1,
     992,    -1,   992,   991,    -1,   992,    -1,   992,    -1,    25,
     992,    -1,    25,   836,    -1,   425,    -1,   421,    -1,   424,
      -1,   836,    -1,   872,    -1,  1000,    -1,   447,   448,    -1,
     447,   996,   448,    -1,   995,    -1,   996,   995,    -1,   998,
      -1,   997,   454,   998,    -1,   996,    -1,   451,   997,   452,
      -1,  1000,    -1,   447,    -1,   448,    -1,   454,    -1,   450,
      -1,   421,    -1,   424,    -1,   844,    -1,   845,    -1,   848,
      -1,   440,    -1,   438,    -1,   439,    -1,   441,    -1,   442,
      -1,   284,    -1,    52,    -1,    53,    -1,    54,    -1,    55,
      -1,    56,    -1,    57,    -1,    58,    -1,    59,    -1,    60,
      -1,    61,    -1,    62,    -1,    63,    -1,    65,    -1,    64,
      -1,    66,    -1,    67,    -1,    68,    -1,    69,    -1,    70,
      -1,    71,    -1,    72,    -1,    73,    -1,    75,    -1,    74,
      -1,     5,    -1,    19,    -1,   209,    -1,   229,    -1,    28,
      -1,   260,    -1,   263,    -1,   345,    -1,    39,    -1,    40,
      -1,    47,    -1,    48,    -1,   416,    -1,   117,    -1,   190,
      -1,   381,    -1,   393,    -1,   405,    -1,   445,    -1,   446,
      -1,   434,    -1,   455,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   606,   606,   608,   609,   612,   613,   614,   620,   621,
     622,   623,   624,   627,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   677,
     678,   679,   680,   681,   682,   683,   684,   685,   686,   687,
     688,   689,   690,   691,   692,   693,   694,   695,   696,   697,
     699,   700,   701,   702,   703,   704,   705,   706,   707,   708,
     709,   710,   711,   712,   713,   714,   715,   717,   718,   719,
     720,   721,   722,   723,   724,   725,   727,   728,   729,   730,
     731,   732,   733,   734,   735,   736,   737,   743,   744,   745,
     746,   747,   748,   749,   750,   751,   757,   767,   771,   779,
     787,   791,   802,   812,   816,   823,   830,   836,   847,   857,
     863,   872,   879,   885,   894,   901,   922,   926,   927,   936,
     937,   938,   939,   940,   941,   942,   943,   944,   945,   946,
     947,   948,   949,   950,   951,   952,   953,   954,   955,   956,
     957,   967,   978,   982,   984,   994,   997,   999,  1009,  1011,
    1021,  1023,  1034,  1044,  1048,  1049,  1058,  1060,  1071,  1073,
    1077,  1078,  1081,  1082,  1089,  1090,  1091,  1092,  1093,  1094,
    1107,  1109,  1111,  1115,  1117,  1119,  1121,  1123,  1125,  1127,
    1129,  1131,  1135,  1136,  1140,  1142,  1146,  1148,  1152,  1153,
    1154,  1155,  1158,  1159,  1160,  1163,  1164,  1165,  1166,  1176,
    1177,  1178,  1180,  1182,  1184,  1188,  1189,  1190,  1193,  1194,
    1197,  1199,  1201,  1203,  1205,  1209,  1211,  1213,  1215,  1217,
    1221,  1225,  1227,  1231,  1232,  1238,  1249,  1251,  1257,  1258,
    1262,  1266,  1269,  1272,  1275,  1278,  1281,  1284,  1287,  1290,
    1293,  1296,  1299,  1302,  1305,  1308,  1311,  1314,  1317,  1320,
    1323,  1325,  1329,  1330,  1336,  1339,  1341,  1343,  1348,  1349,
    1352,  1353,  1354,  1357,  1358,  1368,  1372,  1384,  1393,  1394,
    1397,  1398,  1399,  1402,  1403,  1406,  1407,  1408,  1410,  1412,
    1413,  1414,  1416,  1418,  1420,  1425,  1426,  1429,  1430,  1437,
    1440,  1443,  1444,  1454,  1457,  1467,  1468,  1469,  1470,  1471,
    1472,  1473,  1477,  1480,  1482,  1484,  1488,  1489,  1490,  1493,
    1497,  1498,  1501,  1503,  1504,  1518,  1520,  1522,  1524,  1526,
    1528,  1530,  1545,  1546,  1547,  1548,  1551,  1555,  1557,  1561,
    1562,  1563,  1564,  1565,  1566,  1573,  1575,  1579,  1581,  1583,
    1585,  1590,  1591,  1594,  1596,  1600,  1603,  1605,  1611,  1614,
    1615,  1616,  1617,  1618,  1621,  1625,  1629,  1630,  1631,  1632,
    1633,  1636,  1639,  1642,  1643,  1644,  1645,  1648,  1649,  1650,
    1651,  1654,  1655,  1658,  1659,  1668,  1667,  1678,  1681,  1684,
    1686,  1690,  1701,  1705,  1709,  1710,  1713,  1715,  1717,  1719,
    1721,  1723,  1725,  1727,  1729,  1731,  1733,  1737,  1738,  1749,
    1751,  1756,  1757,  1764,  1765,  1768,  1771,  1773,  1776,  1779,
    1781,  1785,  1786,  1796,  1800,  1801,  1815,  1817,  1830,  1834,
    1841,  1842,  1845,  1847,  1849,  1853,  1854,  1855,  1858,  1861,
    1864,  1865,  1868,  1869,  1872,  1874,  1877,  1880,  1881,  1884,
    1885,  1888,  1889,  1896,  1897,  1905,  1910,  1912,  1916,  1918,
    1922,  1924,  1935,  1943,  1958,  1960,  1962,  1964,  1966,  1968,
    1972,  1976,  1977,  1980,  1981,  1985,  1986,  1987,  1988,  1989,
    1992,  1993,  1997,  1998,  2001,  2004,  2005,  2008,  2012,  2019,
    2020,  2023,  2025,  2027,  2029,  2033,  2034,  2037,  2038,  2041,
    2043,  2056,  2061,  2073,  2075,  2079,  2080,  2081,  2082,  2083,
    2084,  2085,  2086,  2089,  2091,  2095,  2096,  2099,  2100,  2109,
    2124,  2129,  2134,  2139,  2144,  2149,  2154,  2159,  2164,  2166,
    2170,  2171,  2172,  2173,  2174,  2175,  2176,  2177,  2178,  2179,
    2180,  2181,  2182,  2183,  2186,  2187,  2190,  2192,  2194,  2196,
    2198,  2200,  2202,  2204,  2206,  2208,  2210,  2214,  2215,  2216,
    2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,  2225,  2228,
    2229,  2239,  2243,  2245,  2249,  2250,  2251,  2254,  2256,  2260,
    2261,  2262,  2263,  2266,  2268,  2270,  2272,  2274,  2276,  2278,
    2280,  2284,  2286,  2290,  2291,  2294,  2299,  2302,  2304,  2308,
    2317,  2322,  2326,  2327,  2330,  2331,  2347,  2350,  2355,  2356,
    2359,  2362,  2365,  2366,  2369,  2371,  2373,  2377,  2378,  2379,
    2382,  2385,  2390,  2391,  2394,  2396,  2400,  2402,  2406,  2407,
    2408,  2409,  2410,  2413,  2414,  2415,  2416,  2419,  2421,  2425,
    2427,  2435,  2439,  2441,  2446,  2448,  2453,  2455,  2457,  2459,
    2461,  2463,  2465,  2467,  2469,  2471,  2474,  2476,  2478,  2482,
    2483,  2487,  2491,  2492,  2495,  2496,  2509,  2511,  2515,  2517,
    2521,  2523,  2527,  2529,  2531,  2533,  2538,  2540,  2544,  2547,
    2552,  2553,  2557,  2561,  2562,  2572,  2574,  2576,  2580,  2581,
    2584,  2585,  2596,  2598,  2600,  2602,  2604,  2606,  2608,  2610,
    2612,  2614,  2616,  2618,  2620,  2622,  2626,  2627,  2637,  2639,
    2641,  2643,  2645,  2647,  2657,  2659,  2661,  2663,  2665,  2667,
    2669,  2671,  2673,  2675,  2687,  2686,  2696,  2697,  2698,  2702,
    2704,  2708,  2709,  2710,  2711,  2712,  2715,  2716,  2720,  2721,
    2722,  2723,  2726,  2727,  2728,  2731,  2733,  2745,  2749,  2753,
    2755,  2768,  2769,  2770,  2771,  2772,  2773,  2774,  2775,  2776,
    2777,  2778,  2779,  2780,  2781,  2784,  2785,  2786,  2790,  2792,
    2793,  2797,  2798,  2799,  2803,  2804,  2815,  2817,  2826,  2828,
    2830,  2833,  2843,  2855,  2857,  2861,  2863,  2867,  2869,  2871,
    2873,  2875,  2877,  2879,  2881,  2883,  2885,  2887,  2891,  2892,
    2903,  2907,  2909,  2914,  2915,  2919,  2929,  2931,  2942,  2949,
    2951,  2953,  2955,  2957,  2961,  2962,  2966,  2980,  2982,  2984,
    2997,  2999,  3001,  3005,  3007,  3011,  3012,  3015,  3016,  3019,
    3020,  3023,  3024,  3027,  3030,  3041,  3046,  3047,  3048,  3049,
    3050,  3054,  3055,  3105,  3110,  3112,  3114,  3118,  3120,  3124,
    3128,  3129,  3139,  3143,  3144,  3147,  3151,  3154,  3157,  3158,
    3159,  3160,  3161,  3162,  3163,  3164,  3167,  3168,  3178,  3187,
    3188,  3192,  3193,  3197,  3200,  3203,  3206,  3207,  3216,  3247,
    3248,  3249,  3250,  3251,  3255,  3261,  3262,  3272,  3274,  3278,
    3280,  3284,  3286,  3288,  3290,  3294,  3295,  3298,  3302,  3304,
    3306,  3308,  3312,  3317,  3318,  3328,  3330,  3332,  3334,  3336,
    3338,  3340,  3342,  3346,  3347,  3350,  3351,  3354,  3356,  3358,
    3361,  3364,  3365,  3368,  3372,  3373,  3376,  3378,  3380,  3382,
    3386,  3388,  3390,  3392,  3394,  3398,  3399,  3402,  3403,  3406,
    3416,  3419,  3422,  3425,  3429,  3430,  3434,  3435,  3439,  3440,
    3444,  3446,  3451,  3452,  3455,  3457,  3469,  3470,  3473,  3474,
    3484,  3486,  3488,  3490,  3492,  3494,  3496,  3498,  3500,  3502,
    3504,  3525,  3527,  3529,  3531,  3533,  3535,  3539,  3541,  3543,
    3545,  3549,  3550,  3551,  3552,  3556,  3557,  3567,  3569,  3573,
    3575,  3577,  3579,  3583,  3585,  3587,  3591,  3594,  3595,  3598,
    3600,  3604,  3617,  3619,  3621,  3623,  3628,  3634,  3641,  3648,
    3649,  3650,  3651,  3652,  3653,  3654,  3655,  3656,  3659,  3660,
    3661,  3662,  3663,  3664,  3666,  3668,  3672,  3673,  3674,  3675,
    3676,  3679,  3687,  3689,  3691,  3693,  3695,  3697,  3699,  3701,
    3703,  3705,  3707,  3711,  3714,  3717,  3719,  3722,  3725,  3727,
    3730,  3738,  3739,  3742,  3743,  3746,  3750,  3759,  3760,  3763,
    3764,  3767,  3771,  3775,  3777,  3779,  3781,  3783,  3785,  3789,
    3792,  3795,  3798,  3801,  3803,  3805,  3807,  3811,  3815,  3817,
    3820,  3823,  3824,  3825,  3826,  3827,  3828,  3829,  3830,  3831,
    3832,  3833,  3834,  3835,  3836,  3862,  3864,  3866,  3877,  3879,
    3881,  3883,  3885,  3887,  3889,  3891,  3893,  3895,  3897,  3899,
    3901,  3903,  3905,  3907,  3909,  3911,  3913,  3915,  3917,  3919,
    3921,  3923,  3925,  3927,  3929,  3931,  3933,  3935,  3937,  3939,
    3941,  3943,  3954,  3956,  3958,  3960,  3962,  3964,  3966,  3968,
    3970,  3972,  3974,  3976,  3978,  3980,  3982,  3984,  3986,  3988,
    3990,  4002,  4004,  4006,  4008,  4010,  4012,  4014,  4016,  4018,
    4020,  4022,  4024,  4026,  4028,  4030,  4032,  4034,  4036,  4038,
    4050,  4052,  4054,  4056,  4058,  4060,  4062,  4064,  4066,  4068,
    4070,  4082,  4084,  4086,  4088,  4090,  4092,  4094,  4096,  4098,
    4100,  4102,  4104,  4106,  4108,  4110,  4112,  4114,  4116,  4118,
    4120,  4122,  4124,  4126,  4128,  4131,  4133,  4135,  4137,  4139,
    4141,  4143,  4145,  4147,  4149,  4154,  4156,  4158,  4162,  4163,
    4164,  4167,  4168,  4171,  4172,  4173,  4174,  4175,  4176,  4177,
    4178,  4179,  4182,  4183,  4186,  4187,  4190,  4191,  4192,  4193,
    4194,  4195,  4198,  4200,  4204,  4207,  4210,  4212,  4216,  4217,
    4221,  4222,  4228,  4229,  4230,  4231,  4232,  4233,  4234,  4235,
    4239,  4241,  4246,  4250,  4253,  4256,  4258,  4260,  4262,  4264,
    4267,  4270,  4274,  4278,  4280,  4282,  4286,  4288,  4295,  4299,
    4301,  4305,  4309,  4312,  4315,  4316,  4319,  4320,  4324,  4325,
    4326,  4327,  4330,  4331,  4335,  4336,  4339,  4340,  4344,  4345,
    4349,  4350,  4353,  4361,  4363,  4368,  4370,  4372,  4448,  4449,
    4452,  4454,  4458,  4460,  4464,  4466,  4471,  4472,  4473,  4474,
    4475,  4477,  4479,  4481,  4489,  4491,  4493,  4495,  4497,  4499,
    4501,  4503,  4507,  4508,  4509,  4510,  4511,  4521,  4527,  4528,
    4531,  4532,  4535,  4543,  4546,  4554,  4555,  4564,  4573,  4585,
    4586,  4589,  4590,  4591,  4594,  4595,  4596,  4597,  4598,  4601,
    4602,  4605,  4606,  4607,  4608,  4609,  4610,  4613,  4615,  4622,
    4638,  4640,  4643,  4645,  4649,  4661,  4677,  4681,  4692,  4693,
    4696,  4708,  4717,  4718,  4721,  4722,  4723,  4726,  4727,  4730,
    4731,  4734,  4735,  4738,  4740,  4742,  4744,  4748,  4755,  4778,
    4810,  4820,  4827,  4867,  4869,  4876,  4878,  4879,  4884,  4882,
    4897,  4896,  4909,  4915,  4917,  4918,  4921,  4922,  4923,  4924,
    4925,  4932,  4931,  4941,  4943,  4945,  4946,  4947,  4950,  4951,
    4952,  4953,  4954,  4957,  4958,  4962,  4961,  5019,  5017,  5032,
    5031,  5044,  5050,  5051,  5054,  5056,  5057,  5060,  5061,  5062,
    5063,  5066,  5067,  5070,  5078,  5095,  5103,  5126,  5220,  5254,
    5256,  5258,  5262,  5266,  5265,  5316,  5318,  5317,  5332,  5338,
    5345,  5350,  5353,  5354,  5357,  5358,  5359,  5360,  5361,  5362,
    5363,  5371,  5379,  5382,  5383,  5384,  5385,  5386,  5387,  5395,
    5403,  5404,  5405,  5408,  5409,  5412,  5414,  5418,  5500,  5501,
    5508,  5509,  5510,  5516,  5525,  5528,  5529,  5530,  5531,  5534,
    5535,  5536,  5542,  5556,  5555,  5573,  5574,  5575,  5576,  5577,
    5580,  5582,  5586,  5587,  5594,  5599,  5601,  5602,  5605,  5606,
    5609,  5616,  5623,  5623,  5625,  5626,  5629,  5629,  5631,  5641,
    5650,  5657,  5663,  5669,  5677,  5678,  5690,  5701,  5712,  5716,
    5717,  5720,  5725,  5729,  5730,  5733,  5740,  5747,  5751,  5752,
    5755,  5758,  5762,  5763,  5766,  5773,  5774,  5775,  5776,  5777,
    5778,  5779,  5780,  5781,  5782,  5783,  5784,  5785,  5786,  5787,
    5817,  5818,  5821,  5822,  5829,  5830,  5831,  5838,  5837,  5896,
    5897,  5904,  5903,  5972,  5978,  5984,  5992,  5998,  6004,  6010,
    6016,  6022,  6028,  6034,  6040,  6051,  6052,  6055,  6056,  6057,
    6058,  6059,  6060,  6061,  6062,  6063,  6064,  6065,  6066,  6067,
    6068,  6069,  6070,  6071,  6072,  6073,  6074,  6075,  6076,  6077,
    6078,  6079,  6080,  6081,  6082,  6085,  6086,  6087,  6088,  6089,
    6090,  6094,  6095,  6096,  6097,  6098,  6099,  6100,  6103,  6117,
    6118,  6119,  6120,  6121,  6122,  6123,  6124,  6128,  6129,  6130,
    6131,  6132,  6133,  6134,  6138,  6139,  6140,  6141,  6142,  6147,
    6148,  6149,  6150,  6151,  6157,  6158,  6159,  6160,  6161,  6162,
    6163,  6164,  6165,  6168,  6169,  6170,  6171,  6174,  6175,  6176,
    6177,  6180,  6181,  6182,  6183,  6184,  6185,  6186,  6204,  6204,
    6206,  6207,  6208,  6209,  6210,  6211,  6217,  6218,  6221,  6222,
    6223,  6224,  6225,  6226,  6227,  6228,  6229,  6230,  6231,  6232,
    6233,  6234,  6235,  6236,  6237,  6238,  6239,  6240,  6241,  6242,
    6243,  6244,  6245,  6246,  6247,  6248,  6249,  6250,  6252,  6253,
    6254,  6255,  6256,  6257,  6258,  6259,  6260,  6261,  6263,  6264,
    6265,  6266,  6267,  6268,  6269,  6270,  6271,  6272,  6273,  6274,
    6275,  6276,  6277,  6278,  6279,  6280,  6281,  6282,  6283,  6284,
    6285,  6286,  6287,  6288,  6289,  6290,  6291,  6292,  6294,  6295,
    6296,  6297,  6298,  6299,  6300,  6301,  6302,  6303,  6304,  6305,
    6306,  6307,  6308,  6309,  6310,  6311,  6312,  6313,  6314,  6315,
    6316,  6317,  6318,  6319,  6320,  6321,  6323,  6324,  6326,  6327,
    6328,  6329,  6330,  6331,  6332,  6333,  6334,  6335,  6336,  6337,
    6338,  6339,  6340,  6341,  6342,  6343,  6344,  6345,  6346,  6347,
    6348,  6349,  6350,  6351,  6352,  6353,  6354,  6355,  6356,  6357,
    6358,  6359,  6360,  6361,  6362,  6363,  6364,  6365,  6366,  6367,
    6368,  6369,  6370,  6371,  6372,  6373,  6374,  6375,  6376,  6378,
    6379,  6380,  6381,  6382,  6383,  6384,  6385,  6386,  6387,  6388,
    6389,  6390,  6391,  6392,  6393,  6394,  6395,  6396,  6397,  6398,
    6399,  6400,  6401,  6402,  6403,  6404,  6405,  6406,  6407,  6408,
    6409,  6410,  6411,  6412,  6413,  6414,  6415,  6416,  6417,  6418,
    6420,  6434,  6435,  6439,  6440,  6441,  6442,  6443,  6444,  6445,
    6446,  6447,  6448,  6452,  6453,  6454,  6455,  6456,  6457,  6458,
    6459,  6460,  6461,  6462,  6463,  6464,  6465,  6466,  6467,  6468,
    6469,  6470,  6471,  6472,  6475,  6489,  6490,  6491,  6492,  6493,
    6494,  6495,  6496,  6497,  6498,  6499,  6500,  6501,  6502,  6503,
    6504,  6505,  6506,  6507,  6508,  6518,  6519,  6520,  6521,  6522,
    6523,  6524,  6525,  6526,  6527,  6528,  6529,  6530,  6531,  6532,
    6533,  6534,  6535,  6536,  6537,  6538,  6539,  6540,  6541,  6542,
    6543,  6544,  6545,  6546,  6547,  6548,  6549,  6550,  6551,  6552,
    6553,  6554,  6555,  6556,  6557,  6558,  6559,  6560,  6561,  6562,
    6563,  6564,  6565,  6566,  6567,  6568,  6569,  6570,  6571,  6572,
    6573,  6574,  6575,  6576,  6577,  6578,  6579,  6583,  6584,  6588,
    6589,  6590,  6591,  6592,  6596,  6596,  6599,  6602,  6603,  6606,
    6608,  6613,  6623,  6630,  6631,  6632,  6635,  6667,  6668,  6671,
    6673,  6681,  6682,  6683,  6687,  6688,  6692,  6693,  6696,  6697,
    6700,  6701,  6702,  6703,  6704,  6707,  6708,  6709,  6710,  6711,
    6712,  6713,  6714,  6715,  6716,  6717,  6718,  6719,  6720,  6721,
    6722,  6723,  6724,  6725,  6726,  6727,  6728,  6729,  6730,  6731,
    6732,  6733,  6734,  6735,  6736,  6737,  6738,  6739,  6740,  6741,
    6742,  6743,  6744,  6745,  6746,  6747,  6748,  6749,  6750,  6751,
    6752,  6753,  6754,  6755,  6756,  6757,  6758,  6759,  6760,  6761,
    6762,  6763
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", "SQL_DATA", 
  "SQL_DATETIME_INTERVAL_CODE", "SQL_DATETIME_INTERVAL_PRECISION", 
  "SQL_DESCRIBE", "SQL_DESCRIPTOR", "SQL_DISCONNECT", "SQL_ENUM", 
  "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", "SQL_IDENTIFIED", 
  "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", "SQL_LONG", "SQL_NAME", 
  "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", 
  "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", 
  "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", 
  "BY", "CACHE", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", 
  "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", 
  "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", 
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONNECTION", "CONSTRAINT", 
  "CONSTRAINTS", "CONVERSION_P", "CONVERT", "COPY", "CREATE", "CREATEDB", 
  "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_DATE", 
  "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", 
  "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", 
  "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", 
  "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DISABLE_P", 
  "DISTINCT", "DO", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", 
  "EXCLUSIVE", "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", 
  "EXTRACT", "FALSE_P", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", 
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", 
  "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", 
  "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", 
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEW", "NEXT", "NO", 
  "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", 
  "NONE", "NOSUPERUSER", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", 
  "NULL_P", "NULLIF", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET", 
  "OIDS", "OLD", "ON", "ONLY", "OPERATOR", "OPTION", "OR", "ORDER", 
  "OUT_P", "OUTER_P", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARTIAL", 
  "PASSWORD", "PLACING", "POSITION", "PRECISION", "PRESERVE", "PREPARE", 
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", 
  "QUOTE", "READ", "REAL", "REASSIGN", "RECHECK", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "RESET", 
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", 
  "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", 
  "SCROLL", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", "SERIALIZABLE", 
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", 
  "SIMPLE", "SMALLINT", "SOME", "STABLE", "START", "STATEMENT", 
  "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", "SUBSTRING", 
  "SUPERUSER_P", "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", 
  "TEMP", "TEMPLATE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", 
  "VACUUM", "VALID", "VALIDATOR", "VALUES", "VARCHAR", "VARYING", 
  "VERBOSE", "VIEW", "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", 
  "WORK", "WRITE", "YEAR_P", "ZONE", "WITH_CASCADED", "WITH_LOCAL", 
  "WITH_CHECK", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "DOLCONST", "ICONST", "PARAM", 
  "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", 
  "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", 
  "'}'", "\"=\"", "','", "':'", "$accept", "prog", "statements", 
  "statement", "opt_at", "stmt", "CreateRoleStmt", "opt_with", 
  "OptRoleList", "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", 
  "AlterUserStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", 
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list_or_default", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_rel_cmds", "alter_rel_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids", 
  "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_delete", "key_update", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "CreateAsStmt", "@1", 
  "OptCreateAs", "CreateAsList", "CreateAsElement", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", 
  "opt_trusted", "handler_name", "opt_validator", "opt_lancompiler", 
  "DropPLangStmt", "opt_procedural", "CreateTableSpaceStmt", 
  "OptTableSpaceOwner", "DropTableSpaceStmt", "CreateTrigStmt", 
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent", 
  "TriggerForSpec", "TriggerForOpt", "TriggerForType", "TriggerFuncArgs", 
  "TriggerFuncArg", "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "aggr_args_list", 
  "old_aggr_definition", "old_aggr_list", "old_aggr_elem", 
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default", 
  "opt_recheck", "DropOpClassStmt", "DropOwnedStmt", "ReassignOwnedStmt", 
  "DropStmt", "drop_type", "any_name_list", "any_name", "attrs", 
  "TruncateStmt", "FetchStmt", "fetch_direction", "from_in", 
  "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes", "any_operator", 
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", "CreateConversionStmt", 
  "ClusterStmt", "VacuumStmt", "AnalyzeStmt", "analyze_keyword", 
  "opt_verbose", "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "returning_clause", 
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type", 
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause", 
  "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold", 
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_opt_alias", "func_table", 
  "where_clause", "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "Iresult", "SimpleTypename", "ConstTypename", 
  "GenericType", "Numeric", "opt_float", "opt_numeric", "opt_decimal", 
  "Bit", "ConstBit", "BitWithLength", "BitWithoutLength", "Character", 
  "ConstCharacter", "CharacterWithLength", "CharacterWithoutLength", 
  "character", "opt_varying", "opt_charset", "ConstDatetime", 
  "ConstInterval", "opt_timezone", "opt_interval", "a_expr", "b_expr", 
  "c_expr", "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "ctext_expr", "ctext_expr_list", "ctext_row", "target_list", 
  "target_el", "relation_name", "qualified_name_list", "qualified_name", 
  "name_list", "name", "database_name", "access_method", "attr_name", 
  "index_name", "file_name", "func_name", "AexprConst", "Iconst", 
  "Fconst", "Bconst", "Xconst", "Sconst", "PosIntConst", "IntConst", 
  "IntConstVar", "AllConstVar", "StringConst", "PosIntStringConst", 
  "NumConst", "AllConst", "PosAllConst", "RoleId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into", "using_list", "UsingConst", "ECPGPrepare", 
  "ECPGDescribe", "opt_output", "ECPGAllocateDescr", 
  "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_name", 
  "function_name", "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", 
  "ECPGCKeywords", "unreserved_keyword", "ECPGunreserved_interval", 
  "ECPGunreserved", "ECPGunreserved_con", "col_name_keyword", 
  "func_name_keyword", "reserved_keyword", "into_list", "ecpgstart", 
  "c_args", "coutputvariable", "civarind", "civar", "indicator", 
  "cvariable", "ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,    61,    60,    62,   689,    43,    45,
      42,    47,    37,    94,   690,    91,    93,    40,    41,    46,
      59,   123,   125,   691,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   456,   457,   458,   458,   459,   459,   459,   459,   459,
     459,   459,   459,   460,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   462,   463,   463,   464,
     464,   464,   464,   464,   464,   464,   464,   464,   464,   464,
     464,   464,   464,   464,   464,   464,   464,   464,   464,   464,
     464,   465,   466,   467,   467,   468,   467,   467,   469,   469,
     470,   470,   471,   472,   473,   473,   474,   474,   475,   475,
     476,   476,   477,   477,   478,   478,   478,   478,   478,   478,
     479,   479,   479,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   481,   481,   482,   482,   483,   483,   484,   484,
     484,   484,   485,   485,   485,   486,   486,   486,   486,   487,
     487,   487,   487,   487,   487,   488,   488,   488,   489,   489,
     490,   490,   490,   490,   490,   491,   491,   491,   491,   491,
     492,   493,   493,   494,   494,   495,   496,   496,   497,   497,
     498,   498,   498,   498,   498,   498,   498,   498,   498,   498,
     498,   498,   498,   498,   498,   498,   498,   498,   498,   498,
     498,   498,   499,   499,   500,   500,   500,   500,   501,   501,
     502,   502,   502,   503,   503,   504,   505,   505,   506,   506,
     507,   507,   507,   508,   508,   509,   509,   509,   509,   509,
     509,   509,   509,   509,   509,   510,   510,   511,   511,   512,
     512,   513,   513,   514,   514,   515,   515,   515,   515,   515,
     515,   515,   516,   516,   517,   517,   518,   518,   518,   519,
     520,   520,   521,   521,   521,   522,   522,   522,   522,   522,
     522,   522,   523,   523,   523,   523,   524,   525,   525,   526,
     526,   526,   526,   526,   526,   527,   527,   528,   528,   528,
     528,   529,   529,   530,   530,   531,   532,   532,   532,   533,
     533,   533,   533,   533,   534,   535,   536,   536,   536,   536,
     536,   537,   537,   538,   538,   538,   538,   539,   539,   539,
     539,   540,   540,   541,   541,   543,   542,   544,   544,   545,
     545,   546,   547,   548,   549,   549,   550,   550,   550,   550,
     550,   550,   550,   550,   550,   550,   550,   551,   551,   552,
     552,   553,   553,   554,   554,   555,   555,   556,   556,   557,
     557,   558,   558,   559,   560,   560,   561,   561,   562,   562,
     563,   563,   564,   564,   564,   565,   565,   565,   566,   566,
     567,   567,   568,   568,   569,   569,   569,   570,   570,   571,
     571,   572,   572,   572,   572,   572,   573,   573,   574,   574,
     575,   575,   576,   577,   578,   578,   578,   578,   578,   578,
     579,   580,   580,   581,   581,   582,   582,   582,   582,   582,
     583,   583,   584,   584,   585,   586,   586,   587,   588,   589,
     589,   590,   590,   590,   590,   591,   591,   592,   592,   593,
     593,   594,   595,   596,   596,   597,   597,   597,   597,   597,
     597,   597,   597,   598,   598,   599,   599,   600,   600,   601,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   602,
     603,   603,   603,   603,   603,   603,   603,   603,   603,   603,
     603,   603,   603,   603,   604,   604,   605,   605,   605,   605,
     605,   605,   605,   605,   605,   605,   605,   606,   606,   606,
     606,   606,   606,   606,   606,   606,   606,   606,   606,   607,
     607,   608,   609,   609,   610,   610,   610,   611,   611,   612,
     612,   612,   612,   613,   613,   613,   613,   613,   613,   613,
     613,   614,   614,   615,   615,   616,   616,   617,   617,   618,
     619,   620,   621,   621,   622,   622,   623,   623,   624,   624,
     625,   625,   626,   626,   627,   627,   627,   628,   628,   628,
     629,   629,   630,   630,   631,   631,   632,   632,   633,   633,
     633,   633,   633,   634,   634,   634,   634,   635,   635,   636,
     637,   637,   638,   638,   639,   639,   640,   640,   640,   640,
     640,   640,   640,   640,   640,   640,   641,   641,   641,   642,
     642,   643,   644,   644,   645,   645,   646,   646,   647,   647,
     648,   648,   649,   649,   649,   649,   650,   650,   651,   651,
     652,   652,   653,   654,   654,   655,   655,   655,   656,   656,
     657,   657,   658,   658,   658,   658,   658,   658,   658,   658,
     658,   658,   658,   658,   658,   658,   659,   659,   660,   660,
     660,   660,   660,   660,   661,   661,   661,   661,   661,   661,
     661,   661,   661,   661,   663,   662,   664,   664,   664,   665,
     665,   666,   666,   666,   666,   666,   667,   667,   668,   668,
     668,   668,   669,   669,   669,   670,   670,   671,   672,   673,
     673,   674,   674,   674,   674,   674,   674,   674,   674,   674,
     674,   674,   674,   674,   674,   675,   675,   675,   676,   676,
     676,   677,   677,   677,   678,   678,   679,   679,   680,   680,
     680,   680,   681,   682,   682,   683,   683,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   685,   685,
     686,   687,   687,   688,   688,   689,   690,   690,   691,   692,
     692,   692,   692,   692,   693,   693,   694,   695,   695,   695,
     696,   696,   696,   697,   697,   698,   698,   699,   699,   700,
     700,   701,   701,   702,   702,   703,   704,   704,   704,   704,
     704,   705,   705,   706,   707,   707,   707,   708,   708,   709,
     710,   710,   711,   712,   712,   713,   714,   714,   715,   715,
     715,   715,   715,   715,   715,   715,   716,   716,   717,   718,
     718,   719,   719,   720,   721,   722,   723,   723,   724,   725,
     725,   725,   725,   725,   726,   726,   726,   727,   727,   728,
     728,   729,   729,   729,   729,   730,   730,   731,   731,   731,
     731,   731,   732,   732,   732,   733,   733,   733,   733,   733,
     733,   733,   733,   734,   734,   735,   735,   736,   736,   736,
     736,   737,   737,   738,   739,   739,   740,   740,   740,   740,
     741,   741,   741,   741,   741,   742,   742,   743,   743,   744,
     745,   745,   746,   746,   747,   747,   748,   748,   749,   749,
     750,   750,   751,   751,   752,   752,   753,   753,   754,   754,
     755,   755,   755,   755,   755,   755,   755,   755,   755,   755,
     755,   756,   756,   756,   756,   756,   756,   757,   757,   757,
     757,   758,   758,   758,   758,   759,   759,   760,   760,   761,
     761,   761,   761,   762,   762,   762,   763,   764,   764,   765,
     765,   766,   767,   767,   767,   767,   768,   768,   768,   769,
     769,   769,   769,   769,   769,   769,   769,   769,   770,   770,
     770,   770,   770,   770,   770,   770,   771,   771,   771,   771,
     771,   772,   773,   773,   773,   773,   773,   773,   773,   773,
     773,   773,   773,   774,   774,   775,   775,   775,   776,   776,
     776,   777,   777,   778,   778,   779,   780,   781,   781,   782,
     782,   783,   784,   785,   785,   785,   785,   785,   785,   786,
     786,   787,   787,   788,   788,   788,   788,   789,   790,   790,
     790,   791,   791,   791,   791,   791,   791,   791,   791,   791,
     791,   791,   791,   791,   791,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   793,   793,   793,   793,   793,   793,   793,   793,   793,
     793,   793,   793,   793,   793,   793,   793,   793,   793,   793,
     794,   794,   794,   794,   794,   794,   794,   794,   794,   794,
     794,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   795,   795,   796,   796,   796,   797,   797,
     797,   798,   798,   799,   799,   799,   799,   799,   799,   799,
     799,   799,   800,   800,   801,   801,   802,   802,   802,   802,
     802,   802,   803,   803,   804,   804,   805,   805,   806,   806,
     807,   807,   808,   808,   808,   808,   808,   808,   808,   808,
     809,   809,   810,   811,   811,   812,   812,   812,   812,   812,
     812,   813,   814,   815,   815,   815,   816,   816,   817,   818,
     818,   819,   820,   820,   821,   821,   822,   822,   823,   823,
     823,   823,   824,   824,   825,   825,   826,   826,   827,   827,
     828,   828,   829,   830,   830,   831,   831,   831,   832,   832,
     833,   833,   834,   834,   835,   835,   836,   837,   838,   839,
     840,   841,   842,   842,   843,   843,   843,   843,   843,   843,
     843,   843,   844,   845,   846,   847,   848,   848,   849,   849,
     850,   850,   851,   851,   852,   852,   852,   852,   852,   853,
     853,   854,   854,   854,   855,   855,   855,   855,   855,   856,
     856,   857,   857,   857,   857,   857,   857,   858,   859,   859,
     860,   860,   860,   860,   861,   861,   861,   861,   862,   862,
     863,   864,   865,   865,   866,   866,   866,   867,   867,   868,
     868,   869,   869,   870,   870,   870,   870,   871,   871,   872,
     873,   873,   874,   875,   875,   876,   877,   877,   879,   878,
     880,   878,   878,   881,   882,   882,   883,   883,   883,   883,
     883,   885,   884,   886,   887,   888,   888,   888,   889,   889,
     889,   889,   889,   890,   890,   892,   891,   894,   893,   895,
     893,   893,   896,   896,   897,   897,   897,   898,   898,   898,
     898,   899,   899,   900,   900,   900,   900,   900,   900,   901,
     901,   901,   902,   904,   903,   905,   906,   905,   907,   907,
     908,   908,   909,   909,   910,   910,   910,   910,   910,   910,
     910,   910,   910,   911,   911,   911,   911,   911,   911,   911,
     911,   911,   911,   912,   912,   913,   913,   914,   915,   915,
     916,   916,   916,   917,   918,   919,   919,   919,   919,   920,
     920,   920,   921,   922,   921,   923,   923,   923,   923,   923,
     924,   924,   925,   925,   926,   927,   928,   928,   929,   929,
     930,   931,   932,   932,   933,   933,   934,   934,   935,   935,
     936,   937,   937,   937,   938,   938,   939,   940,   941,   942,
     942,   943,   944,   945,   945,   946,   947,   948,   949,   949,
     950,   951,   952,   952,   953,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     955,   955,   956,   956,   957,   957,   957,   959,   958,   960,
     960,   962,   961,   963,   963,   963,   964,   964,   964,   964,
     964,   964,   964,   964,   964,   965,   965,   966,   966,   966,
     966,   966,   966,   966,   966,   966,   966,   966,   966,   966,
     966,   966,   966,   966,   966,   966,   966,   966,   966,   966,
     966,   966,   966,   966,   966,   967,   967,   967,   967,   967,
     967,   968,   968,   968,   968,   968,   968,   968,   969,   970,
     970,   970,   970,   970,   970,   970,   970,   971,   971,   971,
     971,   971,   971,   971,   972,   972,   972,   972,   972,   973,
     973,   973,   973,   973,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   975,   975,   975,   975,   976,   976,   976,
     976,   977,   977,   977,   977,   977,   977,   977,   978,   978,
     979,   979,   979,   979,   979,   979,   980,   980,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   982,   982,   982,   983,   983,   983,   983,   983,
     983,   983,   983,   983,   983,   983,   983,   983,   983,   983,
     983,   983,   983,   983,   983,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   985,   985,   986,   987,   987,   988,
     988,   989,   990,   991,   991,   991,   992,   993,   993,   994,
     994,   995,   995,   995,   996,   996,   997,   997,   998,   998,
     999,   999,   999,   999,   999,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     1,     0,     2,
       2,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     2,     2,     2,     2,     3,
       3,     5,     5,     5,     4,     5,     5,     4,     3,     5,
       3,     5,     5,     6,     1,     1,     3,     5,     6,     4,
       1,     0,     2,     0,     1,     1,     1,     1,     1,     1,
       2,     3,     3,     3,     3,     3,     2,     5,     2,     2,
       3,     3,     1,     3,     1,     1,     1,     3,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     6,     1,     1,     1,     1,     0,     1,     1,
       3,     4,     5,     4,     2,     2,     3,     4,     3,     2,
       4,     1,     1,     1,     1,     1,     4,     4,     1,     3,
       3,     4,     6,     6,     6,     6,     4,     6,     2,     4,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       3,     1,     1,     3,     3,     3,     2,     2,     3,     2,
       1,     1,     0,     2,     0,     2,     9,     6,     1,     1,
       1,     1,     1,     2,     0,     1,     1,     3,     3,     1,
       1,     3,     3,     3,     4,     1,     0,     2,     0,     3,
       0,     1,     0,    11,    12,     1,     1,     2,     2,     2,
       2,     0,     1,     0,     1,     3,     1,     1,     1,     3,
       2,     0,     3,     1,     1,     2,     1,     3,     4,     4,
       2,     5,     1,     2,     2,     2,     3,     2,     0,     2,
       2,     2,     2,     2,     2,     3,     1,     4,     6,     7,
      11,     3,     0,     3,     1,     1,     2,     2,     0,     1,
       1,     2,     2,     0,     3,     3,     2,     1,     1,     2,
       2,     4,     0,     2,     2,     2,     0,     3,     4,     4,
       0,     2,     0,     4,     0,     0,    11,     3,     0,     3,
       1,     1,     5,     4,     2,     0,     2,     1,     2,     3,
       2,     2,     2,     2,     3,     3,     3,     1,     0,     5,
       9,     1,     0,     1,     2,     2,     0,     2,     0,     5,
       7,     1,     0,     6,     2,     0,     3,     5,    14,    19,
       1,     1,     1,     3,     5,     1,     1,     1,     3,     0,
       1,     0,     1,     1,     1,     3,     0,     1,     1,     0,
       2,     1,     2,     1,     2,     0,     2,     1,     2,     2,
       6,     8,     8,     3,     5,     4,     4,     4,     3,     7,
       3,     1,     3,     3,     1,     1,     1,     1,     1,     1,
       3,     3,     1,     3,     3,     1,     3,     3,    12,     1,
       3,     4,     7,     4,     2,     1,     0,     1,     0,     7,
       9,     5,     6,     6,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     2,     2,     3,     4,
       5,     4,     4,     3,     4,     3,     3,     2,     4,     2,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     2,
       2,     1,     2,     2,     1,     1,     6,     7,     7,     9,
       8,     8,     6,     9,     7,    10,     7,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     7,     7,    10,     2,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
       2,     1,     3,     1,     2,     3,     0,     1,     3,     2,
       6,     6,     3,     0,     3,     0,    13,    14,     1,     0,
       2,     0,     1,     3,     2,     2,     4,     1,     2,     0,
       9,     7,     2,     0,     3,     2,     1,     3,     3,     3,
       2,     2,     1,     1,     1,     1,     2,     1,     3,     1,
       1,     5,     1,     4,     1,     2,     4,     5,     1,     1,
       1,     1,     3,     3,     2,     2,     2,     2,     1,     2,
       0,     5,     1,     2,     1,     0,     5,     7,     5,     7,
       7,     9,     1,     3,     3,     3,     1,     3,    11,    10,
       2,     0,     9,     2,     0,     4,     4,     4,     1,     1,
       1,     0,     7,     6,     6,     7,     6,     6,     9,     6,
       6,     6,     8,     8,     6,     6,     1,     0,     7,     6,
       7,     6,     6,     6,     7,     6,     6,     6,     7,     9,
       9,     6,     6,     6,     0,    14,     1,     1,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     0,     6,     8,     2,     2,     2,
       2,     2,     3,     3,     2,     2,     2,     2,     3,     2,
       5,     4,     3,     3,     3,     1,     1,     0,     3,     2,
       2,     1,     3,     2,     1,     0,     8,    10,     2,     3,
       3,     0,     2,     5,     3,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     4,     3,     3,     1,     0,
       5,     5,     4,     2,     0,     4,     3,     5,     6,     4,
       6,     6,     5,     7,     1,     0,    10,     4,     2,     1,
       4,     5,     5,     2,     4,     1,     1,     1,     0,     1,
       0,     1,     0,     3,     0,     4,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     4,     2,     3,     1,     2,
       2,     0,     6,     2,     0,     5,     3,     0,     2,     2,
       2,     3,     1,     3,     1,     2,     1,     0,     7,     1,
       3,     1,     1,     3,     5,     2,     1,     3,     7,     0,
       2,     2,     2,     3,     0,     2,     2,     1,     1,     3,
       3,     1,     2,     4,     4,     1,     1,     8,     1,     4,
       4,     4,     2,     1,     0,     3,     3,     4,     4,     4,
       4,     2,     1,     1,     0,     1,     0,     1,     5,     1,
       0,     1,     0,     3,     1,     3,     3,     2,     2,     1,
       4,     4,     2,     2,     4,     1,     0,     1,     1,     1,
       3,     0,     2,     0,     1,     3,     1,     0,     1,     2,
       4,     4,     2,     0,     2,     3,     2,     0,     3,     1,
       1,     2,     1,     2,     5,     6,     5,     1,     2,     1,
       4,     3,     4,     5,     4,     5,     4,     5,     2,     4,
       1,     2,     2,     2,     1,     1,     0,     4,     2,     1,
       2,     2,     4,     1,     2,     3,     1,     2,     0,     1,
       3,     2,     2,     3,     5,     6,     3,     4,     0,     1,
       3,     3,     3,     3,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     5,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     3,     0,     5,     3,     0,     5,     3,
       0,     1,     1,     1,     1,     5,     2,     1,     1,     1,
       1,     5,     2,     2,     2,     1,     3,     3,     2,     1,
       0,     3,     0,     5,     2,     5,     2,     1,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     0,     1,     3,     5,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     3,     3,     2,     3,     5,     4,     6,     3,
       5,     4,     6,     4,     6,     5,     7,     2,     3,     2,
       4,     3,     3,     4,     3,     4,     3,     4,     5,     6,
       6,     7,     6,     7,     6,     7,     3,     4,     4,     6,
       2,     1,     3,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     5,     6,     6,     7,
       1,     1,     2,     4,     1,     1,     1,     2,     2,     2,
       1,     3,     4,     5,     5,     4,     1,     1,     4,     1,
       4,     1,     4,     1,     4,     1,     1,     1,     1,     6,
       4,     4,     4,     4,     6,     5,     5,     5,     4,     6,
       4,     6,     4,     4,     4,     4,     3,     5,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     1,     4,     1,     4,     1,     2,
       1,     2,     1,     3,     3,     0,     3,     1,     1,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     3,     2,     3,     0,     3,     3,     2,     2,     1,
       0,     2,     2,     3,     2,     1,     1,     3,     5,     2,
       1,     4,     2,     0,     1,     0,     1,     2,     2,     2,
       3,     5,     1,     2,     0,     2,     1,     0,     1,     1,
       1,     3,     3,     3,     1,     3,     1,     1,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     3,     6,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     3,     2,     2,     3,     7,     1,     1,     1,     0,
       2,     2,     1,     0,     1,     3,     1,     2,     0,     2,
       0,     2,     0,     1,     3,     4,     3,     1,     1,     1,
       2,     0,     7,     3,     2,     1,     1,     1,     0,     5,
       0,     4,     2,     1,     2,     0,     1,     3,     3,     3,
       3,     0,     4,     5,     5,     0,     1,     1,     1,     1,
       2,     2,     2,     1,     2,     0,     7,     0,     5,     0,
       4,     2,     2,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     2,     1,     3,
       2,     2,     3,     0,     5,     1,     0,     5,     2,     2,
       1,     1,     1,     2,     2,     3,     1,     2,     2,     3,
       3,     4,     2,     1,     2,     1,     1,     2,     2,     3,
       1,     1,     1,     1,     0,     1,     3,     5,     0,     2,
       0,     1,     2,     3,     2,     1,     1,     1,     0,     1,
       1,     1,     3,     0,     4,     2,     2,     1,     1,     0,
       1,     1,     1,     1,     2,     3,     0,     1,     2,     1,
       4,     4,     0,     1,     2,     1,     1,     3,     1,     1,
       4,     4,     4,     4,     1,     0,     3,     3,     4,     1,
       3,     3,     4,     1,     3,     3,     1,     6,     1,     3,
       3,     6,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     4,     1,     1,     4,     4,     3,     0,     7,     1,
       0,     0,     7,     3,     4,     3,     1,     1,     1,     2,
       3,     5,     2,     5,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     0,     1,     2,
       1,     2,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     2,     1,     3,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2080,  2081,  2084,  2088,  2089,  2016,
    2090,  2091,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,
    2064,  2065,  2066,  2067,  2069,  2068,  2070,  2071,  2072,  2073,
    2074,  2075,  2076,  2077,  2079,  2078,  2093,  2094,  2082,  2083,
    2085,  2086,  2055,  2087,  2095,  2096,  2097,  2092,  2045,  1326,
    2046,    10,  1327,  1322,  1323,  2100,  2051,  2052,  2050,  2053,
    2054,  2098,  2099,  2041,  2042,  2044,    11,    12,  2043,  2101,
       4,  2047,  2048,  2049,     8,  1411,  1484,     9,  2040,  1484,
       0,  1597,  1598,  1599,     0,  1600,  1601,  1602,  1603,  1604,
    1535,  1498,     0,  1605,     0,  1606,  1607,  1608,  1609,  1610,
    1611,  1612,  1613,  1614,     0,  1615,  1616,  1617,  1618,  1483,
    1619,  1620,  1621,  1622,  1623,  1460,  1466,  1624,  1581,     0,
    1440,  1441,  1437,  1439,  1438,  1442,  1425,   757,     0,   816,
     815,     0,  1925,   757,  1926,  1891,  1927,  1892,  1893,   225,
       0,   809,  1894,     0,   757,  1895,   286,   301,  1928,  1369,
       0,  1896,  1897,     0,     0,   412,   757,     0,  1898,   832,
    1899,     0,  1900,  1929,  1930,     0,     0,  1901,  1931,  1932,
    1902,     0,  1903,  1904,  1933,  1934,  1935,  1905,  1936,  1937,
       0,     0,   904,     0,  1906,  1938,  1907,  1908,     0,  1939,
    1909,  1910,  1911,  1940,  1941,  1912,  1913,  1914,     0,  1915,
       0,     0,     0,     0,     0,  1942,   757,  1916,     0,   910,
       0,  1917,     0,  1943,  1918,     0,  1919,  1920,  1921,  1922,
    1923,   904,  1577,  1461,     0,     0,   820,     0,  1924,  1944,
    2027,  2028,     0,     0,     0,    42,    48,    24,    23,    25,
      59,    64,    39,    18,    55,    43,    91,    92,    93,    31,
      27,    22,    28,    32,    45,    33,    44,    21,    40,    58,
      46,    62,    47,    63,    34,    53,    51,    41,    56,    57,
      76,    61,    87,    67,    30,    68,    82,    69,    83,    70,
      38,    17,    80,    78,    79,    35,    54,    77,    81,    19,
      20,    84,    60,    75,    72,    88,    86,    94,    73,    49,
      14,    15,    65,    37,    16,    36,    29,    90,    26,   818,
      66,    71,    52,    74,    89,    50,    85,   878,   877,   912,
     881,   888,    96,    97,    98,     7,  1395,  1397,  1396,  1484,
    1435,  1436,  1400,  1445,  1455,  1444,  1448,  1456,  1443,  1462,
       0,   100,   102,   103,   104,   107,   108,   101,    95,    99,
     106,   112,   105,   111,   109,   110,   113,   114,   115,  1676,
    1084,  1674,  1675,  1673,  1417,     0,  1484,  1419,  1418,  1484,
    1429,  1455,     0,  1625,  1626,  1627,  1628,  1629,  1630,  1681,
    1682,  1683,  1684,  1685,  1687,  1686,  1698,  1699,  1700,  1701,
    1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  1718,  1652,  1719,  1720,
    1721,  1722,  1723,  1724,  1725,  1726,  1727,  1697,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1737,  1690,  1738,
    1739,  1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,
    1749,  1750,  1751,  1752,  1753,  1755,  1754,  1756,  1757,  1758,
    1759,  1760,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1691,
    1768,  1769,  1770,  1771,  1772,  1773,  1774,  1775,  1776,  1777,
    1778,  1779,  1780,  1781,  1782,  1783,  1784,  1785,  1786,  1787,
    1788,  1789,  1790,  1791,  1792,  1793,  1794,  1795,  1692,  1796,
    1797,  1693,  1798,  1799,  1800,  1801,  1802,  1803,  1804,  1805,
    1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,  1814,  1815,
    1816,  1817,  1818,  1819,  1822,  1820,  1821,  1823,  1824,  1825,
    1826,  1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,  1835,
    1836,  1837,  1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,
    1846,  1847,  1848,  1694,  1849,  1850,  1851,  1852,  1853,  1854,
    1855,  1856,  1857,  1858,  1859,  1860,  1861,  1862,  1864,  1863,
    1866,  1865,  1867,  1868,  1869,  1870,  1369,  1871,  1872,  1873,
    1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,  1882,  1883,
    1653,  1884,  1885,  1886,  1887,  1888,  1889,  1695,  1890,  2026,
    1339,  1388,  1387,  1362,  1383,  1650,  1595,  1596,  1357,  1651,
    1648,  1688,  1689,  1696,  1649,  1340,  2022,  1647,  1534,     0,
       0,  1496,  1497,  1500,  1499,  1501,  1494,  1495,  1307,  1389,
    1631,  1632,  1633,  1634,  1636,  1635,  1637,  1945,  1946,  1947,
    1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,  1956,  1666,
    1957,  1958,  1959,  1960,  1961,  1962,  1965,  1963,  1964,  1966,
    1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,
    1977,  1978,  1979,  1980,  1981,  1982,  1983,  1667,  1668,  1984,
    1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,  2006,  1670,  2007,  2008,  1669,  2009,  2010,  2011,  2012,
    2013,     0,  1450,  1680,  1665,  1451,  1638,  1677,  1664,  1671,
    1672,  1679,  1678,  1514,  1306,  1516,  1458,  1468,  1464,  1472,
    1467,     0,     0,     0,     0,  1484,   756,   755,   741,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    13,     0,   765,   265,
    1359,  1358,  1302,   808,     0,  1298,  1299,   412,     0,   744,
     285,     0,     0,     0,     0,     0,     0,     0,   485,     0,
       0,     0,     0,     0,     0,     0,   161,     0,   296,   295,
       0,   401,     0,   598,     0,     0,   412,     0,     0,     0,
    1368,  1367,  1363,  1373,     0,  1366,  1647,     0,  1820,  1512,
    1513,  1394,  1858,   869,     0,     0,     0,   674,   501,     0,
     500,     0,     0,   498,     0,     0,   411,     0,     0,   502,
     496,   495,     0,     0,   499,     0,   497,     0,     0,   745,
    1769,  1503,   831,   818,  1699,   527,   531,   522,   528,   535,
     534,   523,   520,   521,  1832,     0,     0,     0,   517,  1328,
    1330,   526,  1329,     0,   565,   571,   570,   569,     0,   566,
     567,   572,     0,   738,  1299,   772,  1311,   903,     0,     0,
     519,   737,  1871,     0,     0,     0,   678,     0,   679,     0,
    1846,   749,   219,  1645,  1851,  1920,  1871,  1646,   215,  1643,
     182,  1644,  1640,  1641,  1642,  1639,     0,     0,   566,     0,
     746,   747,   909,   907,     0,     0,     0,     0,  1728,  1790,
    1799,  1842,  1851,  1920,  1871,   170,     0,   214,  1851,  1920,
    1871,     0,   765,     0,     0,  1459,   740,   739,     0,   983,
       0,   979,   819,   822,     0,   944,   886,     0,   757,     0,
       6,   817,   813,   906,   906,     0,   906,     0,   882,     0,
    1398,  1455,  1434,  1490,  1402,     0,     0,  1480,  1476,  1473,
    1481,  1482,  1475,  1463,  1073,  1074,  1075,  1072,  1076,  1071,
       0,  1406,  1447,  1412,     0,  1422,  1421,  1420,  1427,  1490,
    1431,  2029,  2030,  1536,  1361,  1380,     0,     0,     0,     0,
       0,     0,     0,  2034,  2038,     0,  2036,  2031,  1449,  1522,
    1515,  1517,  1519,  1470,  1469,  1465,     0,     0,  1586,     0,
       0,  1587,  1588,     0,  1583,  1585,     0,  1490,     0,     0,
    1650,  1312,  1651,  1648,  1661,  1647,     0,   505,   118,     0,
       0,   505,     0,     0,     0,     0,     0,  1721,  1211,  1221,
    1219,  1220,  1213,  1214,  1215,  1218,  1216,  1217,     0,   666,
    1212,     0,   118,     0,     0,   385,     0,     0,     0,     0,
     118,     0,     0,     0,   761,   764,   742,     0,     0,  1282,
    1303,     0,     0,     0,   547,   556,   548,   553,     0,   550,
       0,     0,   558,     0,   549,   551,   552,   557,     0,   554,
     555,     0,     0,   753,   288,     0,     0,     0,     0,     0,
     774,   805,   300,   299,   118,   298,   297,     0,     0,   612,
     118,     0,   163,   415,     0,   458,   118,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1372,  1378,     0,  1370,
    1537,  1393,  1493,     0,   844,  1768,     0,   453,     0,     0,
    1768,   796,  1768,     0,  1768,   156,  1304,     0,     0,     0,
       0,  1768,   148,  1768,     0,  1768,   416,  1768,     0,  1768,
     150,     0,  1768,   262,   503,  1511,  1510,  1502,  1509,     0,
     524,   533,   532,   530,   529,   525,  1331,     0,   515,   516,
    1522,  1525,   513,     0,   564,     0,     0,     0,     0,   847,
    1300,     0,   752,     0,     0,   681,   681,   681,   748,   218,
     216,     0,     0,     0,     0,     0,   754,     0,     0,     0,
    1891,  1892,  1032,  1275,     0,  1652,  1893,  1894,  1895,  1176,
    1185,  1177,  1179,  1186,  1896,  1897,  1747,  1898,  1899,  1319,
    1900,  1901,  1022,  1903,  1904,  1905,  1181,  1183,  1906,  1907,
       0,  1320,  1909,  1910,  1814,  1912,  1913,  1915,  1916,  1187,
    1918,  1919,  1920,  1921,  1922,  1923,  1318,     0,  1188,  1924,
    1222,  1324,  1325,  1284,     0,     0,  1297,     0,  1166,     0,
    1016,  1018,  1019,  1043,  1044,  1020,  1049,  1050,  1062,  1017,
       0,  1296,  1085,  1165,  1170,     0,  1164,  1160,   894,  1294,
    1276,     0,  1161,  1353,  1352,  1354,  1355,  1351,  1314,  1650,
    1657,  1021,  1651,  1648,  1321,  1356,  2022,  1647,     0,     0,
       0,     0,     0,  1576,   221,     0,   222,  1851,   171,   206,
     178,   205,   179,   209,   208,     0,  1719,   172,     0,   176,
       0,     0,     0,     0,     0,   210,   743,   262,     0,     0,
     981,     0,   984,     0,   980,   821,   818,  1289,  1288,  1290,
       0,   880,   879,     5,   824,   905,     0,     0,     0,     0,
       0,     0,     0,   937,   926,   934,   938,   945,  1490,  1491,
       0,  1485,     0,  1484,  1484,  1478,  1477,  1474,     0,     0,
       0,     0,     0,     0,  1345,  1344,  1403,  1405,  1348,     0,
    1490,     0,     0,  1382,     0,  1386,  1384,  1522,  1531,  1522,
    1532,  1533,  2032,     0,     0,  2035,  1452,     0,  1523,  1349,
    1350,  1528,     0,  1518,  1526,  1529,  1471,  1484,  1594,     0,
    1589,  1592,     0,  1584,     0,  1313,     0,     0,     0,     0,
       0,   506,     0,     0,     0,   117,   794,   792,     0,     0,
       0,   799,     0,     0,     0,   639,     0,     0,   640,   638,
     641,   652,   655,     0,   589,   154,   155,     0,     0,     0,
       0,     0,     0,   227,   252,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,   383,   697,   697,     0,     0,
     697,     0,     0,     0,   697,     0,   226,   228,   251,     0,
       0,     0,     0,     0,     0,     0,     0,   147,  1413,     0,
     759,   760,     0,   763,     0,  1279,  1278,  1309,  1283,   807,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   271,   272,   118,   270,     0,     0,   455,     0,
    1025,  1060,  1060,  1060,  1040,  1040,  1034,  1023,  1067,     0,
    1060,  1037,  1026,     0,  1024,  1070,  1070,  1055,     0,   998,
    1008,  1010,  1011,  1041,  1042,  1012,  1047,  1048,  1009,  1084,
    1656,  1021,  1658,  1655,  1654,     0,     0,   804,     0,     0,
     486,     0,   456,     0,     0,     0,   159,     0,     0,   421,
     420,     0,     0,   457,     0,   385,   378,   342,     0,     0,
    1727,     0,  1310,     0,     0,  1376,  1371,  1374,     0,  1364,
    1378,   870,   874,   871,     0,   872,     0,   988,     0,   262,
     673,     0,     0,     0,   262,     0,     0,  1768,     0,     0,
       0,   262,     0,     0,     0,     0,     0,     0,     0,     0,
     262,     0,   260,   261,     0,   494,  1504,  1507,  1508,     0,
     825,   827,   829,   828,   830,   826,   514,   511,   512,     0,
    1524,  2014,  2020,     0,  1538,  1539,     0,  1737,  1762,  1784,
    1847,  1849,     0,  1867,     0,   573,   593,   568,     0,     0,
     841,   834,     0,     0,   857,   518,  1530,     0,   680,   677,
     676,   675,   217,   183,     0,     0,   595,  1846,   751,     0,
       0,  1168,  1169,  1059,  1046,  1274,     0,     0,  1054,  1053,
       0,     0,     0,     0,     0,  1030,  1029,  1028,  1167,  1235,
       0,  1027,     0,     0,     0,     0,  1060,  1060,  1058,  1104,
       0,     0,  1031,     0,     0,  1254,     0,  1260,     0,     0,
       0,  1066,     0,  1064,     0,     0,  1140,  1162,  1088,  1089,
    1653,  1166,  1232,     0,  1315,     0,     0,  1052,     0,  1084,
       0,     0,     0,     0,  1287,  1230,     0,     0,  1117,  1228,
       0,  1119,     0,     0,     0,  1222,  1221,  1219,  1220,  1213,
    1214,  1215,  1218,  1216,  1217,  1226,  1101,     0,     0,  1100,
    1522,     0,   947,   893,  1277,     0,     0,  2021,  2023,  1573,
    1572,  1571,  1570,  1546,     0,  1542,  1543,     0,  1574,  1575,
     223,   224,   220,     0,   181,   180,     0,   203,   204,   175,
       0,   199,   200,   185,   196,   198,   197,   195,   173,   184,
     186,   192,   193,   194,   174,   213,   211,     0,   509,  1484,
       0,   985,     0,   947,   859,   861,   862,     0,  1284,   810,
    1292,     0,     0,   814,   886,   891,   885,   890,   913,   914,
     919,   889,     0,   943,   943,   928,   922,   927,   923,   929,
     936,   884,   925,   883,     0,   939,     0,  1492,  1401,  1490,
     998,  1484,  1423,  1484,  1479,  1409,  1078,  1079,  1080,  1081,
    1083,  1082,  1410,  1407,  1077,  1408,  1347,  1346,     0,     0,
       0,     0,  1430,  1379,     0,  1360,  1385,  2033,  2039,  2037,
       0,     0,   998,  2017,  1590,  2017,   998,     0,     0,   472,
       0,     0,     0,     0,     0,   507,     0,     0,     0,   791,
     790,     0,     0,     0,     0,     0,   802,   336,     0,   259,
       0,     0,     0,     0,     0,     0,     0,     0,   644,   645,
     654,   653,   651,   623,   625,   624,   615,     0,   616,     0,
       0,   622,   632,  1662,  1021,   629,  1663,  1660,  1659,     0,
       0,     0,     0,     0,     0,     0,   257,     0,   256,     0,
       0,     0,     0,     0,   662,   667,   143,     0,     0,   127,
     129,     0,     0,   125,   131,   128,   130,   126,   132,   124,
       0,     0,   123,     0,     0,     0,     0,   142,     0,     0,
       0,     0,   387,   398,     0,     0,     0,     0,   118,   118,
     384,   696,   238,     0,     0,     0,     0,     0,     0,     0,
     249,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   146,   145,     0,     0,   191,   758,   762,
    1280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   287,   269,   268,     0,   274,     0,   475,
    1654,   454,     0,   998,     0,     0,     0,   992,  1073,  1072,
    1071,     0,  1013,  1015,     0,     0,   789,   789,   789,   789,
     789,   773,   775,   311,   152,     0,     0,   461,   464,     0,
     116,   163,   301,     0,   162,   164,   166,   167,   168,   165,
     169,   414,     0,   426,   425,   427,     0,   422,     0,   141,
     382,     0,   303,   366,     0,     0,   399,     0,     0,     0,
       0,   714,     0,  1377,     0,     0,     0,     0,   873,     0,
     957,   843,   949,   959,   950,   952,   986,  1302,     0,   841,
       0,   658,     0,   797,     0,   656,   157,  1305,     0,     0,
       0,     0,   491,   149,     0,   262,   417,     0,   262,   151,
       0,   409,   262,   504,  1505,  1506,   869,   510,     0,     0,
    2019,  1332,     0,  1333,     0,     0,   577,   576,   587,     0,
     578,   579,   575,   574,   580,     0,     0,   595,   836,     0,
     838,  1284,     0,   833,     0,   854,     0,   852,     0,  1301,
     856,   845,     0,     0,   566,     0,     0,   262,   750,  1232,
       0,     0,     0,  1238,     0,     0,  1273,  1270,     0,     0,
    1232,     0,     0,     0,     0,  1245,  1246,  1247,  1244,  1248,
    1243,     0,     0,  1249,  1242,     0,     0,     0,     0,     0,
    1057,  1056,     0,     0,     0,     0,     0,     0,     0,  1141,
    1170,     0,     0,  1206,     0,  1232,  1259,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1232,  1265,     0,
    1285,  1284,     0,     0,     0,     0,  1316,  1086,  1102,  1295,
       0,  1286,     0,     0,  1109,     0,  1266,  1136,     0,  1124,
       0,  1118,     0,  1122,  1126,  1105,  1287,  1231,     0,  1229,
       0,     0,  1103,     0,  1098,  1096,  1097,  1090,  1091,  1092,
    1093,  1094,  1095,  1099,  1210,  1208,  1209,     0,     0,     0,
    1121,  1619,  1763,  1790,     0,   904,   904,   892,   902,  1293,
       0,   988,     0,     0,     0,  1171,     0,  2025,  2024,     0,
       0,     0,     0,     0,  1084,     0,   212,   998,   982,   866,
       0,     0,   988,     0,   865,   812,   811,  1291,     0,     0,
     917,   918,     0,   935,     0,   857,   857,     0,     0,     0,
    1399,  1486,  1433,  1454,  1424,  1457,  1404,  1446,     0,  1428,
    1381,  1520,  1527,  1580,     0,  2018,     0,     0,   471,   470,
       0,     0,     0,     0,   705,   683,   508,   706,   684,     0,
     793,     0,     0,     0,     0,     0,   262,   800,   258,   801,
     699,   707,     0,   642,   643,     0,   626,   614,     0,     0,
     621,     0,   620,  1015,     0,     0,     0,   686,   153,   254,
     691,   255,   253,   687,     0,  1308,     0,     0,     0,   137,
       0,     0,     0,     0,   120,   119,   138,   136,     0,   135,
       0,   711,   689,   701,   386,   397,     0,   390,   391,   388,
     392,   393,     0,     0,     0,   230,     0,     0,   241,   247,
     248,   246,   262,   262,   244,   245,   243,   250,   690,     0,
     702,   242,   240,     0,   229,   713,   695,     0,   712,   703,
     694,   189,   188,   190,     0,     0,     0,     0,     0,     0,
       0,   560,   542,   559,     0,     0,     0,   536,   290,   267,
     474,     0,     0,     0,     0,   993,     0,     0,   998,     0,
       0,  1006,   999,  1007,     0,     0,     0,     0,   789,   788,
       0,     0,     0,     0,     0,   776,   798,     0,   460,     0,
       0,   342,   158,     0,     0,   413,     0,     0,     0,   989,
       0,     0,     0,     0,   302,   304,   306,   307,   308,     0,
     380,   381,     0,     0,   370,     0,   344,   345,     0,     0,
       0,     0,   601,     0,     0,     0,   650,   648,   634,     0,
    1375,  1369,   875,   876,     0,   886,     0,   959,     0,   958,
     970,     0,     0,   976,   974,     0,   976,     0,   976,     0,
     951,     0,   953,   970,  1303,   987,   842,   262,     0,   262,
       0,   262,     0,   262,     0,   735,     0,   450,   262,   493,
       0,  1521,  2015,  1547,  1548,     0,  1540,  1541,     0,   589,
       0,   586,   581,   583,     0,   590,     0,     0,   839,   840,
     855,   848,   850,   849,     0,     0,   846,   492,     0,   262,
       0,   591,   908,     0,  1240,  1241,     0,     0,     0,     0,
    1269,     0,     0,  1202,     0,  1200,  1178,  1180,  1039,     0,
    1190,     0,  1033,  1203,  1204,  1182,  1184,     0,  1036,     0,
    1223,     0,     0,  1191,  1143,     0,     0,     0,     0,  1222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1155,
    1154,  1192,  1205,     0,     0,  1257,  1258,  1193,  1068,  1069,
    1070,  1070,     0,     0,  1264,     0,     0,     0,  1198,  1163,
    1233,  1061,  1062,     0,     0,     0,     0,     0,     0,     0,
       0,  1125,  1120,     0,  1123,  1127,     0,     0,     0,     0,
    1111,  1137,  1107,     0,     0,  1113,     0,  1138,   904,   904,
     904,   904,   901,     0,     0,   946,   931,     0,     0,  1175,
    1172,  1555,  1556,  1557,  1558,  1559,  1560,  1561,  1562,  1563,
    1564,  1566,  1567,  1568,  1565,  1569,  1551,  1552,     0,  1544,
    1545,   177,     0,   201,   187,  1580,     0,     0,   860,   841,
     863,   823,   915,     0,  1224,   916,   942,   941,   940,   920,
     924,   921,     0,  1488,  1414,  1579,  1582,  1593,  1591,  1426,
     473,   704,   682,   698,   789,     0,   335,     0,     0,     0,
     803,   636,     0,   617,   618,   619,     0,   708,   685,   700,
       0,     0,   664,     0,   665,   663,   133,   121,   140,   139,
     122,   134,   389,   394,   396,   395,   311,     0,     0,     0,
     231,   239,   236,     0,     0,  1281,   537,     0,   538,   544,
       0,     0,     0,     0,   546,   291,   118,     0,   275,   279,
     805,   805,     0,   280,   805,   276,   805,   273,   476,     0,
    1814,  1214,   477,   465,   468,   469,   466,   467,   445,     0,
       0,     0,   996,     0,     0,     0,     0,     0,     0,   998,
    1084,     0,     0,   784,  1341,  1342,   783,  1343,   780,   779,
     787,   786,   778,   777,   782,   781,     0,     0,     0,   322,
       0,     0,   316,     0,     0,   650,   310,   313,   314,     0,
     462,   463,     0,   301,     0,   429,   423,   459,     0,   991,
     303,   328,   362,     0,   377,     0,   364,   363,   365,     0,
     372,   341,     0,   771,   406,   403,     0,   601,     0,     0,
     646,   627,   647,     0,     0,   630,     0,   635,   611,     0,
    1391,   868,  1392,   961,   968,     0,   948,     0,   975,   971,
       0,   972,     0,     0,   973,     0,     0,   968,     0,   659,
       0,   657,     0,   489,     0,   660,   262,   262,   410,   874,
       0,     0,   588,   584,     0,     0,   561,   592,   835,   837,
     853,   851,     0,   562,   594,  1233,  1239,  1045,     0,  1272,
    1268,     0,     0,     0,  1234,     0,     0,  1252,  1251,  1142,
    1253,     0,     0,     0,  1153,  1152,  1150,  1151,  1144,  1145,
    1146,  1147,  1148,  1149,  1262,  1261,  1255,  1256,  1065,  1063,
       0,  1195,  1196,  1197,  1263,  1207,  1051,  1084,  1087,     0,
       0,  1110,  1267,  1128,     0,     0,  1237,     0,  1106,     0,
       0,     0,     0,  1115,  1223,     0,     0,     0,     0,     0,
       0,   896,   895,     0,   933,  1173,  1174,     0,     0,     0,
    1578,     0,   867,   858,     0,  1432,     0,  1487,     0,   337,
       0,     0,   650,   637,   633,     0,     0,     0,   309,     0,
       0,     0,     0,   264,   692,   693,     0,     0,     0,   541,
     540,   274,     0,     0,     0,     0,     0,     0,     0,   447,
       0,     0,   452,   441,   443,     0,     0,     0,   994,  1000,
    1001,  1002,  1003,  1004,  1005,   997,  1014,   439,   785,     0,
       0,   320,   324,   325,   323,   315,   650,   342,   374,     0,
       0,     0,   431,     0,     0,   990,     0,   326,     0,   366,
     305,   379,   381,     0,     0,     0,   343,     0,     0,     0,
     766,     0,   408,   404,     0,     0,   600,     0,     0,  1021,
     650,   649,   730,   731,   728,   729,     0,     0,  1365,   960,
       0,     0,   962,     0,     0,   964,   966,     0,     0,     0,
       0,     0,  1306,   262,   262,   262,   736,   451,     0,  1549,
    1550,     0,   582,     0,  1271,  1189,  1199,  1038,  1201,  1035,
    1250,     0,     0,     0,     0,  1194,  1317,  1134,  1132,  1129,
       0,  1130,     0,     0,     0,  1112,  1108,     0,  1114,  1139,
     900,   899,   898,   897,     0,     0,   887,  1553,     0,  1334,
    1338,  1335,  1554,  1084,   864,     0,  1489,   795,     0,   650,
     374,   710,   688,   709,   232,   233,   234,   235,     0,   237,
       0,   543,   539,   266,   289,   277,   282,     0,   283,   278,
     281,   449,   448,   446,   442,   444,   995,     0,   671,     0,
     445,     0,     0,   312,   374,   348,     0,   317,     0,   771,
     303,   430,     0,     0,   424,   366,     0,     0,   327,     0,
     370,     0,   367,     0,   371,   375,     0,     0,   768,   405,
       0,   400,     0,     0,     0,     0,   602,   609,   609,   628,
    1015,   610,     0,  1390,     0,   969,   978,     0,   965,   963,
     954,     0,   956,   672,   490,   661,     0,   585,   262,  1156,
       0,     0,     0,  1131,  1236,  1135,  1133,  1116,   930,   932,
    1337,  1336,   202,  1225,     0,   374,   338,   263,   545,   284,
     671,     0,   669,   440,     0,   319,   318,     0,   353,     0,
       0,   767,   432,   433,   428,     0,   370,   332,   330,   334,
     331,   329,   333,     0,   372,   368,   369,     0,   769,   770,
     407,   806,     0,     0,   650,     0,     0,   607,   605,   604,
       0,   988,   967,     0,   955,   563,  1157,     0,  1158,   342,
     339,   668,   670,     0,   346,   347,     0,   321,   349,   350,
       0,     0,     0,   372,   361,   293,   376,   650,   609,   372,
     603,   608,   631,     0,   977,  1159,   348,     0,     0,     0,
       0,   351,     0,   352,   373,     0,     0,     0,   478,   479,
     436,   294,   372,   606,   988,   734,   353,     0,   358,     0,
     357,     0,   354,   355,     0,     0,   484,     0,     0,   434,
     437,   438,   988,   596,   733,   732,     0,   445,     0,   356,
     359,   360,     0,   488,   480,   418,     0,   597,   716,   727,
     715,   717,   725,   722,   724,   723,   721,   340,     0,   483,
     487,     0,   481,   435,     0,   726,   720,   886,   877,     0,
       0,   718,   727,   436,   488,   719,     0,   482,   419
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    70,   233,   234,   235,  1436,  1997,   236,
     237,   238,   239,   240,   241,   242,   243,  1458,   244,   245,
    1111,  1576,  2094,   246,   915,   916,  1818,  1819,  2038,  1820,
    1821,  1809,  1320,  1322,   247,   248,   249,  1315,  1802,   250,
     251,  1486,  1487,  1463,  1488,  1441,  1635,  3279,   252,   253,
    2056,  1524,  2509,  2877,   761,  1521,  2866,  2867,   254,  1573,
    2553,  2554,  2555,  2556,  2536,  2926,  2927,  2928,  2557,  3167,
    3318,  2558,  1927,  2115,  2565,  2566,  3388,  3437,  3438,  3439,
    3482,  3169,  2564,  2950,  3175,  3307,   255,  3407,  2113,  2559,
    2560,   256,   257,  1475,  2010,  2456,   258,   786,  2954,  3182,
    3331,   259,   827,   260,  1578,   261,   262,  1581,  2106,  2107,
    3163,  3312,  3394,  3488,  3489,  3300,  3132,  3133,  3134,   263,
     264,   265,   266,  1968,  2086,  2087,  2882,  1427,  1908,  1528,
    2058,  2059,   267,  3468,  3469,   787,  3522,   268,   269,   270,
     271,   828,  1163,  3417,  1431,   272,   273,   846,   847,   274,
    1092,  2502,   275,   276,   858,  2204,   860,  1664,  2631,  2632,
    3006,  2177,  1032,   277,   278,  2187,  2207,   279,   788,  2959,
    3335,  3336,  3418,   280,   789,  1454,  1947,  1948,  1949,  2960,
    1950,  2964,  1951,  2576,  2577,  2578,  2968,   281,  1452,  1942,
     282,   283,   284,  1973,  1048,   285,  3382,   286,  1139,   287,
     879,  1679,   288,  2013,   289,   290,   291,  2579,  3510,  3524,
    3525,  3526,  3196,  3496,   292,  3512,   294,   295,   296,   748,
    1064,  1065,  1066,   297,  3180,   298,   299,  2081,  2082,  2530,
     300,   301,  1920,  2400,   302,   303,   304,  1568,   305,   306,
     307,   308,   309,   942,   933,  1346,  1843,   310,  1640,   833,
    3513,  1670,  2189,  2190,  2193,  3514,  1607,   313,  1674,  2198,
    2201,  3515,  1833,  1834,  1835,  1836,  1837,  2350,   315,  1133,
    2127,  3516,  1268,   318,   319,   320,  1782,  2327,   868,  1356,
     904,   947,   948,  1848,  1849,  1363,  1863,  1856,  1858,  3084,
    3256,  1364,  1861,  1365,  1366,  2365,   321,  2331,  2131,  2132,
    2133,  2589,  2599,  2979,  3205,  2134,   930,  2135,  2139,  2548,
    2549,  1952,  2067,  2520,  1549,  1269,  1270,  1271,  1711,  1722,
    1705,  1552,  1272,  1273,  1274,  1555,  1275,  1276,  1277,  1278,
    1694,  1747,  1279,  1280,  1731,   971,  2209,  2248,  1282,  1283,
    1284,  2317,  1775,  1050,  1285,  2884,  1777,  2268,  2231,  3067,
    2212,  1692,  2232,  2246,  2682,  2252,  2257,  2705,  2706,  2269,
    2287,  1286,  2216,  2217,  2661,  1696,  1287,  1069,  1070,  1737,
    2283,  1349,  1350,   935,  1288,  1289,  1290,  1665,   931,  3201,
    1146,   614,  2434,  1506,   754,   865,  1291,  1292,  1293,  1294,
    1295,  1296,  1297,   850,   851,  2172,  3262,  2503,  2906,  1410,
    1822,  1298,   592,   755,   322,   792,   793,   794,  1126,  1127,
    1596,  1599,  1393,  1895,   593,   594,   615,  3198,   323,   324,
     325,   326,   327,  1368,   953,  1387,  1889,   972,    74,    79,
      75,   973,   365,   366,  1871,   328,   725,  1872,  1390,   979,
    2803,   369,   330,   331,   370,   333,   702,   371,   955,   335,
     956,   336,   337,   338,   339,   963,   340,  1370,  1371,  3097,
    1372,   341,   342,   616,   617,   343,  1168,  1636,  1167,   801,
     344,   345,  1000,  1001,  1002,  1181,  1649,  1182,  1413,  1414,
     346,   347,   610,   348,   349,   350,  1654,  1655,   351,  1795,
    1796,  1797,   352,  2623,  2624,   353,  2776,  2777,  2778,   354,
    1791,   355,   356,   924,  2806,   357,   721,   358,  1014,   595,
     596,   597,  1300,   705,   890,   864,  1301,  1021,   706,   360,
     708,   599,   600,   601,   602,   603,   604,  1024,   712,  1650,
      76,  2384,  1651,  1304,  1305,  1787,  1306,   607,   983,   993,
     994,  2385,   996,    77,   997
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3072
static const int yypact[] =
{
   -3072,   303, 13897, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, 16678, -3072, -3072, 36276,
     300, -3072, -3072, -3072, 33742, -3072, -3072, -3072, -3072, -3072,
     210, 38378, 15428, -3072, 53475, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, 53475, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, 37119,   586, -3072, -3072,   219,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072,   260,  3517, -3072,
   -3072, 39218, -3072,   175, -3072, -3072, -3072, -3072, -3072, -3072,
   53475, 48866, -3072,    50,   326, -3072,    71,  9054, -3072, 35017,
   39638, -3072, -3072, 53894,   407,  5417,   260, 40058, -3072,  1479,
   -3072, 32038, -3072, -3072, -3072,   620, 46352, -3072, -3072, -3072,
   -3072,   459, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   48866,   893,   289, 32465, -3072, -3072, -3072, -3072, 48866, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, 40478, -3072,
     493,   480, 54313, 54732, 45933, -3072,   689, -3072, 53475,   615,
   35864, -3072, 55151, -3072, -3072,   456, -3072, -3072, -3072, -3072,
   -3072,   289, -3072, 37119, 30751, 47190,   661,   436, -3072, -3072,
   -3072, -3072,   501, 17003,   492, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,   572,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072,  1719, -3072,   453,
    2001,   583, -3072, -3072, -3072, -3072, -3072, -3072, -3072, 62251,
     697, -3072, -3072, -3072,   603, -3072,   675, -3072, -3072, -3072,
    1142, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
      61, -3072, -3072, -3072, -3072,  1124, 36697, -3072, -3072, 62251,
   -3072,   662, 40898, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, 34167, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072,   137, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, 53475,
   53475, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, 14428, -3072, -3072, -3072,   745, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072,   843, -3072,   203,  1033, -3072,
   -3072, 37119,  1538,  1538,  1271, 62251, -3072, -3072, -3072, 44257,
   53475, 53475, 53475, 44257, 53475, 47190, 53475, 29034, 53475, 53475,
   47190, 47190, 53475, 53475, 53475, 53475, -3072,  1286,    38, -3072,
   -3072, -3072,   847, -3072,  1076, -3072,  1117,  1249,   893, -3072,
   -3072, 48866,   998, 44257, 53475,   973,  1053, 53475, -3072, 53475,
    1088, 53475,  1145,  1825,  1176, 53475, 53475, 53475, -3072, -3072,
   53475, -3072, 53475, -3072, 53475,   772,  1161,  1345,  1268,    53,
   -3072, -3072, -3072,  1092,  1069, -3072,  1113, 40898, 40898, -3072,
   -3072, -3072,   915, -3072, 47190, 44676, 53475,  1323, -3072, 55570,
   -3072, 45095, 55989, -3072,  1976,  1433, -3072, 56408, 56827, -3072,
   -3072, -3072, 57246, 57665, -3072, 58084, -3072,  1317, 58503, -3072,
    1152, -3072, -3072,   572,  1112, -3072,   251,    40,   256, -3072,
   -3072,   123,   152,   174,  1112,   659, 49285, 53475,  1330, -3072,
   -3072, -3072, -3072, 40898,  1265, -3072, -3072, -3072,  1279,   -85,
   -3072, -3072, 48866, -3072, -3072, -3072, -3072, -3072, 48866,   593,
   -3072, -3072,   893,  1412,  1502, 53475, -3072, 53475, -3072, 48866,
   53475, -3072, -3072, -3072,  1527,  1244,  1419, -3072,  1221, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072,  1382,  1417,     7,   893,
    1322, -3072, -3072,  1431, 19576,   -87, 40898, 32892, 47609, 61436,
      51, 35017, 58922,  1316,    38, -3072,   752, -3072,  1648,  1341,
    1525,    66,    38, 48866, 62654, -3072, -3072, -3072, 26487, 59341,
    1434,  1329, -3072,  1596, 20019, -3072,  1347,  1356,   260,  1362,
   -3072, -3072, 48866,  1730,  1730,  1713,  1730,   786,   790,   436,
   -3072, -3072, -3072,  1386, -3072,  1409,  1453, -3072,   207,  1609,
   -3072, -3072, -3072, -3072,  1549,  1554,  1572,  1575, -3072,  1583,
    1199, -3072, -3072, -3072,  1731, -3072, -3072, -3072, -3072,  1386,
   -3072, -3072, -3072, -3072, -3072,  1820,  1808, 35017, 35017,  1567,
     -10, 14509, 14428, -3072, 14985,   867, -3072, -3072, -3072,   211,
   -3072, -3072, -3072,  1709, -3072, -3072,  1757, 53475, -3072,  1647,
   53475, -3072, -3072, 59760, -3072, -3072,  1538,  1386,   847,  1599,
    1615, -3072,  1619,  1626, -3072,  1654,   885,  1653,   571,   130,
    1801,   -48,   585,  1662,   237,   833,  1794, 53475, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,  1680, -3072,
   -3072,  1682,   -59,   924,  1783,   -78,  2585,   926,  1844,   777,
     537,  1688,  1892,   341, -3072,   122, -3072, 22202, 29911, -3072,
     847, 48866, 44257,  1693, -3072, -3072, -3072, -3072, 44257, -3072,
    1855,  2162, -3072, 53475, -3072, -3072, -3072, -3072, 53475, -3072,
   -3072,  1905, 53475, -3072,  1735,  1105,  1703,  2032, 42999, 53475,
    1741,  2068, -3072, -3072,  1750, -3072, -3072, 53475,  1718,   869,
    1750,  2075,  2076,  1863,  1234,    91,  1750, 48866, 48866, 48866,
    1935, 53475, 60179, 44257, 53475, 35442, -3072,  1723,  1092, -3072,
   -3072, -3072, -3072,   116,  1782,  2000,  1599, -3072,  2002,  1740,
    2006, -3072,  2007,  1662,  2010,  1747, -3072, 60598,  2011,  1748,
   53475,  2019,  1747,  2022,  1914,  2023, -3072,  2026,  1920,  2031,
    1747,   502,  2034,    65, -3072, -3072, -3072, -3072,    -5,  1148,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, 53475,  1330,  1330,
     141, -3072, -3072,   119, -3072, 48028, 53475, 48447,    70,   120,
   -3072, 53475, -3072,  1152, 53475,  2024,  2024,  2024, -3072, -3072,
   -3072,  1968, 53475,  2027, 48028, 53475, -3072, 61017,  1772,  1207,
     940,  1144, -3072, 22202,  1775,   511,   511,  1779,  1786, -3072,
   -3072,  1787,  1788, -3072,  1206,  1206,  1921,  1796,  1797, -3072,
    1398,  1800, -3072,  1000,  1460,  1802,  1804,  1805,  1471,   511,
   22202, -3072,  1806,  1514,  1807,  1809,  1811,  1032,  1823, -3072,
    1067,  1824,  1304,  1441,  1829,  1838, -3072,  1796, -3072,   312,
   -3072, -3072, -3072, -3072, 22202, 22202, -3072, 20454, -3072,   893,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,    69, -3072,
    1532,  7175, -3072, -3072,  1971, 22202, -3072, -3072,    72, -3072,
     847,  1840, -3072, -3072, -3072, -3072, -3072, -3072, -3072,  1550,
   -3072, -3072,  1593,  1638, -3072, -3072,   118,  1666,   938,   938,
     944, 39218, 39218, -3072, -3072,   761,  1832,  1208, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, 34592,  2196, -3072,  1255,   122,
   31170, 31170,  1330,  1330,  2045, -3072, -3072,    73,  2058, 48866,
   -3072, 53475, -3072, 27751, -3072, -3072,   572, -3072,  8677, -3072,
     918, -3072, -3072, -3072,  1847, -3072,   501,   501, 22202,   501,
      -9, 20889, 22202,  2104,    49,  2105, -3072, -3072,  1386,  1860,
     901, -3072, 43838, 61848, 61848,  2072, -3072, -3072,   602,    46,
    1957,  2040,    22,  1258, -3072, -3072, -3072,  1851, -3072,  2150,
    1386,   936, 39218,  1909, 35017, -3072, -3072,  2271, -3072,  2271,
   -3072, -3072, -3072, 14913,  1298, -3072, -3072, 14428, -3072, -3072,
   -3072, -3072,  2312, -3072,  1876, -3072, -3072, 62251,  1886, 53475,
   -3072,  1887,  1888, -3072, 62654,   847, 30332,   -12,  1950,  1956,
   37119,  1889,  1959,  1961, 61436, -3072, -3072, -3072,   279,   730,
     423, -3072,  1963,  2057,  2012, -3072,  2073,   429, -3072, -3072,
   -3072, -3072,  1393, 18293,   787, -3072, -3072,  1979,  1962,  1982,
    1986,  1718,   320,  1915, -3072,  1987,  1970, 41739, 29472, 61436,
    2903, -3072,  1991,  1995,  2038,  1784,   127,  2257,  2092,  2008,
    1307,  2013, 48866,  2166,    90,   582,  1933, -3072, -3072,  2014,
    2015, 47190,  2016,  2049,  2020, 61436,  2903, -3072, -3072,   829,
   -3072, -3072,    38, -3072,  3064, -3072, -3072, -3072, -3072, -3072,
    1599, 42999,  1662,  1199, 53475,  1955,    79,  2110, 53475,  2169,
    2114,   142, -3072, -3072,  1750, -3072, 30332,  1718, -3072,  1960,
   -3072,  2003,  2003,  2003,  1973,  1973,  1975, -3072, -3072,  1471,
    2003,  1977, -3072, 43419, -3072,   743,   794, -3072,  2315,    97,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,    98,
   -3072,  1653, -3072, -3072, -3072,  2323,   682, -3072, 42999,  2903,
    2268, 37119, -3072,  2021,  2903, 53475,   900, 53475,  2175, -3072,
   -3072,   106,  1985, -3072,  2903, -3072,   311,  1989, 35017,  2242,
   53475,  2141, -3072,  1662,  2344, -3072, -3072,  1990,   659, -3072,
    1723, -3072,  1229, -3072,  2096, -3072, 24781,  2030, 44257,   121,
   -3072, 42999, 53475, 44257,   121, 53475, 53475,  2259,  2047, 29472,
   41739,    81, 53475, 53475, 48866, 53475, 53475, 48866, 53475,  2265,
     121, 53475, -3072, -3072, 53475, -3072, -3072,  1330,   843, 53475,
   -3072, -3072, -3072, -3072, -3072, -3072,  1330, -3072, -3072,  2432,
    1996, -3072,   118,   659,  1998, -3072,  2029, 53475, 44257, 53475,
   53475, 48866, 48866, 53475,  2074,  1832,  -100, -3072,  2053, 27332,
    2127, -3072,   131, 48866,  2183, -3072, -3072,   -79, -3072, -3072,
   -3072, -3072, -3072, -3072, 46352,  2281,    32, 53475, -3072, 22202,
   21324, -3072, -3072, -3072,  2035,  8677,  2069, 22202, -3072, -3072,
   22202, 22202,   659,   659,   659, -3072, -3072, -3072, -3072,  2313,
     659, -3072, 22202, 22202,   659,   659,  2003,  2003, -3072,  3394,
   22202,   659, -3072, 29472, 22202, 22637, 17849, 22202,  2102,  2106,
     659, -3072,   659, -3072, 22202, 19141, -3072,   847,  2407,  2407,
     436,  1424,  4578,  2036, -3072,  2134,   659, -3072,   659,   782,
   42999, 22202, 37119,  2108,    93, 22202,  2041,  1215, -3072, 22202,
     112, -3072,  2042, 22202,  2116,   153, 22202, 22202, 22202, 22202,
   22202, 22202, 22202, 22202, 22202, -3072, 23072,   195,   -61,   144,
   38798, 19576,  2302, -3072,   974, 17405, 40898, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072,   659,  2046, -3072,  2065, -3072, -3072,
   -3072, -3072, -3072,  2196, -3072, -3072,  2118, -3072, -3072, -3072,
    1667, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,  2052,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072,  1330, -3072, 62251,
    2055, -3072, 53475,    10, -3072, -3072, -3072,  2078, -3072, 46771,
   -3072, 20019, 53475, -3072, -3072,  2282, -3072, -3072,  2067, -3072,
    6847,  2282,  2229,  2236,  2236, -3072,   -45,  8677,  2276,  8677,
   -3072, -3072, -3072, -3072,   285, -3072,  1018, -3072, -3072,  1386,
    2081, 15840, -3072, 16259, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,  1199,  2079,
    2495,  1056, -3072, -3072, 35017, -3072, -3072, -3072, -3072, -3072,
   40898,  1738,  2081, 14428, -3072, 14428,  2081,  2087,   943, -3072,
    2155,  2156,  2202, 53475, 53475, -3072, 37119, 53475, 53475, -3072,
    2411,  2099, 53475,  2308,  2310,  2103, -3072, -3072, 53475, -3072,
    2267, 22202,  2269, 53475, 53475,  2270,   622,  2262, -3072, -3072,
   -3072, -3072, -3072,  2260, -3072, -3072, -3072,  1007, -3072, 37959,
   41319, -3072, -3072,   332,  1653, -3072,   339,   346,   432,  2177,
    2179,  2219, 53475, 53475, 53475, 53475, -3072, 53475, -3072,   789,
   53475, 53475,  2111,  2119,  2115, -3072, -3072, 53475,  2317, -3072,
   -3072,  2258,   384, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
     566, 53475, -3072,   659,  2264, 53475,  2180, -3072, 53475, 53475,
   53475,  1199, -3072,  2463,  1199,  1199,   669,  2469,  1750,  1750,
   -3072, -3072, -3072, 53475, 53475, 53475, 49704, 53475, 53475, 50123,
   -3072, 48866, 53475, 53475, 53475,   160,  2620, 53475, 53475,  2252,
   53475, 53475, 53475, -3072, -3072,    74,  2261, -3072, -3072, -3072,
   -3072, 22202,  2346,  2501,  2360,  2364,  2206, 41739,   839, 53475,
   53475,  2373,   839, -3072, -3072, -3072,  1105, -3072,  1086, -3072,
    2176, -3072, 22202,   104, 42999,  2167, 25619, -3072,  2232, -3072,
    2233,   659, -3072,  1889,   106,  2366,  2182,  2182,  2182,  2182,
    2182,   682, -3072, -3072, -3072,  2427,  1099, -3072,  2185, 48866,
   -3072, -3072,  1852, 46352, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072,   977, -3072, -3072, -3072,  2328,  2329, 53475, -3072,
    1784, 48866, 45514,  1262, 53475,  2532,  2423,   893,  2338, 48866,
    1652, -3072, 35442, -3072,  2191,  2425,  2426,  2444, -3072, 24362,
   50542,  2184,  1157, -3072, 50542, 50961, -3072,   847, 22202,  2127,
    1599, -3072,  2543, -3072,  1662, -3072,  1747, -3072, 53475, 53475,
    2190,  2192, -3072,  1747,  2349,   121, -3072,  2350,   121,  1747,
     893, -3072,    65, -3072, -3072, -3072, -3072, -3072, 40898,  1113,
   -3072, -3072,  1113, -3072,  1113,  2628,  1747,  2193, -3072,  1662,
    1747,  1747,  1832,  1832,  1747, 51380,  2562,  2443, -3072,  1108,
   -3072, -3072, 19576, -3072,    68, -3072,   171,   -30,  2386, -3072,
   -3072, -3072, 53475,  2358,  2198, 51380,  2545,   121, -3072,  8677,
    1139,   876,   963, -3072,   659, 22202,    39, -3072,  7270,  1151,
    7543,  1181,  2207,  2213,  1239, -3072, -3072, -3072, -3072, -3072,
   -3072,  2215,  2474, -3072, -3072,  2226,  1267,  1284,  2228,  2230,
   -3072, -3072,  4643,  1287,  2234,  7726,  2237, 22637,  1913, -3072,
   -3072, 22637,  2238, -3072,  1294,  6913,  2227,  2239,  2263,  2272,
    2240,  2244,  7974, 21767, 22202, 21767, 21767,  8667,  2227,  2247,
   -3072, -3072, 22202, 53475,  2248,  2251, -3072, -3072,  3394, -3072,
    2283, -3072, 22637, 22637,  4014, 20454, -3072, -3072,  2488, -3072,
     692, -3072,  2255, -3072, -3072,  4997,   117, 22202,  2041, 22202,
    2324, 29472,  1875, 22202,  3747,  1884,  1884,   215,   215,   107,
     107,   107,   863,   144, -3072, -3072, -3072,  2273,  1823, 22202,
   -3072,  2693,  1407,  1473, 48866,  4067,  7670, -3072, -3072, -3072,
   24781,  2030, 22202, 22202,  2256, -3072,  1295, -3072, -3072,  1189,
    2628,   659,    38,   659,   782, 31604, -3072,  2081, -3072, -3072,
    1326, 27751,  2030, 20019,   847, -3072, -3072, -3072,  1359, 22202,
   -3072, -3072,  2033, -3072, 53475,  2183,  2183, 22202, 22202, 20889,
   -3072, -3072,  2275, -3072, -3072, -3072, -3072, -3072,  2266, -3072,
   -3072, -3072, -3072,  2678,  2274,  2278,  2277,  2286, -3072, -3072,
   42999, 53475, 53475, 53475, -3072, -3072, -3072, -3072, -3072,  2465,
   -3072, 22202,   126,  2279,  2280, 53475,   121, -3072,  8677, -3072,
   -3072, -3072,  2490, -3072, -3072,  2435, -3072, -3072, 37539, 42999,
   -3072, 42999, -3072,   605, 53475, 53475, 53475, -3072,  1747, -3072,
   -3072, -3072, -3072, -3072,   966, -3072, 42999,  2419, 42159,  1747,
    1112,   977, 53475, 53475, -3072, -3072,  1747, -3072,   977,  1747,
     977, -3072, -3072, -3072, -3072, -3072,  1199, -3072, -3072, -3072,
   -3072, -3072, 53475,  1199,  1199, -3072, 42999,    58, -3072, -3072,
   -3072, -3072,   121,   121, -3072, -3072, -3072, -3072, -3072,  2347,
   -3072, -3072, -3072,   455, -3072, -3072, -3072,  2359, -3072, -3072,
   -3072, -3072, -3072, -3072,  6276,   839, 42999,   839,   839, 53475,
    2291, -3072, -3072, -3072,  2507,  2510,   839, -3072,    62,  2570,
   -3072,   915, 28596,  5011,  2304, -3072,  2305,   659,  2081, 26061,
    1482, -3072, -3072, -3072,   755,  2487,  2306,  2459,  2182, -3072,
     302,   415, 51799, 52218, 52637, -3072,  2385,  2365, -3072, 37119,
   28596,  1989,   900,  2429,   840, -3072, 48866,   106,  1401, -3072,
   42999,  2316, 48866,  2318,  2311, -3072, -3072, -3072, -3072,  1410,
   -3072, 42999,   -19,  2473,  2467,  1413, -3072, -3072,   501, 53475,
    2389, 48866,  2372,   893, 35017, 42579,   889, -3072, -3072,  2480,
   -3072, 53475, -3072, -3072, 26906, 23942,  1157,  2326, 53475, -3072,
    2333, 24781,  2538,  2481, -3072, 24781,  2481,  1218,  2481,  2544,
   -3072, 28170, -3072,  2336,   974,  8677, -3072,   121, 42999,   121,
    2384,   121, 41739,   121, 48866, -3072, 48866, -3072,   121, -3072,
     928, -3072, -3072,  2331, -3072,  2353, -3072, -3072, 44257, -3072,
   53475,   454, -3072, -3072,  2492, -3072,   501, 53475,   847,  2335,
   -3072, -3072, -3072, -3072,  2612,  2613, -3072, -3072, 48028,    82,
   53475, -3072, -3072, 22202, -3072, -3072,  2351,  2354,  8110, 22202,
   -3072,  2621, 42999, -3072, 53475, -3072, -3072, -3072, -3072,   659,
   -3072, 22202, -3072, -3072, -3072, -3072, -3072, 22202, -3072,   659,
   -3072, 22202,  2601, -3072,  2723, 42999, 22637,   524,  1807, 23507,
   22637, 22637, 22637, 22637, 22637, 22637, 22637, 22637, 22637, -3072,
     322, -3072, -3072, 22202, 22202,  2610,  2601, -3072, -3072, -3072,
    1387,  1387, 42999,  2355,  2227,  2356,  2361, 22202, -3072,   847,
    5275, -3072,  2688,   893, 22202,  1178,  2148, 22202,  1420, 22202,
    2614, -3072, -3072,  2367, -3072, -3072, 42999, 22202, 22637, 22637,
    6326, -3072,  6816, 22202,  2368,  7754, 20454, -3072,   289,   289,
     289,   289, -3072, 48866, 48866,  2184,  2604,  1421,  1422, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072,  2363, -3072,  2378, -3072,
   -3072,   122,  2371, -3072, -3072,  2678,  2379, 53475, -3072,  2127,
   -3072, -3072, -3072,  2374, -3072, -3072,  1747, -3072, -3072, -3072,
   -3072, -3072,  2394,  2381, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072,  2182,  5471, -3072, 53475, 53475,  1443,
   -3072, -3072,  2608, -3072, -3072, -3072,  2445, -3072, -3072, -3072,
    2453,  2457, -3072,  2458, -3072, -3072, -3072, -3072,  1747,  1747,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072,   132,   742, 42999,
   -3072, -3072, -3072, 53475, 53475, -3072, -3072,  2395, -3072, -3072,
    2607,  2611,   839,   839, -3072, -3072,  1750,  2681, -3072, -3072,
    2068,  2068,   520, -3072,  2068, -3072,  2068, -3072, -3072,  2176,
    2374,  1258, -3072, -3072, -3072, -3072, -3072, -3072,   747,   659,
    1466,  2401, -3072,  1257, 26061, 26061, 26061, 26061, 26061,  2081,
     782, 48866,   659, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072,  2402, 53475, 22637, -3072,
     802,   488, -3072,  2618, 48866,  2438, -3072, -3072, -3072, 42999,
   -3072, -3072,  2758,   720, 48866,  2661,  2556, -3072, 53475, -3072,
   45514, -3072,  2637, 45514, -3072, 53475, -3072, -3072, -3072,  2730,
    2486, -3072, 53475,  1607,  2460,  1653,   893,  2372, 53475,  2415,
   -3072,  2410, -3072, 43419,  1923, -3072,  1718, -3072, -3072,    56,
    2442, -3072, -3072, 50542,  2420, 53475,  1157, 24781, -3072, -3072,
     886, -3072, 24781,  2631, -3072, 24781, 53475,  2424, 53475, -3072,
    2430, -3072, 53475, -3072,  2433, -3072,   121,   121, -3072,  1229,
    1113,  1189, -3072, -3072,  2671, 51380, -3072, -3072, -3072, -3072,
   -3072, -3072,  2677, -3072, -3072,  8677, -3072, -3072, 22202,  8677,
   -3072,  2434,  2449,  2450,  8677,  5881,  2451,  8677,  2610, -3072,
    1839,  2684,   481,  2436,   322,  1839,  1224,  1224,   228,   228,
     110,   110,   110,  2723,  8677,  8677, -3072, -3072, -3072, -3072,
    2455, -3072, -3072, -3072,  2227, -3072, -3072,   782,  2407, 22637,
   22637,   431, -3072,   276, 22202, 42999, -3072,  1452,   431,  2388,
    2765, 22202, 22202,  8004,   196, 22202,  5947, 48866, 48866, 48866,
   48866, -3072, -3072,  2768,  2668, -3072, -3072,  1189,  1949,   893,
   -3072,   436, -3072, -3072, 29472, -3072, 14428, -3072,   659, -3072,
    1478,  1489,  2438, -3072, -3072, 53475, 53475, 53475,  2385,  2602,
    2606,   659, 53475,  2504, -3072, -3072,  2666,   839,   839, -3072,
   -3072, -3072,   893,   893,   977,  2622, 53475,   893,   977, -3072,
     950,  2746, -3072,  2686,    99,  2468,  2713,  2715, -3072, -3072,
    1608,  1608, -3072, -3072, -3072, -3072, -3072,  2720, -3072, 22202,
     565,  1839, -3072, -3072, -3072, -3072,  2438,  1989,  2517,  2518,
     501,   331,  2747,  2738,   106, -3072,  2475,   995,  2478,  1262,
   -3072, -3072, -3072,    78, 53475,  2828, -3072,  2802,  2806,  2633,
   -3072, 53475,  2690,  1889,  2731,  2484, -3072, 25200,   893,  1653,
     889, -3072, -3072, -3072, -3072, -3072,  2551, 53475, -3072, -3072,
   53475,  1494, -3072, 22202,  2489, -3072, -3072, 24781,   886,  1501,
   53475,  1529, 42999,   121,   121,   121, -3072, -3072,  2742, -3072,
   -3072,  2639, -3072, 51380,  8677, -3072, -3072, -3072, -3072, -3072,
   -3072, 22637,  2744,  2491, 22637, -3072, -3072,   305,   305,   276,
    1536, -3072, 42999, 22637, 22637,   431,   431, 22202,   431, -3072,
   -3072, -3072, -3072, -3072, 22202, 22202, -3072, -3072,  1258, -3072,
   -3072, -3072, -3072,   782, -3072,  2493, -3072, -3072,  2619,  2438,
    2517, -3072, -3072, -3072, -3072, -3072, -3072, -3072, 22202, -3072,
     839, -3072, -3072,  2570, -3072, -3072, -3072, 53475,  2499, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, 44257,  2850, 48866,
     747,  5975,  2660, -3072,  2517,  2691,  2727, -3072, 53475,  1607,
   45514, -3072,   935,  2629, -3072,  1262,   897,   948, -3072, 48866,
    2467,  2615, -3072,  2623, -3072, -3072,  2658,  2662, -3072, -3072,
     893, -3072, 53475, 25200, 22202,  1540, -3072, 53056, 18713, -3072,
     908, -3072, 48866, -3072,  1552, -3072,  8677, 53475, -3072, -3072,
   -3072,  1556, -3072, -3072, -3072, -3072,   501, -3072,    82,   472,
   22637, 22637,   382, -3072, -3072,   305,   305,   431,  2227,  8677,
   -3072, -3072, -3072, -3072, 48866,  2517, -3072,  8677, -3072,  2499,
    2850,  2863, -3072, -3072,  2769, -3072, -3072,   425,  2672,  2590,
    2873, -3072, -3072, -3072, -3072, 53475,  2467, -3072, -3072, -3072,
   -3072, -3072, -3072,  1560,  2486, -3072, -3072,   501, -3072, -3072,
   -3072, -3072,  1576,  6157,  2438, 25200, 53475, -3072, -3072, -3072,
    2579,  2030, -3072,  1588, -3072, -3072,   472,  1010, -3072,  1989,
   -3072, -3072, -3072,  2798, -3072, -3072,   164, -3072,  2680,  2682,
   53475,    55,  2524,  2486, -3072, -3072, -3072,  2438, 53056,  2486,
   -3072, -3072, -3072,  2808, -3072, -3072,  2691,  2635,    95,    95,
    2580, -3072,  2815, -3072, -3072,   659,   659, 42999,  2525, -3072,
   33314, -3072,  2486, -3072,  2030,   190,  2672,  2799, -3072,  2900,
   -3072,   441, -3072, -3072, 44257, 29472, -3072,    55,  1603, -3072,
   -3072, -3072,  2030, -3072, -3072, -3072,   862,   747,  2665, -3072,
   -3072, -3072,  1662,   329, -3072, -3072, 33314, -3072, -3072,   890,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, 44257, -3072,
   -3072, 41739, -3072, -3072,  1526, -3072, -3072,  1557,  1356,  2536,
    2539, -3072,   890, 33314,  2664, -3072,  1605, -3072, -3072
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3072, -3072, -3072, -3072, -3072,  2751, -3072, -1024,  -180, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072,   898, -3072, -3072,  -759,  1055,  1657, -3072, -3072,   645,
   -3072, -3072, -3072, -1263, -3072,   227, -3072, -3072, -3072, -3072,
   -3072, -3072,   965, -3072,  -923,   527,  -824, -3072, -3072, -3072,
   -3072,   939,  -119, -3072, -3072, -3072, -3072, -3072, -1498,  -134,
      63, -3072,    64,   993,   162, -3072,  -141, -3072, -3072, -3072,
   -3072,  -427,   608, -2426, -2285,    60,  -443,  -461,  -423,  -421,
    -441, -3072, -2610, -3032, -1845, -2478, -3072, -3072, -3072, -3072,
      75, -1483, -3072,  1436, -3072, -3072, -3072, -3072,  -162, -3072,
   -3072, -3072,   -98, -3072, -3072, -3072, -1481, -3072,   949, -2415,
   -3072, -3072, -3072,  -511,  -482, -3072, -3063,  -108,  -106, -3072,
   -3072, -3072, -3072, -1077, -3072,   489,   490, -1000, -3072, -3072,
   -3072,   525, -3072, -3072,  -456,  1467,  -496, -3072, -3072, -3072,
   -3072, -3072,  1408,  -705, -1539, -3072, -3072,  2857,   437, -3072,
   -3072, -1967, -1477, -3072,  -184,   969,  1854, -1152, -2116,    41,
   -3072, -3072, -1615, -3072, -3072, -3072,   857, -1471, -3072,    88,
    -279,  -360, -3071, -3072, -3072, -1136, -3072,   650,  1119, -3072,
    1114, -3072, -1801,   111,  -892, -2452, -2786, -3072, -3072, -3072,
   -3072, -3072, -3072, -1602, -1454, -3072,  -310, -3072, -3072, -3072,
   -3072,   699, -3072,    52, -3072, -3072, -3072, -3072, -3072, -3072,
    -425,  -459, -3072, -3072, -3072,   186, -3072, -3072, -3072,  1146,
   -1050,  -861,  2152, -1469,  -233, -3072, -3072, -3072,   996, -1907,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -1115, -3072, -3072,
   -3072,  1241,  2919,  -712, -3072, -3072, -3072, -3072, -3072, -3072,
      -3, -3072, -3072,   444, -2021,     3, -3072, -3072, -3072, -3072,
    -328,     8, -3072,   731, -3072, -3072, -1719, -3072,  1919,   923,
      92,   -73,   -75,  -227,    80,   477, -3072, -3072,  -219,  1121,
   -3072, -3072, -3072, -3072,   733,  1726, -3072,   724,  -274, -3072,
   -3072,  1732, -3072, -3072,  1733,  1243, -3072,  1266,   771, -2039,
     975, -2008,   505,  -480,  -105,  -144,  2303, -3072, -2227, -2764,
     170,   677, -1768, -2327, -1487, -3072,  2112,  2200, -3072, -3072,
   -1030, -3072, -3072,  2558,  2819, -3072, -3072,  3479,  7373, -3072,
   -1037,   389,  8604,  1264, -1202, -1540, 11185, -2085,   710, -1503,
    -614, -3072,  -716, -3072, 11385,   750, -3072, -1234, -3072,    57,
   -3072, -1581, -3072, -3072, -3072, -3072, -3072, -1496, -2506,  -270,
     816, -3072, -3072,   903, -3072, -3072, -3072, -1029,  -944, -1694,
     821, -1704, -3072,  -940,   929,  1339,  7189,  -860,  3723,  -706,
    8624,  -137, -2074, -1289,  -967, -3072,  -723, -3072,    -2,    28,
   -3072, -3072,  7873,  -698,  -768, -1725, -3072,   -17, -3072,  -938,
    -957, -2566,  -684, -3072, -3072,  2559,   545, -3072,  2005, -3072,
    1006,  1530, -3072, -3072,  1235,  -813,  -133, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072, -3072,
   -3072, -3072, -3072, -3072,  1760,   109, -3072,   -44, -3072, -3072,
   -3072,  3055, -3072,  2805,   -39, -3072,  2431,   -21, -3072, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072,  -827,  1269, -3072,
    2120, -3072, -3072, -3072,   -72, -3072, -3072, -3072,  1946,  -153,
   -3072, -3072, -3072, -1023,  1140,  2151,  -836,  -786,  1246, -3072,
   -3072, -3072, -3072, -3072, -3072, -3072, -3072,   970, -3072, -3072,
     805,   976, -3072, -3072,   149, -3072, -3072,    76,   151, -3072,
    1841, -3072, -3072, -3072,   368, -3072, -3072, -3072,  -522,  9133,
     140,   -69,   -43,   214, -3072,  1034, 10089, -1356,  -695,    36,
    1785,  5965, 10524,   -81,     2,  -102,    54,   -32, -2212, -3072,
    2790,  1253,   990,  -883,  7010,  1509,  2687,  4235,  -739,  -838,
    2174,  -501, -1378, -3072,  3164
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1871
static const short yytable[] =
{
      71,   317,   923,   316,   831,   937,  1019,  1614,  1189,  1367,
    1033,   710,   790,   785,  1975,  1503,   795,   800,  2151,  2072,
     897,  1049,  2073,   703,   800,  1026,  1006,  1029,  1470,  1899,
      72,  1572,  1386,  1743,   710,   368,  1496,   332,  1583,  1059,
    1096,  1508,  1411,  2178,   362,   873,   703,   362,  1316,   704,
    1034,  1733,  1685,  1329,  1052,   334,  2063,  1108,  1130,   746,
     362,  1060,  1805,  1337,  1101,   800,  1170,   591,  1172,  2339,
    1174,   762,   704,   311,  1425,  2611,  1175,  1115,  2095,   312,
    1569,   929,  1136,   362,   314,  2507,  1574,  1104,  1143,  2649,
    2586,  1110,  1584,  2096,   711,  2097,  1527,  1955,  1149,  2098,
    1116,   893,  2372,  2136,  2756,  2099,  1145,  2100,   893,  2213,
     893,  1152,  1464,  2349,  1183,  2932,  1415,   711,  2606,  1160,
    2819,  1169,   892,  1164,  2967,  2789,  2600,  2602,   707,   892,
     361,   892,  2936,   361,  2383,  1335,  1609,  2357,  2387,  3158,
    1451,  1915,   710,  1786,  2354,  1637,   361,  1176,  2420,  2422,
    1318,   707,  1391,  1327,   703,  1591,  1405,   936,   317,   849,
     316,   986,  2684,  1412,   866,  2150,  2700,  1310,  1653,   361,
    2531,  2532,  2533,  2534,  1395,  1396,   760,  1632,  1698,  1699,
     704,   849,  1408,  1750,  1582,  1632,  2685,  1745,   367,  2065,
    2281,   362,  2893,  1632,  1632,  1706,  2514,  2725,  2726,  3046,
     995,  1015,  1718,  1205,  2491,  1753,  2330,  3478,  1319,  2276,
    2194,  1438,  2659,   964,  2281,  2296,   359,  2011,  3192,   359,
    1750,  1601,  3209,  1399,  3211,   711,  -292,  1668,  1180,  2847,
     311,  1003,   359,  1632,  2206,  1375,   312,  3384, -1211,   982,
    3321,   314,  1753,   608, -1211,  2367,  1921,  1921,  2640,  3322,
    2068,  1123,  1408,  3465,  2011,   359, -1307,   894,  3129,   707,
    1922,   722,   293,   723,   894,  1602,   894,  3419,  2103,  2244,
     965,   203,  2946, -1759,  -979,  1062,  3494,   361,  2318,  1503,
    2314, -1227,  1883,  3193,  2481,  1884,  2315, -1227,  3404,  1929,
     950,  1750,  1910,  1469,  1308,  2515,  1186,   362,  1361,  1180,
    2887,  1439,  2202,     3,  2685,  1780,  1879,   965,   951,  2644,
    1852,  2195,  2186,  1753,  2048,  1911,  3270,   372,  1455,  1923,
    1923,   966,   977,  2297,   967,  2116,  3458,  2298,  2887,   716,
     978,   747,  1466,  2104,   362,  1672,  1171,   362,  2054,  1362,
    1912,  1173,  1603,   757,  1733,  1853,  1784,  1309,   951,  1510,
    3466,  2642,  1750,  1435,  1616,  1512, -1786,  1063,   966,  1062,
    2299,  2069,  1344,   359,  3443,  1515,  3479,  1885,  2645,  1187,
    3304,  1811,  2049,  1507,  1753,  1616,  2044,  3473,  3131,  1757,
    1758,  2685,  1638,   361,  1966, -1800,  2319,  1604,  3323,  1854,
    1397,  1880,  1647,  1648,  1124,   999,  1508,  1633,  2685,  1921,
    1593,  1430,  1570,  3194,  3341,  1633,   968, -1823,  1456,  2368,
    2848,  3109,  1922,  1633,  1633,  2423,  1589,   209,  3495,   293,
     361,  3467,  2641,   361, -1656,  2860,  1761,  3480,  1571,   790,
   -1055, -1658,  1004,   795,  3517,   609,  1376,   925, -1655,  1924,
    1924,  1063,  1618,   968,  1621,  2500,  3351,  3481,  2849,  2215,
    2061,  2482,  2039,  1633,  3195,  2210,  2211,  2120,  2685,  2903,
    1605,  1187,  2865,  2282,  2351,  2492,  2219,  2221,  2300,   359,
    2196,  2022,  1923,    49,   227,   976,   589,   969,  2236,  2237,
    1666,    52,  1440,  3375, -1711,  2197,  1616,  2738,  1677, -1761,
   -1759,  1404,  2254,  2256,  1423,  1698,  1699,  2638,   724,  1686,
    2057,  -207,  1783,  1718,  2105,  1706,   359,  1750,   970,   359,
    2042, -1871, -1211,  1828,  2070,  1202,  1746,  1669,   232,  1634,
    1925,  1925,  3230,  2055, -1654,  2643,  1781,  1673,  2856,  1753,
    2858,  2859,  3100,  3101,  1754,  1616,  3005,   987,  1571,  2864,
    2687,  1866,  2066,   589,   589,  2071,  1825,  1826,  2685,  2066,
    1774,  2336,  2976,  2698,  2316, -1227,  2980,  2687,   726,  3320,
    1941,  1412,  3459,  1891,  1457,  1405,   589,  3140,  3141,  3142,
    3143,  3144,  2908, -1786,  1673,  2045,  1502,  2719,   988,  2785,
    1931,  1896,  1769,  1770,  1771,  1772,  1773,  1774,  2442,   727,
    1938,  1035,  1924,  1955,  1028,  1030,  1054,  1056,  3500,  2111,
    2688,  3030, -1800,   804,  3034,  3035,  3036,  3037,  3038,  3039,
    3040,  3041,  3042,  3043,   717,  2165,  2780,  2687,  2824,  2111,
    2825,  2902,  3434,  2118, -1823,   718,  2136,  2396,  3449, -1060,
    1100,   875,   943,    49,  1839,  1500,   589,   853,   758,  1853,
     710,    52,    53,   726,    54,  1131,  1756,  3154,  3232,  2790,
    1383,  3520,   703,  3069,  3070,  1771,  1772,  1773,  1774,  1091,
     929,  3472,   867,  1939,   982,   800,  1757,  1758,  2695,  2696,
    2697,  2698,  1141,  1925,   727,  1919,   589,  2688,   704,  2240,
    2241,   589,    53,  1854,   944,  2916,  1017,    53,  1120,   362,
     845,  3031,   862,   362,  1967,   845,  1443,  1166,   876,    71,
     902, -1711,  1932,   719,   951,  3396, -1761, -1871,  2270,   726,
    1976,  2883,  1629,  1761,  1769,  1770,  1771,  1772,  1773,  1774,
     982,  2443,  2918,   711,    49,  3501,  1762,   589,  2689,    72,
    3435,  3305,    52,    53, -1055,  1507,  2033, -1055,  2967,  2883,
     727,  1093, -1055,  2693,  2694,  2695,  2696,  2697,  2698,  3314,
    2892,   945,  1049,   121,  1875,  1508,  1501,   707,  2112, -1055,
    2693,  2694,  2695,  2696,  2697,  2698,  1933,  1571,  3093,  3233,
    1444,   125,  3155,   982,  2965,   361,  3521, -1656,  3310,   361,
   -1656, -1656,   903,  2413, -1658,  2141, -1656, -1658, -1658,   839,
    2145, -1655,  3376, -1658, -1655, -1655,   874,  2152,  1445,  3125,
   -1655,  2182,  2183,  3032,  2783,  2689,  2161,   893,   840,  2046,
     893,  1876,  3033,  2051,  2075,   720,  2690,  2691,  2692,  2459,
    2693,  2694,  2695,  2696,  2697,  2698,  3386,  2136,   892,  1967,
    3428,   892,   849,  3151,   849,  1313,   849,    49,  3126,   922,
     589,  3288,   849,   849,  3302,    52,   946,  2744,   209,  2922,
    2444,  2164,   877,   878,  1765,  1192,  2414,  2076,   932,  2730,
    2167,   359,  1877,  1928,  1494,   359,  3004,   203,  2025,  1769,
    1770,  1771,  1772,  1773,  1774,  1432,  2088, -1654,  2923,  2731,
   -1654, -1654,  1206,   934,  3186,  2140, -1654,  1929,  2924,  1495,
    2144,  2091,   362,  1321,  1323,  3119,  3120,  3430,  1433,  1931,
    2123,   203,  1571,  1049,  3490,   227,  3129,  3098,  3005,  2146,
    2693,  2694,  2695,  2696,  2697,  2698,  2153,  1693,  3214,  1446,
     770,  1800,  2159,  1434,    49,  2024,  1164,   589,  2460,  2163,
    2461,  1447,    52, -1060,  2068,  2179, -1060,  2077,  3202,  1750,
    3490, -1060,   940,  3206,  1411,  1448,  3208,  1878,   232,  1435,
    2376,  2176,  1449,  2180,  2181,  1793,  1967,  2184, -1060,  2925,
    1338,  1753,  3152,   894,  1876,  3199,   894,  3490,  1384,  3130,
     591,   591,   772,  1801,  3237,  3238,  2732,  1360,   361,   941,
    2733,  -911,  2573,  1435,  2463,  2464,  2078,   710,    49,    71,
      71,   965,    71,  1794,  1450,  2025,    52,  1384,  1385,   703,
    1443,   899,  3379,  3456,  2222,  2223,  2224,  1049,  2609,  1930,
    2994,  1926,  2235,  3002,  3153,  1877,  2238,  2239,  1415,    72,
      72,  3110,    72,  2243,   154,   704,  3131,  1385,  2592,  1571,
    2714,  3397,  2260,  1601,  2261,  1361,   362,   949,  2092,  -911,
     937,  2346,   966,  2629,  2095,  2069,  2432,  2826,  2274,  2012,
    2275,  2728,   154,   954,  1916,  3398,  2079,  2279,  2080,  2096,
    1166,  2097,  1955,  2454,   359,  2098,  2457,  2458,  3092,   770,
     711,  2099,   726,  2100,  1444,  3016,  1362,  2999,  1525,  2734,
    -911,  1492,  3400,  2593,   589,  1743,  2685,  2735,  2136,   171,
      53,  1959,  2136,  1459,   317,   778,  1645,   779,  2757,  2758,
    1878,  2093,  1445,   727,   707,  3111,  3401,  3358,  3112,  2594,
    3291,  2250,   980,   317,  1960,  1671,  3399,   171,   598,  1461,
    1117,   772,   361,  2501,  2595,   618, -1453,   968,   714,  1493,
    2574,  3145,  2596,  1330,  1691,   859,  2358,  1459,   714,  1961,
    2607,  1462,  3508,   188,  1630,  1118,  3359,   957,  2035,  3362,
    3281,  3282,  1708,  2597,  1603,  1728,  1729,  2036,  3365,  3366,
    1460,  2381,  3292,  1461,  2320,   618,  1641,  3402,  3348,     9,
     958,   188,  1642,   898,   714,   756,  3316,  1643,  2037,  3203,
    1119,   959,  1736,   618,   714,  1462,  3028,   714,  1117,  1428,
    1730,   714,  1741,  2604,  3453,   714,   701,  2761,  2070,  1604,
     861,  1202,  2762,  2763,  2764,  1331,  1728,  1729,   359,   209,
    3047,  3317,  1429,  2934,  2765,  2766,  2767,   714,  2768,  2769,
    2770,  1507,  2598,  1446,  2771,  2772,  2773,  1789,  1472,  2394,
    1489,  1790,   714,  2397,  3390,  1447,   881,   209,   861,  1798,
    1799,  1732,   901,   999,   778,  2687,   779,  3493,  1119,  1448,
    2411,  1473,  1744,  1490,  2685,  1437,  1449,  2428,   888,   960,
     225,    49,  1005,  1749,   589,  3507,   227,   921,  3059,    52,
    2830,  2439,  1605,   728,  3392,  3426,  3427,  -301,  2427,  1471,
    2429,  1844,  1844,  1177,  1844,  2446,  3204,  1497,   225,  2449,
     759,  1016,  1067,  2831,   227,  2447,  1068,  3393,  1450,  2592,
    2685,  2966,   829,   703,  1639,  2688,  1191,  1325,  1323,  3509,
     154,  2962,   961,  3378,  2451,    49,  2034,  1579,   589,  1406,
    1893,  1407,  2654,    52,  1061,  2270,  1384,  1803,  1384,  1384,
    2653,  2615,   893,  1072,  2617,  1580,   230,   232,  2619,   231,
     362,   362,   362,  2485,  2504,  2505,  2488,  2029,  2490,   710,
    3420,  1868,   900,   892,  2593,  1869,  1385,  1916,  1385,  1385,
    3146,   703, -1025,  3261,  1073, -1025,  1840,   893,  2522,  1071,
   -1025,   962,  1841,  2526,   711,   171,  1074,   591,  1902,  1095,
    2594,  1886,  2288,  2651,  1075,   362,  1892,   704,   892,  2084,
    1869,  2389,   362,   893,  2090,  2595,   951,  2390,   362,    49,
    1076,    71,  2289,  2596,  2109,    71,   714,    52,   707,  2655,
   -1310,  1887,  1807,  2687,   892,  2593,  3183,  2656,  1077,  1067,
    1098, -1313, -1023,  1068,  2597, -1023,   361,   361,   361,  2621,
   -1023,    72,   711,  2689,  2011,    72,  1845,  1847,  1099,  1851,
    2017,  2594,   937,  2610,  2690,  2691,  2692,  1078,  2693,  2694,
    2695,  2696,  2697,  2698, -1026,  2417,  2982, -1026,  3455,  2687,
    1906,  2418, -1026,  1102,  2596,  1103,   707,  1079,  2370,  1522,
    1523,   361,  1869,  2688,  2136,  2143,  2063,   816,   361,  2136,
    1121,  2781,  2136,  3054,   361,  2947,  1122,  1538,   894, -1024,
     710,  1080, -1024,  2598,  2290,   209,  3012, -1024,  2774,  2291,
    2203,  2633,   703,  2292,  1443,  1109,  2379,  1808,  3048,  3049,
    1869,  1384,   359,   359,   359,  1125,  2657,  3236,  2842,  2688,
    1105,  2633,  1106,   894,  1128,  2844,  2845,    49,   704,  2014,
     589,  2130,  2018,  1138,  2510,    52,  2023,   589,   589,   362,
    2511,  1385,  1150,    53,  1081,  1007,   225,  2538,  1008,   894,
    1693,   845,   227,  2539,  2598,  2885,  2636,   359,  1161,  3445,
    1009,  1010,  2637,  1180,   359,   816, -1060,   129,   130, -1060,
     359,  1323,  1185,   711, -1060,  1508,  1165,   589,  1444,  2775,
    1184,  1011,  2820,  2885,  1012,  1049,  1082,  2652,  1716,  1717,
    1083, -1060,  1084,  2653,   936,   232,   849,  1085,  3471,  2663,
     618,  2689,  2293,  -886,  3474,  2653,  1445,   707,  1193,  2270,
    2294,  1194,  2690,  2691,  2692,  -886,  2693,  2694,  2695,  2696,
    2697,  2698,  1086,  1087,   589,   361,  1199,  3492, -1040,  2665,
      53, -1040,    54,  2250,  1088,  2653, -1040,  2250,  1383,  1089,
    3265,  2125,  2126,   714,   714,  2782,  2794,  2689,  2851,  2852,
    3340,  2171,  1690,  1704,   232,  -886,  1201,  1090,  2796, -1871,
   -1871,  1200,  2693,  2694,  2695,  2696,  2697,  2698,  2250,  2250,
    1202,   710,  2836,  -886,  2562,  2563,   230,    49,  1203,   231,
     589,  2286,  3380,   703,  3337,    52,    53,  2668,    54,    53,
    2270,    54,  2233,  2669,  1383,  2894,  2895,  2896,  2897,  2898,
     849,   849,   849,  1207,  2136,  3139,  1013,  2811,   849,   704,
    1204,   359,   849,   849,  -886,  2673,  1728,  1729,  3266,   849,
     362,  2653,  -886,  3372,  1208,  1940, -1070,  1446,   849, -1070,
     849,  1503,  2674,  1328, -1070,  2678,  2838,  2839,  2653,  1447,
    2827,  2679,  2702,  2760,   849,  2573,   849,  1332,  2653,  2653,
    1898,  1730,  1407,  1448,   711,  3123,  3124,  2843,  1333,  3127,
    1449,  3128,  1334,  1443,  1027,   618,  1031,   982,   598,  1344,
     714,  1051,   598,   714,  2786,  1548,   714,   714,  1027,   598,
    2787,  2398,  2748,  2989,  2749,  2991,  1343,  2993,   707,  2995,
    2347,  1345,  2171,  2344,  2998,  1351,  2794,   362,   714,  1728,
    1729,   618,  1450,  1027,  1352,   598,   361,  2791,   951,   598,
    1112,   714,  1353,  1616,   714,  1355,  1027,  -886,   598,  2891,
   -1034,  2522,  1358, -1034,  2794,  3013,  1369,  2374, -1034,  2374,
    3337,   714,   714,  1846,  1846,   710,  1846,  1444,  1377,   362,
     714,   362,  3121,   618,  2088,  1710,   714,   703,  2750,  2937,
    2751,   714,   714,  1728,  1729,  2938,   714,   714,  2944,   714,
    1373,  2951,  1027, -1070,  2945,  1445, -1070,  2952,  3062,  3085,
    3086, -1070,  1351,   704,  2653,  2653,  2653,   591,  3136,  3137,
     714,   714, -1067,   361,   362, -1067,  1384,   714,  1732,  3191,
   -1067,  3102,   359,  2574,  2001,  1680,  1681,  2952,  -886,  1384,
    3241,    71,   937,    71,  1374,  2179,  3242, -1067,  1389,   714,
    -886,   714,  3337,  1392,  1198,  2685,  1385,  1394,   711,  3530,
    2894,  2895,  2896,  2897,  2898,   361,  3268,   361,  2899,  1385,
    1378,    72,  2952,    72,  2002,  1379, -1037,  3269,  1416, -1037,
     714,   618,  3345,  2952, -1037,  1324,  3003,  1107,  1616,  3350,
    -886,  1750,   707,  1380,    49,  2938,  1381,   589,  2544,  3022,
    1750,  1721,    52,  1342,  1382,  1751,  3014,  1397,  -886,   359,
     361,  3023, -1656,  1753,  3531, -1656,  3532,  3352,  1754,  1748,
   -1656,  3026,  1753,  2938,  3363,   766,  2575,  1754,  3414,  2685,
    3242,   849,  1417,  2713,  3415,  2715,  2716, -1662,  1447,  1384,
    3422,  2003,  1384,  1384,  3424,  1351,  1616,  -878,  3444,  -886,
    2938,   359,  1448,   359,  1673, -1658,  2573,  -886, -1658,  1449,
    3368,   598,   598, -1658,  3447,  3177,  3178,  3179,  1419,  1385,
    3415,  3503,  1385,  1385,  1443,   982,  3454,  2797,  2798,  1525,
   -1663,   714,  1616,  2004,   714,  2005,  1426,   714,  2896,  2897,
    2898,  3505,   770,  3538,  2585,  2006,   359,  3506,   937,  3506,
   -1655,  1450, -1662, -1655,   849,  1357, -1663,  1359, -1655,   849,
    -599,  1027,  2250, -1660,  2687,  2250,  2250,  2250,  2250,  2250,
    2250,  2250,  2250,  2250,  2250, -1660,  1755,  2007, -1654,    49,
    1756, -1654,   589,  2799,  2800,  1755, -1654,    52,  1147,  1756,
    2570, -1659,  1430,  1909,   772,  1442,  2753,  2754,  1444,  1453,
    1757,  1758,  -886, -1659,  2343,  2008,  2981,   714,  2984,  1757,
    1758,  1465,   714,  1759,  2250,  2250,   714,  1467,  2686,  1398,
    1400,  1468,  1759,   714,  2688,  1474,  1445,  1491,  1498,  1499,
    1511,  1027,  1513,  2618,  1974,  2009,  1518,  1520,  2687,  2543,
    1526,  3264,  1529,  1566,  1760,  1027,  1592,  1761,   714,  1597,
      49,  1567,  1435,   589,  2574,  1571,  1761,  1577,    52,    53,
    1762,    54,  3216,  3217,  1575,  -160,  1588,  1383,  1598,  1762,
    -885,  1027,  1606,  1608,   714,  1610,  1148,  1611,  2043,  1612,
    1613,  3135,  -885,  1615,  1619,  1620,  2522,  2522,  2522,  2522,
    2522,  1616,  1622,  1909,  3148,  1623,  1625,  1624,  2688,  1626,
    1741,   714,   849,  1627,  1628,  1682,  1678,  1631,  1684,  1689,
     714,   861,  1697,  2286,  2685,   714,  1700,   778,   714,   779,
    1707,  1764,  -885,  1701,  1702,  1703,  1683,   780,  3060,   714,
    1764,  1688,  2747,   232,  1709,  2083,   783,  1712,  1038,  1713,
    -885,  1714,  1715,  1720,  1723,  2130,  1724,  1446,  1725,  1039,
    1040,  1041,  2689,  1042,  1043,  1044,  1045,  1046,  1047,  1447,
    1726,  1727,  1778,  2690,  2691,  2692,  1734,  2693,  2694,  2695,
    2696,  2697,  2698,  1448,  1514,  1735,  1673,  1785,  2142,  1806,
    1449,  -885,  1827,  1829,  1842,  1360,  1864,  1974,  1765,  -885,
    1867,  1874,  1881,  1882,  2250,  1888,  1890,  1765,  1894,  1766,
    1767,  1768,  1408,  1769,  1770,  1771,  1772,  1773,  1774, -1871,
   -1871,  2633,  1769,  1770,  1771,  1772,  1773,  1774,  2793,  1900,
    1901,  1913,  1450,  1903, -1597,  1905,  2689,  1914,  1916,  2171,
    1917,   849,  1918,  1384,  1934,   618,   618,  2690,  2691,  2692,
    1935,  2693,  2694,  2695,  2696,  2697,  2698,  1937,  1936,  1324,
    1962,  1963,  1559,  1964,  1823,  1823,  3519,  1965,  1970,  1969,
    1971,    49,  1998,  1385,   589,  1831,  1999,  1838,  1049,    52,
      53,  2000,    54,  2687,  2011,  2015,  2021,  2026,  3258,  3353,
    3354,  3355,  2031,  2016,  -885,  2027,  2028,  2030,  2019,  1038,
    3267,  2032,  2047,  2050,  2052,  2053,  2074,  2062,  2064,  1693,
    1039,  1040,  1041,  3276,  1042,  1043,  1044,  1045,  1046,  1047,
    1704,  3271,  1710,  3273,  1721,   768,   618,  2277,   598,  2089,
    2102,  2972,  2108,  2117,  2119,  2249,  2114,  2121,   849,  2122,
    2128,  2138,  2148,  2688,   790,  2250,  2250,  2149,  2160,  2168,
    2169,   800,  2174,   714,  1384,  2185,  1038,  2188,   710,  3403,
    2192,  1384,  1384,  2175,  2685,  2225,  2200,  1039,  1040,  1041,
     703,  1042,  1043,  1044,  1045,  1046,  1047,  2205,  3243,  2215,
    2886,  2258,  2214,  1750,  1385,  2259,  2273,  2280,  2285,  2301,
    2272,  1385,  1385,   317,  3344,  2953,   704,  2303,  2330,  2341,
    2340,  2342,  1051,  2348,  3344,  2916,  2345,   362,  2886,   317,
    1384,  2971,  2353,   944,  2909,   849,  2130,   849,  2917,   937,
    2130,  2359,  2226,  2363,  2364,  2369,  2066,  2377,  2904,  3077,
    3078,  3079,  3080,  2378,  3425,  2388,  2391,  2392,  1384,  2633,
    1385,   711,  2918,  2399,  2919,  2393,  2401,  2403,  1027,  2404,
    2405,  2407,  1027,  2409,  2412,  2415,  2961,  1323,  2424,  2416,
    2425,   317,  2426,  3008,  2441,  2436,  2440,  2437,  1385,  2438,
    2448,  2689,  2455,  2227,  2179,   707,  2228,  2450,  2462,  2487,
    2493,  2495,  2690,  2691,  2692,  1038,  2693,  2694,  2695,  2696,
    2697,  2698,  1810,   361,  2496,  2497,  1039,  1040,  1041,  2498,
    1042,  1043,  1044,  1045,  1046,  1047,  2499,  2920,  2506,   598,
    2512,   714,  2517,  2524,  2525,  2528,  2529,  2250,  2537,  2540,
    2250,  2546,  1324,  2687,  1592,  2568,  2547,  3411,  2569,  2250,
    2250,  2571,  2581,  2582,  2583,  2584,  2608,  2612,  2591,  1793,
    2613,  3423,  2614,  2616,  2634,  2206,   618,  2628,  2646,   714,
     714,  2648,  1187,  1051,  2650,  2666,   714,   714,  2229,   714,
     714,  2667,   714,  2670,  2921,  1027,  1476,   849,  1027,  2922,
    2671,  1741,  1477,   714,  2672,  2868,  2675,   849,  2676,   359,
    2708,  2653,  2680,  2688,  2729,  2683,  2701,  2707,  2710,  2709,
    1559,   714,  2711,   714,   714,  2718,  2722,   714,  2923,  2723,
    2724,  1476,  2736,  2191,  2759,  2743,  3057,  1477,  2924,  1478,
   -1523,  3451,  2805,  2869,  2814,  2821,  2804,  1559,   861,  2822,
    2746,  2208,  2807,  2833,  1974,  2808,  2817,  2818,  2853,  2230,
    2802,  1559,  1407,  2870,   230,    49,  2809,   231,   589,  2861,
    2854,  2516,  2862,    52,  1478,  2863,  2250,  2250,  2871,  2889,
    1884,  1479,  2901,  2890,  2900,  2929,  1480,  1051,  2933,  1481,
    2949,  3502,  2872,  2940,  2948,  2943,  2942,  3484,  3485,  1049,
    2956,   606,  2958,  2969,  2973,  1559,  2977,  2873,   619,  2925,
    2975,  2978,  2985,  2988,  2992,  3000,  1479,  3001,  3007,  1781,
    1559,  1480,  3010,  3011,  1481,  3529,  1690,  2704,  3020,  2685,
    3095,  2703,  3017,  3051,  3052,  1482,  1745,  1559,  3083,  3053,
    3064,  2689,  3088,  3091,  3065,  3096,  3074,  3087,   619,  3089,
     714,  3094,  2690,  2691,  2692,    53,  2693,  2694,  2695,  2696,
    2697,  2698,  1559,  3103,  3105,  3104,   619,   619,  3106,  3107,
    1482,  2685,  3117,  3116,   619,  3122,  3118,  3138,   606,  3149,
    2966,  3160,  3162,  3164,  2874,  3244,  1483,  3156,  3168,  3173,
    3174,  2875,  3187,  3181,  3188,  3197,  1838,  3200,   606,  3207,
     606,  3210,  3221,  3223,  3255,  1559,   714,  3254,  3213,  1886,
    3231,  3215,  3225,  3234,  1559,   619,  3274,   849,  2876,  1459,
    3275,  1483,   849,   849,   849,   849,   849,  3226,  3227,  3229,
     849,  3280,  2130,  3235,  3278,  3293,  3287,  2130,  3130,  1887,
    2130,  3297,  1484,  3298,  3296,  1461,  3299,  3306,  3308,  3311,
    3313,  3325,  3326,  3315,  1459,  3319,  3327,  3332,   598,  3328,
    3330,  3333,  3342,  3356,   714,  3357,  3347,  1485,  3361,  3184,
    3360,  3373,  3374,  3381,  3155,  3389,  3395,   598,   714,  3387,
    1461,   598,   618,  2952,  3408,  3405,   714,  2249,  3409,  3432,
    3433,  2249,   714,  3406,  3440,  3436,  3441,   714,   598,  3452,
    3457,  3470,  2483,  3460,  3477,  3462,  3475,  3458,  3459,  3487,
    3499,  3498,  3518,  3533,   939,  1977,  3520,  3534,  1824,  2542,
    2784,  2484,  2249,  2249,  2850,  2508,   598,   714,   598,   714,
    2687,   714,  3283,  3166,   714,  2435,  2465,  3170,  3108,  3303,
    2816,   714,  3176,  3476,  1559,  3497,  3463,  3461,  3483,  3329,
    3171,  2110,  3536,  2527,  3523,   714,  3295,  3294,  2930,   714,
    2931,  3504,   598,   714,   714,  1978,  2878,  2085,  3537,  2162,
     869,  1667,  1979,  1980,  2635,  3185,  3222,  2466,  2467,   714,
     714,   714,  2473,   714,  3412,  3450,   714,   714,   714,   619,
    2688,   598,   714,  2419,   598,   714,   598,  2810,  2823,  2421,
    3431,  3511,  3263,  3535,  1336,  3190,  3391,  2535,   832,  1981,
    2355,  3009,  2788,  1027,  1027,   317,  2171,  3309,  1644,  2620,
    1862,  3218,  2792,  2801,    71,  1860,   849,  2366,  1865,  2352,
    2523,  2755,  2983,  3349,  2587,  3284,  3285,  1134,  3165,   849,
    3289,  3056,  2795,  2832,  2741,  2835,  3259,  2739,  1982,  2660,
    2329,  2639,  3240,  1983,    72,   985,  2970,   861,  2580,  2380,
    2124,   329,  2130,  1600,  1873,   952,   998,  1424,  2371,  1676,
    1750,  1401,  2550,  2846,  2626,  2779,  2561,  2382,  2567,  3219,
    1792,  2627,  3220,  3090,  1751,   974,  1597,  1870,  2386,  2622,
    1984,  2170,  1753,  3257,  2590,  1403,    78,  1754,  2590,  2603,
       0,  3339,     0,  2857,     0,  1985,  1986,     0,  1987,  1988,
       0,  1989,  1027,  2435,     0,     0,     0,     0,  2689,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2690,
    2691,  2692,   714,  2693,  2694,  2695,  2696,  2697,  2698,  1990,
    1550,     0,     0,  1559,  1559,     0,     0,     0,     0,   598,
       0,     0,     0,     0,     0,     0,     0,  2939,     0,     0,
       0,     0,     0,     0,     0,     0,   714,     0,  2846,   598,
    1991,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   619,     0,     0,  3370,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1992,     0,  1993,  1755,     0,     0,     0,  1756,
       0,   317,  3528,  2971,     0,  2990,  3371,     0,     0,  1974,
       0,     0,     0,     0,     0,  1994,     0,     0,  1551,  1757,
    1758,     0,  1995,     0,     0,  1996,     0,  2721,     0,     0,
       0,  1559,  1759,  3410,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1559,     0,
       0,     0,   317,     0,  3446,  1051,     0,     0,     0,  3021,
       0,     0,     0,  1760,     0,     0,  1761,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1762,
       0,  1763,  3029,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1823,
       0,     0,     0,     0,     0,  1838,     0,     0,     0,  3050,
       0,     0,     0,     0,     0,     0,  2249,     0,   714,  2249,
    2249,  2249,  2249,  2249,  2249,  2249,  2249,  2249,  2249,     0,
       0,     0,     0,  3066,     0,     0,     0,     0,     0,     0,
    1764,   317,     0,     0,     0,   598,   714,   714,     0,     0,
       0,     0,     0,     0,  3527,     0,     0,     0,     0,  2567,
       0,     0,     0,     0,     0,   606,     0,     0,  2249,  2249,
       0,     0,     0,     0,     0,     0,     0,   317,   598,   714,
     714,     0,     0,   849,   849,     0,     0,     0,     0,     0,
    1750,     0,     0,     0,     0,     0,   714,   714,     0,     0,
       0,     0,     0,  1129,   619,   619,     0,  1765,     0,     0,
       0,     0,  1753,     0,     0,     0,  1027,  1754,  1766,  1767,
    1768,     0,  1769,  1770,  1771,  1772,  1773,  1774,     0,     0,
    2040,     0,     0,     0,     0,     0,     0,   619,     0,  2041,
       0,   606,     0,   606,     0,   606,  3113,     0,     0,     0,
       0,   606,   606,  2435,     0,     0,     0,     0,  1550,     0,
     619,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2523,     0,     0,     0,     0,     0,   606,
       0,     0,     0,     0,     0,  1550,   714,   714,   714,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1550,
       0,     0,     0,     0,     0,     0,   606,     0,     0,     0,
       0,     0,     0,   619,   619,     0,     0,   606,   606,     0,
       0,   729,     0,   714,     0,  1755,  3159,     0,  1324,  1756,
       0,     0,     0,     0,     0,   618,     0,     0,   714,  2590,
       0,     0,  2974,  1550,     0,     0,  1551,     0,  2249,  1757,
    1758,     0,     0,     0,     0,  2987,     0,     0,  1550,     0,
       0,     0,  1759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   730,  1551,  1559,  1550,  1553,   606,     0,     0,
       0,     0,     0,     0,   598,     0,     0,  1551,   731,     0,
       0,  2191,     0,  1760,   606,   606,  1761,     0,     0,     0,
    1550,     0,  1559,  1559,   598,  1559,   732,     0,     0,  1762,
       0,     0,     0,     0,     0,     0,     0,     0,  1027,     0,
    1559,     0,  1559,     0,     0,     0,     0,     0,     0,     0,
       0,  1551,     0,     0,     0,   733,     0,     0,     0,     0,
       0,   734,     0,  1550,     0,     0,  1551,     0,     0,     0,
    1559,     0,  1550,     0,     0,   735,     0,     0,     0,     0,
       0,     0,  3066,  1551,     0,     0,     0,     0,     0,     0,
    1764,     0,     0,     0,     0,     0,     0,     0,   736,     0,
    1559,     0,     0,     0,     0,     0,     0,     0,  1551,  2249,
    2249,     0,     0,     0,     0,     0,  1559,     0,     0,     0,
       0,     0,   606,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1559,     0,     0,     0,     0,     0,
       0,  1551,   737,     0,  1559,     0,     0,  1765,     0,     0,
    1551,  1838,     0,  1750,     0,  1559,     0,     0,  1766,  1767,
    1768,     0,  1769,  1770,  1771,  1772,  1773,  1774,     0,  1559,
       0,     0,     0,     0,     0,  1753,     0,     0,   606,     0,
    1754,  2567,  2567,     0,   738,     0,     0,     0,     0,     0,
     739,     0,  1550,     0,   753,   740,     0,  1652,     0,     0,
    1656,     0,  1559,     0,     0,     0,  1559,     0,     0,     0,
     619,     0,     0,     0,     0,     0,     0,   714,   714,  2939,
     741,   742,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   743,   863,     0,     0,     0,   744,     0,     0,
       0,   871,     0,     0,     0,     0,   745,  1554,     0,  3364,
       0,     0,     0,     0,     0,     0,  1559,     0,  2523,  2523,
    2523,  2523,  2523,     0,     0,     0,     0,     0,     0,     0,
       0,  2249,     0,     0,  2249,     0,     0,   927,     0,  1559,
    1551,   714,     0,  2249,  2249,     0,   606,     0,  1755,     0,
       0,     0,  1756,     0,     0,     0,     0,   606,     0,     0,
       0,     0,  2550,     0,  2466,     0,  1559,  2466,     0,  3172,
       0,     0,  1757,  1758,  1553,     0,  2567,     0,     0,     0,
       0,     0,  2435,  1788,     0,  1759,     0,     0,   619,   619,
    1559,     0,     0,     0,     0,     0,     0,  2590,     0,   714,
       0,  1553,   606,     0,     0,   606,     0,   606,   606,     0,
    2550,     0,  3212,     0,     0,  1553,  2435,     0,     0,  1761,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   598,
       0,     0,  1762,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1550,  1550,     0,     0,     0,     0,     0,     0,  1553,
    2249,  2249,     0,     0,     0,     0,     0,     0,     0,   619,
       0,   606,     0,     0,  1553,     0,     0,     0,     0,     0,
    1750,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1553,     0,  1764,     0,     0,     0,     0,     0,     0,
       0,     0,  1753,  1559,     0,     0,     0,  1754,     0,     0,
       0,     0,     0,     0,     0,     0,  1553,     0,  1051,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   598,
     714,   598,     0,     0,  3486,     0,  3277,     0,     0,  1551,
    1551,     0,     0,     0,     0,     0,     0,     0,     0,  1550,
    2567,     0,     0,     0,     0,     0,     0,     0,     0,  1553,
    1765,     0,     0,     0,     0,     0,  1550,     0,  1553,     0,
       0,  1766,  1767,  1768,     0,  1769,  1770,  1771,  1772,  1773,
    1774,     0,  2727,  1559,     0,     0,     0,     0,  1974,     0,
     606,     0,     0,     0,     0, -1868,     0,     0,   714,     0,
       0,     0,     0,     0,     0,   714,     0,     0,     0,     0,
       0,  3338,     0,     0,     0, -1871,     0,  1559,     0,  1756,
       0,  3343,     0,     0,   714,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3212,  1554, -1868,  1551,     0,  1757,
    1758,     0,     0,     0,     0,     0,     0,   598, -1868,     0,
       0,     0, -1871, -1868,  1551,     0,     0,     0, -1868,     0,
       0, -1868,  1554, -1868,     0,   606,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   606,  1554,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1761,     0, -1868,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1553,  1762,
       0,   363,     0,     0,   363,     0, -1868,     0,     0,     0,
       0,  2567,     0,     0,     0,     0,     0,   363,     0,  1559,
    1554,     0,     0,     0,     0,     0,     0,     0,     0,  1788,
    2173,     0,  2435,     0,  2466,  1554,     0,     0,     0,     0,
     363,     0,     0,     0,     0,     0,     0, -1868,     0,     0,
       0,     0,  1554,     0,     0, -1868,  1027,  3338,     0,     0,
   -1871,  1027,  1027,     0,     0,     0,     0,     0,     0,     0,
       0,   714,     0,     0,   796,     0,     0,  1554,     0,   606,
     606,   606,     0,     0,     0,     0,   606,   606,     0,     0,
   -1868,   606,   606,     0,     0,     0,     0,     0,   606,     0,
       0,     0,     0,     0,     0,     0,     0,   606,     0,   606,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   714,
    1554,     0,     0,   606,     0,   606,     0,  1765,   895,  1554,
     867,     0,     0,     0,     0,   895,     0,   895,     0,  3338,
    1027,     0,  1769,  1770,  1771,  1772,  1773,  1774,   363,     0,
   -1868,     0,     0,  1055,     0,     0,     0,  1652,     0,     0,
       0,     0,     0,  2338,   714,     0,  1559,     0, -1868,     0,
       0,  2173,  1027,     0,  1094, -1868, -1868, -1868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   606,     0,     0,
       0,     0,  1550,     0,  3491,     0,  1559,  1553,  1553,     0,
       0,     0, -1868,     0,     0, -1868, -1868, -1868,     0,  1051,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1550,  1550,     0,  1550,     0,     0,     0,     0,     0,     0,
    3491,     0,     0,     0,     0,     0,     0,     0,  1550,     0,
    1550,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,     0,  3491,     0,  1554,
       0,     0,     0,     0,     0,   606,     0,  1556,  1550,     0,
       0,   606,     0,     0,     0,  1188,     0,   619,     0,     0,
    1551,  1190,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   363,  1197,     0,   363,  1553,     0,     0,  1550,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,  1551,
       0,  1551,  1553,     0,  1550,     0,     0,     0,     0,     0,
       0,  1190,     0,     0,     0,     0,  1551,     0,  1551,     0,
       0,     0,     0,     0,     0,     0,  1190,     0,     0,     0,
       0,  1340,  1550,     0,  1750,     0,     0,     0,     0,     0,
       0,     0,  1550,     0,     0,  1354,  1551,     0,  1751,     0,
       0,     0,     0,  1550,     0,     0,  1753,     0,     0,     0,
     606,  1754,     0,     0,     0,     0,     0,  1550,   606,     0,
       0,   606,   606,     0,     0,     0,  1551,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1551,     0,     0,     0,     0,     0,     0,  1750,
    1550,     0,     0,     0,  1550,     0,     0,     0,     0,     0,
       0,  1559,     0,  1751,     0,   606,     0,     0,     0,   606,
    1551,  1753,     0,   606,     0,     0,  1754,     0,     0,     0,
    1551,     0,     0,   606,     0,     0,     0,     0,   606,     0,
       0,  1551,     0,     0,     0,     0,     0,     0,  1554,  1554,
       0,     0,     0,     0,  1550,  1551,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1559,     0,     0,     0,  1755,
       0,     0,     0,  1756,  1509,     0,     0,  1550,     0,     0,
       0,   796,     0,     0,   606,     0,     0,     0,  1551,     0,
       0,     0,  1551,  1757,  1758,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1550,     0,  1759,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1585,  1586,  1587,     0,     0,     0,     0,   606,  1550,     0,
       0,     0,     0,     0,  1755,   619,  1652,  1760,  1756,  2625,
    1761,  1656,  1551,     0,     0,     0,  1554,     0,     0,     0,
       0,     0,     0,  1762,     0,  1763,     0,     0,  1757,  1758,
       0,     0,     0,  1554,     0,  1551,     0,     0,     0,     0,
       0,  1759,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   606,     0,     0,     0,  1556,     0,     0,  1190,     0,
       0,     0,  1551,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1760,     0,     0,  1761,     0,  1190,     0,     0,
       0,     0,  1556,     0,  1764,     0,  1551,     0,  1762,     0,
    1763,     0,     0,     0,     0,     0,  1556,     0,  1553,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,     0,
     363,  1550,     0,     0,  1025,     0,     0,     0,  1025,     0,
       0,     0,     0,     0,     0,     0,  1553,  1553,     0,  1553,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1556,     0,     0,     0,  1553,     0,  1553,     0,  1025,  1764,
       0,  1765,     0,     0,     0,  1556,     0,     0,     0,     0,
       0,     0,  1766,  1767,  1768,     0,  1769,  1770,  1771,  1772,
    1773,  1774,  1556,     0,  1553,     0,  2271,     0,  2173,     0,
     606,     0,   606,     0,     0,     0,     0,  1132,     0,     0,
    1025,  1550,     0,     0,     0,     0,  1025,  1556,     0,  1551,
       0,     0,     0,     0,  1553,     0,     0,     0,     0,     0,
       0,     0,  1830,     0,     0,     0,  1765,     0,     0,     0,
    1553,     0,     0,  1750,     0,  1550,     0,  1766,  1767,  1768,
       0,  1769,  1770,  1771,  1772,  1773,  1774,  1750,     0,     0,
    1556,     0,     0,     0,     0,  1753,     0,  2677,  1553,  1556,
    1754,  1751,     0,     0,     0,     0,     0,     0,  1553,  1753,
       0,     0,     0,     0,  1754,     0,     0,     0,     0,  1553,
       0,     0,     0,     0,     0,     0,     0,   606,     0,  1551,
       0,     0,     0,  1553,     0,     0,     0,     0,     0,  1307,
       0,     0,     0,   606,   895,     0,     0,   895,     0,     0,
     606,   606,     0,     0,     0,     0,     0,     0,     0,   363,
       0,     0,     0,  1551,     0,     0,  1553,     0,     0,  1307,
    1553,     0,     0,     0,     0,  2737,     0,  1550,     0,     0,
       0,     0,   606,     0,   606,   606,     0,     0,     0,     0,
       0,     0,     0,   606,     0,     0,     0,     0,     0,   606,
       0,     0,     0,     0,   606,  2020,   606,     0, -1871,  1554,
       0,     0,  1756,     0,     0,     0,     0,   606,   606,     0,
    1553,     0,  1755,     0,     0,     0,  1756,   606,     0,  1556,
       0,     0,  1757,  1758,     0,     0,     0,  1554,  1554,     0,
    1554,     0,     0,  1553,     0, -1871,  1757,  1758,     0,     0,
       0,     0,     0,     0,     0,  1554,     0,  1554,     0,  1759,
     606,   606,     0,     0,     0,  1551,     0,     0,     0,     0,
    1553,   619,     0,     0,     0,     0,     0,     0,     0,  1761,
       0,     0,     0,     0,     0,  1554,     0,     0,     0,     0,
    1760,     0,  1762,  1761,  1553,     0,     0,     0,     0,     0,
       0,     0,  1307,   363,     0,     0,  1762,  1025,  1763,     0,
       0,     0,     0,  1025,     0,  1554,     0,     0,     0,     0,
       0,     0,     0,     0,  1550,     0,     0,     0,     0,     0,
       0,  1554,     0,  1564,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2155,     0,     0,
    2158,  1750,     0, -1871,  1550,     0,   606,     0,  1025,  1554,
       0,     0,     0,     0,     0,  1751,   606,  1764,     0,  1554,
       0,     0,     0,  1753,     0,     0,     0,     0,  1754,     0,
    1554,     0,     0,     0,  1190,  1190,     0,     0,     0,     0,
       0,     0,     0,     0,  1554,     0,  2199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1553,     0,     0,
     606,     0,  1551,     0,     0,     0,     0,     0,     0,     0,
    1765,     0,     0,     0,     0,     0,     0,  1554,  1556,  1556,
       0,  1554,     0,     0,  1765,  1769,  1770,  1771,  1772,  1773,
    1774,     0,  1551,     0,     0,  1766,  1767,  1768,  1307,  1769,
    1770,  1771,  1772,  1773,  1774,     0,     0,     0,     0,  2888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1307,     0,     0,     0,     0,
       0,  1554,     0,     0,     0,     0,  1755,  1553,     0,     0,
    1756,     0,     0,     0,     0,     0,     0,     0,     0,  1307,
    1307,   805,  1307,  2328,  1554,     0,     0,     0,     0,     0,
    1757,  1758,   806,     0,     0,     0,     0,     0,     0,     0,
    1307,  1553,     0,  1759,     0,     0,  1556,     0,     0,     0,
       0,  1554,   807,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1556,     0,     0,     0,  1750,     0,   606,
     606,     0,   808,     0,  1760,  1554,     0,  1761,     0,     0,
       0,  1751,  2356,  1812,     0,     0,     0,     0,   809,  1753,
    1762,     0,  1763,     0,  1754,     0,   606,     0,     0,  1550,
       0,   606,   606,   606,   606,   606,   810,     0,     0,   606,
       0,     0,     0,  1307,     0,     0,  1307,  1307,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   363,   363,   363,
       0,     0,     0,     0,     0,   811,     0,     0,     0,     0,
       0,   812,     0,  1553,     0,     0,     0,     0,     0,     0,
       0,  1764,     0,  1550,     0,   813,     0,     0,     0,     0,
       0,     0,     0,   606,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,     0,     0,     0,     0,     0,   363,
       0,  1564,     0,     0,     0,   363,     0,  1551,  1554,   895,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1755,     0,     0,     0,  1756,  2625,  1958,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1765,     0,
       0,     0,  1564,     0,   895,     0,  1757,  1758,     0,  1766,
    1767,  1768,   814,  1769,  1770,  1771,  1772,  1773,  1774,  1759,
     815,  1551,     0,  3055,     0,     0,     0,     0,     0,     0,
     895,     0,     0,   816,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2477,     0,  1564,     0,  1554,     0,
    1760,     0,     0,  1761,   817,     0,     0,     0,   818,     0,
     819,  2060,     0,     0,     0,   820,  1762,     0,  1763,     0,
    1553,     0,     0,     0,     0,  2173,   606,     0,  1564,     0,
       0,     0,  1554,     0,     0,   606,     0,     0,     0,     0,
     821,   822,     0,     0,     0,     0,     0,     0,   606,     0,
    1553,     0,   823,  1564,   606,   606,   363,   824,     0,   606,
     606,     0,  2541,     0,   606,     0,   825,     0,     0,     0,
       0,     0,     0,     0,     0,   826,     0,  1764,     0,     0,
       0,     0,     0,     0,  2551,     0,     0,     0,     0,     0,
       0,  1025,  2572,  1025,     0,     0,  1564,     0,  1025,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1556,
       0,     0,     0,     0,     0,   606,     0,     0,     0,     0,
       0,     0,     0,     0,  1554,     0,     0,     0,     0,     0,
       0,     0,     0,  1025,  1765,     0,     0,  1556,  1556,     0,
    1556,     0,     0,     0,     0,  1766,  1767,  1768,     0,  1769,
    1770,  1771,  1772,  1773,  1774,  1556,     0,  1556,     0,  3099,
       0,     0,     0,     0,  1307,  1307,     0,     0,     0,     0,
       0,     0,  1307,     0,     0,  1307,  1307,     0,     0,     0,
       0,     0,     0,     0,  2234,  1556,     0,  1307,  1307,     0,
       0,     0,     0,     0,     0,  1307,     0,  1750,     0,  1307,
    1307,  1307,  1307,     0,     0,     0,     0,   606,     0,  1307,
    1307,  1751,     0,     0,     0,  1556,     0,     0,     0,  1753,
       0,     0,     0,     0,  1754,  1564,  1307,   363,     0,     0,
    1307,  1556,     0,     0,  1307,     0,     0,     0,  1307,     0,
       0,  1307,  1307,  1307,  1307,  1307,  1307,  1307,  1307,  1307,
       0,  1307,     0,     0,     0,     0,  1307,   606,     0,  1556,
    1307,     0,     0,  1750,     0,  1553,     0,     0,     0,  1556,
       0,  1554,     0,     0,     0,     0,     0,  1751,     0,     0,
    1556,     0,     0,     0,     0,  1753,     0,  2752,     0,     0,
    1754,  1750,     0,     0,  1556,     0,     0,   709,     0,     0,
       0,  1554,     0,     0,   363,  1751,     0,     0,     0,     0,
       0,     0,     0,  1753,     0,     0,  1307,     0,  1754,  1553,
     709,     0,     0,     0,     0,     0,     0,  1556,     0,     0,
       0,  1556,  1755,     0,     0,     0,  1756,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   363,     0,
       0,     0,     0,     0,     0,     0,  1757,  1758,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1556,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   363,   606,   606,     0,     0,     0,   606,  1755,     0,
    1760,     0,  1756,  1761,  1556,     0,  1307,     0,   891,     0,
       0,     0,     0,     0,     0,   891,  1762,   891,  1763,     0,
       0,     0,  1757,  1758,  1958,  1564,  1755,     0,   709,     0,
    1756,  1556,     0,   606,     0,  1759,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1757,  1758,     0,     0,     0,  1556,     0,     0,     0,     0,
     606,     0,     0,  1759,     0,     0,  1760,     0,     0,  1761,
       0,     0,     0,  1750,     0,     0,     0,  1764,     0,     0,
       0,     0,  1762,     0,  1763,     0,     0,  1751,     0,     0,
       0,     0,     0,     0,  1760,  1753,     0,  1761,     0,     0,
    1754,     0,     0,     0,     0,     0,     0,     0,     0,  2935,
    1762,     0,  1763,     0,     0,  2941,  1307,     0,     0,     0,
       0,     0,  1564,     0,     0,     0,  1554,     0,     0,     0,
       0,     0,     0,     0,  2957,     0,     0,  1307,     0,  1564,
       0,     0,     0,  1764,  1765,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1766,  1767,  1768,     0,  1769,
    1770,  1771,  1772,  1773,  1774,     0,     0,     0,  1556,  3228,
       0,  1764,     0,     0,     0,     0,     0,  2996,     0,  2997,
    1554,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1750,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1025,     0,  1751,     0,  1755,     0,
    1765,  1190,  1756,  1307,  1753,     0,     0,     0,     0,  1754,
       0,  1766,  1767,  1768,     0,  1769,  1770,  1771,  1772,  1773,
    1774,     0,  1757,  1758,     0,  3249,     0,     0,  1765,     0,
       0,     0,  1750,     0,     0,  1759,     0,     0,  1556,  1766,
    1767,  1768,     0,  1769,  1770,  1771,  1772,  1773,  1774,     0,
       0,     0,     0,  3385,  1753,     0,     0,  1307,     0,  1754,
       0,     0,     0,     0,     0,     0,  1760,     0,     0,  1761,
       0,     0,  1556,     0,     0,     0,     0,     0,     0,     0,
    1307,     0,  1762,     0,  1763,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3081,  3082,     0,     0,
       0,     0,  1307,     0,     0,     0,  1307,  1755,     0,     0,
       0,  1756,     0,     0,     0,     0,     0,     0,  1307,  1307,
    1307,  1307,     0,     0,  3071,     0,     0,  1307,     0,     0,
       0,  1757,  1758,  1764,     0,     0,     0,  1307,  1307,     0,
    1307,     0,     0,     0,  1759,     0,     0,     0,     0,     0,
       0,     0,  1307,     0,  1307,     0,     0, -1871,  1307,     0,
       0,  1756,     0,     0,  1556,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1307,  1760,     0,     0,  1761,     0,
       0,  1757,  1758,     0,     0,  1025,     0,  1307,  1307,     0,
       0,  1762,     0,  1763, -1871,     0,     0,     0,     0,     0,
    1765,     0,     0,     0,     0,     0,     0,     0,  1307,     0,
       0,  1766,  1767,  1768,  1307,  1769,  1770,  1771,  1772,  1773,
    1774,     0,  1307,  1307,  1307,  3448,     0,     0,  1761,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1762,     0,     0,  3147,  1564,     0,     0,     0,     0,
       0,     0,  1764,     0,     0,     0,  1307,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3157,     0,     0,
       0,     0,     0,  1958,  1564,     0,  1564,  3161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1564,     0,  1564,     0,     0,     0,     0,     0,     0,
       0,     0, -1871,     0,     0,     0,   709,     0,     0,     0,
       0,  1556,     0,     0,  1022,     0,     0,     0,  1022,  1765,
       0,  1564,     0,     0,     0,     0,     0,     0,     0,     0,
    1766,  1767,  1768,     0,  1769,  1770,  1771,  1772,  1773,  1774,
       0,  1556,  2855,     0,     0,     0,     0,     0,  1022,     0,
       0,  1564,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2879,  1564,     0,  1765,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1769,  1770,  1771,  1772,  1773,  1774,
    1022,     0,     0,     0,   363,  1564,  1022,     0,     0,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1564,     0,     0,     0,
    3250,  3251,  3252,  3253,     0,     0,     0,     0,     0,     0,
    1564,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1025,     0,     0,     0,
    1025,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,     0,     0,  1564,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1025,     0,     0,     0,     0,     0,  1302,
       0,     0,     0,     0,   891,     0,     0,   891,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1307,     0,
       0,     0,  1750,     0,  1307,     0,     0,  1564,     0,  1302,
       0,     0,     0,     0,     0,     0,  1307,     0,     0,     0,
       0,     0,  1307,     0,  1753,     0,  1307,     0,     0,  1754,
    1564,  1307,     0,  1750,  1307,  1307,  1307,  1307,  1307,  1307,
    1307,  1307,  1307,  1307,     0,     0,     0,  1751,  1307,  1307,
       0,  2360,     0,     0,     0,  1753,  1556,  1564,     0,     0,
    1754,     0,  1307,     0,     0,     0,     0,     0,     0,  1307,
       0,     0,  1307,     0,  1307,     0,     0,     0,     0,     0,
       0,  1564,  1307,  1307,  1307,     0,     0,     0,  1307,     0,
       0,  1307,     0,     0,     0,     0,     0,     0,     0,  1750,
       0,     0,     0,     0,  3072,     0,     0,     0,     0,     0,
    1556,     0,     0,  1751,     0,     0,     0,     0,     0,     0,
       0,  1753,  2361,     0,     0,     0,  1754,     0,     0,     0,
       0,     0,  3383,     0,     0,     0,     0, -1871,     0,     0,
       0,  1756,  1302,   709,     0,     0,     0,  1022,     0,     0,
       0,     0,  1190,  1022,     0,     0,     0,     0,     0,     0,
       0,  1757,  1758,     0,     0,     0,     0,     0,  1755,     0,
       0,     0,  1756,  1562, -1871,  3421,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1757,  1758,  1564,     0,     0,     0,  1022,     0,
       0,     0,     0,     0,   605,  1759,     0,  3429,  1761,     0,
       0,     0,     0,     0,  2703,     0,     0,     0,     0,  2704,
       0,  1762,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1755,     0,  1760,     0,  1756,  1761,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1762,     0,  1763,     0,     0,     0,  1757,  1758,
       0,     0,     0,  1307,     0,     0,     0,     0,     0,     0,
       0,  1759,     0,     0,  1564,     0,     0,     0,     0,     0,
       0,   852, -1871,     0,     0,     0,     0,     0,  1302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   605,  1760,   852,     0,  1761,     0,     0,  1564,     0,
       0,     0,     0,  1764,     0,  1302,     0,     0,  1762,     0,
    1763,     0,  1025,     0,     0,     0,     0,  1025,     0,     0,
    1025,     0,     0,     0,     0,     0,     0,     0,     0,  1302,
    1302,     0,  1302,     0,     0,     0,     0,     0,     0,  1765,
       0,     0,     0,     0,     0,     0,     0,  2362,     0,     0,
    1302,  1750,     0,  1307,  1769,  1770,  1771,  1772,  1773,  1774,
       0,     0,     0,     0,     0,  1751,     0,     0,  1752,  1764,
    1765,     0,     0,  1753,     0,     0,     0,     0,  1754,     0,
       0,  1766,  1767,  1768,     0,  1769,  1770,  1771,  1772,  1773,
    1774,     0,     0,     0,  1307,  1307,     0,     0,     0,  1307,
    1564,     0,     0,     0,     0,     0,  1307,  1307,     0,     0,
    1307,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1302,     0,     0,  1302,  1302,     0,     0,
     752,     0,     0,     0,     0,     0,  1765,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1750,  1766,  1767,  1768,
       0,  1769,  1770,  1771,  1772,  1773,  1774,     0,     0,     0,
    1751,     0,     0,  2662,     0,     0,     0,     0,  1753,   752,
       0,     0,     0,  1754,     0,     0,     0,   752,     0,     0,
       0,     0,     0,     0,  1307,     0,  1755,     0,     0,     0,
    1756,  1562,     0,     0,     0,   709,     0,     0,     0,   891,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1757,  1758,     0,   752,   752,     0,     0,     0,  1956,     0,
       0,     0,  1025,  1759,     0,     0,     0,     0,     0,     0,
       0,     0,  1562,     0,   891,     0,     0,     0,  1307,     0,
       0,     0,  1025,     0,     0,     0,     0,  1564,     0,     0,
       0,     0,     0,     0,  1760,     0,     0,  1761,     0,     0,
     891,     0,     0,     0,     0,     0,  1307,     0,     0,  1307,
    1762,     0,  1763,     0,     0,     0,  1562,  1564,  1307,  1307,
       0,  1755,  1307,     0,     0,  1756,     0,     0,     0,  1307,
    1307,  1562,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1757,  1758,     0,  1562,     0,
       0,     0,     0,  1307,     0,     0,     0,     0,  1759,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1764,  1025,  1562,     0,     0,   709,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1760,
       0,     0,  1761,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1762,     0,  1763,  1025,  1307,
       0,  1022,     0,  1022,     0,     0,  1562,     0,  1022,     0,
       0,     0,     0,     0,     0,  1562,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1307,  1307,     0,  1765,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1766,
    1767,  1768,     0,  1769,  1770,  1771,  1772,  1773,  1774,  1750,
       0,     0,     0,  1022,     0,     0,  1764,     0,     0,     0,
       0,     0,     0,  1751,     0,     0,     0,     0,     0,     0,
       0,  1753,     0,     0,     0,     0,  1754,     0,     0,     0,
    1025,     0,     0,     0,  1302,  1302,     0,     0,     0,     0,
       0,     0,  1302,     0,     0,  1302,  1302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1302,  1302,     0,
       0,     0,     0,     0,     0,  1302,     0,     0,     0,  1302,
    1302,  1302,  1302,  1765,     0,     0,     0,     0,     0,  1302,
    1302,     0,  1564,     0,  1766,  1767,  1768,     0,  1769,  1770,
    1771,  1772,  1773,  1774,     0,  1562,  1302,   709,     0,  1025,
    1302,     0,     0,     0,  1302,     0,     0,     0,  1302,     0,
       0,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,
       0,  1302,     0,     0,     0,     0,  1302,     0,     0,     0,
    1302,     0,     0,  1025,  1755,     0,  1564,     0,  1756,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   605,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1757,  1758,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1759,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1750,     0,     0,     0,  1302,     0, -1870,     0,
       0,     0,     0,     0,     0,     0,  1751,     0,     0,     0,
       0,     0,  1760,     0,  1753,  1761,     0,     0,     0,  1754,
    1750,     0,     0,     0,     0,     0,     0,     0,  1762,     0,
    1763,     0,     0,     0,   852,     0,   852,     0,   852, -1870,
       0,     0,  1753,     0,   852,   852,     0,  1754,     0,     0,
       0, -1870,     0,     0,     0,     0, -1870,     0,     0,     0,
       0, -1870,     0,     0, -1870,    73, -1870,     0,     0,     0,
       0,   709,   605,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1302,     0,     0,  1764,
       0, -1870,     0,     0,     0,     0,     0,     0,     0,   605,
       0,     0,     0,     0,  1956,  1562,     0,     0,  1018, -1870,
     605,   605,  1018,     0,   752,     0,     0,     0,     0,   752,
     752,     0,  3075,     0,     0,     0,     0,  1755,     0,     0,
       0,  1756,     0,  2664,     0,     0,     0,     0,     0,     0,
     752,     0,  1018,     0,     0,     0,     0,   590,     0,     0,
   -1870,  1757,  1758,     0,     0, -1871,  1765,     0, -1870,  1756,
       0,     0,     0,     0,  1759,     0,     0,  1766,  1767,  1768,
    1388,  1769,  1770,  1771,  1772,  1773,  1774,     0,     0,  1757,
    1758,     0,     0,   752,  1018,     0,     0,   605,   605,     0,
    1018,     0, -1871, -1870,     0,  1760,  1302,     0,  1761,  1388,
       0,     0,  1562,     0,     0,     0,     0,     0,     0,     0,
       0,  1762,   791,  1763,     0,     0,     0,  1302,     0,  1562,
       0,     0,     0,  2681,     0,     0,  1761,     0,     0,     0,
       0,     0,     0,   867,     0,     0,     0,     0,     0,  1762,
    1750,   752,     0,     0,   590,     0,     0,   752,     0,     0,
       0,     0,     0, -1870,  1751,     0,     0,  2712,   752,     0,
       0,     0,  1753,     0,     0,     0,     0,  1754,     0,     0,
    1750, -1870,  1764,     0,     0,     0,     0,     0, -1870, -1870,
   -1870,     0,     0,     0,  1022,     0,     0,   752,     0,     0,
       0,     0,  1753,  1302,     0,   605,     0,  1754,     0,     0,
   -1871,     0,   752,     0,     0, -1870,     0,   752, -1870, -1870,
   -1870,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   752,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1765,
       0,     0,     0,     0,     0,     0,     0,  1302,     0,     0,
    1766,  1767,  1768,     0,  1769,  1770,  1771,  1772,  1773,  1774,
       0,   605,     0,     0,     0,     0,     0,  1765,     0,     0,
    1302,     0,  3247,     0,     0,  1755,  1750,     0,     0,  1756,
       0,     0,  1769,  1770,  1771,  1772,  1773,  1774,     0,     0,
    1751,     0,     0,     0,     0,     0,     0,     0,  1753,  1757,
    1758,     0,  1302,  1754,     0, -1871,  1302,     0,     0,  1756,
       0,     0,  1759,     0,     0,     0,     0,     0,  1302,  1302,
    1302,  1302,     0,     0,     0,     0,     0,  1302,     0,  1757,
    1758,     0,     0,     0,     0,     0,     0,  1302,  1302,     0,
    1302,     0, -1871,  1760,     0,     0,  1761,     0,     0,     0,
     752,  1018,  1302,     0,  1302,     0,     0,  1018,  1302,  1762,
       0,  1763,     0,     0,     0,     0,     0,     0,     0,   605,
       0,     0,     0,     0,  1302,     0,  1761,     0,     0,     0,
     605,     0,     0,     0,     0,  1022,     0,  1302,  1302,  1762,
       0,     0,     0,     0,     0,     0,   752,   752,   752,     0,
       0,     0,  1018,     0,     0,     0,     0,     0,  1302,     0,
       0,  1755,     0,     0,  1302,  1756,     0,     0,     0,     0,
    1764,     0,  1302,  1302,  1302,   605,     0,     0,  1388,     0,
    1388,  1388,     0,     0,     0,  1757,  1758,     0,     0,     0,
       0,     0,     0,     0,     0,  1562,     0,     0,  1759,     0,
   -1871,     0,     0,     0,     0,     0,  1302,     0,     0,     0,
       0,     0,     0,     0,   752,     0,     0,     0,     0,     0,
       0,     0,     0,  1956,  1562,     0,  1562,     0,     0,  1760,
       0,     0,  1761,   752,     0,     0,     0,  1765,     0,     0,
       0,  1562,     0,  1562,   605,  1762,     0,  1763,  1766,  1767,
    1768,     0,  1769,  1770,  1771,  1772,  1773,  1774,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1765,     0,     0,
       0,  1562,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,  1769,  1770,  1771,  1772,  1773,  1774,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1562,     0,     0,     0,     0,  1764,     0,     0,     0,
       0,  1557,     0,     0,     0,     0,     0,  1562,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3018,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   709,  1562,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1562,     0,     0,     0,     0,
       0,     0,     0,  1388,     0,     0,  1562,     0,   752,     0,
       0,     0,     0,  1765,     0,     0,     0,     0,     0,     0,
    1562,     0,     0,     0,  1766,  1767,  1768,     0,  1769,  1770,
    1771,  1772,  1773,  1774,     0,     0,  1022,     0,     0,     0,
    1022,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1562,    73,     0,     0,  1562,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1022,     0,     0,     0,     0,   605,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   852,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1302,     0,
       0,     0,     0,     0,  1302,     0,     0,  1562,     0,     0,
       0,   590,     0,     0,     0,     0,  1302,     0,     0,     0,
       0,     0,  1302,     0,     0,     0,  1302,     0,     0,     0,
    1562,  1302,     0,     0,  1302,  1302,  1302,  1302,  1302,  1302,
    1302,  1302,  1302,  1302,     0,     0,     0,     0,  1302,  1302,
       0,   752,     0,     0,     0,     0,     0,  1562,     0,     0,
     752,     0,  1302,     0,     0,     0,     0,     0,     0,  1302,
       0,     0,  1302,     0,  1302,     0,     0,     0,     0,     0,
       0,  1562,  1302,  1302,  1302,     0,     0,     0,  1302,     0,
       0,  1302,   852,   852,   852,     0,     0,     0,   713,   605,
     852,     0,     0,     0,   852,   852,     0,     0,   715,     0,
       0,   852,     0,     0,     0,     0,     0,     0,     0,     0,
     852,     0,   852,  1750,     0,   590,     0,     0,     0,     0,
       0,     0,     0,  1750,     0,     0,   852,  1751,   852,     0,
       0,     0,     0,     0,   749,  1753,     0,  1751,     0,     0,
    1754,     0,   590,     0,   799,  1753,     0,   803,     0,     0,
    1754,   799,     0,   590,   590,   848,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2137,     0,  1018,     0,  1557,
       0,     0,  1018,     0,     0,     0,     0,   870,     0,     0,
       0,     0,     0,   752,  1562,     0,   752,     0,     0,     0,
     605,     0,   799,     0,     0,     0,  1557,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1557,     0,     0,     0,     0,     0,     0,  1018,     0,     0,
     752,   752,     0,     0,     0,     0,     0,     0,     0,     0,
     590,   590,   752,  2717,    73,    73,     0,    73,     0,     0,
       0,     0,  1409,     0,     0,     0,     0,     0,  1755,     0,
       0,     0,  1756,  1302,  1557,     0,     0,     0,  1755,     0,
       0,     0,  1756,     0,  1562,     0,     0,     0,  1388,  1557,
       0,     0,  1757,  1758,   605,     0,     0,     0,     0,     0,
       0,  1388,  1757,  1758,     0,  1759,  1557,     0,     0,     0,
       0,     0,     0,     0,     0,  1759,     0,     0,  1562,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1557,  1022,     0,     0,     0,  1760,  1022,     0,  1761,
    1022,     0,     0,     0,     0,     0,  1760,     0,     0,  1761,
       0,     0,  1762,     0,  1763,     0,     0,     0,   590,   752,
       0,     0,  1762,     0,  1763,     0,     0,     0,     0,     0,
       0,     0,     0,  1302,  1557,     0,     0,     0,     0,     0,
       0,     0,     0,  1557,     0,     0,   981,     0,     0,     0,
       0,     0,     0,   852,     0,     0,     0,     0,     0,     0,
       0,  1388,     0,     0,  1388,  1388,     0,     0,     0,     0,
       0,     0,     0,  1764,  1302,  1302,     0,     0,   752,  1302,
    1562,     0,     0,  1764,   590,     0,  1302,  1302,     0,     0,
    1302,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   605,     0,
       0,     0,   605,     0,     0,     0,   605,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   852,     0,     0,     0,
       0,   852,     0,     0,     0,     0,     0,     0,     0,     0,
    1765,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1765,  1766,  1767,  1768,     0,  1769,  1770,  1771,  1772,  1773,
    1774,  1766,  1767,  1768,  1302,  1769,  1770,  1771,  1772,  1773,
    1774,     0,     0,  1557,     0,     0,     0,   605,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   763,     0,
       0,     0,   590,     0,     0,     0,     0,     0,     0,   764,
       0,     0,  1022,   590,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1302,   765,
     605,     0,  1022,     0,     0,     0,     0,  1562,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   766,     0,  -486,
       0,     0,     0,     0,     0,     0,  1302,     0,   590,  1302,
       0,  1409,     0,  1409,  1409,   767,     0,  1562,  1302,  1302,
     752,   768,  1302,     0,     0,     0,     0,     0,     0,  1302,
    1302,     0,     0,   769,   852,     0,     0,     0,     0,     0,
       0,     0,     0,   989,   990,     0,     0,     0,     0,     0,
       0,     0,     0,  1302,     0,     0,     0,     0,     0,     0,
       0,     0,  -613,     0,   770,     0,     0,     0,   771,     0,
       0,     0,  1022,     0,     0,     0,     0,   590,     0,     0,
       0,     0,  -599,     0,     0,     0,    73,     0,   752,     0,
      73,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -402,     0,     0,  1022,  1302,
     752,     0,     0,     0,     0,     0,   772,     0,   752,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2137,     0,
       0,     0,  1557,  1557,     0,  1302,  1302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   889,     0,     0,     0,
       0,     0,     0,   889,     0,   889,     0,     0,     0,   773,
       0,   774,     0,   852,     0,  1388,     0,     0,     0,     0,
    1036,     0,     0,  1053,     0,     0,  1057,  1058,     0,     0,
    -402,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1022,     0,     0,     0,     0,     0,     0,     0,  1097,     0,
       0,   775,     0,     0,     0,  -613,     0,   776,     0,     0,
       0,  1113,     0,     0,  1114,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1557,   981,   799,     0,     0,     0,     0,     0,   777,   778,
    1137,   779,  1562,     0,     0,     0,     0,  1557,     0,   780,
       0,     0,  1154,   781,   782,     0,  1156,  1158,   783,  1022,
     852,     0,     0,   784,     0,     0,     0,     0,     0,     0,
       0,   590,     0,     0,     0,     0,  1388,     0,     0,     0,
    1178,  1179,     0,  1388,  1388,     0,     0,   981,     0,     0,
       0,     0,     0,  1022,     0,     0,  1562,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,  1196,     0,     0,     0,   605,     0,   605,   605,     0,
       0,     0,     0,   752,     0,     0,   605,     0,     0,  2137,
       0,     0,  1388,     0,     0,     0,     0,   852,     0,   852,
     981,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2907,   605,     0,     0,     0,     0,     0,     0,     0,     0,
    1388,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   590,   605,   605,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1418,     0,     0,  1420,     0,     0,  1422,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   852,
       0,     0,     0,   590,     0,     0,     0,     0,     0,   852,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1558,     0,     0,     0,     0,  1516,     0,     0,
       0,     0,  1517,     0,     0,     0,  1519,     0,     0,     0,
       0,     0,     0,  1565,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   605,     0,   752,     0,     0,     0,     0,
       0,   752,     0,     0,     0,     0,     0,     0,  1594,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     752,     0,     0,  1557,     0,     0,     0,   590,     0,     0,
       0,     0,     0,     0,  1409,     0,    73,     0,    73,     0,
    2137,     0,     0,     0,  2137,     0,     0,     0,     0,     0,
       0,  1557,  1557,     0,  1557,     0,     0,     0,     0,     0,
       0,  1646,     0,   752,     0,   752,     0,     0,     0,  1557,
       0,  1557,     0,     0,     0,  1675,     0,  1018,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   752,     0,  1557,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1020,  2445,     0,     0,  1020,     0,     0,  1557,
       0,     0,   605,   605,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1557,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1020,     0,     0,   852,
       0,     0,     0,     0,   852,   852,   852,   852,   852,     0,
       0,     0,   852,  1557,     0,     0,     0,     0,     0,     0,
       0,   590,     0,  1557,     0,   590,     0,     0,     0,   590,
       0,     0,     0,     0,  1557,     0,     0,     0,  1020,  2521,
       0,     0,   752,   752,  1020,     0,     0,     0,  1557,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   605,     0,     0,     0,
       0,     0,     0,     0,     0,  2545,     0,     0,     0,     0,
       0,  1557,     0,     0,     0,  1557,     0,     0,     0,     0,
     590,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1558,     0,     0,   590,     0,  1557,     0,  1299,     0,     0,
       0,     0,   889,  1904,     0,   889,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1558,  1557,     0,
       0,     0,     0,     0,     0,     0,     0,  1299,     0,     0,
       0,  1558,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1557,     0,     0,     0,     0,
     752,     0,     0,     0,     0,     0,     0,     0,     0,   605,
       0,     0,     0,     0,     0,     0,     0,     0,   852,  1557,
       0,     0,     0,   752,     0,  1558,     0,     0,     0,     0,
       0,   852,     0,   752,     0,     0,     0,   605,   605,     0,
    1558,     0,   605,   605,     0,     0,     0,   605,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1558,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2137,     0,     0,     0,
       0,  2137,  1558,     0,  2137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   605,     0,
    1299,  2101,     0,     0,     0,  1020,     0,     0,     0,     0,
       0,  1020,     0,     0,     0,  1558,     0,     0,  1409,     0,
       0,     0,  1557,     0,  1558,     0,     0,     0,     0,     0,
       0,  1560,     0,     0,     0,     0,     0,     0,     0,     0,
    2147,     0,     0,     0,     0,     0,     0,  2154,     0,  2156,
    2157,     0,     0,     0,     0,     0,  1020,     0,     0,     0,
       0,     0,     0,  2166,     0,     0,   752,   752,   752,   752,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     605,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1557,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2837,     0,     0,     0,     0,     0,
       0,  2840,     0,  2841,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1557,     0,     0,     0,
     605,     0,     0,     0,     0,     0,  1299,     0,     0,     0,
       0,     0,     0,     0,  1558,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   590,     0,
     590,   590,     0,  1299,     0,     0,  1018,     0,     0,   590,
       0,     0,     0,     0,     0,  1409,     0,     0,     0,     0,
       0,     0,  2521,     0,     0,     0,  2137,  1299,  1299,     0,
    1299,     0,     0,  2905,   590,     0,     0,     0,     0,     0,
    2337,     0,     0,  1409,     0,     0,     0,     0,  1299,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1557,     0,
       0,     0,     0,     0,     0,     0,   590,   590,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   852,   852,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1018,     0,   752,     0,
       0,  1299,     0,     0,  1299,  1299,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   752,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1018,     0,   981,     0,     0,     0,     0,     0,
       0,   752,     0,     0,     0,     0,     0,     0,  2395,     0,
       0,     0,     0,     0,     0,     0,  2402,     0,     0,     0,
       0,     0,  2406,  1558,  1558,     0,     0,  2410,     0,  1560,
       0,     0,     0,   752,     0,     0,     0,   889,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1557,  1953,     0,     0,  2430,
       0,  2431,     0,     0,  2433,     0,   590,     0,     0,     0,
    1560,     0,   889,     0,  1018,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1557,     0,     0,     0,     0,
       0,     0,     0,  2452,  2453,     0,     0,     0,   889,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2468,
    2471,  2472,     0,  2476,  1560,     0,  2478,  2479,  2480,     0,
       0,  1558,  2486,     0,     0,  2489,     0,     0,     0,  1560,
       0,     0,     0,     0,     0,     0,     0,     0,  1558,     0,
       0,     0,     0,  1018,     0,     0,  1560,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1560,     0,     0,     0,     0,     0,  1018,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   590,   590,     0,     0,  1020,
       0,  1020,     0,     0,  1560,     0,  1020,     0,     0,     0,
       0,     0,     0,  1560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2521,  2521,  2521,
    2521,  2521,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1020,   981,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1299,  1299,     0,     0,  2647,     0,     0,   590,
    1299,     0,     0,  1299,  1299,     0,     0,     0,     0,     0,
    1557,     0,     0,     0,     0,  1299,  1299,     0,     0,     0,
       0,     0,     0,  1299,     0,     0,     0,  1299,  1299,  1299,
    1299,     0,     0,     0,     0,     0,     0,  1299,  1299,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1560,  1299,     0,     0,     0,  1299,     0,
       0,     0,  1299,     0,  1557,     0,  1299,     0,     0,  1299,
    1299,  1299,  1299,  1299,  1299,  1299,  1299,  1299,     0,  1299,
       0,     0,     0,     0,  1299,     0,     0,     0,  1299,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3260,   590,     0,     0,     0,     0,     0,     0,    73,
       0,     0,     0,     0,  1299,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     590,   590,     0,     0,  1558,   590,   590,  3286,     0,     0,
     590,  3290,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2812,  2813,     0,     0,
       0,     0,  1558,  1558,     0,  1558,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1558,     0,  1558,     0,     0,     0,     0,     0,     0,  2828,
    2829,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   590,     0,     0,  1299,     0,     0,     0,     0,     0,
    1558,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1953,  1560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1558,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1558,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1558,     0,     0,     0,     0,     0,
       0,     0,     0,   590,  1558,     0,  2911,  2913,  2915,     0,
       0,     0,     0,     0,     0,  1558,     0,     0,     0,     0,
       0,     0,     0,     0,  1299,     0,     0,     0,     0,  1558,
    1560,     0,     0,     0,     0,     0,     0,  1561,     0,     0,
       0,     0,     0,  2955,     0,  1299,     0,  1560,     0,     0,
       0,     0,     0,   590,     0,     0,     0,     0,   799,     0,
       0,     0,  1558,     0,     0,     0,  1558,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1023,     0,     0,     0,  1023,     0,     0,
       0,     0,  1020,     0,     0,     0,  1558,     0,     0,     0,
       0,  1299,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1023,     0,  1558,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1558,     0,     0,     0,
       0,     0,     0,     0,     0,  1299,     0,     0,     0,  1023,
       0,     0,     0,     0,     0,  1023,     0,     0,     0,     0,
    1558,     0,     0,     0,     0,     0,     0,     0,  1299,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1299,     0,     0,     0,  1299,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1299,  1299,  1299,  1299,
       0,     0,     0,     0,     0,  1299,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1299,  1299,     0,  1299,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1303,     0,
    1299,     0,  1299,     0,     0,     0,  1299,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1299,  1558,     0,     0,     0,     0,  1303,     0,
       0,     0,     0,  1020,     0,  1299,  1299,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3114,  3115,     0,
       0,     0,     0,     0,     0,     0,  1299,     0,     0,     0,
       0,     0,  1299,     0,     0,     0,     0,     0,     0,     0,
    1299,  1299,  1299,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1561,     0,     0,     0,     0,
       0,     0,     0,  1560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1558,  1299,     0,     0,     0,     0,     0,
       0,  3150,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,  1953,  1560,     0,  1560,     0,  1561,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1558,     0,  1560,
       0,  1560,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1303,     0,     0,     0,     0,  1023,     0,     0,  1560,
    1561,     0,  1023,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1561,     0,     0,     0,     0,
       0,     0,  1563,     0,     0,     0,     0,     0,     0,  1560,
       0,     0,  1561,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1560,     0,  1023,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1561,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1558,
       0,     0,     0,  1560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1560,     0,     0,     0,     0,     0,
    1561,     0,     0,     0,     0,     0,     0,     0,  1560,  1561,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1020,     0,     0,     0,  1020,     0,
    3272,     0,     0,     0,     0,     0,     0,  1303,     0,     0,
       0,  1560,     0,     0,     0,  1560,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1020,     0,     0,  1303,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1299,     0,  1303,  1303,
       0,  1303,  1299,     0,     0,  1560,     0,     0,  3324,     0,
       0,     0,     0,     0,  1299,  2955,     0,     0,     0,  1303,
    1299,     0,     0,     0,  1299,     0,  1558,     0,  1560,  1299,
       0,     0,  1299,  1299,  1299,  1299,  1299,  1299,  1299,  1299,
    1299,  1299,     0,     0,     0,     0,  1299,  1299,     0,  1561,
       0,     0,     0,     0,     0,  1560,  1558,     0,     0,     0,
    1299,     0,     0,     0,     0,     0,     0,  1299,     0,     0,
    1299,     0,  1299,     0,     0,     0,     0,     0,     0,  1560,
    1299,  1299,  1299,     0,     0,     0,  1299,     0,     0,  1299,
       0,     0,  1303,     0,     0,  1303,  1303,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1957,     0,     0,
       0,     0,  1560,     0,     0,     0,     0,     0,     0,     0,
       0,  1563,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3442,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1563,     0,     0,  1954,  1954,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1563,  1299,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1560,     0,  3464,     0,     0,  1563,     0,     0,
       0,  1558,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1281,
       0,     0,  1563,     0,     0,     0,  1560,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1020,     0,     0,     0,     0,  1020,     0,     0,  1020,  1348,
       0,     0,     0,     0,     0,  1558,     0,     0,     0,     0,
    1023,     0,  1023,     0,     0,  1563,  1561,  1023,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,     0,
       0,  1299,     0,  1561,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1023,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1299,  1299,     0,     0,     0,  1299,  1560,     0,
       0,     0,     0,     0,  1299,  1299,     0,     0,  1299,     0,
       0,     0,     0,  1303,  1303,     0,     0,     0,     0,     0,
       0,  1303,     0,     0,  1303,  1303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1303,  1303,     0,     0,
       0,     0,     0,     0,  1303,     0,     0,     0,  1303,  1303,
    1303,  1303,  1504,     0,     0,     0,     0,     0,  1303,  1303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,  1303,     0,     0,     0,  1303,
       0,     0,  1299,  1303,     0,     0,     0,  1303,     0,     0,
    1303,  1303,  1303,  1303,  1303,  1303,  1303,  1303,  1303,     0,
    1303,     0,     0,     0,     0,  1303,     0,     0,     0,  1303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1020,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1299,     0,     0,     0,
    1020,     0,     0,     0,     0,  1560,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1299,  1303,     0,  1299,     0,     0,
       0,     0,     0,     0,     0,  1560,  1299,  1299,     0,     0,
    1299,     0,     0,     0,     0,     0,     0,  1299,  1299,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1695,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1299,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1719,     0,     0,     0,     0,
    1020,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1738,
    1739,     0,  1742,     0,     0,  1303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1020,  1299,     0,     0,
    1779,     0,     0,  1957,  1563,     0,     0,     0,     0,  1561,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1299,  1299,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1954,  1954,     0,
    1954,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1561,     0,  1561,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1850,     0,     0,  1857,  1859,  1020,     0,
       0,     0,     0,     0,     0,  1561,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1303,     0,     0,     0,     0,
       0,  1563,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1561,  1303,     0,  1563,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1560,  1954,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1020,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1954,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1561,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1561,  1020,     0,  1023,  1560,     0,     0,     0,     0,     0,
       0,     0,  1303,     0,  1954,     0,  1776,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1561,     0,     0,
       0,  1561,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1303,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1776,     0,     0,     0,     0,     0,  1303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1561,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1303,     0,     0,  1561,  1303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1303,  1303,  1303,
    1303,     0,     0,     0,     0,     0,  1303,     0,     0,     0,
       0,  1561,     0,     0,     0,     0,  1303,  1303,     0,  1303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1303,     0,  1303,     0,  1561,     0,  1303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1023,     0,  1303,  1303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1303,     0,     0,
       0,     0,  2218,  1303,     0,     0,  2220,     0,     0,  1776,
       0,  1303,  1303,  1303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2242,     0,     0,     0,  2245,
       0,     0,  2255,     0,  1563,     0,     0,     0,     0,  2262,
    2267,     0,     0,     0,     0,  1303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2278,     0,  1561,     0,
    2284,     0,  1957,  1563,  2295,  1563,     0,     0,  2302,     0,
       0,  2304,  2305,  2306,  2307,  2308,  2309,  2310,  2311,  2312,
    1563,  2313,  1563,     0,     0,     0,  1281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1561,     0,
    1563,     0,     0,     0,     0,     0,  1348,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,     0,
    1776,     0,     0,     0,     0,  1563,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
       0,     0,     0,     0,  1776,     0,     0,     0,     0,     0,
    2251,     0,     0,     0,     0,  1023,  2408,     0,     0,  1023,
       0,     0,     0,  1776,  1776,     0,     0,  1776,     0,     0,
       0,     0,  1563,     0,     0,     0,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1023,     0,  1561,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1776,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1303,     0,     0,
       0,     0,     0,  1303,     0,     0,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,  1303,     0,     0,     0,     0,
       0,  1303,     0,     0,     0,  1303,     0,     0,     0,  1563,
    1303,     0,     0,  1303,  1303,  1303,  1303,  1303,  1303,  1303,
    1303,  1303,  1303,     0,     0,     0,  2494,  1303,  1303,     0,
       0,     0,     0,     0,     0,  1776,  1563,     0,     0,     0,
       0,  1303,  1776,     0,  1776,     0,     0,  2513,  1303,     0,
       0,  1303,     0,  1303,     0,     0,     0,     0,     0,     0,
    1563,  1303,  1303,  1303,     0,     0,     0,  1303,     0,     0,
    1303,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1561,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2605,     0,     0,     0,     0,     0,     0,
       0,  1561,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1563,     0,     0,     0,  1281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2658,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1303,     0,     0,     0,     0,     0,  2267,     0,
    2267,  2267,     0,  1563,     0,     0,     0,  2720,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2740,     0,  2742,     0,     0,  1563,  2745,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1023,     0,     0,     0,     0,  1023,     0,     0,  1023,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1348,     0,
       0,     0,  1303,     0,  1850,     0,     0,     0,     0,     0,
       0,     0,  1859,  1859,  1857,     0,  1561,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1303,  1303,     0,  2815,     0,  1303,  1563,
       0,     0,     0,     0,  1776,  1303,  1303,     0,     0,  1303,
       0,     0,     0,  1776,     0,  1776,     0,     0,     0,     0,
    1561,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1776,     0,     0,
    1776,     0,  2251,  2699,     0,     0,  2251,     0,     0,     0,
    1776,     0,     0,     0,     0,     0,     0,  1776,     0,     0,
       0,     0,  1776,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1776,     0,     0,     0,  2251,  2251,  1776,
       0,     0,     0,  1303,     0,     0,     0,     0,     0,     0,
    1776,     0,     0,     0,     0,     0,     0,  1776,     0,  1776,
    1776,  1776,  1776,  1776,  1776,  1776,  1776,  1776,  1776,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1023,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1303,     0,     0,
       0,  1023,     0,     0,     0,     0,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1303,     0,     0,  1303,     0,
       0,     0,     0,     0,     0,     0,  1563,  1303,  1303,     0,
       0,  1303,     0,     0,     0,     0,     0,     0,  1303,  1303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1776,     0,     0,     0,     0,     0,     0,
       0,     0,  1303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1023,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3015,     0,
       0,     0,     0,     0,  3019,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3024,  1023,  1303,     0,
       0,     0,  3025,     0,     0,     0,  3027,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1776,
       0,     0,     0,     0,  1303,  1303,     0,     0,  3044,  3045,
       0,     0,     0,     0,     0,     0,     0,     0,  1776,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,  3058,
       0,     0,  3061,     0,  3063,     0,     5,     0,     0,     0,
       0,     0,  3068,     0,     0,     6,     0,     0,  3073,     0,
       0,  3076,     0,     0,     0,     0,     7,     8,     0,  1023,
       0,     0,     9,     0,    10,    11,     0,     0,     0,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1776,  1563,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1023,     0,
       0,     0,     0,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1023,  1776,     0,  1563,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2699,
       0,  2251,     0,     0,  2251,  2251,  2251,  2251,  2251,  2251,
    2251,  2251,  2251,  2251,     0,  2699,     0,    37,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1776,    38,     0,     0,     0,
    2699,  2699,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2251,  2251,  1776,    39,  1776,     0,     0,
    1776,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    40,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1776,     0,     0,  3224,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,     0,     0,     0,  3239,
       0,     0,     0,     0,     0,     0,  3245,  3246,     0,     0,
    3248,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,  2251,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,     0,    48,    49,
       0,    50,     0,    51,     0,     0,     0,    52,    53,     0,
      54,    55,     0,     0,  3301,    56,    57,    58,    59,    60,
       0,     0,    61,    62,    63,    64,     0,    65,    66,    67,
       0,    68,    69,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3346,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1776,     0,     0,     0,  1776,     0,     0,     0,     0,  1776,
    1776,     0,  1776,     0,     0,  2699,     0,     0,     0,  2699,
    2699,  2699,  2699,  2699,  2699,  2699,  2699,  2699,  2699,  1776,
    1776,     0,  3367,     4,     0,     0,     0,     0,     0,     0,
    3369,     0,     0,  1776,  2251,  2251,  1776,     5,  1776,     0,
       0,     0,     0,  1776,  2699,  2699,     6,     0,  1776,     0,
       0,  1776,     0,  3377,     0,     0,     0,     7,     8,     0,
       0,     0,     0,     0,     0,    10,    11,     0,     0,     0,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,  3413,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,  2699,     6,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,     7,     8,
       0,     0,     0,     0,     0,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1776,
       0,     0,     0,     0,     0,     0,  2251,     0,    37,  2251,
       0,     0,  2699,  2699,  1776,     0,    36,     0,  2251,  2251,
    1776,  1776,     0,  1776,     0,     0,     0,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    39,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1776,     0,    40,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    42,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1776,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,  2699,  2251,  2251,  2699,     0,     0,
    2699,  2699,  1776,     0,  1776,     0,     0,     0,     0,     0,
       0,     0,  1776,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,    43,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,  1776,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,  2699,  2699,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,     0,    48,
      49,     0,    50,     0,    43,     0,     0,     0,    52,    53,
       0,    54,    55,     0,     0,     0,    56,    57,    58,    59,
      60,     0,     0,    61,    62,   991,     0,     0,     0,   992,
       0,     0,     0,    69,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     4,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
      48,    49,     5,    50,     0,     0,     0,     0,     0,    52,
      53,     6,    54,    55,     0,     0,     0,    56,    57,    58,
      59,    60,     7,     8,    61,    62,   991,  1402,     0,     0,
      10,    11,     0,     0,    69,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     7,     8,     0,     0,     0,     0,
      36,     0,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,    37,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    40,     0,    37,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    38,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    39,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
      43,     0,     0,     0,    48,    49,     0,    50,     0,     0,
       0,     0,     0,    52,    53,     0,    54,    55,     0,     0,
       0,    56,    57,    58,    59,    60,     0,     0,    61,    62,
     991,  1897,     0,     0,     0,     0,    44,     0,    69,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,    48,    49,     0,    50,
       0,     0,     0,     0,     0,    52,    53,     0,    54,    55,
       0,     0,     0,    56,    57,    58,    59,    60,     0,     0,
      61,    62,   991,   620,    81,    82,    83,   373,    85,    86,
      69,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,   621,   101,   102,   103,
     376,   622,     0,   105,   106,   107,   108,   623,   624,   110,
     111,   112,   113,     0,   114,   625,   626,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,   627,   394,   395,   628,   629,   630,   631,
     632,   633,   634,   396,   397,   635,   398,   132,   399,   400,
     401,   134,   135,   136,   137,     0,   636,   402,   403,     0,
     404,   405,   637,   638,   406,   639,   138,   408,   640,   409,
     410,   411,   412,   142,   641,   642,   413,   414,   415,   416,
     417,   643,   418,   419,   145,   420,   644,   421,   422,   423,
     148,   424,   645,   646,   647,   648,   649,   425,   426,   427,
     428,   429,   151,   152,   430,   650,   431,   651,   432,     0,
     433,   434,   435,   652,   436,   653,   654,   437,   438,   439,
     440,   655,   441,   442,   443,   656,   444,   657,   445,   446,
     447,   158,   448,     0,   160,   658,   449,   450,   162,   659,
     451,   660,   452,   163,   661,   164,   453,     0,   454,   662,
     455,   167,   663,   456,   664,   457,   458,   459,   460,   168,
     461,   462,   463,   665,   464,   465,   466,   467,   468,   469,
     666,   169,   170,   667,   470,   471,   472,   668,   172,   669,
     173,   670,     0,   174,   175,   473,   176,   474,   475,   476,
     477,   478,   671,   177,   178,   479,   179,   672,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,   185,   186,   673,   494,   495,
     496,   497,   498,   499,   500,   187,   501,   674,   502,   503,
     189,   504,   675,   190,   191,   505,   506,   676,   677,   507,
     678,   679,   680,   508,   509,   681,   682,   192,   193,   194,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,   683,   517,   518,   519,   520,   521,   522,   199,   523,
     524,   684,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   685,   534,   535,   205,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,   686,   544,   545,   546,   687,
     547,   211,   548,   549,   213,   550,   214,   688,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,   689,   560,
     561,   690,   562,   563,   564,   565,   691,   217,   218,   692,
     693,   567,   219,   568,   220,   694,   569,   570,   571,   572,
     573,   695,   696,   574,   575,   576,   577,   697,   698,   578,
     579,     0,     0,   228,   581,   229,   582,     0,   699,   700,
     583,   584,   585,   586,   587,   588,    81,    82,    83,   230,
      85,    86,   231,    87,    88,    89,     0,     0,     0,    92,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,     0,     0,     0,   105,   106,   107,   108,   701,
     109,   110,   111,   112,   113,     0,   114,   115,   116,   117,
       0,     0,     0,     0,     0,   120,   121,     0,     0,     0,
       0,   122,     0,     0,     0,     0,     0,     0,     0,     0,
     123,     0,   124,     0,   125,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   132,
       0,     0,     0,   134,   135,   136,   137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   138,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   145,     0,     0,     0,
       0,     0,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   158,     0,     0,   160,     0,     0,     0,
     162,     0,     0,     0,     0,   163,     0,   164,     0,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   169,   170,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,   174,   175,     0,   176,     0,
       0,     0,     0,     0,     0,   177,   178,     0,   179,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   184,   185,   186,     0,
       0,     0,     0,     0,     0,     0,     0,   187,     0,     0,
       0,     0,   189,     0,     0,   190,   191,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   192,
     193,   194,   195,     0,     0,     0,     0,     0,   196,   197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,   207,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   213,     0,   214,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   216,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
     218,     0,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   228,     0,   229,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   230,     0,     0,   231,    81,    82,    83,     0,    85,
      86,     0,    87,    88,    89,     0,     0,     0,    92,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,     0,  2373,     0,   105,   106,   107,   108,     0,   109,
     110,   111,   112,   113,     0,   114,   115,   116,   117,     0,
       0,     0,     0,     0,   120,   121,     0,     0,     0,     0,
     122,     0,     0,     0,     0,     0,     0,     0,     0,   123,
       0,   124,     0,   125,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   132,     0,
       0,     0,   134,   135,   136,   137,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   138,     0,     0,
       0,     0,     0,     0,   142,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   151,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   158,     0,     0,   160,     0,     0,     0,   162,
       0,     0,     0,     0,   163,     0,   164,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   169,   170,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,   174,   175,     0,   176,     0,     0,
       0,     0,     0,     0,   177,   178,     0,   179,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   184,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,   187,     0,     0,     0,
       0,   189,     0,     0,   190,   191,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   192,   193,
     194,   195,     0,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   199,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,     0,     0,   207,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   213,     0,   214,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   216,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,   218,
       0,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,   223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     230,    80,     0,   231,    81,    82,    83,    84,    85,    86,
       0,    87,    88,    89,    90,     0,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     104,  2375,     0,   105,   106,   107,   108,     0,   109,   110,
     111,   112,   113,     0,   114,   115,   116,   117,   118,   119,
       0,     0,     0,   120,   121,     0,     0,     0,     0,   122,
       0,     0,     0,     0,     0,     0,     0,     0,   123,     0,
     124,     0,   125,   126,     0,   127,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   128,   129,   130,     0,     0,
       0,     0,     0,     0,     0,     0,   131,   132,     0,     0,
     133,   134,   135,   136,   137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   138,     0,     0,   139,
       0,   140,   141,   142,     0,     0,   143,   144,     0,     0,
       0,     0,     0,     0,   145,   146,   147,     0,     0,     0,
     148,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,   150,   151,   152,   153,     0,     0,     0,     0,     0,
     154,     0,     0,     0,     0,     0,     0,     0,     0,   155,
       0,     0,     0,     0,     0,   156,     0,     0,     0,     0,
     157,   158,   159,     0,   160,     0,   161,     0,   162,     0,
       0,     0,     0,   163,     0,   164,     0,   165,     0,   166,
       0,   167,     0,     0,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   169,   170,     0,     0,   171,     0,     0,   172,     0,
     173,     0,     0,   174,   175,     0,   176,     0,     0,     0,
       0,     0,     0,   177,   178,     0,   179,     0,   180,   181,
       0,     0,     0,     0,   182,     0,     0,     0,     0,     0,
       0,     0,   183,     0,   184,   185,   186,     0,     0,     0,
       0,     0,     0,     0,     0,   187,     0,     0,     0,   188,
     189,     0,     0,   190,   191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   192,   193,   194,
     195,     0,     0,     0,     0,     0,   196,   197,     0,   198,
       0,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,    80,     0,   203,     0,
       0,     0,    84,   204,   205,     0,   206,   207,     0,    90,
     208,    91,     0,     0,    94,   209,     0,     0,     0,     0,
     210,   211,     0,   212,   213,   104,   214,     0,     0,   215,
       0,     0,     0,     0,     0,     0,   216,     0,     0,     0,
       0,     0,     0,   118,   119,     0,     0,   217,   218,     0,
       0,     0,   219,     0,   220,     0,   221,     0,   222,     0,
       0,   223,     0,     0,   224,     0,   225,     0,     0,   226,
     127,     0,   227,   228,     0,   229,     0,     0,     0,     0,
     128,   129,   130,     0,     0,     0,     0,     0,     0,   230,
       0,     0,   231,     0,     0,   938,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   139,   232,   140,   141,     0,     0,
       0,   143,   144,     0,     0,     0,     0,     0,     0,     0,
     146,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,     0,   150,     0,     0,   153,
       0,     0,     0,     0,     0,   154,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,     0,     0,     0,
     156,     0,     0,     0,     0,   157,     0,   159,     0,     0,
       0,   161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,     0,   166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,     0,     0,     0,   182,
       0,     0,     0,     0,     0,     0,     0,   183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   198,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,     0,   201,     0,   202,
       0,     0,     0,   203,     0,     0,     0,     0,   204,     0,
       0,   206,     0,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   210,     0,     0,   212,     0,
       0,     0,     0,     0,   215,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221,     0,   222,     0,     0,     0,     0,     0,   224,
       0,   225,     0,     0,   226,     0,     0,   227,     0,     0,
     620,    81,    82,    83,   373,    85,    86,     0,    87,    88,
      89,   374,     0,   375,     0,    93,     0,    95,    96,    97,
      98,    99,   100,   621,   101,   102,   103,   376,   622,     0,
     105,   106,   107,   108,   623,   624,   110,   111,   112,   113,
     232,   114,   625,   626,   117,   377,   378,     0,     0,     0,
     379,   380,     0,     0,     0,     0,   381,     0,     0,     0,
       0,     0,     0,     0,     0,   382,     0,   383,     0,   384,
     385,     0,   386,   387,   388,   389,   390,   391,   392,   393,
    2332,   394,   395,     0,     0,     0,     0,  1209,     0,     0,
     396,   397,     0,   398,   132,   399,   400,   401,   134,  1210,
     136,  1211,  1212,     0,   402,   403,     0,   404,   405,  1213,
    1214,   406,  1215,  1216,   408,     0,   409,   410,   411,   412,
    1217,     0,     0,   413,   414,   415,   416,   417,     0,   418,
     419,  1218,   420,     0,   421,   422,   423,   148,   424,  1219,
    1220,  1221,  1222,  1223,   425,   426,   427,   428,   429,  1224,
    1225,   430,     0,   431,     0,   432,     0,   433,   434,   435,
       0,   436,  2333,     0,   437,  1226,   439,   440,     0,   441,
     442,   443,     0,   444,     0,   445,   446,   447,  1227,   448,
       0,  1228,  1229,   449,   450,  1230,     0,   451,     0,   452,
     163,     0,   164,   453,     0,   454,     0,   455,  1231,     0,
     456,     0,   457,   458,   459,   460,   168,   461,   462,   463,
       0,   464,   465,   466,   467,   468,   469,     0,   169,   170,
       0,   470,   471,   472,  1232,  1233,     0,  1234,     0,     0,
     174,   175,   473,   176,   474,   475,   476,   477,   478,     0,
    1235,   178,   479,   179,     0,   480,   481,   482,  1236,  1237,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,  1238,   185,  1239,   750,   494,   495,   496,   497,   498,
     499,   500,   187,   501,  1240,   502,   503,   189,   504,  1241,
    1242,  1243,   505,   506,     0,     0,   507,   751,     0,     0,
    1244,   509,     0,     0,   192,   193,   194,  1245,   510,   511,
     512,   513,     0,  1246,   197,   514,   515,   516,     0,   517,
     518,   519,   520,   521,   522,  1247,   523,   524,     0,   525,
     526,   527,   528,   529,   530,   531,   532,   533,     0,   534,
     535,   205,   536,   537,  1248,   538,   539,   540,   541,   542,
     543,     0,     0,   544,   545,   546,  1249,   547,   211,   548,
     549,   213,   550,  1250,     0,   551,   552,   553,   554,   555,
     556,   557,   558,  1251,   559,     0,   560,   561,     0,   562,
     563,   564,   565,     0,  1252,  1253,     0,     0,   567,  1254,
     568,  1255,  1256,   569,   570,   571,   572,   573,     0,  1257,
     574,   575,   576,   577,  1258,     0,   578,   579,     0,   580,
    1259,   581,   229,   582,     0,     0,     0,   583,   584,   585,
     586,   587,   588,     0,     0,     0,   230,    49,  1260,   231,
     589,     0,     0,  1261,  1262,    52,    53,  1263,    54,     0,
       0,     0,     0,  1264,  1265,  2334,     0,     0,     0,     0,
       0,     0,  1267,  2335,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,  1209,     0,     0,   396,   397,     0,   398,   132,   399,
     400,   401,   134,  1210,   136,  1211,  1212,     0,   402,   403,
       0,   404,   405,  1213,  1214,   406,  1215,  1216,   408,     0,
     409,   410,   411,   412,  1217,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,  1218,   420,     0,   421,   422,
     423,   148,   424,  1219,  1220,  1221,  1222,  1223,   425,   426,
     427,   428,   429,  1224,  1225,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,  1227,   448,     0,  1228,  1229,   449,   450,  1230,
       0,   451,     0,   452,   163,     0,   164,   453,     0,   454,
       0,   455,  1231,     0,   456,     0,   457,   458,   459,   460,
     168,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,   169,   170,     0,   470,   471,   472,  1232,  1233,
       0,  1234,     0,     0,   174,   175,   473,   176,   474,   475,
     476,   477,   478,     0,  1235,   178,   479,   179,     0,   480,
     481,   482,  1236,  1237,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1238,   185,  1239,   750,   494,
     495,   496,   497,   498,   499,   500,   187,   501,  1240,   502,
     503,   189,   504,  1241,  1242,  1243,   505,   506,     0,     0,
     507,   751,     0,     0,  1244,   509,     0,     0,   192,   193,
     194,  1245,   510,   511,   512,   513,     0,  1246,   197,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1247,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,   205,   536,   537,  1248,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
    1249,   547,   211,   548,   549,   213,   550,  1250,     0,   551,
     552,   553,   554,   555,   556,   557,   558,  1251,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1252,  1253,
       0,     0,   567,  1254,   568,  1255,  1256,   569,   570,   571,
     572,   573,     0,  1257,   574,   575,   576,   577,  1258,     0,
     578,   579,     0,   580,  1259,   581,   229,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,    49,  1260,   231,   589,     0,     0,  1261,  1262,    52,
      53,  1263,    54,     0,     0,     0,     0,  1264,  1265,     0,
       0,     0,     0,     0,     0,     0,  1267,  2253,   620,    81,
      82,    83,   373,    85,    86,     0,    87,    88,    89,   374,
       0,   375,     0,    93,     0,    95,    96,    97,    98,    99,
     100,   621,   101,   102,   103,   376,   622,     0,   105,   106,
     107,   108,   623,   624,   110,   111,   112,   113,     0,   114,
     625,   626,   117,   377,   378,     0,     0,     0,   379,   380,
       0,     0,     0,     0,   381,     0,     0,     0,     0,     0,
       0,     0,     0,   382,     0,   383,     0,   384,   385,     0,
     386,   387,   388,   389,   390,   391,   392,   393,     0,   394,
     395,     0,     0,     0,     0,     0,     0,     0,   396,   397,
       0,   398,   132,   399,   400,   401,   134,  1530,   136,  1531,
    1212,     0,   402,   403,     0,   404,   405,     0,     0,   406,
    1532,  1533,   408,     0,   409,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,   417,     0,   418,   419,     0,
     420,     0,   421,   422,   423,   148,   424,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,  1534,  1535,   430,
       0,   431,     0,   432,     0,   433,   434,   435,     0,   436,
       0,     0,   437,  1226,   439,   440,     0,   441,   442,   443,
       0,   444,     0,   445,   446,   447,     0,   448,     0,     0,
       0,   449,   450,  1536,     0,   451,     0,   452,   163,     0,
     164,   453,     0,   454,     0,   455,     0,     0,   456,     0,
     457,   458,   459,   460,   168,   461,   462,   463,  1943,   464,
     465,   466,   467,   468,   469,     0,   169,  1944,     0,   470,
     471,   472,  1232,  1537,     0,  1538,     0,     0,   174,   175,
     473,   176,   474,   475,   476,   477,   478,     0,     0,   178,
     479,   179,     0,   480,   481,   482,     0,     0,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,  1539,
     185,  1540,     0,   494,   495,   496,   497,   498,   499,   500,
       0,   501,     0,   502,   503,   189,   504,     0,     0,  1541,
     505,   506,     0,     0,   507,     0,     0,     0,   508,   509,
       0,     0,  1945,   193,   194,     0,   510,   511,   512,   513,
       0,     0,     0,   514,   515,   516,     0,   517,   518,   519,
     520,   521,   522,  1542,   523,   524,     0,   525,   526,   527,
     528,   529,   530,   531,   532,   533,     0,   534,   535,   205,
     536,   537,     0,   538,   539,   540,   541,   542,   543,     0,
       0,   544,   545,   546,     0,   547,  1543,   548,   549,   213,
     550,  1544,     0,   551,   552,   553,   554,   555,   556,   557,
     558,     0,   559,     0,   560,   561,     0,   562,   563,   564,
     565,     0,  1545,  1546,     0,     0,   567,     0,   568,     0,
       0,   569,   570,   571,   572,   573,     0,     0,   574,   575,
     576,   577,     0,     0,   578,   579,     0,     0,  1547,   581,
     229,   582,     0,     0,     0,   583,   584,   585,   586,   587,
     588,     0,     0,     0,   230,     0,     0,   231,     0,    81,
      82,    83,   373,    85,    86,     0,    87,    88,    89,   374,
       0,   375,     0,    93,     0,    95,    96,    97,    98,    99,
     100,  1946,   101,   102,   103,   376,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   117,   377,   378,     0,     0,     0,   379,   380,
       0,     0,     0,     0,   381,     0,     0,     0,     0,     0,
       0,     0,     0,   382,     0,   383,     0,   384,   385,     0,
     386,   387,   388,   389,   390,   391,   392,   393,     0,   394,
     395,     0,     0,     0,     0,     0,     0,     0,   396,   397,
       0,   398,     0,   399,   400,   401,     0,   135,     0,   137,
       0,     0,   402,   403,     0,   404,   405,     0,     0,   406,
     407,   138,   408,     0,   409,   410,   411,   412,   142,     0,
       0,   413,   414,   415,   416,   417,     0,   418,   419,   145,
     420,     0,   421,   422,   423,     0,   424,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   151,   152,   430,
       0,   431,     0,   432,     0,   433,   434,   435,     0,   436,
       0,     0,   437,   438,   439,   440,     0,   441,   442,   443,
       0,   444,     0,   445,   446,   447,   158,   448,     0,   160,
       0,   449,   450,   162,     0,   451,     0,   452,     0,     0,
       0,   453,     0,   454,     0,   455,   167,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,   463,     0,   464,
     465,   466,   467,   468,   469,     0,     0,   170,     0,   470,
     471,   472,     0,   172,     0,   173,     0,     0,     0,     0,
     473,     0,   474,   475,   476,   477,   478,     0,   177,     0,
     479,     0,     0,   480,   481,   482,     0,     0,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   184,
       0,   186,     0,   494,   495,   496,   497,   498,   499,   500,
     187,   501,     0,   502,   503,     0,   504,     0,   190,   191,
     505,   506,     0,     0,   507,     0,     0,     0,   508,   509,
       0,     0,   192,     0,     0,   195,   510,   511,   512,   513,
       0,   196,   197,   514,   515,   516,     0,   517,   518,   519,
     520,   521,   522,   199,   523,   524,     0,   525,   526,   527,
     528,   529,   530,   531,   532,   533,     0,   534,   535,     0,
     536,   537,   207,   538,   539,   540,   541,   542,   543,     0,
       0,   544,   545,   546,     0,   547,   211,   548,   549,     0,
     550,   214,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   216,   559,     0,   560,   561,     0,   562,   563,   564,
     565,     0,   217,   218,     0,     0,   567,   219,   568,   220,
       0,   569,   570,   571,   572,   573,     0,     0,   574,   575,
     576,   577,     0,  3416,   578,   579,     0,   580,   228,   581,
       0,   582,     0,     0,     0,   583,   584,   585,   586,   587,
     588,     0,     0,     0,   230,     0,     0,   231,     0,     0,
       0,     0,     0,     0,     0,     0,   620,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374, -1299,   375,
       0,    93, -1299,    95,    96,    97,    98,    99,   100,   621,
     101,   102,   103,   376,   622,     0,   105,   106,   107,   108,
     623,   624,   110,   111,   112,   113,     0,   114,   625,   626,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,     0,   394,   395,     0,
       0,     0,     0,  1209,     0,     0,   396,   397,     0,   398,
     132,   399,   400,   401,   134,  1210,   136,  1211,  1212,  2263,
     402,   403,     0,   404,   405,  1213,  1214,   406,  1215,  1216,
     408,     0,   409,   410,   411,   412,  1217,     0,     0,   413,
     414,   415,   416,   417,     0,   418,   419,  1218,   420,     0,
     421,   422,   423,   148,   424,  1219,  1220,  1221,  1222,  1223,
     425,   426,   427,   428,   429,  1224,  1225,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,  1226,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,  1227,   448,     0,  1228,  1229,   449,
     450,  1230,     0,   451,     0,   452,   163,  2264,   164,   453,
       0,   454,     0,   455,  1231,     0,   456,     0,   457,   458,
     459,   460,   168,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,   169,   170,     0,   470,   471,   472,
    1232,  1233,     0,  1234,     0,     0,   174,   175,   473,   176,
     474,   475,   476,   477,   478,  2265,  1235,   178,   479,   179,
       0,   480,   481,   482,  1236,  1237,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,  1238,   185,  1239,
     750,   494,   495,   496,   497,   498,   499,   500,   187,   501,
    1240,   502,   503,   189,   504,  1241,  1242,  1243,   505,   506,
       0,     0,   507,   751,     0,     0,  1244,   509,     0,     0,
     192,   193,   194,  1245,   510,   511,   512,   513,     0,  1246,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,  1247,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,   205,   536,   537,
    1248,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   546,  1249,   547,   211,   548,   549,   213,   550,  1250,
       0,   551,   552,   553,   554,   555,   556,   557,   558,  1251,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
    1252,  1253,     0,  2266,   567,  1254,   568,  1255,  1256,   569,
     570,   571,   572,   573,     0,  1257,   574,   575,   576,   577,
    1258,     0,   578,   579,     0,   580,  1259,   581,   229,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,    49,  1260,   231,   589,     0,     0,  1261,
    1262,    52,    53,  1263,    54,     0,     0,     0,     0,  1264,
    1265,   620,    81,    82,    83,   373,    85,    86,  1267,    87,
      88,    89,   374,     0,   375,     0,    93,     0,    95,    96,
      97,    98,    99,   100,   621,   101,   102,   103,   376,   622,
       0,   105,   106,   107,   108,   623,   624,   110,   111,   112,
     113,     0,   114,   625,   626,   117,   377,   378,     0,     0,
       0,   379,   380,     0,     0,     0,     0,   381,     0,     0,
       0,     0,     0,     0,     0,     0,   382,     0,   383,     0,
     384,   385,     0,   386,   387,   388,   389,   390,   391,   392,
     393,     0,   394,   395,     0,     0,     0,     0,  1209,     0,
       0,   396,   397,     0,   398,   132,   399,   400,   401,   134,
    1210,   136,  1211,  1212,     0,   402,   403,     0,   404,   405,
    1213,  1214,   406,  1215,  1216,   408,     0,   409,   410,   411,
     412,  1217,     0,     0,   413,   414,   415,   416,   417,     0,
     418,   419,  1218,   420,     0,   421,   422,   423,   148,   424,
    1219,  1220,  1221,  1222,  1223,   425,   426,   427,   428,   429,
    1224,  1225,   430,     0,   431,     0,   432,     0,   433,   434,
     435,     0,   436,     0,     0,   437,  1226,   439,   440,     0,
     441,   442,   443,     0,   444,     0,   445,   446,   447,  1227,
     448,     0,  1228,  1229,   449,   450,  1230,     0,   451,     0,
     452,   163,     0,   164,   453,     0,   454,     0,   455,  1231,
       0,   456,     0,   457,   458,   459,   460,   168,   461,   462,
     463,     0,   464,   465,   466,   467,   468,   469,     0,   169,
     170,     0,   470,   471,   472,  1232,  1233,     0,  1234,     0,
       0,   174,   175,   473,   176,   474,   475,   476,   477,   478,
       0,  1235,   178,   479,   179,     0,   480,   481,   482,  1236,
    1237,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,  1238,   185,  1239,   750,   494,   495,   496,   497,
     498,   499,   500,   187,   501,  1240,   502,   503,   189,   504,
    1241,  1242,  1243,   505,   506,     0,     0,   507,   751,     0,
       0,  1244,   509,     0,     0,   192,   193,   194,  1245,   510,
     511,   512,   513,     0,  1246,   197,   514,   515,   516,     0,
     517,   518,   519,   520,   521,   522,  1247,   523,   524,     0,
     525,   526,   527,   528,   529,   530,   531,   532,   533,     0,
     534,   535,   205,   536,   537,  1248,   538,   539,   540,   541,
     542,   543,     0,     0,   544,   545,   546,  1249,   547,   211,
     548,   549,   213,   550,  1250,     0,   551,   552,   553,   554,
     555,   556,   557,   558,  1251,   559,     0,   560,   561,     0,
     562,   563,   564,   565,     0,  1252,  1253,     0,     0,   567,
    1254,   568,  1255,  1256,   569,   570,   571,   572,   573,     0,
    1257,   574,   575,   576,   577,  1258,     0,   578,   579,     0,
     580,  1259,   581,   229,   582,     0,     0,     0,   583,   584,
     585,   586,   587,   588,     0,     0,     0,   230,    49,  1260,
     231,   589,     0,     0,  1261,  1262,    52,    53,  1263,    54,
       0,     0,     0,     0,  1264,  1265,  1266,     0,     0,     0,
       0,     0,     0,  1267,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,  1209,     0,     0,   396,   397,     0,   398,   132,   399,
     400,   401,   134,  1210,   136,  1211,  1212,     0,   402,   403,
       0,   404,   405,  1213,  1214,   406,  1215,  1216,   408,     0,
     409,   410,   411,   412,  1217,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,  1218,   420,     0,   421,   422,
     423,   148,   424,  1219,  1220,  1221,  1222,  1223,   425,   426,
     427,   428,   429,  1224,  1225,   430,  1347,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,  1227,   448,     0,  1228,  1229,   449,   450,  1230,
       0,   451,     0,   452,   163,     0,   164,   453,     0,   454,
       0,   455,  1231,     0,   456,     0,   457,   458,   459,   460,
     168,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,   169,   170,     0,   470,   471,   472,  1232,  1233,
       0,  1234,     0,     0,   174,   175,   473,   176,   474,   475,
     476,   477,   478,     0,  1235,   178,   479,   179,     0,   480,
     481,   482,  1236,  1237,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1238,   185,  1239,   750,   494,
     495,   496,   497,   498,   499,   500,   187,   501,  1240,   502,
     503,   189,   504,  1241,  1242,  1243,   505,   506,     0,     0,
     507,   751,     0,     0,  1244,   509,     0,     0,   192,   193,
     194,  1245,   510,   511,   512,   513,     0,  1246,   197,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1247,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,   205,   536,   537,  1248,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
    1249,   547,   211,   548,   549,   213,   550,  1250,     0,   551,
     552,   553,   554,   555,   556,   557,   558,  1251,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1252,  1253,
       0,     0,   567,  1254,   568,  1255,  1256,   569,   570,   571,
     572,   573,     0,  1257,   574,   575,   576,   577,  1258,     0,
     578,   579,     0,   580,  1259,   581,   229,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,    49,  1260,   231,   589,     0,     0,  1261,  1262,    52,
      53,  1263,    54,     0,     0,     0,     0,  1264,  1265,   620,
      81,    82,    83,   373,    85,    86,  1267,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,   621,   101,   102,   103,   376,   622,     0,   105,
     106,   107,   108,   623,   624,   110,   111,   112,   113,     0,
     114,   625,   626,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,  1209,     0,     0,   396,
     397,     0,   398,   132,   399,   400,   401,   134,  1210,   136,
    1211,  1212,     0,   402,   403,     0,   404,   405,  1213,  1214,
     406,  1215,  1216,   408,     0,   409,   410,   411,   412,  1217,
       0,     0,   413,   414,   415,   416,   417,     0,   418,   419,
    1218,   420,     0,   421,   422,   423,   148,   424,  1219,  1220,
    1221,  1222,  1223,   425,   426,   427,   428,   429,  1224,  1225,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,  1226,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,  1227,   448,     0,
    1228,  1229,   449,   450,  1230,     0,   451,     0,   452,   163,
       0,   164,   453,     0,   454,     0,   455,  1231,     0,   456,
       0,   457,   458,   459,   460,   168,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,   169,   170,     0,
     470,   471,   472,  1232,  1233,     0,  1234,     0,     0,   174,
     175,   473,   176,   474,   475,   476,   477,   478,     0,  1235,
     178,   479,   179,     0,   480,   481,   482,  1236,  1237,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
    1238,   185,  1239,   750,   494,   495,   496,   497,   498,   499,
     500,   187,   501,  1240,   502,   503,   189,   504,  1241,  1242,
    1243,   505,   506,     0,     0,   507,   751,     0,     0,  1244,
     509,     0,     0,   192,   193,   194,  1245,   510,   511,   512,
     513,     0,  1246,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,  1247,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
     205,   536,   537,  1248,   538,   539,   540,   541,   542,   543,
       0,   209,   544,   545,   546,  1249,   547,   211,   548,   549,
     213,   550,  1250,     0,   551,   552,   553,   554,   555,   556,
     557,   558,  1251,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,  1252,  1253,     0,     0,   567,  1254,   568,
    1255,  1256,   569,   570,   571,   572,   573,     0,  1257,   574,
     575,   576,   577,  1258,     0,   578,   579,     0,  1740,  1259,
     581,   229,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,    49,  1260,   231,   589,
       0,     0,  1261,  1262,    52,    53,  1263,    54,     0,     0,
       0,     0,  1264,  1265,   620,    81,    82,    83,   373,    85,
      86,  1267,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,  1855,   394,   395,     0,     0,     0,
       0,  1209,     0,     0,   396,   397,     0,   398,   132,   399,
     400,   401,   134,  1210,   136,  1211,  1212,     0,   402,   403,
       0,   404,   405,  1213,  1214,   406,  1215,  1216,   408,     0,
     409,   410,   411,   412,  1217,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,  1218,   420,     0,   421,   422,
     423,   148,   424,  1219,  1220,  1221,  1222,  1223,   425,   426,
     427,   428,   429,  1224,  1225,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,  1227,   448,     0,  1228,  1229,   449,   450,  1230,
       0,   451,     0,   452,   163,     0,   164,   453,     0,   454,
       0,   455,  1231,     0,   456,     0,   457,   458,   459,   460,
     168,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,   169,   170,     0,   470,   471,   472,  1232,  1233,
       0,  1234,     0,     0,   174,   175,   473,   176,   474,   475,
     476,   477,   478,     0,  1235,   178,   479,   179,     0,   480,
     481,   482,  1236,  1237,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1238,   185,  1239,   750,   494,
     495,   496,   497,   498,   499,   500,   187,   501,  1240,   502,
     503,   189,   504,  1241,  1242,  1243,   505,   506,     0,     0,
     507,   751,     0,     0,  1244,   509,     0,     0,   192,   193,
     194,  1245,   510,   511,   512,   513,     0,  1246,   197,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1247,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,   205,   536,   537,  1248,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
    1249,   547,   211,   548,   549,   213,   550,  1250,     0,   551,
     552,   553,   554,   555,   556,   557,   558,  1251,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1252,  1253,
       0,     0,   567,  1254,   568,  1255,  1256,   569,   570,   571,
     572,   573,     0,  1257,   574,   575,   576,   577,  1258,     0,
     578,   579,     0,   580,  1259,   581,   229,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,    49,  1260,   231,   589,     0,     0,  1261,  1262,    52,
      53,  1263,    54,     0,     0,     0,     0,  1264,  1265,   620,
      81,    82,    83,   373,    85,    86,  1267,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,   621,   101,   102,   103,   376,   622,     0,   105,
     106,   107,   108,   623,   624,   110,   111,   112,   113,     0,
     114,   625,   626,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,  1209,     0,     0,   396,
     397,     0,   398,   132,   399,   400,   401,   134,  1210,   136,
    1211,  1212,     0,   402,   403,     0,   404,   405,  1213,  1214,
     406,  1215,  1216,   408,     0,   409,   410,   411,   412,  1217,
       0,     0,   413,   414,   415,   416,   417,     0,   418,   419,
    1218,   420,     0,   421,   422,   423,   148,   424,  1219,  1220,
    1221,  1222,  1223,   425,   426,   427,   428,   429,  1224,  1225,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,  1226,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,  1227,   448,     0,
    1228,  1229,   449,   450,  1230,     0,   451,     0,   452,   163,
       0,   164,   453,     0,   454,     0,   455,  1231,     0,   456,
       0,   457,   458,   459,   460,   168,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,   169,   170,     0,
     470,   471,   472,  1232,  1233,     0,  1234,     0,     0,   174,
     175,   473,   176,   474,   475,   476,   477,   478,     0,  1235,
     178,   479,   179,     0,   480,   481,   482,  1236,  1237,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
    1238,   185,  1239,   750,   494,   495,   496,   497,   498,   499,
     500,   187,   501,  1240,   502,   503,   189,   504,  1241,  1242,
    1243,   505,   506,     0,     0,   507,   751,     0,     0,  1244,
     509,     0,     0,   192,   193,   194,  1245,   510,   511,   512,
     513,     0,  1246,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,  1247,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
     205,   536,   537,  1248,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   546,  1249,   547,   211,   548,   549,
     213,   550,  1250,     0,   551,   552,   553,   554,   555,   556,
     557,   558,  1251,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,  1252,  1253,     0,     0,   567,  1254,   568,
    1255,  1256,   569,   570,   571,   572,   573,     0,  1257,   574,
     575,   576,   577,  1258,     0,   578,   579,     0,   580,  1259,
     581,   229,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,    49,  1260,   231,   589,
       0,     0,  1261,  1262,    52,    53,  1263,    54,     0,     0,
       0,     0,  1264,  1265,     0,     0,     0,     0,     0,  1690,
       0,  1267,   620,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,   621,   101,   102,   103,   376,
     622,     0,   105,   106,   107,   108,   623,   624,   110,   111,
     112,   113,     0,   114,   625,   626,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,  1209,
       0,     0,   396,   397,     0,   398,   132,   399,   400,   401,
     134,  1210,   136,  1211,  1212,     0,   402,   403,     0,   404,
     405,  1213,  1214,   406,  1215,  1216,   408,     0,   409,   410,
     411,   412,  1217,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,  1218,   420,     0,   421,   422,   423,   148,
     424,  1219,  1220,  1221,  1222,  1223,   425,   426,   427,   428,
     429,  1224,  1225,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,  1226,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
    1227,   448,     0,  1228,  1229,   449,   450,  1230,     0,   451,
       0,   452,   163,  2264,   164,   453,     0,   454,     0,   455,
    1231,     0,   456,     0,   457,   458,   459,   460,   168,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
     169,   170,     0,   470,   471,   472,  1232,  1233,     0,  1234,
       0,     0,   174,   175,   473,   176,   474,   475,   476,   477,
     478,     0,  1235,   178,   479,   179,     0,   480,   481,   482,
    1236,  1237,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,  1238,   185,  1239,   750,   494,   495,   496,
     497,   498,   499,   500,   187,   501,  1240,   502,   503,   189,
     504,  1241,  1242,  1243,   505,   506,     0,     0,   507,   751,
       0,     0,  1244,   509,     0,     0,   192,   193,   194,  1245,
     510,   511,   512,   513,     0,  1246,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,  1247,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,   205,   536,   537,  1248,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,  1249,   547,
     211,   548,   549,   213,   550,  1250,     0,   551,   552,   553,
     554,   555,   556,   557,   558,  1251,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,  1252,  1253,     0,     0,
     567,  1254,   568,  1255,  1256,   569,   570,   571,   572,   573,
       0,  1257,   574,   575,   576,   577,  1258,     0,   578,   579,
       0,   580,  1259,   581,   229,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,    49,
    1260,   231,   589,     0,     0,  1261,  1262,    52,    53,  1263,
      54,     0,     0,     0,     0,  1264,  1265,   620,    81,    82,
      83,   373,    85,    86,  1267,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     621,   101,   102,   103,   376,   622,     0,   105,   106,   107,
     108,   623,   624,   110,   111,   112,   113,     0,   114,   625,
     626,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,  1209,     0,     0,   396,   397,     0,
     398,   132,   399,   400,   401,   134,  1210,   136,  1211,  1212,
       0,   402,   403,     0,   404,   405,  1213,  1214,   406,  1215,
    1216,   408,     0,   409,   410,   411,   412,  1217,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,  1218,   420,
       0,   421,   422,   423,   148,   424,  1219,  1220,  1221,  1222,
    1223,   425,   426,   427,   428,   429,  1224,  1225,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,  1226,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,  1227,   448,     0,  1228,  1229,
     449,   450,  1230,     0,   451,     0,   452,   163,     0,   164,
     453,     0,   454,     0,   455,  1231,     0,   456,     0,   457,
     458,   459,   460,   168,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,   169,   170,     0,   470,   471,
     472,  1232,  1233,     0,  1234,     0,     0,   174,   175,   473,
     176,   474,   475,   476,   477,   478,     0,  1235,   178,   479,
     179,     0,   480,   481,   482,  1236,  1237,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,  1238,   185,
    1239,   750,   494,   495,   496,   497,   498,   499,   500,   187,
     501,  1240,   502,   503,   189,   504,  1241,  1242,  1243,   505,
     506,     0,     0,   507,   751,     0,     0,  1244,   509,     0,
       0,   192,   193,   194,  1245,   510,   511,   512,   513,     0,
    1246,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,  1247,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,   205,   536,
     537,  1248,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,  1249,   547,   211,   548,   549,   213,   550,
    1250,     0,   551,   552,   553,   554,   555,   556,   557,   558,
    1251,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,  1252,  1253,     0,     0,   567,  1254,   568,  1255,  1256,
     569,   570,   571,   572,   573,     0,  1257,   574,   575,   576,
     577,  1258,     0,   578,   579,     0,   580,  1259,   581,   229,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,    49,  1260,   231,   589,     0,     0,
    1261,  1262,    52,    53,  1263,    54,     0,     0,     0,     0,
    1264,  1265,   620,    81,    82,    83,   373,    85,    86,  1267,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,   621,   101,   102,   103,   376,
     622,     0,   105,   106,   107,   108,   623,   624,   110,   111,
     112,   113,     0,   114,   625,   626,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,  1209,
       0,     0,   396,   397,     0,   398,   132,   399,   400,   401,
     134,  1210,   136,  1211,  1212,     0,   402,   403,     0,   404,
     405,  1213,  1214,   406,  1215,  1216,   408,     0,   409,   410,
     411,   412,  1217,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,  1218,   420,     0,   421,   422,   423,   148,
     424,  1219,  1220,  1221,  1222,  1223,   425,   426,   427,   428,
     429,  1224,  1225,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,  1226,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
    1227,   448,     0,  1228,  1229,   449,   450,  1230,     0,   451,
       0,   452,   163,     0,   164,   453,     0,   454,     0,   455,
    1231,     0,   456,     0,   457,   458,   459,   460,   168,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
     169,   170,     0,   470,   471,   472,  1232,  1233,     0,  1234,
       0,     0,   174,   175,   473,   176,   474,   475,   476,   477,
     478,     0,  1235,   178,   479,   179,     0,   480,   481,   482,
    1236,  1237,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,  1238,   185,  1239,   750,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,   189,
     504,  1241,  1242,  1243,   505,   506,     0,     0,   507,   751,
       0,     0,  1244,   509,     0,     0,   192,   193,   194,  1245,
     510,   511,   512,   513,     0,  1246,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,  1247,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,   205,   536,   537,  1248,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,  1249,   547,
     211,   548,   549,   213,   550,  1250,     0,   551,   552,   553,
     554,   555,   556,   557,   558,  1251,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,  1252,  1253,     0,     0,
     567,  1254,   568,  1255,  1256,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,  1258,     0,   578,   579,
       0,   580,  1259,   581,   229,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,    49,
    1260,   231,   589,     0,     0,  1261,  1262,    52,    53,  1263,
      54,     0,     0,     0,     0,     0,  2247,   620,    81,    82,
      83,   373,    85,    86,  1267,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     621,   101,   102,   103,   376,   622,     0,   105,   106,   107,
     108,   623,   624,   110,   111,   112,   113,     0,   114,   625,
     626,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,  1209,     0,     0,   396,   397,     0,
     398,   132,   399,   400,   401,     0,  1210,   136,  1211,  1212,
       0,   402,   403,     0,   404,   405,  1213,  1214,   406,  1215,
    1216,   408,     0,   409,   410,   411,   412,  1217,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,  1218,   420,
       0,   421,   422,   423,   148,   424,  1219,  1220,  1221,  1222,
    1223,   425,   426,   427,   428,   429,  1224,  1225,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,  1226,   439,   440,     0,   441,   442,   443,     0,
       0,     0,   445,   446,   447,  1227,   448,     0,  1228,  1229,
     449,   450,  1230,     0,   451,     0,   452,   163,     0,   164,
     453,     0,   454,     0,   455,  1231,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,   169,   170,     0,   470,   471,
     472,  1232,  1233,     0,  1234,     0,     0,   174,   175,   473,
     176,   474,   475,   476,   477,   478,     0,  1235,   178,   479,
       0,     0,   480,   481,   482,  1236,  1237,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,  1238,   185,
    1239,   750,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,   189,   504,  1241,  1242,  1243,   505,
     506,     0,     0,   507,   751,     0,     0,  1244,   509,     0,
       0,   192,   193,   194,  1245,   510,   511,   512,   513,     0,
    1246,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,  1247,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,   205,   536,
     537,  1248,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,  1249,   547,   211,   548,   549,     0,   550,
    1250,     0,   551,   552,   553,   554,   555,   556,   557,   558,
    1251,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,  1252,  1253,     0,     0,   567,  1254,   568,  1255,  1256,
     569,   570,   571,   572,   573,     0,  1257,   574,   575,   576,
     577,  1258,     0,   578,   579,     0,   580,  1259,   581,   229,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,    49,  1260,   231,   589,     0,     0,
    1261,  1262,    52,    53,  1263,    54,     0,     0,     0,     0,
    1264,  1265,   620,    81,    82,    83,   373,    85,    86,  1267,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,   621,   101,   102,   103,   376,
     622,     0,   105,   106,   107,   108,   623,   624,   110,   111,
     112,   113,     0,   114,   625,   626,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,  1209,
       0,     0,   396,   397,     0,   398,   132,   399,   400,   401,
       0,  1210,   136,  1211,  1212,     0,   402,   403,     0,   404,
     405,  1213,  1214,   406,  1215,  1216,   408,     0,   409,   410,
     411,   412,  1217,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,  1218,   420,     0,   421,   422,   423,   148,
     424,  1219,  1220,  1221,  1222,  1223,   425,   426,   427,   428,
     429,  1224,  1225,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,  1226,   439,   440,
       0,   441,   442,   443,     0,     0,     0,   445,   446,   447,
    1227,   448,     0,  1228,  1229,   449,   450,  1230,     0,   451,
       0,   452,   163,     0,   164,   453,     0,   454,     0,   455,
    1231,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
     169,   170,     0,   470,   471,   472,  1232,  1233,     0,  1234,
       0,     0,   174,   175,   473,   176,   474,   475,   476,   477,
     478,     0,  1235,   178,   479,     0,     0,   480,   481,   482,
    1236,  1237,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,  1238,   185,  1239,   750,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,   189,
     504,  1241,  1242,  1243,   505,   506,     0,     0,   507,   751,
       0,     0,     0,   509,     0,     0,   192,   193,   194,  1245,
     510,   511,   512,   513,     0,  1246,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,  1247,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,   205,   536,   537,  1248,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,  1249,   547,
     211,   548,   549,     0,   550,  1250,     0,   551,   552,   553,
     554,   555,   556,   557,   558,  1251,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,  1252,  1253,     0,     0,
     567,  1254,   568,  1255,  1256,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,  1258,     0,   578,   579,
       0,   580,  1259,   581,   229,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,    49,
       0,   231,   589,     0,     0,  1261,  1262,    52,    53,  1263,
      54,     0,     0,     0,     0,     0,  2247,     0,    81,    82,
      83,   373,    85,    86,  1267,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,  2588,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
       0,   421,   422,   423,  -957,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,  -957,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,  -957,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
    -957,   474,   475,   476,   477,   478,     0,   177,  -957,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,  -957,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,  -957,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,     0,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   580,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,     0,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
    1351,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,   132,   399,   400,   401,   134,   135,   136,   137,     0,
       0,   402,   403,     0,   404,   405,     0,  1214,   406,   407,
     138,   408,     0,   409,   410,   411,   412,  1217,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,  1218,   420,
       0,   421,   422,   423,   148,   424,  1219,  1220,  1221,  1222,
    1223,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,  1228,     0,
     449,   450,   162,     0,   451,     0,   452,   163,     0,   164,
     453,     0,   454,     0,   455,  1231,     0,   456,     0,   457,
     458,   459,   460,   168,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,   169,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,   174,   175,   473,
     176,   474,   475,   476,   477,   478,     0,  1235,   178,   479,
     179,     0,   480,   481,   482,  1236,  1237,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,   185,
     186,   750,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,   189,   504,     0,  1242,   191,   505,
     506,     0,     0,   507,   751,     0,   928,   508,   509,     0,
       0,   192,   193,   194,  1245,   510,   511,   512,   513,     0,
    1246,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,   205,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,   209,
     544,   545,   546,  1249,   547,   211,   548,   549,   213,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
    1251,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,     0,     0,   567,  1254,   568,  1255,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,  1258,     0,   578,   579,     0,  1740,   228,   581,   229,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,     0,    95,    96,    97,    98,    99,   100,  2129,
     101,   102,   103,   376,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,     0,   394,   395,     0,
       0,     0,     0,     0,     0,     0,   396,   397,     0,   398,
     132,   399,   400,   401,   134,   135,   136,   137,     0,     0,
     402,   403,     0,   404,   405,     0,  1214,   406,   407,   138,
     408,     0,   409,   410,   411,   412,  1217,     0,     0,   413,
     414,   415,   416,   417,     0,   418,   419,  1218,   420,     0,
     421,   422,   423,   148,   424,  1219,  1220,  1221,  1222,  1223,
     425,   426,   427,   428,   429,   151,   152,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,   438,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,   158,   448,     0,  1228,     0,   449,
     450,   162,     0,   451,     0,   452,   163,     0,   164,   453,
       0,   454,     0,   455,  1231,     0,   456,     0,   457,   458,
     459,   460,   168,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,   169,   170,     0,   470,   471,   472,
       0,   172,     0,   173,     0,     0,   174,   175,   473,   176,
     474,   475,   476,   477,   478,     0,  1235,   178,   479,   179,
       0,   480,   481,   482,  1236,  1237,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,   185,   186,
     750,   494,   495,   496,   497,   498,   499,   500,   187,   501,
       0,   502,   503,   189,   504,     0,  1242,   191,   505,   506,
       0,     0,   507,   751,     0,   928,   508,   509,     0,     0,
     192,   193,   194,  1245,   510,   511,   512,   513,     0,  1246,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,   199,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,   205,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   546,  1249,   547,   211,   548,   549,   213,   550,   214,
       0,   551,   552,   553,   554,   555,   556,   557,   558,  1251,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
     217,   218,     0,     0,   567,  1254,   568,  1255,     0,   569,
     570,   571,   572,   573,     0,     0,   574,   575,   576,   577,
    1258,     0,   578,   579,     0,   580,   228,   581,   229,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,     0,     0,   231,    81,    82,    83,   373,
      85,    86,     0,    87,    88,    89,   374,     0,   375,     0,
      93,     0,    95,    96,    97,    98,    99,   100,  2129,   101,
     102,   103,   376,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   117,
     377,   378,     0,     0,     0,   379,   380,     0,     0,     0,
       0,   381,     0,     0,     0,     0,     0,     0,     0,     0,
     382,     0,   383,     0,   384,   385,     0,   386,   387,   388,
     389,   390,   391,   392,   393,     0,   394,   395,     0,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,   132,
     399,   400,   401,   134,   135,   136,   137,     0,     0,   402,
     403,     0,   404,   405,     0,  1214,   406,   407,   138,   408,
       0,   409,   410,   411,   412,  1217,     0,     0,   413,   414,
     415,   416,   417,     0,   418,   419,  1218,   420,     0,   421,
     422,   423,   148,   424,  1219,  1220,  1221,  1222,  1223,   425,
     426,   427,   428,   429,   151,   152,   430,     0,   431,     0,
     432,     0,   433,   434,   435,     0,   436,     0,     0,   437,
     438,   439,   440,     0,   441,   442,   443,     0,   444,     0,
     445,   446,   447,   158,   448,     0,  1228,     0,   449,   450,
     162,     0,   451,     0,   452,   163,     0,   164,   453,     0,
     454,     0,   455,  1231,     0,   456,     0,   457,   458,   459,
     460,   168,   461,   462,   463,     0,   464,   465,   466,   467,
     468,   469,     0,   169,   170,     0,   470,   471,   472,     0,
     172,     0,   173,     0,     0,   174,   175,   473,   176,   474,
     475,   476,   477,   478,     0,  1235,   178,   479,   179,     0,
     480,   481,   482,  1236,  1237,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   184,   185,   186,   750,
     494,   495,   496,   497,   498,   499,   500,   187,   501,     0,
     502,   503,   189,   504,     0,  1242,   191,   505,   506,     0,
       0,   507,   751,     0,     0,   508,   509,     0,     0,   192,
     193,   194,  1245,   510,   511,   512,   513,     0,  1246,   197,
     514,   515,   516,     0,   517,   518,   519,   520,   521,   522,
     199,   523,   524,     0,   525,   526,   527,   528,   529,   530,
     531,   532,   533,     0,   534,   535,   205,   536,   537,   207,
     538,   539,   540,   541,   542,   543,     0,     0,   544,   545,
     546,  1249,   547,   211,   548,   549,   213,   550,   214,     0,
     551,   552,   553,   554,   555,   556,   557,   558,  1251,   559,
       0,   560,   561,     0,   562,   563,   564,   565,     0,   217,
     218,     0,     0,   567,  1254,   568,  1255,     0,   569,   570,
     571,   572,   573,     0,     0,   574,   575,   576,   577,  1258,
       0,   578,   579,     0,   580,   228,   581,   229,   582,     0,
       0,     0,   583,   584,   585,   586,   587,   588,     0,     0,
       0,   230,     0,     0,   231,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,  3334,   101,   102,
     103,   376,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,   135,     0,   137,     0,     0,   402,   403,
       0,   404,   405,     0,     0,   406,   407,   138,   408,     0,
     409,   410,   411,   412,   142,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,   145,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   151,   152,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,   438,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,   158,   448,     0,   160,     0,   449,   450,   162,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,   167,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,   170,     0,   470,   471,   472,     0,   172,
       0,   173,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,   177,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   184,     0,   186,     0,   494,
     495,   496,   497,   498,   499,   500,   187,   501,     0,   502,
     503,     0,   504,     0,   190,   191,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,   192,     0,
       0,   195,   510,   511,   512,   513,     0,   196,   197,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,   199,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,   207,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,   211,   548,   549,     0,   550,   214,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   216,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,   217,   218,
       0,     0,   567,   219,   568,   220,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,   580,   228,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,    49,     0,   231,   589,     0,     0,     0,     0,    52,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2518,  2519,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   376,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,     0,   394,   395,     0,
       0,     0,     0,     0,     0,     0,   396,   397,     0,   398,
       0,   399,   400,   401,     0,   135,     0,   137,     0,     0,
     402,   403,     0,   404,   405,     0,     0,   406,   407,   138,
     408,     0,   409,   410,   411,   412,   142,     0,     0,   413,
     414,   415,   416,   417,     0,   418,   419,   145,   420,     0,
     421,   422,   423,     0,   424,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   151,   152,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,   438,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,   158,   448,     0,   160,     0,   449,
     450,   162,     0,   451,     0,   452,     0,     0,     0,   453,
       0,   454,     0,   455,   167,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,     0,   170,     0,   470,   471,   472,
       0,   172,     0,   173,     0,     0,     0,     0,   473,     0,
     474,   475,   476,   477,   478,     0,   177,     0,   479,     0,
       0,   480,   481,   482,     0,     0,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,     0,   186,
       0,   494,   495,   496,   497,   498,   499,   500,   187,   501,
       0,   502,   503,     0,   504,     0,   190,   191,   505,   506,
       0,     0,   507,     0,     0,     0,   508,   509,     0,     0,
     192,     0,     0,   195,   510,   511,   512,   513,     0,   196,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,   199,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,     0,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   546,     0,   547,   211,   548,   549,     0,   550,   214,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   216,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
     217,   218,     0,     0,   567,   219,   568,   220,     0,   569,
     570,   571,   572,   573,     0,     0,   574,   575,   576,   577,
       0,     0,   578,   579,     0,   580,   228,   581,     0,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,    49,     0,   231,   589,     0,     0,     0,
       0,    52,    53,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,  2519,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   376,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,   399,   400,   401,
       0,   135,     0,   137,     0,     0,   402,   403,     0,   404,
     405,     0,     0,   406,   407,   138,   408,     0,   409,   410,
     411,   412,   142,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,   145,   420,     0,   421,   422,   423,     0,
     424,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   151,   152,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,   438,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
     158,   448,     0,   160,     0,   449,   450,   162,     0,   451,
       0,   452,     0,     0,     0,   453,     0,   454,     0,   455,
     167,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
       0,   170,     0,   470,   471,   472,     0,   172,     0,   173,
       0,     0,     0,     0,   473,     0,   474,   475,   476,   477,
     478,     0,   177,     0,   479,     0,     0,   480,   481,   482,
       0,     0,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   184,     0,   186,   750,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,     0,
     504,     0,   190,   191,   505,   506,     0,     0,   507,   751,
       0,     0,   508,   509,     0,     0,   192,     0,     0,   195,
     510,   511,   512,   513,     0,   196,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,   199,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,     0,   536,   537,   207,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,     0,   547,
     211,   548,   549,     0,   550,   214,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   216,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,   217,   218,     0,     0,
     567,   219,   568,   220,     0,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,     0,     0,   578,   579,
       0,   580,   228,   581,     0,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,     0,
       0,   231,    81,    82,    83,   373,    85,    86,     0,    87,
      88,    89,   374,     0,   375,     0,    93,     0,    95,    96,
      97,    98,    99,   100,  1339,   101,   102,   103,   376,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   117,   377,   378,     0,     0,
       0,   379,   380,     0,     0,     0,     0,   381,     0,     0,
       0,     0,     0,     0,     0,     0,   382,     0,   383,     0,
     384,   385,     0,   386,   387,   388,   389,   390,   391,   392,
     393,     0,   394,   395,     0,     0,     0,     0,     0,     0,
       0,   396,   397,     0,   398,     0,   399,   400,   401,     0,
     135,     0,   137,     0,     0,   402,   403,     0,   404,   405,
       0,     0,   406,   407,   138,   408,     0,   409,   410,   411,
     412,   142,     0,     0,   413,   414,   415,   416,   417,     0,
     418,   419,   145,   420,     0,   421,   422,   423,     0,   424,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     151,   152,   430,     0,   431,     0,   432,     0,   433,   434,
     435,     0,   436,     0,     0,   437,   438,   439,   440,     0,
     441,   442,   443,     0,   444,     0,   445,   446,   447,   158,
     448,     0,   160,     0,   449,   450,   162,     0,   451,     0,
     452,     0,     0,     0,   453,     0,   454,     0,   455,   167,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
     463,     0,   464,   465,   466,   467,   468,   469,     0,     0,
     170,     0,   470,   471,   472,     0,   172,     0,   173,     0,
       0,     0,     0,   473,     0,   474,   475,   476,   477,   478,
       0,   177,     0,   479,     0,     0,   480,   481,   482,     0,
       0,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   184,     0,   186,     0,   494,   495,   496,   497,
     498,   499,   500,   187,   501,     0,   502,   503,     0,   504,
       0,   190,   191,   505,   506,     0,     0,   507,     0,     0,
       0,   508,   509,     0,     0,   192,     0,     0,   195,   510,
     511,   512,   513,     0,   196,   197,   514,   515,   516,     0,
     517,   518,   519,   520,   521,   522,   199,   523,   524,     0,
     525,   526,   527,   528,   529,   530,   531,   532,   533,     0,
     534,   535,     0,   536,   537,   207,   538,   539,   540,   541,
     542,   543,     0,   209,   544,   545,   546,     0,   547,   211,
     548,   549,     0,   550,   214,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   216,   559,     0,   560,   561,     0,
     562,   563,   564,   565,     0,   217,   218,     0,     0,   567,
     219,   568,   220,     0,   569,   570,   571,   572,   573,     0,
       0,   574,   575,   576,   577,     0,     0,   578,   579,     0,
    1740,   228,   581,     0,   582,     0,     0,     0,   583,   584,
     585,   586,   587,   588,     0,     0,     0,   230,     0,     0,
     231,   589,     0,     0,     0,     0,     0,     0,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,   232,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,   209,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,     0,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,  1740,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,     0,    95,    96,    97,    98,    99,   100,   232,
     101,   102,   103,   376,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,     0,   394,   395,     0,
       0,     0,     0,     0,     0,     0,   396,   397,     0,   398,
       0,   399,   400,   401,     0,   135,     0,   137,     0,     0,
     402,   403,     0,   404,   405,     0,     0,   406,   407,   138,
     408,     0,   409,   410,   411,   412,   142,     0,     0,   413,
     414,   415,   416,   417,     0,   418,   419,   145,   420,     0,
     421,   422,   423,     0,   424,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   151,   152,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,   438,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,   158,   448,     0,   160,     0,   449,
     450,   162,     0,   451,     0,   452,     0,     0,     0,   453,
       0,   454,     0,   455,   167,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,     0,   170,     0,   470,   471,   472,
       0,   172,     0,   173,     0,     0,     0,     0,   473,     0,
     474,   475,   476,   477,   478,     0,   177,     0,   479,     0,
       0,   480,   481,   482,     0,     0,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,     0,   186,
       0,   494,   495,   496,   497,   498,   499,   500,   187,   501,
       0,   502,   503,     0,   504,     0,   190,   191,   505,   506,
       0,     0,   507,     0,     0,     0,   508,   509,     0,     0,
     192,     0,     0,   195,   510,   511,   512,   513,     0,   196,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,   199,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,     0,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   546,     0,   547,   211,   548,   549,     0,   550,   214,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   216,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
     217,   218,     0,     0,   567,   219,   568,   220,     0,   569,
     570,   571,   572,   573,     0,     0,   574,   575,   576,   577,
       0,     0,   578,   579,     0,   580,   228,   581,     0,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,     0,     0,   231,    81,    82,    83,   373,
      85,    86,     0,    87,    88,    89,   374,     0,   375,     0,
      93,     0,    95,    96,    97,    98,    99,   100,  1832,   101,
     102,   103,   376,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   117,
     377,   378,     0,     0,     0,   379,   380,     0,     0,     0,
       0,   381,     0,     0,     0,     0,     0,     0,     0,     0,
     382,     0,   383,     0,   384,   385,     0,   386,   387,   388,
     389,   390,   391,   392,   393,     0,   394,   395,     0,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
     399,   400,   401,     0,   135,     0,   137,     0,     0,   402,
     403,     0,   404,   405,     0,     0,   406,   407,   138,   408,
       0,   409,   410,   411,   412,   142,     0,     0,   413,   414,
     415,   416,   417,     0,   418,   419,   145,   420,     0,   421,
     422,   423,     0,   424,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   151,   152,   430,     0,   431,     0,
     432,     0,   433,   434,   435,     0,   436,     0,     0,   437,
     438,   439,   440,     0,   441,   442,   443,     0,   444,     0,
     445,   446,   447,   158,   448,     0,   160,     0,   449,   450,
     162,     0,   451,     0,   452,     0,     0,     0,   453,     0,
     454,     0,   455,   167,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,   463,     0,   464,   465,   466,   467,
     468,   469,     0,     0,   170,     0,   470,   471,   472,     0,
     172,     0,   173,     0,     0,     0,     0,   473,     0,   474,
     475,   476,   477,   478,     0,   177,     0,   479,     0,     0,
     480,   481,   482,     0,     0,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   184,     0,   186,     0,
     494,   495,   496,   497,   498,   499,   500,   187,   501,     0,
     502,   503,     0,   504,     0,   190,   191,   505,   506,     0,
       0,   507,     0,     0,     0,   508,   509,     0,     0,   192,
       0,     0,   195,   510,   511,   512,   513,     0,   196,   197,
     514,   515,   516,     0,   517,   518,   519,   520,   521,   522,
     199,   523,   524,     0,   525,   526,   527,   528,   529,   530,
     531,   532,   533,     0,   534,   535,     0,   536,   537,   207,
     538,   539,   540,   541,   542,   543,     0,     0,   544,   545,
     546,     0,   547,   211,   548,   549,     0,   550,   214,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   216,   559,
       0,   560,   561,     0,   562,   563,   564,   565,     0,   217,
     218,     0,     0,   567,   219,   568,   220,     0,   569,   570,
     571,   572,   573,     0,     0,   574,   575,   576,   577,     0,
       0,   578,   579,     0,   580,   228,   581,     0,   582,     0,
       0,     0,   583,   584,   585,   586,   587,   588,     0,     0,
       0,   230,     0,     0,   231,     0,     0,     0,     0,     0,
       0,   620,    81,    82,    83,   373,    85,    86,     0,    87,
      88,    89,   374,     0,   375,     0,    93,  2986,    95,    96,
      97,    98,    99,   100,   621,   101,   102,   103,   376,   622,
       0,   105,   106,   107,   108,   623,   624,   110,   111,   112,
     113,     0,   114,   625,   626,   117,   377,   378,     0,     0,
       0,   379,   380,     0,     0,     0,     0,   381,     0,     0,
       0,     0,     0,     0,     0,     0,   382,     0,   383,     0,
     384,   385,     0,   386,   387,   388,   389,   390,   391,   392,
     393,   627,   394,   395,   628,   629,   630,   631,   632,   633,
     634,   396,   397,   635,   398,   132,   399,   400,   401,   134,
    1530,   136,  1531,  1212,   636,   402,   403,     0,   404,   405,
     637,   638,   406,  1532,  1533,   408,   640,   409,   410,   411,
     412,     0,   641,   642,   413,   414,   415,   416,   417,   643,
     418,   419,     0,   420,   644,   421,   422,   423,   148,   424,
     645,   646,   647,   648,   649,   425,   426,   427,   428,   429,
    1534,  1535,   430,   650,   431,   651,   432,     0,   433,   434,
     435,   652,   436,   653,   654,   437,  1226,   439,   440,   655,
     441,   442,   443,   656,   444,   657,   445,   446,   447,     0,
     448,     0,     0,   658,   449,   450,  1536,   659,   451,   660,
     452,   163,   661,   164,   453,     0,   454,   662,   455,     0,
     663,   456,   664,   457,   458,   459,   460,   168,   461,   462,
     463,   665,   464,   465,   466,   467,   468,   469,   666,   169,
       0,     0,   470,   471,   472,  1232,  1537,   669,  1538,   670,
       0,   174,   175,   473,   176,   474,   475,   476,   477,   478,
     671,     0,   178,   479,   179,   672,   480,   481,   482,     0,
       0,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,  1539,   185,  1540,   673,   494,   495,   496,   497,
     498,   499,   500,     0,   501,   674,   502,   503,   189,   504,
     675,     0,  1541,   505,   506,   676,   677,   507,   678,   679,
     680,  2880,   509,   681,   682,     0,   193,   194,     0,   510,
     511,   512,   513,     0,     0,     0,   514,   515,   516,   683,
     517,   518,   519,   520,   521,   522,  1542,   523,   524,   684,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   685,
     534,   535,   205,   536,   537,     0,   538,   539,   540,   541,
     542,   543,     0,   686,   544,   545,   546,   687,   547,  1543,
     548,   549,   213,   550,  1544,   688,   551,   552,   553,   554,
     555,   556,   557,   558,     0,   559,   689,   560,   561,   690,
     562,   563,   564,   565,   691,  1545,  1546,     0,   693,   567,
       0,   568,     0,   694,   569,   570,   571,   572,   573,     0,
     696,   574,   575,   576,   577,   697,   698,   578,   579,     0,
       0,  1547,   581,   229,   582,     0,   699,   700,   583,   584,
     585,   586,   587,   588,     0,     0,     0,   230,    49,  1038,
     231,   589,     0,     0,     0,     0,    52,    53,     0,    54,
    1039,  1040,  1041,     0,  1042,  2881,  1044,  1045,  1046,  1047,
      81,    82,    83,   373,    85,    86,     0,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   376,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,   399,   400,   401,     0,   135,     0,
     137,     0,     0,   402,   403,     0,   404,   405,     0,     0,
     406,   407,   138,   408,     0,   409,  1037,   411,   412,   142,
       0,     0,   413,   414,   415,   416,   417,     0,   418,   419,
     145,   420,     0,   421,   422,   423,     0,   424,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   151,   152,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,   438,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,   158,   448,     0,
     160,     0,   449,   450,   162,     0,   451,     0,   452,     0,
       0,     0,   453,     0,   454,     0,   455,   167,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,     0,   170,     0,
     470,   471,   472,     0,   172,     0,   173,     0,     0,     0,
       0,   473,     0,   474,   475,   476,   477,   478,     0,   177,
       0,   479,     0,     0,   480,   481,   482,     0,     0,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     184,     0,   186,     0,   494,   495,   496,   497,   498,   499,
     500,   187,   501,     0,   502,   503,     0,   504,     0,   190,
     191,   505,   506,     0,     0,   507,     0,     0,     0,   508,
     509,     0,     0,   192,     0,     0,   195,   510,   511,   512,
     513,     0,   196,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,   199,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
       0,   536,   537,   207,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   546,     0,   547,   211,   548,   549,
       0,   550,   214,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   216,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,   217,   218,     0,     0,   567,   219,   568,
     220,     0,   569,   570,   571,   572,   573,     0,     0,   574,
     575,   576,   577,     0,     0,   578,   579,     0,   580,   228,
     581,     0,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,     0,  1038,   231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1039,  1040,
    1041,     0,  1042,  1043,  1044,  1045,  1046,  1047,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,     0,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   580,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,  1038,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1039,  1040,  1041,     0,
    1042,  1043,  1044,  1045,  1046,  1047,   620,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,     0,    95,    96,    97,    98,    99,   100,   621,
     101,   102,   103,   376,   622,     0,   105,   106,   107,   108,
     623,   624,   110,   111,   112,   113,     0,   114,   625,   626,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,   627,   394,   395,   628,
     629,   630,   631,   632,   633,   634,   396,   397,   635,   398,
     132,   399,   400,   401,   134,   135,   136,   137,     0,   636,
     402,   403,     0,   404,   405,   637,   638,   406,   639,   138,
     408,   640,   409,   410,   411,   412,   142,   641,   642,   413,
     414,   415,   416,   417,   643,   418,   419,   145,   420,   644,
     421,   422,   423,   148,   424,   645,   646,   647,   648,   649,
     425,   426,   427,   428,   429,   151,   152,   430,   650,   431,
     651,   432,     0,   433,   434,   435,   652,   436,   653,   654,
     437,   438,   439,   440,   655,   441,   442,   443,   656,   444,
     657,   445,   446,   447,   158,   448,     0,   160,   658,   449,
     450,   162,   659,   451,   660,   452,   163,   661,   164,   453,
       0,   454,   662,   455,   167,   663,   456,   664,   457,   458,
     459,   460,   168,   461,   462,   463,   665,   464,   465,   466,
     467,   468,   469,   666,   169,   170,   667,   470,   471,   472,
     668,   172,   669,   173,   670,     0,   174,   175,   473,   176,
     474,   475,   476,   477,   478,   671,   177,   178,   479,   179,
     672,   480,   481,   482,     0,     0,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,   185,   186,
     673,   494,   495,   496,   497,   498,   499,   500,   187,   501,
     674,   502,   503,   189,   504,   675,   190,   191,   505,   506,
     676,   677,   507,   678,   679,   680,   508,   509,   681,   682,
     192,   193,   194,   195,   510,   511,   512,   513,     0,   196,
     197,   514,   515,   516,   683,   517,   518,   519,   520,   521,
     522,   199,   523,   524,   684,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   685,   534,   535,   205,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,   686,   544,
     545,   546,   687,   547,   211,   548,   549,   213,   550,   214,
     688,   551,   552,   553,   554,   555,   556,   557,   558,   216,
     559,   689,   560,   561,   690,   562,   563,   564,   565,   691,
     217,   218,   692,   693,   567,   219,   568,   220,   694,   569,
     570,   571,   572,   573,   695,   696,   574,   575,   576,   577,
     697,   698,   578,   579,     0,     0,   228,   581,   229,   582,
       0,   699,   700,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,     0,     0,   231,     0,   620,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,  1505,    93,     0,    95,    96,    97,    98,    99,   100,
     621,   101,   102,   103,   376,   622,     0,   105,   106,   107,
     108,   623,   624,   110,   111,   112,   113,     0,   114,   625,
     626,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,  1530,     0,  1531,  1212,
       0,   402,   403,     0,   404,   405,     0,     0,   406,  1532,
    1533,   408,     0,   409,   410,   411,   412,     0,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,     0,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,  1534,  1535,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,  1226,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,     0,   448,     0,     0,     0,
     449,   450,  1536,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,     0,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,     0,     0,   470,   471,
     472,  1232,  1537,     0,  1538,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,     0,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,  1539,     0,
    1540,     0,   494,   495,   496,   497,   498,   499,   500,     0,
     501,     0,   502,   503,     0,   504,     0,     0,  1541,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,     0,     0,     0,     0,   510,   511,   512,   513,     0,
       0,     0,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,  1542,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,     0,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,     0,   547,  1543,   548,   549,     0,   550,
    1544,     0,   551,   552,   553,   554,   555,   556,   557,   558,
       0,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,  1545,  1546,     0,     0,   567,     0,   568,     0,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,     0,  1547,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,  1907,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   376,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,     0,   394,   395,     0,
       0,     0,     0,     0,     0,     0,   396,   397,     0,   398,
       0,   399,   400,   401,     0,   135,     0,   137,     0,     0,
     402,   403,     0,   404,   405,     0,     0,   406,   407,   138,
     408,     0,   409,   410,   411,   412,   142,     0,     0,   413,
     414,   415,   416,   417,     0,   418,   419,   145,   420,     0,
     421,   422,   423,     0,   424,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   151,   152,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,   438,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,   158,   448,     0,   160,     0,   449,
     450,   162,     0,   451,     0,   452,     0,     0,     0,   453,
       0,   454,     0,   455,   167,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,     0,   170,     0,   470,   471,   472,
       0,   172,     0,   173,     0,     0,     0,     0,   473,     0,
     474,   475,   476,   477,   478,     0,   177,     0,   479,     0,
       0,   480,   481,   482,     0,     0,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,     0,   186,
     750,   494,   495,   496,   497,   498,   499,   500,   187,   501,
       0,   502,   503,     0,   504,     0,   190,   191,   505,   506,
       0,     0,   507,   751,     0,     0,   508,   509,     0,     0,
     192,     0,     0,   195,   510,   511,   512,   513,     0,   196,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,   199,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,     0,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   546,     0,   547,   211,   548,   549,     0,   550,   214,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   216,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
     217,   218,     0,     0,   567,   219,   568,   220,     0,   569,
     570,   571,   572,   573,     0,     0,   574,   575,   576,   577,
       0,     0,   578,   579,     0,   580,   228,   581,     0,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,     0,     0,   231,    81,    82,    83,   373,
      85,    86,     0,    87,    88,    89,   374,     0,   375,     0,
      93,   926,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   376,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   117,
     377,   378,     0,     0,     0,   379,   380,     0,     0,     0,
       0,   381,     0,     0,     0,     0,     0,     0,     0,     0,
     382,     0,   383,     0,   384,   385,     0,   386,   387,   388,
     389,   390,   391,   392,   393,     0,   394,   395,     0,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
     399,   400,   401,     0,   135,     0,   137,     0,     0,   402,
     403,     0,   404,   405,     0,     0,   406,   407,   138,   408,
       0,   409,   410,   411,   412,   142,     0,     0,   413,   414,
     415,   416,   417,     0,   418,   419,   145,   420,     0,   421,
     422,   423,     0,   424,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   151,   152,   430,  1813,   431,     0,
     432,     0,   433,   434,   435,     0,   436,     0,     0,   437,
     438,   439,   440,     0,   441,   442,   443,     0,   444,     0,
     445,   446,   447,   158,   448,     0,   160,  1814,   449,   450,
     162,     0,   451,     0,   452,     0,     0,     0,   453,     0,
     454,     0,   455,   167,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,   463,     0,   464,   465,   466,   467,
     468,   469,     0,     0,   170,     0,   470,   471,   472,     0,
     172,     0,   173,     0,     0,     0,     0,   473,     0,   474,
     475,   476,   477,   478,     0,   177,     0,   479,     0,     0,
     480,   481,   482,     0,     0,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   184,     0,   186,     0,
     494,   495,   496,   497,   498,   499,   500,   187,   501,     0,
     502,   503,     0,   504,     0,   190,   191,   505,   506,  1815,
       0,   507,     0,  1816,     0,   508,   509,     0,     0,   192,
       0,     0,   195,   510,   511,   512,   513,     0,   196,   197,
     514,   515,   516,     0,   517,   518,   519,   520,   521,   522,
     199,   523,   524,     0,   525,   526,   527,   528,   529,   530,
     531,   532,   533,     0,   534,   535,     0,   536,   537,   207,
     538,   539,   540,   541,   542,   543,     0,     0,   544,   545,
     546,     0,   547,   211,   548,   549,     0,   550,   214,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   216,   559,
       0,   560,   561,     0,   562,   563,   564,   565,     0,   217,
     218,     0,     0,   567,   219,   568,   220,  1817,   569,   570,
     571,   572,   573,     0,     0,   574,   575,   576,   577,     0,
       0,   578,   579,     0,   580,   228,   581,     0,   582,     0,
       0,     0,   583,   584,   585,   586,   587,   588,     0,     0,
       0,   230,    49,     0,   231,   589,     0,     0,     0,     0,
      52,    53,     0,    54,     0,     0,     0,     0,     0,  1383,
      81,    82,    83,   373,    85,    86,     0,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   376,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,   399,   400,   401,     0,   135,     0,
     137,     0,     0,   402,   403,     0,   404,   405,     0,     0,
     406,   407,   138,   408,     0,   409,   410,   411,   412,   142,
       0,     0,   413,   414,   415,   416,   417,     0,   418,   419,
     145,   420,     0,   421,   422,   423,     0,   424,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   151,   152,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,   438,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,   158,   448,     0,
     160,  1814,   449,   450,   162,     0,   451,     0,   452,     0,
       0,     0,   453,     0,   454,     0,   455,   167,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,     0,   170,     0,
     470,   471,   472,     0,   172,     0,   173,     0,     0,     0,
       0,   473,     0,   474,   475,   476,   477,   478,     0,   177,
       0,   479,     0,     0,   480,   481,   482,     0,     0,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     184,     0,   186,     0,   494,   495,   496,   497,   498,   499,
     500,   187,   501,     0,   502,   503,     0,   504,     0,   190,
     191,   505,   506,  1815,     0,   507,     0,  1816,     0,   508,
     509,     0,     0,   192,     0,     0,   195,   510,   511,   512,
     513,     0,   196,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,   199,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
       0,   536,   537,   207,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   546,     0,   547,   211,   548,   549,
       0,   550,   214,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   216,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,   217,   218,     0,     0,   567,   219,   568,
     220,  1817,   569,   570,   571,   572,   573,     0,     0,   574,
     575,   576,   577,     0,     0,   578,   579,     0,   580,   228,
     581,     0,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,    49,     0,   231,   589,
       0,     0,     0,     0,    52,    53,     0,    54,     0,     0,
       0,     0,     0,  1383,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   834,   388,   389,   390,
     391,   392,   393,   835,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   836,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   837,   162,     0,
     451,     0,   838,     0,   839,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,   840,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   841,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   842,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   843,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   844,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,   589,     0,     0,     0,     0,     0,    53,
       0,    81,    82,    83,   373,    85,    86,   845,    87,    88,
      89,   374,     0,   375,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   376,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   117,   377,   378,     0,     0,     0,
     379,   380,     0,     0,     0,     0,   381,     0,     0,     0,
       0,     0,     0,     0,     0,   382,     0,   383,     0,   384,
     385,     0,   386,   834,   388,   389,   390,   391,   392,   393,
     835,   394,   395,     0,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,   836,   400,   401,     0,   135,
       0,   137,     0,     0,   402,   403,     0,   404,   405,     0,
       0,   406,   407,   138,   408,     0,   409,   410,   411,   412,
     142,     0,     0,   413,   414,   415,   416,   417,     0,   418,
     419,   145,   420,     0,   421,   422,   423,     0,   424,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   151,
     152,   430,     0,   431,     0,   432,     0,   433,   434,   435,
       0,   436,     0,     0,   437,   438,   439,   440,     0,   441,
     442,   443,     0,   444,     0,   445,   446,   447,   158,   448,
       0,   160,     0,   449,   837,   162,     0,   451,     0,   838,
       0,     0,     0,   453,     0,   454,     0,   455,   167,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,   463,
       0,   464,   465,   466,   467,   468,   469,     0,     0,   170,
       0,   470,   471,   472,     0,   172,     0,   173,     0,     0,
       0,     0,   473,     0,   474,   475,   476,   477,   841,     0,
     177,     0,   479,     0,     0,   480,   481,   482,     0,     0,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   184,     0,   186,     0,   842,   495,   496,   497,   498,
     499,   500,   187,   501,     0,   502,   503,     0,   504,     0,
     190,   191,   505,   506,     0,     0,   507,     0,     0,     0,
     508,   509,     0,     0,   192,     0,     0,   195,   510,   511,
     512,   513,     0,   196,   197,   514,   515,   516,     0,   843,
     518,   519,   520,   521,   522,   199,   523,   524,     0,   525,
     844,   527,   528,   529,   530,   531,   532,   533,     0,   534,
     535,     0,   536,   537,   207,   538,   539,   540,   541,   542,
     543,     0,     0,   544,   545,   546,     0,   547,   211,   548,
     549,     0,   550,   214,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   216,   559,     0,   560,   561,     0,   562,
     563,   564,   565,     0,   217,   218,     0,     0,   567,   219,
     568,   220,     0,   569,   570,   571,   572,   573,     0,     0,
     574,   575,   576,   577,     0,     0,   578,   579,     0,   580,
     228,   581,     0,   582,     0,     0,     0,   583,   584,   585,
     586,   587,   588,     0,     0,     0,   230,     0,     0,   231,
     589,     0,     0,     0,     0,     0,    53,     0,    81,    82,
      83,   373,    85,    86,   845,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,   613,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,  1311,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   580,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,   589,     0,     0,
      81,    82,    83,   373,    85,    86,  1312,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   376,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,   399,   400,   401,     0,   135,     0,
     137,     0,     0,   402,   403,     0,   404,   405,     0,     0,
     406,   407,   138,   408,     0,   409,   410,   411,   412,   142,
       0,     0,   413,   414,   415,   416,   417,     0,   418,   419,
     145,   420,     0,   421,   422,   423,     0,   424,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   151,   152,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,   438,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,   158,   448,     0,
     160,     0,   449,   450,   162,     0,   451,     0,   452,     0,
       0,     0,   453,     0,   454,     0,   455,   167,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,     0,   170,     0,
     470,   471,   472,     0,   172,     0,   173,     0,     0,     0,
       0,   473,     0,   474,   475,   476,   477,   478,     0,   177,
       0,   479,     0,     0,   480,   481,   482,     0,     0,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     184,     0,   186,     0,   494,   495,   496,   497,   498,   499,
     500,   187,   501,     0,   502,   503,     0,   504,     0,   190,
     191,   505,   506,     0,     0,   507,     0,     0,     0,   508,
     509,     0,     0,   192,     0,     0,   195,   510,   511,   512,
     513,     0,   196,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,   199,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
       0,   536,   537,   207,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   546,     0,   547,   211,   548,   549,
       0,   550,   214,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   216,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,   217,   218,     0,     0,   567,   219,   568,
     220,     0,   569,   570,   571,   572,   573,     0,     0,   574,
     575,   576,   577,     0,     0,   578,   579,     0,   580,   228,
     581,     0,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,    49,     0,   231,   589,
       0,     0,  1261,  1262,    52,    53,     0,    54,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,   566,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   580,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,    49,     0,   231,   589,     0,     0,
       0,     0,    52,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   376,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,   399,   400,   401,
       0,   135,     0,   137,     0,     0,   402,   403,     0,   404,
     405,     0,     0,   406,   407,   138,   408,     0,   409,   410,
     411,   412,   142,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,   145,   420,     0,   421,   422,   423,     0,
     424,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   151,   152,   430,   984,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,   438,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
     158,   448,     0,   160,     0,   449,   450,   162,     0,   451,
       0,   452,     0,     0,     0,   453,     0,   454,     0,   455,
     167,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
       0,   170,     0,   470,   471,   472,     0,   172,     0,   173,
       0,     0,     0,     0,   473,     0,   474,   475,   476,   477,
     478,     0,   177,     0,   479,     0,     0,   480,   481,   482,
       0,     0,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   184,     0,   186,     0,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,     0,
     504,     0,   190,   191,   505,   506,     0,     0,   507,     0,
       0,     0,   508,   509,     0,     0,   192,     0,     0,   195,
     510,   511,   512,   513,     0,   196,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,   199,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,     0,   536,   537,   207,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,     0,   547,
     211,   548,   549,     0,   550,   214,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   216,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,   217,   218,     0,     0,
     567,   219,   568,   220,     0,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,     0,     0,   578,   579,
       0,   580,   228,   581,     0,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,    49,
       0,   231,   589,     0,     0,     0,     0,    52,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,  1804,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,     0,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   580,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,    49,     0,   231,   589,     0,     0,
       0,     0,    52,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   376,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,   399,   400,   401,
       0,   135,     0,   137,     0,     0,   402,   403,     0,   404,
     405,     0,     0,   406,   407,   138,   408,     0,   409,   410,
     411,   412,   142,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,   145,   420,     0,   421,   422,   423,     0,
     424,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   151,   152,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,   438,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
     158,   448,     0,   160,     0,   449,   450,   162,     0,   451,
       0,   452,     0,     0,     0,   453,     0,   454,     0,   455,
     167,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
       0,   170,     0,   470,   471,   472,     0,   172,     0,   173,
       0,     0,     0,     0,   473,     0,   474,   475,   476,   477,
     478,     0,   177,     0,   479,     0,     0,   480,   481,   482,
       0,     0,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   184,     0,   186,     0,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,     0,
     504,     0,   190,   191,   505,   506,     0,     0,   507,     0,
       0,     0,   508,   509,     0,     0,   192,     0,     0,   195,
     510,   511,   512,   513,     0,   196,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,   199,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,     0,   536,   537,   207,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,     0,   547,
     211,   548,   549,     0,   550,   214,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   216,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,   217,   218,     0,     0,
     567,   219,   568,   220,     0,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,     0,     0,   578,   579,
       0,   580,   228,   581,     0,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,    49,
       0,   231,   589,     0,     0,     0,     0,    52,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,     0,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   580,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,     0,   905,  1595,
      81,    82,    83,   373,    85,    86,     0,    87,    88,    89,
     374,   906,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   376,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,   399,   400,   401,     0,   135,     0,
     137,     0,     0,   402,   403,     0,   404,   405,     0,     0,
     406,   883,   138,   408,     0,   409,   410,   411,   412,   142,
       0,     0,   413,   414,   415,   416,   907,     0,   908,   419,
     145,   420,     0,   421,   422,   423,     0,   424,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   151,   152,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,   438,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,   158,   448,     0,
     160,     0,   449,   450,   162,     0,   451,     0,   452,     0,
       0,     0,   453,     0,   454,     0,   455,   167,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,     0,   170,     0,
     470,   471,   472,     0,   172,     0,   173,     0,     0,     0,
       0,   473,     0,   474,   475,   476,   477,   478,     0,   177,
       0,   479,     0,     0,   480,   481,   909,     0,     0,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   910,
     184,     0,   186,     0,   494,   495,   496,   497,   498,   499,
     500,   187,   501,     0,   502,   503,     0,   504,     0,   190,
     191,   505,   506,     0,     0,   507,     0,     0,     0,   508,
     509,     0,     0,   192,     0,     0,   195,   510,   511,   512,
     513,     0,   196,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,   199,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
       0,   911,   537,   207,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   912,     0,   547,   211,   548,   549,
       0,   550,   214,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   216,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,   913,   218,     0,     0,   914,   219,   568,
     220,     0,   569,   570,   571,   572,   573,     0,     0,   574,
     575,   576,   577,     0,     0,   578,   579,     0,   887,   228,
     581,     0,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,    81,    82,    83,   230,    85,    86,   231,    87,
      88,    89,     0,     0,     0,    92,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,     0,     0,
       0,   105,   106,   107,   108,     0,   109,   110,   111,   112,
     113, -1415,   114,   115,   116,   117,     0,     0,     0,     0,
       0,   120,   121,     0,     0,     0,     0,   122,     0,     0,
       0,     0,     0,     0,     0,     0,   123,     0,   124,     0,
     125,   126,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   132,     0,     0,     0,   134,
     135,   136,   137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   138,     0,     0,     0,     0,     0,
       0,   142,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     151,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   158,
       0,     0,   160,     0,     0,     0,   162,     0,     0,     0,
       0,   163,     0,   164,     0,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   169,
     170,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,   174,   175,     0,   176,     0,     0,     0,     0,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   184,   185,   186,     0,     0,     0,     0,     0,
       0,     0,     0,   187,     0,     0,     0,     0,   189,     0,
       0,   190,   191,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   192,   193,   194,   195,     0,
       0,     0,     0,     0,   196,   197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   213,     0,   214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   216,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   217,   218,     0,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,   223,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   228,     0,   229,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   230,     0,     0,
     231,     0,   364,    81,    82,    83,     0,    85,    86,     0,
      87,    88,    89,     0,     0,     0,    92,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,     0,
       0,     0,   105,   106,   107,   108,     0,   109,   110,   111,
     112,   113, -1416,   114,   115,   116,   117,     0,     0,     0,
       0,     0,   120,   121,     0,     0,     0,     0,   122,     0,
       0,     0,     0,     0,     0,     0,     0,   123,     0,   124,
       0,   125,   126,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   132,     0,     0,     0,
     134,   135,   136,   137,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   138,     0,     0,     0,     0,
       0,     0,   142,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   145,     0,     0,     0,     0,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   151,   152,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     158,     0,     0,   160,     0,     0,     0,   162,     0,     0,
       0,     0,   163,     0,   164,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     169,   170,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,   174,   175,     0,   176,     0,     0,     0,     0,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   184,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,     0,     0,   189,
       0,     0,   190,   191,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   192,   193,   194,   195,
       0,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,   207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,   214,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   216,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,   218,     0,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
     223,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   228,     0,   229,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,   231,     0,   975,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,   627,   394,   395,   628,   629,   630,
     631,   632,   633,   634,   396,   397,   635,   398,   132,   399,
     400,   401,   134,   135,   136,   137,     0,   636,   402,   403,
       0,   404,   405,   637,   638,   406,   639,   138,   408,   640,
     409,   410,   411,   412,   142,   641,   642,   413,   414,   415,
     416,   417,   643,   418,   419,   145,   420,   644,   421,   422,
     423,   148,   424,   645,   646,   647,   648,   649,   425,   426,
     427,   428,   429,   151,   152,   430,   650,   431,   651,   432,
       0,   433,   434,   435,   652,   436,   653,   654,   437,   438,
     439,   440,   655,   441,   442,   443,   656,   444,   657,   445,
     446,   447,   158,   448,     0,   160,   658,   449,   450,   162,
     659,   451,   660,   452,   163,   661,   164,   453,     0,   454,
     662,   455,   167,   663,   456,   664,   457,   458,   459,   460,
     168,   461,   462,   463,   665,   464,   465,   466,   467,   468,
     469,   666,   169,   170,   667,   470,   471,   472,   668,   172,
     669,   173,   670,     0,   174,   175,   473,   176,   474,   475,
     476,   477,   478,   671,   177,   178,   479,   179,   672,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   184,   185,   186,   673,   494,
     495,   496,   497,   498,   499,   500,   187,   501,   674,   502,
     503,   189,   504,   675,   190,   191,   505,   506,   676,   677,
     507,   678,   679,   680,   508,   509,   681,   682,   192,   193,
     194,   195,   510,   511,   512,   513,     0,   196,   197,   514,
     515,   516,   683,   517,   518,   519,   520,   521,   522,   199,
     523,   524,   684,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   685,   534,   535,   205,   536,   537,   207,   538,
     539,   540,   541,   542,   543,     0,   686,   544,   545,   546,
     687,   547,   211,   548,   549,   213,   550,   214,   688,   551,
     552,   553,   554,   555,   556,   557,   558,   216,   559,   689,
     560,   561,   690,   562,   563,   564,   565,   691,   217,   218,
     692,   693,   567,   219,   568,   220,   694,   569,   570,   571,
     572,   573,   695,   696,   574,   575,   576,   577,   697,   698,
     578,   579,     0,     0,   228,   581,   229,   582,     0,   699,
     700,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,   132,   399,
     400,   401,   134,  1530,   136,  1531,  1212,     0,   402,   403,
       0,   404,   405,     0,     0,   406,  1532,  1533,   408,     0,
     409,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,     0,   420,     0,   421,   422,
     423,   148,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1534,  1535,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,     0,   448,     0,     0,     0,   449,   450,  1536,
       0,   451,     0,   452,   163,     0,   164,   453,     0,   454,
       0,   455,     0,     0,   456,     0,   457,   458,   459,   460,
     168,   461,   462,   463,  1943,   464,   465,   466,   467,   468,
     469,     0,   169,  1944,     0,   470,   471,   472,  1232,  1537,
       0,  1538,     0,     0,   174,   175,   473,   176,   474,   475,
     476,   477,   478,     0,     0,   178,   479,   179,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1539,   185,  1540,     0,   494,
     495,   496,   497,   498,   499,   500,     0,   501,     0,   502,
     503,   189,   504,     0,     0,  1541,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,  1945,   193,
     194,     0,   510,   511,   512,   513,     0,     0,     0,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1542,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,   205,   536,   537,     0,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,  1543,   548,   549,   213,   550,  1544,     0,   551,
     552,   553,   554,   555,   556,   557,   558,     0,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1545,  1546,
       0,     0,   567,     0,   568,     0,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,     0,  1547,   581,   229,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,   132,   399,
     400,   401,   134,  1530,   136,  1531,  1212,     0,   402,   403,
       0,   404,   405,     0,     0,   406,  1532,  1533,   408,     0,
     409,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,     0,   420,     0,   421,   422,
     423,   148,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1534,  1535,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,     0,   448,     0,     0,     0,   449,   450,  1536,
       0,   451,     0,   452,   163,     0,   164,   453,     0,   454,
       0,   455,     0,     0,   456,     0,   457,   458,   459,   460,
     168,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,   169,     0,     0,   470,   471,   472,  1232,  1537,
       0,  1538,     0,     0,   174,   175,   473,   176,   474,   475,
     476,   477,   478,     0,     0,   178,   479,   179,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1539,   185,  1540,     0,   494,
     495,   496,   497,   498,   499,   500,     0,   501,     0,   502,
     503,   189,   504,     0,     0,  1541,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,     0,   193,
     194,     0,   510,   511,   512,   513,     0,     0,     0,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1542,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,   205,   536,   537,     0,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,  1543,   548,   549,   213,   550,  1544,     0,   551,
     552,   553,   554,   555,   556,   557,   558,     0,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1545,  1546,
       0,     0,   567,     0,   568,     0,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,     0,  1547,   581,   229,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,    81,    82,    83,   373,    85,    86,
     611,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,   612,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,   613,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,   589,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,  2321,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,  2322,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
    2323,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,   750,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
     751,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,  2324,   562,  2325,   564,  2326,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,   589,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,   613,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,   589,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,   797,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   798,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,   589,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     830,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,   589,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   872,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,   589,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,   589,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,  1530,     0,  1531,  1212,     0,   402,   403,
       0,   404,   405,     0,     0,   406,  1532,  1533,   408,     0,
     409,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,     0,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1534,  1535,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,     0,   448,     0,     0,     0,   449,   450,  1536,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,     0,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,  1943,   464,   465,   466,   467,   468,
     469,     0,     0,  1944,     0,   470,   471,   472,  1232,  1537,
       0,  1538,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,     0,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1539,     0,  1540,     0,   494,
     495,   496,   497,   498,   499,   500,     0,   501,     0,   502,
     503,     0,   504,     0,     0,  1541,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,  1945,     0,
       0,     0,   510,   511,   512,   513,     0,     0,     0,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1542,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,     0,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,  1543,   548,   549,     0,   550,  1544,     0,   551,
     552,   553,   554,   555,   556,   557,   558,     0,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1545,  1546,
       0,     0,   567,     0,   568,     0,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,     0,  1547,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,  1530,     0,  1531,  1212,     0,   402,   403,
       0,   404,   405,     0,     0,   406,  1532,  1533,   408,     0,
     409,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,     0,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1534,  1535,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,     0,   448,     0,     0,     0,   449,   450,  1536,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,     0,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,     0,     0,   470,   471,   472,  1232,  1537,
       0,  1538,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,     0,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1539,     0,  1540,     0,   494,
     495,   496,   497,   498,   499,   500,  1972,   501,     0,   502,
     503,     0,   504,     0,     0,  1541,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,     0,     0,
       0,     0,   510,   511,   512,   513,     0,     0,     0,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1542,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,     0,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,  1543,   548,   549,     0,   550,  1544,     0,   551,
     552,   553,   554,   555,   556,   557,   558,     0,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1545,  1546,
       0,     0,   567,     0,   568,     0,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,     0,  1547,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,  1530,     0,  1531,  1212,     0,   402,   403,
       0,   404,   405,     0,     0,   406,  1532,  1533,   408,     0,
     409,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,     0,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1534,  1535,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,     0,   448,     0,     0,     0,   449,   450,  1536,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,     0,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,     0,     0,   470,   471,   472,  1232,  1537,
       0,  1538,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,     0,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1539,     0,  1540,     0,   494,
     495,   496,   497,   498,   499,   500,  2834,   501,     0,   502,
     503,     0,   504,     0,     0,  1541,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,     0,     0,
       0,     0,   510,   511,   512,   513,     0,     0,     0,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1542,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,     0,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,  1543,   548,   549,     0,   550,  1544,     0,   551,
     552,   553,   554,   555,   556,   557,   558,     0,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1545,  1546,
       0,     0,   567,     0,   568,     0,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,     0,  1547,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,  1530,     0,  1531,  1212,     0,   402,   403,
       0,   404,   405,     0,     0,   406,  1532,  1533,   408,     0,
     409,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,     0,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1534,  1535,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,     0,   448,     0,     0,     0,   449,   450,  1536,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,     0,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,     0,     0,   470,   471,   472,  1232,  1537,
       0,  1538,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,     0,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1539,     0,  1540,     0,   494,
     495,   496,   497,   498,   499,   500,     0,   501,     0,   502,
     503,     0,   504,  1937,     0,  1541,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,     0,     0,
       0,     0,   510,   511,   512,   513,     0,     0,     0,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1542,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,     0,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,  2963,   548,   549,     0,   550,  1544,     0,   551,
     552,   553,   554,   555,   556,   557,   558,     0,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1545,  1546,
       0,     0,   567,     0,   568,     0,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,     0,  1547,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,  1530,     0,  1531,  1212,     0,   402,   403,
       0,   404,   405,     0,     0,   406,  1532,  1533,   408,     0,
     409,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,     0,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1534,  1535,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,     0,   448,     0,     0,     0,   449,   450,  1536,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,     0,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,     0,     0,   470,   471,   472,  1232,  1537,
       0,  1538,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,     0,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1539,     0,  1540,     0,   494,
     495,   496,   497,   498,   499,   500,     0,   501,     0,   502,
     503,     0,   504,     0,     0,  1541,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,     0,     0,
       0,     0,   510,   511,   512,   513,     0,     0,     0,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1542,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,     0,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,  1543,   548,   549,     0,   550,  1544,     0,   551,
     552,   553,   554,   555,   556,   557,   558,     0,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1545,  1546,
       0,     0,   567,     0,   568,     0,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,     0,  1547,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,   620,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   621,   101,   102,
     103,   376,   622,     0,   105,   106,   107,   108,   623,   624,
     110,   111,   112,   113,     0,   114,   625,   626,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,  1530,     0,  1531,  1212,     0,   402,   403,
       0,   404,   405,     0,     0,   406,  1532,  1533,   408,     0,
     409,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,     0,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,  1534,  1535,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,  1226,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,     0,   448,     0,     0,     0,   449,   450,  1536,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,     0,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,     0,     0,   470,   471,   472,  1232,  1537,
       0,  1538,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,     0,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,  1539,     0,  1540,     0,   494,
     495,   496,   497,   498,   499,   500,     0,   501,     0,   502,
     503,     0,   504,     0,     0,  1541,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,     0,     0,
       0,     0,   510,   511,   512,   513,     0,     0,     0,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,  1542,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,     0,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,     0,   548,   549,     0,   550,  1544,     0,   551,
     552,   553,   554,   555,   556,   557,   558,     0,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,  1545,  1546,
       0,     0,   567,     0,   568,     0,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,     0,  1547,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   386,   387,   388,   389,   390,
     391,   392,   393,   627,   394,   395,   628,   629,   630,   631,
     632,   633,   634,   396,   397,   635,   398,   132,   399,   400,
     401,   134,   135,   136,   137,     0,   636,   402,   403,     0,
     404,   405,   637,   638,   406,     0,   138,   408,   640,   409,
     410,   411,   412,   142,   641,   642,   413,   414,   415,   416,
     417,   643,   418,   419,   145,   420,   644,   421,   422,   423,
     148,   424,   645,   646,   647,   648,   649,   425,   426,   427,
       0,   429,   151,   152,   430,   650,   431,   651,   432,     0,
     433,   434,   435,   652,   436,   653,   654,   437,   438,   439,
     440,   655,   441,   442,   443,   656,   444,   657,   445,   446,
     447,   158,   448,     0,   160,   658,   449,   450,   162,   659,
     451,   660,   452,   163,   661,   164,   453,     0,   454,   662,
     455,   167,   663,   456,   664,   457,   458,     0,   460,   168,
     461,   462,   463,   665,   464,   465,   466,   467,   468,   469,
     666,   169,   170,     0,   470,   471,   472,     0,   172,   669,
     173,   670,     0,   174,   175,   473,   176,   474,   475,   476,
     477,   478,   671,   177,   178,   479,   179,   672,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,     0,   489,
     490,     0,   492,   493,   184,   185,   186,   673,   494,   495,
     496,   497,   498,   499,   500,   187,   501,   674,   502,   503,
     189,   504,   675,   190,   191,   505,   506,   676,   677,   507,
     678,   679,   680,   508,   509,   681,   682,   192,   193,   194,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,   683,   517,   518,   519,   520,   521,   522,   199,   523,
     524,   684,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   685,   534,   535,   205,   536,   537,   207,   538,   539,
     540,   541,   542,     0,     0,   686,   544,   545,   546,   687,
     547,   211,   548,   549,   213,   550,   214,   688,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,   689,   560,
     561,   690,   562,   563,   564,   565,   691,   217,   218,     0,
     693,   567,   219,   568,   220,   694,   569,   570,   571,   572,
     573,     0,   696,   574,   575,   576,   577,   697,   698,   578,
     579,     0,     0,   228,   581,   229,   582,     0,   699,   700,
     583,   584,   585,   586,     0,   588,     0,     0,     0,   230,
       0,     0,   231,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   376,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,   132,   399,   400,   401,
     134,   135,   136,   137,     0,     0,   402,   403,     0,   404,
     405,     0,     0,   406,   407,   138,   408,     0,   409,   410,
     411,   412,   142,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,   145,   420,     0,   421,   422,   423,   148,
     424,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   151,   152,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,   438,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
     158,   448,     0,   160,     0,   449,   450,   162,     0,   451,
       0,   452,   163,     0,   164,   453,     0,   454,     0,   455,
     167,     0,   456,     0,   457,   458,   459,   460,   168,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
     169,   170,     0,   470,   471,   472,     0,   172,     0,   173,
       0,     0,   174,   175,   473,   176,   474,   475,   476,   477,
     478,     0,   177,   178,   479,   179,     0,   480,   481,   482,
       0,     0,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   184,   185,   186,   750,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,   189,
     504,     0,   190,   191,   505,   506,     0,     0,   507,   751,
       0,     0,   508,   509,     0,     0,   192,   193,   194,   195,
     510,   511,   512,   513,     0,   196,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,   199,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,   205,   536,   537,   207,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,     0,   547,
     211,   548,   549,   213,   550,   214,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   216,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,   217,   218,     0,     0,
     567,   219,   568,   220,     0,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,     0,     0,   578,   579,
       0,   580,   228,   581,   229,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,     0,
       0,   231,    81,    82,    83,   373,    85,    86,     0,    87,
      88,    89,   374,     0,   375,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   376,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   117,   377,   378,     0,     0,
       0,   379,   380,     0,     0,     0,     0,   381,     0,     0,
       0,     0,     0,     0,     0,     0,   382,     0,   383,     0,
     384,   385,     0,   386,   387,   388,   389,   390,   391,   392,
     393,     0,   394,   395,     0,     0,     0,     0,     0,     0,
       0,   396,   397,     0,   398,   132,   399,   400,   401,   134,
     135,   136,   137,     0,     0,   402,   403,     0,   404,   405,
       0,     0,   406,   407,   138,   408,     0,   409,   410,   411,
     412,   142,     0,     0,   413,   414,   415,   416,   417,     0,
     418,   419,   145,   420,     0,   421,   422,   423,   148,   424,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     151,   152,   430,     0,   431,     0,   432,     0,   433,   434,
     435,     0,   436,     0,     0,   437,   438,   439,   440,     0,
     441,   442,   443,     0,   444,     0,   445,   446,   447,   158,
     448,     0,   160,     0,   449,   450,   162,     0,   451,     0,
     452,   163,     0,   164,   453,     0,   454,     0,   455,   167,
       0,   456,     0,   457,   458,   459,  1135,   168,   461,   462,
     463,     0,   464,   465,   466,   467,   468,   469,     0,   169,
     170,     0,   470,   471,   472,     0,   172,     0,   173,     0,
       0,   174,   175,   473,   176,   474,   475,   476,   477,   478,
       0,   177,   178,   479,   179,     0,   480,   481,   482,     0,
       0,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   184,   185,   186,   750,   494,   495,   496,   497,
     498,   499,   500,   187,   501,     0,   502,   503,   189,   504,
       0,   190,   191,   505,   506,     0,     0,   507,   751,     0,
       0,   508,   509,     0,     0,   192,   193,   194,   195,   510,
     511,   512,   513,     0,   196,   197,   514,   515,   516,     0,
     517,   518,   519,   520,   521,   522,   199,   523,   524,     0,
     525,   526,   527,   528,   529,   530,   531,   532,   533,     0,
     534,   535,   205,   536,   537,   207,   538,   539,   540,   541,
     542,   543,     0,     0,   544,   545,   546,     0,   547,   211,
     548,   549,   213,   550,   214,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   216,   559,     0,   560,   561,     0,
     562,   563,   564,   565,     0,   217,   218,     0,     0,   567,
     219,   568,   220,     0,   569,   570,   571,   572,   573,     0,
       0,   574,   575,   576,   577,     0,     0,   578,   579,     0,
     580,   228,   581,   229,   582,     0,     0,     0,   583,   584,
     585,   586,   587,   588,     0,     0,     0,   230,     0,     0,
     231,    81,    82,    83,   373,    85,    86,     0,    87,    88,
      89,   374,     0,   375,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   376,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   117,   377,   378,     0,     0,     0,
     379,   380,     0,     0,     0,     0,   381,     0,     0,     0,
       0,     0,     0,     0,     0,   382,     0,   383,     0,   384,
     385,     0,   386,   387,   388,   389,   390,   391,   392,   393,
       0,   394,   395,     0,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,   132,   399,   400,   401,   134,   135,
     136,   137,     0,     0,   402,   403,     0,   404,   405,     0,
       0,   406,   407,   138,   408,     0,   409,   410,   411,   412,
     142,     0,     0,   413,   414,   415,   416,   417,     0,   418,
     419,   145,   420,     0,   421,   422,   423,   148,   424,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   151,
     152,   430,     0,   431,     0,   432,     0,   433,   434,   435,
       0,   436,     0,     0,   437,   438,   439,   440,     0,   441,
     442,   443,     0,   444,     0,   445,   446,   447,   158,   448,
       0,   160,     0,   449,   450,   162,     0,   451,     0,   452,
     163,     0,   164,   453,     0,   454,     0,   455,   167,     0,
     456,     0,   457,   458,   459,  1142,   168,   461,   462,   463,
       0,   464,   465,   466,   467,   468,   469,     0,   169,   170,
       0,   470,   471,   472,     0,   172,     0,   173,     0,     0,
     174,   175,   473,   176,   474,   475,   476,   477,   478,     0,
     177,   178,   479,   179,     0,   480,   481,   482,     0,     0,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   184,   185,   186,   750,   494,   495,   496,   497,   498,
     499,   500,   187,   501,     0,   502,   503,   189,   504,     0,
     190,   191,   505,   506,     0,     0,   507,   751,     0,     0,
     508,   509,     0,     0,   192,   193,   194,   195,   510,   511,
     512,   513,     0,   196,   197,   514,   515,   516,     0,   517,
     518,   519,   520,   521,   522,   199,   523,   524,     0,   525,
     526,   527,   528,   529,   530,   531,   532,   533,     0,   534,
     535,   205,   536,   537,   207,   538,   539,   540,   541,   542,
     543,     0,     0,   544,   545,   546,     0,   547,   211,   548,
     549,   213,   550,   214,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   216,   559,     0,   560,   561,     0,   562,
     563,   564,   565,     0,   217,   218,     0,     0,   567,   219,
     568,   220,     0,   569,   570,   571,   572,   573,     0,     0,
     574,   575,   576,   577,     0,     0,   578,   579,     0,   580,
     228,   581,   229,   582,     0,     0,     0,   583,   584,   585,
     586,   587,   588,     0,     0,     0,   230,     0,     0,   231,
      81,    82,    83,   373,    85,    86,     0,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   376,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,   399,   400,   401,     0,   135,     0,
     137,     0,     0,   402,   403,     0,   404,   405,     0,     0,
     406,   407,   138,   408,  1921,   409,   410,   411,   412,   142,
       0,     0,   413,   414,   415,   416,   417,  1922,   418,   419,
     145,   420,     0,   421,   422,   423,     0,   424,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   151,   152,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,   438,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,   158,   448,     0,
     160,     0,   449,   450,   162,     0,   451,  1923,   452,     0,
       0,     0,   453,     0,   454,     0,   455,   167,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,     0,   170,     0,
     470,   471,   472,     0,   172,     0,   173,     0,     0,     0,
       0,   473,     0,   474,   475,   476,   477,   478,     0,   177,
       0,   479,  2552,     0,   480,   481,   482,     0,     0,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     184,     0,   186,     0,   494,   495,   496,   497,   498,   499,
     500,   187,   501,     0,   502,   503,     0,   504,     0,   190,
     191,   505,   506,     0,     0,   507,     0,     0,     0,   508,
     509,     0,     0,   192,     0,     0,   195,   510,   511,   512,
     513,     0,   196,   197,   514,   515,   516,  1924,   517,   518,
     519,   520,   521,   522,   199,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
       0,   536,   537,   207,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   546,     0,   547,   211,   548,   549,
       0,   550,   214,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   216,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,   217,   218,     0,     0,   567,   219,   568,
     220,     0,   569,   570,   571,   572,   573,     0,  1925,   574,
     575,   576,   577,     0,     0,   578,   579,     0,   580,   228,
     581,     0,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,     0,     0,   231,    81,
      82,    83,   373,    85,    86,     0,    87,    88,    89,   374,
       0,   375,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   376,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   117,   377,   378,     0,     0,     0,   379,   380,
       0,     0,     0,     0,   381,     0,     0,     0,     0,     0,
       0,     0,     0,   382,     0,   383,     0,   384,   385,     0,
     386,   387,   388,   389,   390,   391,   392,   393,   854,   394,
     395,     0,     0,     0,     0,     0,     0,     0,   396,   397,
       0,   398,     0,   399,   400,   401,     0,   135,     0,   137,
       0,     0,   402,   403,     0,   404,   405,     0,     0,   406,
     407,   138,   408,     0,   409,   410,   411,   412,   142,     0,
       0,   413,   414,   415,   416,   417,     0,   418,   419,   145,
     420,   855,   421,   422,   423,     0,   424,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   151,   152,   430,
       0,   431,     0,   432,     0,   433,   434,   435,     0,   436,
       0,     0,   437,   438,   439,   440,     0,   441,   442,   443,
       0,   444,     0,   445,   446,   447,   158,   448,     0,   160,
       0,   449,   450,   162,     0,   451,     0,   452,     0,     0,
       0,   453,     0,   454,   896,   455,   167,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,   463,     0,   464,
     465,   466,   467,   468,   469,     0,     0,   170,     0,   470,
     471,   472,     0,   172,     0,   173,     0,     0,     0,     0,
     473,     0,   474,   475,   476,   477,   478,     0,   177,     0,
     479,     0,     0,   480,   481,   482,     0,     0,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   184,
       0,   186,     0,   494,   495,   496,   497,   498,   499,   500,
     187,   501,     0,   502,   503,     0,   504,     0,   190,   191,
     505,   506,     0,     0,   507,     0,     0,     0,   508,   509,
       0,     0,   192,     0,     0,   195,   510,   511,   512,   513,
       0,   196,   197,   514,   515,   516,     0,   517,   518,   519,
     520,   521,   522,   199,   523,   524,   856,   525,   526,   527,
     528,   529,   530,   531,   532,   533,     0,   534,   535,     0,
     536,   537,   207,   538,   539,   540,   541,   542,   543,     0,
     857,   544,   545,   546,     0,   547,   211,   548,   549,     0,
     550,   214,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   216,   559,     0,   560,   561,     0,   562,   563,   564,
     565,     0,   217,   218,     0,     0,   567,   219,   568,   220,
       0,   569,   570,   571,   572,   573,     0,     0,   574,   575,
     576,   577,     0,     0,   578,   579,     0,   580,   228,   581,
       0,   582,     0,     0,     0,   583,   584,   585,   586,   587,
     588,     0,     0,     0,   230,     0,     0,   231,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,   854,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
     855,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,   856,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,   857,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,     0,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   580,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   376,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,     0,   394,   395,   129,
     130,     0,     0,     0,     0,     0,   396,   397,     0,   398,
       0,   399,   400,   401,     0,   135,     0,   137,     0,     0,
     402,   403,     0,   404,   405,     0,     0,   406,   407,   138,
     408,     0,   409,   410,   411,   412,   142,     0,     0,   413,
     414,   415,   416,   417,     0,   418,   419,   145,   420,     0,
     421,   422,   423,     0,   424,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   151,   152,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,   438,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,   158,   448,     0,   160,     0,   449,
     450,   162,     0,   451,     0,   452,     0,     0,     0,   453,
       0,   454,     0,   455,   167,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,     0,   170,     0,   470,   471,   472,
       0,   172,     0,   173,     0,     0,     0,     0,   473,     0,
     474,   475,   476,   477,   478,     0,   177,     0,   479,     0,
       0,   480,   481,   482,     0,     0,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,     0,   186,
     750,   494,   495,   496,   497,   498,   499,   500,   187,   501,
       0,   502,   503,     0,   504,     0,   190,   191,   505,   506,
       0,     0,   507,   751,     0,     0,   508,   509,     0,     0,
     192,     0,     0,   195,   510,   511,   512,   513,     0,   196,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,   199,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,     0,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   546,     0,   547,   211,   548,   549,     0,   550,   214,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   216,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
     217,   218,     0,     0,   567,   219,   568,   220,     0,   569,
     570,   571,   572,   573,     0,     0,   574,   575,   576,   577,
       0,     0,   578,   579,     0,   580,   228,   581,     0,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,     0,     0,   231,    81,    82,    83,   373,
      85,    86,     0,    87,    88,    89,   374,     0,   375,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   376,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   117,
     377,   378,     0,     0,     0,   379,   380,     0,     0,     0,
       0,   381,     0,     0,     0,     0,     0,     0,     0,     0,
     382,     0,   383,     0,   384,   385,     0,   386,   387,   388,
     389,   390,   391,   392,   393,     0,   394,   395,     0,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
     399,   400,   401,     0,   135,     0,   137,     0,     0,   402,
     403,     0,   404,   405,     0,     0,   406,   407,   138,   408,
       0,   409,   410,   411,   412,   142,     0,     0,   413,   414,
     415,   416,   417,     0,   418,   419,   145,   420,     0,   421,
     422,   423,     0,   424,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   151,   152,   430,     0,   431,     0,
     432,     0,   433,   434,   435,     0,   436,     0,     0,   437,
     438,   439,   440,     0,   441,   442,   443,     0,   444,     0,
     445,   446,   447,   158,   448,     0,   160,     0,   449,   450,
     162,     0,   451,     0,   452,     0,     0,     0,   453,     0,
     454,     0,   455,   167,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,   463,     0,   464,   465,   466,   467,
     468,   469,     0,     0,   170,     0,   470,   471,   472,     0,
     172,     0,   173,     0,     0,     0,     0,   473,     0,   474,
     475,   476,   477,   478,     0,   177,     0,   479,     0,     0,
     480,   481,   482,     0,     0,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   184,     0,   186,   750,
     494,   495,   496,   497,   498,   499,   500,   187,   501,     0,
     502,   503,     0,   504,     0,   190,   191,   505,   506,     0,
       0,   507,   751,     0,   928,   508,   509,     0,     0,   192,
       0,     0,   195,   510,   511,   512,   513,     0,   196,   197,
     514,   515,   516,     0,   517,   518,   519,   520,   521,   522,
     199,   523,   524,     0,   525,   526,   527,   528,   529,   530,
     531,   532,   533,     0,   534,   535,     0,   536,   537,   207,
     538,   539,   540,   541,   542,   543,     0,     0,   544,   545,
     546,     0,   547,   211,   548,   549,     0,   550,   214,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   216,   559,
       0,   560,   561,     0,   562,   563,   564,   565,     0,   217,
     218,     0,     0,   567,   219,   568,   220,     0,   569,   570,
     571,   572,   573,     0,     0,   574,   575,   576,   577,     0,
       0,   578,   579,     0,   580,   228,   581,     0,   582,     0,
       0,     0,   583,   584,   585,   586,   587,   588,     0,     0,
       0,   230,     0,     0,   231,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   376,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,  1314,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,   135,     0,   137,     0,     0,   402,   403,
       0,   404,   405,     0,     0,   406,   407,   138,   408,     0,
     409,   410,   411,   412,   142,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,   145,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   151,   152,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,   438,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,   158,   448,     0,   160,     0,   449,   450,   162,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,   167,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,   170,     0,   470,   471,   472,     0,   172,
       0,   173,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,   177,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   184,     0,   186,   750,   494,
     495,   496,   497,   498,   499,   500,   187,   501,     0,   502,
     503,     0,   504,     0,   190,   191,   505,   506,     0,     0,
     507,   751,     0,     0,   508,   509,     0,     0,   192,     0,
       0,   195,   510,   511,   512,   513,     0,   196,   197,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,   199,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,   207,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,   211,   548,   549,     0,   550,   214,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   216,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,   217,   218,
       0,     0,   567,   219,   568,   220,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,   580,   228,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,  1657,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,  1658,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,  1659,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,   750,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
     751,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,  1660,   542,   543,     0,     0,  1661,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,  1662,  1663,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   376,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,   399,   400,   401,
       0,   135,     0,   137,     0,     0,   402,   403,     0,   404,
     405,     0,     0,   406,   407,   138,   408,     0,   409,   410,
     411,   412,   142,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,   145,   420,   855,   421,   422,   423,     0,
     424,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   151,   152,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,   438,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
     158,   448,     0,   160,     0,   449,   450,   162,     0,   451,
       0,   452,     0,     0,     0,   453,     0,   454,     0,   455,
     167,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
       0,   170,     0,   470,   471,   472,     0,   172,     0,   173,
       0,     0,     0,     0,   473,     0,   474,   475,   476,   477,
     478,     0,   177,     0,   479,     0,     0,   480,   481,   482,
       0,     0,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   184,     0,   186,     0,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,     0,
     504,     0,   190,   191,   505,   506,     0,     0,   507,     0,
       0,     0,   508,   509,     0,     0,   192,     0,     0,   195,
     510,   511,   512,   513,     0,   196,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,   199,   523,   524,
     856,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,     0,   536,   537,   207,   538,   539,   540,
     541,   542,   543,     0,   857,   544,   545,   546,     0,   547,
     211,   548,   549,     0,   550,   214,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   216,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,   217,   218,     0,     0,
     567,   219,   568,   220,     0,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,     0,     0,   578,   579,
       0,   580,   228,   581,     0,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,     0,
       0,   231,    81,    82,    83,   373,    85,    86,     0,    87,
      88,    89,   374,     0,   375,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   376,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   117,   377,   378,     0,     0,
       0,   379,   380,     0,     0,     0,     0,   381,     0,     0,
       0,     0,     0,     0,     0,     0,   382,     0,   383,     0,
     384,   385,     0,   386,   387,   388,   389,   390,   391,   392,
     393,     0,   394,   395,     0,     0,     0,     0,     0,     0,
       0,   396,   397,     0,   398,     0,   399,   400,   401,     0,
     135,     0,   137,     0,     0,   402,   403,     0,   404,   405,
       0,     0,   406,   407,   138,   408,     0,   409,   410,   411,
     412,   142,     0,     0,   413,   414,   415,   416,   417,     0,
     418,   419,   145,   420,     0,   421,   422,   423,     0,   424,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     151,   152,   430,     0,   431,     0,   432,     0,   433,   434,
     435,     0,   436,     0,     0,   437,   438,   439,   440,     0,
     441,   442,   443,     0,   444,     0,   445,   446,   447,   158,
     448,     0,   160,     0,   449,   450,   162,     0,   451,     0,
     452,     0,     0,     0,   453,     0,   454,     0,   455,   167,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
     463,     0,   464,   465,   466,   467,   468,   469,     0,     0,
     170,     0,   470,   471,   472,     0,   172,     0,   173,     0,
       0,     0,     0,   473,     0,   474,   475,   476,   477,   478,
       0,   177,     0,   479,     0,     0,   480,   481,   482,     0,
       0,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   184,     0,   186,   750,   494,   495,   496,   497,
     498,   499,   500,   187,   501,     0,   502,   503,     0,   504,
       0,   190,   191,   505,   506,     0,     0,   507,   751,     0,
       0,   508,   509,     0,     0,   192,     0,     0,   195,   510,
     511,   512,   513,     0,   196,   197,   514,   515,   516,     0,
     517,   518,   519,   520,   521,   522,   199,   523,   524,     0,
     525,   526,   527,   528,   529,   530,   531,   532,   533,     0,
     534,   535,     0,   536,   537,   207,   538,   539,   540,   541,
     542,   543,     0,     0,   544,   545,   546,     0,   547,   211,
     548,   549,     0,   550,   214,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   216,   559,     0,   560,   561,     0,
     562,   563,   564,   565,     0,   217,   218,     0,     0,   567,
     219,   568,   220,     0,   569,   570,   571,   572,   573,     0,
       0,   574,   575,   576,   577,     0,     0,   578,   579,     0,
     580,   228,   581,     0,   582,     0,     0,     0,   583,   584,
     585,   586,   587,   588,     0,     0,     0,   230,     0,     0,
     231,    81,    82,    83,   373,    85,    86,     0,    87,    88,
      89,   374,     0,   375,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   376,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   117,   377,   378,     0,     0,     0,
     379,   380,     0,     0,     0,     0,   381,     0,     0,     0,
       0,     0,     0,     0,     0,   382,     0,   383,     0,   384,
     385,     0,   386,   387,   388,   389,   390,   391,   392,   393,
       0,   394,   395,     0,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,   399,   400,   401,     0,   135,
       0,   137,     0,     0,   402,   403,     0,   404,   405,     0,
       0,   406,   407,   138,   408,     0,   409,   410,   411,   412,
     142,     0,     0,   413,   414,   415,   416,   417,     0,   418,
     419,   145,   420,     0,   421,   422,   423,     0,   424,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   151,
     152,   430,     0,   431,     0,   432,     0,   433,   434,   435,
       0,   436,     0,     0,   437,   438,   439,   440,     0,   441,
     442,   443,     0,   444,     0,   445,   446,   447,   158,   448,
       0,   160,     0,   449,   450,   162,     0,   451,     0,   452,
       0,   839,     0,   453,     0,   454,     0,   455,   167,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,   463,
     840,   464,   465,   466,   467,   468,   469,     0,     0,   170,
       0,   470,   471,   472,     0,   172,     0,   173,     0,     0,
       0,     0,   473,     0,   474,   475,   476,   477,   478,     0,
     177,     0,   479,     0,     0,   480,   481,   482,     0,     0,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   184,     0,   186,     0,   494,   495,   496,   497,   498,
     499,   500,   187,   501,     0,   502,   503,     0,   504,     0,
     190,   191,   505,   506,     0,     0,   507,     0,     0,     0,
     508,   509,     0,     0,   192,     0,     0,   195,   510,   511,
     512,   513,     0,   196,   197,   514,   515,   516,     0,   517,
     518,   519,   520,   521,   522,   199,   523,   524,     0,   525,
     526,   527,   528,   529,   530,   531,   532,   533,     0,   534,
     535,     0,   536,   537,   207,   538,   539,   540,   541,   542,
     543,     0,     0,   544,   545,   546,     0,   547,   211,   548,
     549,     0,   550,   214,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   216,   559,     0,   560,   561,     0,   562,
     563,   564,   565,     0,   217,   218,     0,     0,   567,   219,
     568,   220,     0,   569,   570,   571,   572,   573,     0,     0,
     574,   575,   576,   577,     0,     0,   578,   579,     0,   580,
     228,   581,     0,   582,     0,     0,     0,   583,   584,   585,
     586,   587,   588,     0,     0,     0,   230,     0,     0,   231,
      81,    82,    83,   373,    85,    86,     0,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   376,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,  2469,
     394,   395,     0,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,   399,   400,   401,     0,   135,     0,
     137,     0,     0,   402,   403,     0,   404,   405,     0,     0,
     406,   407,   138,   408,     0,   409,   410,   411,   412,   142,
       0,     0,   413,   414,   415,   416,   417,     0,   418,   419,
     145,   420,     0,   421,   422,   423,     0,   424,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   151,   152,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,   438,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,   158,   448,     0,
     160,     0,   449,   450,   162,     0,   451,     0,   452,     0,
       0,     0,   453,     0,   454,     0,   455,   167,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,     0,   170,     0,
     470,   471,   472,     0,   172,     0,   173,     0,     0,     0,
       0,   473,     0,   474,   475,   476,   477,   478,     0,   177,
       0,   479,     0,     0,   480,   481,   482,     0,     0,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     184,     0,   186,     0,   494,   495,   496,   497,   498,   499,
     500,   187,   501,     0,   502,   503,     0,   504,     0,   190,
     191,   505,   506,     0,     0,   507,     0,     0,     0,   508,
     509,     0,     0,   192,     0,     0,   195,   510,   511,   512,
     513,     0,   196,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,   199,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
       0,   536,   537,   207,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   546,     0,   547,   211,   548,   549,
       0,   550,   214,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   216,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,   217,   218,     0,     0,   567,   219,   568,
     220,     0,   569,   570,   571,   572,   573,     0,     0,   574,
     575,   576,   577,  2470,     0,   578,   579,     0,   580,   228,
     581,     0,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,     0,     0,   231,    81,
      82,    83,   373,    85,    86,     0,    87,    88,    89,   374,
       0,   375,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   376,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   117,   377,   378,     0,     0,     0,   379,   380,
       0,     0,     0,     0,   381,     0,     0,     0,     0,     0,
       0,     0,     0,   382,     0,   383,     0,   384,   385,     0,
     386,   387,   388,   389,   390,   391,   392,   393,  2474,   394,
     395,     0,     0,     0,     0,     0,     0,     0,   396,   397,
       0,   398,     0,   399,   400,   401,     0,   135,     0,   137,
       0,     0,   402,   403,     0,   404,   405,     0,     0,   406,
     407,   138,   408,     0,   409,   410,   411,   412,   142,     0,
       0,   413,   414,   415,   416,   417,     0,   418,   419,   145,
     420,     0,   421,   422,   423,     0,   424,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   151,   152,   430,
       0,   431,     0,   432,     0,   433,   434,   435,     0,   436,
       0,     0,   437,   438,   439,   440,     0,   441,   442,   443,
       0,   444,     0,   445,   446,   447,   158,   448,     0,   160,
       0,   449,   450,   162,     0,   451,     0,   452,     0,     0,
       0,   453,     0,   454,     0,   455,   167,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,   463,     0,   464,
     465,   466,   467,   468,   469,     0,     0,   170,     0,   470,
     471,   472,     0,   172,     0,   173,     0,     0,     0,     0,
     473,     0,   474,   475,   476,   477,   478,     0,   177,     0,
     479,     0,     0,   480,   481,   482,     0,     0,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   184,
       0,   186,     0,   494,   495,   496,   497,   498,   499,   500,
     187,   501,     0,   502,   503,     0,   504,     0,   190,   191,
     505,   506,     0,     0,   507,     0,     0,     0,   508,   509,
       0,     0,   192,     0,     0,   195,   510,   511,   512,   513,
       0,   196,   197,   514,   515,   516,     0,   517,   518,   519,
     520,   521,   522,   199,   523,   524,     0,   525,   526,   527,
     528,   529,   530,   531,   532,   533,     0,   534,   535,     0,
     536,   537,   207,   538,   539,   540,   541,   542,   543,     0,
       0,   544,   545,   546,     0,   547,   211,   548,   549,     0,
     550,   214,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   216,   559,     0,   560,   561,     0,   562,   563,   564,
     565,     0,   217,   218,     0,     0,   567,   219,   568,   220,
       0,   569,   570,   571,   572,   573,     0,     0,   574,   575,
     576,   577,  2475,     0,   578,   579,     0,   580,   228,   581,
       0,   582,     0,     0,     0,   583,   584,   585,   586,   587,
     588,     0,     0,     0,   230,     0,     0,   231,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,  2588,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   407,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,   417,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   546,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   217,   218,     0,     0,   567,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   580,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   376,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,     0,   394,   395,     0,
       0,     0,     0,     0,  2601,     0,   396,   397,     0,   398,
       0,   399,   400,   401,     0,   135,     0,   137,     0,     0,
     402,   403,     0,   404,   405,     0,     0,   406,   407,   138,
     408,     0,   409,   410,   411,   412,   142,     0,     0,   413,
     414,   415,   416,   417,     0,   418,   419,   145,   420,     0,
     421,   422,   423,     0,   424,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   151,   152,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,   438,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,   158,   448,     0,   160,     0,   449,
     450,   162,     0,   451,     0,   452,     0,     0,     0,   453,
       0,   454,     0,   455,   167,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,     0,   170,     0,   470,   471,   472,
       0,   172,     0,   173,     0,     0,     0,     0,   473,     0,
     474,   475,   476,   477,   478,     0,   177,     0,   479,     0,
       0,   480,   481,   482,     0,     0,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,     0,   186,
       0,   494,   495,   496,   497,   498,   499,   500,   187,   501,
       0,   502,   503,     0,   504,     0,   190,   191,   505,   506,
       0,     0,   507,     0,     0,     0,   508,   509,     0,     0,
     192,     0,     0,   195,   510,   511,   512,   513,     0,   196,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,   199,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,     0,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   546,     0,   547,   211,   548,   549,     0,   550,   214,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   216,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
     217,   218,     0,     0,   567,   219,   568,   220,     0,   569,
     570,   571,   572,   573,     0,     0,   574,   575,   576,   577,
       0,     0,   578,   579,     0,   580,   228,   581,     0,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,     0,     0,   231,    81,    82,    83,   373,
      85,    86,     0,    87,    88,    89,   374,     0,   375,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   376,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   117,
     377,   378,     0,     0,     0,   379,   380,     0,     0,     0,
       0,   381,     0,     0,     0,     0,     0,     0,     0,     0,
     382,     0,   383,     0,   384,   385,     0,   386,   387,   388,
     389,   390,   391,   392,   393,     0,   394,   395,     0,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
     399,   400,   401,     0,   135,     0,   137,     0,     0,   402,
     403,     0,   404,   405,     0,     0,   406,   407,   138,   408,
       0,   409,   410,   411,   412,   142,     0,     0,   413,   414,
     415,   416,   417,     0,   418,   419,   145,   420,     0,   421,
     422,   423,     0,   424,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   151,   152,   430,     0,   431,     0,
     432,     0,   433,   434,   435,     0,   436,     0,     0,   437,
     438,   439,   440,     0,   441,   442,   443,     0,   444,     0,
     445,   446,   447,   158,   448,     0,   160,     0,   449,   450,
     162,     0,   451,     0,   452,     0,     0,     0,   453,     0,
     454,     0,   455,   167,  2630,   456,     0,   457,   458,   459,
     460,     0,   461,   462,   463,     0,   464,   465,   466,   467,
     468,   469,     0,     0,   170,     0,   470,   471,   472,     0,
     172,     0,   173,     0,     0,     0,     0,   473,     0,   474,
     475,   476,   477,   478,     0,   177,     0,   479,     0,     0,
     480,   481,   482,     0,     0,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   184,     0,   186,     0,
     494,   495,   496,   497,   498,   499,   500,   187,   501,     0,
     502,   503,     0,   504,     0,   190,   191,   505,   506,     0,
       0,   507,     0,     0,     0,   508,   509,     0,     0,   192,
       0,     0,   195,   510,   511,   512,   513,     0,   196,   197,
     514,   515,   516,     0,   517,   518,   519,   520,   521,   522,
     199,   523,   524,     0,   525,   526,   527,   528,   529,   530,
     531,   532,   533,     0,   534,   535,     0,   536,   537,   207,
     538,   539,   540,   541,   542,   543,     0,     0,   544,   545,
     546,     0,   547,   211,   548,   549,     0,   550,   214,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   216,   559,
       0,   560,   561,     0,   562,   563,   564,   565,     0,   217,
     218,     0,     0,   567,   219,   568,   220,     0,   569,   570,
     571,   572,   573,     0,     0,   574,   575,   576,   577,     0,
       0,   578,   579,     0,   580,   228,   581,     0,   582,     0,
       0,     0,   583,   584,   585,   586,   587,   588,     0,     0,
       0,   230,     0,     0,   231,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   376,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,   135,     0,   137,     0,     0,   402,   403,
       0,   404,   405,     0,     0,   406,   407,   138,   408,     0,
     409,   410,   411,   412,   142,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,   145,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   151,   152,   430,  2910,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,   438,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,   158,   448,     0,   160,     0,   449,   450,   162,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,   167,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,   170,     0,   470,   471,   472,     0,   172,
       0,   173,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,   177,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   184,     0,   186,     0,   494,
     495,   496,   497,   498,   499,   500,   187,   501,     0,   502,
     503,     0,   504,     0,   190,   191,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,   192,     0,
       0,   195,   510,   511,   512,   513,     0,   196,   197,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,   199,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,   207,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,   211,   548,   549,     0,   550,   214,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   216,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,   217,   218,
       0,     0,   567,   219,   568,   220,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,   580,   228,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,  2912,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   376,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,   399,   400,   401,
       0,   135,     0,   137,     0,     0,   402,   403,     0,   404,
     405,     0,     0,   406,   407,   138,   408,     0,   409,   410,
     411,   412,   142,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,   145,   420,     0,   421,   422,   423,     0,
     424,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   151,   152,   430,  2914,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,   438,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
     158,   448,     0,   160,     0,   449,   450,   162,     0,   451,
       0,   452,     0,     0,     0,   453,     0,   454,     0,   455,
     167,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
       0,   170,     0,   470,   471,   472,     0,   172,     0,   173,
       0,     0,     0,     0,   473,     0,   474,   475,   476,   477,
     478,     0,   177,     0,   479,     0,     0,   480,   481,   482,
       0,     0,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   184,     0,   186,     0,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,     0,
     504,     0,   190,   191,   505,   506,     0,     0,   507,     0,
       0,     0,   508,   509,     0,     0,   192,     0,     0,   195,
     510,   511,   512,   513,     0,   196,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,   199,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,     0,   536,   537,   207,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,     0,   547,
     211,   548,   549,     0,   550,   214,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   216,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,   217,   218,     0,     0,
     567,   219,   568,   220,     0,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,     0,     0,   578,   579,
       0,   580,   228,   581,     0,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,     0,
       0,   231,    81,    82,    83,   373,    85,    86,     0,    87,
      88,    89,   374,     0,   375,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   376,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   117,   377,   378,     0,     0,
       0,   379,   380,     0,     0,     0,     0,   381,     0,     0,
       0,     0,     0,     0,     0,     0,   382,     0,   383,     0,
     384,   385,     0,   386,   387,   388,   389,   390,   391,   392,
     393,     0,   394,   395,     0,     0,     0,     0,     0,     0,
       0,   396,   397,     0,   398,     0,   399,   400,   401,     0,
     135,     0,   137,     0,     0,   402,   403,     0,   404,   405,
       0,     0,   406,   407,   138,   408,     0,   409,   410,   411,
     412,   142,     0,     0,   413,   414,   415,   416,   417,     0,
     418,   419,   145,   420,     0,   421,   422,   423,     0,   424,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     151,   152,   430,     0,   431,     0,   432,     0,   433,   434,
     435,     0,   436,     0,     0,   437,   438,   439,   440,     0,
     441,   442,   443,     0,   444,     0,   445,   446,   447,   158,
     448,     0,   160,     0,   449,   450,   162,     0,   451,     0,
     452,     0,     0,     0,   453,     0,   454,     0,   455,   167,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
     463,     0,   464,   465,   466,   467,   468,   469,     0,     0,
     170,     0,   470,   471,   472,     0,   172,     0,   173,     0,
       0,     0,     0,   473,     0,   474,   475,   476,   477,   478,
       0,   177,     0,   479,     0,     0,   480,   481,   482,     0,
       0,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   184,     0,   186,     0,   494,   495,   496,   497,
     498,   499,   500,   187,   501,     0,   502,   503,     0,   504,
       0,   190,   191,   505,   506,     0,     0,   507,     0,     0,
       0,   508,   509,     0,     0,   192,     0,     0,   195,   510,
     511,   512,   513,     0,   196,   197,   514,   515,   516,     0,
     517,   518,   519,   520,   521,   522,   199,   523,   524,     0,
     525,   526,   527,   528,   529,   530,   531,   532,   533,     0,
     534,   535,     0,   536,   537,   207,   538,   539,   540,   541,
     542,   543,     0,     0,   544,   545,   546,     0,   547,   211,
     548,   549,     0,   550,   214,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   216,   559,     0,   560,   561,     0,
     562,   563,   564,   565,     0,   217,   218,     0,     0,   567,
     219,   568,   220,     0,   569,   570,   571,   572,   573,     0,
       0,   574,   575,   576,   577,     0,  3416,   578,   579,     0,
     580,   228,   581,     0,   582,     0,     0,     0,   583,   584,
     585,   586,   587,   588,     0,     0,     0,   230,     0,     0,
     231,    81,    82,    83,   373,    85,    86,     0,    87,    88,
      89,   374,     0,   375,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   376,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   117,   377,   378,     0,     0,     0,
     379,   380,     0,     0,     0,     0,   381,     0,     0,     0,
       0,     0,     0,     0,     0,   382,     0,   383,     0,   384,
     385,     0,   386,   387,   388,   389,   390,   391,   392,   393,
       0,   394,   395,     0,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,   399,   400,   401,     0,   135,
       0,   137,     0,     0,   402,   403,     0,   404,   405,     0,
       0,   406,   407,   138,   408,     0,   409,   410,   411,   412,
     142,     0,     0,   413,   414,   415,   416,   417,     0,   418,
     419,   145,   420,     0,   421,   422,   423,     0,   424,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   151,
     152,   430,     0,   431,     0,   432,     0,   433,   434,   435,
       0,   436,     0,     0,   437,   438,   439,   440,     0,   441,
     442,   443,     0,   444,     0,   445,   446,   447,   158,   448,
       0,   160,     0,   449,   450,   162,     0,   451,     0,   452,
       0,     0,     0,   453,     0,   454,     0,   455,   167,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,   463,
       0,   464,   465,   466,   467,   468,   469,     0,     0,   170,
       0,   470,   471,   472,     0,   172,     0,   173,     0,     0,
       0,     0,   473,     0,   474,   475,   476,   477,   478,     0,
     177,     0,   479,     0,     0,   480,   481,   482,     0,     0,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   184,     0,   186,     0,   494,   495,   496,   497,   498,
     499,   500,   187,   501,     0,   502,   503,     0,   504,     0,
     190,   191,   505,   506,     0,     0,   507,     0,     0,     0,
     508,   509,     0,     0,   192,     0,     0,   195,   510,   511,
     512,   513,     0,   196,   197,   514,   515,   516,     0,   517,
     518,   519,   520,   521,   522,   199,   523,   524,     0,   525,
     526,   527,   528,   529,   530,   531,   532,   533,     0,   534,
     535,     0,   536,   537,   207,   538,   539,   540,   541,   542,
     543,     0,     0,   544,   545,   546,     0,   547,   211,   548,
     549,     0,   550,   214,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   216,   559,     0,   560,   561,     0,   562,
     563,   564,   565,     0,   217,   218,     0,     0,   567,   219,
     568,   220,     0,   569,   570,   571,   572,   573,     0,     0,
     574,   575,   576,   577,     0,     0,   578,   579,     0,   580,
     228,   581,     0,   582,     0,     0,     0,   583,   584,   585,
     586,   587,   588,     0,     0,     0,   230,     0,     0,   231,
      81,    82,    83,   373,    85,    86,     0,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   376,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,   399,   400,   401,     0,   135,     0,
     137,     0,     0,   402,   403,     0,   404,   405,     0,     0,
     406,   407,   138,   408,     0,   409,   410,   411,   412,   142,
       0,     0,   413,   414,   415,   416,   417,     0,   418,   419,
     145,   420,     0,   421,   422,   423,     0,   424,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   151,   152,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,   438,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,   158,   448,     0,
     160,     0,   449,   450,   162,     0,   451,     0,   452,     0,
       0,     0,   453,     0,   454,     0,   455,   167,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,     0,   170,     0,
     470,   471,   472,     0,   172,     0,   173,     0,     0,     0,
       0,   473,     0,   474,   475,   476,   477,   478,     0,   177,
       0,   479,     0,     0,   480,   481,   482,     0,     0,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     184,     0,   186,     0,   494,   495,   496,   497,   498,   499,
     500,   187,   501,     0,   502,   503,     0,   504,     0,   190,
     191,   505,   506,     0,     0,   507,     0,     0,     0,   508,
     509,     0,     0,   192,     0,     0,   195,   510,   511,   512,
     513,     0,   196,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,   199,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
       0,   536,   537,   207,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   546,     0,   547,   211,   548,   549,
       0,   550,   214,     0,   551,   552,   802,   554,   555,   556,
     557,   558,   216,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,   217,   218,     0,     0,   567,   219,   568,
     220,     0,   569,   570,   571,   572,   573,     0,     0,   574,
     575,   576,   577,     0,     0,   578,   579,     0,   580,   228,
     581,     0,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,     0,     0,   231,    81,
      82,    83,   373,    85,    86,     0,    87,    88,    89,   374,
       0,   375,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   376,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   117,   377,   378,     0,     0,     0,   379,   380,
       0,     0,     0,     0,   381,     0,     0,     0,     0,     0,
       0,     0,     0,   382,     0,   383,     0,   384,   385,     0,
     386,   387,   388,   389,   390,   391,   392,   393,     0,   394,
     395,     0,     0,     0,     0,     0,     0,     0,   396,   397,
       0,   398,     0,   399,   400,   401,     0,   135,     0,   137,
       0,     0,   402,   403,     0,   404,   405,     0,     0,   406,
     407,   138,   408,     0,   409,   410,   411,   412,   142,     0,
       0,   413,   414,   415,   416,   417,     0,   418,   419,   145,
     420,     0,   421,   422,   423,     0,   424,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   151,   152,   430,
       0,   431,     0,   432,     0,   433,   434,   435,     0,   436,
       0,     0,   437,   438,   439,   440,     0,   441,   442,   443,
       0,   444,     0,   445,   446,   447,   158,   448,     0,   160,
       0,   449,   450,   162,     0,   451,     0,   452,     0,     0,
       0,   453,     0,   454,     0,   455,   167,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,   463,     0,   464,
     465,   466,   467,   468,   469,     0,     0,   170,     0,   470,
     471,   472,     0,   172,     0,   173,     0,     0,     0,     0,
     473,     0,   474,   475,   476,   477,   478,     0,   177,     0,
     479,     0,     0,   480,   481,   482,     0,     0,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   184,
       0,   186,     0,   494,   495,   496,   497,   498,   499,   500,
     187,   501,     0,   502,   503,     0,   504,     0,   190,   191,
     505,   506,     0,     0,   507,     0,     0,     0,   508,   509,
       0,     0,   192,     0,     0,   195,   510,   511,   512,   513,
       0,   196,   197,   514,   515,   516,     0,   517,   518,   519,
     520,   521,   522,   199,   523,   524,     0,   525,   526,   527,
     528,   529,   530,   531,   532,   533,     0,   534,   535,     0,
     536,   537,   207,   538,   539,   880,   541,   542,   543,     0,
       0,   544,   545,   546,     0,   547,   211,   548,   549,     0,
     550,   214,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   216,   559,     0,   560,   561,     0,   562,   563,   564,
     565,     0,   217,   218,     0,     0,   567,   219,   568,   220,
       0,   569,   570,   571,   572,   573,     0,     0,   574,   575,
     576,   577,     0,     0,   578,   579,     0,   580,   228,   581,
       0,   582,     0,     0,     0,   583,   584,   585,   586,   587,
     588,     0,     0,     0,   230,     0,     0,   231,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,   882,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   883,
     138,   408,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,     0,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   536,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,   884,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   885,   218,     0,     0,   886,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   887,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   376,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,   917,   394,   395,     0,
       0,     0,     0,     0,     0,     0,   396,   397,     0,   398,
       0,   399,   400,   401,     0,   135,     0,   137,     0,     0,
     402,   403,     0,   404,   405,     0,     0,   406,   883,   138,
     408,     0,   409,   410,   411,   412,   142,     0,     0,   413,
     414,   415,   416,     0,     0,   418,   419,   145,   420,     0,
     421,   422,   423,     0,   424,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   151,   152,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,   438,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,   158,   448,     0,   160,     0,   449,
     450,   162,     0,   451,     0,   452,     0,     0,     0,   453,
       0,   454,     0,   455,   167,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,     0,   170,     0,   470,   471,   472,
       0,   172,     0,   173,     0,     0,     0,     0,   473,     0,
     474,   475,   476,   477,   478,     0,   177,     0,   479,     0,
       0,   480,   481,   482,     0,     0,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,     0,   186,
       0,   494,   495,   496,   497,   498,   499,   500,   187,   501,
       0,   502,   503,     0,   504,     0,   190,   191,   505,   506,
       0,     0,   507,     0,     0,     0,   508,   509,     0,     0,
     192,     0,     0,   195,   510,   511,   512,   513,     0,   196,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,   199,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,     0,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   918,     0,   547,   211,   548,   549,     0,   550,   214,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   216,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
     919,   218,     0,     0,   920,   219,   568,   220,     0,   569,
     570,   571,   572,   573,     0,     0,   574,   575,   576,   577,
       0,     0,   578,   579,     0,   887,   228,   581,     0,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,     0,     0,   231,    81,    82,    83,   373,
      85,    86,     0,    87,    88,    89,   374,     0,   375,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   376,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   117,
     377,   378,     0,     0,     0,   379,   380,     0,     0,     0,
       0,   381,     0,     0,     0,     0,     0,     0,     0,     0,
     382,     0,   383,     0,   384,   385,     0,   386,   387,   388,
     389,   390,   391,   392,   393,     0,   394,   395,     0,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
     399,   400,   401,     0,   135,     0,   137,     0,     0,   402,
     403,     0,   404,   405,     0,     0,   406,   407,   138,   408,
       0,   409,   410,   411,   412,   142,     0,     0,   413,   414,
     415,   416,   417,     0,   418,   419,   145,   420,     0,   421,
     422,   423,     0,   424,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   151,   152,   430,     0,   431,     0,
     432,     0,   433,   434,   435,     0,   436,     0,     0,   437,
     438,   439,   440,     0,   441,   442,   443,     0,   444,     0,
     445,   446,   447,   158,   448,     0,   160,     0,   449,   450,
     162,     0,   451,     0,   452,     0,     0,     0,   453,     0,
     454,     0,   455,   167,     0,   456,     0,   457,   458,   459,
    1140,     0,   461,   462,   463,     0,   464,   465,   466,   467,
     468,   469,     0,     0,   170,     0,   470,   471,   472,     0,
     172,     0,   173,     0,     0,     0,     0,   473,     0,   474,
     475,   476,   477,   478,     0,   177,     0,   479,     0,     0,
     480,   481,   482,     0,     0,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   184,     0,   186,     0,
     494,   495,   496,   497,   498,   499,   500,   187,   501,     0,
     502,   503,     0,   504,     0,   190,   191,   505,   506,     0,
       0,   507,     0,     0,     0,   508,   509,     0,     0,   192,
       0,     0,   195,   510,   511,   512,   513,     0,   196,   197,
     514,   515,   516,     0,   517,   518,   519,   520,   521,   522,
     199,   523,   524,     0,   525,   526,   527,   528,   529,   530,
     531,   532,   533,     0,   534,   535,     0,   536,   537,   207,
     538,   539,   540,   541,   542,   543,     0,     0,   544,   545,
     546,     0,   547,   211,   548,   549,     0,   550,   214,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   216,   559,
       0,   560,   561,     0,   562,   563,   564,   565,     0,   217,
     218,     0,     0,   567,   219,   568,   220,     0,   569,   570,
     571,   572,   573,     0,     0,   574,   575,   576,   577,     0,
       0,   578,   579,     0,   580,   228,   581,     0,   582,     0,
       0,     0,   583,   584,   585,   586,   587,   588,     0,     0,
       0,   230,     0,     0,   231,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   376,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,   135,     0,   137,     0,     0,   402,   403,
       0,   404,   405,     0,     0,   406,   407,   138,   408,     0,
     409,   410,   411,   412,   142,     0,     0,   413,   414,   415,
     416,   417,     0,   418,   419,   145,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   151,   152,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,   438,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,   158,   448,     0,   160,     0,   449,   450,   162,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,   167,     0,   456,     0,   457,   458,   459,  1144,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,   170,     0,   470,   471,   472,     0,   172,
       0,   173,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,   177,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   184,     0,   186,     0,   494,
     495,   496,   497,   498,   499,   500,   187,   501,     0,   502,
     503,     0,   504,     0,   190,   191,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,   192,     0,
       0,   195,   510,   511,   512,   513,     0,   196,   197,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,   199,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,   207,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,   211,   548,   549,     0,   550,   214,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   216,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,   217,   218,
       0,     0,   567,   219,   568,   220,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,   580,   228,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,  1151,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   376,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,   399,   400,   401,
       0,   135,     0,   137,     0,     0,   402,   403,     0,   404,
     405,     0,     0,   406,   407,   138,   408,     0,   409,   410,
     411,   412,   142,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,   145,   420,     0,   421,   422,   423,     0,
     424,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   151,   152,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,   438,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
     158,   448,     0,   160,     0,   449,   450,   162,     0,   451,
       0,   452,     0,     0,     0,   453,     0,   454,     0,   455,
     167,     0,   456,     0,   457,   458,   459,  1153,     0,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
       0,   170,     0,   470,   471,   472,     0,   172,     0,   173,
       0,     0,     0,     0,   473,     0,   474,   475,   476,   477,
     478,     0,   177,     0,   479,     0,     0,   480,   481,   482,
       0,     0,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   184,     0,   186,     0,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,     0,
     504,     0,   190,   191,   505,   506,     0,     0,   507,     0,
       0,     0,   508,   509,     0,     0,   192,     0,     0,   195,
     510,   511,   512,   513,     0,   196,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,   199,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,     0,   536,   537,   207,   538,   539,   540,
     541,   542,   543,     0,     0,   544,   545,   546,     0,   547,
     211,   548,   549,     0,   550,   214,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   216,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,   217,   218,     0,     0,
     567,   219,   568,   220,     0,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,     0,     0,   578,   579,
       0,   580,   228,   581,     0,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,     0,
       0,   231,    81,    82,    83,   373,    85,    86,     0,    87,
      88,    89,   374,     0,   375,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   376,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   117,   377,   378,     0,     0,
       0,   379,   380,     0,     0,     0,     0,   381,     0,     0,
       0,     0,     0,     0,     0,     0,   382,     0,   383,     0,
     384,   385,     0,   386,   387,   388,   389,   390,   391,   392,
     393,     0,   394,   395,     0,     0,     0,     0,     0,     0,
       0,   396,   397,     0,   398,     0,   399,   400,   401,     0,
     135,     0,   137,     0,     0,   402,   403,     0,   404,   405,
       0,     0,   406,   407,   138,   408,     0,   409,   410,   411,
     412,   142,     0,     0,   413,   414,   415,   416,   417,     0,
     418,   419,   145,   420,     0,   421,   422,   423,     0,   424,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     151,   152,   430,     0,   431,     0,   432,     0,   433,   434,
     435,     0,   436,     0,     0,   437,   438,   439,   440,     0,
     441,   442,   443,     0,   444,     0,   445,   446,   447,   158,
     448,     0,   160,     0,   449,   450,   162,     0,   451,     0,
     452,     0,     0,     0,   453,     0,   454,     0,   455,   167,
       0,   456,     0,   457,   458,   459,  1155,     0,   461,   462,
     463,     0,   464,   465,   466,   467,   468,   469,     0,     0,
     170,     0,   470,   471,   472,     0,   172,     0,   173,     0,
       0,     0,     0,   473,     0,   474,   475,   476,   477,   478,
       0,   177,     0,   479,     0,     0,   480,   481,   482,     0,
       0,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   184,     0,   186,     0,   494,   495,   496,   497,
     498,   499,   500,   187,   501,     0,   502,   503,     0,   504,
       0,   190,   191,   505,   506,     0,     0,   507,     0,     0,
       0,   508,   509,     0,     0,   192,     0,     0,   195,   510,
     511,   512,   513,     0,   196,   197,   514,   515,   516,     0,
     517,   518,   519,   520,   521,   522,   199,   523,   524,     0,
     525,   526,   527,   528,   529,   530,   531,   532,   533,     0,
     534,   535,     0,   536,   537,   207,   538,   539,   540,   541,
     542,   543,     0,     0,   544,   545,   546,     0,   547,   211,
     548,   549,     0,   550,   214,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   216,   559,     0,   560,   561,     0,
     562,   563,   564,   565,     0,   217,   218,     0,     0,   567,
     219,   568,   220,     0,   569,   570,   571,   572,   573,     0,
       0,   574,   575,   576,   577,     0,     0,   578,   579,     0,
     580,   228,   581,     0,   582,     0,     0,     0,   583,   584,
     585,   586,   587,   588,     0,     0,     0,   230,     0,     0,
     231,    81,    82,    83,   373,    85,    86,     0,    87,    88,
      89,   374,     0,   375,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   376,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   117,   377,   378,     0,     0,     0,
     379,   380,     0,     0,     0,     0,   381,     0,     0,     0,
       0,     0,     0,     0,     0,   382,     0,   383,     0,   384,
     385,     0,   386,   387,   388,   389,   390,   391,   392,   393,
       0,   394,   395,     0,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,   399,   400,   401,     0,   135,
       0,   137,     0,     0,   402,   403,     0,   404,   405,     0,
       0,   406,   407,   138,   408,     0,   409,   410,   411,   412,
     142,     0,     0,   413,   414,   415,   416,   417,     0,   418,
     419,   145,   420,     0,   421,   422,   423,     0,   424,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   151,
     152,   430,     0,   431,     0,   432,     0,   433,   434,   435,
       0,   436,     0,     0,   437,   438,   439,   440,     0,   441,
     442,   443,     0,   444,     0,   445,   446,   447,   158,   448,
       0,   160,     0,   449,   450,   162,     0,   451,     0,   452,
       0,     0,     0,   453,     0,   454,     0,   455,   167,     0,
     456,     0,   457,   458,   459,  1157,     0,   461,   462,   463,
       0,   464,   465,   466,   467,   468,   469,     0,     0,   170,
       0,   470,   471,   472,     0,   172,     0,   173,     0,     0,
       0,     0,   473,     0,   474,   475,   476,   477,   478,     0,
     177,     0,   479,     0,     0,   480,   481,   482,     0,     0,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   184,     0,   186,     0,   494,   495,   496,   497,   498,
     499,   500,   187,   501,     0,   502,   503,     0,   504,     0,
     190,   191,   505,   506,     0,     0,   507,     0,     0,     0,
     508,   509,     0,     0,   192,     0,     0,   195,   510,   511,
     512,   513,     0,   196,   197,   514,   515,   516,     0,   517,
     518,   519,   520,   521,   522,   199,   523,   524,     0,   525,
     526,   527,   528,   529,   530,   531,   532,   533,     0,   534,
     535,     0,   536,   537,   207,   538,   539,   540,   541,   542,
     543,     0,     0,   544,   545,   546,     0,   547,   211,   548,
     549,     0,   550,   214,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   216,   559,     0,   560,   561,     0,   562,
     563,   564,   565,     0,   217,   218,     0,     0,   567,   219,
     568,   220,     0,   569,   570,   571,   572,   573,     0,     0,
     574,   575,   576,   577,     0,     0,   578,   579,     0,   580,
     228,   581,     0,   582,     0,     0,     0,   583,   584,   585,
     586,   587,   588,     0,     0,     0,   230,     0,     0,   231,
      81,    82,    83,   373,    85,    86,     0,    87,    88,    89,
     374,     0,   375,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   376,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,   377,   378,     0,     0,     0,   379,
     380,     0,     0,     0,     0,   381,     0,     0,     0,     0,
       0,     0,     0,     0,   382,     0,   383,     0,   384,   385,
       0,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,   395,     0,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,   399,   400,   401,     0,   135,     0,
     137,     0,     0,   402,   403,     0,   404,   405,     0,     0,
     406,   407,   138,   408,     0,   409,   410,   411,   412,   142,
       0,     0,   413,   414,   415,   416,   417,     0,   418,   419,
     145,   420,     0,   421,   422,   423,     0,   424,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   151,   152,
     430,     0,   431,     0,   432,     0,   433,   434,   435,     0,
     436,     0,     0,   437,   438,   439,   440,     0,   441,   442,
     443,     0,   444,     0,   445,   446,   447,   158,   448,     0,
     160,     0,   449,   450,   162,     0,   451,     0,   452,     0,
       0,     0,   453,     0,   454,     0,   455,   167,     0,   456,
       0,   457,   458,   459,  1159,     0,   461,   462,   463,     0,
     464,   465,   466,   467,   468,   469,     0,     0,   170,     0,
     470,   471,   472,     0,   172,     0,   173,     0,     0,     0,
       0,   473,     0,   474,   475,   476,   477,   478,     0,   177,
       0,   479,     0,     0,   480,   481,   482,     0,     0,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     184,     0,   186,     0,   494,   495,   496,   497,   498,   499,
     500,   187,   501,     0,   502,   503,     0,   504,     0,   190,
     191,   505,   506,     0,     0,   507,     0,     0,     0,   508,
     509,     0,     0,   192,     0,     0,   195,   510,   511,   512,
     513,     0,   196,   197,   514,   515,   516,     0,   517,   518,
     519,   520,   521,   522,   199,   523,   524,     0,   525,   526,
     527,   528,   529,   530,   531,   532,   533,     0,   534,   535,
       0,   536,   537,   207,   538,   539,   540,   541,   542,   543,
       0,     0,   544,   545,   546,     0,   547,   211,   548,   549,
       0,   550,   214,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   216,   559,     0,   560,   561,     0,   562,   563,
     564,   565,     0,   217,   218,     0,     0,   567,   219,   568,
     220,     0,   569,   570,   571,   572,   573,     0,     0,   574,
     575,   576,   577,     0,     0,   578,   579,     0,   580,   228,
     581,     0,   582,     0,     0,     0,   583,   584,   585,   586,
     587,   588,     0,     0,     0,   230,     0,     0,   231,    81,
      82,    83,   373,    85,    86,     0,    87,    88,    89,   374,
       0,   375,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   376,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   117,   377,   378,     0,     0,     0,   379,   380,
       0,     0,     0,     0,   381,     0,     0,     0,     0,     0,
       0,     0,     0,   382,     0,   383,     0,   384,   385,     0,
     386,   387,   388,   389,   390,   391,   392,   393,     0,   394,
     395,     0,     0,     0,     0,     0,     0,     0,   396,   397,
       0,   398,     0,   399,   400,   401,     0,   135,     0,   137,
       0,     0,   402,   403,     0,   404,   405,     0,     0,   406,
     407,   138,   408,     0,   409,   410,   411,   412,   142,     0,
       0,   413,   414,   415,   416,   417,     0,   418,   419,   145,
     420,     0,   421,   422,   423,     0,   424,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   151,   152,   430,
       0,   431,     0,   432,     0,   433,   434,   435,     0,   436,
       0,     0,   437,   438,   439,   440,     0,   441,   442,   443,
       0,   444,     0,   445,   446,   447,   158,   448,     0,   160,
       0,   449,   450,   162,     0,   451,     0,   452,     0,     0,
       0,   453,     0,   454,     0,   455,   167,     0,   456,     0,
     457,   458,   459,  1162,     0,   461,   462,   463,     0,   464,
     465,   466,   467,   468,   469,     0,     0,   170,     0,   470,
     471,   472,     0,   172,     0,   173,     0,     0,     0,     0,
     473,     0,   474,   475,   476,   477,   478,     0,   177,     0,
     479,     0,     0,   480,   481,   482,     0,     0,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   184,
       0,   186,     0,   494,   495,   496,   497,   498,   499,   500,
     187,   501,     0,   502,   503,     0,   504,     0,   190,   191,
     505,   506,     0,     0,   507,     0,     0,     0,   508,   509,
       0,     0,   192,     0,     0,   195,   510,   511,   512,   513,
       0,   196,   197,   514,   515,   516,     0,   517,   518,   519,
     520,   521,   522,   199,   523,   524,     0,   525,   526,   527,
     528,   529,   530,   531,   532,   533,     0,   534,   535,     0,
     536,   537,   207,   538,   539,   540,   541,   542,   543,     0,
       0,   544,   545,   546,     0,   547,   211,   548,   549,     0,
     550,   214,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   216,   559,     0,   560,   561,     0,   562,   563,   564,
     565,     0,   217,   218,     0,     0,   567,   219,   568,   220,
       0,   569,   570,   571,   572,   573,     0,     0,   574,   575,
     576,   577,     0,     0,   578,   579,     0,   580,   228,   581,
       0,   582,     0,     0,     0,   583,   584,   585,   586,   587,
     588,     0,     0,     0,   230,     0,     0,   231,    81,    82,
      83,   373,    85,    86,     0,    87,    88,    89,   374,     0,
     375,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   376,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   117,   377,   378,     0,     0,     0,   379,   380,     0,
       0,     0,     0,   381,     0,     0,     0,     0,     0,     0,
       0,     0,   382,     0,   383,     0,   384,   385,     0,   386,
     387,   388,   389,   390,   391,   392,   393,     0,   394,   395,
       0,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,  1325,   399,   400,   401,     0,   135,     0,   137,     0,
       0,   402,   403,     0,   404,   405,     0,     0,   406,   883,
     138,  1326,     0,   409,   410,   411,   412,   142,     0,     0,
     413,   414,   415,   416,     0,     0,   418,   419,   145,   420,
       0,   421,   422,   423,     0,   424,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   151,   152,   430,     0,
     431,     0,   432,     0,   433,   434,   435,     0,   436,     0,
       0,   437,   438,   439,   440,     0,   441,   442,   443,     0,
     444,     0,   445,   446,   447,   158,   448,     0,   160,     0,
     449,   450,   162,     0,   451,     0,   452,     0,     0,     0,
     453,     0,   454,     0,   455,   167,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,   463,     0,   464,   465,
     466,   467,   468,   469,     0,     0,   170,     0,   470,   471,
     472,     0,   172,     0,   173,     0,     0,     0,     0,   473,
       0,   474,   475,   476,   477,   478,     0,   177,     0,   479,
       0,     0,   480,   481,   482,     0,     0,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   910,   184,     0,
     186,     0,   494,   495,   496,   497,   498,   499,   500,   187,
     501,     0,   502,   503,     0,   504,     0,   190,   191,   505,
     506,     0,     0,   507,     0,     0,     0,   508,   509,     0,
       0,   192,     0,     0,   195,   510,   511,   512,   513,     0,
     196,   197,   514,   515,   516,     0,   517,   518,   519,   520,
     521,   522,   199,   523,   524,     0,   525,   526,   527,   528,
     529,   530,   531,   532,   533,     0,   534,   535,     0,   911,
     537,   207,   538,   539,   540,   541,   542,   543,     0,     0,
     544,   545,  1317,     0,   547,   211,   548,   549,     0,   550,
     214,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     216,   559,     0,   560,   561,     0,   562,   563,   564,   565,
       0,   913,   218,     0,     0,   914,   219,   568,   220,     0,
     569,   570,   571,   572,   573,     0,     0,   574,   575,   576,
     577,     0,     0,   578,   579,     0,   887,   228,   581,     0,
     582,     0,     0,     0,   583,   584,   585,   586,   587,   588,
       0,     0,     0,   230,     0,     0,   231,    81,    82,    83,
     373,    85,    86,     0,    87,    88,    89,   374,     0,   375,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   376,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     117,   377,   378,     0,     0,     0,   379,   380,     0,     0,
       0,     0,   381,     0,     0,     0,     0,     0,     0,     0,
       0,   382,     0,   383,     0,   384,   385,     0,   386,   387,
     388,   389,   390,   391,   392,   393,     0,   394,   395,     0,
       0,     0,     0,     0,  1341,     0,   396,   397,     0,   398,
       0,   399,   400,   401,     0,   135,     0,   137,     0,     0,
     402,   403,     0,   404,   405,     0,     0,   406,   407,   138,
     408,     0,   409,   410,   411,   412,   142,     0,     0,   413,
     414,   415,   416,   417,     0,   418,   419,   145,   420,     0,
     421,   422,   423,     0,   424,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   151,   152,   430,     0,   431,
       0,   432,     0,   433,   434,   435,     0,   436,     0,     0,
     437,   438,   439,   440,     0,   441,   442,   443,     0,   444,
       0,   445,   446,   447,   158,   448,     0,   160,     0,   449,
     450,   162,     0,   451,     0,   452,     0,     0,     0,   453,
       0,   454,     0,   455,   167,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,   463,     0,   464,   465,   466,
     467,   468,   469,     0,     0,   170,     0,   470,   471,   472,
       0,   172,     0,   173,     0,     0,     0,     0,   473,     0,
     474,   475,   476,   477,   478,     0,   177,     0,   479,     0,
       0,   480,   481,   482,     0,     0,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   184,     0,   186,
       0,   494,   495,   496,   497,   498,   499,   500,   187,   501,
       0,   502,   503,     0,   504,     0,   190,   191,   505,   506,
       0,     0,   507,     0,     0,     0,   508,   509,     0,     0,
     192,     0,     0,   195,   510,   511,   512,   513,     0,   196,
     197,   514,   515,   516,     0,   517,   518,   519,   520,   521,
     522,   199,   523,   524,     0,   525,   526,   527,   528,   529,
     530,   531,   532,   533,     0,   534,   535,     0,   536,   537,
     207,   538,   539,   540,   541,   542,   543,     0,     0,   544,
     545,   546,     0,     0,   211,   548,   549,     0,   550,   214,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   216,
     559,     0,   560,   561,     0,   562,   563,   564,   565,     0,
     217,   218,     0,     0,   567,   219,   568,   220,     0,   569,
     570,   571,   572,   573,     0,     0,   574,   575,   576,   577,
       0,     0,   578,   579,     0,   580,   228,   581,     0,   582,
       0,     0,     0,   583,   584,   585,   586,   587,   588,     0,
       0,     0,   230,     0,     0,   231,  1421,    82,    83,   373,
      85,    86,     0,    87,    88,    89,   374,     0,   375,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   376,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   117,
     377,   378,     0,     0,     0,   379,   380,     0,     0,     0,
       0,   381,     0,     0,     0,     0,     0,     0,     0,     0,
     382,     0,   383,     0,   384,   385,     0,   386,   387,   388,
     389,   390,   391,   392,   393,     0,   394,   395,     0,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
     399,   400,   401,     0,   135,     0,   137,     0,     0,   402,
     403,     0,   404,   405,     0,     0,   406,   407,   138,   408,
       0,   409,   410,   411,   412,   142,     0,     0,   413,   414,
     415,   416,   417,     0,   418,   419,   145,   420,     0,   421,
     422,   423,     0,   424,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   151,   152,   430,     0,   431,     0,
     432,     0,   433,   434,   435,     0,   436,     0,     0,   437,
     438,   439,   440,     0,   441,   442,   443,     0,   444,     0,
     445,   446,   447,   158,   448,     0,   160,     0,   449,   450,
     162,     0,   451,     0,   452,     0,     0,     0,   453,     0,
     454,     0,   455,   167,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,   463,     0,   464,   465,   466,   467,
     468,   469,     0,     0,   170,     0,   470,   471,   472,     0,
     172,     0,   173,     0,     0,     0,     0,   473,     0,   474,
     475,   476,   477,   478,     0,   177,     0,   479,     0,     0,
     480,   481,   482,     0,     0,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   184,     0,   186,     0,
     494,   495,   496,   497,   498,   499,   500,   187,   501,     0,
     502,   503,     0,   504,     0,   190,   191,   505,   506,     0,
       0,   507,     0,     0,     0,   508,   509,     0,     0,   192,
       0,     0,   195,   510,   511,   512,   513,     0,   196,   197,
     514,   515,   516,     0,   517,   518,   519,   520,   521,   522,
     199,   523,   524,     0,   525,   526,   527,   528,   529,   530,
     531,   532,   533,     0,   534,   535,     0,   536,   537,   207,
     538,   539,   540,   541,   542,   543,     0,     0,   544,   545,
     546,     0,   547,   211,   548,   549,     0,   550,   214,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   216,   559,
       0,   560,   561,     0,   562,   563,   564,   565,     0,   217,
     218,     0,     0,   567,   219,   568,   220,     0,   569,   570,
     571,   572,   573,     0,     0,   574,   575,   576,   577,     0,
       0,   578,   579,     0,   580,   228,   581,     0,   582,     0,
       0,     0,   583,   584,   585,   586,   587,   588,     0,     0,
       0,   230,     0,     0,   231,    81,    82,    83,   373,    85,
      86,     0,    87,    88,    89,   374,     0,   375,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   376,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   117,   377,
     378,     0,     0,     0,   379,   380,     0,     0,     0,     0,
     381,     0,     0,     0,     0,     0,     0,     0,     0,   382,
       0,   383,     0,   384,   385,     0,   386,   387,   388,   389,
     390,   391,   392,   393,     0,   394,   395,     0,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,   399,
     400,   401,     0,   135,     0,   137,     0,     0,   402,   403,
       0,   404,   405,     0,     0,   406,   407,   138,   408,     0,
     409,   410,   411,   412,   142,     0,     0,   413,   414,   415,
    1590,   417,     0,   418,   419,   145,   420,     0,   421,   422,
     423,     0,   424,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   151,   152,   430,     0,   431,     0,   432,
       0,   433,   434,   435,     0,   436,     0,     0,   437,   438,
     439,   440,     0,   441,   442,   443,     0,   444,     0,   445,
     446,   447,   158,   448,     0,   160,     0,   449,   450,   162,
       0,   451,     0,   452,     0,     0,     0,   453,     0,   454,
       0,   455,   167,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,   463,     0,   464,   465,   466,   467,   468,
     469,     0,     0,   170,     0,   470,   471,   472,     0,   172,
       0,   173,     0,     0,     0,     0,   473,     0,   474,   475,
     476,   477,   478,     0,   177,     0,   479,     0,     0,   480,
     481,   482,     0,     0,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   184,     0,   186,     0,   494,
     495,   496,   497,   498,   499,   500,   187,   501,     0,   502,
     503,     0,   504,     0,   190,   191,   505,   506,     0,     0,
     507,     0,     0,     0,   508,   509,     0,     0,   192,     0,
       0,   195,   510,   511,   512,   513,     0,   196,   197,   514,
     515,   516,     0,   517,   518,   519,   520,   521,   522,   199,
     523,   524,     0,   525,   526,   527,   528,   529,   530,   531,
     532,   533,     0,   534,   535,     0,   536,   537,   207,   538,
     539,   540,   541,   542,   543,     0,     0,   544,   545,   546,
       0,   547,   211,   548,   549,     0,   550,   214,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   216,   559,     0,
     560,   561,     0,   562,   563,   564,   565,     0,   217,   218,
       0,     0,   567,   219,   568,   220,     0,   569,   570,   571,
     572,   573,     0,     0,   574,   575,   576,   577,     0,     0,
     578,   579,     0,   580,   228,   581,     0,   582,     0,     0,
       0,   583,   584,   585,   586,   587,   588,     0,     0,     0,
     230,     0,     0,   231,    81,    82,    83,   373,    85,    86,
       0,    87,    88,    89,   374,     0,   375,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     376,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   117,   377,   378,
       0,     0,     0,   379,   380,     0,     0,     0,     0,   381,
       0,     0,     0,     0,     0,     0,     0,     0,   382,     0,
     383,     0,   384,   385,     0,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,   395,     0,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,   399,   400,
     401,     0,   135,     0,   137,     0,     0,   402,   403,     0,
     404,   405,     0,     0,   406,   407,   138,   408,     0,   409,
     410,   411,   412,   142,     0,     0,   413,   414,   415,   416,
     417,     0,   418,   419,   145,   420,     0,   421,   422,   423,
       0,   424,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   151,   152,   430,     0,   431,     0,   432,     0,
     433,   434,   435,     0,   436,     0,     0,   437,   438,   439,
     440,     0,   441,   442,   443,     0,   444,     0,   445,   446,
     447,   158,   448,     0,   160,     0,   449,   450,   162,     0,
     451,     0,   452,     0,     0,     0,   453,     0,   454,     0,
     455,   167,     0,   456,     0,   457,   458,   459,  1617,     0,
     461,   462,   463,     0,   464,   465,   466,   467,   468,   469,
       0,     0,   170,     0,   470,   471,   472,     0,   172,     0,
     173,     0,     0,     0,     0,   473,     0,   474,   475,   476,
     477,   478,     0,   177,     0,   479,     0,     0,   480,   481,
     482,     0,     0,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   184,     0,   186,     0,   494,   495,
     496,   497,   498,   499,   500,   187,   501,     0,   502,   503,
       0,   504,     0,   190,   191,   505,   506,     0,     0,   507,
       0,     0,     0,   508,   509,     0,     0,   192,     0,     0,
     195,   510,   511,   512,   513,     0,   196,   197,   514,   515,
     516,     0,   517,   518,   519,   520,   521,   522,   199,   523,
     524,     0,   525,   526,   527,   528,   529,   530,   531,   532,
     533,     0,   534,   535,     0,   536,   537,   207,   538,   539,
     540,   541,   542,   543,     0,     0,   544,   545,   546,     0,
     547,   211,   548,   549,     0,   550,   214,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   216,   559,     0,   560,
     561,     0,   562,   563,   564,   565,     0,   217,   218,     0,
       0,   567,   219,   568,   220,     0,   569,   570,   571,   572,
     573,     0,     0,   574,   575,   576,   577,     0,     0,   578,
     579,     0,   580,   228,   581,     0,   582,     0,     0,     0,
     583,   584,   585,   586,   587,   588,     0,     0,     0,   230,
       0,     0,   231,    81,    82,    83,   373,    85,    86,     0,
      87,    88,    89,   374,     0,   375,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   376,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   117,   377,   378,     0,
       0,     0,   379,   380,     0,     0,     0,     0,   381,     0,
       0,     0,     0,     0,     0,     0,     0,   382,     0,   383,
       0,   384,   385,     0,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,   395,     0,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,   399,   400,   401,
       0,   135,     0,   137,     0,     0,   402,   403,     0,   404,
     405,     0,     0,   406,   407,   138,   408,     0,   409,   410,
     411,   412,   142,     0,     0,   413,   414,   415,   416,   417,
       0,   418,   419,   145,   420,     0,   421,   422,   423,     0,
     424,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   151,   152,   430,     0,   431,     0,   432,     0,   433,
     434,   435,     0,   436,     0,     0,   437,   438,   439,   440,
       0,   441,   442,   443,     0,   444,     0,   445,   446,   447,
     158,   448,     0,   160,     0,   449,   450,   162,     0,   451,
       0,   452,     0,     0,     0,   453,     0,   454,     0,   455,
     167,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,   463,     0,   464,   465,   466,   467,   468,   469,     0,
       0,   170,     0,   470,   471,   472,     0,   172,     0,   173,
       0,     0,     0,     0,   473,     0,   474,   475,   476,   477,
     478,     0,   177,     0,   479,     0,     0,   480,   481,   482,
       0,     0,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   184,     0,   186,     0,   494,   495,   496,
     497,   498,   499,   500,   187,   501,     0,   502,   503,     0,
     504,     0,   190,   191,   505,   506,     0,     0,   507,     0,
       0,     0,   508,   509,     0,     0,   192,     0,     0,   195,
     510,   511,   512,   513,     0,   196,   197,   514,   515,   516,
       0,   517,   518,   519,   520,   521,   522,   199,   523,   524,
       0,   525,   526,   527,   528,   529,   530,   531,   532,   533,
       0,   534,   535,     0,   536,   537,   207,   538,   539,  1687,
     541,   542,   543,     0,     0,   544,   545,   546,     0,   547,
     211,   548,   549,     0,   550,   214,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   216,   559,     0,   560,   561,
       0,   562,   563,   564,   565,     0,   217,   218,     0,     0,
     567,   219,   568,   220,     0,   569,   570,   571,   572,   573,
       0,     0,   574,   575,   576,   577,     0,     0,   578,   579,
       0,   580,   228,   581,     0,   582,     0,     0,     0,   583,
     584,   585,   586,   587,   588,     0,     0,     0,   230,     0,
       0,   231,    81,    82,    83,   373,    85,    86,     0,    87,
      88,    89,   374,     0,   375,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   376,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   117,   377,   378,     0,     0,
       0,   379,   380,     0,     0,     0,     0,   381,     0,     0,
       0,     0,     0,     0,     0,     0,   382,     0,   383,     0,
     384,   385,     0,   386,   387,   388,   389,   390,   391,   392,
     393,     0,   394,   395,     0,     0,     0,     0,     0,     0,
       0,   396,   397,     0,   398,     0,   399,   400,   401,     0,
     135,     0,   137,     0,     0,   402,   403,     0,   404,   405,
       0,     0,   406,   883,   138,   408,     0,   409,   410,   411,
     412,   142,     0,     0,   413,   414,   415,   416,     0,     0,
     418,   419,   145,   420,     0,   421,   422,   423,     0,   424,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     151,   152,   430,     0,   431,     0,   432,     0,   433,   434,
     435,     0,   436,     0,     0,   437,   438,   439,   440,     0,
     441,   442,   443,     0,   444,     0,   445,   446,   447,   158,
     448,     0,   160,     0,   449,   450,   162,     0,   451,     0,
     452,     0,     0,     0,   453,     0,   454,     0,   455,   167,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
     463,     0,   464,   465,   466,   467,   468,   469,     0,     0,
     170,     0,   470,   471,   472,     0,   172,     0,   173,     0,
       0,     0,     0,   473,     0,   474,   475,   476,   477,   478,
       0,   177,     0,   479,     0,     0,   480,   481,   482,     0,
       0,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   910,   184,     0,   186,     0,   494,   495,   496,   497,
     498,   499,   500,   187,   501,     0,   502,   503,     0,   504,
       0,   190,   191,   505,   506,     0,     0,   507,     0,     0,
       0,   508,   509,     0,     0,   192,     0,     0,   195,   510,
     511,   512,   513,     0,   196,   197,   514,   515,   516,     0,
     517,   518,   519,   520,   521,   522,   199,   523,   524,     0,
     525,   526,   527,   528,   529,   530,   531,   532,   533,     0,
     534,   535,     0,   911,   537,   207,   538,   539,   540,   541,
     542,   543,     0,     0,   544,   545,  1317,     0,   547,   211,
     548,   549,     0,   550,   214,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   216,   559,     0,   560,   561,     0,
     562,   563,   564,   565,     0,   913,   218,     0,     0,   914,
     219,   568,   220,     0,   569,   570,   571,   572,   573,     0,
       0,   574,   575,   576,   577,     0,     0,   578,   579,     0,
     887,   228,   581,     0,   582,     0,     0,     0,   583,   584,
     585,   586,   587,   588,    81,    82,    83,   230,    85,    86,
     231,    87,    88,    89,     0,     0,     0,    92,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
       0,     0,     0,   105,   106,   107,   108,     0,   109,   110,
     111,   112,   113,     0,   114,   115,   116,   117,     0,     0,
       0,     0,     0,   120,   121,     0,     0,     0,     0,   122,
       0,     0,     0,     0,     0,     0,     0,     0,   123,     0,
     124,     0,   125,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   132,     0,     0,
       0,   134,   135,   136,   137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   138,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   145,     0,     0,     0,     0,     0,
     148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   151,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   158,     0,     0,   160,     0,     0,     0,   162,     0,
       0,     0,     0,   163,     0,   164,     0,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   169,   170,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,   174,   175,     0,   176,     0,     0,     0,
       0,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   184,   185,   186,     0,     0,     0,
       0,     0,     0,     0,     0,   187,     0,     0,     0,     0,
     189,     0,     0,   190,   191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   192,   193,   194,
     195,     0,     0,     0,     0,     0,   196,   197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,   214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   216,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,   218,     0,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,   223,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   228,     0,   229,     0,    81,    82,    83,
       0,    85,    86,     0,    87,    88,    89,     0,     0,   230,
      92,    93,   231,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,     0,     0,     0,   105,   106,   107,   108,
       0,   109,   110,   111,   112,   113,     0,   114,   115,   116,
     117,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     132,     0,     0,     0,   134,   135,   136,   137,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   138,
       0,     0,     0,     0,     0,     0,   142,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,   152,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   158,     0,     0,   160,     0,     0,
       0,   162,     0,     0,     0,     0,   163,     0,   164,     0,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   169,   170,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,   174,   175,     0,   176,
       0,     0,     0,     0,     0,     0,   177,   178,     0,   179,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   184,   185,   186,
       0,     0,     0,     0,     0,     0,     0,     0,   187,     0,
       0,     0,     0,   189,     0,     0,   190,   191,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     192,   193,   194,   195,     0,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   199,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,     0,     0,
     207,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   213,     0,   214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,   218,     0,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,   223,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   228,     0,   229,     0,
      81,    82,    83,     0,    85,    86,     0,    87,    88,    89,
       0,     0,   230,     0,    93,   231,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,     0,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   117,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   132,     0,     0,     0,   134,   135,   136,
     137,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   138,     0,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,   148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   158,     0,     0,
     160,     0,     0,     0,   162,     0,     0,     0,     0,   163,
       0,   164,     0,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   169,   170,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,   174,
     175,     0,   176,     0,     0,     0,     0,     0,     0,   177,
     178,     0,   179,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     184,   185,   186,     0,     0,     0,     0,     0,     0,     0,
       0,   187,     0,     0,     0,     0,   189,     0,     0,   190,
     191,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   192,   193,   194,   195,     0,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,   214,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,   218,     0,     0,     0,   219,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,   231
};

static const short yycheck[] =
{
       2,    76,   221,    76,   157,   232,   729,  1143,   868,   949,
     733,    92,   149,   147,  1468,  1065,   149,   150,  1620,  1559,
     204,   737,  1561,    92,   157,   730,   721,   732,  1052,  1407,
       2,  1108,   970,  1267,   115,    79,  1060,    76,  1115,   744,
     763,  1070,   999,  1658,    76,   198,   115,    79,   908,    92,
     734,  1253,  1204,   914,   738,    76,  1543,   773,   797,   131,
      92,   745,  1325,   923,   769,   198,   834,    84,   836,  1794,
     838,   146,   115,    76,  1018,  2149,   844,   782,  1576,    76,
    1104,   225,   805,   115,    76,  2052,  1110,   771,   811,  2205,
    2129,   775,  1116,  1576,    92,  1576,  1096,  1453,   814,  1576,
     784,   203,  1870,  1606,  2331,  1576,   812,  1576,   210,  1690,
     212,   817,  1035,  1832,   853,  2541,   999,   115,  2139,   825,
    2405,   833,   203,   828,  2576,  2352,  2134,  2135,    92,   210,
      76,   212,  2547,    79,  1902,   921,  1136,  1841,  1906,  2925,
    1032,  1430,   223,    25,  1838,  1168,    92,   845,  1949,  1950,
     909,   115,   979,   912,   223,  1122,   994,   232,   233,   161,
     233,    24,  2247,   999,   181,  1619,  2251,   906,    49,   115,
    2077,  2078,  2079,  2080,   987,   988,   105,   112,  1215,  1216,
     223,   183,    41,    76,    93,   112,    76,   118,    79,    92,
      97,   223,  2519,   112,   112,  1225,    92,  2282,  2283,  2705,
     701,   723,  1239,   196,   130,    98,   196,   112,   157,  1749,
      79,    81,   173,   152,    97,   103,    76,   127,   162,    79,
      76,   105,  2986,   233,  2988,   223,   164,   157,   233,   171,
     233,    28,    92,   112,   202,    28,   233,  3300,    85,   372,
     162,   233,    98,    33,    91,   290,   120,   120,   180,   171,
     152,   198,    41,   198,   127,   115,   304,   203,   159,   223,
     133,    42,    76,    44,   210,   149,   212,  3338,   162,  1723,
     209,   330,   291,   233,   352,   237,    86,   223,   339,  1329,
      85,    85,   260,   227,   124,   263,    91,    91,  3320,   157,
     329,    76,   304,   352,   381,  2063,   381,   329,   249,   233,
    2512,   171,   381,     0,    76,   233,   260,   209,   329,   339,
     319,   180,   412,    98,   235,   327,  3102,    17,    81,   193,
     193,   260,   366,   211,   263,  1588,   162,   215,  2540,   115,
     369,   156,  1037,   227,   366,   215,    85,   369,   196,   290,
     352,    85,   226,   293,  1546,   354,  1290,   434,   369,  1072,
     295,   180,    76,   412,   454,  1078,   233,   319,   260,   237,
     248,   263,   440,   223,  3396,  1081,   271,   345,   398,   454,
    3156,  1328,   293,  1068,    98,   454,  1512,  3448,   279,   235,
     236,    76,  1168,   329,  1461,   233,   447,   271,   310,   398,
     400,   345,  1178,  1179,   341,   400,  1425,   332,    76,   120,
    1123,   449,  1107,   347,  3190,   332,   345,   233,   171,   454,
     352,   279,   133,   332,   332,  1954,  1121,   347,   228,   233,
     366,   366,   354,   369,    92,  2499,   282,   332,   447,   566,
     118,    92,   229,   566,  3497,   225,   229,   223,    92,   313,
     313,   319,  1147,   345,  1150,  2047,  3210,   352,   390,   410,
    1527,   291,  1502,   332,   398,  1689,  1690,  1593,    76,   157,
     344,   454,   400,   370,   454,   391,  1700,  1701,   356,   329,
     339,   381,   193,   422,   404,   366,   425,   416,  1712,  1713,
    1186,   430,   352,  3269,   233,   354,   454,   370,  1194,   233,
     450,   992,  1726,  1727,  1016,  1532,  1533,  2191,   279,  1205,
    1524,   450,  1288,  1540,   398,  1535,   366,    76,   447,   369,
    1510,   235,   359,  1337,   416,   449,   447,   447,   447,   454,
     394,   394,  3028,   381,    92,   354,   454,   454,  2495,    98,
    2497,  2498,  2817,  2818,   103,   454,   454,   400,   447,  2506,
     235,  1368,   445,   425,   425,   447,  1332,  1333,    76,   445,
     443,  1785,  2591,   443,   359,   359,  2595,   235,   383,  3169,
    1452,  1397,   398,  1390,   327,  1403,   425,  2894,  2895,  2896,
    2897,  2898,   157,   450,   454,  1513,   454,  2271,   441,  2347,
     157,  1394,   438,   439,   440,   441,   442,   443,   204,   414,
     161,   735,   313,  1949,   731,   732,   740,   741,   157,   288,
     295,  2686,   450,   196,  2689,  2690,  2691,  2692,  2693,  2694,
    2695,  2696,  2697,  2698,    28,  1638,  2341,   235,  2419,   288,
    2421,  2528,   197,  1590,   450,    39,  2129,  1916,  3414,   118,
     767,   151,   179,   422,  1346,   294,   425,    17,   312,   354,
     721,   430,   431,   383,   433,   798,   215,   159,   167,  2353,
     439,   322,   721,  2738,  2739,   440,   441,   442,   443,   757,
     804,  3447,   373,   234,   797,   798,   235,   236,   440,   441,
     442,   443,   809,   394,   414,  1434,   425,   295,   721,  1716,
    1717,   425,   431,   398,   231,   120,   725,   431,   786,   721,
     439,   167,   233,   725,   374,   439,   111,   830,   218,   701,
      85,   450,   279,   117,   725,  3315,   450,   235,  1737,   383,
    1469,  2512,   210,   282,   438,   439,   440,   441,   442,   443,
     853,   337,   157,   721,   422,   284,   295,   425,   423,   701,
     305,  3157,   430,   431,   422,  1430,  1495,   425,  3190,  2540,
     414,   758,   430,   438,   439,   440,   441,   442,   443,  3164,
    2518,   298,  1468,    56,   152,  1784,   415,   721,   447,   447,
     438,   439,   440,   441,   442,   443,   343,   447,  2789,   288,
     185,    74,   284,   906,  2575,   721,   447,   445,   447,   725,
     448,   449,   167,   161,   445,  1609,   454,   448,   449,   196,
    1614,   445,  3270,   454,   448,   449,   303,  1621,   213,   279,
     454,  1661,  1662,   279,  2344,   423,  1630,   909,   215,  1514,
     912,   209,   288,  1518,   132,   229,   434,   435,   436,   150,
     438,   439,   440,   441,   442,   443,  3304,  2330,   909,   374,
     448,   912,   834,  2918,   836,   907,   838,   422,   318,   383,
     425,  3126,   844,   845,   279,   430,   393,  2301,   347,   284,
     284,  1637,   372,   373,   423,   872,   234,   175,   197,   167,
    1646,   721,   260,   133,   327,   725,   412,   330,   413,   438,
     439,   440,   441,   442,   443,   304,  1571,   445,   313,   187,
     448,   449,   899,   447,  2958,  1608,   454,   157,   323,   352,
    1613,  1575,   924,   910,   911,  2862,  2863,  3375,   327,   157,
    1598,   330,   447,  1619,  3470,   404,   159,  2814,   454,  1615,
     438,   439,   440,   441,   442,   443,  1622,   406,  2992,   334,
     200,   160,  1628,   352,   422,   343,  1631,   425,   259,  1634,
     261,   346,   430,   422,   152,  1658,   425,   255,  2977,    76,
    3506,   430,   450,  2982,  1901,   360,  2985,   345,   447,   412,
    1888,  1657,   367,  1659,  1660,    11,   374,  1663,   447,   394,
     924,    98,   160,   909,   209,  2973,   912,  3533,   970,   222,
     987,   988,   252,   212,  3059,  3060,   284,   191,   924,   407,
     288,   191,    93,   412,  2008,  2009,   304,  1068,   422,   991,
     992,   209,   994,    49,   409,   413,   430,   999,   970,  1068,
     111,   312,  3287,  3429,  1702,  1703,  1704,  1723,  2144,   279,
    2612,  1438,  1710,  2628,   212,   260,  1714,  1715,  1901,   991,
     992,   279,   994,  1721,   162,  1068,   279,   999,   142,   447,
    2264,   134,  1730,   105,  1732,   249,  1068,   454,   138,   249,
    1267,  1827,   260,  2179,  2542,   263,  1969,   442,  1746,  1476,
    1748,  2285,   162,   450,   449,   158,   374,  1752,   376,  2542,
    1193,  2542,  2418,  2001,   924,  2542,  2004,  2005,  2787,   200,
    1068,  2542,   383,  2542,   185,  2656,   290,   149,  1095,   387,
     290,   304,   134,   197,   425,  2319,    76,   395,  2591,   227,
     431,   304,  2595,   304,  1169,   375,  1169,   377,  2332,  2333,
     345,   201,   213,   414,  1068,   363,   158,  3223,   366,   223,
     160,  1725,   450,  1188,   327,  1188,   219,   227,    84,   330,
     348,   252,  1068,   284,   238,    91,   451,   345,    94,   352,
     241,  2899,   246,   381,  1209,   166,  1842,   304,   104,   352,
    2140,   352,   280,   281,  1161,   373,  3231,     5,   319,  3234,
    3117,  3118,  1227,   267,   226,   412,   413,   328,  3243,  3244,
     327,  1900,   212,   330,  1778,   131,  1169,   219,  3207,    45,
      28,   281,  1169,   204,   140,   141,   181,  1169,   349,   293,
     408,    39,  1257,   149,   150,   352,  2682,   153,   348,   304,
     447,   157,  1267,  2137,  3421,   161,   451,     8,   416,   271,
     166,   449,    13,    14,    15,   453,   412,   413,  1068,   347,
    2706,   216,   327,   373,    25,    26,    27,   183,    29,    30,
      31,  1916,   336,   334,    35,    36,    37,   289,   304,  1913,
     304,   293,   198,  1917,  3308,   346,   202,   347,   204,  1311,
    1312,   447,   208,   400,   375,   235,   377,  3474,   408,   360,
    1934,   327,  1269,   327,    76,  1028,   367,  1963,   203,   117,
     398,   422,   229,  1280,   425,  3492,   404,   212,    90,   430,
     304,  1977,   344,   127,   339,  3360,  3361,   408,  1962,  1052,
    1964,  1356,  1357,   846,  1359,  1991,   400,  1060,   398,  1995,
     144,    20,   445,   327,   404,  1993,   449,   362,   409,   142,
      76,   412,   156,  1372,   156,   295,   869,    99,  1325,   447,
     162,  2574,   170,  3280,  1998,   422,  1496,    83,   425,   452,
    1392,   454,   446,   430,    38,  2354,  1328,   119,  1330,  1331,
     454,  2155,  1434,    84,  2158,   101,   421,   447,  2162,   424,
    1372,  1373,  1374,  2027,  2049,  2050,  2030,  1491,  2032,  1430,
     442,   450,   206,  1434,   197,   454,  1328,   449,  1330,  1331,
    2900,  1430,   422,  3088,   115,   425,   448,  1469,  2066,   293,
     430,   229,   454,  2071,  1372,   227,   127,  1394,  1417,   381,
     223,  1383,   167,  2207,   135,  1417,   450,  1430,  1469,  1569,
     454,   448,  1424,  1495,  1574,   238,  1417,   454,  1430,   422,
     151,  1403,   187,   246,  1584,  1407,   372,   430,  1372,   446,
     293,  1383,   157,   235,  1495,   197,  2955,   454,   169,   445,
     447,   447,   422,   449,   267,   425,  1372,  1373,  1374,  2168,
     430,  1403,  1430,   423,   127,  1407,  1356,  1357,   385,  1359,
     133,   223,  1669,  2148,   434,   435,   436,   198,   438,   439,
     440,   441,   442,   443,   422,   448,   238,   425,   448,   235,
    1424,   454,   430,   375,   246,   377,  1430,   218,   450,   364,
     365,  1417,   454,   295,  2977,  1612,  2963,   316,  1424,  2982,
     135,  2342,  2985,  2717,  1430,  2562,   218,   232,  1434,   422,
    1571,   242,   425,   336,   279,   347,  2648,   430,   309,   284,
    1684,  2185,  1571,   288,   111,   329,   450,   252,  2710,  2711,
     454,  1513,  1372,  1373,  1374,   423,  2214,  3057,  2456,   295,
     375,  2205,   377,  1469,   455,  2463,  2464,   422,  1571,  1477,
     425,  1606,  1480,   210,   448,   430,  1484,   425,   425,  1571,
     454,  1513,   109,   431,   295,     7,   398,   448,    10,  1495,
     406,   439,   404,   454,   336,  2512,   448,  1417,   241,  3404,
      22,    23,   454,   233,  1424,   316,   422,    88,    89,   425,
    1430,  1588,   293,  1571,   430,  2604,   424,   425,   185,   390,
     315,    43,  2406,  2540,    46,  2301,   337,   448,   117,   118,
     341,   447,   343,   454,  1669,   447,  1598,   348,  3443,   448,
     566,   423,   387,   179,  3449,   454,   213,  1571,   196,  2638,
     395,   109,   434,   435,   436,   191,   438,   439,   440,   441,
     442,   443,   373,   374,   425,  1571,    99,  3472,   422,   448,
     431,   425,   433,  2247,   385,   454,   430,  2251,   439,   390,
    3094,   412,   413,   609,   610,  2343,  2362,   423,  2472,  2473,
    3189,  1653,   445,   447,   447,   231,   237,   408,  2364,   435,
     436,   417,   438,   439,   440,   441,   442,   443,  2282,  2283,
     449,  1752,  2440,   249,   412,   413,   421,   422,   296,   424,
     425,  1756,  3297,  1752,  3187,   430,   431,   448,   433,   431,
    2719,   433,  1709,   454,   439,   438,   439,   440,   441,   442,
    1702,  1703,  1704,   381,  3207,   448,   168,  2391,  1710,  1752,
     293,  1571,  1714,  1715,   290,   448,   412,   413,  3096,  1721,
    1752,   454,   298,  3263,   293,   332,   422,   334,  1730,   425,
    1732,  2781,   448,   417,   430,   448,  2442,  2443,   454,   346,
    2424,   454,   448,   448,  1746,    93,  1748,    99,   454,   454,
     452,   447,   454,   360,  1752,  2870,  2871,  2462,   417,  2874,
     367,  2876,   237,   111,   730,   731,   732,  1900,   734,   440,
     736,   737,   738,   739,   448,  1098,   742,   743,   744,   745,
     454,  1918,   375,  2607,   377,  2609,   352,  2611,  1752,  2613,
    1829,   195,  1794,  1810,  2618,   448,  2512,  1829,   764,   412,
     413,   767,   409,   769,   448,   771,  1752,   448,  1829,   775,
     776,   777,   450,   454,   780,    85,   782,   393,   784,  2517,
     422,  2519,   109,   425,  2540,  2649,   440,  1871,   430,  1873,
    3333,   797,   798,  1356,  1357,  1916,  1359,   185,   229,  1871,
     806,  1873,  2866,   809,  2539,   447,   812,  1916,   375,   448,
     377,   817,   818,   412,   413,   454,   822,   823,   448,   825,
     451,   448,   828,   422,   454,   213,   425,   454,   448,   448,
     448,   430,   448,  1916,   454,   454,   454,  1894,   412,   413,
     846,   847,   422,  1829,  1916,   425,  1888,   853,   447,  2966,
     430,   448,  1752,   241,   110,  1196,  1197,   454,   179,  1901,
     448,  1903,  2129,  1905,   451,  2628,   454,   447,   177,   875,
     191,   877,  3415,    93,   880,    76,  1888,   109,  1916,  3521,
     438,   439,   440,   441,   442,  1871,   448,  1873,   446,  1901,
     381,  1903,   454,  1905,   150,   381,   422,   448,   229,   425,
     906,   907,   448,   454,   430,   911,  2630,   122,   454,   448,
     231,    76,  1916,   381,   422,   454,   381,   425,  2092,  2664,
      76,   447,   430,   929,   381,    90,  2650,   400,   249,  1829,
    1916,  2669,   422,    98,   448,   425,   450,   448,   103,   447,
     430,  2679,    98,   454,   448,   133,   334,   103,   448,    76,
     454,  1993,   235,  2263,   454,  2265,  2266,   447,   346,  2001,
     448,   217,  2004,  2005,   448,   448,   454,   450,   448,   290,
     454,  1871,   360,  1873,   454,   422,    93,   298,   425,   367,
    3254,   987,   988,   430,   448,   418,   419,   420,   381,  2001,
     454,  3485,  2004,  2005,   111,  2168,   448,  2365,  2366,  2056,
     447,  1007,   454,   259,  1010,   261,   447,  1013,   440,   441,
     442,   448,   200,   448,  2129,   271,  1916,   454,  2285,   454,
     422,   409,   447,   425,  2066,   944,   447,   946,   430,  2071,
     218,  1037,  2686,   447,   235,  2689,  2690,  2691,  2692,  2693,
    2694,  2695,  2696,  2697,  2698,   447,   211,   303,   422,   422,
     215,   425,   425,  2367,  2368,   211,   430,   430,   122,   215,
    2117,   447,   449,  1426,   252,   304,  2325,  2326,   185,   447,
     235,   236,   393,   447,   447,   331,  2596,  1083,  2598,   235,
     236,   327,  1088,   248,  2738,  2739,  1092,   447,   215,   989,
     990,   449,   248,  1099,   295,   352,   213,   293,   450,   247,
     447,  1107,   287,  2160,  1467,   361,   241,   412,   235,   297,
     447,  3091,   120,   412,   279,  1121,  1122,   282,  1124,  1125,
     422,    93,   412,   425,   241,   447,   282,   304,   430,   431,
     295,   433,  2996,  2997,    99,    99,   241,   439,   455,   295,
     179,  1147,   400,   183,  1150,   183,   210,   447,  1511,   183,
     183,  2889,   191,   183,   183,   447,  2894,  2895,  2896,  2897,
    2898,   454,   183,  1526,  2902,   183,   183,   293,   295,   183,
    2285,  1177,  2214,   293,   183,   247,   192,   183,   191,   447,
    1186,  1187,   447,  2298,    76,  1191,   447,   375,  1194,   377,
     309,   356,   231,   447,   447,   447,  1202,   385,    90,  1205,
     356,  1207,  2317,   447,   447,  1568,   394,   447,   423,   447,
     249,   447,   447,   447,   447,  2330,   447,   334,   447,   434,
     435,   436,   423,   438,   439,   440,   441,   442,   443,   346,
     447,   447,   301,   434,   435,   436,   447,   438,   439,   440,
     441,   442,   443,   360,   122,   447,   454,   447,  1611,    93,
     367,   290,   247,   235,   447,   191,   191,  1620,   423,   298,
     440,   229,   345,   263,  2918,   454,   156,   423,   399,   434,
     435,   436,    41,   438,   439,   440,   441,   442,   443,   435,
     436,  3005,   438,   439,   440,   441,   442,   443,   295,    17,
     454,   381,   409,   447,   447,   447,   423,   381,   449,  2341,
     381,  2343,   381,  2345,   381,  1311,  1312,   434,   435,   436,
     293,   438,   439,   440,   441,   442,   443,   284,   346,  1325,
     381,   399,  1098,   381,  1330,  1331,  3502,   381,   381,   454,
     400,   422,   381,  2345,   425,  1341,   381,  1343,  3094,   430,
     431,   343,   433,   235,   127,   293,   220,   454,   439,  3213,
    3214,  3215,   343,   385,   393,   381,   381,   381,   385,   423,
    3098,   381,   447,   293,   235,   291,    83,   447,    93,   406,
     434,   435,   436,  3111,   438,   439,   440,   441,   442,   443,
     447,  3105,   447,  3107,   447,   157,  1392,  1750,  1394,   408,
     255,  2584,   447,   191,   293,  1725,   447,    93,  2440,   449,
     344,   411,   183,   295,  2581,  3059,  3060,   400,   183,    17,
     454,  2584,   454,  1419,  2456,   381,   423,   404,  2539,  3319,
     333,  2463,  2464,   434,    76,   152,   283,   434,   435,   436,
    2539,   438,   439,   440,   441,   442,   443,   196,    90,   410,
    2512,   379,   447,    76,  2456,   379,   352,   379,   447,   447,
     454,  2463,  2464,  2568,  3200,  2568,  2539,   381,   196,   434,
     454,   383,  1468,   448,  3210,   120,   454,  2539,  2540,  2584,
    2512,  2584,   434,   231,  2531,  2517,  2591,  2519,   133,  2746,
    2595,   454,   209,   294,   288,   249,   445,   448,  2530,  2748,
    2749,  2750,  2751,    38,  3358,   448,   381,   381,  2540,  3223,
    2512,  2539,   157,   132,   159,   343,   447,   239,  1514,   239,
     447,   284,  1518,   284,   284,   293,  2573,  2574,   381,   299,
     381,  2636,   343,  2636,   306,   454,   249,   448,  2540,   454,
     306,   423,   109,   260,  3297,  2539,   263,   397,   109,   327,
     319,   235,   434,   435,   436,   423,   438,   439,   440,   441,
     442,   443,  1328,  2539,    93,   235,   434,   435,   436,   235,
     438,   439,   440,   441,   442,   443,   400,   222,   235,  1575,
     434,  1577,   445,   381,   381,   249,   434,  3231,   191,   434,
    3234,   293,  1588,   235,  1590,    93,   297,  3332,   205,  3243,
    3244,   293,   441,   208,   208,   191,    93,   447,   454,    11,
     448,  3347,   293,   293,    82,   202,  1612,   454,   262,  1615,
    1616,   293,   454,  1619,   109,   448,  1622,  1623,   345,  1625,
    1626,   448,  1628,   448,   279,  1631,    81,  2669,  1634,   284,
     196,  2746,    87,  1639,   448,   105,   448,  2679,   448,  2539,
     417,   454,   448,   295,   196,   448,   448,   448,   448,   417,
    1426,  1657,   448,  1659,  1660,   448,   448,  1663,   313,   448,
     417,    81,   447,  1669,   448,   381,  2723,    87,   323,   124,
      17,  3416,    34,   143,   249,   225,   450,  1453,  1684,   284,
     447,  1687,   448,   304,  2047,   448,   447,   447,   381,   416,
     455,  1467,   454,   163,   421,   422,   450,   424,   425,   448,
     381,  2064,   235,   430,   124,   235,  3360,  3361,   178,   445,
     263,   166,   293,   448,   448,   390,   171,  1723,   329,   174,
     293,  3484,   192,   447,   291,   454,   448,  3465,  3466,  3485,
     381,    84,   400,   293,   448,  1511,   238,   207,    91,   394,
     447,   300,   238,   447,   400,   454,   166,   434,   296,   454,
    1526,   171,   180,   180,   174,  3518,   445,   196,   177,    76,
    2802,   191,   448,   448,   448,   220,   118,  1543,   204,   448,
     196,   423,   434,   434,   447,   434,   448,   454,   131,   448,
    1786,   447,   434,   435,   436,   431,   438,   439,   440,   441,
     442,   443,  1568,   225,   381,   390,   149,   150,   381,   381,
     220,    76,   235,   448,   157,   164,   235,   446,   161,   447,
     412,    93,   191,   297,   284,    90,   271,   239,   221,   129,
     374,   291,   447,   403,   454,   423,  1832,   447,   181,   238,
     183,   447,   201,   196,   206,  1611,  1842,   109,   448,  2881,
     196,   448,   448,   447,  1620,   198,   284,  2889,   318,   304,
     284,   271,  2894,  2895,  2896,  2897,  2898,   448,   448,   448,
    2902,   235,  2977,   448,   400,   159,   284,  2982,   222,  2881,
    2985,   198,   327,   198,   446,   330,   196,   400,   400,   172,
     182,    93,   120,   448,   304,   447,   120,   196,  1894,   296,
     240,   447,   381,   191,  1900,   296,   447,   352,   447,  2956,
     196,   448,   323,    93,   284,   218,   317,  1913,  1914,   258,
     330,  1917,  1918,   454,   296,   340,  1922,  2247,   296,    96,
     191,  2251,  1928,   340,   374,   293,    93,  1933,  1934,   390,
     172,   447,   352,   293,   339,   293,   168,   162,   398,   454,
      80,   182,   317,   447,   233,    82,   322,   448,  1331,  2091,
    2345,  2026,  2282,  2283,  2467,  2056,  1962,  1963,  1964,  1965,
     235,  1967,  3121,  2940,  1970,  1971,  2013,  2943,  2846,  3150,
    2402,  1977,  2952,  3456,  1750,  3476,  3439,  3438,  3459,  3181,
    2945,  1585,  3533,  2074,  3506,  1991,  3134,  3133,  2539,  1995,
    2540,  3487,  1998,  1999,  2000,   132,  2511,  1570,  3534,  1631,
     183,  1187,   139,   140,  2187,  2957,  3005,  2013,  2014,  2015,
    2016,  2017,  2018,  2019,  3333,  3415,  2022,  2023,  2024,   372,
     295,  2027,  2028,  1949,  2030,  2031,  2032,  2390,  2418,  1950,
    3380,  3496,  3089,  3532,   922,  2964,  3309,  2081,   159,   176,
    1839,  2637,  2351,  2049,  2050,  3160,  3088,  3160,  1169,  2166,
    1364,  2999,  2359,  2369,  3096,  1363,  3098,  1854,  1365,  1833,
    2066,  2330,  2597,  3208,  2129,  3122,  3123,   804,  2938,  3111,
    3127,  2722,  2362,  2436,  2298,  2438,  3088,  2296,   215,  2216,
    1781,  2192,  3065,   220,  3096,   566,  2581,  2093,  2122,  1894,
    1600,    76,  3207,  1128,  1374,   330,   705,  1017,  1869,  1193,
      76,   990,  2108,  2466,  2174,  2340,  2112,  1901,  2114,  3000,
    1309,  2175,  3001,  2785,    90,   365,  2122,  1372,  1905,  2169,
     257,  1652,    98,  3087,  2130,   991,     2,   103,  2134,  2135,
      -1,  3188,    -1,  2496,    -1,   272,   273,    -1,   275,   276,
      -1,   278,  2148,  2149,    -1,    -1,    -1,    -1,   423,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,
     435,   436,  2168,   438,   439,   440,   441,   442,   443,   306,
    1098,    -1,    -1,  1949,  1950,    -1,    -1,    -1,    -1,  2185,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2550,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2202,    -1,  2561,  2205,
     337,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,  3258,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   369,    -1,   371,   211,    -1,    -1,    -1,   215,
      -1,  3356,  3509,  3356,    -1,  2608,  3258,    -1,    -1,  2612,
      -1,    -1,    -1,    -1,    -1,   392,    -1,    -1,  1098,   235,
     236,    -1,   399,    -1,    -1,   402,    -1,  2273,    -1,    -1,
      -1,  2047,   248,  3330,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2064,    -1,
      -1,    -1,  3407,    -1,  3407,  2301,    -1,    -1,    -1,  2662,
      -1,    -1,    -1,   279,    -1,    -1,   282,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,
      -1,   297,  2685,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2345,
      -1,    -1,    -1,    -1,    -1,  2351,    -1,    -1,    -1,  2712,
      -1,    -1,    -1,    -1,    -1,    -1,  2686,    -1,  2364,  2689,
    2690,  2691,  2692,  2693,  2694,  2695,  2696,  2697,  2698,    -1,
      -1,    -1,    -1,  2736,    -1,    -1,    -1,    -1,    -1,    -1,
     356,  3496,    -1,    -1,    -1,  2391,  2392,  2393,    -1,    -1,
      -1,    -1,    -1,    -1,  3509,    -1,    -1,    -1,    -1,  2405,
      -1,    -1,    -1,    -1,    -1,   758,    -1,    -1,  2738,  2739,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3532,  2424,  2425,
    2426,    -1,    -1,  3465,  3466,    -1,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,  2442,  2443,    -1,    -1,
      -1,    -1,    -1,   796,   797,   798,    -1,   423,    -1,    -1,
      -1,    -1,    98,    -1,    -1,    -1,  2462,   103,   434,   435,
     436,    -1,   438,   439,   440,   441,   442,   443,    -1,    -1,
     446,    -1,    -1,    -1,    -1,    -1,    -1,   830,    -1,   455,
      -1,   834,    -1,   836,    -1,   838,  2849,    -1,    -1,    -1,
      -1,   844,   845,  2499,    -1,    -1,    -1,    -1,  1426,    -1,
     853,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2519,    -1,    -1,    -1,    -1,    -1,   872,
      -1,    -1,    -1,    -1,    -1,  1453,  2532,  2533,  2534,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1467,
      -1,    -1,    -1,    -1,    -1,    -1,   899,    -1,    -1,    -1,
      -1,    -1,    -1,   906,   907,    -1,    -1,   910,   911,    -1,
      -1,    84,    -1,  2569,    -1,   211,  2929,    -1,  2574,   215,
      -1,    -1,    -1,    -1,    -1,  2581,    -1,    -1,  2584,  2585,
      -1,    -1,  2588,  1511,    -1,    -1,  1426,    -1,  2918,   235,
     236,    -1,    -1,    -1,    -1,  2601,    -1,    -1,  1526,    -1,
      -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   135,  1453,  2390,  1543,  1098,   970,    -1,    -1,
      -1,    -1,    -1,    -1,  2630,    -1,    -1,  1467,   151,    -1,
      -1,  2637,    -1,   279,   987,   988,   282,    -1,    -1,    -1,
    1568,    -1,  2418,  2419,  2650,  2421,   169,    -1,    -1,   295,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2664,    -1,
    2436,    -1,  2438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1511,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,
      -1,   204,    -1,  1611,    -1,    -1,  1526,    -1,    -1,    -1,
    2466,    -1,  1620,    -1,    -1,   218,    -1,    -1,    -1,    -1,
      -1,    -1,  3065,  1543,    -1,    -1,    -1,    -1,    -1,    -1,
     356,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
    2496,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1568,  3059,
    3060,    -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,    -1,
      -1,    -1,  1095,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2540,    -1,    -1,    -1,    -1,    -1,
      -1,  1611,   295,    -1,  2550,    -1,    -1,   423,    -1,    -1,
    1620,  2787,    -1,    76,    -1,  2561,    -1,    -1,   434,   435,
     436,    -1,   438,   439,   440,   441,   442,   443,    -1,  2575,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,  1161,    -1,
     103,  2817,  2818,    -1,   337,    -1,    -1,    -1,    -1,    -1,
     343,    -1,  1750,    -1,   141,   348,    -1,  1180,    -1,    -1,
    1183,    -1,  2608,    -1,    -1,    -1,  2612,    -1,    -1,    -1,
    1193,    -1,    -1,    -1,    -1,    -1,    -1,  2853,  2854,  3212,
     373,   374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   385,   180,    -1,    -1,    -1,   390,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,   399,  1098,    -1,  3242,
      -1,    -1,    -1,    -1,    -1,    -1,  2662,    -1,  2894,  2895,
    2896,  2897,  2898,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3231,    -1,    -1,  3234,    -1,    -1,   224,    -1,  2685,
    1750,  2917,    -1,  3243,  3244,    -1,  1269,    -1,   211,    -1,
      -1,    -1,   215,    -1,    -1,    -1,    -1,  1280,    -1,    -1,
      -1,    -1,  2938,    -1,  2940,    -1,  2712,  2943,    -1,  2945,
      -1,    -1,   235,   236,  1426,    -1,  2952,    -1,    -1,    -1,
      -1,    -1,  2958,  1306,    -1,   248,    -1,    -1,  1311,  1312,
    2736,    -1,    -1,    -1,    -1,    -1,    -1,  2973,    -1,  2975,
      -1,  1453,  1325,    -1,    -1,  1328,    -1,  1330,  1331,    -1,
    2986,    -1,  2988,    -1,    -1,  1467,  2992,    -1,    -1,   282,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3005,
      -1,    -1,   295,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1949,  1950,    -1,    -1,    -1,    -1,    -1,    -1,  1511,
    3360,  3361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1392,
      -1,  1394,    -1,    -1,  1526,    -1,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1543,    -1,   356,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,  2849,    -1,    -1,    -1,   103,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1568,    -1,  3094,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3105,
    3106,  3107,    -1,    -1,  3467,    -1,  3112,    -1,    -1,  1949,
    1950,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2047,
    3126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1611,
     423,    -1,    -1,    -1,    -1,    -1,  2064,    -1,  1620,    -1,
      -1,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,    -1,   178,  2929,    -1,    -1,    -1,    -1,  3521,    -1,
    1513,    -1,    -1,    -1,    -1,   138,    -1,    -1,  3174,    -1,
      -1,    -1,    -1,    -1,    -1,  3181,    -1,    -1,    -1,    -1,
      -1,  3187,    -1,    -1,    -1,   211,    -1,  2963,    -1,   215,
      -1,  3197,    -1,    -1,  3200,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3210,  1426,   179,  2047,    -1,   235,
     236,    -1,    -1,    -1,    -1,    -1,    -1,  3223,   191,    -1,
      -1,    -1,   248,   196,  2064,    -1,    -1,    -1,   201,    -1,
      -1,   204,  1453,   206,    -1,  1588,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1598,  1467,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   231,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1750,   295,
      -1,    76,    -1,    -1,    79,    -1,   249,    -1,    -1,    -1,
      -1,  3287,    -1,    -1,    -1,    -1,    -1,    92,    -1,  3065,
    1511,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1652,
    1653,    -1,  3308,    -1,  3310,  1526,    -1,    -1,    -1,    -1,
     115,    -1,    -1,    -1,    -1,    -1,    -1,   290,    -1,    -1,
      -1,    -1,  1543,    -1,    -1,   298,  3332,  3333,    -1,    -1,
     356,  3337,  3338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3347,    -1,    -1,   149,    -1,    -1,  1568,    -1,  1702,
    1703,  1704,    -1,    -1,    -1,    -1,  1709,  1710,    -1,    -1,
     333,  1714,  1715,    -1,    -1,    -1,    -1,    -1,  1721,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1730,    -1,  1732,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3395,
    1611,    -1,    -1,  1746,    -1,  1748,    -1,   423,   203,  1620,
     373,    -1,    -1,    -1,    -1,   210,    -1,   212,    -1,  3415,
    3416,    -1,   438,   439,   440,   441,   442,   443,   223,    -1,
     393,    -1,    -1,   740,    -1,    -1,    -1,  1780,    -1,    -1,
      -1,    -1,    -1,  1786,  3440,    -1,  3212,    -1,   411,    -1,
      -1,  1794,  3448,    -1,   761,   418,   419,   420,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1810,    -1,    -1,
      -1,    -1,  2390,    -1,  3470,    -1,  3242,  1949,  1950,    -1,
      -1,    -1,   445,    -1,    -1,   448,   449,   450,    -1,  3485,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2418,  2419,    -1,  2421,    -1,    -1,    -1,    -1,    -1,    -1,
    3506,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2436,    -1,
    2438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   329,    -1,    -1,  3533,    -1,  1750,
      -1,    -1,    -1,    -1,    -1,  1888,    -1,  1098,  2466,    -1,
      -1,  1894,    -1,    -1,    -1,   862,    -1,  1900,    -1,    -1,
    2390,   868,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   366,   879,    -1,   369,  2047,    -1,    -1,  2496,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2418,  2419,
      -1,  2421,  2064,    -1,  2512,    -1,    -1,    -1,    -1,    -1,
      -1,   908,    -1,    -1,    -1,    -1,  2436,    -1,  2438,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   923,    -1,    -1,    -1,
      -1,   928,  2540,    -1,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2550,    -1,    -1,   942,  2466,    -1,    90,    -1,
      -1,    -1,    -1,  2561,    -1,    -1,    98,    -1,    -1,    -1,
    1993,   103,    -1,    -1,    -1,    -1,    -1,  2575,  2001,    -1,
      -1,  2004,  2005,    -1,    -1,    -1,  2496,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2512,    -1,    -1,    -1,    -1,    -1,    -1,    76,
    2608,    -1,    -1,    -1,  2612,    -1,    -1,    -1,    -1,    -1,
      -1,  3467,    -1,    90,    -1,  2048,    -1,    -1,    -1,  2052,
    2540,    98,    -1,  2056,    -1,    -1,   103,    -1,    -1,    -1,
    2550,    -1,    -1,  2066,    -1,    -1,    -1,    -1,  2071,    -1,
      -1,  2561,    -1,    -1,    -1,    -1,    -1,    -1,  1949,  1950,
      -1,    -1,    -1,    -1,  2662,  2575,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3521,    -1,    -1,    -1,   211,
      -1,    -1,    -1,   215,  1071,    -1,    -1,  2685,    -1,    -1,
      -1,   566,    -1,    -1,  2117,    -1,    -1,    -1,  2608,    -1,
      -1,    -1,  2612,   235,   236,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2712,    -1,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1117,  1118,  1119,    -1,    -1,    -1,    -1,  2160,  2736,    -1,
      -1,    -1,    -1,    -1,   211,  2168,  2169,   279,   215,  2172,
     282,  2174,  2662,    -1,    -1,    -1,  2047,    -1,    -1,    -1,
      -1,    -1,    -1,   295,    -1,   297,    -1,    -1,   235,   236,
      -1,    -1,    -1,  2064,    -1,  2685,    -1,    -1,    -1,    -1,
      -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2214,    -1,    -1,    -1,  1426,    -1,    -1,  1185,    -1,
      -1,    -1,  2712,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   279,    -1,    -1,   282,    -1,  1204,    -1,    -1,
      -1,    -1,  1453,    -1,   356,    -1,  2736,    -1,   295,    -1,
     297,    -1,    -1,    -1,    -1,    -1,  1467,    -1,  2390,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   721,    -1,    -1,    -1,
     725,  2849,    -1,    -1,   729,    -1,    -1,    -1,   733,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2418,  2419,    -1,  2421,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1511,    -1,    -1,    -1,  2436,    -1,  2438,    -1,   763,   356,
      -1,   423,    -1,    -1,    -1,  1526,    -1,    -1,    -1,    -1,
      -1,    -1,   434,   435,   436,    -1,   438,   439,   440,   441,
     442,   443,  1543,    -1,  2466,    -1,   448,    -1,  2341,    -1,
    2343,    -1,  2345,    -1,    -1,    -1,    -1,   802,    -1,    -1,
     805,  2929,    -1,    -1,    -1,    -1,   811,  1568,    -1,  2849,
      -1,    -1,    -1,    -1,  2496,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1339,    -1,    -1,    -1,   423,    -1,    -1,    -1,
    2512,    -1,    -1,    76,    -1,  2963,    -1,   434,   435,   436,
      -1,   438,   439,   440,   441,   442,   443,    76,    -1,    -1,
    1611,    -1,    -1,    -1,    -1,    98,    -1,   454,  2540,  1620,
     103,    90,    -1,    -1,    -1,    -1,    -1,    -1,  2550,    98,
      -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,  2561,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2440,    -1,  2929,
      -1,    -1,    -1,  2575,    -1,    -1,    -1,    -1,    -1,   904,
      -1,    -1,    -1,  2456,   909,    -1,    -1,   912,    -1,    -1,
    2463,  2464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   924,
      -1,    -1,    -1,  2963,    -1,    -1,  2608,    -1,    -1,   934,
    2612,    -1,    -1,    -1,    -1,   178,    -1,  3065,    -1,    -1,
      -1,    -1,  2495,    -1,  2497,  2498,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2506,    -1,    -1,    -1,    -1,    -1,  2512,
      -1,    -1,    -1,    -1,  2517,  1482,  2519,    -1,   211,  2390,
      -1,    -1,   215,    -1,    -1,    -1,    -1,  2530,  2531,    -1,
    2662,    -1,   211,    -1,    -1,    -1,   215,  2540,    -1,  1750,
      -1,    -1,   235,   236,    -1,    -1,    -1,  2418,  2419,    -1,
    2421,    -1,    -1,  2685,    -1,   248,   235,   236,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2436,    -1,  2438,    -1,   248,
    2573,  2574,    -1,    -1,    -1,  3065,    -1,    -1,    -1,    -1,
    2712,  2584,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,    -1,    -1,    -1,    -1,  2466,    -1,    -1,    -1,    -1,
     279,    -1,   295,   282,  2736,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1067,  1068,    -1,    -1,   295,  1072,   297,    -1,
      -1,    -1,    -1,  1078,    -1,  2496,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3212,    -1,    -1,    -1,    -1,    -1,
      -1,  2512,    -1,  1098,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1624,    -1,    -1,
    1627,    76,    -1,   356,  3242,    -1,  2669,    -1,  1123,  2540,
      -1,    -1,    -1,    -1,    -1,    90,  2679,   356,    -1,  2550,
      -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
    2561,    -1,    -1,    -1,  1661,  1662,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2575,    -1,  1673,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2849,    -1,    -1,
    2723,    -1,  3212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     423,    -1,    -1,    -1,    -1,    -1,    -1,  2608,  1949,  1950,
      -1,  2612,    -1,    -1,   423,   438,   439,   440,   441,   442,
     443,    -1,  3242,    -1,    -1,   434,   435,   436,  1213,   438,
     439,   440,   441,   442,   443,    -1,    -1,    -1,    -1,   448,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1240,    -1,    -1,    -1,    -1,
      -1,  2662,    -1,    -1,    -1,    -1,   211,  2929,    -1,    -1,
     215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1264,
    1265,    84,  1267,  1780,  2685,    -1,    -1,    -1,    -1,    -1,
     235,   236,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1285,  2963,    -1,   248,    -1,    -1,  2047,    -1,    -1,    -1,
      -1,  2712,   115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2064,    -1,    -1,    -1,    76,    -1,  2862,
    2863,    -1,   135,    -1,   279,  2736,    -1,   282,    -1,    -1,
      -1,    90,  1839,  1328,    -1,    -1,    -1,    -1,   151,    98,
     295,    -1,   297,    -1,   103,    -1,  2889,    -1,    -1,  3467,
      -1,  2894,  2895,  2896,  2897,  2898,   169,    -1,    -1,  2902,
      -1,    -1,    -1,  1358,    -1,    -1,  1361,  1362,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1372,  1373,  1374,
      -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,
      -1,   204,    -1,  3065,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   356,    -1,  3521,    -1,   218,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2956,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1417,    -1,    -1,    -1,    -1,    -1,    -1,  1424,
      -1,  1426,    -1,    -1,    -1,  1430,    -1,  3467,  2849,  1434,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   211,    -1,    -1,    -1,   215,  3000,  1453,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,    -1,
      -1,    -1,  1467,    -1,  1469,    -1,   235,   236,    -1,   434,
     435,   436,   295,   438,   439,   440,   441,   442,   443,   248,
     303,  3521,    -1,   448,    -1,    -1,    -1,    -1,    -1,    -1,
    1495,    -1,    -1,   316,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2021,    -1,  1511,    -1,  2929,    -1,
     279,    -1,    -1,   282,   337,    -1,    -1,    -1,   341,    -1,
     343,  1526,    -1,    -1,    -1,   348,   295,    -1,   297,    -1,
    3212,    -1,    -1,    -1,    -1,  3088,  3089,    -1,  1543,    -1,
      -1,    -1,  2963,    -1,    -1,  3098,    -1,    -1,    -1,    -1,
     373,   374,    -1,    -1,    -1,    -1,    -1,    -1,  3111,    -1,
    3242,    -1,   385,  1568,  3117,  3118,  1571,   390,    -1,  3122,
    3123,    -1,  2089,    -1,  3127,    -1,   399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   408,    -1,   356,    -1,    -1,
      -1,    -1,    -1,    -1,  2111,    -1,    -1,    -1,    -1,    -1,
      -1,  1606,  2119,  1608,    -1,    -1,  1611,    -1,  1613,    -1,
      -1,    -1,    -1,    -1,    -1,  1620,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2390,
      -1,    -1,    -1,    -1,    -1,  3188,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3065,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1658,   423,    -1,    -1,  2418,  2419,    -1,
    2421,    -1,    -1,    -1,    -1,   434,   435,   436,    -1,   438,
     439,   440,   441,   442,   443,  2436,    -1,  2438,    -1,   448,
      -1,    -1,    -1,    -1,  1689,  1690,    -1,    -1,    -1,    -1,
      -1,    -1,  1697,    -1,    -1,  1700,  1701,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1709,  2466,    -1,  1712,  1713,    -1,
      -1,    -1,    -1,    -1,    -1,  1720,    -1,    76,    -1,  1724,
    1725,  1726,  1727,    -1,    -1,    -1,    -1,  3280,    -1,  1734,
    1735,    90,    -1,    -1,    -1,  2496,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,   103,  1750,  1751,  1752,    -1,    -1,
    1755,  2512,    -1,    -1,  1759,    -1,    -1,    -1,  1763,    -1,
      -1,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,
      -1,  1776,    -1,    -1,    -1,    -1,  1781,  3330,    -1,  2540,
    1785,    -1,    -1,    76,    -1,  3467,    -1,    -1,    -1,  2550,
      -1,  3212,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,
    2561,    -1,    -1,    -1,    -1,    98,    -1,  2324,    -1,    -1,
     103,    76,    -1,    -1,  2575,    -1,    -1,    92,    -1,    -1,
      -1,  3242,    -1,    -1,  1829,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,  1841,    -1,   103,  3521,
     115,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,
      -1,  2612,   211,    -1,    -1,    -1,   215,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1871,    -1,  1873,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2662,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1916,  3465,  3466,    -1,    -1,    -1,  3470,   211,    -1,
     279,    -1,   215,   282,  2685,    -1,  1931,    -1,   203,    -1,
      -1,    -1,    -1,    -1,    -1,   210,   295,   212,   297,    -1,
      -1,    -1,   235,   236,  1949,  1950,   211,    -1,   223,    -1,
     215,  2712,    -1,  3506,    -1,   248,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,    -1,    -1,    -1,  2736,    -1,    -1,    -1,    -1,
    3533,    -1,    -1,   248,    -1,    -1,   279,    -1,    -1,   282,
      -1,    -1,    -1,    76,    -1,    -1,    -1,   356,    -1,    -1,
      -1,    -1,   295,    -1,   297,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,   279,    98,    -1,   282,    -1,    -1,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2546,
     295,    -1,   297,    -1,    -1,  2552,  2041,    -1,    -1,    -1,
      -1,    -1,  2047,    -1,    -1,    -1,  3467,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2571,    -1,    -1,  2062,    -1,  2064,
      -1,    -1,    -1,   356,   423,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   434,   435,   436,    -1,   438,
     439,   440,   441,   442,   443,    -1,    -1,    -1,  2849,   448,
      -1,   356,    -1,    -1,    -1,    -1,    -1,  2614,    -1,  2616,
    3521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2129,    -1,    90,    -1,   211,    -1,
     423,  2648,   215,  2138,    98,    -1,    -1,    -1,    -1,   103,
      -1,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,    -1,   235,   236,    -1,   448,    -1,    -1,   423,    -1,
      -1,    -1,    76,    -1,    -1,   248,    -1,    -1,  2929,   434,
     435,   436,    -1,   438,   439,   440,   441,   442,   443,    -1,
      -1,    -1,    -1,   448,    98,    -1,    -1,  2192,    -1,   103,
      -1,    -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,
      -1,    -1,  2963,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2215,    -1,   295,    -1,   297,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2753,  2754,    -1,    -1,
      -1,    -1,  2247,    -1,    -1,    -1,  2251,   211,    -1,    -1,
      -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,  2263,  2264,
    2265,  2266,    -1,    -1,   178,    -1,    -1,  2272,    -1,    -1,
      -1,   235,   236,   356,    -1,    -1,    -1,  2282,  2283,    -1,
    2285,    -1,    -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2297,    -1,  2299,    -1,    -1,   211,  2303,    -1,
      -1,   215,    -1,    -1,  3065,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2319,   279,    -1,    -1,   282,    -1,
      -1,   235,   236,    -1,    -1,  2330,    -1,  2332,  2333,    -1,
      -1,   295,    -1,   297,   248,    -1,    -1,    -1,    -1,    -1,
     423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2353,    -1,
      -1,   434,   435,   436,  2359,   438,   439,   440,   441,   442,
     443,    -1,  2367,  2368,  2369,   448,    -1,    -1,   282,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   295,    -1,    -1,  2901,  2390,    -1,    -1,    -1,    -1,
      -1,    -1,   356,    -1,    -1,    -1,  2401,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2924,    -1,    -1,
      -1,    -1,    -1,  2418,  2419,    -1,  2421,  2934,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2436,    -1,  2438,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   356,    -1,    -1,    -1,   721,    -1,    -1,    -1,
      -1,  3212,    -1,    -1,   729,    -1,    -1,    -1,   733,   423,
      -1,  2466,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     434,   435,   436,    -1,   438,   439,   440,   441,   442,   443,
      -1,  3242,   446,    -1,    -1,    -1,    -1,    -1,   763,    -1,
      -1,  2496,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2511,  2512,    -1,   423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   438,   439,   440,   441,   442,   443,
     805,    -1,    -1,    -1,  2539,  2540,   811,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2550,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2561,    -1,    -1,    -1,
    3077,  3078,  3079,  3080,    -1,    -1,    -1,    -1,    -1,    -1,
    2575,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2591,    -1,    -1,    -1,
    2595,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2608,    -1,    -1,    -1,  2612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2628,    -1,    -1,    -1,    -1,    -1,   904,
      -1,    -1,    -1,    -1,   909,    -1,    -1,   912,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2653,    -1,
      -1,    -1,    76,    -1,  2659,    -1,    -1,  2662,    -1,   934,
      -1,    -1,    -1,    -1,    -1,    -1,  2671,    -1,    -1,    -1,
      -1,    -1,  2677,    -1,    98,    -1,  2681,    -1,    -1,   103,
    2685,  2686,    -1,    76,  2689,  2690,  2691,  2692,  2693,  2694,
    2695,  2696,  2697,  2698,    -1,    -1,    -1,    90,  2703,  2704,
      -1,    94,    -1,    -1,    -1,    98,  3467,  2712,    -1,    -1,
     103,    -1,  2717,    -1,    -1,    -1,    -1,    -1,    -1,  2724,
      -1,    -1,  2727,    -1,  2729,    -1,    -1,    -1,    -1,    -1,
      -1,  2736,  2737,  2738,  2739,    -1,    -1,    -1,  2743,    -1,
      -1,  2746,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      -1,    -1,    -1,    -1,   178,    -1,    -1,    -1,    -1,    -1,
    3521,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,   165,    -1,    -1,    -1,   103,    -1,    -1,    -1,
      -1,    -1,  3299,    -1,    -1,    -1,    -1,   211,    -1,    -1,
      -1,   215,  1067,  1068,    -1,    -1,    -1,  1072,    -1,    -1,
      -1,    -1,  3319,  1078,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   211,    -1,
      -1,    -1,   215,  1098,   248,  3342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,  2849,    -1,    -1,    -1,  1123,    -1,
      -1,    -1,    -1,    -1,    84,   248,    -1,  3374,   282,    -1,
      -1,    -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,   196,
      -1,   295,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   211,    -1,   279,    -1,   215,   282,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   295,    -1,   297,    -1,    -1,    -1,   235,   236,
      -1,    -1,    -1,  2918,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,    -1,    -1,  2929,    -1,    -1,    -1,    -1,    -1,
      -1,   161,   356,    -1,    -1,    -1,    -1,    -1,  1213,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   181,   279,   183,    -1,   282,    -1,    -1,  2963,    -1,
      -1,    -1,    -1,   356,    -1,  1240,    -1,    -1,   295,    -1,
     297,    -1,  2977,    -1,    -1,    -1,    -1,  2982,    -1,    -1,
    2985,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1264,
    1265,    -1,  1267,    -1,    -1,    -1,    -1,    -1,    -1,   423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,
    1285,    76,    -1,  3018,   438,   439,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    93,   356,
     423,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,    -1,    -1,    -1,  3059,  3060,    -1,    -1,    -1,  3064,
    3065,    -1,    -1,    -1,    -1,    -1,  3071,  3072,    -1,    -1,
    3075,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1358,    -1,    -1,  1361,  1362,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   423,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,   434,   435,   436,
      -1,   438,   439,   440,   441,   442,   443,    -1,    -1,    -1,
      90,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,   180,
      -1,    -1,    -1,   103,    -1,    -1,    -1,   188,    -1,    -1,
      -1,    -1,    -1,    -1,  3149,    -1,   211,    -1,    -1,    -1,
     215,  1426,    -1,    -1,    -1,  1430,    -1,    -1,    -1,  1434,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,    -1,   224,   225,    -1,    -1,    -1,  1453,    -1,
      -1,    -1,  3187,   248,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1467,    -1,  1469,    -1,    -1,    -1,  3203,    -1,
      -1,    -1,  3207,    -1,    -1,    -1,    -1,  3212,    -1,    -1,
      -1,    -1,    -1,    -1,   279,    -1,    -1,   282,    -1,    -1,
    1495,    -1,    -1,    -1,    -1,    -1,  3231,    -1,    -1,  3234,
     295,    -1,   297,    -1,    -1,    -1,  1511,  3242,  3243,  3244,
      -1,   211,  3247,    -1,    -1,   215,    -1,    -1,    -1,  3254,
    3255,  1526,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,    -1,  1543,    -1,
      -1,    -1,    -1,  3278,    -1,    -1,    -1,    -1,   248,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   356,  3297,  1568,    -1,    -1,  1571,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   279,
      -1,    -1,   282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   295,    -1,   297,  3333,  3334,
      -1,  1606,    -1,  1608,    -1,    -1,  1611,    -1,  1613,    -1,
      -1,    -1,    -1,    -1,    -1,  1620,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3360,  3361,    -1,   423,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,
     435,   436,    -1,   438,   439,   440,   441,   442,   443,    76,
      -1,    -1,    -1,  1658,    -1,    -1,   356,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,
    3415,    -1,    -1,    -1,  1689,  1690,    -1,    -1,    -1,    -1,
      -1,    -1,  1697,    -1,    -1,  1700,  1701,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1712,  1713,    -1,
      -1,    -1,    -1,    -1,    -1,  1720,    -1,    -1,    -1,  1724,
    1725,  1726,  1727,   423,    -1,    -1,    -1,    -1,    -1,  1734,
    1735,    -1,  3467,    -1,   434,   435,   436,    -1,   438,   439,
     440,   441,   442,   443,    -1,  1750,  1751,  1752,    -1,  3484,
    1755,    -1,    -1,    -1,  1759,    -1,    -1,    -1,  1763,    -1,
      -1,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,
      -1,  1776,    -1,    -1,    -1,    -1,  1781,    -1,    -1,    -1,
    1785,    -1,    -1,  3518,   211,    -1,  3521,    -1,   215,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   758,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    -1,    -1,    -1,  1841,    -1,   138,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,   279,    -1,    98,   282,    -1,    -1,    -1,   103,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,    -1,
     297,    -1,    -1,    -1,   834,    -1,   836,    -1,   838,   179,
      -1,    -1,    98,    -1,   844,   845,    -1,   103,    -1,    -1,
      -1,   191,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,   204,     2,   206,    -1,    -1,    -1,
      -1,  1916,   872,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1931,    -1,    -1,   356,
      -1,   231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   899,
      -1,    -1,    -1,    -1,  1949,  1950,    -1,    -1,   729,   249,
     910,   911,   733,    -1,   735,    -1,    -1,    -1,    -1,   740,
     741,    -1,   178,    -1,    -1,    -1,    -1,   211,    -1,    -1,
      -1,   215,    -1,   400,    -1,    -1,    -1,    -1,    -1,    -1,
     761,    -1,   763,    -1,    -1,    -1,    -1,    84,    -1,    -1,
     290,   235,   236,    -1,    -1,   211,   423,    -1,   298,   215,
      -1,    -1,    -1,    -1,   248,    -1,    -1,   434,   435,   436,
     970,   438,   439,   440,   441,   442,   443,    -1,    -1,   235,
     236,    -1,    -1,   804,   805,    -1,    -1,   987,   988,    -1,
     811,    -1,   248,   333,    -1,   279,  2041,    -1,   282,   999,
      -1,    -1,  2047,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   295,   149,   297,    -1,    -1,    -1,  2062,    -1,  2064,
      -1,    -1,    -1,   307,    -1,    -1,   282,    -1,    -1,    -1,
      -1,    -1,    -1,   373,    -1,    -1,    -1,    -1,    -1,   295,
      76,   862,    -1,    -1,   181,    -1,    -1,   868,    -1,    -1,
      -1,    -1,    -1,   393,    90,    -1,    -1,    93,   879,    -1,
      -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,    -1,
      76,   411,   356,    -1,    -1,    -1,    -1,    -1,   418,   419,
     420,    -1,    -1,    -1,  2129,    -1,    -1,   908,    -1,    -1,
      -1,    -1,    98,  2138,    -1,  1095,    -1,   103,    -1,    -1,
     356,    -1,   923,    -1,    -1,   445,    -1,   928,   448,   449,
     450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   942,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2192,    -1,    -1,
     434,   435,   436,    -1,   438,   439,   440,   441,   442,   443,
      -1,  1161,    -1,    -1,    -1,    -1,    -1,   423,    -1,    -1,
    2215,    -1,   178,    -1,    -1,   211,    76,    -1,    -1,   215,
      -1,    -1,   438,   439,   440,   441,   442,   443,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,   235,
     236,    -1,  2247,   103,    -1,   211,  2251,    -1,    -1,   215,
      -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,  2263,  2264,
    2265,  2266,    -1,    -1,    -1,    -1,    -1,  2272,    -1,   235,
     236,    -1,    -1,    -1,    -1,    -1,    -1,  2282,  2283,    -1,
    2285,    -1,   248,   279,    -1,    -1,   282,    -1,    -1,    -1,
    1071,  1072,  2297,    -1,  2299,    -1,    -1,  1078,  2303,   295,
      -1,   297,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1269,
      -1,    -1,    -1,    -1,  2319,    -1,   282,    -1,    -1,    -1,
    1280,    -1,    -1,    -1,    -1,  2330,    -1,  2332,  2333,   295,
      -1,    -1,    -1,    -1,    -1,    -1,  1117,  1118,  1119,    -1,
      -1,    -1,  1123,    -1,    -1,    -1,    -1,    -1,  2353,    -1,
      -1,   211,    -1,    -1,  2359,   215,    -1,    -1,    -1,    -1,
     356,    -1,  2367,  2368,  2369,  1325,    -1,    -1,  1328,    -1,
    1330,  1331,    -1,    -1,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2390,    -1,    -1,   248,    -1,
     356,    -1,    -1,    -1,    -1,    -1,  2401,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1185,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2418,  2419,    -1,  2421,    -1,    -1,   279,
      -1,    -1,   282,  1204,    -1,    -1,    -1,   423,    -1,    -1,
      -1,  2436,    -1,  2438,  1394,   295,    -1,   297,   434,   435,
     436,    -1,   438,   439,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,    -1,    -1,
      -1,  2466,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   438,   439,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2496,    -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,
      -1,  1098,    -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   378,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2539,  2540,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2550,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1513,    -1,    -1,  2561,    -1,  1339,    -1,
      -1,    -1,    -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,
    2575,    -1,    -1,    -1,   434,   435,   436,    -1,   438,   439,
     440,   441,   442,   443,    -1,    -1,  2591,    -1,    -1,    -1,
    2595,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2608,   701,    -1,    -1,  2612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2628,    -1,    -1,    -1,    -1,  1588,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1598,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2653,    -1,
      -1,    -1,    -1,    -1,  2659,    -1,    -1,  2662,    -1,    -1,
      -1,   758,    -1,    -1,    -1,    -1,  2671,    -1,    -1,    -1,
      -1,    -1,  2677,    -1,    -1,    -1,  2681,    -1,    -1,    -1,
    2685,  2686,    -1,    -1,  2689,  2690,  2691,  2692,  2693,  2694,
    2695,  2696,  2697,  2698,    -1,    -1,    -1,    -1,  2703,  2704,
      -1,  1482,    -1,    -1,    -1,    -1,    -1,  2712,    -1,    -1,
    1491,    -1,  2717,    -1,    -1,    -1,    -1,    -1,    -1,  2724,
      -1,    -1,  2727,    -1,  2729,    -1,    -1,    -1,    -1,    -1,
      -1,  2736,  2737,  2738,  2739,    -1,    -1,    -1,  2743,    -1,
      -1,  2746,  1702,  1703,  1704,    -1,    -1,    -1,    94,  1709,
    1710,    -1,    -1,    -1,  1714,  1715,    -1,    -1,   104,    -1,
      -1,  1721,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1730,    -1,  1732,    76,    -1,   872,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    76,    -1,    -1,  1746,    90,  1748,    -1,
      -1,    -1,    -1,    -1,   140,    98,    -1,    90,    -1,    -1,
     103,    -1,   899,    -1,   150,    98,    -1,   153,    -1,    -1,
     103,   157,    -1,   910,   911,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1606,    -1,  1608,    -1,  1426,
      -1,    -1,  1613,    -1,    -1,    -1,    -1,   183,    -1,    -1,
      -1,    -1,    -1,  1624,  2849,    -1,  1627,    -1,    -1,    -1,
    1810,    -1,   198,    -1,    -1,    -1,  1453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1467,    -1,    -1,    -1,    -1,    -1,    -1,  1658,    -1,    -1,
    1661,  1662,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     987,   988,  1673,   196,   991,   992,    -1,   994,    -1,    -1,
      -1,    -1,   999,    -1,    -1,    -1,    -1,    -1,   211,    -1,
      -1,    -1,   215,  2918,  1511,    -1,    -1,    -1,   211,    -1,
      -1,    -1,   215,    -1,  2929,    -1,    -1,    -1,  1888,  1526,
      -1,    -1,   235,   236,  1894,    -1,    -1,    -1,    -1,    -1,
      -1,  1901,   235,   236,    -1,   248,  1543,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   248,    -1,    -1,  2963,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1568,  2977,    -1,    -1,    -1,   279,  2982,    -1,   282,
    2985,    -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,
      -1,    -1,   295,    -1,   297,    -1,    -1,    -1,  1095,  1780,
      -1,    -1,   295,    -1,   297,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3018,  1611,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1620,    -1,    -1,   372,    -1,    -1,    -1,
      -1,    -1,    -1,  1993,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2001,    -1,    -1,  2004,  2005,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,  3059,  3060,    -1,    -1,  1839,  3064,
    3065,    -1,    -1,   356,  1161,    -1,  3071,  3072,    -1,    -1,
    3075,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2048,    -1,
      -1,    -1,  2052,    -1,    -1,    -1,  2056,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2066,    -1,    -1,    -1,
      -1,  2071,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     423,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,   434,   435,   436,  3149,   438,   439,   440,   441,   442,
     443,    -1,    -1,  1750,    -1,    -1,    -1,  2117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,
      -1,    -1,  1269,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,  3187,  1280,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3203,   115,
    2160,    -1,  3207,    -1,    -1,    -1,    -1,  3212,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,    -1,    -1,    -1,  3231,    -1,  1325,  3234,
      -1,  1328,    -1,  1330,  1331,   151,    -1,  3242,  3243,  3244,
    2021,   157,  3247,    -1,    -1,    -1,    -1,    -1,    -1,  3254,
    3255,    -1,    -1,   169,  2214,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   609,   610,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3278,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   198,    -1,   200,    -1,    -1,    -1,   204,    -1,
      -1,    -1,  3297,    -1,    -1,    -1,    -1,  1394,    -1,    -1,
      -1,    -1,   218,    -1,    -1,    -1,  1403,    -1,  2089,    -1,
    1407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,    -1,  3333,  3334,
    2111,    -1,    -1,    -1,    -1,    -1,   252,    -1,  2119,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2129,    -1,
      -1,    -1,  1949,  1950,    -1,  3360,  3361,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   203,    -1,    -1,    -1,
      -1,    -1,    -1,   210,    -1,   212,    -1,    -1,    -1,   295,
      -1,   297,    -1,  2343,    -1,  2345,    -1,    -1,    -1,    -1,
     736,    -1,    -1,   739,    -1,    -1,   742,   743,    -1,    -1,
     316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3415,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   764,    -1,
      -1,   337,    -1,    -1,    -1,   341,    -1,   343,    -1,    -1,
      -1,   777,    -1,    -1,   780,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2047,   797,   798,    -1,    -1,    -1,    -1,    -1,   374,   375,
     806,   377,  3467,    -1,    -1,    -1,    -1,  2064,    -1,   385,
      -1,    -1,   818,   389,   390,    -1,   822,   823,   394,  3484,
    2440,    -1,    -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1588,    -1,    -1,    -1,    -1,  2456,    -1,    -1,    -1,
     846,   847,    -1,  2463,  2464,    -1,    -1,   853,    -1,    -1,
      -1,    -1,    -1,  3518,    -1,    -1,  3521,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   875,
      -1,   877,    -1,    -1,    -1,  2495,    -1,  2497,  2498,    -1,
      -1,    -1,    -1,  2324,    -1,    -1,  2506,    -1,    -1,  2330,
      -1,    -1,  2512,    -1,    -1,    -1,    -1,  2517,    -1,  2519,
     906,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2530,  2531,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2540,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1709,  2573,  2574,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1007,    -1,    -1,  1010,    -1,    -1,  1013,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2669,
      -1,    -1,    -1,  1810,    -1,    -1,    -1,    -1,    -1,  2679,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1098,    -1,    -1,    -1,    -1,  1083,    -1,    -1,
      -1,    -1,  1088,    -1,    -1,    -1,  1092,    -1,    -1,    -1,
      -1,    -1,    -1,  1099,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2723,    -1,  2546,    -1,    -1,    -1,    -1,
      -1,  2552,    -1,    -1,    -1,    -1,    -1,    -1,  1124,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2571,    -1,    -1,  2390,    -1,    -1,    -1,  1894,    -1,    -1,
      -1,    -1,    -1,    -1,  1901,    -1,  1903,    -1,  1905,    -1,
    2591,    -1,    -1,    -1,  2595,    -1,    -1,    -1,    -1,    -1,
      -1,  2418,  2419,    -1,  2421,    -1,    -1,    -1,    -1,    -1,
      -1,  1177,    -1,  2614,    -1,  2616,    -1,    -1,    -1,  2436,
      -1,  2438,    -1,    -1,    -1,  1191,    -1,  2628,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2648,    -1,  2466,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   729,  1990,    -1,    -1,   733,    -1,    -1,  2496,
      -1,    -1,  2862,  2863,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   763,    -1,    -1,  2889,
      -1,    -1,    -1,    -1,  2894,  2895,  2896,  2897,  2898,    -1,
      -1,    -1,  2902,  2540,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2048,    -1,  2550,    -1,  2052,    -1,    -1,    -1,  2056,
      -1,    -1,    -1,    -1,  2561,    -1,    -1,    -1,   805,  2066,
      -1,    -1,  2753,  2754,   811,    -1,    -1,    -1,  2575,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2956,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2102,    -1,    -1,    -1,    -1,
      -1,  2608,    -1,    -1,    -1,  2612,    -1,    -1,    -1,    -1,
    2117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1426,    -1,    -1,  2160,    -1,  2662,    -1,   904,    -1,    -1,
      -1,    -1,   909,  1419,    -1,   912,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1453,  2685,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   934,    -1,    -1,
      -1,  1467,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2712,    -1,    -1,    -1,    -1,
    2901,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3089,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3098,  2736,
      -1,    -1,    -1,  2924,    -1,  1511,    -1,    -1,    -1,    -1,
      -1,  3111,    -1,  2934,    -1,    -1,    -1,  3117,  3118,    -1,
    1526,    -1,  3122,  3123,    -1,    -1,    -1,  3127,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1543,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2977,    -1,    -1,    -1,
      -1,  2982,  1568,    -1,  2985,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3188,    -1,
    1067,  1577,    -1,    -1,    -1,  1072,    -1,    -1,    -1,    -1,
      -1,  1078,    -1,    -1,    -1,  1611,    -1,    -1,  2345,    -1,
      -1,    -1,  2849,    -1,  1620,    -1,    -1,    -1,    -1,    -1,
      -1,  1098,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1616,    -1,    -1,    -1,    -1,    -1,    -1,  1623,    -1,  1625,
    1626,    -1,    -1,    -1,    -1,    -1,  1123,    -1,    -1,    -1,
      -1,    -1,    -1,  1639,    -1,    -1,  3077,  3078,  3079,  3080,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3280,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2929,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2441,    -1,    -1,    -1,    -1,    -1,
      -1,  2448,    -1,  2450,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2963,    -1,    -1,    -1,
    3330,    -1,    -1,    -1,    -1,    -1,  1213,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1750,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2495,    -1,
    2497,  2498,    -1,  1240,    -1,    -1,  3187,    -1,    -1,  2506,
      -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,    -1,    -1,
      -1,    -1,  2519,    -1,    -1,    -1,  3207,  1264,  1265,    -1,
    1267,    -1,    -1,  2530,  2531,    -1,    -1,    -1,    -1,    -1,
    1786,    -1,    -1,  2540,    -1,    -1,    -1,    -1,  1285,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3065,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2573,  2574,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3465,  3466,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3297,    -1,  3299,    -1,
      -1,  1358,    -1,    -1,  1361,  1362,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3319,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3333,    -1,  1900,    -1,    -1,    -1,    -1,    -1,
      -1,  3342,    -1,    -1,    -1,    -1,    -1,    -1,  1914,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1922,    -1,    -1,    -1,
      -1,    -1,  1928,  1949,  1950,    -1,    -1,  1933,    -1,  1426,
      -1,    -1,    -1,  3374,    -1,    -1,    -1,  1434,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3212,  1453,    -1,    -1,  1965,
      -1,  1967,    -1,    -1,  1970,    -1,  2723,    -1,    -1,    -1,
    1467,    -1,  1469,    -1,  3415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3242,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1999,  2000,    -1,    -1,    -1,  1495,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2015,
    2016,  2017,    -1,  2019,  1511,    -1,  2022,  2023,  2024,    -1,
      -1,  2047,  2028,    -1,    -1,  2031,    -1,    -1,    -1,  1526,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2064,    -1,
      -1,    -1,    -1,  3484,    -1,    -1,  1543,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1568,    -1,    -1,    -1,    -1,    -1,  3518,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2862,  2863,    -1,    -1,  1606,
      -1,  1608,    -1,    -1,  1611,    -1,  1613,    -1,    -1,    -1,
      -1,    -1,    -1,  1620,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2894,  2895,  2896,
    2897,  2898,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1658,  2168,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1689,  1690,    -1,    -1,  2202,    -1,    -1,  2956,
    1697,    -1,    -1,  1700,  1701,    -1,    -1,    -1,    -1,    -1,
    3467,    -1,    -1,    -1,    -1,  1712,  1713,    -1,    -1,    -1,
      -1,    -1,    -1,  1720,    -1,    -1,    -1,  1724,  1725,  1726,
    1727,    -1,    -1,    -1,    -1,    -1,    -1,  1734,  1735,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1750,  1751,    -1,    -1,    -1,  1755,    -1,
      -1,    -1,  1759,    -1,  3521,    -1,  1763,    -1,    -1,  1766,
    1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,    -1,  1776,
      -1,    -1,    -1,    -1,  1781,    -1,    -1,    -1,  1785,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3088,  3089,    -1,    -1,    -1,    -1,    -1,    -1,  3096,
      -1,    -1,    -1,    -1,  1841,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3117,  3118,    -1,    -1,  2390,  3122,  3123,  3124,    -1,    -1,
    3127,  3128,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2392,  2393,    -1,    -1,
      -1,    -1,  2418,  2419,    -1,  2421,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2436,    -1,  2438,    -1,    -1,    -1,    -1,    -1,    -1,  2425,
    2426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3188,    -1,    -1,  1931,    -1,    -1,    -1,    -1,    -1,
    2466,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1949,  1950,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2496,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2540,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3280,  2550,    -1,  2532,  2533,  2534,    -1,
      -1,    -1,    -1,    -1,    -1,  2561,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2041,    -1,    -1,    -1,    -1,  2575,
    2047,    -1,    -1,    -1,    -1,    -1,    -1,  1098,    -1,    -1,
      -1,    -1,    -1,  2569,    -1,  2062,    -1,  2064,    -1,    -1,
      -1,    -1,    -1,  3330,    -1,    -1,    -1,    -1,  2584,    -1,
      -1,    -1,  2608,    -1,    -1,    -1,  2612,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   729,    -1,    -1,    -1,   733,    -1,    -1,
      -1,    -1,  2129,    -1,    -1,    -1,  2662,    -1,    -1,    -1,
      -1,  2138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   763,    -1,  2685,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2712,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2192,    -1,    -1,    -1,   805,
      -1,    -1,    -1,    -1,    -1,   811,    -1,    -1,    -1,    -1,
    2736,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2215,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2247,    -1,    -1,    -1,  2251,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2263,  2264,  2265,  2266,
      -1,    -1,    -1,    -1,    -1,  2272,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2282,  2283,    -1,  2285,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,    -1,
    2297,    -1,  2299,    -1,    -1,    -1,  2303,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2319,  2849,    -1,    -1,    -1,    -1,   934,    -1,
      -1,    -1,    -1,  2330,    -1,  2332,  2333,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2853,  2854,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2353,    -1,    -1,    -1,
      -1,    -1,  2359,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2367,  2368,  2369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1426,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2390,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2929,  2401,    -1,    -1,    -1,    -1,    -1,
      -1,  2917,  1453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2418,  2419,    -1,  2421,    -1,  1467,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2963,    -1,  2436,
      -1,  2438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1067,    -1,    -1,    -1,    -1,  1072,    -1,    -1,  2466,
    1511,    -1,  1078,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1526,    -1,    -1,    -1,    -1,
      -1,    -1,  1098,    -1,    -1,    -1,    -1,    -1,    -1,  2496,
      -1,    -1,  1543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2512,    -1,  1123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1568,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3065,
      -1,    -1,    -1,  2540,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2550,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2561,    -1,    -1,    -1,    -1,    -1,
    1611,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2575,  1620,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2591,    -1,    -1,    -1,  2595,    -1,
    3106,    -1,    -1,    -1,    -1,    -1,    -1,  1213,    -1,    -1,
      -1,  2608,    -1,    -1,    -1,  2612,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2628,    -1,    -1,  1240,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2653,    -1,  1264,  1265,
      -1,  1267,  2659,    -1,    -1,  2662,    -1,    -1,  3174,    -1,
      -1,    -1,    -1,    -1,  2671,  3181,    -1,    -1,    -1,  1285,
    2677,    -1,    -1,    -1,  2681,    -1,  3212,    -1,  2685,  2686,
      -1,    -1,  2689,  2690,  2691,  2692,  2693,  2694,  2695,  2696,
    2697,  2698,    -1,    -1,    -1,    -1,  2703,  2704,    -1,  1750,
      -1,    -1,    -1,    -1,    -1,  2712,  3242,    -1,    -1,    -1,
    2717,    -1,    -1,    -1,    -1,    -1,    -1,  2724,    -1,    -1,
    2727,    -1,  2729,    -1,    -1,    -1,    -1,    -1,    -1,  2736,
    2737,  2738,  2739,    -1,    -1,    -1,  2743,    -1,    -1,  2746,
      -1,    -1,  1358,    -1,    -1,  1361,  1362,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1453,    -1,    -1,
      -1,    -1,  2849,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1467,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3395,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1511,    -1,    -1,  1949,  1950,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1526,  2918,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2929,    -1,  3440,    -1,    -1,  1543,    -1,    -1,
      -1,  3467,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,
      -1,    -1,  1568,    -1,    -1,    -1,  2963,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2977,    -1,    -1,    -1,    -1,  2982,    -1,    -1,  2985,   934,
      -1,    -1,    -1,    -1,    -1,  3521,    -1,    -1,    -1,    -1,
    1606,    -1,  1608,    -1,    -1,  1611,  2047,  1613,    -1,    -1,
      -1,    -1,    -1,    -1,  1620,    -1,    -1,    -1,    -1,    -1,
      -1,  3018,    -1,  2064,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1658,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3059,  3060,    -1,    -1,    -1,  3064,  3065,    -1,
      -1,    -1,    -1,    -1,  3071,  3072,    -1,    -1,  3075,    -1,
      -1,    -1,    -1,  1689,  1690,    -1,    -1,    -1,    -1,    -1,
      -1,  1697,    -1,    -1,  1700,  1701,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1712,  1713,    -1,    -1,
      -1,    -1,    -1,    -1,  1720,    -1,    -1,    -1,  1724,  1725,
    1726,  1727,  1067,    -1,    -1,    -1,    -1,    -1,  1734,  1735,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1750,  1751,    -1,    -1,    -1,  1755,
      -1,    -1,  3149,  1759,    -1,    -1,    -1,  1763,    -1,    -1,
    1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,    -1,
    1776,    -1,    -1,    -1,    -1,  1781,    -1,    -1,    -1,  1785,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3203,    -1,    -1,    -1,
    3207,    -1,    -1,    -1,    -1,  3212,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3231,  1841,    -1,  3234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3242,  3243,  3244,    -1,    -1,
    3247,    -1,    -1,    -1,    -1,    -1,    -1,  3254,  3255,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1213,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1240,    -1,    -1,    -1,    -1,
    3297,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1264,
    1265,    -1,  1267,    -1,    -1,  1931,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3333,  3334,    -1,    -1,
    1285,    -1,    -1,  1949,  1950,    -1,    -1,    -1,    -1,  2390,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3360,  3361,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2418,  2419,    -1,
    2421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2436,    -1,  2438,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1358,    -1,    -1,  1361,  1362,  3415,    -1,
      -1,    -1,    -1,    -1,    -1,  2466,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2041,    -1,    -1,    -1,    -1,
      -1,  2047,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2496,  2062,    -1,  2064,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3467,  2512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3484,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2540,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2550,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2561,  3518,    -1,  2129,  3521,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2138,    -1,  2575,    -1,  1281,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,
      -1,  2612,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2192,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1348,    -1,    -1,    -1,    -1,    -1,  2215,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2662,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2247,    -1,    -1,  2685,  2251,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2263,  2264,  2265,
    2266,    -1,    -1,    -1,    -1,    -1,  2272,    -1,    -1,    -1,
      -1,  2712,    -1,    -1,    -1,    -1,  2282,  2283,    -1,  2285,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2297,    -1,  2299,    -1,  2736,    -1,  2303,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2319,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2330,    -1,  2332,  2333,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2353,    -1,    -1,
      -1,    -1,  1697,  2359,    -1,    -1,  1701,    -1,    -1,  1504,
      -1,  2367,  2368,  2369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1720,    -1,    -1,    -1,  1724,
      -1,    -1,  1727,    -1,  2390,    -1,    -1,    -1,    -1,  1734,
    1735,    -1,    -1,    -1,    -1,  2401,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1751,    -1,  2849,    -1,
    1755,    -1,  2418,  2419,  1759,  2421,    -1,    -1,  1763,    -1,
      -1,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,
    2436,  1776,  2438,    -1,    -1,    -1,  1781,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2466,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2929,    -1,
    2496,    -1,    -1,    -1,    -1,    -1,  1841,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2963,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2540,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2550,    -1,    -1,    -1,    -1,    -1,
    1695,    -1,    -1,    -1,    -1,  2561,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2575,
      -1,    -1,    -1,    -1,  1719,    -1,    -1,    -1,    -1,    -1,
    1725,    -1,    -1,    -1,    -1,  2591,  1931,    -1,    -1,  2595,
      -1,    -1,    -1,  1738,  1739,    -1,    -1,  1742,    -1,    -1,
      -1,    -1,  2608,    -1,    -1,    -1,  2612,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2628,    -1,  3065,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1779,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2653,    -1,    -1,
      -1,    -1,    -1,  2659,    -1,    -1,  2662,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2671,    -1,    -1,    -1,    -1,
      -1,  2677,    -1,    -1,    -1,  2681,    -1,    -1,    -1,  2685,
    2686,    -1,    -1,  2689,  2690,  2691,  2692,  2693,  2694,  2695,
    2696,  2697,  2698,    -1,    -1,    -1,  2041,  2703,  2704,    -1,
      -1,    -1,    -1,    -1,    -1,  1850,  2712,    -1,    -1,    -1,
      -1,  2717,  1857,    -1,  1859,    -1,    -1,  2062,  2724,    -1,
      -1,  2727,    -1,  2729,    -1,    -1,    -1,    -1,    -1,    -1,
    2736,  2737,  2738,  2739,    -1,    -1,    -1,  2743,    -1,    -1,
    2746,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3242,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2849,    -1,    -1,    -1,  2192,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2918,    -1,    -1,    -1,    -1,    -1,  2263,    -1,
    2265,  2266,    -1,  2929,    -1,    -1,    -1,  2272,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2297,    -1,  2299,    -1,    -1,  2963,  2303,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2977,    -1,    -1,    -1,    -1,  2982,    -1,    -1,  2985,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2353,    -1,
      -1,    -1,  3018,    -1,  2359,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2367,  2368,  2369,    -1,  3467,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3059,  3060,    -1,  2401,    -1,  3064,  3065,
      -1,    -1,    -1,    -1,  2209,  3071,  3072,    -1,    -1,  3075,
      -1,    -1,    -1,  2218,    -1,  2220,    -1,    -1,    -1,    -1,
    3521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2242,    -1,    -1,
    2245,    -1,  2247,  2248,    -1,    -1,  2251,    -1,    -1,    -1,
    2255,    -1,    -1,    -1,    -1,    -1,    -1,  2262,    -1,    -1,
      -1,    -1,  2267,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2278,    -1,    -1,    -1,  2282,  2283,  2284,
      -1,    -1,    -1,  3149,    -1,    -1,    -1,    -1,    -1,    -1,
    2295,    -1,    -1,    -1,    -1,    -1,    -1,  2302,    -1,  2304,
    2305,  2306,  2307,  2308,  2309,  2310,  2311,  2312,  2313,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3203,    -1,    -1,
      -1,  3207,    -1,    -1,    -1,    -1,  3212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3231,    -1,    -1,  3234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3242,  3243,  3244,    -1,
      -1,  3247,    -1,    -1,    -1,    -1,    -1,    -1,  3254,  3255,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2408,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3297,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2653,    -1,
      -1,    -1,    -1,    -1,  2659,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2671,  3333,  3334,    -1,
      -1,    -1,  2677,    -1,    -1,    -1,  2681,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2494,
      -1,    -1,    -1,    -1,  3360,  3361,    -1,    -1,  2703,  2704,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2513,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,  2724,
      -1,    -1,  2727,    -1,  2729,    -1,    19,    -1,    -1,    -1,
      -1,    -1,  2737,    -1,    -1,    28,    -1,    -1,  2743,    -1,
      -1,  2746,    -1,    -1,    -1,    -1,    39,    40,    -1,  3415,
      -1,    -1,    45,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2605,  3467,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3484,    -1,
      -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3518,  2658,    -1,  3521,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2684,
      -1,  2686,    -1,    -1,  2689,  2690,  2691,  2692,  2693,  2694,
    2695,  2696,  2697,  2698,    -1,  2700,    -1,   190,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2720,   209,    -1,    -1,    -1,
    2725,  2726,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2738,  2739,  2740,   229,  2742,    -1,    -1,
    2745,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2815,    -1,    -1,  3018,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   345,    -1,    -1,    -1,    -1,    -1,    -1,  3064,
      -1,    -1,    -1,    -1,    -1,    -1,  3071,  3072,    -1,    -1,
    3075,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   405,  2918,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,   421,   422,
      -1,   424,    -1,   426,    -1,    -1,    -1,   430,   431,    -1,
     433,   434,    -1,    -1,  3149,   438,   439,   440,   441,   442,
      -1,    -1,   445,   446,   447,   448,    -1,   450,   451,   452,
      -1,   454,   455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3203,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3015,    -1,    -1,    -1,  3019,    -1,    -1,    -1,    -1,  3024,
    3025,    -1,  3027,    -1,    -1,  3030,    -1,    -1,    -1,  3034,
    3035,  3036,  3037,  3038,  3039,  3040,  3041,  3042,  3043,  3044,
    3045,    -1,  3247,     5,    -1,    -1,    -1,    -1,    -1,    -1,
    3255,    -1,    -1,  3058,  3059,  3060,  3061,    19,  3063,    -1,
      -1,    -1,    -1,  3068,  3069,  3070,    28,    -1,  3073,    -1,
      -1,  3076,    -1,  3278,    -1,    -1,    -1,    39,    40,    -1,
      -1,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,  3334,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3151,    28,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    39,    40,
      -1,    -1,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3224,
      -1,    -1,    -1,    -1,    -1,    -1,  3231,    -1,   190,  3234,
      -1,    -1,  3237,  3238,  3239,    -1,   117,    -1,  3243,  3244,
    3245,  3246,    -1,  3248,    -1,    -1,    -1,   209,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   229,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3301,    -1,   260,    -1,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   190,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   284,    -1,    -1,    -1,    -1,    -1,   209,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3346,    -1,    -1,    -1,    -1,    -1,    -1,   229,    -1,
      -1,    -1,    -1,    -1,  3359,  3360,  3361,  3362,    -1,    -1,
    3365,  3366,  3367,    -1,  3369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3377,    -1,    -1,    -1,    -1,    -1,    -1,   260,
      -1,    -1,   263,   345,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   284,    -1,    -1,    -1,    -1,  3413,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,
      -1,  3426,  3427,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   405,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,   421,
     422,    -1,   424,    -1,   345,    -1,    -1,    -1,   430,   431,
      -1,   433,   434,    -1,    -1,    -1,   438,   439,   440,   441,
     442,    -1,    -1,   445,   446,   447,    -1,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,
     381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   405,    -1,    -1,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,
     421,   422,    19,   424,    -1,    -1,    -1,    -1,    -1,   430,
     431,    28,   433,   434,    -1,    -1,    -1,   438,   439,   440,
     441,   442,    39,    40,   445,   446,   447,   448,    -1,    -1,
      47,    48,    -1,    -1,   455,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
       5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    19,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    39,    40,    -1,    -1,    -1,    -1,
     117,    -1,    47,    48,    -1,    -1,    -1,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   117,   190,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   209,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   260,    -1,   190,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   209,    -1,    -1,   284,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   284,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   405,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,
     345,    -1,    -1,    -1,   421,   422,    -1,   424,    -1,    -1,
      -1,    -1,    -1,   430,   431,    -1,   433,   434,    -1,    -1,
      -1,   438,   439,   440,   441,   442,    -1,    -1,   445,   446,
     447,   448,    -1,    -1,    -1,    -1,   381,    -1,   455,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     405,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   416,    -1,    -1,    -1,    -1,   421,   422,    -1,   424,
      -1,    -1,    -1,    -1,    -1,   430,   431,    -1,   433,   434,
      -1,    -1,    -1,   438,   439,   440,   441,   442,    -1,    -1,
     445,   446,   447,     5,     6,     7,     8,     9,    10,    11,
     455,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,   110,    -1,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,    -1,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,    -1,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,   399,   400,   401,
     402,    -1,    -1,   405,   406,   407,   408,    -1,   410,   411,
     412,   413,   414,   415,   416,   417,     6,     7,     8,   421,
      10,    11,   424,    13,    14,    15,    -1,    -1,    -1,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    -1,    -1,    -1,    35,    36,    37,    38,   451,
      40,    41,    42,    43,    44,    -1,    46,    47,    48,    49,
      -1,    -1,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   154,   155,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   183,    -1,    -1,   186,    -1,    -1,    -1,
     190,    -1,    -1,    -1,    -1,   195,    -1,   197,    -1,    -1,
      -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   223,   224,    -1,    -1,    -1,    -1,    -1,
     230,    -1,   232,    -1,    -1,   235,   236,    -1,   238,    -1,
      -1,    -1,    -1,    -1,    -1,   245,   246,    -1,   248,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   266,   267,   268,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,    -1,   285,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,
     300,   301,   302,    -1,    -1,    -1,    -1,    -1,   308,   309,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   336,    -1,    -1,   339,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   353,    -1,    -1,   356,    -1,   358,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,    -1,    -1,    -1,   384,    -1,   386,    -1,    -1,    -1,
      -1,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   405,    -1,   407,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   421,    -1,    -1,   424,     6,     7,     8,    -1,    10,
      11,    -1,    13,    14,    15,    -1,    -1,    -1,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    -1,   452,    -1,    35,    36,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    -1,
      -1,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,    -1,    -1,    -1,    -1,
      -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   154,   155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   183,    -1,    -1,   186,    -1,    -1,    -1,   190,
      -1,    -1,    -1,    -1,   195,    -1,   197,    -1,    -1,    -1,
      -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   223,   224,    -1,    -1,    -1,    -1,    -1,   230,
      -1,   232,    -1,    -1,   235,   236,    -1,   238,    -1,    -1,
      -1,    -1,    -1,    -1,   245,   246,    -1,   248,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   266,   267,   268,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,    -1,   285,   286,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,
     301,   302,    -1,    -1,    -1,    -1,    -1,   308,   309,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   336,    -1,    -1,   339,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   353,    -1,    -1,   356,    -1,   358,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
      -1,    -1,    -1,   384,    -1,   386,    -1,    -1,    -1,    -1,
      -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   405,    -1,   407,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     421,     3,    -1,   424,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,   452,    -1,    35,    36,    37,    38,    -1,    40,    41,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    87,    88,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
     102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,   121,
      -1,   123,   124,   125,    -1,    -1,   128,   129,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,   138,    -1,    -1,    -1,
     142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,
      -1,   153,   154,   155,   156,    -1,    -1,    -1,    -1,    -1,
     162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   171,
      -1,    -1,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,
     182,   183,   184,    -1,   186,    -1,   188,    -1,   190,    -1,
      -1,    -1,    -1,   195,    -1,   197,    -1,   199,    -1,   201,
      -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   223,   224,    -1,    -1,   227,    -1,    -1,   230,    -1,
     232,    -1,    -1,   235,   236,    -1,   238,    -1,    -1,    -1,
      -1,    -1,    -1,   245,   246,    -1,   248,    -1,   250,   251,
      -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   264,    -1,   266,   267,   268,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,    -1,   281,
     282,    -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,
     302,    -1,    -1,    -1,    -1,    -1,   308,   309,    -1,   311,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,   321,
      -1,    -1,   324,    -1,   326,    -1,     3,    -1,   330,    -1,
      -1,    -1,     9,   335,   336,    -1,   338,   339,    -1,    16,
     342,    18,    -1,    -1,    21,   347,    -1,    -1,    -1,    -1,
     352,   353,    -1,   355,   356,    32,   358,    -1,    -1,   361,
      -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,
      -1,    -1,    -1,    50,    51,    -1,    -1,   379,   380,    -1,
      -1,    -1,   384,    -1,   386,    -1,   388,    -1,   390,    -1,
      -1,   393,    -1,    -1,   396,    -1,   398,    -1,    -1,   401,
      77,    -1,   404,   405,    -1,   407,    -1,    -1,    -1,    -1,
      87,    88,    89,    -1,    -1,    -1,    -1,    -1,    -1,   421,
      -1,    -1,   424,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   121,   447,   123,   124,    -1,    -1,
      -1,   128,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     137,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,    -1,    -1,    -1,   162,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   171,    -1,    -1,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   281,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   311,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   321,    -1,    -1,   324,    -1,   326,
      -1,    -1,    -1,   330,    -1,    -1,    -1,    -1,   335,    -1,
      -1,   338,    -1,    -1,    -1,   342,    -1,    -1,    -1,    -1,
     347,    -1,    -1,    -1,    -1,   352,    -1,    -1,   355,    -1,
      -1,    -1,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   388,    -1,   390,    -1,    -1,    -1,    -1,    -1,   396,
      -1,   398,    -1,    -1,   401,    -1,    -1,   404,    -1,    -1,
       5,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
     447,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,   187,   188,   189,   190,    -1,   192,    -1,   194,
     195,    -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,   211,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,   223,   224,
      -1,   226,   227,   228,   229,   230,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,    -1,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,    -1,   394,
     395,   396,   397,   398,   399,    -1,   401,   402,    -1,   404,
     405,   406,   407,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,   433,    -1,
      -1,    -1,    -1,   438,   439,   440,    -1,    -1,    -1,    -1,
      -1,    -1,   447,   448,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,   187,   188,   189,   190,
      -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
     211,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,   223,   224,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,    -1,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,    -1,   394,   395,   396,   397,   398,   399,    -1,
     401,   402,    -1,   404,   405,   406,   407,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,   433,    -1,    -1,    -1,    -1,   438,   439,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   447,   448,     5,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,    -1,
     137,    -1,   139,   140,   141,   142,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,
      -1,   188,   189,   190,    -1,   192,    -1,   194,   195,    -1,
     197,   198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,    -1,   223,   224,    -1,   226,
     227,   228,   229,   230,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,    -1,    -1,   246,
     247,   248,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
      -1,   278,    -1,   280,   281,   282,   283,    -1,    -1,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,   300,   301,    -1,   303,   304,   305,   306,
      -1,    -1,    -1,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,    -1,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,   356,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,    -1,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,
     407,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,    -1,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,   448,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    41,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,   400,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     5,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,   445,    18,
      -1,    20,   449,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,   187,   188,
     189,   190,    -1,   192,    -1,   194,   195,   196,   197,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,   211,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,   223,   224,    -1,   226,   227,   228,
     229,   230,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,    -1,   394,   395,   396,   397,   398,
     399,    -1,   401,   402,    -1,   404,   405,   406,   407,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,   428,
     429,   430,   431,   432,   433,    -1,    -1,    -1,    -1,   438,
     439,     5,     6,     7,     8,     9,    10,    11,   447,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    -1,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,    -1,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,   132,    -1,
     134,   135,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,   183,
     184,    -1,   186,   187,   188,   189,   190,    -1,   192,    -1,
     194,   195,    -1,   197,   198,    -1,   200,    -1,   202,   203,
      -1,   205,    -1,   207,   208,   209,   210,   211,   212,   213,
     214,    -1,   216,   217,   218,   219,   220,   221,    -1,   223,
     224,    -1,   226,   227,   228,   229,   230,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
      -1,   245,   246,   247,   248,    -1,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,    -1,   291,   292,    -1,
      -1,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,   308,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,    -1,    -1,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
     374,   375,   376,   377,    -1,   379,   380,    -1,    -1,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,    -1,
     394,   395,   396,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,   407,   408,    -1,    -1,    -1,   412,   413,
     414,   415,   416,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,   433,
      -1,    -1,    -1,    -1,   438,   439,   440,    -1,    -1,    -1,
      -1,    -1,    -1,   447,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,   187,   188,   189,   190,
      -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
     211,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,   223,   224,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,    -1,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,    -1,   394,   395,   396,   397,   398,   399,    -1,
     401,   402,    -1,   404,   405,   406,   407,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,   433,    -1,    -1,    -1,    -1,   438,   439,     5,
       6,     7,     8,     9,    10,    11,   447,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,    -1,   109,   110,    -1,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,   187,   188,   189,   190,    -1,   192,    -1,   194,   195,
      -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,   211,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,   223,   224,    -1,
     226,   227,   228,   229,   230,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,    -1,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,    -1,   394,   395,
     396,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,   407,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,   433,    -1,    -1,
      -1,    -1,   438,   439,     5,     6,     7,     8,     9,    10,
      11,   447,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,   187,   188,   189,   190,
      -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
     211,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,   223,   224,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,    -1,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,    -1,   394,   395,   396,   397,   398,   399,    -1,
     401,   402,    -1,   404,   405,   406,   407,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,   433,    -1,    -1,    -1,    -1,   438,   439,     5,
       6,     7,     8,     9,    10,    11,   447,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,    -1,   109,   110,    -1,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,   187,   188,   189,   190,    -1,   192,    -1,   194,   195,
      -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,   211,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,   223,   224,    -1,
     226,   227,   228,   229,   230,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,    -1,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,    -1,   394,   395,
     396,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,   407,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,   433,    -1,    -1,
      -1,    -1,   438,   439,    -1,    -1,    -1,    -1,    -1,   445,
      -1,   447,     5,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,   194,   195,   196,   197,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,   211,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
     223,   224,    -1,   226,   227,   228,   229,   230,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,    -1,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
      -1,   394,   395,   396,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
     433,    -1,    -1,    -1,    -1,   438,   439,     5,     6,     7,
       8,     9,    10,    11,   447,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,    -1,   394,   395,   396,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,   433,    -1,    -1,    -1,    -1,
     438,   439,     5,     6,     7,     8,     9,    10,    11,   447,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,   194,   195,    -1,   197,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,   211,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
     223,   224,    -1,   226,   227,   228,   229,   230,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,    -1,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
     433,    -1,    -1,    -1,    -1,    -1,   439,     5,     6,     7,
       8,     9,    10,    11,   447,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,    -1,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
      -1,    -1,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,   245,   246,   247,
      -1,    -1,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,    -1,   394,   395,   396,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,   433,    -1,    -1,    -1,    -1,
     438,   439,     5,     6,     7,     8,     9,    10,    11,   447,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
      -1,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,    -1,    -1,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,   194,   195,    -1,   197,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
     223,   224,    -1,   226,   227,   228,   229,   230,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,    -1,   245,   246,   247,    -1,    -1,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,    -1,   296,    -1,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
      -1,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
     433,    -1,    -1,    -1,    -1,    -1,   439,    -1,     6,     7,
       8,     9,    10,    11,   447,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    93,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
     238,   239,   240,   241,   242,   243,    -1,   245,   246,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,    -1,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
     448,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,   447,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,   115,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,   195,    -1,   197,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,   211,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,   223,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,    -1,   245,   246,   247,   248,
      -1,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,   292,    -1,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
     399,    -1,   401,   402,    -1,   404,   405,   406,   407,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,   447,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,   109,
     110,    -1,   112,   113,    -1,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,    -1,   188,   189,
     190,    -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,   211,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,    -1,   226,   227,   228,    -1,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,   447,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      41,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,   422,    -1,   424,   425,    -1,    -1,    -1,    -1,   430,
     431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   446,   447,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,   422,    -1,   424,   425,    -1,    -1,    -1,
      -1,   430,   431,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,   447,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,    -1,   188,   189,   190,    -1,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
      -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,
     243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,    -1,
     283,    -1,   285,   286,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,   402,
      -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,    -1,
      -1,   424,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,   447,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    41,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,   132,    -1,
     134,   135,   136,   137,    -1,   139,   140,   141,    -1,   143,
      -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,   183,
     184,    -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,
      -1,   205,    -1,   207,   208,   209,   210,    -1,   212,   213,
     214,    -1,   216,   217,   218,   219,   220,   221,    -1,    -1,
     224,    -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,
      -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,   243,
      -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,
      -1,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,   268,    -1,   270,   271,   272,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,    -1,   283,
      -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,
     304,   305,   306,    -1,   308,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,    -1,   337,   338,   339,   340,   341,   342,   343,
     344,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,   357,   358,    -1,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
     374,   375,   376,   377,    -1,   379,   380,    -1,    -1,   383,
     384,   385,   386,    -1,   388,   389,   390,   391,   392,    -1,
      -1,   395,   396,   397,   398,    -1,    -1,   401,   402,    -1,
     404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,
     414,   415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,
     424,   425,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,   447,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,   447,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,   447,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,    -1,   283,    -1,   285,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,
      -1,    -1,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,   404,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,    -1,    -1,    -1,    -1,    -1,
      -1,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,   447,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,    -1,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,    -1,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,    -1,
     184,    -1,    -1,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
      -1,    -1,   226,   227,   228,   229,   230,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,    -1,   246,   247,   248,   249,   250,   251,   252,    -1,
      -1,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,    -1,   300,   301,    -1,   303,
     304,   305,   306,    -1,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,   340,   341,   342,   343,
     344,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,    -1,   382,   383,
      -1,   385,    -1,   387,   388,   389,   390,   391,   392,    -1,
     394,   395,   396,   397,   398,   399,   400,   401,   402,    -1,
      -1,   405,   406,   407,   408,    -1,   410,   411,   412,   413,
     414,   415,   416,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,    -1,    -1,   430,   431,    -1,   433,
     434,   435,   436,    -1,   438,   439,   440,   441,   442,   443,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,    -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,    -1,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,   239,   240,   241,   242,   243,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,    -1,   283,    -1,   285,
     286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,
     296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,    -1,   401,   402,    -1,   404,   405,
     406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,    -1,   423,   424,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,   435,
     436,    -1,   438,   439,   440,   441,   442,   443,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,   423,   424,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   434,   435,   436,    -1,
     438,   439,   440,   441,   442,   443,     5,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,    -1,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
      -1,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,   398,
     399,   400,   401,   402,    -1,    -1,   405,   406,   407,   408,
      -1,   410,   411,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,    -1,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,   440,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,    -1,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,    -1,   280,   281,    -1,   283,    -1,    -1,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,    -1,    -1,    -1,    -1,   303,   304,   305,   306,    -1,
      -1,    -1,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,   440,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,   440,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,    -1,   283,    -1,   285,   286,   287,   288,   289,
      -1,   291,    -1,   293,    -1,   295,   296,    -1,    -1,   299,
      -1,    -1,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,   404,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,    -1,   424,   425,    -1,    -1,    -1,    -1,
     430,   431,    -1,   433,    -1,    -1,    -1,    -1,    -1,   439,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,   187,   188,   189,   190,    -1,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,    -1,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,   239,   240,   241,   242,   243,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,    -1,   283,    -1,   285,
     286,   287,   288,   289,    -1,   291,    -1,   293,    -1,   295,
     296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,    -1,   401,   402,    -1,   404,   405,
     406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,   422,    -1,   424,   425,
      -1,    -1,    -1,    -1,   430,   431,    -1,   433,    -1,    -1,
      -1,    -1,    -1,   439,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,   196,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,    -1,    -1,    -1,    -1,    -1,   431,
      -1,     6,     7,     8,     9,    10,    11,   439,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    41,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,
     425,    -1,    -1,    -1,    -1,    -1,   431,    -1,     6,     7,
       8,     9,    10,    11,   439,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,   381,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,   425,    -1,    -1,
       6,     7,     8,     9,    10,    11,   434,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,    -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,    -1,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,   239,   240,   241,   242,   243,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,    -1,   283,    -1,   285,
     286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,
     296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,    -1,   401,   402,    -1,   404,   405,
     406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,   422,    -1,   424,   425,
      -1,    -1,   428,   429,   430,   431,    -1,   433,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,   381,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,    -1,   424,   425,    -1,    -1,
      -1,    -1,   430,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,   157,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,    -1,   188,   189,   190,    -1,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
      -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,
     243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,   268,    -1,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,    -1,
     283,    -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,   402,
      -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
      -1,   424,   425,    -1,    -1,    -1,    -1,   430,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,    -1,   424,   425,    -1,    -1,
      -1,    -1,   430,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,    -1,   188,   189,   190,    -1,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
      -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,
     243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,   268,    -1,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,    -1,
     283,    -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,   402,
      -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
      -1,   424,   425,    -1,    -1,    -1,    -1,   430,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,    -1,     4,   427,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    17,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,    -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,    -1,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,   239,   240,   241,   242,   243,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,    -1,   283,    -1,   285,
     286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,
     296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,    -1,   401,   402,    -1,   404,   405,
     406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,     6,     7,     8,   421,    10,    11,   424,    13,
      14,    15,    -1,    -1,    -1,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    -1,    -1,
      -1,    35,    36,    37,    38,    -1,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    -1,    -1,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,   103,
     104,   105,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,
      -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,   142,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     154,   155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   183,
      -1,    -1,   186,    -1,    -1,    -1,   190,    -1,    -1,    -1,
      -1,   195,    -1,   197,    -1,    -1,    -1,    -1,    -1,   203,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   223,
     224,    -1,    -1,    -1,    -1,    -1,   230,    -1,   232,    -1,
      -1,   235,   236,    -1,   238,    -1,    -1,    -1,    -1,    -1,
      -1,   245,   246,    -1,   248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   266,   267,   268,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,
      -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   299,   300,   301,   302,    -1,
      -1,    -1,    -1,    -1,   308,   309,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   320,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   336,    -1,    -1,   339,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   353,
      -1,    -1,   356,    -1,   358,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,    -1,    -1,    -1,
     384,    -1,   386,    -1,    -1,    -1,    -1,    -1,    -1,   393,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   405,    -1,   407,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,    -1,    -1,
     424,    -1,   426,     6,     7,     8,    -1,    10,    11,    -1,
      13,    14,    15,    -1,    -1,    -1,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    -1,
      -1,    -1,    35,    36,    37,    38,    -1,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    -1,    -1,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,   142,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   154,   155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     183,    -1,    -1,   186,    -1,    -1,    -1,   190,    -1,    -1,
      -1,    -1,   195,    -1,   197,    -1,    -1,    -1,    -1,    -1,
     203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     223,   224,    -1,    -1,    -1,    -1,    -1,   230,    -1,   232,
      -1,    -1,   235,   236,    -1,   238,    -1,    -1,    -1,    -1,
      -1,    -1,   245,   246,    -1,   248,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   266,   267,   268,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,
      -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,   302,
      -1,    -1,    -1,    -1,    -1,   308,   309,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   336,    -1,    -1,   339,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     353,    -1,    -1,   356,    -1,   358,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,    -1,    -1,
      -1,   384,    -1,   386,    -1,    -1,    -1,    -1,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   405,    -1,   407,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,    -1,
      -1,   424,    -1,   426,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,    -1,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,    -1,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     401,   402,    -1,    -1,   405,   406,   407,   408,    -1,   410,
     411,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,    -1,   137,    -1,   139,   140,
     141,   142,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,   190,
      -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,   200,
      -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,    -1,   223,   224,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,    -1,    -1,   246,   247,   248,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,    -1,   278,    -1,   280,
     281,   282,   283,    -1,    -1,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,   300,
     301,    -1,   303,   304,   305,   306,    -1,    -1,    -1,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,   356,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,    -1,   405,   406,   407,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,    -1,   137,    -1,   139,   140,
     141,   142,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,   190,
      -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,   200,
      -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,   210,
     211,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,   223,    -1,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,    -1,    -1,   246,   247,   248,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,    -1,   278,    -1,   280,
     281,   282,   283,    -1,    -1,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,   300,
     301,    -1,   303,   304,   305,   306,    -1,    -1,    -1,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,   356,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,    -1,   405,   406,   407,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,   373,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    17,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,    -1,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,    -1,   278,    -1,   280,
     281,    -1,   283,    -1,    -1,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,    -1,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,    -1,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,    -1,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,    -1,
      -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,    -1,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,    -1,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,    -1,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,    -1,
      -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,    -1,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,    -1,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,    -1,   278,    -1,   280,
     281,    -1,   283,   284,    -1,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,    -1,
      -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,   107,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
  