.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE CONSTRAINT TRIGGER" "" "2009-09-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE CONSTRAINT TRIGGER \- define a new constraint trigger

.SH SYNOPSIS
.sp
.nf
CREATE CONSTRAINT TRIGGER \fIname\fR
    AFTER \fIevent [ OR ... ]\fR
    ON \fItable_name\fR
    [ FROM \fIreferenced_table_name\fR ]
    { NOT DEFERRABLE | [ DEFERRABLE ] { INITIALLY IMMEDIATE | INITIALLY DEFERRED } }
    FOR EACH ROW
    EXECUTE PROCEDURE \fIfuncname\fR ( \fIarguments\fR )
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE CONSTRAINT TRIGGER\fR is used within
\fBCREATE TABLE\fR/\fBALTER TABLE\fR and by
\fBpg_dump\fR to create the special triggers for
referential integrity.
It is not intended for general use.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the constraint trigger. The actual name of the
created trigger will be of the form
RI_ConstraintTrigger_0000 (where 0000 is some number
assigned by the server).
Use this assigned name when dropping the trigger.
.TP
\fB\fIevent\fB\fR
One of INSERT, UPDATE, or
DELETE; this specifies the event that will fire the
trigger. Multiple events can be specified using OR.
.TP
\fB\fItable_name\fB\fR
The (possibly schema-qualified) name of the table in which
the triggering events occur.
.TP
\fB\fIreferenced_table_name\fB\fR
The (possibly schema-qualified) name of the table referenced by the
constraint. Used by foreign key constraints triggers.
.TP
\fBDEFERRABLE\fR
.TP
\fBNOT DEFERRABLE\fR
.TP
\fBINITIALLY IMMEDIATE\fR
.TP
\fBINITIALLY DEFERRED\fR
See the CREATE TABLE [\fBcreate_table\fR(l)]
documentation for details of these constraint options.
.TP
\fB\fIfuncname\fB(\fIargs\fB)\fR
The function to call as part of the trigger processing. See CREATE TRIGGER [\fBcreate_trigger\fR(l)] for
details.
.SH "COMPATIBILITY"
.PP
\fBCREATE CONTRAINT TRIGGER\fR is a
PostgreSQL extension of the SQL
standard.
