.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "UPDATE" "" "2010-03-12" "SQL - Language Statements" "SQL Commands"
.SH NAME
UPDATE \- update rows of a table

.SH SYNOPSIS
.sp
.nf
UPDATE [ ONLY ] \fItable\fR SET \fIcolumn\fR = { \fIexpression\fR | DEFAULT } [, ...]
    [ FROM \fIfromlist\fR ]
    [ WHERE \fIcondition\fR ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBUPDATE\fR changes the values of the specified
columns in all rows that satisfy the condition. Only the columns to
be modified need be mentioned in the SET clause;
columns not explicitly modified retain their previous values.
.PP
By default, \fBUPDATE\fR will update rows in the
specified table and all its subtables. If you wish to only update
the specific table mentioned, you must use the ONLY
clause.
.PP
There are two ways to modify a table using information contained in
other tables in the database: using sub-selects, or specifying
additional tables in the FROM clause. Which
technique is more appropriate depends on the specific
circumstances.
.PP
You must have the UPDATE privilege on the table
to update it, as well as the SELECT
privilege to any table whose values are read in the
\fIexpression\fRs or
\fIcondition\fR.
.SH "PARAMETERS"
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of the table to update.
.TP
\fB\fIcolumn\fB\fR
The name of a column in \fItable\fR.
The column name can be qualified with a subfield name or array
subscript, if needed.
.TP
\fB\fIexpression\fB\fR
An expression to assign to the column. The expression may use the
old values of this and other columns in the table.
.TP
\fBDEFAULT\fR
Set the column to its default value (which will be NULL if no
specific default expression has been assigned to it).
.TP
\fB\fIfromlist\fB\fR
A list of table expressions, allowing columns from other tables
to appear in the WHERE condition and the update
expressions. This is similar to the list of tables that can be
specified in the FROM Clause [\fBselect\fR(l)] of a \fBSELECT\fR
statement. Note that the target table must not appear in the
\fIfromlist\fR, unless you intend a self-join (in which
case it must appear with an alias in the \fIfromlist\fR).
.TP
\fB\fIcondition\fB\fR
An expression that returns a value of type \fBboolean\fR.
Only rows for which this expression returns true
will be updated.
.SH "OUTPUTS"
.PP
On successful completion, an \fBUPDATE\fR command returns a command
tag of the form
.sp
.nf
UPDATE \fIcount\fR
.sp
.fi
The \fIcount\fR is the number
of rows updated. If \fIcount\fR is
0, no rows matched the \fIcondition\fR (this is not considered
an error).
.SH "NOTES"
.PP
When a FROM clause is present, what essentially happens
is that the target table is joined to the tables mentioned in the
\fIfromlist\fR, and each output row of the join
represents an update operation for the target table. When using
FROM you should ensure that the join
produces at most one output row for each row to be modified. In
other words, a target row shouldn't join to more than one row from
the other table(s). If it does, then only one of the join rows
will be used to update the target row, but which one will be used
is not readily predictable.
.PP
Because of this indeterminacy, referencing other tables only within
sub-selects is safer, though often harder to read and slower than
using a join.
.SH "EXAMPLES"
.PP
Change the word Drama to Dramatic in the
column \fBkind\fR of the table \fBfilms\fR:
.sp
.nf
UPDATE films SET kind = 'Dramatic' WHERE kind = 'Drama';
.sp
.fi
.PP
Adjust temperature entries and reset precipitation to its default
value in one row of the table \fBweather\fR:
.sp
.nf
UPDATE weather SET temp_lo = temp_lo+1, temp_hi = temp_lo+15, prcp = DEFAULT
  WHERE city = 'San Francisco' AND date = '2003-07-03';
.sp
.fi
.PP
Increment the sales count of the salesperson who manages the
account for Acme Corporation, using the FROM
clause syntax:
.sp
.nf
UPDATE employees SET sales_count = sales_count + 1 FROM accounts
  WHERE accounts.name = 'Acme Corporation'
  AND employees.id = accounts.sales_person;
.sp
.fi
.PP
Perform the same operation, using a sub-select in the
WHERE clause:
.sp
.nf
UPDATE employees SET sales_count = sales_count + 1 WHERE id =
  (SELECT sales_person FROM accounts WHERE name = 'Acme Corporation');
.sp
.fi
.PP
Attempt to insert a new stock item along with the quantity of stock. If
the item already exists, instead update the stock count of the existing
item. To do this without failing the entire transaction, use savepoints.
.sp
.nf
BEGIN;
-- other operations
SAVEPOINT sp1;
INSERT INTO wines VALUES('Chateau Lafite 2003', '24');
-- Assume the above fails because of a unique key violation,
-- so now we issue these commands:
ROLLBACK TO sp1;
UPDATE wines SET stock = stock + 24 WHERE winename = 'Chateau Lafite 2003';
-- continue with other operations, and eventually
COMMIT;
.sp
.fi
.SH "COMPATIBILITY"
.PP
This command conforms to the SQL standard, except
that the FROM clause is a
PostgreSQL extension.
.PP
Some other database systems offer a FROM option in which
the target table is supposed to be listed again within FROM.
That is not how PostgreSQL interprets
FROM. Be careful when porting applications that use this
extension.
