.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TABLE AS" "" "2009-03-13" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TABLE AS \- create a new table from the results of a query

.SH SYNOPSIS
.sp
.nf
CREATE [ [ GLOBAL | LOCAL ] { TEMPORARY | TEMP } ] TABLE \fItable_name\fR [ (\fIcolumn_name\fR [, ...] ) ]
    AS \fIquery\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TABLE AS\fR creates a table and fills it
with data computed by a \fBSELECT\fR command or an
\fBEXECUTE\fR that runs a prepared
\fBSELECT\fR command. The table columns have the
names and data types associated with the output columns of the
\fBSELECT\fR (except that you can override the column
names by giving an explicit list of new column names).
.PP
\fBCREATE TABLE AS\fR bears some resemblance to
creating a view, but it is really quite different: it creates a new
table and evaluates the query just once to fill the new table
initially. The new table will not track subsequent changes to the
source tables of the query. In contrast, a view re-evaluates its
defining \fBSELECT\fR statement whenever it is
queried.
.SH "PARAMETERS"
.TP
\fBTEMPORARY or TEMP\fR
If specified, the table is created as a temporary table.
Refer to CREATE TABLE [\fBcreate_table\fR(l)] for details.
.TP
\fB\fItable_name\fB\fR
The name (optionally schema-qualified) of the table to be created.
.TP
\fB\fIcolumn_name\fB\fR
The name of a column in the new table. If column names are not
provided, they are taken from the output column names of the
query. If the table is created out of an
\fBEXECUTE\fR command, a column name list can
currently not be specified.
.TP
\fB\fIquery\fB\fR
A query statement (that is, a \fBSELECT\fR command
or an \fBEXECUTE\fR command that runs a prepared
\fBSELECT\fR command). Refer to SELECT [\fBselect\fR(l)] or EXECUTE [\fBexecute\fR(l)],
respectively, for a description of the allowed syntax.
.SH "NOTES"
.PP
This command is functionally equivalent to SELECT INTO [\fBselect_into\fR(l)], but it is preferred since it is less
likely to be confused with other uses of the \fBSELECT
\&... INTO\fR syntax.
.SH "COMPATIBILITY"
.PP
This command is modeled after an Oracle
feature. There is no command with equivalent functionality in
the SQL standard. However, a combination of CREATE
TABLE and INSERT ... SELECT can
accomplish the same thing with little more effort.
.SH "SEE ALSO"
CREATE TABLE [\fBcreate_table\fR(l)], CREATE VIEW [\fBcreate_view\fR(l)], EXECUTE [\fBexecute\fR(l)], SELECT [\fBselect\fR(l)], SELECT INTO [\fBselect_into\fR(l)]
