.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "PG_LISTEN" "" "2007-09-16" "" "PostgreSQL 7.4.18 Documentation"
.SH NAME
pg_listen \- set or change a callback for asynchronous notification messages

.SH SYNOPSIS
.sp
.nf
pg_listen \fIconn\fR \fInotifyName\fR [\fIcallbackCommand\fR]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBpg_listen\fR creates, changes, or cancels a
request to listen for asynchronous notification messages from the
PostgreSQL server. With a
\fIcallbackCommand\fR parameter, the request is
established, or the command string of an already existing request
is replaced. With no \fIcallbackCommand\fR parameter, a
prior request is canceled.
.PP
After a \fBpg_listen\fR request is established, the
specified command string is executed whenever a notification
message bearing the given name arrives from the server. This
occurs when any PostgreSQL client
application issues a
\fBNOTIFY\fR command referencing that name. The
command string is executed from the Tcl idle loop. That is the
normal idle state of an application written with Tk. In non-Tk Tcl
shells, you can execute \fBupdate\fR or
\fBvwait\fR to cause the idle loop to be entered.
.PP
You should not invoke the SQL statements \fBLISTEN\fR
or \fBUNLISTEN\fR directly when using
\fBpg_listen\fR. \fBpgtcl\fR
takes care of issuing those statements for you. But if you want to
send a notification message yourself, invoke the SQL
\fBNOTIFY\fR statement using
\fBpg_exec\fR.
.SH "ARGUMENTS"
.TP
\fB\fIconn\fB\fR
The handle of the connection on which to listen for notifications.
.TP
\fB\fInotifyName\fB\fR
The name of the notification condition to start or stop
listening to.
.TP
\fB\fIcallbackCommand\fB\fR
If present, provides the command string to execute when a
matching notification arrives.
.SH "RETURN VALUE"
.PP
None
