.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE DATABASE" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE DATABASE \- create a new database
.SH SYNOPSIS
.sp
.nf
CREATE DATABASE \fIname\fR
    [ [ WITH ] [ OWNER [=] \fIdbowner\fR ]
           [ LOCATION [=] '\fIdbpath\fR' ]
           [ TEMPLATE [=] \fItemplate\fR ]
           [ ENCODING [=] \fIencoding\fR ] ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a database to create.
.TP
\fB\fIdbowner\fB\fR
Name of the database user who will own the new database,
or DEFAULT to use the default (namely, the
user executing the command).
.TP
\fB\fIdbpath\fB\fR
An alternate file-system location in which to store the new database,
specified as a string literal;
or DEFAULT to use the default location.
.TP
\fB\fItemplate\fB\fR
Name of template from which to create the new database,
or DEFAULT to use the default template
(template1).
.TP
\fB\fIencoding\fB\fR
Multibyte encoding method to use in the new database. Specify
a string literal name (e.g., 'SQL_ASCII'),
or an integer encoding number, or DEFAULT
to use the default encoding.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE DATABASE\fR
Message returned if the command completes successfully.
.TP
\fBERROR: user '\fIusername\fB' is not allowed to create/drop databases\fR
You must have the special CREATEDB privilege to create databases.
See CREATE USER [\fBcreate_user\fR(l)].
.TP
\fBERROR: createdb: database "\fIname\fB" already exists\fR
This occurs if a database with the \fIname\fR
specified already exists.
.TP
\fBERROR: database path may not contain single quotes\fR
The database location
\fIdbpath\fR cannot contain
single quotes. This is required so that the shell commands that
create the database directory can execute safely.
.TP
\fBERROR: CREATE DATABASE: may not be called in a transaction block\fR
If you have an explicit transaction block in progress you cannot call
\fBCREATE DATABASE\fR. You must finish the transaction first.
.TP
\fBERROR: Unable to create database directory '\fIpath\fB'.\fR
.TP
\fBERROR: Could not initialize database directory.\fR
These are most likely related to insufficient permissions on the data
directory, a full disk, or other file system problems. The user under
which the database server is running must have access to the location.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE DATABASE\fR creates a new
PostgreSQL database.
.PP
Normally, the creator becomes the owner of the new database.
Superusers can create databases owned by other users using the
\fBOWNER\fR clause. They can even create databases owned by
users with no special privileges. Non-superusers with CREATEDB
privilege can only create databases owned by themselves.
.PP
An alternate location can be specified in order to,
for example, store the database on a different disk.
The path must have been prepared with the 
initlocation [\fBinitlocation\fR(1)]
command.
.PP
If the path name does not contain a slash, it is interpreted
as an environment variable name, which must be known to the
server process. This way the database administrator can
exercise control over locations in which databases can be created.
(A customary choice is, e.g., \fBPGDATA2\fR.)
If the server is compiled with ALLOW_ABSOLUTE_DBPATHS
(not so by default), absolute path names, as identified by
a leading slash
(e.g., \fI/usr/local/pgsql/data\fR),
are allowed as well.
.PP
By default, the new database will be created by cloning the standard
system database template1. A different template can be
specified by writing TEMPLATE =
\fIname\fR. In particular,
by writing TEMPLATE = template0, you can create a virgin
database containing only the standard objects predefined by your
version of \fBPostgreSQL\fR. This is useful
if you wish to avoid copying
any installation-local objects that may have been added to
template1. 
.PP
The optional encoding parameter allows selection of the database encoding,
if your server was compiled with multibyte encoding support. When not
specified, it defaults to the encoding used by the selected template
database.
.PP
Optional parameters can be written in any order, not only the order
illustrated above.
.SS "NOTES"
.PP
\fBCREATE DATABASE\fR is a PostgreSQL
language extension.
.PP
Use DROP DATABASE [\fBdrop_database\fR(l)] to remove a database.
.PP
The program createdb [\fBcreatedb\fR(1)] is a
shell script wrapper around this command, provided for convenience.
.PP
There are security and data integrity issues
involved with using alternate database locations
specified with absolute path names, and by default
only an environment variable known to the backend may be
specified for an alternate location.
See the Administrator's Guide for more information.
.PP
Although it is possible to copy a database other than template1
by specifying its name as the template, this is not (yet) intended as
a general-purpose COPY DATABASE facility.
We recommend that databases used as templates be treated as read-only.
See the \fIAdministrator's Guide\fR for more information.
.SH "USAGE"
.PP
To create a new database:
.sp
.nf
olly=> \fBcreate database lusiadas;\fR
   
.sp
.fi
.PP
To create a new database in an alternate area \fI~/private_db\fR:
.sp
.nf
$ \fBmkdir private_db\fR
$ \fBinitlocation ~/private_db\fR
    The location will be initialized with username "olly".
This user will own all the files and must also own the server process.
Creating directory /home/olly/private_db
Creating directory /home/olly/private_db/base

initlocation is complete.
    
   
$ \fBpsql olly\fR
Welcome to psql, the PostgreSQL interactive terminal.
 
Type:  \\copyright for distribution terms
       \\h for help with SQL commands
       \\? for help on internal slash commands
       \\g or terminate with semicolon to execute query
       \\q to quit

olly=> \fBCREATE DATABASE elsewhere WITH LOCATION = '/home/olly/private_db';\fR
CREATE DATABASE
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCREATE DATABASE\fR statement in SQL92.
Databases are equivalent to catalogs, whose creation is
implementation-defined.
