.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP USER" "l" "2002-01-30" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP USER \- remove a database user account
.SH SYNOPSIS
.sp
.nf
DROP USER \fIname\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing user.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP USER\fR
The message returned if the user is successfully deleted.
.TP
\fBERROR: DROP USER: user "\fIname\fB" does not exist\fR
This message occurs if the user name is not found.
.TP
\fBDROP USER: user "\fIname\fB" owns database "\fIname\fB", cannot be removed\fR
You must drop the database first or change its ownership.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP USER\fR removes the specified user from the database.
It does not remove tables, views, or other objects owned by the user. If the
user owns any database you get an error.
.PP
Use CREATE USER [\fBcreate_user\fR(l)]
to add new users, and ALTER USER [\fBalter_user\fR(l)] to change a user's properties.
PostgreSQL
comes with a script dropuser [\fBdropuser\fR(1)]
which has the same functionality as this command (in fact, it calls this command)
but can be run from the command shell.
.SH "USAGE"
.PP
To drop a user account:
.sp
.nf
DROP USER jonathan;
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP USER\fR in SQL92.
