<?
/*
  Author: Greg Feigenson
  File: functions.inc.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/

function isLoggedIn()
{
	if (!isset($_SESSION['username']))
		return false;
		
	return true;
}

function generateString($len)
{
	$str = '';
	while ($len > 0)
	{
		$rand = mt_rand(48,122);
		if ($rand < 58 || ($rand > 64 && $rand < 91) 
		    || ($rand > 96 && $rand < 123))
		{
			$str.= chr($rand);
			$len--;
		}
	}
	
	return $str;
}

function printError($error)
{
	print("<font color='red' size=3><p align='center'><b>$error</b></p></font>");
}

function printNotice($notice)
{
	print("<font color='e7c511' size=3><p align='center'><b>$notice</b></p></font>");
}

function grabLinks($security)
{
	//Query DB
	require('db.inc.php');
	$sql = "SELECT * FROM links WHERE (security <= 0 OR security <= $security) AND visible = 1 ORDER BY id";
	$query = pg_exec($sql);
	$array = array();
	
	while ($result = pg_fetch_assoc($query))
	{
		$token = $result[token];
		$array[$token] = $result;
	}

	pg_close($connection);
	
	$_SESSION[links] = $array;
}

function grabLink($token)
{
	return $_SESSION[links][$token];
}

function printNavLinks()
{
	//update links cache
	grabLinks($_SESSION[acct_type]); 
	
	//print link container
	echo "<br>-->&nbsp;&nbsp;[ ";

	//print links
	foreach ($_SESSION[links] as $link)
	{
		echo "<a href='{$link['href']}' class='footer'>{$link['description']}</a> ";
		
		if ($link['id'] < count($_SESSION[links]))
			echo "|| ";
	}

	//print link container end piece
	echo " ]&nbsp;&nbsp;<-- &nbsp;&nbsp;";
}

function checkSecurity()
{
	/*
	 * This checks with the database and sees if the user has credentials
	 * to view this page. Will fail true if the page is not in the DB! so
	 * be careful.
	 *
	 * The link architecture should accomodate you though in that it has a
	 * "visible" parameter, for being printed in the header/footer links.
	 * You should add your link and set it invisible if you don't want it
	 * on your header/footer to follow through with this security mechanism
	 */
	$file = explode("/",$_SERVER['PHP_SELF']); //grab current filename
	$i = count($file) - 1; //should be at the last index
	$filename = $file[$i]; //this is the current file
	
	require('db.inc.php');
	$sql = "SELECT security FROM links WHERE href = '$filename'";	
	$query = pg_exec($sql);
	$result = pg_fetch_assoc($query);
	pg_close($connection);
	
	if (pg_num_rows($query) < 1)
		return true; 
	
	if ($_SESSION['acct_type'] < $result['security'])
		return false;
	else
		return true;
}

?>
