#!/usr/bin/perl

my %replace_define = (
	'\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}' => 'XXXX-XX-XX XX:XX:XX',
	'\(\d{2}:\d{2}:\d{2}\)' => '(XX:XX:XX)',
	'removed \d+ row versions in \d+ pages' => 'removed xxx row versions in xxx pages',
	'found \d+ removable, \d+ nonremovable row versions in \d+ out of \d+ pages' => 'found xxx removable, xxx nonremovable row versions in xxx out of xxx pages',
	'\d+ dead row versions cannot be removed yet' => 'xxx dead row versions cannot be removed yet',
	'There were \d+ unused item pointers' => 'There were xxx unused item pointers',
	'\d+ pages are entirely empty' => 'xxx pages are entirely empty',
	'CPU \d+\.\d+s/\d+\.\d+u sec elapsed \d+\.\d+ sec' => 'CPU xx.xxs/xx.xxu sec elapsed xx.xx sec',
	'truncated \d+ to \d+ pages' => 'truncated xxx to xxx pages',
	'found \d+ removable, \d+ nonremovable row versions in \d+ pages' => 'found xxx removable, xxx nonremovable row versions in xxx pages',
	'Nonremovable row versions range from \d+ to \d+ bytes long.' => 'Nonremovable row versions range from xxx to xxx bytes long.',
	'Total free space \(including removable row versions\) is \d+ bytes.' => 'Total free space (including removable row versions) is xxx bytes.',
	'\d+ pages are or will become empty, including \d+ at the end of the table.' => 'xxx pages are or will become empty, including xxx at the end of the table.',
	'\d+ pages containing \d+ free bytes are potential move destinations.' => 'xxx pages containing xxx free bytes are potential move destinations.',
	'scanned \d+ of \d+ pages, containing \d+ live rows and \d+ dead rows; \d+ rows in sample, \d+ estimated total rows' => 'scanned xxx of xxx pages, containing xxx live rows and xxx dead rows; xxx rows in sample, xxx estimated total rows'
);

$ENV{'PGDATABASE'} = "regression";

if ($#ARGV < 0)
{
	print(STDERR "Error: parameter invalid\n");
	exit 1;
}

my $command = shift(@ARGV);
foreach $param (@ARGV)
{
	$command = "$command \"$param\"";
}

open(IN, "$command 2>&1 |") or die "... $!\n";

while ($in = <IN>)
{
	foreach $pattern ( keys %replace_define )
	{
		$in =~ s/$pattern/$replace_define{$pattern}/g;
	}
	print(STDOUT $in);
}
close(IN);
exit ($? >> 8);
