/* $Id: system.h,v 1.2 2005/12/04 03:47:16 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Interface to Postgres system types (Oid, CommandID, aclitem, etc)
 */
#ifndef PyPg_type_system_H
#define PyPg_type_system_H 0
#ifdef __cplusplus
extern "C" {
#endif

#ifndef PyPg_ci_H
IF_PGTYPE_OID(extern PyPgTypeObject PyPg_oid_Type;)
IF_PGTYPE_CID(extern PyPgTypeObject PyPg_cid_Type;)
IF_PGTYPE_XID(extern PyPgTypeObject PyPg_xid_Type;)
IF_PGTYPE_TID(extern PyPgTypeObject PyPg_tid_Type;)
IF_PGTYPE_ACLITEM(extern PyPgTypeObject PyPg_aclitem_Type;)
IF_PGTYPE_REFCURSOR(extern PyPgTypeObject PyPg_refcursor_Type;)
IF_PGTYPE_REGPROCEDURE(extern PyPgTypeObject PyPg_regprocedure_Type;)
IF_PGTYPE_REGPROC(extern PyPgTypeObject PyPg_regproc_Type;)
IF_PGTYPE_REGCLASS(extern PyPgTypeObject PyPg_regclass_Type;)
IF_PGTYPE_REGTYPE(extern PyPgTypeObject PyPg_regtype_Type;)
IF_PGTYPE_REGOPER(extern PyPgTypeObject PyPg_regoper_Type;)
IF_PGTYPE_REGOPERATOR(extern PyPgTypeObject PyPg_regoperator_Type;)
IF_PGTYPE_OIDVECTOR(extern PyPgTypeObject PyPg_oidvector_Type;)
IF_PGTYPE_INT2VECTOR(extern PyPgTypeObject PyPg_int2vector_Type;)

Oid Oid_FromPyObject(PyObj);
#else
#	ifdef PGTYPE_OID
#		define PyPg_oid_Type (*(PyPgCI.PyPg_oid_Type))
#	endif
#	ifdef PGTYPE_CID
#		define PyPg_cid_Type (*(PyPgCI.PyPg_cid_Type))
#	endif
#	ifdef PGTYPE_XID
#		define PyPg_xid_Type (*(PyPgCI.PyPg_xid_Type))
#	endif
#	ifdef PGTYPE_TID
#		define PyPg_tid_Type (*(PyPgCI.PyPg_tid_Type))
#	endif
#	ifdef PGTYPE_ACLITEM
#		define PyPg_aclitem_Type (*(PyPgCI.PyPg_aclitem_Type))
#	endif
#	ifdef PGTYPE_REFCURSOR
#		define PyPg_refcursor_Type (*(PyPgCI.PyPg_refcursor_Type))
#	endif
#	ifdef PGTYPE_REGPROCEDURE
#		define PyPg_regprocedure_Type (*(PyPgCI.PyPg_regprocedure_Type))
#	endif
#	ifdef PGTYPE_REGPROC
#		define PyPg_regproc_Type (*(PyPgCI.PyPg_regproc_Type))
#	endif
#	ifdef PGTYPE_REGCLASS
#		define PyPg_REGCLASS_Type (*(PyPgCI.PyPg_regclass_Type))
#	endif
#	ifdef PGTYPE_REGTYPE
#		define PyPg_regtype_Type (*(PyPgCI.PyPg_regtype_Type))
#	endif
#	ifdef PGTYPE_REGOPER
#		define PyPg_regoper_Type (*(PyPgCI.PyPg_regoper_Type))
#	endif
#	ifdef PGTYPE_REGOPERATOR
#		define PyPg_regoperator_Type (*(PyPgCI.PyPg_regoperator_Type))
#	endif
#	ifdef PGTYPE_OIDVECTOR
#		define PyPg_oidvector_Type (*(PyPgCI.PyPg_oidvector_Type))
#	endif
#	ifdef PGTYPE_INT2VECTOR
#		define PyPg_int2vector_Type (*(PyPgCI.PyPg_int2vector_Type))
#	endif
#endif /* PyPg_ci_H */

#define PyPg_oid_FromObjectId(oid) \
	PyPgObject_New(&PyPg_oid_Type, ObjectIdGetDatum(oid))
#define PyPg_oid_FromOid(oid) PyPg_oid_FromObjectId(oid)

#define PyPg_cid_FromCommandId(cid) \
	PyPgObject_New(&PyPg_cid_Type, CommandIdGetDatum(cid))
#define PyPg_xid_FromTransactionId(xid) \
	PyPgObject_New(&PyPg_xid_Type, TransactionIdGetDatum(xid))

#define PyPg_oid_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_oid_Type))
#define PyPg_oid_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_oid_Type)

#define PyPg_cid_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_cid_Type))
#define PyPg_cid_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_cid_Type)

#define PyPg_xid_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_xid_Type))
#define PyPg_xid_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_xid_Type)

#define PyPg_tid_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_tid_Type))
#define PyPg_tid_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_tid_Type)

#define PyPg_aclitem_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_aclitem_Type))
#define PyPg_aclitem_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_aclitem_Type)

#define PyPg_refcursor_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_refcursor_Type))
#define PyPg_refcursor_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_refcursor_Type)

#define PyPg_regprocedure_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_regprocedure_Type))
#define PyPg_regprocedure_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_regprocedure_Type)

#define PyPg_regproc_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_regproc_Type))
#define PyPg_regproc_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_regproc_Type)

#define PyPg_regclass_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_regclass_Type))
#define PyPg_regclass_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_regclass_Type)

#define PyPg_regtype_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_regtype_Type))
#define PyPg_regtype_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_regtype_Type)

#define PyPg_regoper_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_regoper_Type))
#define PyPg_regoper_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_regoper_Type)

#define PyPg_regoperator_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_regoperator_Type))
#define PyPg_regoperator_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_regoperator_Type)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_system_H */
/*
 * vim: ts=3:sw=3:noet:
 */
