/* $Id: transaction.h,v 1.4 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/tb.h,v 1.2 2005/02/05 20:54:30 flaw
 * imp/src/tb.h,v 1.1 2004/12/15 13:10:01 flaw
 *//*
 * Postgres Transaction Block
 */
#ifndef PyPg_transaction_H
#define PyPg_transaction_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
	PgTBS_INITIALIZING = -1,
	PgTBS_INVALID = 0,
	PgTBS_RUNNING = 1,
	PgTBS_COMMITTING,
	PgTBS_COMMITTED,
	PgTBS_ABORTING,
	PgTBS_ABORTED
} PgTBState;

typedef struct PyPgTransaction {
	PyObject_HEAD
	PgTBState		xa_state;	/* last known state of block */
	PyObj				xa_points;	/* savepoints set in block */
	PyObj				xa_sptp;		/* the savepoint type for this block */
} *PyPgTransaction;

extern PyTypeObject PyPgTransaction_Type;

#define PyPgTransaction_NEW() \
	(PyObj) PyPgTransactionBlock_Type.tp_alloc(&PyPgTransactionBlock_Type, 0)

#define PyPgTransaction(SELF) ((PyPgTransaction) SELF)

#define PyPgTransaction_Check(SELF) \
	(PyObject_TypeCheck(SELF, &PyPgTransactionBlock_Type))
#define PyPgTransaction_CheckExact(SELF) \
	(SELF->ob_type == &PyPgTransactionBlock_Type)

#define PyPgTransaction_FetchState(SELF) \
	(PyPgTransaction(SELF)->xa_state)
#define PyPgTransaction_FetchSavepoints(SELF) \
	(PyPgTransaction(SELF)->xa_points)
#define PyPgTransaction_FetchSavepointType(SELF) \
	(PyPgTransaction(SELF)->xa_sptp)

#define PyPgTransaction_FixState(SELF, S) \
	(PyPgTransaction(SELF)->xa_state = S)
#define PyPgTransaction_FixSavepoints(SELF, OB) \
	(PyPgTransaction(SELF)->xa_points = OB)
#define PyPgTransaction_FixSavepointType(SELF, OB) \
	(PyPgTransaction(SELF)->xa_sptp = OB)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_transaction_H */
/*
 * vim: ts=3:sw=3:noet:
 */
