
--
-- tests extracted from the READMEs
--
-- to be extended
--

CREATE TYPE __testrowperl AS (f1 integer, f2 text, f3 text);

CREATE OR REPLACE FUNCTION perl_row() RETURNS __testrowperl AS $$

return {f2 => 'hello', f1 => 1, f3 => 'world'};

$$ LANGUAGE plperl;

select * FROM perl_row();

CREATE TYPE __testsetperl AS (f1 integer, f2 text, f3 text);

CREATE OR REPLACE FUNCTION perl_set() RETURNS SETOF __testsetperl AS $$
return[
{f1 => 1, f2 => 'hello', f3 =>  'world'},
{f1 => 2, f2 => 'hello', f3 =>  'postgres'},
{f1 => 3, f2 => 'hello', f3 =>  'plperl'}
];
$$  LANGUAGE plperl;

SELECT * FROM perl_set();

CREATE TABLE test (
        i int,
        v varchar
) WITH OIDS;

CREATE OR REPLACE FUNCTION valid_id() RETURNS trigger AS $$
       	if (($_TD->{"new"}{"i"}>=100) || ($_TD->{"new"}{"i"}<=0)){
                return "SKIP";   # Skip INSERT/UPDATE command
       	} elsif ($_TD->{"new"}{"v"} ne "immortal") {
		$_TD->{"new"}{"v"} .= "(modified by trigger)";
		return "MODIFY"; # Modify tuple and proceed INSERT/UPDATE command
	} else {
		return;          # Proceed INSERT/UPDATE command
	}
$$ LANGUAGE plperl;

CREATE TRIGGER "test_valid_id_trig" BEFORE INSERT OR UPDATE ON test
FOR EACH ROW EXECUTE PROCEDURE "valid_id"();

INSERT INTO test (i, v) VALUES (1,'first line');
INSERT INTO test (i, v) VALUES (2,'second line');
INSERT INTO test (i, v) VALUES (3,'third line');
INSERT INTO test (i, v) VALUES (4,'immortal');

INSERT INTO test (i, v) VALUES (101,'bad id');

UPDATE test SET i = 5 where i=3;

UPDATE test SET i = 100 where i=1;


CREATE OR REPLACE FUNCTION immortal() RETURNS trigger AS $$
        if ($_TD->{"old"}{"v"} eq $_TD->{"args"}{0}){
                return "SKIP"; # Skip DELETE command
        } else { 
		return;        # Proceed DELETE command
	};
$$ LANGUAGE plperl;

CREATE TRIGGER "immortal_trig" BEFORE DELETE ON test
FOR EACH ROW EXECUTE PROCEDURE immortal('immortal');

DELETE FROM test;
