<?
/*
Autor (Author): Guilherme Augusto da Rocha Silva <gars.dba@gmail.com>
Criao (Created) - ISO: 2007/04/30
Verso (Version): 0.1
Liberao (Release): 20070430a

Desenvolvido, testado e funcionou bem em/com (Developed, tested and worked well in/with):
   - Intel Pentium IV 1.7GHZ, 256kb cache, 512mb RAM.
   - GNU/Linux with kernel 2.6, distro Debian 3.1.
   - PostgreSQL 8.1.
   - PHP 4.3.10 +  Zend Engine 1.3.0.
   - Apache 2.0.54 + PHP module.
   - Mozilla Firefox 2.0.0.3.
*/
////////////////////////////////////////////////////////////////////////////////
// Funes para exibio de informaes do SGBD.
////////////////////////////////////////////////////////////////////////////////
function exibir_estado_servidor() {
   $pid = buscar_situacao_postmaster();
   if ($pid === false) {
      $status = 'parado';
      $icone = 'db_stop.png';
   } elseif ($pid > 0) {
      $status = 'executando';
      $icone = 'db_start.png';
      $db = new database;
      if ($db->connect('localhost', 5432, 'postgres', 'postgres')) {
         $porta  = pg_port($db->connect);
         $tempos = $db->postmaster_times();
         $versao = $db->version();
         $db->close();
      }
   } else {
      $status = 'inderteminado';
      $icone = 'pg_power_unknown.gif';
   }
   $html = identar(2)."<table align='center' width='50%' border='0' cellpadding='3' cellspacing='0'>"
         . identar(3)."<caption><strong><font face='arial,helvetica'>Informa&ccedil;&atilde;o Geral</font></strong></caption>"
   ;
   if ($versao) {
      unset($aux);
      $aux = preg_split('/,/', $versao, -1, PREG_SPLIT_NO_EMPTY);
      $html .= identar(3)."<tr bgcolor=''>"
             . identar(4)."<td align='left' width='10%' nowrap><font face='arial,helvetica' size='-2'><img src='img/db_status.png' alt='db_status.png' text='vers&atilde;o' border='0' align='base'></font></td>"
             . identar(4)."<td align='left' width='90%' nowrap><font face='arial,helvetica' size='-2'>".$aux[0].'<br>'.$aux[1].'</font></td>'
             . identar(3).'</tr>'
      ;
   }
   if ($status) {
      $html .= identar(3)."<tr bgcolor=''>"
             . identar(4)."<td align='left' width='10%' nowrap><font face='arial,helvetica' size='-2'><img src='img/".$icone."' alt='".$icone."' text='".$status."' border='0' align='base'></font></td>"
             . identar(4)."<td align='left' width='90%' nowrap><font face='arial,helvetica' size='-2'>Postmaster ".$status.($pid? '<br>PID '.$pid.', porta '.$porta : '').'</font></td>'
             . identar(3).'</tr>'
      ;
   }
   if ($tempos and is_array($tempos)) {
      $icone = 'time_clock.png';
      $html .= identar(3)."<tr bgcolor=''>"
             . identar(4)."<td align='left' width='10%' nowrap><font face='arial,helvetica' size='-2'><img src='img/".$icone."' alt='".$icone."' text='tempo' border='0' align='base'></font></td>"
             . identar(4)."<td align='left' width='90%' nowrap><font face='arial,helvetica' size='-2'>Iniciado em ".($tempos['start']? $tempos['start'] : '-').'<br>Ativo por '.($tempos['uptime']? $tempos['uptime'] : '-' ).'</font></td>'
             . identar(3).'</tr>'
      ;
   }
   $html .= identar(2).'</table>';
   return (($html)? $html : null);
}
function exibir_estatisticas($databases) {
   if (is_array($databases)) {
      $titles = array('Base<br>de Dados', 'Sesses<br>Abertas', 'Blocos<br>Lidos', 'Blocos<br>Acertados', 'Uso de<br>Cache (%)', 'Tamanho<br>da Base');
      $totais = array('database' => 0, 'numbackends' => 0, 'blks_read' => 0, 'blks_hit' => 0, 'cache_stat' => 0, 'pg_database_size' => 0);
      $colunas = count($titles);
      $html = identar(2)."<table align='center' width='75%' border='0' cellpadding='3' cellspacing='0'>"
            . identar(3)."<caption><strong><font face='arial,helvetica'>Estat&iacute;sticas de Bases de Dados</font></strong></caption>"
            . identar(3)."<tr bgcolor=''>"
      ;
      for ($i = 0 ; $i < $colunas; $i++) {
         $html .= identar(4)."<th align='center' bgcolor='#F0F0F0'><font face='arial,helvetica' size='-2'>".$titles[$i].'</font></th>';
      }
      $html .= identar(3).'</tr>';
      $i = 1; // para alternar exibio de cores nas linhas
      foreach ($databases as $oid => $database) {
         $totais['databases'] += 1;
         $totais['numbackends'] += $database['numbackends'];
         $totais['blks_read'] += $database['blks_read'];
         $totais['blks_hit'] += $database['blks_hit'];
         $totais['cache_stat'] += $database['cache_stat'];
         $totais['pg_database_size'] += $database['pg_database_size'];
         $html .= identar(3)."<tr bgcolor='".(!((++$i) % 2)? '#FFFFFF' : '#F0F0F0')."'>"
                . identar(4)."<td align='left' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$database['name'].'</font></td>'
                . identar(4)."<td align='center' width='15%' nowrap><font face='arial,helvetica' size='-2'>".$database['numbackends'].'</font></td>'
                . identar(4)."<td align='right' width='15%' nowrap><font face='arial,helvetica' size='-2'>".$database['blks_read'].'</font></td>'
                . identar(4)."<td align='right' width='15%' nowrap><font face='arial,helvetica' size='-2'>".$database['blks_hit'].'</font></td>'
                . identar(4)."<td align='right' width='15%' nowrap><font face='arial,helvetica' size='-2'>".$database['cache_stat'].'</font></td>'
                . identar(4)."<td align='right' width='15%' nowrap><font face='arial,helvetica' size='-2'>"
                . round($database['pg_database_size']/pow(1024,2),2).' mb'
                . '</font></td>'
                . identar(3).'</tr>'
         ;
      }
      // Exibio da totalizao.
      $html .= identar(3)."<tr bgcolor=''>"
             . identar(4)."<td colspan='".$colunas."'><hr size='0'></td>"
             . identar(3).'</tr>'
             . identar(3)."<tr bgcolor='#FFFFFF'>"
             . identar(4)."<td align='center'><font face='arial,helvetica' size='-2'><b>Total : ".$totais['databases'].'</b></font></td>'
             . identar(4)."<td align='center'><font face='arial,helvetica' size='-2'><b>".$totais['numbackends'].'</b></font></td>'
             . identar(4)."<td align='right'><font face='arial,helvetica' size='-2'><b>".round($totais['blks_read'] / $totais['databases'], 2).'</b></font></td>'
             . identar(4)."<td align='right'><font face='arial,helvetica' size='-2'><b>".round($totais['blks_hit'] / $totais['databases'], 2).'</b></font></td>'
             . identar(4)."<td align='right'><font face='arial,helvetica' size='-2'><b>".round($totais['cache_stat'] / $totais['databases'], 2).'</b></font></td>'
             . identar(4)."<td align='right'><font face='arial,helvetica' size='-2'><b>".round($totais['pg_database_size']/pow(1024,3),2).' gb'.'</b></font></td>'
             . identar(3).'</tr>'
             . identar(3)."<tr bgcolor=''>"
             . identar(4)."<td colspan='".$colunas."'><hr size='0'></td>"
             . identar(3).'</tr>'
             . identar(2)."</table>"
      ;
   }
   return (($html)? $html : null);
}
function exibir_atividades($activity) {
   if (is_array($activity)) {
      $html = identar(2)."<table align='center' width='100%' border='1' cellpadding='3' cellspacing='0'>"
            . identar(3)."<caption><strong><font face='arial,helvetica'>Monitoramento de Processos</font></strong></caption>"
            . identar(3)."<tr bgcolor=''>";
      $titles = array('Origem', "Processo <font face='arial,helvetica' size='-3'>*</font>", 'In&iacute;cio e Tempo', 'Texto da Consulta');
      foreach ($titles as $title) {
         $html .= identar(4)."<th align='center' bgcolor='#F0F0F0'><font face='arial,helvetica' size='-2'>".$title.'</font></th>';
      }
      $html .= identar(3).'</tr>';
      foreach ($activity as $info) {
         $html .= identar(3)."<tr bgcolor=''>"
                . identar(4)."<td align='left' width='10%' nowrap><font face='arial,helvetica' size='-2'><br>"
                // Dados de base, usurio e orgigem - incio
                . identar(5)."<table align='center' width='100%' border='0' cellpadding='2' cellspacing='0'>"
                . identar(6)."<tr bgcolor='#F0F0F0'>"
                . identar(7)."<td align='center' width='50%' nowrap><font face='arial,helvetica' size='-2'><b>Base</b></td>"
                . identar(7)."<td align='center' width='50%' nowrap><font face='arial,helvetica' size='-2'><b>Usu&aacute;rio</b></td>"
                . identar(7).'</tr>'
                . identar(6)."<tr bgcolor=''>"
                . identar(7)."<td align='center' width='50%' nowrap><font face='arial,helvetica' size='-2'>".$info['datname'].identar(7).'</td>'
                . identar(7)."<td align='center' width='50%' nowrap><font face='arial,helvetica' size='-2'>".$info['usename'].identar(7).'</td>'
                . identar(6).'</tr>'
                . identar(6)."<tr bgcolor='#F0F0F0'>"
                . identar(7)."<td align='center' width='50%' nowrap><font face='arial,helvetica' size='-2'><b>IP</b></td>"
                . identar(7)."<td align='center' width='50%' nowrap><font face='arial,helvetica' size='-2'><b>Porta</b></td>"
                . identar(6).'</tr>'
                . identar(6)."<tr bgcolor=''>"
                . identar(7)."<td align='center' width='50%' nowrap><font face='arial,helvetica' size='-2'>".(($info['client_addr'] and $info['client_port'] > 0) ? $info['client_addr'] : 'localhost').identar(7).'</td>'
                . identar(7)."<td align='center' width='50%' nowrap><font face='arial,helvetica' size='-2'>".$info['client_port'].identar(7).'</td>'
                . identar(6).'</tr>'
                . identar(5).'</table>'
                // Dados de base, usurio e orgigem - fim.
                . identar(4).'</font></td>'
                . identar(4)."<td align='center' width='15%' nowrap><font face='arial,helvetica' size='-2'><b>Pid&nbsp;&nbsp;".$info['procpid'].'</b>'
         ;
         // Detalhamento do processo.
         if (($process = buscar_informacao_processo($info['procpid'])) != null) {
            $html .= identar(5)."<table align='center' width='100%' border='0' cellpadding='2' cellspacing='0'>"
                   . identar(6)."<tr bgcolor='#F0F0F0'>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>stat</td>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>start</td>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>time</td>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>tty</td>"
                   . identar(6).'</tr>'
                   . identar(6)."<tr bgcolor=''>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$process['STAT'].'</td>'
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$process['START'].'</td>'
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$process['TIME'].'</td>'
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$process['TTY'].'</td>'
                   . identar(6).'</tr>'
                   . identar(6)."<tr bgcolor='#F0F0F0'>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>cpu</td>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>mem</td>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>vsz</td>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>rss</td>"
                   . identar(6).'</tr>'
                   . identar(6)."<tr bgcolor=''>"
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$process['%CPU'].'</td>'
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$process['%MEM'].'</td>'
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$process['VSZ'].'</td>'
                   . identar(7)."<td align='center' width='25%' nowrap><font face='arial,helvetica' size='-2'>".$process['RSS'].'</td>'
                   . identar(6).'</tr>'
                   . identar(5)."</table>"
            ;
         }
         $html .= '</font></td>'
                . identar(4)."<td align='center' width='15%' nowrap><font face='arial,helvetica' size='-2'>"
                . identar(5)."<table width='100%' align='center' border='0' cellpadding='2' cellspacing='1'>"
                . identar(6)."<tr bgcolor='#F0F0F0'>"
                . identar(7)."<td align='center' width='100%' nowrap><font face='arial,helvetica' size='-2'><b>Sesso</b></td>"
                . identar(6).'</tr>'
                . identar(6)."<tr bgcolor=''>"
                . identar(7)."<td align='center' width='100%'><font face='arial,helvetica' size='-2'>"
                . $info['backend_start'].'<br>'.htmlspecialchars(str_replace('@', '', $info['backend_time']))
                . identar(7).'</td>'
                . identar(6).'</tr>'
                . identar(6)."<tr bgcolor='#F0F0F0'>"
                . identar(7)."<td align='center' width='100%'><font face='arial,helvetica' size='-2'><b>Consulta</b></td>"
                . identar(6).'</tr>'
                . identar(6)."<tr bgcolor=''>"
                . identar(7)."<td align='center' width='100%' nowrap><font face='arial,helvetica' size='-2'>"
                . (($info['current_query'] and $info['current_query'] != '<IDLE>') ? htmlspecialchars($info['query_start']).'<br>'.htmlspecialchars(str_replace('@', '', $info['query_time'])) : '-')
                . identar(7).'</td>'
                . identar(6).'</tr>'
                . identar(5).'</table>'
                . identar(4).'</font></td>'
                . identar(4)."<td align='left' width='50%'><font face='arial,helvetica' size='-2'>"
                . (($info['current_query'] and $info['current_query'] != '<IDLE>') ? $info['current_query'] : '&nbsp;')
                . identar(4).'</td>'
                . identar(3).'</tr>'
         ;
      }
      $html .= identar(6)."<tr bgcolor='#F0F0F0'>"
             . identar(7)."<td align='center' width='100%' colspan='7'><font face='arial,helvetica' size='-2'>(<b>*</b>) Vari&aacute;veis obtidas atrav&eacute;s do comando 'ps', do Linux.</font></td>"
             . identar(3).'</tr>'
             .identar(2)."</table>"
      ;
   }
   return (($html)? $html : null);
}
////////////////////////////////////////////////////////////////////////////////
// Funes para Linux.
////////////////////////////////////////////////////////////////////////////////
function buscar_informacao_processo($pid = null) {
   if ($pid) {
      exec('ps u -p '.$pid, $ps, $status);
      // Exemplo, quando h retorno. Quando no h pid, d erro do comando ps.
      // 0            1     2      3        4      5     6     7      8       9      10...
      // USER         PID   %CPU   %MEM     VSZ    RSS   TTY   STAT   START   TIME   COMMAND
      // postgres   10562    0.0    1.2   41908   6372     ?      S   15:13   0:00   /usr/lib/postgresql/8.1/bin/postmaster -D /u/erpsim/pgsql/data -c unix_socket_dir
      // postgres   10563    0.0    0.1    7440    916     ?      S   15:13   0:00   postgres: logger process
      // postgres   10565    0.0    0.2   41908   1092     ?      S   15:13   0:00   postgres: writer process
      // postgres   10566    0.0    0.3    8480   1624     ?      S   15:13   0:00   postgres: stats buffer process
      // postgres   10567    0.0    0.2    7672   1084     ?      S   15:13   0:00   postgres: stats collector process
      // postgres   10584    0.0    0.5   42324   3060     ?      S   15:13   0:00   postgres: postgres postgres [local] idle
      if (!$status and is_array($ps)) {
         if($ps[0]) $cols = preg_split('/ /', $ps[0], -1, PREG_SPLIT_NO_EMPTY);
         if($ps[1]) $vals = preg_split('/ /', $ps[1], -1, PREG_SPLIT_NO_EMPTY);
         if ($cols and is_array($cols) and $vals and is_array($vals)) {
            // Loop para ler de 2 a 9, pois desejo ignorar 'USER', 'PID' e 'COMMAND' do retorno do comando 'ps'.
            $info = array();
            for ($i = 2; $i <= 9; $i++) {
               $info[$cols[$i]] = $vals[$i];
            }
         }
      }
   }
   return (($info)? $info : null);
}
function buscar_situacao_postmaster($pid = null) {
   if ($pid) {
      exec('ps -p '.$pid, $ps, $status);
      // Exemplo, quando h retorno. Quando no h pid, d erro do comando ps.
      // 0       1     2      3    4
      // PID     TTY   STAT   TIME   COMMAND
      // 10562   ?     S      0:00   /usr/lib/postgresql/8.1/bin/postmaster -D /u/erpsim/pgsql/data -c unix_socket_directory=/var/run/postgresql -c config
      // 10563   ?     S      0:00   postgres: logger process
      // 10565   ?     S      0:00   postgres: writer process
      // 10566   ?     S      0:00   postgres: stats buffer process
      // 10567   ?     S      0:00   postgres: stats collector process
      // 10584   ?     S      0:00   postgres: postgres postgres [local] idle
      if (!$status and is_array($ps) and $ps[1]) {
         $vals = preg_split('/ /', $ps[1], -1, PREG_SPLIT_NO_EMPTY);
         if (in_array($pid, $vals)) return $pid;
      }
      return false;
   } else {
      exec('pidof postmaster', $pids, $status);
      // Exemplo, quando h retorno. Quando no h pid, retorna linha vazia.
      // 10584 10567 10566 10565 10563 10562
      if (!$status and is_array($pids)) {
         if ($pids[0]) $vals = preg_split('/ /', $pids[0], -1, PREG_SPLIT_NO_EMPTY);
         if (is_array($vals) and ($num = count($vals)) > 0) return $vals[($num - 1)]; // PID do postmaster principal. O comando pidof retorna a lista de pids em ordem reversa.
      }
      return false;
   }
   return null;
}
////////////////////////////////////////////////////////////////////////////////
// Funes para exibio de informaes diversas.
////////////////////////////////////////////////////////////////////////////////
function exibir_data_hora() {
   $html = identar(2)."<p><table align='center' width='10%' border='0' cellpadding='3' cellspacing='0'>"
         . identar(3)."<tr bgcolor='#F0F0F0'>"
         . identar(4)."<td align='center' nowrap><font face='arial,helvetica' size='-2'>".date('d/m/Y H:i:s T').'</font></td>'
         . identar(3).'</tr>'
         . identar(2)."</table></p>"
   ;
   return (($html)? $html : null);
}
////////////////////////////////////////////////////////////////////////////////
// Funes auxiliares divesas.
////////////////////////////////////////////////////////////////////////////////
function identar($num) {
   return "\n".str_repeat('   ', $num);
}
function mensagem_erro($texto = '') {
   $html = identar(2)."<p><table align='center' width='25%' border='0' cellpadding='3' cellspacing='0'>"
         . identar(3)."<tr bgcolor='#FFCC99'>"
         . identar(4)."<td align='center'>"
         . identar(4)."<img src='img/msg_error.png' border='0' align='base'>"
         . identar(3).'</td>'
         . identar(4)."<td align='left'>"
         . identar(4)."<font face='arial,helvetica' size='-2'><b>ERRO</b><br>".$texto.'</font>'
         . identar(3).'</td>'
         . identar(3).'</tr>'
         . identar(2)."</table></p>"
   ;
   return (($html)? $html : null);
}
function mensagem_aviso($texto = '') {
   $html = identar(2)."<p><table align='center' width='25%' border='0' cellpadding='3' cellspacing='0'>"
         . identar(3)."<tr bgcolor='#FFFFCC'>"
         . identar(4)."<td align='center'>"
         . identar(4)."<img src='img/msg_warning.png' border='0' align='base'>"
         . identar(3).'</td>'
         . identar(4)."<td align='left'>"
         . identar(4)."<font face='arial,helvetica' size='-2'><b>AVISO</b><br>".$texto.'</font>'
         . identar(3).'</td>'
         . identar(3).'</tr>'
         . identar(2)."</table></p>"
   ;
   return (($html)? $html : null);
}
function mensagem_informacao($texto = '') {
   $html = identar(2)."<p><table align='center' width='25%' border='0' cellpadding='3' cellspacing='0'>"
         . identar(3)."<tr bgcolor='#CCFFFF'>"
         . identar(4)."<td align='center'>"
         . identar(4)."<img src='img/msg_info.png' border='0' align='base'>"
         . identar(3).'</td>'
         . identar(4)."<td align='left'>"
         . identar(4)."<font face='arial,helvetica' size='-2'><b>INFO</b><br>".$texto.'</font>'
         . identar(3).'</td>'
         . identar(3).'</tr>'
         . identar(2)."</table></p>"
   ;
   return (($html)? $html : null);
}
function mensagem_dica($texto = '') {
   $html = identar(2)."<p><table align='center' width='25%' border='0' cellpadding='3' cellspacing='0'>"
         . identar(3)."<tr bgcolor='#CCFFCC'>"
         . identar(4)."<td align='center'>"
         . identar(4)."<img src='img/msg_idea.png' border='0' align='base'>"
         . identar(3).'</td>'
         . identar(4)."<td align='left'>"
         . identar(4)."<font face='arial,helvetica' size='-2'><b>DICA</b><br>".$texto.'</font>'
         . identar(3).'</td>'
         . identar(3).'</tr>'
         . identar(2)."</table></p>"
   ;
   return (($html)? $html : null);
}
function informacao_cliente() {
   $texto = '<u>Cliente   :</u> '.$_SERVER['REMOTE_ADDR'].':'.$_SERVER['REMOTE_PORT']
          . '<u>Executando:</u> '.$_SERVER['HTTP_USER_AGENT']
   ;
   return mensagem_informacao($texto);
}
?>
