/***************************************************************************
 *  Copyright (C) 2009 Nippon Telegraph and Telephone Corporation
 ***************************************************************************/
/*
 * stats_info_sql.h
 */

#ifndef STATS_INFO_SQL_H
#define STATS_INFO_SQL_H

/* SQL max length */
#define SQL_LEN_S  256
#define SQL_LEN   4096

/*
 * SQL for using getting snapshot
 */

/* Decryption password */
#define SQL_DECRYPT_FORMAT \
        "SELECT pgp_sym_decrypt(decode(password, 'hex'), get_key()) FROM statsinfo.t_dbconn WHERE dbid = $1;"

/* Create persistent connection by using dblink */
#define DBLINK_CONN_STRING_FORMAT "dbname=%s host=%s port=%d user=%s password=%s"
#define SQL_DBLINK_CONNECT_FORMAT "SELECT dblink_connect($1);"
#define SQL_DBLINK_DISCONNECT_FORMAT "SELECT dblink_disconnect();"

/* Deletion filterd-log files. Now we filtering "checkpoint" and "autovacuum" info */
#define SQL_DBLINK_DIRECTLY_FORMAT "SELECT * FROM dblink($1, $2) AS (result text);"

/* Get connection information (from specified DBID)*/
#define SQL_SELECT_T_DBCONN_BY_DBID_FORMAT "\
        SELECT \
            host.host_id, \
            conn.dbname, \
            conn.hostname, \
            conn.port, \
            conn.username, \
            conn.password \
        FROM \
            statsinfo.t_host_id host, \
            statsinfo.t_dbconn conn \
        WHERE \
            conn.dbid = $1 AND \
            conn.hostname = host.hostname AND \
            conn.port = host.port;"

/* Get connection information (from DBs 'istarget' flag on) */
#define  SQL_SELECT_T_DBCONN_ON_TARGET_ALL "\
        SELECT \
            host.host_id, \
            conn.dbid, \
            conn.dbname, \
            conn.hostname, \
            conn.port, \
            conn.username, \
            conn.password \
        FROM \
            statsinfo.t_host_id host, \
            statsinfo.t_dbconn conn \
        WHERE \
            conn.is_snapshot_target = true AND \
            conn.hostname = host.hostname AND \
            conn.port = host.port \
        ORDER BY \
            host.host_id;"

/*************************************************************
 * getting and storing SQL for each DBs snapshot
 * 
 * If you add new SQL, please update SQL_LIST_FOR_INSERT_INTO_DBINFO too.
 ************************************************************/
/* INSERT format for getting Snapshot ID */
#define SQL_INSERT_T_SNAPSHOT_ID_FORMAT "\
        INSERT INTO \
            statsinfo.t_snapshot_id ( \
                snapshot_date, \
                dbid, \
                host_id, \
                level, \
                description \
            ) SELECT \
                date_trunc('seconds', now()), \
                $1, \
                $2, \
                $3, \
                $4 \
        RETURNING \
            snapshot_id;"

/* INSERT format for getting DB basic info */
#define DBLINK_SELECT_T_DBINFO_FORMAT "\
        SELECT \
            pg_database_size(db.oid), \
            db_s.numbackends, \
            age(db.datfrozenxid) as datfrozenxid_age, \
            ( SELECT count(*) FROM pg_stat_user_tables ), \
			db_s.xact_commit, \
			db_s.xact_rollback, \
			db_s.blks_read, \
			db_s.blks_hit, \
			db_s.tup_returned, \
			db_s.tup_fetched, \
			db_s.tup_inserted, \
			db_s.tup_updated, \
			db_s.tup_deleted \
        FROM pg_database db \
			LEFT JOIN pg_stat_database db_s ON db.datname = db_s.datname \
        WHERE db.datname = '%s' "
#define SQL_INSERT_T_DBINFO_FORMAT "\
        INSERT INTO \
            statsinfo.t_dbinfo ( \
                snapshot_id, \
                dbid, \
                dbsize, \
                conn_number, \
                datfrozenxid_age, \
                num_user_rel, \
				db_xact_commit, \
				db_xact_rollback, \
				db_blks_read, \
				db_blks_hit, \
				db_tup_returned, \
				db_tup_fetched, \
				db_tup_inserted, \
				db_tup_updated, \
				db_tup_deleted \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink($3) \
              AS ( \
                  dbsize bigint, \
                  conn_number int, \
                  datfrozenxid_age xid, \
                  num_user_rel bigint, \
				  db_xact_commit bigint, \
				  db_xact_rollback bigint, \
				  db_blks_read bigint, \
				  db_blks_hit bigint, \
				  db_tup_returned bigint, \
				  db_tup_fetched bigint, \
				  db_tup_inserted bigint, \
				  db_tup_updated bigint, \
				  db_tup_deleted bigint \
              );"

/* INSERT format for getting DB setting info */
#define SQL_INSERT_T_DBSETTING_FORMAT "\
        INSERT INTO \
            statsinfo.t_dbsetting ( \
                snapshot_id, \
                dbid, \
                name, \
                setting, \
                source \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          name, \
                          CASE WHEN unit IS NULL THEN setting \
						       WHEN unit = ''''  THEN setting \
							   ELSE setting || ''('' || unit || '')'' \
						  END AS setting,  \
                          source \
                      FROM \
                          pg_settings \
                      WHERE \
                          source <> ''default'' \
                  ') \
              AS ( \
                  name text, \
                  setting text, \
                  source text \
              );"

/* INSERT format fot getting Table density info */
#define SQL_INSERT_T_TABLEFILL_FORMAT "\
        INSERT INTO \
            statsinfo.t_tablefill ( \
                snapshot_id, \
                dbid, \
                schemaname, \
                relname, \
                reltuples, \
                logical_pages, \
                physical_pages, \
                tratio \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          schemaname, \
                          relname, \
                          reltuples, \
                          logical_pages, \
                          physical_pages, \
                          tratio \
                      FROM \
                          targetdb.check_filling_ratio \
                  ') \
              AS ( \
                  schemaname     text, \
                  relname        text, \
                  reltuples      real, \
                  logical_pages  bigint, \
                  physical_pages bigint, \
                  tratio         int \
              );"

/* INSERT format fot getting Column correlation info */
#define SQL_INSERT_T_COLUMNCORR_FORMAT "\
        INSERT INTO \
            statsinfo.t_columncorr ( \
                snapshot_id, \
                dbid, \
                schemaname, \
                relname, \
                column_name, \
                correlation \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          schemaname, \
                          relname, \
                          column_name, \
                          correlation \
                      FROM \
                          targetdb.check_column_correlation \
                  ') \
              AS ( \
                  schemaname     text, \
                  relname        text, \
                  column_name    text, \
                  correlation    real \
              );"

#if PG_VERSION_NUM  >= 80400

/* INSERT format for getting stat functions info */
#define SQL_INSERT_T_FUNCINFO_FORMAT "\
        INSERT INTO \
            statsinfo.t_statfunc ( \
                snapshot_id, \
                dbid, \
                schemaname, \
                funcname, \
                calls, \
                total_time, \
                self_time \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          schemaname, \
                          funcname, \
                          calls, \
                          total_time, \
                          self_time \
                      FROM \
                          pg_stat_user_functions \
                  ') \
              AS ( \
                  schemaname     name, \
                  funcname       name, \
                  calls          bigint, \
                  total_time     bigint, \
                  self_time      bigint \
              );"

#endif


/* INSERT format for getting Table statistical info */
#define SQL_INSERT_T_TABLEINFO_FORMAT "\
        INSERT INTO \
            statsinfo.t_tableinfo ( \
                snapshot_id, \
                dbid, \
                schemaname, \
                table_oid, \
                tablename, \
		relpages, \
		reltuples, \
                n_tup_ins, \
                n_tup_upd, \
                n_tup_del, \
                n_tup_hot_upd, \
                seq_scan, \
                idx_scan, \
                seq_tup_read, \
                idx_tup_fetch, \
                heap_blks_hit, \
                idx_blks_hit, \
                toast_blks_hit, \
                tidx_blks_hit, \
                heap_blks_read, \
                idx_blks_read, \
                toast_blks_read, \
                tidx_blks_read, \
                n_live_tuple, \
                n_dead_tuple, \
                relation_size, \
		last_vacuum, \
		last_autovacuum, \
		last_analyze, \
		last_autoanalyze \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          stat_tbl.schemaname, \
                          stat_tbl.relid, \
                          stat_tbl.relname, \
			  			  class.relpages, \
			  			  class.reltuples, \
                          stat_tbl.n_tup_ins, \
                          stat_tbl.n_tup_upd, \
                          stat_tbl.n_tup_del, \
                          stat_tbl.n_tup_hot_upd, \
                          stat_tbl.seq_scan, \
                          stat_tbl.idx_scan, \
                          stat_tbl.seq_tup_read, \
                          stat_tbl.idx_tup_fetch, \
                          statio_tbl.heap_blks_hit, \
                          statio_tbl.idx_blks_hit, \
                          statio_tbl.toast_blks_hit, \
                          statio_tbl.tidx_blks_hit, \
                          statio_tbl.heap_blks_read, \
                          statio_tbl.idx_blks_read, \
                          statio_tbl.toast_blks_read, \
                          statio_tbl.tidx_blks_read, \
                          stat_tbl.n_live_tup, \
                          stat_tbl.n_dead_tup, \
                          pg_relation_size(stat_tbl.relid), \
			  			  stat_tbl.last_vacuum, \
			  			  stat_tbl.last_autovacuum, \
			  			  stat_tbl.last_analyze, \
			  			  stat_tbl.last_autoanalyze \
                      FROM \
                          pg_stat_user_tables stat_tbl \
                          LEFT JOIN pg_statio_user_tables statio_tbl ON stat_tbl.relid = statio_tbl.relid \
			  			  LEFT JOIN pg_class class ON statio_tbl.relid = class.oid \
                  ') \
              AS ( \
                  schemaname text, \
                  table_oid oid, \
                  tablename text, \
		  		  relpages  bigint, \
		  		  reltuples real, \
                  n_tup_ins bigint, \
                  n_tup_upd bigint, \
                  n_tup_del bigint, \
                  n_tup_hot_upd bigint, \
                  seq_scan bigint, \
                  idx_scan bigint, \
                  seq_tup_read bigint, \
                  idx_tup_fetch bigint, \
                  heap_blks_hit bigint, \
                  idx_blks_hit bigint, \
                  toast_blks_hit bigint, \
                  tidx_blks_hit bigint, \
                  heap_blks_read bigint, \
                  idx_blks_read bigint, \
                  toast_blks_read bigint, \
                  tidx_blks_read bigint, \
                  n_live_tuple bigint, \
                  n_dead_tuple bigint, \
                  relation_size bigint, \
		  		  last_vacuum      timestamp with time zone, \
		  		  last_autovacuum  timestamp with time zone, \
		  		  last_analyze     timestamp with time zone, \
		  		  last_autoanalyze timestamp with time zone \
              	);"

/* INSERT format for getting Index statistical info */
#define SQL_INSERT_T_INDEXINFO_FORMAT "\
        INSERT INTO \
            statsinfo.t_indexinfo ( \
                snapshot_id, \
                dbid, \
                schemaname, \
                index_oid, \
                indexname, \
                tablename, \
                indexdef, \
                cluster_key, \
                index_size, \
                idx_scan, \
                bmp_tup_fetch, \
                idx_tup_fetch, \
                idx_blks_read, \
                idx_blks_hit \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          stat_idx.schemaname, \
                          stat_idx.indexrelid, \
                          stat_idx.indexrelname, \
                          stat_idx.relname, \
                          pg_get_indexdef(idx.indexrelid) as indexdef, \
                          idx.indisclustered as cluster_key, \
                          pg_relation_size(idx.indexrelid), \
                          stat_idx.idx_scan, \
                          (stat_idx.idx_tup_read - stat_idx.idx_tup_fetch) as bmp_tup_fetch, \
                          stat_idx.idx_tup_fetch, \
                          statio_idx.idx_blks_read, \
                          statio_idx.idx_blks_hit \
                      FROM \
                          pg_stat_user_indexes stat_idx, \
                          pg_statio_user_indexes statio_idx, \
                          pg_index idx \
                      WHERE \
                          stat_idx.indexrelid = idx.indexrelid AND \
                          stat_idx.indexrelid = statio_idx.indexrelid \
                  ') \
              AS ( \
                  schemaname text, \
                  index_oid oid, \
                  indexname text, \
                  tablename text, \
                  indexdef text, \
                  cluster_key boolean, \
                  index_size bigint, \
                  idx_scan bigint, \
                  bmp_tup_fetch bigint, \
                  idx_tup_fetch bigint, \
                  idx_blks_read bigint, \
                  idx_blks_hit bigint \
              );"

/* INSERT format for getting Column statistical info */
#define SQL_INSERT_T_COLUMNINFO_FORMAT "\
        INSERT INTO \
            statsinfo.t_columninfo ( \
                snapshot_id, \
                dbid, \
                schemaname, \
                tablename, \
                column_name, \
                n_distinct, \
                correlation \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          nmsp.nspname, \
                          clss.relname, \
                          attr.attname, \
                          stat.n_distinct, \
                          stat.correlation \
                      FROM \
                          pg_namespace nmsp \
                              LEFT JOIN pg_class clss ON (nmsp.oid = clss.relnamespace) \
                              LEFT JOIN pg_attribute attr ON (clss.oid = attr.attrelid) \
                              LEFT JOIN pg_stats stat ON (nmsp.nspname = stat.schemaname AND \
                      		  clss.relname = stat.tablename AND attr.attname = stat.attname) \
                      WHERE \
                          attr.attnum > 0  AND nmsp.nspname NOT IN (''pg_catalog'', ''information_schema'') \
                  ') \
              AS ( \
                  schemaname text, \
                  tablename text, \
                  column_name text, \
                  n_distinct real, \
                  correlation real \
              );"

/* INSERT format for getting filtered autovacuum info */
#define SQL_INSERT_T_AUTOVACUUMINFO_FORMAT "\
        INSERT INTO \
            statsinfo.t_autovacuuminfo ( \
                snapshot_id, \
                dbid, \
                autovacuum_act_time, \
                autovacuum_table, \
                autovacuum_num_page_remove, \
                autovacuum_num_page_remain, \
                autovacuum_num_tup_remove, \
                autovacuum_num_tup_remain, \
                autovacuum_duration \
            ) SELECT \
                  $1, \
                  $2, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          * \
                      FROM \
                          targetdb.stats_autovacuuminfo() \
                      GROUP BY \
                          autovacuum_act_time, \
                          autovacuum_table, \
                          autovacuum_num_page_remove, \
                          autovacuum_num_page_remain, \
                          autovacuum_num_tup_remove, \
                          autovacuum_num_tup_remain, \
                          autovacuum_duration \
                  ') \
              AS ( \
                  autovacuum_act_time timestamp with time zone, \
                  autovacuum_table text, \
                  autovacuum_num_page_remove bigint, \
                  autovacuum_num_page_remain bigint, \
                  autovacuum_num_tup_remove bigint, \
                  autovacuum_num_tup_remain bigint, \
                  autovacuum_duration real \
              );"

/*
 * List of SQL getting info about each DBs.
 *   - If you add new SQL, please update this list and SQL_LIST_FOR_DBINFO_SIZE too.
 */
const char *SQL_LIST_FOR_INSERT_INTO_DBINFO[] =
{
    SQL_INSERT_T_DBSETTING_FORMAT,
    SQL_INSERT_T_TABLEFILL_FORMAT,
    SQL_INSERT_T_COLUMNCORR_FORMAT,
#if PG_VERSION_NUM >= 80400
	SQL_INSERT_T_FUNCINFO_FORMAT,
#endif
    SQL_INSERT_T_TABLEINFO_FORMAT,
    SQL_INSERT_T_INDEXINFO_FORMAT,
    SQL_INSERT_T_COLUMNINFO_FORMAT,
    SQL_INSERT_T_AUTOVACUUMINFO_FORMAT
};
#if PG_VERSION_NUM >= 80400
#define SQL_LIST_FOR_INSERT_INTO_DBINFO_SIZE   8
#else
#define SQL_LIST_FOR_INSERT_INTO_DBINFO_SIZE   7
#endif

/*************************************************************
 * getting and storing SQL for each host snapshot
 *
 * If you add new SQL, please update SQL_LIST_FOR_HOSTINFO too.
 ************************************************************/

/* INSERT format for getting host_snapshot id */
#define SQL_INSERT_T_HOSTINFO_FORMAT "\
        INSERT INTO \
            statsinfo.t_hostinfo ( \
                host_snapshot_date, \
                host_id, \
                kernel_version, \
                processors, \
                mem_total, \
                swap_total, \
                pg_version, \
                maxwritten_clean \
            ) SELECT \
                date_trunc('seconds', now()), \
                $1, \
                * \
              FROM \
                  dblink(' \
                      SELECT \
                          stats.*, \
                          version(), \
                          bgwriter.maxwritten_clean \
                      FROM \
                          targetdb.stats_hostinfo() stats, \
                          pg_stat_bgwriter bgwriter \
                  ') \
              AS (\
                  kernel_version text, \
                  processors bigint, \
                  mem_total bigint, \
                  swap_total bigint, \
                  setting text, \
                  maxwritten_clean int \
              ) \
        RETURNING \
            host_snapshot_id;"

/* INSERT format for getting checkpoint statistical info */
#define SQL_INSERT_T_CHECKPOINTINFO_FORMAT "\
        INSERT INTO \
            statsinfo.t_checkpointinfo ( \
                host_snapshot_id, \
                checkpoint_act_time, \
                checkpoint_start_trig, \
                checkpoint_num_buffers, \
                checkpoint_create_wal, \
                checkpoint_delete_wal, \
                checkpoint_recycle_wal, \
                checkpoint_write_duration, \
                checkpoint_sync_duration, \
                checkpoint_total_duration \
            ) SELECT \
                  $1, \
                  * \
              FROM \
                  dblink(' \
                      SELECT \
                          * \
                      FROM \
                          targetdb.stats_checkpointinfo() \
                      GROUP BY \
                          checkpoint_act_time, \
                          checkpoint_start_trig, \
                          checkpoint_num_buffers, \
                          checkpoint_create_wal, \
                          checkpoint_delete_wal, \
                          checkpoint_recycle_wal, \
                          checkpoint_write_duration, \
                          checkpoint_sync_duration, \
                          checkpoint_total_duration \
                  ') \
              AS (\
                  checkpoint_act_time timestamp with time zone, \
                  checkpoint_start_trig text, \
                  checkpoint_num_buffers bigint, \
                  checkpoint_create_wal bigint, \
                  checkpoint_delete_wal bigint, \
                  checkpoint_recycle_wal bigint, \
                  checkpoint_write_duration real, \
                  checkpoint_sync_duration real, \
                  checkpoint_total_duration real \
              );"


/* INSERT format for getting long-transaction info */
/* -- Now we identify "continuing SQL over 1 min" as long-transaction */
#define SQL_INSERT_T_HOSTACTIVITY_FORMAT "\
		INSERT INTO \
			statsinfo.t_hostactivity ( \
				host_snapshot_id, \
				dbname, \
				procpid, \
				usename, \
				client_addr, \
				waiting, \
				duration, \
				check_time, \
				backend_start, \
				current_query \
			) SELECT \
				$1, \
				* \
			  FROM \
				  dblink(' \
					  SELECT \
						  datname AS dbname, \
						  procpid, \
						  usename, \
						  client_addr, \
						  waiting, \
						  (current_timestamp - xact_start)::interval(0) AS duration, \
						  current_timestamp::timestamp(0) with time zone AS check_time, \
						  backend_start::timestamp(0) with time zone, \
						  current_query \
					  FROM \
						  pg_stat_activity \
					  WHERE \
						  procpid <> pg_backend_pid() AND \
						  (current_timestamp - xact_start)::interval(0) > ''00:01:00'' \
				  ') \
			  AS (\
				  dbname         text, \
				  procpid        int,  \
				  usename        text,  \
				  client_addr    inet,  \
				  waiting        boolean, \
				  duration       interval(0), \
				  check_time     timestamp(0) with time zone, \
				  backend_start  timestamp(0) with time zone, \
				  current_query  text \
			  );"

/* INSERT format for getting device-usage info */
#define SQL_INSERT_T_FS_SIZE_FORMAT "\
		INSERT INTO  \
			statsinfo.t_fs_size ( \
				host_snapshot_id, \
				tblspc_oid, \
				name, \
				device_id, \
				device_name, \
				location, \
				used, \
				avail, \
				total \
			) SELECT \
				$1, \
				* \
			  FROM \
				  dblink(' \
					SELECT \
						oid AS tblspc_oid, \
						name, \
						device_id, \
						device_name, \
						location, \
						used, \
						avail, \
						total \
					FROM \
						targetdb.pg_filesystem_size \
				  ') \
			  AS (\
				  tblspc      oid, \
				  name        text, \
				  device_id   int, \
				  device_name text, \
				  location    text, \
				  used        bigint, \
				  avail       bigint, \
				  total       bigint \
			  );"

#if PG_VERSION_NUM >= 80400

/* INSERT format dfor getting stat_statement */
#define SQL_INSERT_T_STATSTATEMENTS_FORMAT "\
		INSERT INTO \
			statsinfo.t_statstatements (\
				host_snapshot_id, \
				usename, \
				datname, \
				query, \
				calls, \
				total_time, \
				rows \
			) SELECT \
				$1, \
				* \
			  FROM \
				dblink(' \
					SELECT \
						u.usename, \
						  CASE WHEN d.datname IS NULL THEN '' NON EXISTENT'' \
						  ELSE d.datname \
						  END as datname, \
						s.query, \
						s.calls, \
						s.total_time, \
						s.rows \
					FROM \
						pg_stat_statements s \
						LEFT OUTER JOIN pg_user u ON s.userid = u.usesysid \
						LEFT OUTER JOIN pg_database d ON s.dbid = d.oid \
					ORDER BY s.total_time DESC LIMIT 50 \
					') \
			AS (\
					usename	     name, \
					datname      name, \
					query        text, \
					calls        bigint, \
					total_time   double precision, \
					rows         bigint \
			);"	

#endif
				
/*
 * List of SQL getting info about each hosts.
 */
const char *SQL_LIST_FOR_HOSTINFO[] =
{
    SQL_INSERT_T_CHECKPOINTINFO_FORMAT,
    SQL_INSERT_T_HOSTACTIVITY_FORMAT,
#if PG_VERSION_NUM >= 80400
	SQL_INSERT_T_FS_SIZE_FORMAT,
	SQL_INSERT_T_STATSTATEMENTS_FORMAT
#else
	SQL_INSERT_T_FS_SIZE_FORMAT
#endif
};

#endif   /* STATS_INFO_SQL_H */
