/***************************************************************************
 *  Copyright (C) 2009 Nippon Telegraph and Telephone Corporation
 ***************************************************************************/
/**
 * @file    stats_info_message.h
 * @brief   messages in stored procedure for using snapshot-management
 *
 */

#ifndef STATS_INFO_MESSAGE_H
#define STATS_INFO_MESSAGE_H

/* Starting message */
#define MSG_STATS_INFO_0001  "%s: start to collect snapshot info."

/* Error Messages */
/*
 * Error messages on gettign snapshot about each DBs.
 *
 * If you add new SQL for getting new infomation, add error message and 
 * update MSG_LIST_FOR_INSERT_INTO_DBINFO too.
 */
#define MSG_STATS_INFO_1001  "%s: failed on registing snapshot info."
#define MSG_STATS_INFO_1002  "%s: failed on getting database basic info (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_1003  "%s: failed on getting database setting info (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_1004  "%s: failed on getting table info (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_1005  "%s: failed on getting index info (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_1006  "%s: failed on getting column info (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_1007  "%s: failed on getting autovacuum info (hostname=%s, port=%d, dbname=%s)"

/*
 * List of error messages for getting snapshot about each DBs.
 *   - Please add message-define-number if you add new error message above.
 *
 */
const char *MSG_LIST_FOR_INSERT_INTO_DBINFO[] =
{
    MSG_STATS_INFO_1003,
    MSG_STATS_INFO_1004,
    MSG_STATS_INFO_1005,
    MSG_STATS_INFO_1006,
    MSG_STATS_INFO_1007
};

/*
 * Error messages on gettign snapshot about each hosts.
 *
 * If you add new SQL for getting new infomation, add error message and
 * update MSG_LIST_FOR_INSERT_INTO_HOSTINFO too.
 */
#define MSG_STATS_INFO_1100  "%s: failed on registing host info (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_1101  "%s: failed on getting checkpoint info (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_1102  "%s: failed on getting hostactivity info (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_1103  "%s: failed on getting fs_size info (hostname=%s, port=%d, dbname=%s)"

/*
 * List of error messages for getting snapshot about each hosts.
*   - Please add message-define-number if you add new error message above.
 */
const char *MSG_LIST_FOR_INSERT_INTO_HOSTINFO[] =
{
    MSG_STATS_INFO_1101,
    MSG_STATS_INFO_1102,
    MSG_STATS_INFO_1103
};

/* Error messages on internal processes */
#define MSG_STATS_INFO_2000  "%s: failed on connecting to target database (hostname=%s, port=%d, dbname=%s)"
#define MSG_STATS_INFO_2001  "%s: SPI_connect failed (return code:%d)"
#define MSG_STATS_INFO_2002  "%s: no appropriate connect info to be specified DBID (%ld)"
#define MSG_STATS_INFO_2003  "%s: must be database superuser to perform"
#define MSG_STATS_INFO_2004  "%s: SPI_prepare failed (return code:%d, query:%s)"
#define MSG_STATS_INFO_2005  "%s: SPI_execute_plan failed (return code:%d, expected:%d)"

#endif   /* STATS_INFO_MESSAGE_H */

