#!/bin/sh

#############
## Purpose ##
#############

# Generates configure.in, Makefile.in and config.h.in from configure.ac.
# Makefile.am files and configure.ac must exist.

#############
## Options ##
#############

# Additional directory to look for m4 files
ADDITIONAL_M4_DIR="./" # "/usr/local/share/aclocal"

# Directories to explore (depth = 1 & no '/' otherwise it will not work)
# Relative to the project directory
DIRECTORIES=( "." "lib" "src" "test" )

##################
## Main program ##
##################

echo "Runs autotools. Generates configure.in, Makefile.in and config.h.in."
echo "Usage: $0"
echo ""

THISDIR=`dirname $0`
PREVDIR="$PWD"

echo -n "cd $THISDIR... "
cd "$THISDIR"
echo "done"
echo ""

for dir in ${DIRECTORIES[@]}
do
	echo "Entering $dir"
	cd "$dir"

	if test -d "$ADDITIONAL_M4_DIR" # Test whether the optional m4 directory exists
	then
		echo "+ aclocal -I $ADDITIONAL_M4_DIR"
		aclocal -I "$ADDITIONAL_M4_DIR"
	else
		echo "+ aclocal"
		aclocal
	fi
	
	echo "+ autoheader"
	autoheader
	
	echo "+ automake -a -c"
	automake -a -c
	
	echo "+ autoconf"
	autoconf
	
	echo "Leaving $dir"
	cd -
	echo ""
done

echo -n "cd $PREVDIR... "
cd "$PREVDIR"
echo "done"
